<?php
/**
 * @name		Template Creator CK 3
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

class TCK_WidgetAnimations {

	private $name = 'animations';

	private $imagespath;

	public function __construct() {
		$this->imagespath = TEMPLATECREATORCK_MEDIA_URL . '/images/interface';
	}

	public function loadWidget() {
		?>
		<script src="<?php echo TEMPLATECREATORCK_MEDIA_URL ?>/widgets/animations/interface.js" type="text/javascript"></script>
		<?php
	}

	public function renderFrontendWidget($templatepath, $templatename, $data) {
		require_once(TEMPLATECREATORCK_PATH . '/helpers/ckwidgets.php');
		TCK_Folder::create(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename . '/js');
		TCK_File::copy(TEMPLATECREATORCK_PATH . '/widgets/animations/animations.js', TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename . '/js/animations.js');
		$blocs = CKWidgets::parseWidgetData($data);
		if (empty($blocs)) return;

		$jsCalls = array();
		$jcssCalls = array();
		foreach ($blocs as $bloc) {
			$jsCalls[] = "TCK_Animations('#" . $bloc->{'data-id'} . "', {"
					. "replay : '" . $bloc->{'data-animreplay'} . "'"
					. "});";
			$jcssCalls[] = $this->genCssAnimations($bloc);
		}
		$jsCalls = implode(' ', $jsCalls);
		$widget = array();
		$widget['php'] = '';
		$widget['script'] = '<script src="' . $templatepath . '/js/animations.js" type="text/javascript" ></script>';
		$widget['scriptDeclaration'] = 'jQuery(document).ready(function(){ ' . $jsCalls . ' });';
		$widget['stylesheet'] = '';
		$widget['styleDeclaration'] = "\t" . implode("\n\t\t", $jcssCalls);
		$widget['jquery'] = true;

		return $widget;
	}

	/*
	 * Needed function
	 */
	public function onAfterInstall() {
		
	}

	public function listOptions() {
		$input = new TCK_Input();
		$blocsList = $input->get('blocsList', '', 'string');
		$blocsList = json_decode(stripslashes($blocsList));

		$this->showInfos();
		$this->renderTopBar();
		foreach ($blocsList as $bloc) {
			$this->renderBlocOptions($bloc);
		}

		$this->renderCss();
		exit();
	}

	private function showInfos() {
		?>
		<p><?php echo TCK_Text::_('CK_WIDGET_ANIMATIONS_INFOS') ?></p>
		<?php
	}

	private function renderTopBar() {
		?>
		<div class="widgettopbar">
			<div class="widgettopbarfilter"><?php echo TCK_Text::_('CK_FILTER_BY') ?> : </div>
			<div class="ckbutton" data-type="wrapper" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_WRAPPER') ?></div>
			<div class="ckbutton" data-type="row" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_ROW') ?></div>
			<div class="ckbutton" data-type="flexiblemodules" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_FLEXIBLES_MODULES') ?></div>
			<div class="ckbutton" data-type="singlemodule" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_SINGLE_MODULE') ?></div>
			<div class="ckbutton" data-type="horiznav" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_HORIZ_MENU') ?></div>
			<div class="ckbutton" data-type="activeonly" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_ACTIVE_ONLY') ?></div>
			<div class="ckbutton" data-type="all" onclick="TCK_WidgetAnimationsFilterByType(this)"><?php echo TCK_Text::_('CK_ALL') ?></div>
			<input id="widgettopbarfilter" class="inputbox" type="text" style="width: 150px;height:22px;" />
			<span class="fack fack-search ckbutton" style="height:18px;line-height:18px;" onclick="TCK_WidgetAnimationsFilterByType('search')">&nbsp;</span>
			<hr />
			<div>
				<span style="display:inline-block;width: 165px;font-weight: bold;"><?php echo TCK_Text::_('CK_BLOCK') ?></span>
				<span style="display:inline-block;width: 65px;font-weight: bold;"><?php echo TCK_Text::_('CK_STATE') ?></span>
			</div>
			<p></p>
		</div>
		<?php
	}
	
	private function renderBlocOptions($bloc) {
		$prefix = $bloc->id;
		$stateClass = $bloc->enabled ? 'success' : 'danger';
		$stateText = $bloc->enabled ? 'ON' : 'OFF';
	?>
	
		<div class="datarow widgetrow widgetanimations" style="text-align:left;" data-type="<?php echo $bloc->class ?>" data-id="<?php echo $bloc->id ?>" data-enabled="<?php echo $bloc->enabled ?>">
			<span style="display:inline-block;width: 150px;" class=""><?php echo $bloc->id ?></span>
			<span style="display:inline-block;width: 50px;" class="animationstoggler ckbutton ckbutton-small ckbutton-<?php echo $stateClass ?>" onclick="TCK_WidgetAnimationsToggle(this)" data-state="<?php echo $bloc->enabled ?>"><?php echo $stateText ?></span>
			<div>
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animdur"><?php echo TCK_Text::_('CK_DURATION'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/hourglass.png" />
					<input placeholder="1" class="inputbox <?php echo $prefix; ?> animdur" type="text" name="<?php echo $prefix; ?>animdur" id="<?php echo $prefix; ?>animdur" value="<?php echo $bloc->animdur ?>" style="width:40px;" /> [s]
				</div>
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animdelay"><?php echo TCK_Text::_('CK_DELAY'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/hourglass.png" />
					<input placeholder="0" class="inputbox <?php echo $prefix; ?> animdelay" type="text" name="<?php echo $prefix; ?>animdelay" id="<?php echo $prefix; ?>animdelay" value="<?php echo $bloc->animdelay ?>" style="width:40px;" /> [s]
				</div>
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animfade"><?php echo TCK_Text::_('CK_FADE'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/shading.png" />
					<select class="inputbox <?php echo $prefix; ?> animfade" type="list" name="<?php echo $prefix; ?>animfade" id="<?php echo $prefix; ?>animfade" value="" style="width: 100px;" >
						<option value="0" <?php echo ($bloc->animfade == '0' ? 'selected' : '') ?>><?php echo TCK_Text::_('JNO'); ?></option>
						<option value="1" <?php echo ($bloc->animfade == '1' ? 'selected' : '') ?>><?php echo TCK_Text::_('JYES'); ?></option>
					</select>
				</div>
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animmove"><?php echo TCK_Text::_('CK_MOVE'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/shape_square_go.png" />
					<select class="inputbox <?php echo $prefix; ?> animmove" type="list" name="<?php echo $prefix; ?>animmove" id="<?php echo $prefix; ?>animmove" value="" style="width: 100px;" >
						<option value="0" <?php echo $this->isSelected($bloc->animmove, '0') ?>><?php echo TCK_Text::_('JNO'); ?></option>
						<option value="1" <?php echo $this->isSelected($bloc->animmove, '1') ?>><?php echo TCK_Text::_('JYES'); ?></option>
					</select>
					<select class="inputbox <?php echo $prefix; ?> animmovedir hasTip" title="<?php echo TCK_Text::_('CK_DIRECTION'); ?>" type="list" name="<?php echo $prefix; ?>animmovedir" id="<?php echo $prefix; ?>animmovedir" value="" style="width: 100px;" >
						<option value="ltrck" <?php echo ($bloc->animmovedir == 'ltrck' ? 'selected' : '') ?>><?php echo TCK_Text::_('CK_LEFT_TO_RIGHT'); ?></option>
						<option value="rtlck" <?php echo ($bloc->animmovedir == 'rtlck' ? 'selected' : '') ?>><?php echo TCK_Text::_('CK_RIGHT_TO_LEFT'); ?></option>
						<option value="ttbck" <?php echo ($bloc->animmovedir == 'ttbck' ? 'selected' : '') ?>><?php echo TCK_Text::_('CK_TOP_TO_BOTTOM'); ?></option>
						<option value="bttck" <?php echo ($bloc->animmovedir == 'bttck' ? 'selected' : '') ?>><?php echo TCK_Text::_('CK_BOTTOM_TO_TOP'); ?></option>
					</select>
					<input class="inputbox <?php echo $prefix; ?> animmovedist hasTip" title="<?php echo TCK_Text::_('CK_DISTANCE'); ?>" type="text" name="<?php echo $prefix; ?>animmovedist" id="<?php echo $prefix; ?>animmovedist" value="<?php echo $bloc->animmovedist ?>" style="width:40px;" /> [px/%]
				</div>
				
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animrot"><?php echo TCK_Text::_('CK_ROTATE'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/shape_rotate_clockwise.png" />
					<select class="inputbox <?php echo $prefix; ?> animrot" type="list" name="<?php echo $prefix; ?>animrot" id="<?php echo $prefix; ?>animrot" value="" style="width: 100px;" >
						<option value="0" <?php echo $this->isSelected($bloc->animrot, '0') ?>><?php echo TCK_Text::_('JNO'); ?></option>
						<option value="1" <?php echo $this->isSelected($bloc->animrot, '1') ?>><?php echo TCK_Text::_('JYES'); ?></option>
					</select>
					<select class="inputbox <?php echo $prefix; ?> animrotrad" type="list" name="<?php echo $prefix; ?>animrotrad" id="<?php echo $prefix; ?>animrotrad" value="" style="width: 100px;" >
						<option value="45" <?php echo ($bloc->animrotrad == '45' ? 'selected' : '') ?>>45°</option>
						<option value="90" <?php echo ($bloc->animrotrad == '90' ? 'selected' : '') ?>>90°</option>
						<option value="180" <?php echo ($bloc->animrotrad == '180' ? 'selected' : '') ?>>180°</option>
						<option value="270" <?php echo ($bloc->animrotrad == '270' ? 'selected' : '') ?>>270°</option>
						<option value="360" <?php echo ($bloc->animrotrad == '360' ? 'selected' : '') ?>>360°</option>
					</select>
				</div>
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animscale"><?php echo TCK_Text::_('CK_SCALE'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/shape_handles.png" />
					<select class="inputbox <?php echo $prefix; ?> animscale" type="list" name="<?php echo $prefix; ?>animscale" id="<?php echo $prefix; ?>animscale" value="" style="width:100px;" >
						<option value="0" <?php echo $this->isSelected($bloc->animscale, '0') ?>><?php echo TCK_Text::_('JNO'); ?></option>
						<option value="1" <?php echo $this->isSelected($bloc->animscale, '1') ?>><?php echo TCK_Text::_('JYES'); ?></option>
					</select>
				</div>
				<div class="ckrow">
					<label for="<?php echo $prefix; ?>animreplay"><?php echo TCK_Text::_('CK_REPLAY_ANIMATION'); ?></label>
					<img class="ckicon" src="<?php echo $this->imagespath ?>/control_repeat.png" />
					<select class="inputbox <?php echo $prefix; ?> animreplay" type="list" name="<?php echo $prefix; ?>animreplay" id="<?php echo $prefix; ?>animreplay" value="" style="width:100px;" >
						<option value="0" <?php echo $this->isSelected($bloc->animreplay, '0') ?>><?php echo TCK_Text::_('JNO'); ?></option>
						<option value="1" <?php echo $this->isSelected($bloc->animreplay, '1') ?>><?php echo TCK_Text::_('JYES'); ?></option>
					</select>
				</div>
			</div>
			<div class="clr"></div>
		
		
		
		
		</div>
	<?php
	}
	
	private function renderCss() {
		?>
		<style>
			.animationstoggler + * {
				display: none;
			}

			.widgetanimations .ckicon {
				margin-bottom: 2px;
				vertical-align: middle;
			}

			.animationstoggler.ckbutton-success + * {
				display: block;
			}
			
			.animationstoggler.ckbutton-success + * .ckrow {
				display: inline-block;
				padding: 5px;
				margin: 5px;
				border: 1px solid #ccc;
			}

			.widgetanimations label {
				display: block;
			}
		</style>
		<?php
	}

	private function isSelected($ref, $option) {
		if ($ref == $option) return ' selected="selected"';
		return '';
	}

	/**
	* Set the CSS3 animations for the blocks
	*/
	private function genCssAnimations($bloc) {
		if (! isset($bloc->{'data-animfade'})) return; // if no animation field is found, nothing to do here

		// fade, move, rotate, scale, flip?rotateY, replay
		$css = '';
		$transition = Array(); // transition: opacity 0.4s;transition: opacity 0.2s, transform 0.35s;
		$transform0 = Array(); // transform: rotate(45deg);transform: translate3d(0,40px,0);
		$transform100 = Array(); // transform: rotate(45deg);transform: translate3d(0,40px,0);
		$style0 = Array();
		$style100 = Array();
		$duration = isset($bloc->{'data-animdur'}) && $bloc->{'data-animdur'} ? $bloc->{'data-animdur'} . 's' : '1s';
		$delay = isset($bloc->{'data-animdelay'}) && $bloc->{'data-animdelay'} ? $bloc->{'data-animdelay'} . 's' : '0s';
		// fade effect
		if ($bloc->{'data-animfade'} == '1') {
			$transition['fade'] = 'opacity ' . $duration;
			$style0[] = 'opacity: 0';
			$style100[] = 'opacity: 1';
		}
		// move effect
		if ($bloc->{'data-animmove'} == '1') {
			$transition['transform'] = 'transform ' . $duration;
			switch($bloc->{'data-animmovedir'}) {
				case 'ltrck':
				default:
					$transform0[] = 'translate3d(-' . TemplateckHelper::testUnit($bloc->{'data-animmovedist'}) . ',0,0)';
				break;
				case 'rtlck':
					$transform0[] = 'translate3d(' . TemplateckHelper::testUnit($bloc->{'data-animmovedist'}) . ',0,0)';
				break;
				case 'ttbck':
					$transform0[] = 'translate3d(0,-' . TemplateckHelper::testUnit($bloc->{'data-animmovedist'}) . ',0)';
				break;
				case 'bttck':
					$transform0[] = 'translate3d(0,' . TemplateckHelper::testUnit($bloc->{'data-animmovedist'}) . ',0)';
				break;
			}

			$transform100[] = 'translate3d(0,0,0)';
		}
		// rotate effect
		if ($bloc->{'data-animrot'} == '1') {
			$transition['transform'] = (isset($transition['transform']) && $transition['transform']) ? $transition['transform'] : 'transform ' . $duration;
			$transform0[] = 'rotate(' . $bloc->{'data-animrotrad'} . 'deg)';
			$transform100[] = 'rotate(0deg)';
		}
		// scale effect
		if ($bloc->{'data-animscale'} == '1') {
			$transition['transform'] = (isset($transition['transform']) && $transition['transform']) ? $transition['transform'] : 'transform ' . $duration;
			$transform0[] = 'scale(0)';
			$transform100[] = 'scale(1)';
		}

		if (count($transition)) {
			// start
			$css .= '#' . $bloc->{'data-id'} . ' {
				-webkit-transition: ' . implode(', ', $transition) . ';
				transition: ' . implode(', ', $transition) . ';
				' . (count($transform0) ? '-webkit-transform: ' . implode(' ', $transform0) . ';
				transform: ' . implode(' ', $transform0) . ';' : '') . '
				' . implode(';', $style0) . ';
				 -webkit-transition-delay: ' . $delay . ';
				transition-delay: ' . $delay . ';
			}
			';
			// end
			$css .= '#' . $bloc->{'data-id'} . '.animateck {
				' . (count($transform0) ? '-webkit-transform: ' . implode(' ', $transform100) . ';
				transform: ' . implode(' ', $transform100) . ';' : '') . '
				' . implode(';', $style100) . ';
			}';
		}

		return $css;
	}
}
