<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

use Templatecreatorck\CKFof;

\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');
CKFof::addStyleSheet('components/com_templateck/assets/admin.css');
CKFof::addStyleSheet('components/com_templateck/assets/ckframework.css');
$extensionsck = array(
	'maximenuck' => 'https://www.joomlack.fr/en/joomla-extensions/maximenu-ck'
	,'slideshowck' => 'https://www.joomlack.fr/en/joomla-extensions/slideshow-ck'
	,'pagebuilderck' => 'https://www.joomlack.fr/en/joomla-extensions/page-builder-ck'
	,'carouselck' => 'https://www.joomlack.fr/en/joomla-extensions/carousel-ck'
);
?>
<h3><?php echo TCK_Text::_('CK_IMPORT_DATA') ?></h3>
<p><?php echo TCK_Text::_('CK_SELECT_DATA_TO_INSTALL') ?></p>
<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_templateck&task=template.importQuickData'); ?>" method="post" name="adminForm" id="adminForm">
<table class="cktable cktable-bordered">
	<thead>
		<tr>
			<th><?php echo TCK_Text::_('CK_TITLE') ?></th>
			<th><?php echo TCK_Text::_('CK_TYPE') ?></th>
			<th><?php echo TCK_Text::_('CK_POSITION') ?></th>
			<th><label class="ckbutton"><input type="checkbox" name="selectedimportall"/><?php echo TCK_Text::_('CK_SELECT_ALL') ?></label></th>
		</tr>
	</head>
	<tbody>
	<?php
	foreach ($this->modules as $i => $module) {
		$extension = str_replace('mod_', '', $module->module);
		$infourl = isset($extensionsck[$extension]) ? $extensionsck[$extension] : '';
		?>
		<tr>
			<td><?php echo $module->title ?></td>
			<td><?php echo $module->module ?></td>
			<td><span class="ckbadge"><?php echo $module->position ?></span></td>
			<td><?php if ($module->installed) { ?>
				<label class="ckbutton"><input type="checkbox"  name="modules[<?php echo $i ?>][selectedimport]"/><?php echo TCK_Text::_('CK_SELECT') ?></label>
				<?php } else {
					echo '<span class="ckbadge ckbadge-warning">' . TCK_Text::_('CK_NOT_INSTALLED') . '</span>';
					echo '<p>' . TCK_Text::_('CK_GET_MORE_INFOS');
					echo '<br/><a target="_blank" href="' . $infourl . '">' . $infourl . '</a></p>';
				}?>
			</td>
			<input type="hidden" name="modules[<?php echo $i ?>][settings]" value="<?php echo htmlspecialchars(serialize($module)) ?>" />
		</tr>
		<?php
	}
	?>
	</tbody>
</table>
<div style="text-align:center;">
	<a href="javascript:void(0)" onclick="ckSubmitInstallData()" class="ckbutton"><?php echo TCK_Text::_('CK_INSTALL_DEMO_DATA') ?></a>
	<a class="" href="javascript:void(0)" onclick="window.parent.CKBox.close()"><?php echo TCK_Text::_('CK_DONT_INSTALL_DEMO_DATA') ?></a>
</div>
</form>
<script>
jQuery('input[name="selectedimportall"]').change (function () {
  jQuery('input:checkbox[name*="selectedimport"]').prop('checked', this.checked);
});

function ckSubmitInstallData() {
	if (! jQuery('input:checkbox[name*="selectedimport"]:checked').length) {
		alert("<?php echo TCK_Text::_('CK_PLEASE_SELECT') ?>");
		return;
	}
	var form = document.getElementById('adminForm');
	form.submit();
}
</script>
<?php

