<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
require_once(TEMPLATECREATORCK_PATH . '/helpers/ckwidgets.php');

// get the list of widgets
$widgets = CKWidgets::loadWidgets();

?>
<div class="cktitle"><?php echo TCK_Text::_('CK_WIDGETSMANAGER'); ?></div>
<table>
	<tr>
		<td style="vertical-align:top;">
			<div class="ckpopupinfos">
				<div class="ckpopupinfostitle"><?php echo TCK_Text::_('CK_WIDGETSMANAGER_INFOS'); ?></div>
				<div class="ckpopupinfosdesc"><?php echo TCK_Text::_('CK_WIDGETSMANAGER_DESC'); ?></div>
			</div>
		</td>
		<td style="vertical-align:top;">
			<div id="ckelementscontainer" class="ckinterface" style="margin-top: 8px;">
				<div id="widgetsmanager">
					<?php foreach ($widgets as $widget) { 
					switch($widget->type) {
						case 'widget' :
						default :
							$label = 'info';
							break;
						case 'plugin' :
							$label = 'warning';
							break;
					}
					?>
					<div class="widgetrow clearfix" data-installed="<?php echo $widget->installed ?>" data-name="<?php echo $widget->name ?>" data-url="<?php echo $widget->url ?>" data-type="<?php echo $widget->type ?>" data-enabled="">
						<span class="widgettitledesc">
							<div class="widgettitle"><?php echo $widget->title; ?>&nbsp;<span class="cklabel cklabel-<?php echo $label ?>"><?php echo $widget->type ?></span></div>
							<div class="widgetdescription"><?php echo $widget->description; ?></div>
							<div><?php if (isset($widget->phpClass->pluginUrl) && $widget->type == 'plugin' && $widget->phpClass->pluginUrl) {
								$c = new $widget->phpClass();

								if (method_exists($c, 'isInstalled')) {
									$installed = $c->isInstalled();
								} else {
									$installed = true;
								}

								if (! $installed) {
								?>
								<span class="cklabel cklabel-important"><?php echo TCK_Text::_('CK_PLUGIN_NOT_INSTALLED') ?></span> <b><?php echo TCK_Text::_('CK_MANUAL_INSTALLATION') ?> :</b><br/>
								<a class="ckbutton" href="<?php echo $widget->phpClass->pluginUrl ?>" target="_blank"><span class="fack fack-download"></span> <?php echo TCK_Text::_('CK_DOWNLOAD_PLUGIN') ?></a>
								<span><a href="https://www.template-creator.com/documentation/widgets/manual-installation" target="_blank"><?php echo TCK_Text::_('CK_READ_DOCUMENTATION') ?></a></span>
								<?php
								}
							} ?>
							</div>
						</span>
						<span class="widgetactions">
							<span class="widgetinstall ckbutton" onclick="ckInstallWidget(this)"><span class="fack fack-download"></span> <?php echo TCK_Text::_('CK_INSTALL'); ?></span>
							<span class="widgetupdate ckbutton" onclick="ckInstallWidget(this, true)"><span class="fack fack-refresh"></span> <?php echo TCK_Text::_('CK_UPDATE'); ?></span>
							<span class="widgetdisable ckbutton ckhastip" onclick="ckDisableWidget(this)" title="<?php echo TCK_Text::_('CK_ENABLED'); ?>"><span class="fack fack-check"></span> </span>
							<span class="widgetenable ckbutton ckhastip" onclick="ckEnableWidget(this)" title="<?php echo TCK_Text::_('CK_DISABLED'); ?>"><span class="fack fack-times-circle"></span> </span>
							<?php if ($widget->edition) { ?>
							<span class="widgetedit ckbutton" onclick="ckEditWidget(this)"><span class="fack fack-edit"></span> <?php echo TCK_Text::_('CK_EDIT'); ?></span>
							<?php } ?>
						</span>
					</div>
					<?php } ?>
					<div class="clr"></div>
					<p></p>
					<div id="widgetsdownload">
						<hr style="margin: 20px 0;" />
						<div class="cktitle"><?php echo TCK_Text::_('CK_WIDGET_MANUAL_DOWNLOAD'); ?></div>
						<div><?php echo TCK_Text::_('CK_WIDGET_MANUAL_DOWNLOAD_DESC'); ?></div>
						<?php foreach ($widgets as $widget) { 
						?>
							<a class="ckbutton" href="<?php echo $widget->url ?>" target="_blank"><span class="fack fack-download"></span> <?php echo $widget->title ?></a>
						<?php
						}?>
						<p></p>
						<div>
							<input type="file" id="tck_file_upload" />
							<div class="ckbutton" id="ckInstallWidgetManualButton"><?php echo TCK_Text::_('CK_INSTALL'); ?></div>
						</div>
					</div>
					<p style="margin: 20px 0;"></p>
				</div>
				
				<div id="widgetedition">
				</div>
				<div class="clr"></div>
			</div>
		</td>
	</tr>
</table>
<script language="javascript" type="text/javascript">
	$ck('#ckInstallWidgetManualButton').click(function() {
		ckInstallWidgetManually();
	});
</script>