<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
$input = new TCK_Input();
$fontslist = $input->get('fontslist', '', 'string');
$fontsarray = array_filter(explode(',', $fontslist));

?>
<div id="ckgfontsmanager">
	<h3><?php echo TCK_Text::_('CK_FONTS_MANAGER') ?></h3>
	<p><?php echo TCK_Text::_('CK_FONTS_MANAGER_DESC') ?></p>
	<table style="width: 100%;vertical-align: middle;" class="ckedition cktable cktable-striped cktable-bordered cktable-hover">
	<?php
	// for ($i=1;$i<=5;$i++) {
	if (count($fontsarray) == 0) {
		?>
		<p class="ckalert"><?php echo TCK_Text::_('CK_NO_GOOGLE_FONT_FOUND_IN_PAGE') ?></p>
		<?php
	} else {
		foreach ($fontsarray as $font) {
			?>
			<tr data-font="<?php echo $font ?>">
				<td style="width:50%;font-family:'<?php echo $font ?>';"><?php echo $font ?></td>
				<td><span class="ckbutton ckbutton-danger" onclick="ckRemoveGoogleFont('<?php echo $font ?>')"><?php echo TCK_Text::_('CK_DELETE') ?></span></td>
			</tr>
		<?php
		}
	}
	?>
	</table>
</div>
<script>
	ckInitColorPickers();
</script>