<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

use Templatecreatorck\CKFof;

global $ckcreatesteps;
$ckcreatesteps = array();

$db = \Templatecreatorck\CKFof::getDbo();

// clear cache before processing
$conf = \Joomla\CMS\Factory::getConfig();
$options = [
	'defaultgroup' => '',
	'storage'      => $conf->get('cache_handler', ''),
	'caching'      => true,
	'cachebase'    => $conf->get('cache_path', JPATH_SITE . '/cache'),
];
$cache = \Joomla\CMS\Cache\Cache::getInstance('callback', $options);
$cache->clean();
$bodycode = $this->input->get('bodycode', '', 'raw');
$headcode = $this->input->get('headcode', '', 'raw');
$csscode = $this->input->get('csscode', '', 'raw');
$headcode = str_replace('|ot|', '<?', $headcode);
$headcode = str_replace('|ct|', '?>', $headcode);
// $bodycode = $this->input->get('bodycode', null, null, JREQUEST_ALLOWRAW);
// $headcode = $this->input->get('headcode', null, null);
$joomlaversion = $this->input->get('joomlaversion');
$templatename = $this->input->get('templatename');
$creationdate = $this->input->get('creationdate', '', 'string');
$author = htmlspecialchars($this->input->get('author', '', 'string'));
$authorEmail = htmlspecialchars($this->input->get('authorEmail', '', 'email'));
$authorUrl = htmlspecialchars($this->input->get('authorUrl', '', 'url'));
$copyright = htmlspecialchars($this->input->get('copyright', '', 'string'));
$license = htmlspecialchars($this->input->get('license', '', 'string'));
$version = htmlspecialchars($this->input->get('version'));
$description = htmlspecialchars($this->input->get('description', '', 'string'));
$makearchive = ($this->input->get('makearchive') != 'preview') ? true : false;
$blocs = $this->input->get('blocs', null, '');
$blocs = str_replace("|di|", "#", $blocs);
$blocswithslashes = $blocs;
$blocs = stripslashes($blocs);
$blocs = json_decode($blocs);
$blocswithslashes = json_decode($blocswithslashes);
$customstyles = stripslashes( $this->input->get('customstyles', '', 'string'));
$customstyles = json_decode($customstyles);
//$customstylesobjects = stripslashes( $input->get('customstylesobject', '', 'string'));
//$customstylesobjects = json_decode($customstylesobjects);
$isFluid = (isset($blocs[0]->blocwrapperfluid) && $blocs[0]->blocwrapperfluid !== 'fluid') ? false : true;
$loadBootstrap = (isset($blocs[0]->blocloadboostrap) && $blocs[0]->blocloadboostrap == '1') ? true : false;
$loadFontawesome = (isset($blocs[0]->blocloadfontawesome)) ? $blocs[0]->blocloadfontawesome : true;
$googleanalytics = (isset($blocs[0]->blocloadgoogleanalytics)) ? $blocs[0]->blocloadgoogleanalytics : false;
$hidefrontpage = (isset($blocs[0]->blochidefrontpage)) ? $blocs[0]->blochidefrontpage : false;
$customcss = '';
$customheader = '';
$customcodeendbody = '';
$customjs = '';
$column1width = (float)$this->input->get('column1width', '', 'float');
$column2ratio = (100 - $column1width) / 100;
$column2widthnoleft = (float)$this->input->get('column2width', '', 'float');
$column2width = $column2widthnoleft / $column2ratio;
$templateid = $this->input->get('id', 0, 'int');
$templateidentifier = $this->input->get('templateidentifier', '');
$loadBootstrap = (isset($blocs[0]->blocloadboostrap) && $blocs[0]->blocloadboostrap == '1') ? true : false;
$responsivevalues = $this->input->get('responsivevalues', '524,758,950,1024', 'string');
$responsivevalues = explode( ',', $responsivevalues);
$responsiverange = (isset($blocs[0]->responsiverange)) ? $blocs[0]->responsiverange : 'between';
$responsiveminivalue = (isset($blocs[0]->responsiveminivalue)) ? $blocs[0]->responsiveminivalue : '292';
$blocwrapperfluid = (isset($blocs[0]->blocwrapperfluid)) ? $blocs[0]->blocwrapperfluid : 'fixed';
$htmlcode_responsive = $this->input->get('htmlcode_responsive', '', 'html');
$customslayoutcss = $this->input->get('customslayoutcss', '', 'html');
$positions = $this->input->get('positions', '', 'array');
$colors = $this->input->get('colors', '', 'string');
$action = $this->input->get('action', '', 'cmd');
$googlefonts = $this->input->get('googlefonts', '', 'string');
$googlefontsuselocal = $this->input->get('googlefontsuselocal', '', 'string');
$svgicons = $this->input->get('svgicons', '', 'string');
$svgicons = str_replace('|lt|', '<', $svgicons);
$svgicons = str_replace('|gt|', '>', $svgicons);
$svgicons = json_decode($svgicons);
$templatecsstext = '';
$path = TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename;

/* responsive css */
$responsivecss = $this->input->get('responsivecss', null, '');// TODO extraire la liste de l'array et décoder chaque sous liste
$responsivecss = str_replace("|di|", "#", $responsivecss);
$responsivecsswithslashes = $responsivecss;
$responsivecss = stripslashes($responsivecss);
$responsivecss = json_decode($responsivecss);
$responsivecsswithslashes = json_decode($responsivecsswithslashes);


/* variation css */
$variationcss = $this->input->get('variationcss', null, '');// TODO extraire la liste de l'array et décoder chaque sous liste
$variationcss = str_replace("|di|", "#", $variationcss);
$variationcsswithslashes = $variationcss;
$variationcss = stripslashes($variationcss);
$variationcss = json_decode($variationcss);
$variationcsswithslashes = json_decode($variationcsswithslashes);

$isJ6AndMore = ($joomlaversion != 'j25' && $joomlaversion != 'j3' && $joomlaversion != 'j4' && $joomlaversion != 'j5');

// dark mode
$darkModeCss ='';
if (isset($variationcsswithslashes->variationcss1)) {
	if (file_exists($path . '/css/dark_custom.css')) {
		$darkModeCss .= "\n@import url(dark_custom.css) (prefers-color-scheme: dark);\n";
	}
	$content = str_replace('.ckvariationactive[ckvariationrange*="1"]', '', $variationcsswithslashes->variationcss1);
	$content = str_replace('.body', 'body', $content);

	$darkModeCss .= '@media (prefers-color-scheme: dark) {';
	$darkModeCss .= $content;
//	$darkModeCss .= str_replace('.body', 'body', $darkModeCss);
	$darkModeCss .= '}';
}

if ($loadFontawesome === '1') {
	$facktoload = true;
} else if ($loadFontawesome === '0') {
	$facktoload = false;
} else {
	$facktoload = $this->input->get('facktoload', 0, 'string');
}

$widgets = $this->input->get('widgets', '', 'raw');
$widgetsList = json_decode($widgets);

$messages = array();

/*--------------------------------
 * --	HTML STEP				--
 * -----------------------------*/


// if ($action == 'install') {
	// $path = TEMPLATECREATORCK_PROJECTS_PATH . '/' . $templatename;
// } else {
	
// }
echo '<div class="cktitle">' . TCK_Text::_('CK_TEMPLATE_CREATION') . '</div>';

// create the template folder if not exists
if (!TCK_Folder::exists($path)) {
	if (!TCK_Folder::create($path)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER_PROJECTS') . '</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER_PROJECTS') . '</p>';
	}

	$messages[] = $msg;
}

// automatically backup the gabarit
$query = ' SELECT * FROM #__templateck_templates' .
		' WHERE id = ' . (int) $templateid;
$db->setQuery($query);
$gabaritcode = $db->loadObject();
if ($gabaritcode) {
	$exportfiledest = $path . '/' . $templatename . '.tck3';
	$gabaritcode->htmlcode = str_replace(TEMPLATECREATORCK_URI_ROOT, "|URIBASE|", $gabaritcode->htmlcode);
	$exportfiletext = json_encode($gabaritcode);
	if (!TCK_File::write($exportfiledest, $exportfiletext)) {
		$msg = '<p class="error">' . TCK_Text::_('CK_ERROR_COPY_GABARIT') . '</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_COPY_GABARIT') . '</p>';
	}
	$messages[] = $msg;
}

// export the colors
//TCK_File::write($path . '/params.tck', json_encode(array('colors' => $colors, 'googlefonts' => $googlefonts)));

// create component.php file
if ($joomlaversion == 'j4' || $joomlaversion == 'j5') {
	$defaultcomponentphpsrc = TEMPLATECREATORCK_PATH . '/additionals/joomla6/component.php';
} else {
	$defaultcomponentphpsrc = TEMPLATECREATORCK_PATH . '/component.php';
}
$defaultcomponentphpdest = $path . '/component.php';
if (!TCK_File::copy($defaultcomponentphpsrc, $defaultcomponentphpdest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /component.php</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /component.php</p>';
}
$messages[] = $msg;

// setup the source path for the overrides and additional files
if ($joomlaversion == 'j4' || $joomlaversion == 'j5' || $isJ6AndMore) {
	$additionalsPath = TEMPLATECREATORCK_PATH . '/additionals/joomla6';
} else {
	$additionalsPath = TEMPLATECREATORCK_PATH . '/additionals';
}

// create frontedition.php file
/*$src = TEMPLATECREATORCK_PATH . '/additionals/frontedition.php';
$dest = $path . '/frontedition.php';
if (!TCK_File::copy($src, $dest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /frontedition.php</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /frontedition.php</p>';
}
$messages[] = $msg;*/

if ($joomlaversion == 'j4' || $joomlaversion == 'j5') {
	// create offline.php file only for joomla 4 because not compatible with joomla 3
	$src = TEMPLATECREATORCK_PATH . '/additionals/offline.php';
	$dest = $path . '/offline.php';
	if (!TCK_File::copy($src, $dest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /offline.php</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /offline.php</p>';
	}
	$messages[] = $msg;
}

// create local svg files for icons
if (! empty($svgicons)) {
	if (! TCK_Folder::exists($path . '/icons')) {
		if (!TCK_Folder::create($path . '/icons')) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /icons</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /icons</p>';
		}
		$messages[] = $msg;
	}
	// create index.html file (root)
	$indexhtmlsrc = TEMPLATECREATORCK_PATH . '/index.html';
	if (!TCK_File::copy($indexhtmlsrc, $path . '/icons' . '/index.html')) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /index.html</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /index.html</p>';
	}
	$messages[] = $msg;
	foreach ($svgicons as $name => $code) {
		if (!TCK_File::write($path . '/icons/' . $name, $code)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /icons/' . $name . '</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /icons/' . $name . '</p>';
		}
		$messages[] = $msg;
	}
}
if ($customcodeendbody) {
	if (!TCK_File::write($path . '/customcodeendbody.php', $customcodeendbody)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /customcodeendbody.php</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /customcodeendbody.php</p>';
	}
	$messages[] = $msg;
}

// create html folder of override
$pathhtmlfolder = $path . '/html';
if (! TCK_Folder::exists($pathhtmlfolder)) {
	if (!TCK_Folder::create($pathhtmlfolder)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /html</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /html</p>';
	}
	$messages[] = $msg;
}

if ($joomlaversion == 'j3') {
	// create modules.php file
	$modulesphpsrc = $additionalsPath . '/html/modules.php';
	$modulesphpdest = $path . '/html/modules.php';
	if (!TCK_File::copy($modulesphpsrc, $modulesphpdest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /html/modules.php</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /html/modules.php</p>';
	}
	$messages[] = $msg;
} else if ($joomlaversion == 'j4' || $joomlaversion == 'j5' || $isJ6AndMore) {
	if (! TCK_Folder::exists($path . '/html/layouts')) {
		if (!TCK_Folder::create($path . '/html/layouts')) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /html/layouts</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /html/layouts</p>';
		}
		$messages[] = $msg;
	}
	// create chromes override file
	$crhomessrc = $additionalsPath . '/html/layouts/chromes';
	$crhomesdest = $path . '/html/layouts/chromes';
	if (!TCK_Folder::copy($crhomessrc, $crhomesdest, '', true, true)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /additionals/html/layouts/chromes</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /additionals/html/layouts/chromes</p>';
	}
	$messages[] = $msg;
}

// create css folder
$pathcss = $path . '/css';
if (! TCK_Folder::exists($pathcss)) {
	if (! TCK_Folder::create($pathcss)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /css</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /css</p>';
	}
	$messages[] = $msg;
}

// copy the fonts folder for fontawesome
if ($facktoload && $facktoload !== 'false' && ($joomlaversion != 'j4' || $joomlaversion == 'j5')) {
	$pathfontsfolder = $path . '/fonts';

	// create fonts folder
	if (!TCK_Folder::exists($pathfontsfolder)) {
		if (!TCK_Folder::create($pathfontsfolder)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /fonts</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /fonts</p>';
		}
		$messages[] = $msg;
	}

	$fontfiles = TCK_Folder::files(TEMPLATECREATORCK_PATH . '/fonts');
	foreach ($fontfiles as $fontfile) {
		if (!TCK_File::copy(TEMPLATECREATORCK_PATH . '/fonts/' . $fontfile, $pathfontsfolder . '/' . $fontfile)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FONTSAWESOMEFOLDER_PROJECTS') . '</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FONTSAWESOMEFOLDER_PROJECTS') . '</p>';
		}
		$messages[] = $msg;
	}

	if (! $isJ6AndMore) {
		// copy the fontawesome css file
		$defaultfontawesomecsssrc = TEMPLATECREATORCK_PATH . '/assets/font-awesome.min.css';
		$defaultfontawesomecssdest = $path . '/css/font-awesome.min.css';

		if (!TCK_File::copy($defaultfontawesomecsssrc, $defaultfontawesomecssdest)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /assets/font-awesome.min.css</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /assets/font-awesome.min.css</p>';
		}
		$messages[] = $msg;
	}
}

// create images folder
$pathimg = $path . '/images';
if (!TCK_Folder::exists($pathimg)) {
	if (!TCK_Folder::create($pathimg)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /images</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /images</p>';
	}
	$messages[] = $msg;
} else {
	// clean images folder
	$images = TCK_Folder::files($pathimg);
	foreach ($images as $image) {
		$ok = TCK_File::delete($pathimg . '/' . $image);
	}
}

// create images system folder
$pathimgsystem = $path . '/images/system';
if (!TCK_Folder::exists($pathimgsystem)) {
	if (!TCK_Folder::create($pathimgsystem)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /images/system</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /images/system</p>';
	}
	$messages[] = $msg;
}

// copy Joomla 4 images
if ($joomlaversion == 'j4' || $joomlaversion == 'j5' || $isJ6AndMore) {
	$srcfolder = TEMPLATECREATORCK_PATH . '/additionals/joomla6/images/';
	$j4images = TCK_Folder::files($srcfolder);
	foreach ($j4images as $j4image) {
		if (! TCK_File::copy($srcfolder . $j4image, $path . '/images/' . $j4image)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . '/images/' . $j4image . '</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . '/images/' . $j4image . '</p>';
		}

		$messages[] = $msg;
	}
}

/* integrated before, to test
if ($facktoload) {
	// copy the fontawesome css file
	$defaultfontawesomecsssrc = TEMPLATECREATORCK_PATH . '/assets/font-awesome.min.css';
	$defaultfontawesomecssdest = $path . '/css/font-awesome.min.css';

	if (!TCK_File::copy($defaultfontawesomecsssrc, $defaultfontawesomecssdest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FONTSAWESOMECSS_PROJECTS') . '</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FONTSAWESOMECSS_PROJECTS') . '</p>';
	}
	$messages[] = $msg;
}*/

if ($joomlaversion !== 'j4' || $joomlaversion == 'j5') {
// create default.css file
$defaultcsssrc = TEMPLATECREATORCK_PATH . '/default.css';
$defaultcssdest = $path . '/css/default.css';
if (!$loadBootstrap && !TCK_File::copy($defaultcsssrc, $defaultcssdest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/default.css</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/default.css</p>';
}
$messages[] = $msg;
}

// create template.js file
if ($loadBootstrap && !$isJ6AndMore) {
	// create images system folder
	$pathjs = $path . '/js';
	if (!TCK_Folder::exists($pathjs)) {
		if (!TCK_Folder::create($pathjs)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /js</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /js</p>';
		}
		$messages[] = $msg;
	}

	$defaultcsssrc = $additionalsPath . '/template.js';
	$defaultcssdest = $path . '/js/template.js';
	if (!TCK_File::copy($defaultcsssrc, $defaultcssdest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /js/template.js</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /js/template.js</p>';
	}
	$messages[] = $msg;
}

// create default_rtl.css file
$defaultcsssrc = TEMPLATECREATORCK_PATH . '/default_rtl.css';
$defaultcssdest = $path . '/css/default_rtl.css';
if (!$loadBootstrap && !TCK_File::copy($defaultcsssrc, $defaultcssdest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/default_rtl.css</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/default_rtl.css</p>';
}
$messages[] = $msg;

// create bootstrap.css file
if ($joomlaversion == 'j3') {
	$defaultcsssrc = TEMPLATECREATORCK_PATH . '/bootstrap.css';
	$defaultcssdest = $path . '/css/bootstrap.css';
	if (!TCK_File::copy($defaultcsssrc, $defaultcssdest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/bootstrap.css</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/bootstrap.css</p>';
	}
	$messages[] = $msg;

	$defaultimgfoldersrc = TEMPLATECREATORCK_PATH . '/img';
	$defaultimgfoldersrcdest = $path . '/img';
	if (!TCK_Folder::exists($defaultimgfoldersrcdest)) {
		if (!TCK_Folder::copy($defaultimgfoldersrc, $defaultimgfoldersrcdest)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /img</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /img</p>';
		}
		$messages[] = $msg;
	}
} else if ($joomlaversion == 'j4' || $joomlaversion == 'j5') {
	$defaultcsssrc = $additionalsPath . '/bootstrap.j4.css';
	$defaultcssdest = $path . '/css/bootstrap.css';
	if (!TCK_File::copy($defaultcsssrc, $defaultcssdest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/bootstrap.css</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/bootstrap.css</p>';
	}
	$messages[] = $msg;
}

// create custom.css file if exists
//if ($customcss) {
//	if (!TCK_File::write($path . '/css/custom.css', $customcss)) {
//		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_CUSTOMCSS') . '</p>';
//		$messages[] = $msg;
//	}
//}

// create customheader.php file if exists
//if ($customheader) {
//	if (!TCK_File::write($path . '/customheader.php', $customheader)) {
//		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_CUSTOMHEADER') . '</p>';
//		$messages[] = $msg;
//	}
//}



// create index.html file (root)
$indexhtmlsrc = TEMPLATECREATORCK_PATH . '/index.html';
$indexhtmldest = $path . '/index.html';
if (!TCK_File::copy($indexhtmlsrc, $indexhtmldest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /index.html</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /index.html</p>';
}
$messages[] = $msg;

// create index.html file (css)
$indexhtmldest = $path . '/css/index.html';
if (!TCK_File::copy($indexhtmlsrc, $indexhtmldest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/index.html</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/index.html</p>';
}
$messages[] = $msg;

// create the file font.css
// removed from version 3.3.11 because the fonts are loaded into index.php
// $fontscontent = '';
// if (!TCK_File::write($path . '/css/fonts/fonts.css', $fontscontent)) {
	// $msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FONTSCSS') . '</p>';
// } else {
	// $msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FONTSCSS') . '</p>';
// }
// $messages[] = $msg;


// create index.html file (images)
$indexhtmldest = $path . '/images/index.html';
if (!TCK_File::copy($indexhtmlsrc, $indexhtmldest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /images/index.html</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /images/index.html</p>';
}
$messages[] = $msg;


// create index.html file (images system)
$indexhtmldest = $path . '/images/system/index.html';
if (!TCK_File::copy($indexhtmlsrc, $indexhtmldest)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /images/system/index.html</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /images/system/index.html</p>';
}
$messages[] = $msg;

//$pieIds = Array();
$ie7inlineblock =  Array();
$external_fonts = Array();
foreach ($blocs as $bloc) {

	$systemimages = array(
		"emailsystemimageurl",
		"printsystemimageurl",
		"ratingblanksystemimageurl",
		"ratingfilledsystemimageurl",
		"editsystemimageurl",
		"arrowsystemimageurl",
		"faviconsystemimageurl",
		"template_thumbnailsystemimageurl",
		"template_previewsystemimageurl");
	foreach ($systemimages as $systemimage) {
		if (isset($bloc->$systemimage) AND $bloc->$systemimage) {
			if ($systemimage == 'emailsystemimageurl')
				$destimgname = 'images/system/emailButton.png';
			if ($systemimage == 'printsystemimageurl')
				$destimgname = 'images/system/printButton.png';
			if ($systemimage == 'ratingblanksystemimageurl')
				$destimgname = 'images/system/rating_star_blank.png';
			if ($systemimage == 'ratingfilledsystemimageurl')
				$destimgname = 'images/system/rating_star.png';
			if ($systemimage == 'editsystemimageurl')
				$destimgname = 'images/system/edit.png';
			if ($systemimage == 'arrowsystemimageurl')
				$destimgname = 'images/system/arrow.png';
			if ($systemimage == 'faviconsystemimageurl')
				$destimgname = 'favicon.ico';
			if ($systemimage == 'template_thumbnailsystemimageurl')
				$destimgname = 'template_thumbnail.png';
			if ($systemimage == 'template_previewsystemimageurl')
				$destimgname = 'template_preview.png';
			$imgurl = $bloc->$systemimage;

			$imgname = explode("/", $bloc->$systemimage);
			$imgname = end($imgname);

			if ($imgname) {
				$imagesdest = $path . '/' . $destimgname;
				$imagessrc = TEMPLATECREATORCK_SITE_ROOT . '/' . $imgurl;

				if (!TCK_File::copy($imagessrc, $imagesdest)) {
					$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_IMAGEFILES') . ' ' . $imgname . '</p>';
				} else {
					$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_IMAGEFILES') . ' ' . $imgname . '</p>';
				}
				$messages[] = $msg;
			}
		}
	}
	
	// copy the custom images
	for ($i=1 ; $i<= 9; $i++) {
		$customimage = 'customimage' . $i;
		if (isset($bloc->$customimage) AND $bloc->$customimage) {
			
			$imgurl = $bloc->$customimage;

			$imgname = explode("/", $bloc->$customimage);
			$imgname = end($imgname);

			$imagesdest = $path . '/images/' . $imgname;
			$imagessrc = TEMPLATECREATORCK_SITE_ROOT . '/' . $imgurl;

			if (!TCK_File::copy($imagessrc, $imagesdest)) {
				$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_IMAGEFILES') . ' ' . $imgname . '</p>';
			} else {
				$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_IMAGEFILES') . ' ' . $imgname . '</p>';
			}
			$messages[] = $msg;
		}
	}

//	$bloc->ckid = $bloc->ckid . ' > div.inner';

	// IE7 compatibility for horizontal menu
	
	if (stristr($bloc->class, 'menu') || stristr($bloc->class, 'horiznav')) {
		$ie7inlineblock[] = '#' . $bloc->ckid . ' ul.menu > li';
	}
	
	// test for the google fonts
	
	// $prefix = 'bloc';
	// $fontfamily = $prefix . 'fontfamily';
	
	// if ($action != 'preview') $this->_injectFonts($cssparams, $fontfamily);

	$native_fonts = array('default'
		,'Times New Roman, Serif'
		,'Helvetica, sans-serif'
		,'Georgia, serif'
		,'Courier New, serif'
		,'Arial, sans-serif'
		,'Verdana, sans-serif'
		,'Comic Sans MS, cursive'
		,'Tahoma, sans-serif'
		,'Segoe UI, sans-serif'
		);

	if ($bloc->ckid == 'body' || stristr($bloc->class, 'body')) {
		$prefixes = array(
			"pagenavbutton",
			"pagenavbuttonhover",
			"readmorebutton",
			"readmorebuttonhover",
			"buttonbutton",
			"buttonbuttonhover",
			"inputfieldbutton",
			"inputfieldbuttonactive",
			"level0bg",
			"level0item",
			"level0itemhover",
			"level0itemactive",
			"level1bg",
			"level1item",
			"level1itemhover",
			"level1itemactive",
			"level2bg",
			"h1title",
			"h2title",
			"h3title",
			"h4title",
			"h5title",
			"h6title",
			"bloc",
			"module",
			"moduletitle",
			"body");
	} else {
		$prefixes = array(
			"level0bg",
			"level0item",
			"level0itemhover",
			"level0itemactive",
			"level1bg",
			"level1item",
			"level1itemhover",
			"level1itemactive",
			"level2bg",
			"bloc",
			"module",
			"moduletitle",
			"body");
	}

	foreach ($prefixes as $prefix) {
		$fontfamily = $prefix . 'fontfamily';
		if (isset($bloc->$fontfamily) AND ! in_array($bloc->$fontfamily, $native_fonts)) {
			if (! in_array($bloc->$fontfamily, $external_fonts)) {
				array_push($external_fonts, $bloc->$fontfamily);
			}
		}
	}
} // fin boucle des blocs

$templatepath = '<?php echo $this->baseurl ?>/templates/<?php echo $this->template ?>';

// loop through the enabled plugins and load the needed CSS / JS files
$widgets = array();
require_once TEMPLATECREATORCK_PATH . '/helpers/ckwidgets.php';
foreach ($widgetsList as &$widget) {
//	$enabled = $widget->enabled ? '1' : '0';
//	$data = $widget->data;

	// if the widget is enabled, call the rendering features
	if ($widget->enabled) {
		$name = $widget->name;
		$widgets[$name] = new stdClass();
		include_once(TEMPLATECREATORCK_PATH .'/widgets/' . $name . '/' . $name . '.php');
		$widgetClassName = 'TCK_Widget' . ucfirst($name);
		$widgetClass = new $widgetClassName();
		$widgetsRenderInit = array();
		$widgetsRenderInit['php'] = '';
		$widgetsRenderInit['jquery'] = '';
		$widgetsRenderInit['script'] = '';
		$widgetsRenderInit['scriptDeclaration'] = '';
		$widgetsRenderInit['stylesheet'] = '';
		$widgetsRenderInit['styleDeclaration'] = '';
		$widgetRender = $widgetClass->renderFrontendWidget($templatepath, $templatename, $widget->data);
		$widgets[$name]->render = $widgetRender ? $widgetRender : $widgetsRenderInit;
	}
}
// init the editor.css file to use in the editor for real preview
$editorcsstext = '';

$gfonts_url = "\t";
$fontsquirrel_url = "\t";
$fontsquirrelfonts = array();
// check for specific font to add
if (count($external_fonts) > 0) {
	$gfonts_url = "";
	$fontsquirrel_urls = "";
	// dans DB cercher fontfamilies (Lato), puis recuperer styles (@import url(https://fonts.googleapis.com/css?family=Lato:300,400,700);), si @import alors c'est gfont et doit utiliser <link />
	// sinon c'est Fsquirrel, utiliser methode normale avec ecriture dans fonts.css
	// mettre creation fonts.css + dossier fonts ici, comme ca si pas de font externe on ne le cree pas !
	// supprimer les lignes dans le helper stylescss.php
	
	// loads the fonts list
	$db = \Joomla\CMS\Factory::getDBO();
	$query = "SELECT * FROM #__templateck_fonts";
	$db->setQuery($query);
	$db_fonts = $db->loadObjectList('fontfamilies');
	
	$font_names = array();
	// create a list of available fonts
	foreach ($db_fonts as $db_font) {
		$db_font_exploded = explode(',', $db_font->fontfamilies);
		foreach ($db_font_exploded as $font_name) {
			$font_names[$font_name] = $db_font;
			$font_names[$font_name]->copied = false;
		}
	}

	// loop for the needed fonts to add
	foreach ($external_fonts as $external_font) {
		$external_font = trim($external_font, "'");
		$external_font = explode(',', $external_font);
		$external_font = trim($external_font[0]);

		if (isset($font_names[$external_font]) && $font_names[$external_font]->copied == false) {
			// check if it is a google font
			preg_match('/@import url\((.*?)\);/', $font_names[$external_font]->styles, $matches);

			if (isset($matches[1])) {
				// if this is a googlefont
				$gfont_url = str_replace('http:', '', $matches[1]);
				$subset = isset($font_names[$external_font]->subset) && $font_names[$external_font]->subset ? '&subset=' . $font_names[$external_font]->subset : '';
				$gfonts_url .= "\t<link href='" . $gfont_url . $subset . "' rel='stylesheet' type='text/css'>\n";
				$font_names[$external_font]->copied = true;
			} else {
				// if this is a fontsquirrel
				$fontsquirrel_urls .= trim(str_replace("url('", "url('" . $templatepath . "/fonts/", $font_names[$external_font]->styles));
				// copy the font files into the template
				$dest = $path . '/fonts';
				$src = TEMPLATECREATORCK_PATH . '/fonts/' . $font_names[$external_font]->name;
				// create the folder fonts if needed
				if (!TCK_Folder::exists($dest)) {
					if (!TCK_Folder::create($dest)) {
						$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER_FONTS') . '</p>';
					} else {
						$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER_FONTS') . '</p>';
					}
					$messages[] = $msg;

					// create index.html file (css)
					$indexhtmldest = $path . '/fonts/index.html';

					if (!TCK_File::copy($indexhtmlsrc, $indexhtmldest)) {
						$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' : fonts/index.html</p>';
					} else {
						$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' : fonts/index.html</p>';
					}
					$messages[] = $msg;
				}
				$fontfiles = TCK_Folder::files($src);
				foreach ($fontfiles as $fontfile) {
					$fileext = strtolower(TCK_File::getExt($fontfile));
					if ($fileext != 'css' AND $fileext != 'html' AND $fileext != 'txt')
						if (!TCK_File::copy($src . '/' . $fontfile, $dest . '/' . $fontfile)) {
							echo 'ERREUR COPIE FONT';
						}
				}
				$font_names[$external_font]->copied = true;
				
			}
		}

		$temp_font = str_replace(' ', '+', $external_font);
		if (! in_array($temp_font, $fontsquirrelfonts)) $fontsquirrelfonts[] = $temp_font;
	}
	$gfonts_url .= "\t";
	if ( trim($fontsquirrel_urls) != "") {
		$fontsquirrel_url = "<style type='text/css'>\n";
		$fontsquirrel_url .= $fontsquirrel_urls;
		$fontsquirrel_url .= "\n\t</style>\n\t";
	}
}

if (!TCK_Folder::exists($path . '/fonts/')) {
	if (!TCK_Folder::create($path . '/fonts/')) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER_FONTS') . '</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER_FONTS') . '</p>';
	}
	$messages[] = $msg;

	// create index.html file (css)
	$indexhtmldest = $path . '/fonts/index.html';

	if (!TCK_File::copy($indexhtmlsrc, $indexhtmldest)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' : fonts/index.html</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' : fonts/index.html</p>';
	}
	$messages[] = $msg;
}

$googlefontsArray = explode(',', $googlefonts);
foreach ($googlefontsArray as $googlefont) {
	if (! $googlefont) continue; // to avoid empty value
	$family = str_replace(' ', '+', $googlefont);

	if ($googlefontsuselocal == '1') {
		// create index.html file (css)
		$gfontFolderPath = TEMPLATECREATORCK_PATH . '/gfonts/';
		$gfontsrc = $gfontFolderPath . $family . '.css';
		$gfontdest = $path . '/css/' . $family . '.css';
		if (file_exists($gfontsrc)) {
			if (!TCK_File::copy($gfontsrc, $gfontdest)) {
				$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/' . $family . '.css</p>';
			} else {
				$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/' . $family . '.css</p>';
			}
			$messages[] = $msg;

			$gfontcsscontent = file_get_contents($gfontsrc);
			preg_match_all('/url\((.*?)\)/', $gfontcsscontent, $matches);
			if (isset($matches[0]) && ! empty($matches[1])) {
				if (is_array($matches[1])) {
					foreach($matches[1] as $url) {
						// replace the google url by the local url in the css file
						$filename = explode('/', $url);
						$filename = end($filename);
						$newurl = '../fonts/' . $filename;
						$gfontfilecontent = file_get_contents($gfontdest);
						$gfontfilecontent = str_replace($url, $newurl, $gfontfilecontent);
						file_put_contents($gfontdest, $gfontfilecontent);
						// copy the ttf files in the template
						if (!TCK_File::copy($gfontFolderPath . $filename, $path . '/fonts/' . $filename)) {
							$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /fonts/' . $filename . '</p>';
						} else {
							$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /fonts/' . $filename . '</p>';
						}
						$messages[] = $msg;
					}
				}
			}

			$templatecsstext .= "@import url(" . $family . ".css);\n";
			$editorcsstext .= "@import url(" . $family . ".css);\n";
		}
	} else {
	$gfonts_url .= "\t<link href='https://fonts.googleapis.com/css2?family=" . $family . "&display=swap' rel='stylesheet' type='text/css'>\n";
	$editorcsstext .= '@import url(https://fonts.googleapis.com/css2?family=' . $family . ');';
	}
}

// export the fonts
$allfonts = (array)$googlefontsArray;
if (! empty($fontsquirrelfonts)) {
	$allfonts = array_merge($allfonts, $fontsquirrelfonts);
	$allfonts = array_unique($allfonts); 
}
$allfonts = implode(',', $allfonts);
TCK_File::write($path . '/params.tck', json_encode(array('colors' => $colors, 'googlefonts' => $allfonts)));

/* * * create index.php ** */

// make code for special characters
$headcode = str_replace('|lt|', '<', $headcode);
$headcode = str_replace('|gt|', '>', $headcode);
$headcode = str_replace("|rr|", "\r\n", $headcode);
$headcode = str_replace("|tab|", "\t", $headcode);
$headcode = str_replace("|plus|", "+", $headcode);
$headcode = str_replace("|di|", "#", $headcode);

// make code for special characters
$bodycode = str_replace('|lt|', '<', $bodycode);
$bodycode = str_replace('|gt|', '>', $bodycode);
$bodycode = str_replace("|rr|", "\r\n", $bodycode);
$bodycode = str_replace("|tab|", "\t", $bodycode);
$bodycode = str_replace("|di|", "#", $bodycode);

$stylesheet = '';
$script = '';
$scriptDeclaration = '';
$styleDeclaration = '';
$php = '';
$versioning = substr((int)microtime(true), 4); // génère un ID

$componentphp = file_get_contents($path . '/component.php');
if (! empty(trim($gfonts_url))) {
	$gfonts_url = "\t<link rel=\"preconnect\" href=\"https://fonts.gstatic.com\">\n" . $gfonts_url;
	//load the fgonts in the component.php if needed
	$componentphp = str_replace('[GFONT]', $gfonts_url, $componentphp);
	
} else {
	$componentphp = str_replace('[GFONT]', '', $componentphp);
}
file_put_contents($path . '/component.php', $componentphp);

// loads the fonts
$stylesheet .= $gfonts_url;
$stylesheet .= $fontsquirrel_url;

$loaddefaultcss = '';
$loaddefaultcssrtl = '';
if ($loadBootstrap && ($joomlaversion == 'j3' || $joomlaversion == 'j4' || $joomlaversion == 'j5' || $isJ6AndMore)) {
	/*$stylesheet .= '<?php \Joomla\CMS\HTML\HTMLHelper::_(\'bootstrap.framework\'); ?>
	<link rel="stylesheet" href="' . $templatepath . '/css/bootstrap.css" type="text/css" />';*/
	if ($joomlaversion == 'j3') {
		$stylesheet .= '<?php JHtml::_(\'bootstrap.framework\'); ?>
	<link rel="stylesheet" href="' . $templatepath . '/css/bootstrap.css" type="text/css" />
	<?php JHtmlBootstrap::loadCss($includeMaincss = false, $this->direction); ?>
';
	} else if ($joomlaversion == 'j4') {
		$stylesheet .= '<?php \Joomla\CMS\HTML\HTMLHelper::_(\'bootstrap.framework\'); ?>
	<link rel="stylesheet" href="' . $templatepath . '/css/bootstrap.css" type="text/css" />
	<?php \Joomla\CMS\HTML\Helpers\Bootstrap::loadCss($includeMaincss = false, $this->direction); ?>
';
	} else if ($joomlaversion == 'j5') {
		$stylesheet .= '<?php \Joomla\CMS\HTML\HTMLHelper::_(\'bootstrap.framework\'); ?>
	<link rel="stylesheet" href="<?php echo $this->baseurl ?>/media/vendor/bootstrap/css/bootstrap.min.css" type="text/css" />
	<?php \Joomla\CMS\HTML\Helpers\Bootstrap::loadCss($includeMaincss = false, $this->direction); ?>
';
	} else if ($isJ6AndMore) {
		$stylesheet .= '<?php \Joomla\CMS\HTML\HTMLHelper::_(\'bootstrap.framework\'); ?>
	<?php $wa->registerAndUseStyle(\'bootstrap\', \'media/vendor/bootstrap/css/bootstrap.min.css\'); ?>
	<?php \Joomla\CMS\HTML\Helpers\Bootstrap::loadCss($includeMaincss = false, $this->direction); ?>
';
	}
} else if ($joomlaversion !== 'j4' && $joomlaversion !== 'j5' && !$isJ6AndMore) {
	$loaddefaultcss = '
		<link rel="stylesheet" href="' . $templatepath . '/css/default.css" type="text/css" />';
	$loaddefaultcssrtl = '
		<link rel="stylesheet" href="' . $templatepath . '/css/default_rtl.css" type="text/css" />';
}
if (!$isJ6AndMore) {
$stylesheet .= '<?php if ($this->direction == \'rtl\') { ?>' . $loaddefaultcssrtl . '
		<link rel="stylesheet" href="' . $templatepath . '/css/template_rtl.css?ver=' . $versioning . '" type="text/css" />
	<?php } else { ?>' . $loaddefaultcss . '
		<link rel="stylesheet" href="' . $templatepath . '/css/template.css?ver=' . $versioning . '" type="text/css" />
	<?php } ?>
';

if ($darkModeCss) {
	$stylesheet .= '<link rel="stylesheet" href="' . $templatepath . '/css/dark.css?ver=' . $versioning . '" type="text/css" />';
}

	if ($facktoload && $facktoload !== 'false' && $joomlaversion != 'j4' && $joomlaversion != 'j5' && !$isJ6AndMore) {
		$stylesheet .= '
	<link rel="stylesheet" href="' . $templatepath . '/css/font-awesome.min.css" type="text/css" />';
	} else if ($facktoload && $facktoload !== 'false' && ($joomlaversion == 'j4' || $joomlaversion == 'j5')) {
		$stylesheet .= '
	<link rel="stylesheet" href="<?php echo $this->baseurl ?>/media/system/css/joomla-fontawesome.min.css" type="text/css" />';
	}

	$stylesheet .= '
	<link rel="stylesheet" href="' . $templatepath . '/css/mobile.css?ver=' . $versioning . '" type="text/css" />';
} else {
	$stylesheet .= '<?php 
	$wa->useScript(\'core\');
	$wa->registerAndUseStyle(\'fontawesome\', \'system/joomla-fontawesome.min.css\');
';
	$stylesheet .= '	if ($this->direction == \'rtl\') {
	$wa->registerAndUseStyle(\'template\', \'templates/\' . $this->template . \'/css/template_rtl.css\');
	} else {
	$wa->registerAndUseStyle(\'template\', \'templates/\' . $this->template . \'/css/template.css\');
	}
';

if ($darkModeCss) {
	$stylesheet .= '	$wa->registerAndUseStyle(\'template-dark\', \'templates/\' . $this->template . \'/css/dark.css\');
';
}
	$stylesheet .= '	$wa->registerAndUseStyle(\'template-mobile\', \'templates/\' . $this->template . \'/css/mobile.css\');
?>';
}

$jquery = false;
foreach ($widgets as $widget) {
	$stylesheet .= $widget->render['stylesheet'] ? "\n\t" . $widget->render['stylesheet'] : '';
	$script .= $widget->render['script'] ? "\n\t" . $widget->render['script'] : '';
	$scriptDeclaration .= $widget->render['scriptDeclaration'] ? "\n\t" . $widget->render['scriptDeclaration'] : '';
	$styleDeclaration .= $widget->render['styleDeclaration']? "\n\t" . $widget->render['styleDeclaration'] : $widget->render['styleDeclaration'];
	$php .= $widget->render['php'] ? "\n\t" . $widget->render['php'] : '';
	$jquery = $widget->render['jquery'] ? true : $jquery;
	
	if (isset($widget->render['jsFiles']) && is_array($widget->render['jsFiles'])) {
		foreach ($widget->render['jsFiles'] as $jsName => $jsFile) {
			TCK_Folder::create($path . '/js/');
			TCK_File::copy($jsFile, $path . '/js/' . $jsName . '.js');
		}
	}
}

// create custom.js file if exists
if ($customjs) {
	// delete the entire folder if already exists
//	if (!TCK_Folder::exists($path . '/js')) {
//		TCK_Folder::create($path . '/js');
//	}

//	if (!TCK_File::write($path . '/js/custom.js', $customjs)) {
//		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_CUSTOMCSS') . '</p>';
//		$messages[] = $msg;
//	} else {
		$script .= "\n\t" . '<script src="<?php echo $this->baseurl ?>/templates/<?php echo $this->template ?>/js/custom.js" type="text/javascript" ></script>';
//	}
}

// define path to file
$indexphpdest = $path . '/index.php';

// create header
$indexphptext = '<?php

/**
 * @copyright	' . $copyright . '
 * ' . $authorUrl . '
 * Template made with the joomla component Template Creator CK - https://www.template-creator.com
 * ' . $templatename . '
 * @license ' . $license . '
 * @version ' . $version . '
 * */

// No direct access to this file
defined(\'_JEXEC\') or die(\'Restricted access\');

' . ($isJ6AndMore ? '$wa    = $this->getWebAssetManager();
$app   = \Joomla\CMS\Factory::getApplication();
$input = $app->getInput();' : '$app   = \Joomla\CMS\Factory::getApplication();') . '
$input = $app->input;
?>

<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>" >
<head>
	' . ($isJ6AndMore ? '<jdoc:include type="metas" />
	<jdoc:include type="styles" />
	<jdoc:include type="scripts" />' : '<jdoc:include type="head" />') . '
	<?php if ($this->params->get(\'useresponsive\',\'1\')) { ?>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<?php } ?>
';
if ($joomlaversion == 'j3') {
	$indexphptext .= '	<?php JHtml::_(\'jquery.framework\'); ?>
';
} else if ($joomlaversion == 'j4' || $joomlaversion == 'j5') {
	$indexphptext .= '	<?php \Joomla\CMS\HTML\HTMLHelper::_(\'jquery.framework\'); ?>
';
} else if ($isJ6AndMore) {
	// do not load jquery by default
}

if ($joomlaversion == 'j15' || $joomlaversion == 'j25') {
	$indexphptext .= '    <link rel="stylesheet" href="<?php echo $this->baseurl ?>/templates/system/css/system.css" type="text/css" />
    <link rel="stylesheet" href="<?php echo $this->baseurl ?>/templates/system/css/general.css" type="text/css" />
';
}
$indexphptext .= $stylesheet
	. ($styleDeclaration ? "\n\t" . '<style type="text/css">' . $styleDeclaration . "\n\t" . '</style>' : '')
	. $script
	. ($scriptDeclaration ? "\n\t" . '<script type="text/javascript">' . $scriptDeclaration . "\n\t" . '</script>' : '')
	. ($php ? "\n\t" . '<?php ' . $php . "\n\t" . ' ?>' : '')
/*	. ($jquery ? "\n\t" . '<?php JHtml::_(\'jquery.framework\'); ?>' . "\n\t" : '') */
	. '
';

$indexphptext .= '<?php
// Detecting Active Variables';
if ($joomlaversion == 'j15') {
	$indexphptext .= '
$option   = JRequest::getVar(\'option\', \'\');
$view     = JRequest::getVar(\'view\', \'\');
$layout   = JRequest::getVar(\'layout\', \'\');
$task     = JRequest::getVar(\'task\', \'\');
$itemid   = JRequest::getVar(\'Itemid\', \'\');
?>';
} else {
	$indexphptext .= '
$option   = $input->getCmd(\'option\', \'\');
$view     = $input->getCmd(\'view\', \'\');
$layout   = $input->getCmd(\'layout\', \'\');
$task     = $input->getCmd(\'task\', \'\');
$itemid   = $input->getCmd(\'Itemid\', \'\');
$pageid   = $input->getCmd(\'id\', \'\');
$tckedition   = $input->getCmd(\'tckedition\', \'\');
$tckeditionclass = $tckedition ? \'tck-edition\' : \'\';

$menu = $app->getMenu()->getActive();
$pageclass = \'\';

if (is_object($menu))
	$pageclass = \' \' . $menu->getParams()->get(\'pageclass_sfx\');
?>';
}

// inject php code in document head
$indexphptext .= stripslashes($headcode);
//$containerClass = $isFluid ? 'container-fluid' : 'container';

/*if ($ie7inlineblock) $indexphptext .= "<!--[if lte IE 7]>
<style type=\"text/css\">
" . implode(",", $ie7inlineblock) . " {
\tdisplay: inline !important;
\tzoom: 1;
}
</style>
<![endif]-->
";*/

// add google analytics (new code)
if ($googleanalytics) {
	$indexphptext .= "<?php if (\$this->params->get('googleanalyticscode','')) { ?>
<script async src=\"https://www.googletagmanager.com/gtag/js?id=<?php echo \$this->params->get('googleanalyticscode','G-xxxxxxxx-x') ?>\"></script>
<script>
	window.dataLayer = window.dataLayer || [];
	function gtag(){dataLayer.push(arguments);}
	gtag('js', new Date());

	gtag('config', '<?php echo \$this->params->get('googleanalyticscode','G-xxxxxxxx-x') ?>');
</script>
<?php } ?>";
}

//if ($hidefrontpage == '1') {
	$indexphptext .= "<?php
// Detecting Home
\$menu = \Joomla\CMS\Factory::getApplication()->getMenu();
\$lang = \Joomla\CMS\Factory::getLanguage();
if (\$menu->getActive() == \$menu->getDefault(\$lang->getTag())) {
	\$siteHome = 1;
}else{
	\$siteHome = 0;
}
?>";
//}

if ($loadBootstrap && !$isJ6AndMore) {
	$indexphptext .= '
	<script src="' . $templatepath . '/js/template.js"></script>';
}
//$indexphptext .= $this->item->options;
$indexphptext .= $customheader;


/*$indexphptext .= '
	<!--[if lt IE 9]>
		<script src="<?php echo \\Joomla\\CMS\\Uri\\Uri::root(true); ?>/media/jui/js/html5.js"></script>
	<![endif]-->';*/
if (file_exists($path . '/customheader.php')) {
	$indexphptext .= ' 
<?php include(\'customheader.php\'); ?>';
}

if (file_exists($path . '/css/custom.css')) {
	$indexphptext .= '
	<link rel="stylesheet" href="' . $templatepath . '/css/custom.css?ver=' . $versioning . '" type="text/css" />
';
}

if (file_exists($path . '/css/print.css')) {
	$indexphptext .= '
	<link rel="stylesheet" href="' . $templatepath . '/css/print.css?ver=' . $versioning . '" type="text/css" media="print" />
';
}

$bodyCustomClass = isset($blocs[0]->{'data-class'}) ? ' ' .$blocs[0]->{'data-class'} : '';
$indexphptext .= '</head>
<body class="<?php echo $option
	. \' \' . $tckeditionclass . \'-body\'
	. \' view-\' . $view
	. ($layout ? \' layout-\' . $layout : \' no-layout\')
	. ($task ? \' task-\' . $task : \' no-task\')
	. $pageclass
	. ($itemid ? \' itemid-\' . $itemid : \'\')
	. ($siteHome === 1 ? \' homepage\' : \'\')
	. ($pageid ? \' pageid-\' . $pageid : \'\');
?> <?php echo $this->direction; ?>' . $bodyCustomClass . '">
';

// inject html code
$indexphptext .= stripslashes($bodycode);
// need to do the replacement here for the slashes
$indexphptext = str_replace("|bs|", "\\", $indexphptext);
$indexphptext = str_replace("{title}", '<?php echo \\Joomla\\CMS\\Factory::getDocument()->getTitle(); ?>', $indexphptext);

// close body and html page
$indexphptext .= '
<jdoc:include type="modules" name="debug" />';

if (file_exists($path . '/customendbody.php')) {
	$indexphptext .= '
<?php include(\'customendbody.php\'); ?>';
}
$indexphptext .= '
</body>
</html>';

// create the file index.php
$bodycode = '											<jdoc:include type="message" />
											<jdoc:include type="component" />
';


$indexphptext = str_replace('|BODYCODE|', $bodycode, $indexphptext);
$regex = "#CKLOADMODULE\((.*?)\)#s"; // masque de recherche
$indexphptext = preg_replace_callback($regex, 'replaceLoadmodule', $indexphptext);
$regex = "#CKLOADMODULEMENU\((.*?)\)#s"; // masque de recherche
$indexphptext = preg_replace_callback($regex, 'replaceLoadmodule', $indexphptext);
$indexphptext = str_replace('CKCOUNTMODULEMENU', '$this->countModules', $indexphptext);
$indexphptext = str_replace('CKCOUNTMODULE', '$this->countModules', $indexphptext);
$indexphptext = str_replace('[TEMPLATENAME]', $templatename, $indexphptext);
$indexphptext = str_replace('CKGETOPTION', '$this->params->get', $indexphptext);

function replaceLoadmodule($matches) {
	$vars = $matches[1];
	$vars = explode(',', $vars);
	$position = $vars[0];
	$iconattribs = $vars[1];

	$html = '<jdoc:include type="modules" name="' . $position . '" style="htmlck" ' . $iconattribs . '/>';

	return $html;
}

// create the file index.php
if (!TCK_File::write($indexphpdest, $indexphptext)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /index.php</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /index.php</p>';
}
$messages[] = $msg;



/*--------------------------------
 * --	CSS STEP				--
 * -----------------------------*/

// refactor the blocs array
$blocsbyname = array();
foreach ($blocs as $bloc) {
	$blocsbyname[$bloc->ckid] = $bloc;
}

// define the widths
$mainwidth = 100 - $column1width;
$centerwidth = 100 - $column2width;
$centerwidthnoleft = 100 - $column2widthnoleft;

// define path to file
$templatecssdest = $path . '/css/template.css';
$templatecss_rtldest = $path . '/css/template_rtl.css';
$templatecss_mobiledest = $path . '/css/mobile.css';

// create css standard styles
$templatecsstext .= '/* ---------------------------------------
	Standard styles formatting
	created with Template Creator
        on https://www.template-creator.com
-----------------------------------------*/

html {
	height: 100%;
}

body {
	margin: 0;
	padding: 0;
	min-height: 100vh;
}

* {
	padding: 0;
	margin: 0;
}

ul, ol {
	padding: .75em 0 .75em 0;
	margin: 0 0 0 35px;
}

ul.menu,
ul.nav {
	margin: 0;
	padding: 0;
	list-style: none;
	display: block;
}

ul.menu li a,
ul.nav li a {
	text-decoration: none;
}


p {
	padding: 5px 0;
}

.flexiblecolumn {
	min-height: 0.1px; /* needed to keep the area of the column */
	box-sizing: border-box;
}

.clr {
	clear : both;
}

.clearfix::after {
	display: block;
	content: "";
	clear: both;
}

canvas, img, svg, video {
	max-width: 100%;
	height: auto;
	box-sizing: border-box;
}

'.($column1width ? '
.column.column1 {
	width: ' . $column1width . '%;
}
' : '') . '
.column.column2 {
	width: ' . $column2width . '%;
}
'.($column1width ? '
.column.main {
	width: ' . $mainwidth . '%;
}
' : '') . '
.column.center {
	width: ' . $centerwidth . '%;
}
'.($column1width ? '
.noleft .center.column  {
	width: ' . $centerwidthnoleft . '%;
}

.noleft .column2 {
	width: ' . $column2widthnoleft . '%;
}

.noleft .main {
	width: 100%;
}
' : '') . '
.noright .column.center {
	width: 100%;
}

.flexiblemodule, .column, .logobloc, .flexiblecolumn {
	float: left;
}

.rtl .flexiblemodule, .rtl .column, .rtl .logobloc, .rtl .flexiblecolumn {
	float: right;
}

/* for equalheights */
section > .inner > .clr,
.flexiblemodule > .inner > .clr,
.equalheights > .inner > .clr,
section > .inner:before,
.flexiblemodule > .inner:before,
.equalheights > .inner:before,
section > .inner:after,
.flexiblemodule > .inner:after,
.equalheights > .inner:after {
	display: none;
}

section > .inner,
.equalheights > .inner,
.equalheights .maincenter > .inner {
	display: flex;
	justify-content: space-between;
}

.flexiblemodule {
	display: flex;
	flex: 1 1 auto;
}

.flexiblemodule > .inner {
	max-width:100%;
	width: 100%;
	box-sizing: border-box;
}

.videobackground { 
	position: absolute;
	top: 50%;
	left: 50%;
	min-width: 100%;
	min-height: 100%;
	width: auto;
	height: auto;
	z-index: 0;
	-webkit-transform: translateX(-50%) translateY(-50%);
	transform: translateX(-50%) translateY(-50%);
	background-size: cover;
	object-fit: cover;
}

.videobackground + *,
.videobackground_yt1 + * { 
	position: relative;
	z-index: 1;
}

/* for youtube video */
.videobackground_yt1 { 
	max-height: 100%;
	overflow: hidden;
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
}

.videobackground_yt2 { 
	padding-bottom: 56.3%;
	position: relative;
}

.hasvideobackground {
	position: relative;
	overflow: hidden;
}

#finder-search .in.collapse {
	overflow: visible;
}

.valign-top {
	align-self: flex-start;
}

.valign-center {
	align-self: center;
}

.valign-bottom {
	align-self: flex-end;
}

.halign-left > .inner {
	display: flex;
	justify-content: flex-start;
}

.halign-center > .inner {
	display: flex;
	justify-content: center;
}

.halign-right > .inner {
	display: flex;
	justify-content: flex-end;
}

.tck-logo-img {
	display: block;
}

.tck-logo-center img {
	margin-left: auto;
	margin-right: auto;
}

.tck-logo-right img {
	margin-left: auto;
}

.tck-wrapper,
.tck-relative,
.tck-module {
	position: relative;
}

.img_caption {
	max-width: 100%;
	width: auto !important;
}

.fack svg {
	vertical-align: baseline;
}

.tck-divider-container {
	pointer-events: none;
}
';

if ($joomlaversion == 'j4' || $joomlaversion == 'j5' || $isJ6AndMore) {
	// [0]=> string(3) "524" [1]=> string(3) "758" [2]=> string(3) "950" [3]=> string(4) "1024"
	$joomladefaultcss = file_get_contents($additionalsPath . '/joomla-default.css');
	$joomladefaultcss = str_replace('[RESOLUTION1]', $responsivevalues[0], $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION2]', $responsivevalues[1], $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION3]', $responsivevalues[2], $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION4]', $responsivevalues[3], $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION1MAX]', (int)$responsivevalues[0]-0.02, $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION2MAX]', (int)$responsivevalues[1]-0.02, $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION3MAX]', (int)$responsivevalues[2]-0.02, $joomladefaultcss);
	$joomladefaultcss = str_replace('[RESOLUTION4MAX]', (int)$responsivevalues[3]-0.02, $joomladefaultcss);
	$templatecsstext .= $joomladefaultcss;
}

$templatecsstext .= '
/* ---------------------------------------
	Article pagination
-----------------------------------------*/

.pagenavigation ul.pagination, .tck-article-pagination {
	list-style: none;
}

.tck-blog p.counter {
	float: right;
}

/* ---------------------------------------
	Print default CSS
-----------------------------------------*/

@media print {

	.tck-container {
		width: 100% !important;
	}

	.scrollToTop, #login-form, .tck-noprint {
		display: none !important
	}

	.flexiblemodule, .column, .logobloc, .flexiblecolumn {
		float: none;
	}

	.column.main, .column.column1, .column.column2 {
		width: 85%;
		margin-right: 2%;
		margin-left: auto;
	}

	.column.center {
		width: 100%;
	}

	a[href]:after {
		content: "";
	}

}

/* ---------------------------------------
	Accessibility
-----------------------------------------*/

.breadcrumb > .active {
	color: #000;
	font-weight: bold;
}

.muted {
	color: #666;
	font-weight: lighter;
}


/* ---------------------------------------
	CSS grid for content alignement
-----------------------------------------*/
[class*="tck-cols"] {
	display: flex;
	flex-wrap: wrap;
	justify-content: space-between;
	box-sizing: border-box;
}

[class*="tck-cols"] > * {
	flex: 1 1 auto;
	box-sizing: border-box;
}

[class*="tck-gutter"] > * {
	flex: 0 1 auto;
}

/* no gutter */
.tck-cols-2 > * {
	width: 50%;
}

.tck-cols-3 > * {
	width: 33.333%;
}

.tck-cols-4 > * {
	width: 25%;
}
.tck-cols-8 > * {
	width: 12.5%;
}

/* gutter 10px */
.tck-cols-2.tck-gutter-10 > * {
	width: calc((100% - 10px) / 2);
}

.tck-cols-3.tck-gutter-10 > * {
	width: calc((100% - 2 * 10px) / 3);
}

.tck-cols-4.tck-gutter-10 > * {
	width: calc((100% - 3 * 10px) / 4);
}

.tck-cols-8.tck-gutter-10 > * {
	width: calc((100% - 7 * 10px) / 8);
}

/* ---------------------------------------
	Shape divider
-----------------------------------------*/

.tck-divider-container {
	position: absolute;
	overflow: hidden;
	left: 0;
	width: 100%;
}

.tck-divider-container > svg {
	position: relative;
	height: 100%;
	left: 50%;
	transform: translate(-50%);
	min-width: 100%;
	max-width: none;
	vertical-align: initial;
	display: block;
}

.tck-divider-container.tck-divider-top {
	top: 0px;
}

.tck-divider-container.tck-divider-bottom {
	bottom: 0px;
}

.tck-divider-container.tck-divider-over {
	z-index: 2;
}

.tck-divider-container.tck-divider-under {
	z-index: 0;
}

.ckflip-horizontal > svg {
	transform: rotateY(180deg) translate(50%);
}

.ckflip-vertical > svg {
	transform: rotateX(180deg) translate(-50%);
}

.ckflip-horizontal.ckflip-vertical > svg {
	transform: rotate(180deg) translate(50%);
}

.tck-divider-container + .inner {
	position: relative;
}

/* ---------------------------------------
	System features
-----------------------------------------*/

.tck-edition {
	min-height: 50px;
	margin: 2px;
	border: 1px dashed grey;
	position: relative;
}
.tck-edition::before {
	content: "[" attr(data-position) "]";
	font-size: 14px;
	position: absolute;
	top: 50%;
	left: 50%;
	transform: translate(-50%, -50%);
	text-align: center;
	font-family: Segoe UI, sans-serif;
	line-height: 1.2;
	padding: 3px 5px;
	background: #333;
	display: block !important;
	color: #fff;
	border-radius: 3px;
	border: 1px solid #666;
	opacity: 0.8;
	pointer-events: none;
	box-sizing: content-box;
	height: 20px;
	z-index: 1;
}

';
if ($joomlaversion == 'j3' && !$loadBootstrap) {
	$templatecsstext .= '/* ---------------------------------------
	specific to images
-----------------------------------------*/

ul.actions {
	margin: 0;
	list-style: none;
}

ul.actions li a {
	text-decoration: none;
}
';
    if (isset($blocs[0]->printsystemimageurl) && $blocs[0]->printsystemimageurl)
        $templatecsstext .= ".print-icon {
	
	display: inline-block;
	height: 16px;
	line-height: 16px;
	padding-left: 20px;
	background: url(../images/system/printButton.png) left center no-repeat;
}

";

    if (isset($blocs[0]->emailsystemimageurl) && $blocs[0]->emailsystemimageurl)
        $templatecsstext .= ".email-icon {
	list-style: none;
	display: inline-block;
	height: 16px;
	line-height: 16px;
	padding-left: 20px;
	background: url(../images/system/emailButton.png) left center no-repeat;
}
";

    if (isset($blocs[0]->editsystemimageurl) && $blocs[0]->editsystemimageurl)
        $templatecsstext .= ".edit-icon {
	list-style: none;
	display: inline-block;
	height: 16px;
	line-height: 16px;
	padding-left: 20px;
	background: url(../images/system/edit.png) left center no-repeat;
}

";
}

$templatecsstext .= $customslayoutcss;

// Add the layouts css
$layouts = array('error404', 'article', 'blog', 'search');
foreach ($layouts as $layout) {
	if ( ($layout == 'article' || $layout == 'blog' || $layout == 'search')
			&& $joomlaversion == 'j25') {
		continue;
	}

	if (file_exists(TEMPLATECREATORCK_PATH . '/style_' . $layout . '.css')) {
		$layoutstyletext = @file_get_contents(TEMPLATECREATORCK_PATH . '/style_' . $layout . '.css');
		$templatecsstext .= '
/* ---------------------------------------
	' . ucfirst($layout) . '
-----------------------------------------*/

';
		$templatecsstext .= $layoutstyletext;
	}
	$layoutcsstext = $this->input->get('layout' . $layout . 'css', '', 'string');
	$templatecsstext .= str_replace('|ID| ', '', $layoutcsstext) . "\n";

	// load the custom layout features
	if (file_exists(TEMPLATECREATORCK_PATH . '/interfaces/layout_' . $layout . '.php'))
		include_once(TEMPLATECREATORCK_PATH . '/interfaces/layout_' . $layout . '.php');
}

// add the css for columns width
$templatecsstext .= '
/* ---------------------------------------
	Columns width
-----------------------------------------*/

' . $csscode;


$templatecsstext .= '
/* ---------------------------------------
	Custom styling
-----------------------------------------*/

';

$template_rtlcsstext = str_replace("float: left;", "float: right;", $templatecsstext);

$cssstyles = new CKStyles();

// create css for mobile responsive design
$cssmobilestyles = new CssMobileStyles();
$templatemobilecsstext = $cssmobilestyles->create($blocswithslashes, $column1width, $column2width, $templateid, $htmlcode_responsive);
// create css for each bloc
foreach ($blocswithslashes as $bloc) {
	if (stristr($bloc->class, 'flexiblemodules')) {
//		$flexiblemodulesCss = $cssstyles->createFlexiblemodulesCss($bloc, $bloc->ckid, 'archive');
		$templatecsstext .= $cssstyles->createFlexiblemodulesCss($bloc, $bloc->ckid, 'archive', 'ltr');
		$template_rtlcsstext .= $cssstyles->createFlexiblemodulesCss($bloc, $bloc->ckid, 'archive', 'rtl');
	}
	if (!isset($bloc->isdisabled) || (isset($bloc->isdisabled) && $bloc->isdisabled != 'true') || (isset($bloc->ishidden) && $bloc->ishidden != 'true')) {
		$templatecsstext .= $cssstyles->create($bloc, $bloc->ckid, 'archive', 'ltr');
		$template_rtlcsstext .= $cssstyles->create($bloc, $bloc->ckid, 'archive', '', 'rtl');
	}
	if (isset($customstyles->{$bloc->ckid})) {
		$customstyle = array($bloc->ckid => $customstyles->{$bloc->ckid});
		$templatecsstext .= $cssstyles->create($bloc, $bloc->ckid, 'archive', '', 'ltr', $customstyle);
	}
}

// write CSS for mobile
$templatecss_mobiletext = '
/* ---------------------------------------
	Responsive design code
-----------------------------------------*/

@media screen and (min-width: ' . ((int)$responsivevalues[3]+1) . 'px) {

.hidemobile5,
.tck-hide-desktop {
	display: none !important;
}

[class*="tck-cols"].tck-stack-5,
[class*="tck-cols"].tck-stack-desktop {
	flex-direction: column;
}

[class*="tck-cols"].tck-stack-5 > *,
[class*="tck-cols"].tck-stack-desktop > * {
	width: auto !important;
}


' . $templatemobilecsstext->resolution5 . '

}

@media screen ' . ($responsiverange == 'between' ? 'and (min-width: ' . ((int)$responsivevalues[2]+1) . 'px) ' : '') . 'and (max-width: ' . (int)$responsivevalues[3] . 'px) {

img {
	max-width: 100%;
	height: auto;
}
' . (($blocwrapperfluid == 'fixed') ? '
.tck-container {
	width: ' . (int)$responsivevalues[2] . 'px;
}
' : '') . '
.hidemobile4,
.tck-hide-tablet-l {
	display: none !important;
}

[class*="tck-cols"].tck-stack-4,
[class*="tck-cols"].tck-stack-tablet-l {
	flex-direction: column;
}

[class*="tck-cols"].tck-stack-4 > *,
[class*="tck-cols"].tck-stack-tablet-l > * {
	width: auto !important;
	max-width: 100%;
}


' . str_replace('.ckresponsiveactive[ckresponsiverange*="4"]', '', $responsivecsswithslashes->responsivecss4) . '
' . $templatemobilecsstext->resolution4 . '

}

@media screen ' . ($responsiverange == 'between' ? 'and (min-width: ' . ((int)$responsivevalues[1]+1) . 'px) ' : '') . 'and (max-width: ' . (int)$responsivevalues[2] . 'px) {

img {
	max-width: 100%;
	height: auto;
}
' . (($blocwrapperfluid == 'fixed') ? '
.tck-container {
	width: ' . (int)$responsivevalues[1] . 'px;
}
' : '') . '
.hidemobile3,
.tck-hide-tablet-p {
	display: none !important;
}

[class*="tck-cols"].tck-stack-3,
[class*="tck-cols"].tck-stack-tablet-p {
	flex-direction: column;
}

[class*="tck-cols"].tck-stack-3 > *,
[class*="tck-cols"].tck-stack-tablet-p > * {
	width: auto !important;
	max-width: 100%;
}


' . str_replace('.ckresponsiveactive[ckresponsiverange*="3"]', '', $responsivecsswithslashes->responsivecss3) . '
' . $templatemobilecsstext->resolution3 . '

}

@media screen ' . ($responsiverange == 'between' ? 'and (min-width: ' . ((int)$responsivevalues[0]+1) . 'px) ' : '') . 'and (max-width: ' . (int)$responsivevalues[1] . 'px) {

img {
	max-width: 100%;
	height: auto;
}
' . (($blocwrapperfluid == 'fixed') ? '
.tck-container {
	width: ' . (int)$responsivevalues[0] . 'px;
}
' : '') . '
.hidemobile2,
.tck-hide-phone-l {
	display: none !important;
}

[class*="tck-cols"].tck-stack-2,
[class*="tck-cols"].tck-stack-phone-l {
	flex-direction: column;
}

[class*="tck-cols"].tck-stack-2 > *,
[class*="tck-cols"].tck-stack-phone-l > * {
	width: auto !important;
	max-width: 100%;
}


' . str_replace('.ckresponsiveactive[ckresponsiverange*="2"]', '', $responsivecsswithslashes->responsivecss2) . '
' . $templatemobilecsstext->resolution2 . '

}

@media screen and (max-width: ' . (int)$responsivevalues[0] . 'px) {

img {
	max-width: 100%;
	height: auto;
}

' . (($blocwrapperfluid == 'fixed') ? '
.tck-container {
	width: ' . (int)$responsiveminivalue . 'px;
}
' : '') . '
.hidemobile1,
.tck-hide-phone-p {
	display: none !important;
}

[class*="tck-cols"].tck-stack-1,
[class*="tck-cols"].tck-stack-phone-p {
	flex-direction: column;
}

[class*="tck-cols"].tck-stack-1 > *,
[class*="tck-cols"].tck-stack-phone-p > * {
	width: auto !important;
	max-width: 100%;
}

' . str_replace('.ckresponsiveactive[ckresponsiverange*="1"]', '', $responsivecsswithslashes->responsivecss1) . '
' . $templatemobilecsstext->resolution1 . '

}
';

$editorcsstext .= '
@import url(template.css);
@import url(custom.css);

body { 
	/*font-family: Arial, Helvetica, sans-serif;*/
	margin: 10px;
	background: white;
	color: black;
}

';

// dark mode
if ($darkModeCss) {
	// create the file template.css
	if (!TCK_File::write($path . '/css/dark.css', $darkModeCss)) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/dark.css</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/dark.css</p>';
	}
	$messages[] = $msg;
}

// create the file template.css
if (!TCK_File::write($templatecssdest, $templatecsstext)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/template.css</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/template.css</p>';
}
$messages[] = $msg;

// create the file template_rtl.css
if (!TCK_File::write($templatecss_rtldest, $template_rtlcsstext)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/template_rtl.css</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/template_rtl.css</p>';
}
$messages[] = $msg;

// create the file mobile.css
if (!TCK_File::write($templatecss_mobiledest, $templatecss_mobiletext)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/mobile.css</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/mobile.css</p>';
}
$messages[] = $msg;

// create the file editor.css
if (!TCK_File::write($path . '/css/editor.css', $editorcsstext)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /css/editor.css</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /css/editor.css</p>';
}
$messages[] = $msg;


/*--------------------------------
 * --	XML STEP				--
 * -----------------------------*/

// check if there is some logos in the template
$logos_id = array();
$positionsforlang = array();
foreach ($blocs as $i => $bloc) {
	if (isset($bloc->ckmoduleposition)) {
		$positionsforlang[$bloc->ckmoduleposition] = $bloc->ckid;
	}
	if (stristr($bloc->class, 'bannerlogo')) {
		$logos_id[$bloc->ckid] = new stdClass();
		$logos_id[$bloc->ckid]->imgsrc = isset($bloc->blocbackgroundimageurl) ? $bloc->blocbackgroundimageurl : '';
		$logos_id[$bloc->ckid]->height = isset($bloc->logoheight) ? $bloc->logoheight : 'auto';
		$logos_id[$bloc->ckid]->width = isset($bloc->logowidth) ? $bloc->logowidth : '100%';
	}
}

// write the language file .sys.ini
$langbuffer = '';
foreach ($positionsforlang as $positionforlang => $idforlang) {
	$langbuffer .= "TPL_" . strtoupper($templatename) . "_POSITION_" . strtoupper($positionforlang) . "=\"" . str_replace('"', '&quot;', $idforlang) . "\"\n";
}
if (! TCK_Folder::exists($path . '/language/en-GB')) {
		TCK_Folder::create($path . '/language/en-GB');
}
// write the content of the language file
file_put_contents($path . '/language/en-GB/en-GB.tpl_' . $templatename . '.sys.ini', $langbuffer);

// write the language file .ini
$langbuffer = '';
$langbuffer .= "TPL_" . strtoupper($templatename) . "_ERROR_REQUEST=\"Oops! That page can&rsquo;t be found.\"\n";
$langbuffer .= "TPL_" . strtoupper($templatename) . "_SEARCH_FIELD=\"It looks like nothing was found at this location. Maybe try a search?\"\n";
$langbuffer .= "TPL_" . strtoupper($templatename) . "_CONTACT_ADMINISTRATOR=\"If difficulties persist, please contact the System Administrator of this site and report the error 404.\"\n";
$langbuffer .= "TPL_" . strtoupper($templatename) . "_ERROR_MESSAGE=\"Page not found\"\n";

// write the content of the language file
file_put_contents($path . '/language/en-GB/en-GB.tpl_' . $templatename . '.ini', $langbuffer);


// copy the preview images if already exists
/*if (file_exists($templatepath . '/template_preview.png') && (isset($blocs[0]->template_previewsystemimageurl) && !$blocs[0]->template_previewsystemimageurl)) {
	TCK_File::copy($templatepath . '/template_preview.png', $path . '/template_preview.png');
}
if (file_exists($templatepath . '/template_thumbnail.png') && (isset($blocs[0]->template_thumbnailsystemimageurl) && !$blocs[0]->template_thumbnailsystemimageurl)) {
	TCK_File::copy($templatepath . '/template_thumbnail.png', $path . '/template_thumbnail.png');
}*/

// create head lines
$xmltext = '<?xml version="1.0" encoding="utf-8"?>';
if ($joomlaversion == 'j15') {
	$xmltext .= '
<!DOCTYPE install PUBLIC "-//Joomla! 1.5//DTD template 1.0//EN" "https://www.joomla.org/xml/dtd/1.5/template-install.dtd">
<install version="1.5" type="template" method="upgrade">';
} elseif ($joomlaversion == 'j17') {
	$xmltext .= '
<!DOCTYPE install PUBLIC "-//Joomla! 1.7//DTD template 1.0//EN" "https://www.joomla.org/xml/dtd/1.7/template-install.dtd">
<extension version="1.7" type="template" client="site" method="upgrade">';
} elseif ($joomlaversion == 'j25') {
	$xmltext .= '
<!DOCTYPE install PUBLIC "-//Joomla! 2.5//DTD template 1.0//EN" "https://www.joomla.org/xml/dtd/2.5/template-install.dtd">
<extension version="2.5" type="template" client="site" method="upgrade">';
} else {
	$xmltext .= '
<!DOCTYPE install PUBLIC "-//Joomla! 2.5//DTD template 1.0//EN" "https://www.joomla.org/xml/dtd/2.5/template-install.dtd">
<extension version="3.0" type="template" client="site" method="upgrade">';
}

$xmltext .='
	<name>' . $templatename . '</name>
	<generator>Template Creator CK</generator>
	<generatorid>' . $templateid . '</generatorid>
	<identifier>' . $templateidentifier . '</identifier>
	<creationDate>' . $creationdate . '</creationDate>
	<author>' . $author . '</author>
	<authorEmail>' . $authorEmail . '</authorEmail>
	<authorUrl>' . $authorUrl . '</authorUrl>
	<copyright>' . $copyright . '</copyright>
	<license>' . $license . '</license>
	<version>' . $version . '</version>
	<description>' . $description . '</description>

';

// list files to archive
$files = TCK_Folder::files($path, false, false, true);
$folders = TCK_Folder::folders($path, false, false, true);

$xmltext .= "\t<files>\r\n";

$tmppath = str_replace('\\', '/', $path);
foreach ($files as $file) {
	$tmpfile = str_replace('\\', '/', $file);
	$tmpfile = str_replace($tmppath, '', $tmpfile);
	$tmpfile = trim($tmpfile, '/');
	$xmltext .= "\t\t<filename>" . $tmpfile . "</filename>\r\n";
}

foreach ($folders as $folder) {
	$tmpfolder = str_replace('\\', '/', $folder);
	$tmpfolder = str_replace($tmppath, '', $tmpfolder);
	$tmpfolder = trim($tmpfolder, '/');
	$xmltext .= "\t\t<folder>" . $tmpfolder . "</folder>\r\n";
}

$xmltext .= "\t</files>\r\n";

// list all positions
$xmltext .= "\t<positions>\r\n";

foreach ($positions as $position) {
	if ($position)
		$xmltext .= "\t\t<position>" . $position . "</position>\r\n";
}

$xmltext .= "\t</positions>\r\n";

// add the language definition only for the module position translation
$xmltext .= "\t<languages folder=\"language\">\r\n";
$xmltext .= "\t\t<language tag=\"en-GB\">en-GB/en-GB.tpl_" . $templatename . ".sys.ini</language>\n";
$xmltext .= "\t</languages>\r\n";

// add admin params
if ($joomlaversion == 'j15') {
	$openparams = "\t<params>\r\n";
	$openfield = "\t\t<param";
	$closefield = "\t\t</param>\r\n";
	$closeparams = "\t</params>\r\n";
} else {
	$openparams = "\t<config>
		<fields name=\"params\">
			<fieldset name=\"advanced\">\r\n";
	$openfield = "\t\t\t\t<field";
	$closefield = "\t\t\t\t</field>\r\n";
	$closeparams = "\t\t\t</fieldset>
		</fields>
	</config>\r\n";
}

$xmltext .= $openparams;

// save the logo settings in the database
if (count($logos_id)) {
	$query = "SELECT * from #__template_styles WHERE template = '" . $templatename ."'";
	$templateTable = CKFof::dbLoadObject($query);
	$templateExists = ! empty($templateTable);
	if ($templateExists) $templateParams = $templateTable->params;
}

foreach ($logos_id as $id => $logo) {
	$imageurl = explode("/", $logo->imgsrc);
	$imageurl = end($imageurl);
	$imageurl = "templates/" . $templatename . "/images/" . $imageurl;
	$xmltext .= $openfield . " name=\"" . $id . "_spacer\" type=\"spacer\" label=\"-- [ Logo image for " . $id . " ] --\" />\r\n";
	$xmltext .= $openfield . " name=\"" . $id . "_logoimgsrc\" type=\"media\" default=\"\" label=\"Logo image\" description=\"If you want to redirect the page on the logo click\" />\r\n";
	$xmltext .= $openfield . " name=\"" . $id . "_logoheight\" type=\"text\" default=\"" . $logo->height . "\" label=\"Logo height\" description=\"If you want to redirect the page on the logo click\" />\r\n";
	$xmltext .= $openfield . " name=\"" . $id . "_logowidth\" type=\"text\" default=\"" . $logo->width . "\" label=\"Logo width\" description=\"If you want to redirect the page on the logo click\" />\r\n";
	$xmltext .= $openfield . " name=\"" . $id . "_logolink\" type=\"text\" default=\"\" label=\"Logo link\" description=\"If you want to redirect the page on the logo click\" />\r\n";
	$xmltext .= $openfield . " name=\"" . $id . "_logotitle\" type=\"text\" default=\"\" label=\"Logo title\" description=\"Choose the alt tag that will be added to the image\" />\r\n";
	$xmltext .= $openfield . " name=\"" . $id . "_logodescription\" type=\"text\" default=\"\" label=\"Logo description\" description=\"Text that will be added under the logo\" />\r\n";
	
	if (isset($blocsbyname[$id]->uselogodescyes) && $blocsbyname[$id]->uselogodescyes == 'checked') {
		$description = $blocsbyname[$id]->logodesctext;
	} else {
		$description = '';
	}

	if ($templateExists) {
		$params = new \Templatecreatorck\CKRegistry($templateParams);
		$params->set($id . '_logoimgsrc', $imageurl);
		$params->set($id . '_logoheight', $logo->height);
		$params->set($id . '_logowidth', $logo->width);
		$params->set($id . '_logodescription', $description);
		$params = $params->toString();

		$templateTable->params = $params;
		CKFof::dbStore('#__template_styles', $templateTable);
	}

}

$xmltext .= $openfield . " name=\"other_spacer\" type=\"spacer\" label=\"-- [ Other options ] --\" />\r\n";

$xmltext .= $openfield . " name=\"useresponsive\" type=\"radio\" default=\"1\" label=\"Use Responsive mode\" description=\"Adapt your template design for mobile resolutions\" class=\"btn-group\">\r\n"
		. "\t\t\t\t\t\t<option value=\"1\">JYES</option>\r\n"
		. "\t\t\t\t\t\t<option value=\"0\">JNO</option>\r\n"
		. $closefield;

$xmltext .= $openfield . " name=\"errorredirect\" type=\"menuitem\" default=\"\" label=\"Error page redirect\" >\r\n"
		. $closefield;
//if ($joomlaversion == 'j3') {
//	$xmltext .= $openfield . " name=\"usebootstrap\" type=\"radio\" default=\"" . $loadBootstrap . "\" label=\"Load Bootstrap\" description=\"Add the Bootstrap framework into the template\" class=\"btn-group\">\r\n"
//			. "\t\t\t\t\t\t<option value=\"1\">JYES</option>\r\n"
//			. "\t\t\t\t\t\t<option value=\"0\">JNO</option>\r\n"
//			. $closefield;
//}

if ($googleanalytics) {
	$xmltext .= $openfield . " name=\"googleanalyticscode\" type=\"text\" default=\"\" label=\"Google analytics code\" description=\"Add the google analytics into the template. Set it like this : G-xxxxxxxx-x. If you don't want to use it, leave the field blank.\" />\r\n";
}
		
$xmltext .= $closeparams;

// close the file
if ($joomlaversion == 'j15') {
	$xmltext .= '</install>';
} else {
	$xmltext .= '</extension>';
}

// define path to file
$xmldest = $path . '/templateDetails.xml';

// create the file templateDetails.xml
if (!TCK_File::write($xmldest, $xmltext)) {
	$msg = '<p class="error">' . TCK_Text::_('CK_ERROR_CREATING_FILE') . ' /templateDetails.xml</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FILE') . ' /templateDetails.xml</p>';
}
$messages[] = $msg;

/*--------------------------------
 * --	ZIP STEP				--
 * -----------------------------*/

if ($action == 'package') {
	$files = TCK_Folder::files($path, false, true, true);
	$exporter = new ZipArchiver();
	$isSuccess = $exporter->create($files, TEMPLATECREATORCK_PROJECTS_PATH . '/' . $templatename . '.zip', $path, true);

	// return message after creating the zip archive
	if (!$isSuccess && $exporter->getError()) {
		$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_ARCHIVE') . '</p>';
	} else {
		$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_ARCHIVE') . '</p>';
	}

	$messages[] = $msg;

	// create button to download the package
	echo '<p style="padding: 15px;"><a class="ckbutton ckbutton-inverse" target="_blank" href="' . TEMPLATECREATORCK_URI . '/projects/' . $templatename . '.zip">' . TCK_Text::_('CK_DOWNLOAD_TEMPLATE') . '</a></p>';
	echo implode($messages);
	echo implode($ckcreatesteps);
//	echo '<p style="padding: 15px;"><a class="ckbutton ckbutton-inverse" href="' . \Templatecreatorck\CKUri::root() . 'components/com_templateck/projects/' . $templatename . '.zip">' . TCK_Text::_('CK_DOWNLOAD_TEMPLATE') . '</a></p>';

	} else {

/*--------------------------------
 * --	UPDATE STEP				--
 * -----------------------------*/

	// show all messages
	echo '<p styles="padding:15px"><a class="ckbutton ckbutton-inverse" href="' . TEMPLATECREATORCK_URI_ROOT . '/?template=' . $templatename . '&tckedition=1&from=templatecreatorck" target="_blank">' . TCK_Text::_('CK_VIEW_WEBSITE') . '</a></p>';
	if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
		if (TEMPLATECREATORCK_ISJ6) {
			if ($joomlaversion != 'j6') echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
		} else if (TEMPLATECREATORCK_ISJ5) {
			if ($joomlaversion != 'j5') echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
		} else if (TEMPLATECREATORCK_ISJ4) {
			if ($joomlaversion != 'j4') echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
		} else if (TEMPLATECREATORCK_ISJ3) {
			if ($joomlaversion != 'j3') echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
		}
	}
//	if (TEMPLATECREATORCK_PLATFORM == 'joomla' && (TEMPLATECREATORCK_ISJ6 && $joomlaversion != 'j6')) {
//		echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
//	} else if (TEMPLATECREATORCK_PLATFORM == 'joomla' && (TEMPLATECREATORCK_ISJ5 && $joomlaversion != 'j5')) {
//		echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
//	} else if (TEMPLATECREATORCK_PLATFORM == 'joomla' && ((TEMPLATECREATORCK_ISJ4 && $joomlaversion != 'j4'))) {
//		echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
//	} else if (TEMPLATECREATORCK_PLATFORM == 'joomla' && TEMPLATECREATORCK_ISJ3 && !TEMPLATECREATORCK_ISJ4 && $joomlaversion != 'j3') {
//		echo '<p class="badgeck errorck">' . TCK_Text::_('CK_ERROR_JOOMLA_VERSION') . '</p>';
//	}
	echo '<p class="badgeck successck" style="">' . TCK_Text::_('CK_SUCCESS_CREATING_TEMPLATECOPY') . '</p>';
	echo implode($messages);
	echo implode($ckcreatesteps);
	echo '<p styles="padding:15px"><a class="ckbutton ckbutton-inverse" href="' . TEMPLATECREATORCK_URI_ROOT . '/?template=' . $templatename . '&tckedition=1&from=templatecreatorck" target="_blank">' . TCK_Text::_('CK_VIEW_WEBSITE') . '</a></p>';
}



