<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

class CKInterface extends stdClass {

	public $imagespath;

	protected $customfonts;

	function __construct() {
		$this->imagespath = TEMPLATECREATORCK_MEDIA_URI .'/images/interface/';
	}

	public function createLabel($text, $image = false) {
	?>
	<span class="ckoption-label">
		<?php echo TCK_Text::_($text); ?>
	</span>
	<?php
	if ($image) $this->createOptionImage($image);
	}

	public function createOptionImage($image) {
	?>
	<img class="ckoption-icon" src="<?php echo $this->imagespath . $image; ?>" width="16" height="16" />
	<?php
	}

	public function createBlocStyles($prefix = 'bloc', $objclass = '', $expert = false, $showlinks = true, $joomlaversion = 'j3', $showtext = true, $showdimensions = true, $showdecoration = true, $showshadow = true) {
		if (stristr($objclass, 'wrapper')) {
			$this->createBackground($prefix, true);
			if ($prefix == 'bloc')
				$this->createText($prefix);
//			if ($prefix == 'bloc')
				$this->createDimensions($prefix, false, false, false, true);
			$this->createDecoration($prefix);
			$this->createShadow($prefix);
			if ($expert == 'true') $this->createCustom($prefix);
		} elseif (stristr($objclass, 'body')) {
			// $this->createWrapperStyles($prefix, $joomlaversion);
			$this->createBackground($prefix, false, TCK_Text::_('CK_PAGEBACKGROUND'));
			$this->createText($prefix);
			if ($expert == 'true') $this->createCustom($prefix);
		} elseif ($objclass == 'focus') {
			// $this->createWrapperStyles($prefix, $joomlaversion);
//			$this->createBackground($prefix, false);
			$this->createDecoration($prefix);
			$this->createOutline($prefix);
			$this->createShadow($prefix);
			if ($expert == 'true') $this->createCustom($prefix);
		} else {
			$this->createBackground($prefix);
			if ($prefix != 'level1bg' && $prefix != 'level2bg')
				if ($showtext) $this->createText($prefix, $showlinks);
			if ($prefix == 'level1bg' || $prefix == 'level2bg' || $expert == 'true' || (stristr($objclass, 'bannerlogo') && !stristr($objclass, 'mainbanner')) && (!stristr($objclass, 'column') && !stristr($objclass, 'flexiblemodule'))) {
				$useheight = true;
				$usewidth = true;
			} else {
				$useheight = false;
				$usewidth = false;
			}
			if ($showdimensions) $this->createDimensions($prefix, $useheight, $usewidth, $expert);
			if ($showdecoration) $this->createDecoration($prefix);
			if ($showshadow) $this->createShadow($prefix);
			if ($expert == 'true') $this->createCustom($prefix);
		}
	}

	public function createIconStyles($prefix = 'bloc', $fromicon = '', $objclass = '', $space = true, $align = true, $font = false, $removebutton = false) {
		$this->createIcon($prefix, $fromicon, $space, $align, $font, true, $removebutton);
		// $this->createIconText($prefix, false);
		$this->createBackground($prefix);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
	}

	public function createImageStyles($prefix = 'bloc', $objclass = '', $fromicon = '') {
		$this->createDimensions($prefix, true, true);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
	}

	public function createNormalStyles($prefix, $showlinks = true) {
		$this->createBackground($prefix);
		$this->createText($prefix, $showlinks);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
		$this->createCustom($prefix);
	}

	public function createLogoStyles($prefix) {
		$this->createLogo($prefix);
	}

	public function createModuleStyles($prefix = 'module') {
		$this->createBackground($prefix);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
	}

	public function createModuletitleStyles($prefix = 'moduletitle') {
		$this->createBackground($prefix);
		$this->createText($prefix, false);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
	}

	public function createBullet($prefix) {
		$this->renderbulletlist($prefix,'default');
		$this->renderbulletlist($prefix,'none');
		$this->renderbulletlist($prefix,'disc');
		$this->renderbulletlist($prefix,'circle');
		$this->renderbulletlist($prefix,'square');
		$this->renderbulletlist($prefix,'upper-roman');
		$this->renderbulletlist($prefix,'lower-alpha');
		$this->renderbulletlist($prefix,'upper-latin');
		$this->renderbulletlist($prefix,'decimal');
		$this->renderbulletlist($prefix,'image');
		?>
		<div class="ckclr"></div>
		<?php
		$this->createText($prefix, true);
		$this->createDimensions($prefix);
		?>
		<input type="hidden" class="inputbox" name="<?php echo $prefix; ?>liststyle" id="<?php echo $prefix; ?>liststyle" />
		<script>
		function initBulletlist() {
			$ck('.bulletlistselect[data-type="'+$ck('#<?php echo $prefix; ?>liststyle').val()+'"]').addClass('selected');
		}
		function selectBulletlist(ul) {
			$ck('.bulletlistselect.selected').removeClass('selected');
			$ck(ul).addClass('selected');
			$ck('#<?php echo $prefix; ?>liststyle').val($ck(ul).attr('data-type'));
			ckRenderCss('previewareabloc', $ck('#ckedition'), '#body');
		}
		</script>
		<?php
	}
	
	public function renderbulletlist($prefix, $type) {
		?>
		<div class="bulletlistselect" data-type="<?php echo $type ?>" onclick="selectBulletlist(this)" >
			<div class="bulletlisttitle"><?php echo $type ?></div>
			<ul class="bulletlistselectul" style="list-style-type:<?php echo $type ?>" >
				<li>List item</li>
				<li>List item</li>
				<li>List item</li>
				<li>List item</li>
			</ul>
			<?php
			if ($type == 'image') { ?>
				<div style="text-align:left;">
					<a style="display:block;float:left;padding:0 5px;width:85px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>imageurl')" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
					<a style="display:block;float:left;padding:0 5px;width:45px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $prefix; ?>imageurl').attr('value', '');"><?php echo TCK_Text::_('CK_CLEAN'); ?></a>
					<div class="ckclr"></div>
					<input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>imageurl" id="<?php echo $prefix; ?>imageurl" size="7" style="width:150px; clear:both;" onchange="selectBulletlist($ck(this).parents('.bulletlistselect')[0])" />
				</div>
			<?php }
			?>
		</div>
		<?php
	}

	public function createDivider($prefix = 'divider') {
		$pos = array('', '-2');
		foreach ($pos as $p) {
		$prefix = $prefix . $p;
		$heading = ($p == '-2') ? TCK_Text::_('CK_BOTTOM_SHAPE') : TCK_Text::_('CK_TOP_SHAPE');
		$position = ($p == '-2') ? 'bottom' : 'top';
		?>
		<div data-quickid="<?php echo $prefix; ?>divider">
		<div class="ckinterfacetitle"><?php echo $heading ?></div>
		<div class="ckoption ckoption-inline">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_SHAPE'); ?>
			</span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>shape" id="<?php echo $prefix; ?>shape" value="" style="width:111px;" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')"  data-quicktargetgroup="<?php echo $prefix; ?>divider">
					<option value="0"><?php echo TCK_Text::_('CK_NONE'); ?></option>
					<option value="clouds"><?php echo TCK_Text::_('CK_CLOUDS'); ?></option>
					<option value="multiclouds"><?php echo TCK_Text::_('CK_MULIPLE_CLOUDS'); ?></option>
					<option value="papertorn"><?php echo TCK_Text::_('CK_PAPER'); ?></option>
					<option value="bridge"><?php echo TCK_Text::_('CK_BRIDGE'); ?></option>
					<option value="rockymoutain"><?php echo TCK_Text::_('CK_MOUNTAIN'); ?></option>
					<option value="singlewave"><?php echo TCK_Text::_('CK_WAVE'); ?></option>
					<option value="waves3"><?php echo TCK_Text::_('CK_MULTIPLE_WAVE'); ?></option>
					<option value="slope"><?php echo TCK_Text::_('CK_SLOPE'); ?></option>
					<option value="multislope"><?php echo TCK_Text::_('CK_MULIPLE_SLOPE'); ?></option>
					<option value="drip"><?php echo TCK_Text::_('CK_DRIP'); ?></option>
					<option value="asymslope"><?php echo TCK_Text::_('CK_ASYM_SLOPE'); ?></option>
					<option value="vslope"><?php echo TCK_Text::_('CK_VSLOPE'); ?></option>
					<option value="vslopeinverse"><?php echo TCK_Text::_('CK_VSLOPE') . ' ' . TCK_Text::_('CK_INVERSE'); ?></option>
					<option value="multivslope"><?php echo TCK_Text::_('CK_MULTIVSLOPE'); ?></option>
					<option value="multiv3slope"><?php echo TCK_Text::_('CK_MULTIV3SLOPE'); ?></option>
					<option value="triangle"><?php echo TCK_Text::_('CK_TRIANGLE'); ?></option>
					<option value="triangleinverse"><?php echo TCK_Text::_('CK_TRIANGLE') . ' ' . TCK_Text::_('CK_INVERSE'); ?></option>
					<option value="trianglesmall"><?php echo TCK_Text::_('CK_TRIANGLE_SMALL'); ?></option>
					<option value="triangle3"><?php echo TCK_Text::_('CK_TRIANGLE_3'); ?></option>
					<option value="ellipse"><?php echo TCK_Text::_('CK_ELLIPSE'); ?></option>
					<option value="ellipseinverse"><?php echo TCK_Text::_('CK_ELLIPSE') . ' ' . TCK_Text::_('CK_INVERSE'); ?></option>
					<option value="book"><?php echo TCK_Text::_('CK_BOOK'); ?></option>
					<option value="bubbles"><?php echo TCK_Text::_('CK_BUBBLES'); ?></option>
					<option value="trees"><?php echo TCK_Text::_('CK_TREES'); ?></option>
					<option value="city"><?php echo TCK_Text::_('CK_CITY'); ?></option>
					<option value="fallleaves"><?php echo TCK_Text::_('CK_FALL_LEAVES'); ?></option>
					<option value="fire"><?php echo TCK_Text::_('CK_FIRE'); ?></option>
					<option value="sphere"><?php echo TCK_Text::_('CK_SPHERE'); ?></option>
					<option value="music"><?php echo TCK_Text::_('CK_MUSIC'); ?></option>
					<option value="paint"><?php echo TCK_Text::_('CK_PAINT'); ?></option>
					<option value="pyramid"><?php echo TCK_Text::_('CK_PYRAMID'); ?></option>
					<option value="snowflakes"><?php echo TCK_Text::_('CK_SNOWFLAKES'); ?></option>
					<option value="butterfly"><?php echo TCK_Text::_('CK_BUTTERFLY'); ?></option>
					<option value="animated_waves"><?php echo TCK_Text::_('CK_ANIMATED_WAVES'); ?></option>
				</select>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption ckoption-inline">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_COLOR'); ?>
			</span>
			<span class="ckoption-field">

				<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" size="6" style="width:52px;" onblur="ckUpdateShapeDivider('<?php echo $prefix; ?>')"/>
				<span class="ckoption-suffix"></span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption ckoption-inline">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_SECOND_COLOR'); ?>
				</span>
			<span class="ckoption-field">

				<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>bgcolor" id="<?php echo $prefix; ?>bgcolor" size="6" style="width:52px;" onblur="ckUpdateShapeDivider('<?php echo $prefix; ?>')"/>
				<span class="ckoption-suffix"></span>
			</span>
			<div class="clr"></div>
		</div>

		<input class="" type="hidden" name="<?php echo $prefix; ?>position" id="<?php echo $prefix; ?>position" value="<?php echo $position ?>" /> 
		<div class="ckoption ckoption-inline">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_FLIP_HORIZONTAL'); ?>
			</span>
			<span class="ckoption-field">
				<span class="ckoption-field ckbutton-group">
					<input type="radio" class="inputbox" name="<?php echo $prefix; ?>fliphorizontal" id="<?php echo $prefix; ?>fliphorizontal1" value="1" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')" />
					<label for="<?php echo $prefix; ?>fliphorizontal1" class="ckbutton"><?php echo TCK_Text::_('CK_YES') ?></label>
					<input type="radio" class="inputbox" name="<?php echo $prefix; ?>fliphorizontal" id="<?php echo $prefix; ?>fliphorizontal0" value="0" checked onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')"/>
					<label for="<?php echo $prefix; ?>fliphorizontal0" class="ckbutton"><?php echo TCK_Text::_('CK_NO') ?></label>
				</span>
			</span>
			<div class="ckclr"></div>
		</div>
		
		
		<div class="ckoption ckoption-inline">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_FLIP_VERTICAL'); ?>
			</span>
			<span class="ckoption-field">
				<span class="ckoption-field ckbutton-group">
					<input type="radio" class="inputbox" name="<?php echo $prefix; ?>flipvertical" id="<?php echo $prefix; ?>flipvertical1" value="1" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')" />
					<label for="<?php echo $prefix; ?>flipvertical1" class="ckbutton"><?php echo TCK_Text::_('CK_YES') ?></label>
					<input type="radio" class="inputbox" name="<?php echo $prefix; ?>flipvertical" id="<?php echo $prefix; ?>flipvertical0" value="0" checked onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')"/>
					<label for="<?php echo $prefix; ?>flipvertical0" class="ckbutton"><?php echo TCK_Text::_('CK_NO') ?></label>
				</span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption ckoption-inline">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_PLACEMENT'); ?>
			</span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>placement" id="<?php echo $prefix; ?>placement" value="" style="width:111px;" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')" >
					<option value="over"><?php echo TCK_Text::_('CK_OVER_CONTENT'); ?></option>
					<option value="under"><?php echo TCK_Text::_('CK_UNDER_CONTENT'); ?></option>
				</select>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo TCK_Text::_('CK_HEIGHT'); ?></span>
			<span class="ckoption-field">

				<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>height" name="<?php echo $prefix; ?>height" min="0" max="500" value="150" step="1" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')">
				<label for="<?php echo $prefix; ?>height"></label> px
				<span class="ckoption-suffix"></span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo TCK_Text::_('CK_WIDTH'); ?></span>
			<span class="ckoption-field">
				<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>width" name="<?php echo $prefix; ?>width" min="100" max="300" value="100" step="1" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')">
				<label for="<?php echo $prefix; ?>width"></label> %
				<span class="ckoption-suffix"></span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo TCK_Text::_('CK_OFFSET_HORIZONTAL'); ?></span>
			<span class="ckoption-field">
				<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>offseth" name="<?php echo $prefix; ?>offseth" min="-100" max="100" value="0" step="1" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')">
				<label for="<?php echo $prefix; ?>offseth"></label> %
				<span class="ckoption-suffix"></span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo TCK_Text::_('CK_OFFSET_VERTICAL'); ?></span>
			<span class="ckoption-field">
				<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>offsetv" name="<?php echo $prefix; ?>offsetv" min="-200" max="200" value="0" step="1" onchange="ckUpdateShapeDivider('<?php echo $prefix; ?>')">
				<label for="<?php echo $prefix; ?>offsetv"></label> px
				<span class="ckoption-suffix"></span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckclr"></div>
		</div>
		<?php
		}
	}

	function createVideobgStyles($prefix = 'bloc') {
		?>
		<div data-quickid="<?php echo $prefix; ?>videobg">
			<div><?php echo TCK_Text::_('CK_VIDEO_URL_INFOS'); ?></div>
			<div class="clearfix">
				<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_VIDEO_URL_MP4'); ?></div>
				<div style="float:left;text-align:right;margin-right:5px;margin-top:5px;"><img src="<?php echo $this->imagespath; ?>film_plus.png" width="16" height="16" align="top" /></div>
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>videourlmp4" id="<?php echo $prefix; ?>videourlmp4" size="1" value="" style="width:200px;" data-quicktargetgroup="<?php echo $prefix; ?>videobg"/>
				<a style="display:inline-block;padding:0 5px;width:85px;" class=" ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>videourlmp4', 'video');" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
			</div>
			<div class="clearfix">
				<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_VIDEO_URL_WEBM'); ?></div>
				<div style="float:left;text-align:right;margin-right:5px;margin-top:5px;"><img src="<?php echo $this->imagespath; ?>film_plus.png" width="16" height="16" align="top" /></div>
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>videourlwebm" id="<?php echo $prefix; ?>videourlwebm" size="1" value="" style="width:200px;" data-quicktargetgroup="<?php echo $prefix; ?>videobg"/>
				<a style="display:inline-block;padding:0 5px;width:85px;" class=" ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>videourlwebm', 'video');" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
			</div>
			<div class="clearfix">
				<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_VIDEO_URL_OGV'); ?></div>
				<div style="float:left;text-align:right;margin-right:5px;margin-top:5px;"><img src="<?php echo $this->imagespath; ?>film_plus.png" width="16" height="16" align="top" /></div>
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>videourlogv" id="<?php echo $prefix; ?>videourlogv" size="1" value="" style="width:200px;" data-quicktargetgroup="<?php echo $prefix; ?>videobg"/>
				<a style="display:inline-block;padding:0 5px;width:85px;" class=" ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>videourlogv', 'video');" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
			</div>
			<div class="ckoption">
				<span class="ckoption-label ckinterfacetitle">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>sound.png" width="16" height="16" />
					<?php echo TCK_Text::_('CK_AUDIO'); ?>
				</span>
				<span class="ckoption-field ckbutton-group">
					<input id="<?php echo $prefix; ?>videomuted1" class="inputbox" name="<?php echo $prefix; ?>videomuted" value="1" type="radio">
					<label class="ckbutton" for="<?php echo $prefix; ?>videomuted1">
					<?php echo TCK_Text::_('CK_YES'); ?>
					</label>
					<input id="<?php echo $prefix; ?>videomuted0" class="inputbox" name="<?php echo $prefix; ?>videomuted" value="0" type="radio" checked>
					<label class="ckbutton" for="<?php echo $prefix; ?>videomuted0">
					<?php echo TCK_Text::_('CK_NO'); ?>
					</label>
				</span>
				<div class="ckclr"></div>
			</div>
			<div class="clearfix">
				<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_VIDEO_POSTER'); ?></div>
				<div style="float:left;text-align:right;margin-right:5px;margin-top:5px;"><img src="<?php echo $this->imagespath; ?>image.png" width="16" height="16" align="top" /></div>
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>videoposter" id="<?php echo $prefix; ?>videoposter" size="1" value="" style="width:200px;" data-quicktargetgroup="<?php echo $prefix; ?>videobg"/>
				<a style="display:inline-block;padding:0 5px;width:85px;" class=" ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>videoposter', 'image');" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
			</div>
			<hr/>
			<div class="ckoption">
				<div class="clearfix">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_YOUTUBE_VIDEO_URL'); ?></div>
					<div style="float:left;text-align:right;margin-right:5px;margin-top:5px;"><img src="<?php echo $this->imagespath; ?>film_plus.png" width="16" height="16" align="top" /></div>
					<input class="inputbox" type="text" name="<?php echo $prefix; ?>videourlyoutube" id="<?php echo $prefix; ?>videourlyoutube" size="1" value="" style="width:200px;" />
				</div>
			</div>
			<div class="ckoption">
				<div class="clearfix">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_YOUTUBE_RATIO'); ?></div>
					<div style="float:left;text-align:right;margin-right:5px;margin-top:5px;"><img src="<?php echo $this->imagespath; ?>height.png" width="16" height="16" align="top" /></div>
					<input class="inputbox" type="text" placeholder="56.3%" name="<?php echo $prefix; ?>ratioyoutube" id="<?php echo $prefix; ?>ratioyoutube" size="1" value="" style="width:50px;" />
				</div>
			</div>
			<div class="ckclr"></div>
		</div>
		<?php
	}

	public function createIconOptions($prefix, $fromicon, $space = true, $align = true) {
	?>
		<div class="ckquickstyle-hide">
		<div style="resize:vertical;">
			<a href="<?php echo TEMPLATECREATORCK_ADMIN_URL ?>&view=icons" rel="{handler: 'iframe'}" class="modal ckbuttonstyle"><?php echo TCK_Text::_('CK_SELECT'); ?></a>
			<a href="javascript:void(0);" class="ckbuttonstyle" onclick="ckRemoveFaIcon('<?php echo $fromicon ?>')"><?php echo TCK_Text::_('CK_CLEAN'); ?></a>
		</div>
		<fieldset id="fontawesomefieldset">
			<legend><?php echo TCK_Text::_('CK_FONTAWESOME_ICON'); ?></legend>
			<?php if ((TEMPLATECREATORCK_ISJ4 || TEMPLATECREATORCK_ISJ5) && 0 === 1) { //add condition to disable it until it works correctly ?>
			<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_ICON_CLASS'); ?></div>
			<div><input type="text" id="<?php echo $prefix; ?>icon_cssclass" name="<?php echo $prefix; ?>icon_cssclass" placeholder="fa fack-eye" onchange="ckSetFaIconCssClass()" /></div>
			<?php } ?>
			<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_ICON_SIZE'); ?></div>
			<div style="margin:5px 0 0 0px;">
				<select id="<?php echo $prefix; ?>iconsize" name="<?php echo $prefix; ?>iconsize" class="inputbox" onchange="ckSetFaIconSize()">
					<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
					<option value="fack-lg"><?php echo TCK_Text::_('CK_ICON_SIZE_X1-3'); ?></option>
					<option value="fack-2x"><?php echo TCK_Text::_('CK_ICON_SIZE_X2'); ?></option>
					<option value="fack-3x"><?php echo TCK_Text::_('CK_ICON_SIZE_X3'); ?></option>
					<option value="fack-4x"><?php echo TCK_Text::_('CK_ICON_SIZE_X4'); ?></option>
					<option value="fack-5x"><?php echo TCK_Text::_('CK_ICON_SIZE_X5'); ?></option>
				</select>
			</div>
			<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_ICON_POSITION'); ?></div>
			<div style="margin:5px 0 0 0px;">
				<select id="<?php echo $prefix; ?>iconposition" name="<?php echo $prefix; ?>iconposition" class="inputbox" onchange="ckSetFaIconPosition()">
					<option value="left"><?php echo TCK_Text::_('CK_LEFT'); ?></option>
					<option value="top"><?php echo TCK_Text::_('CK_TOP'); ?></option>
					<option value="right"><?php echo TCK_Text::_('CK_RIGHT'); ?></option>
					<option value="bottom"><?php echo TCK_Text::_('CK_BOTTOM'); ?></option>
				</select>
			</div>
			<?php if ($align) { ?>
			<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_VERTICAL_ALIGN'); ?></div>
			<div id="<?php echo $prefix; ?>icon-position" class="btn-group">
				<select id="<?php echo $prefix; ?>iconvposition" name="<?php echo $prefix; ?>iconvposition" class="inputbox" onchange="ckSetFaIconVPosition()">
					<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
					<option value="top"><?php echo TCK_Text::_('CK_TOP'); ?></option>
					<option value="middle"><?php echo TCK_Text::_('CK_MIDDLE'); ?></option>
					<option value="bottom"><?php echo TCK_Text::_('CK_BOTTOM'); ?></option>
				</select>
			</div>
			<?php } ?>
			<?php if ($space) { ?>
			<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_ICON_MARGIN'); ?></div>
			<input type="text" id="<?php echo $prefix; ?>icon_margin" name="<?php echo $prefix; ?>icon_margin" placeholder="Ex : 10px" onchange="ck_set_icon_margin('<?php echo $fromicon ?>', '#<?php echo $prefix; ?>icon_margin')" />
			<?php
			}
			?>
		</fieldset>
		</div>
		<?php
	}

	public function createIcon($prefix, $fromicon, $space = true, $align = true, $font = false) {
		?>
		<input type="hidden" class="inputbox" name="<?php echo $prefix; ?>icontype" id="<?php echo $prefix; ?>icontype" />
		<div class="ckinterfaceblock ckquickstyle-hide">
			<div class="ckinterfaceblocktitle"><?php echo TCK_Text::_('CK_ICON') ?></div>
			<div class="ckinterfaceblockaccordion">
				<div class="ckinterfacecolumn">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_ICON'); ?></div>
					<?php $this->createIconOptions($prefix, $fromicon, $space, $align); ?>
				</div>
				<?php if ($font) { ?>
				<div id="fontawesomefieldsetoptions" class="ckinterfacecolumn" style="margin-left:10px;">
					<div style="float:left;">
						<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_COLOR'); ?></div>
						<div>
							<div style="float:left;"><input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" size="6" style="width:52px;"/></div><div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
					</div>
					<div style="float:left;">
						<div  style="" class="ckinterfacetitle"><?php echo TCK_Text::_('CK_SIZE'); ?></div>
						<div style="clear:both;">
							<input class="inputbox" style="width: 40px;" name="<?php echo $prefix; ?>fontsize" id="<?php echo $prefix; ?>fontsize" />
						</div>
					</div>
				</div>
				<?php } ?>
				<div style="clear:both;"></div>
				<fieldset id="iconsvgfieldset">
					<legend><?php echo TCK_Text::_('CK_SVG_ICON'); ?></legend>
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_SIZE'); ?></div>
					<div>
						<input type="range" class="inputbox ckrangeinputupdate" id="<?php echo $prefix; ?>iconsvgsize" name="<?php echo $prefix; ?>iconsvgsize" min="8" max="200" value="24" step="4" onchange="ckSetSvgIconSize()">
						<label for="<?php echo $prefix; ?>iconsvgsize"></label> px
					</div>
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_STROKE'); ?></div>
					<div>
						<input type="range" class="inputbox ckrangeinputupdate" id="<?php echo $prefix; ?>iconsvgstroke" name="<?php echo $prefix; ?>iconsvgstroke" min="0" max="3" value="2" step="0.2" onchange="ckSetSvgIconStroke()">
						<label for="<?php echo $prefix; ?>iconsvgstroke"></label> px
					</div>
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_COLOR'); ?></div>
					<div>
						<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>iconsvgstrokecolor" id="<?php echo $prefix; ?>iconsvgstrokecolor" onblur="ckSetSvgIconStrokeColor()" style="width:52px;"/>
						<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						<?php echo TCK_Text::_('CK_STROKE'); ?>
					</div>
					<div>
						<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>iconsvgfillcolor" id="<?php echo $prefix; ?>iconsvgfillcolor" onblur="ckSetSvgIconFillColor()" style="width:52px;"/>
						<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						<?php echo TCK_Text::_('CK_FILL'); ?>
					</div>
					<div class="ckresponsive-hide">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_ICON_POSITION'); ?></div>
					<div style="margin:5px 0 0 0px;">
						<select id="<?php echo $prefix; ?>iconsvgposition" name="<?php echo $prefix; ?>iconsvgposition" class="inputbox" onchange="ckSetSvgIconPosition()">
							<option value="left"><?php echo TCK_Text::_('CK_LEFT'); ?></option>
							<option value="top"><?php echo TCK_Text::_('CK_TOP'); ?></option>
							<option value="right"><?php echo TCK_Text::_('CK_RIGHT'); ?></option>
							<option value="bottom"><?php echo TCK_Text::_('CK_BOTTOM'); ?></option>
						</select>
					</div>
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_VERTICAL_ALIGN'); ?></div>
					<div id="<?php echo $prefix; ?>iconsvg-vposition" class="btn-group">
						<select id="<?php echo $prefix; ?>iconsvgvposition" name="<?php echo $prefix; ?>iconsvgvposition" class="inputbox" onchange="ckSetSvgIconVPosition()">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="top"><?php echo TCK_Text::_('CK_TOP'); ?></option>
							<option value="middle"><?php echo TCK_Text::_('CK_MIDDLE'); ?></option>
							<option value="bottom"><?php echo TCK_Text::_('CK_BOTTOM'); ?></option>
						</select>
					</div>
					</div>
				</fieldset>
			</div>
		</div>
		<?php
	}

	public function createCustom($prefix) {
		?>
		<div class="ckinterfaceblock">
			<div class="ckinterfaceblocktitle"><?php echo TCK_Text::_('CK_CUSTOMCSS') ?></div>
			<div class="ckinterfaceblockaccordion">
				<div style="text-align:left;margin: 5px 0;"><?php echo TCK_Text::_('CK_CUSTOMCSS_INFOS') ?></div>
				<div style="text-align:left;clear:both;">
					<textarea class="inputbox" name="<?php echo $prefix; ?>custom" id="<?php echo $prefix; ?>custom" rows="7" cols="20" style="width:95%;height:110px;resize:vertical;"></textarea>
				</div>
			</div>
		</div>
		<?php
	}

	public function createAnimations($prefix) {
	?>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hourglass.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_DURATION'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>animdur" id="<?php echo $prefix; ?>animdur" value="1" style="width:105px;" onchange="" /> [s]
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hourglass.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_DELAY'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>animdelay" id="<?php echo $prefix; ?>animdelay" value="0" style="width:105px;" onchange="" /> [s]
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label ckinterfacetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shading.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_FADE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animfadeyes" class="inputbox" name="<?php echo $prefix; ?>animfade" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animfadeyes">
				<?php echo TCK_Text::_('CK_YES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animfadeno" class="inputbox" name="<?php echo $prefix; ?>animfade" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animfadeno">
				<?php echo TCK_Text::_('CK_NO'); ?>
				</label>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label ckinterfacetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_square_go.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_MOVE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animmoveyes" class="inputbox" name="<?php echo $prefix; ?>animmove" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animmoveyes">
				<?php echo TCK_Text::_('CK_YES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animmoveno" class="inputbox" name="<?php echo $prefix; ?>animmove" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animmoveno">
				<?php echo TCK_Text::_('CK_NO'); ?>
				</label>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo TCK_Text::_('CK_DIRECTION'); ?>
			</span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>animmovedir" id="<?php echo $prefix; ?>animmovedir" value="" style="width:111px;" onchange="" >
					<option value="ltrck"><?php echo TCK_Text::_('CK_LEFT_TO_RIGHT'); ?></option>
					<option value="rtlck"><?php echo TCK_Text::_('CK_RIGHT_TO_LEFT'); ?></option>
					<option value="ttbck"><?php echo TCK_Text::_('CK_TOP_TO_BOTTOM'); ?></option>
					<option value="bttck"><?php echo TCK_Text::_('CK_BOTTOM_TO_TOP'); ?></option>
				</select>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo TCK_Text::_('CK_DISTANCE'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>animmovedist" id="<?php echo $prefix; ?>animmovedist" value="40" style="width:55px;" onchange="" />
				<span class="ckoption-suffix">[px]</span>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label ckinterfacetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_rotate_clockwise.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_ROTATE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animrotyes" class="inputbox" name="<?php echo $prefix; ?>animrot" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animrotyes">
				<?php echo TCK_Text::_('CK_YES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animrotno" class="inputbox" name="<?php echo $prefix; ?>animrot" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animrotno">
				<?php echo TCK_Text::_('CK_NO'); ?>
				</label>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo TCK_Text::_(''); ?></span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>animrotrad" id="<?php echo $prefix; ?>animrotrad" value="" style="width:105px;" onchange="" >
					<option value="45">45Â°</option>
					<option value="90">90Â°</option>
					<option value="180">180Â°</option>
					<option value="270">270Â°</option>
					<option value="360">360Â°</option>
				</select>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label ckinterfacetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_handles.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_SCALE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animscaleyes" class="inputbox" name="<?php echo $prefix; ?>animscale" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animscaleyes">
				<?php echo TCK_Text::_('CK_YES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animscaleno" class="inputbox" name="<?php echo $prefix; ?>animscale" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animscaleno">
				<?php echo TCK_Text::_('CK_NO'); ?>
				</label>
			</span>
			<div class="ckclr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label ckinterfacetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>control_repeat.png" width="16" height="16" />
				<?php echo TCK_Text::_('CK_REPLAY_ANIMATION'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animreplayyes" class="inputbox" name="<?php echo $prefix; ?>animreplay" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animreplayyes">
				<?php echo TCK_Text::_('CK_YES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animreplayno" class="inputbox" name="<?php echo $prefix; ?>animreplay" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animreplayno">
				<?php echo TCK_Text::_('CK_NO'); ?>
				</label>
			</span>
			<div class="ckclr"></div>
		</div>
		<div style="text-align:center;">
			<a class="ckbutton" href="javascript:void(0)" onclick="ckPlayAnimationPreview()"><i class="icon icon-play"></i><?php echo TCK_Text::_('CK_PLAY_ANIMATION'); ?></a>
		</div>
		<div class="ckclr"></div>
	<?php
	}

	public function createWrapperStyles($prefix, $joomlaversion) {
		?>
		<?php /*<div class="ckinterfaceblock">
			<div class="ckinterfaceblocktitle"><?php echo TCK_Text::_('CK_WRAPPER_PARAMS') ?></div>
			<div class="ckinterfaceblockaccordion"> */?>
				<div class="ckoption">
					<?php $this->createLabel('CK_WRAPPER_WIDTH', 'width.png') ?>
					<span class="ckoption-field">
						<input class="inputbox ckhastip" type="text" title="<?php echo TCK_Text::_('CK_WRAPPER_WIDTH_DESC'); ?>" name="<?php echo $prefix; ?>width" id="<?php echo $prefix; ?>width" value="" />
					</span>
				</div>
				<div class="ckoption">
					<?php $this->createLabel('CK_WRAPPER_FLUID', 'width.png') ?>
					<span class="ckoption-field">
						<select class="inputbox" type="list" name="<?php echo $prefix; ?>wrapperfluid" id="<?php echo $prefix; ?>wrapperfluid" >
							<option value="fluid"><?php echo TCK_Text::_('CK_FLUID'); ?></option>
							<option value="fixed"><?php echo TCK_Text::_('CK_FIXED'); ?></option>
						</select>
					</span>
				</div>
				<?php if ($joomlaversion == 'j3' || $joomlaversion == 'j4' || $joomlaversion == 'j5' || $joomlaversion == 'j6' ) { ?>
				<div class="ckoption">
					<?php $this->createLabel('CK_LOAD_BOOTSTRAP', 'add.png') ?>
					<span class="ckoption-field">
						<select class="inputbox cksmall" type="list" name="<?php echo $prefix; ?>loadboostrap" id="<?php echo $prefix; ?>loadboostrap" >
							<option value="0"><?php echo TCK_Text::_('CK_NO'); ?></option>
							<option value="1"><?php echo TCK_Text::_('CK_YES'); ?></option>
						</select>
					</span>
				</div>
				<?php } else { ?>
					<input class="inputbox" type="hidden" name="<?php echo $prefix; ?>loadboostrap" id="<?php echo $prefix; ?>loadboostrap" value="0" />
				<?php } ?>
				<div class="ckoption">
					<?php $this->createLabel('CK_LOAD_FONTAWESOME', 'add.png') ?>
					<span class="ckoption-field">
						<select class="inputbox" type="list" name="<?php echo $prefix; ?>loadfontawesome" id="<?php echo $prefix; ?>loadfontawesome" >
							<option value="1"><?php echo TCK_Text::_('CK_YES'); ?></option>
							<option value="2"><?php echo TCK_Text::_('CK_AUTO'); ?></option>
							<option value="0"><?php echo TCK_Text::_('CK_NO'); ?></option>
						</select>
					</span>
				</div>
				<div class="ckoption">
					<?php $this->createLabel('CK_GOOGLEANALYTICS', 'chart_line.png') ?>
					<span class="ckoption-field">
						<select class="inputbox cksmall" type="list" name="<?php echo $prefix; ?>loadgoogleanalytics" id="<?php echo $prefix; ?>loadgoogleanalytics" >
							<option value="0"><?php echo TCK_Text::_('CK_NO'); ?></option>
							<option value="1"><?php echo TCK_Text::_('CK_YES'); ?></option>
						</select>
					</span>
				</div>
				<div class="ckoption">
					<?php $this->createLabel('CK_HIDEFRONTPAGE', 'application_home.png') ?>
					<span class="ckoption-field">
						<select class="inputbox cksmall" type="list" name="<?php echo $prefix; ?>hidefrontpage" id="<?php echo $prefix; ?>hidefrontpage" value="0" >
							<option value="0"><?php echo TCK_Text::_('CK_NO'); ?></option>
							<option value="1"><?php echo TCK_Text::_('CK_YES'); ?></option>
						</select>
					</span>
				</div>
				<div class="ckclr"></div>
			<?php /*</div>
		</div> */ ?>
		<?php
	}

	public function createLogo($prefix, $usegradient = true, $title = '') {
		?>
			<div >
				<div style="padding:5px;">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_LOGO'); ?></div>
					<div style="">
						<div style="margin-left:10px;">
							<img src="<?php echo $this->imagespath; ?>logo_illustration.png" width="65" height="40"/>
						</div>
						<div style="text-align:left;">
							<a style="display:block;float:left;padding:0 5px;width:85px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>backgroundimageurl');" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
							<a style="display:block;float:left;padding:0 5px;width:45px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $prefix; ?>backgroundimageurl').attr('value', '');ckRenderCss();"><?php echo TCK_Text::_('CK_CLEAN'); ?></a>
							<div class="ckclr"></div>
							<input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>backgroundimageurl" id="<?php echo $prefix; ?>backgroundimageurl" size="7" style="width:220px; clear:both;" />
						</div>

					</div>
				</div>
				<div class="ckinterfacecolumn" style="width:50%">
				<div class="ckoption">
					<?php $this->createLabel('CK_WIDTH', 'width.png') ?>
					<span class="ckoption-field">
						<input class="inputbox" type="text" name="logowidth" id="logowidth" size="2" value="" />
					</span>
				</div>
				</div>
				<div class="ckinterfacecolumn" style="width:50%">
				<div class="ckoption">
					<?php $this->createLabel('CK_HEIGHT', 'height.png') ?>
					<span class="ckoption-field">
						<input class="inputbox" type="text" name="logoheight" id="logoheight" size="2" value="" />
					</span>
				</div>
				</div>
				<div class="ckoption">
					<?php $this->createLabel('CK_ALIGN') ?>
					<span class="ckoption-field ckbutton-group">
						<input type="radio" class="logodesc inputbox" value="left" id="logoalignleft" name="logoalign" />
						<label class="ckbutton" for="logoalignleft"><img src="<?php echo $this->imagespath; ?>text_align_left.png" width="16" height="16" />
						</label><input type="radio" class="logodesc inputbox" value="center" id="logoaligncenter" name="logoalign" />
						<label class="ckbutton"  for="logoaligncenter"><img src="<?php echo $this->imagespath; ?>text_align_center.png" width="16" height="16" />
						</label><input type="radio" class="logodesc inputbox" value="1" id="logoalignright" name="logoalign" />
						<label class="ckbutton"  for="logoalignright"><img src="<?php echo $this->imagespath; ?>text_align_right.png" width="16" height="16" />
						</label>
					</span>
					<div class="ckclr"></div>
				</div>
				<div class="ckoption">
					<span class="ckoption-label">
						<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
						<?php echo TCK_Text::_('CK_LOGO_ALT'); ?></span>
					<span class="ckoption-field">
						<input class="inputbox" type="text" name="logoalt" id="logoalt" value="" />
					</span>
					<div class="ckclr"></div>
				</div>
				<div class="ckoption">
					<span class="ckoption-label">
						<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>link.png" width="16" height="16" />
						<?php echo TCK_Text::_('CK_LOGO_URL'); ?></span>
					<span class="ckoption-field">
						<input class="inputbox" type="text" name="logolink" id="logolink" value="" />
					</span>
					<div class="ckclr"></div>
				</div>
				<div class="ckinterfacecolumn" style="padding:5px;">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_MARGINS'); ?></div>
					<div class="ckinterfacecolumn">
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>margintop.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>margintop" id="<?php echo $prefix; ?>margintop" size="1" value="" /></div>
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginright.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginright" id="<?php echo $prefix; ?>marginright" size="1" value="" /></div>
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginbottom.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginbottom" id="<?php echo $prefix; ?>marginbottom" size="1" value=""  /></div>
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginleft.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginleft" id="<?php echo $prefix; ?>marginleft" size="1" value="" /></div>
					</div>
					<div class="ckinterfacecolumn">
						<div style="width: 21px;height: 98px;position: absolute;top: 10px;left: 3px;"><img src="<?php echo $this->imagespath; ?>all_margins.png" width="21" height="98" /></div>
						<div style="position: absolute;top: 45px;left: 30px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>margins" id="<?php echo $prefix; ?>margins" size="1" value="" /><div style="width:25px;float:right;text-align:left;margin-left:3px;"></div></div>
					</div>
				</div>
				<div style="clear:both;"></div>
				<div class="ckinterfacecolumn" style="padding:5px;">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_PADDINGS'); ?></div>
					<div class="ckinterfacecolumn">
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingtop.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingtop" id="<?php echo $prefix; ?>paddingtop" size="1" value="" /></div>
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingright.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingright" id="<?php echo $prefix; ?>paddingright" size="1" value="" /></div>
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingbottom.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingbottom" id="<?php echo $prefix; ?>paddingbottom" size="1" value=""  /></div>
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingleft.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingleft" id="<?php echo $prefix; ?>paddingleft" size="1" value="" /></div>
					</div>
					<div class="ckinterfacecolumn">
						<div style="width: 15px;height: 98px;position: absolute;top: 15px;left: 3px;"><img src="<?php echo $this->imagespath; ?>all_paddings.png" width="15" height="98" /></div>
						<div style="position: absolute;top: 50px;left: 30px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddings" id="<?php echo $prefix; ?>paddings" size="1" value="" /><div style="width:20px;float:right;text-align:left;margin-left:3px;"></div></div>
					</div>
				</div>
				<div style="clear:both;"></div>
				
			</div>
		<?php
	}

	public function createBackground($prefix, $usegradient = true, $title = '', $expert = false) {
		?>
		<div class="ckinterfaceblock" >
			<div class="ckinterfaceblocktitle<?php if ($expert == 'true') echo ' expert'; ?>"><?php echo ($title ? $title : TCK_Text::_('CK_BACKGROUND')) ?></div>
			<div class="ckinterfaceblockaccordion">
				<?php
				if ($usegradient) {
					//$this->ckCreateGradientPreview($prefix);
					?>
					<div data-quickid="<?php echo $prefix; ?>backgroundcolor">
					<div class="ckinterfacecolumn" style="margin:0;">
						<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_BACKGROUNDGRADIENT'); ?></div>
						<div id="<?php echo $prefix; ?>gradientpreview" style="width:55px;height:120px;border:1px solid #808080;"><div class="injectstyles"></div></div>
					</div>
					<div class="ckinterfacecolumn" style="width: 160px;">
						<div class="ckinterfacetitle"><?php echo ($usegradient ? TCK_Text::_('CK_BACKGROUNDCOLORS') : TCK_Text::_('CK_BACKGROUNDCOLOR')) ?></div>

						<div style="text-align:left;margin-left:27px;">
							<div style="float:left;color:#bcbcbc;line-height:23px;"><?php echo TCK_Text::_('0 %'); ?></div>
							<div style="float:left;"><input class="inputbox colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstart" id="<?php echo $prefix; ?>backgroundcolorstart" size="6" style="" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');" onchange="ckCreateGradientPreview('<?php echo $prefix ?>');" data-quicktarget="<?php echo $prefix; ?>backgroundcolor"/></div><div style="float:left;margin:1px 2px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
						<div style="text-align:left;clear:both;">
							<div style="float:left;"><input class="inputbox isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundpositionstop1" id="<?php echo $prefix; ?>backgroundpositionstop1" size="1" style="width:38px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');"/><?php echo TCK_Text::_('%'); ?></div>
							<div style="float:left;"><input class="inputbox colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstop1" id="<?php echo $prefix; ?>backgroundcolorstop1" size="6" style="" onblur="ckCreateGradientPreview('<?php echo $prefix ?>')"/></div><div style="float:left;margin:1px 2px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
						<div style="text-align:left;clear:both;">
							<div style="float:left;"><input class="inputbox isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundpositionstop2" id="<?php echo $prefix; ?>backgroundpositionstop2" size="1" style="width:38px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');"/><?php echo TCK_Text::_('%'); ?></div>
							<div style="float:left;"><input class="inputbox colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstop2" id="<?php echo $prefix; ?>backgroundcolorstop2" size="6" style="" onblur="ckCreateGradientPreview('<?php echo $prefix ?>')" /></div><div style="float:left;margin:1px 2px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
						<div style="text-align:left;clear:both;">
							<div style="float:left;"><input class="inputbox isGradientfield" type="text" value="100" name="<?php echo $prefix; ?>backgroundpositionend" id="<?php echo $prefix; ?>backgroundpositionend" size="1" style="width:38px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');"/><?php echo TCK_Text::_('%'); ?></div>
							<div style="float:left;"><input class="inputbox colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorend" id="<?php echo $prefix; ?>backgroundcolorend" size="6" style="" onblur="ckCreateGradientPreview('<?php echo $prefix ?>')"/></div><div style="float:left;margin:1px 2px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
						<div style="text-align:left;clear:both;">
							<select class="inputbox" type="list" value="" name="<?php echo $prefix; ?>backgrounddirection" id="<?php echo $prefix; ?>backgrounddirection" style="width: 120px;">
								<option value="topbottom"><?php echo TCK_Text::_('CK_TOPTOBOTTOM'); ?></option>
								<option value="bottomtop"><?php echo TCK_Text::_('CK_BOTTOMTOTOP'); ?></option>
								<option value="leftright"><?php echo TCK_Text::_('CK_LEFTTORIGHT'); ?></option>
								<option value="rightleft"><?php echo TCK_Text::_('CK_RIGHTTOLEFT'); ?></option>
							</select>
						</div>
						
					</div>
					<div class="ckoption">
						<?php echo TCK_Text::_('CK_OPACITY'); ?>
						<input class="inputbox isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundopacity" id="<?php echo $prefix; ?>backgroundopacity" style="width:56px;" placeholder="100"/>
					</div>
				</div>
		<?php } else { ?>
					<div style="margin:0 15px 0 0;">
						<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_BACKGROUNDCOLOR'); ?></div>
						<div style="float:left;"><input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstart" id="<?php echo $prefix; ?>backgroundcolorstart" size="6" style="width:72px;" /></div><div style="float:left;margin:1px 2px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div> <?php echo TCK_Text::_('CK_MAINCOLOR'); ?>
						<div class="ckclr"></div>
					</div>
					<div>
						<input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>backgroundopacity" id="<?php echo $prefix; ?>backgroundopacity" size="1" style="width:72px;" placeholder="100"/> <?php echo TCK_Text::_('CK_OPACITY'); ?>
					</div>
					<?php }
				?>
			<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>backgroundimage">
				<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_BACKGROUNDIMAGE'); ?></div>
				<div style="text-align:left;float: left;">
					<div style="text-align:left;float: left;">
						<div style="float: left">
							<select class="inputbox" type="list" value="" name="<?php echo $prefix; ?>backgroundimageattachment" id="<?php echo $prefix; ?>backgroundimageattachment" style="width: 70px;">
								<option value="scroll"><?php echo TCK_Text::_('scroll'); ?></option>
								<option value="fixed"><?php echo TCK_Text::_('fixed'); ?></option>
							</select>
						</div>
						<div style="text-align:center;float: left;width:18px;"><?php echo TCK_Text::_('x'); ?></div><div style="text-align:left;float: left;"><input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>backgroundimageleft" id="<?php echo $prefix; ?>backgroundimageleft" style="width:56px;" placeholder="center" /></div>
						<div style="text-align:center;float: left;width:18px;"><?php echo TCK_Text::_('y'); ?></div><div style="text-align:left;float: left;"><input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>backgroundimagetop" id="<?php echo $prefix; ?>backgroundimagetop" style="width:56px;" placeholder="center" /></div>
						<div>
						</div>
					</div>
					<div style="clear:both;float:left;">
						<div style="text-align:left;">
							<a style="display:block;float:left;padding:0 5px;width:85px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>backgroundimageurl')" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
							<a style="display:block;float:left;padding:0 5px;width:45px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $prefix; ?>backgroundimageurl').attr('value', '');ckRenderCss();"><?php echo TCK_Text::_('CK_CLEAN'); ?></a>
							<div class="ckclr"></div>
							<input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>backgroundimageurl" id="<?php echo $prefix; ?>backgroundimageurl" size="7" style="width:220px; clear:both;" data-quicktarget="<?php echo $prefix; ?>backgroundimage"/>
						</div>

						<div style="text-align:left;">
	<?php echo TCK_Text::_('CK_REPEAT'); ?>
							<select class="inputbox" type="list" value="" name="<?php echo $prefix; ?>backgroundimagerepeat" id="<?php echo $prefix; ?>backgroundimagerepeat" style="width: 120px;float:right;">
								<option value="no-repeat"><?php echo TCK_Text::_('CK_NONE'); ?></option>
								<option value="repeat-x"><?php echo TCK_Text::_('CK_HORIZONTAL'); ?></option>
								<option value="repeat-y"><?php echo TCK_Text::_('CK_VERTICAL'); ?></option>
								<option value="repeat"><?php echo TCK_Text::_('CK_HORIZONTAL_VERTICAL'); ?></option>
							</select>
						</div>
						<div style="text-align:left;clear:both;">
							<span style="max-width:80px;display:inline-block;"><?php echo TCK_Text::_('CK_BACKGROUND_SIZE'); ?></span>
							<select class="inputbox" type="list" value="" name="<?php echo $prefix; ?>backgroundimagesize" id="<?php echo $prefix; ?>backgroundimagesize" style="width: 120px;float:right;">
								<option value="auto"><?php echo TCK_Text::_('CK_NONE'); ?></option>
								<option value="cover"><?php echo TCK_Text::_('CK_COVER'); ?></option>
								<option value="contain"><?php echo TCK_Text::_('CK_CONTAIN'); ?></option>
							</select>
						</div>
						</div>
					</div>
					</div>
				<div class="ckclr"></div>
				</div>
				</div>
		<?php
	}

	public function createText($prefix, $showlinks = true) {
		?>
		<div class="ckinterfaceblock" >
			<div class="ckinterfaceblocktitle"><?php echo TCK_Text::_('CK_TEXT'); ?></div>
			<div class="ckinterfaceblockaccordion">
				<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>font">
					<div style="float:left;">
						<div class="ckinterfacetitle" style=""><?php echo TCK_Text::_('CK_POLICE'); ?></div>
						<div class="ckinterfacecolumn" style="width: 110px;">
							<div>
								<div style="float:left;"><input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" size="6" style="width:82px;" data-quicktargetgroup="<?php echo $prefix; ?>font"/></div>
								<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
							</div>
							<div style="clear:both;">
								<input class="inputbox" style="width: 50px;" name="<?php echo $prefix; ?>fontsize" id="<?php echo $prefix; ?>fontsize" type="text" data-quicktargetgroup="<?php echo $prefix; ?>font" />
								<div style="text-align:left;display:inline;"><?php echo TCK_Text::_('CK_SIZE'); ?></div>
							</div>
							<div style="text-align:left;clear:both;">
								<input class="inputbox" style="width: 50px;" type="text" name="<?php echo $prefix; ?>fontweight" id="<?php echo $prefix; ?>fontweight" size="1" value="" style="" data-quicktargetgroup="<?php echo $prefix; ?>font" />
								<div style="text-align:left;display:inline-block;max-width:50px;"><?php echo TCK_Text::_('CK_WEIGHT'); ?></div>
							</div>
						</div>
						<div class="ckinterfacecolumn" style="width: 120px;">
							<div style="clear:both;">
								<select class="inputbox" style="width: 120px;" name="<?php echo $prefix; ?>fontfamily" id="<?php echo $prefix; ?>fontfamily" data-quicktargetgroup="<?php echo $prefix; ?>font">
									<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
									<option style="font-family:Times New Roman;" value="Times New Roman, Serif">Times New Roman</option>
									<option style="font-family:Helvetica;" value="Helvetica, sans-serif">Helvetica</option>
									<option style="font-family:Georgia;" value="Georgia, serif">Georgia</option>
									<option style="font-family:Courier New;" value="Courier New, serif">Courier New</option>
									<option style="font-family:Arial;" value="Arial, sans-serif">Arial</option>
									<option style="font-family:Verdana;" value="Verdana, sans-serif">Verdana</option>
									<option style="font-family:Comic Sans MS;" value="Comic Sans MS, cursive">Comic Sans MS</option>
									<option style="font-family:Tahoma;" value="Tahoma, sans-serif">Tahoma</option>
									<option style="font-family:Segoe UI;" value="Segoe UI, sans-serif">Segoe UI</option>
									<?php /*<option style="font-family:Segoe UI;" value="googlefont">Google Font</option> */ ?>
									<?php
									if (empty($this->customfonts)) {
										$this->customfonts = $this->_getFontsData();
									}
									$customfonts = $this->_getFonts();
									foreach ($customfonts as $font) {
										$font = str_replace("+", " ", $font);
										$fontmore = isset($this->customfonts[$font]) && $this->customfonts[$font]->alternatives ? ',' . $this->customfonts[$font]->alternatives : '';
										echo '<option style="font-family:' . $font . ';" value="' . $font . $fontmore . '">' . str_replace("'", "", $font) . '</option>';
									}
									?>
								</select>
							</div>
							<?php /*<div style="text-align:left;clear:both;">
								<input class="inputbox isgooglefont" type="text" name="<?php echo $prefix; ?>googlefont" id="<?php echo $prefix; ?>googlefont" size="1" value="" style="width:120px;" placeholder="Google Font" onchange="ckSetGoogleFont('<?php echo $prefix; ?>', '', this.value, '')" data-quicktargetgroup="<?php echo $prefix; ?>font" />
							</div> */ ?>
							<div style="text-align:left;clear:both;">
								<a href="javascript:void(0)" onclick="ckShowGoogleFontsManager2();" class="ckbuttonstyle" style="display:block;float:left;padding:0 5px;width:100px;height:22px;"><?php echo TCK_Text::_('CK_FONT_MANAGER'); ?></a>
							</div>
							
						</div>
						<div style="clear:both;"></div>
						<span class="ckoption-field ckbutton-group">
							<input id="<?php echo $prefix; ?>alignementleft" class="inputbox" name="<?php echo $prefix; ?>alignement" value="left" type="radio">
							<label class="ckbutton" for="<?php echo $prefix; ?>alignementleft">
								<img src="<?php echo $this->imagespath; ?>text_align_left.png" width="16" height="16" />
							</label>
							<input id="<?php echo $prefix; ?>alignementcenter" class="inputbox" name="<?php echo $prefix; ?>alignement" value="center" type="radio">
							<label class="ckbutton" for="<?php echo $prefix; ?>alignementcenter">
								<img src="<?php echo $this->imagespath; ?>text_align_center.png" width="16" height="16" />
							</label>
							<input id="<?php echo $prefix; ?>alignementright" class="inputbox" name="<?php echo $prefix; ?>alignement" value="right" type="radio">
							<label class="ckbutton" for="<?php echo $prefix; ?>alignementright">
								<img src="<?php echo $this->imagespath; ?>text_align_right.png" width="16" height="16" />
							</label>
							<input id="<?php echo $prefix; ?>alignementjustify" class="inputbox" name="<?php echo $prefix; ?>alignement" value="justify" type="radio">
							<label class="ckbutton" for="<?php echo $prefix; ?>alignementjustify">
								<img src="<?php echo $this->imagespath; ?>text_align_justify.png" width="16" height="16" />
							</label>
						</span>
					</div>
				</div>
				
				<div class="ckinterfacecolumn" style="width: 110px;" data-quickid="<?php echo $prefix; ?>font">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_STYLE'); ?></div>
					<select class="inputbox" value="default" name="<?php echo $prefix; ?>fontbold" id="<?php echo $prefix; ?>fontbold" style="width:72px;">
						<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
						<option value="bold"><?php echo TCK_Text::_('CK_BOLD'); ?></option>
						<option value="normal"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
					</select>
					<img src="<?php echo $this->imagespath; ?>text_bold.png" width="16" height="16" title="bold"/><br />
					<select class="inputbox" default="default" name="<?php echo $prefix; ?>fontitalic" id="<?php echo $prefix; ?>fontitalic" style="width:72px;">
						<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
						<option value="italic"><?php echo TCK_Text::_('CK_ITALIC'); ?></option>
						<option value="normal"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
					</select>
					<img src="<?php echo $this->imagespath; ?>text_italic.png" width="16" height="16" title="italic"/><br />
					<select class="inputbox" value="default" name="<?php echo $prefix; ?>fontunderline" id="<?php echo $prefix; ?>fontunderline" style="width:72px;">
						<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
						<option value="underline"><?php echo TCK_Text::_('CK_UNDERLINE'); ?></option>
						<option value="nodecoration"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
					</select>
					<img src="<?php echo $this->imagespath; ?>text_underline.png" width="16" height="16" title="underline"/><br />
					<select class="inputbox" value="default" name="<?php echo $prefix; ?>fontuppercase" id="<?php echo $prefix; ?>fontuppercase" style="width:72px;">
						<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
						<option value="uppercase"><?php echo TCK_Text::_('CK_UPPERCASE'); ?></option>
						<option value="lowercase"><?php echo TCK_Text::_('CK_LOWERCASE'); ?></option>
						<option value="capitalize"><?php echo TCK_Text::_('CK_CAPITALIZE'); ?></option>
						<option value="smallcaps"><?php echo TCK_Text::_('CK_SMALLCAPS'); ?></option>
					</select>
					<img src="<?php echo $this->imagespath; ?>text_smallcaps.png" width="16" height="16" title="uppercase"/><br />
				</div>
						
				<div class="ckinterfacecolumn" style="width: 110px;" data-quickid="<?php echo $prefix; ?>font">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_SPACING'); ?></div>
					<div style="text-align:left;clear:both;">
						<div style="float:left;margin:0px 5px 0 2px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>wordspacing" id="<?php echo $prefix; ?>wordspacing" size="1" value="" style="width:40px;" /></div>
						<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>spacing.png" width="16" height="16" /></div> <?php echo TCK_Text::_('CK_WORD'); ?>
					</div>
					<div style="text-align:left;clear:both;">
						<div style="float:left;margin:0px 5px 0 2px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>letterspacing" id="<?php echo $prefix; ?>letterspacing" size="1" value="" style="width:40px;" /></div>
						<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>spacing.png" width="16" height="16" /></div> <?php echo TCK_Text::_('CK_LETTER'); ?>
					</div>
					<div style="text-align:left;clear:both;">
						<div style="float:left;margin:0px 5px 0 2px;"><input class="inputbox ckhastip" type="text" name="<?php echo $prefix; ?>lineheight" id="<?php echo $prefix; ?>lineheight" size="1" value="" style="width:40px;" title="<?php echo TCK_Text::_('CK_LINEHEIGHT'); ?>" /></div>
						<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>text_linespacing.png" width="16" height="16" /></div> 
					</div>
					<div style="text-align:left;clear:both;">
						<div style="float:left;margin:0px 5px 0 2px;"><input class="inputbox ckhastip" type="text" name="<?php echo $prefix; ?>textindent" id="<?php echo $prefix; ?>textindent" size="1" value="" style="width:40px;" title="<?php echo TCK_Text::_('CK_TEXTINDENT'); ?>"/></div>
						<div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>text_indent.png" width="16" height="16" align="top"/></div>
					</div>
				</div>
		<?php if ($showlinks) { ?>
				<div class="ckclr"></div>
					<div class="ckinterfacecolumn" style="width: 110px;" data-quickid="<?php echo $prefix; ?>font">
						<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_NORMALLINK'); ?></div>
						<select class="inputbox" value="default" name="<?php echo $prefix; ?>normallinkfontbold" id="<?php echo $prefix; ?>normallinkfontbold" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="bold"><?php echo TCK_Text::_('CK_BOLD'); ?></option>
							<option value="normal"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_bold.png" width="16" height="16" title="bold"/><br />
						<select class="inputbox" default="default" name="<?php echo $prefix; ?>normallinkfontitalic" id="<?php echo $prefix; ?>normallinkfontitalic" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="italic"><?php echo TCK_Text::_('CK_ITALIC'); ?></option>
							<option value="normal"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_italic.png" width="16" height="16" title="italic"/><br />
						<select class="inputbox" value="default" name="<?php echo $prefix; ?>normallinkfontunderline" id="<?php echo $prefix; ?>normallinkfontunderline" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="underline"><?php echo TCK_Text::_('CK_UNDERLINE'); ?></option>
							<option value="nodecoration"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_underline.png" width="16" height="16" title="underline"/><br />
						<select class="inputbox" value="default" name="<?php echo $prefix; ?>normallinkfontuppercase" id="<?php echo $prefix; ?>normallinkfontuppercase" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="uppercase"><?php echo TCK_Text::_('CK_UPPERCASE'); ?></option>
							<option value="lowercase"><?php echo TCK_Text::_('CK_LOWERCASE'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_smallcaps.png" width="16" height="16" title="uppercase"/><br />
						<div style="text-align:left;">
							<div style="float:left;"><input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>normallinkcolor" id="<?php echo $prefix; ?>normallinkcolor" /></div><div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
					</div>
					<div class="ckinterfacecolumn" style="width:110px;" data-quickid="<?php echo $prefix; ?>font">
						<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_HOVERLINK'); ?></div>
						<select class="inputbox" value="default" name="<?php echo $prefix; ?>hoverlinkfontbold" id="<?php echo $prefix; ?>hoverlinkfontbold" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="bold"><?php echo TCK_Text::_('CK_BOLD'); ?></option>
							<option value="normal"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_bold.png" width="16" height="16" title="bold"/><br />
						<select class="inputbox" default="default" name="<?php echo $prefix; ?>hoverlinkfontitalic" id="<?php echo $prefix; ?>hoverlinkfontitalic" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="italic"><?php echo TCK_Text::_('CK_ITALIC'); ?></option>
							<option value="normal"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_italic.png" width="16" height="16" title="italic"/><br />
						<select class="inputbox" value="default" name="<?php echo $prefix; ?>hoverlinkfontunderline" id="<?php echo $prefix; ?>hoverlinkfontunderline" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="underline"><?php echo TCK_Text::_('CK_UNDERLINE'); ?></option>
							<option value="nodecoration"><?php echo TCK_Text::_('CK_NORMAL'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_underline.png" width="16" height="16" title="underline"/><br />
						<select class="inputbox" value="default" name="<?php echo $prefix; ?>hoverlinkfontuppercase" id="<?php echo $prefix; ?>hoverlinkfontuppercase" style="width:72px;">
							<option value="default"><?php echo TCK_Text::_('CK_DEFAULT'); ?></option>
							<option value="uppercase"><?php echo TCK_Text::_('CK_UPPERCASE'); ?></option>
							<option value="lowercase"><?php echo TCK_Text::_('CK_LOWERCASE'); ?></option>
						</select>
						<img src="<?php echo $this->imagespath; ?>text_smallcaps.png" width="16" height="16" title="uppercase"/><br />
						<div style="text-align:left;">
							<div style="float:left;"><input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>hoverlinkcolor" id="<?php echo $prefix; ?>hoverlinkcolor"/></div><div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
						</div>
					</div>
					<div class="menuseparator"></div>
		<?php } ?>
				
				<div class="ckclr"></div>
			</div>
		</div>
		<?php
	}

	public function createDimensions($prefix, $useheight = false, $usewidth = false, $expert = false, $iswrapper = false, $usemargins = true, $usepaddings = true, $useminheight = true) {
		?>
		<div class="ckinterfaceblock">
			<div class="ckinterfaceblocktitle ckquickstyle-hide"><?php echo TCK_Text::_('CK_MISE_FORME'); ?></div>
			<div class="ckinterfaceblockaccordion">
				<?php if ($usemargins) { ?>
				<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>margins">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_MARGINS'); ?></div>
					<div class="ckinterfacecolumn">
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>margintop.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>margintop" id="<?php echo $prefix; ?>margintop" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>margins" /></div>
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginright.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginright" id="<?php echo $prefix; ?>marginright" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>margins" /></div>
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginbottom.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginbottom" id="<?php echo $prefix; ?>marginbottom" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>margins" /></div>
						<div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginleft.png" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginleft" id="<?php echo $prefix; ?>marginleft" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>margins" /></div>
					</div>
					<div class="ckinterfacecolumn">
						<div style="width: 21px;height: 98px;position: absolute;top: 10px;left: 3px;"><img src="<?php echo $this->imagespath; ?>all_margins.png" width="21" height="98" /></div>
						<div style="position: absolute;top: 45px;left: 30px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>margins" id="<?php echo $prefix; ?>margins" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>margins" /><div style="width:25px;float:right;text-align:left;margin-left:3px;"></div></div>
					</div>
				</div>
				<div style="clear:both;"></div>
				<?php } ?>
				<?php if ($usepaddings) { ?>
				<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>paddings">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_PADDINGS'); ?></div>
					<div class="ckinterfacecolumn">
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingtop.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingtop" id="<?php echo $prefix; ?>paddingtop" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>paddings" /></div>
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingright.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingright" id="<?php echo $prefix; ?>paddingright" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>paddings" /></div>
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingbottom.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingbottom" id="<?php echo $prefix; ?>paddingbottom" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>paddings" /></div>
						<div><div style="float:left;text-align:right;margin:5px 8px 0 6px;"><img src="<?php echo $this->imagespath; ?>paddingleft.png" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingleft" id="<?php echo $prefix; ?>paddingleft" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>paddings" /></div>
					</div>
					<div class="ckinterfacecolumn">
						<div style="width: 15px;height: 98px;position: absolute;top: 15px;left: 3px;"><img src="<?php echo $this->imagespath; ?>all_paddings.png" width="15" height="98" /></div>
						<div style="position: absolute;top: 50px;left: 30px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddings" id="<?php echo $prefix; ?>paddings" size="1" value="" data-quicktargetgroup="<?php echo $prefix; ?>paddings" /><div style="width:20px;float:right;text-align:left;margin-left:3px;"></div></div>
					</div>
				</div>
				<?php } ?>
				<div style="clear:both;"></div>
				<?php if ($useheight OR $usewidth OR $useminheight) { ?>
				<div class="ckinterfacetitle ckquickstyle-hide" ><?php echo TCK_Text::_('CK_DIMENSIONS'); ?></div>
				<?php if ($useminheight) { ?>
				<div class="ckoption" data-quickid="<?php echo $prefix; ?>minheight">
					<?php $this->createLabel(TCK_Text::_('CK_MIN_HEIGHT'), 'height.png') ?>
					<span class="ckoption-field">
						<input class="inputbox" type="text" name="<?php echo $prefix; ?>minheight" id="<?php echo $prefix; ?>minheight" value="" data-quicktarget="<?php echo $prefix; ?>minheight" />
					</span>
					<div class="ckclr"></div>
				</div>
				<?php } ?>
		<?php if ($useheight OR $usewidth) { ?>
			<?php if ($useheight) { ?>
						<div class="ckoption" data-quickid="<?php echo $prefix; ?>height">
							<?php $this->createLabel(TCK_Text::_('CK_HEIGHT'), 'height.png') ?>
							<span class="ckoption-field">
								<input class="inputbox" type="text" name="<?php echo $prefix; ?>height" id="<?php echo $prefix; ?>height" value="" data-quicktarget="<?php echo $prefix; ?>height" />
							</span>
							<div class="ckclr"></div>
						</div>
						<?php } ?>
			<?php if ($usewidth) { ?>
							<div class="ckoption" data-quickid="<?php echo $prefix; ?>width">
							<?php $this->createLabel(TCK_Text::_('CK_WIDTH'), 'width.png') ?>
							<span class="ckoption-field">
								<input class="inputbox" type="text" name="<?php echo $prefix; ?>width" id="<?php echo $prefix; ?>width" value="" data-quicktarget="<?php echo $prefix; ?>width" />
							</span>
							<div class="ckclr"></div>
						</div>
					<?php } ?>
				<?php } ?>
		<?php } ?>
		<?php if ($iswrapper) { ?>
					<div class="menuseparator ckquickstyle-hide"></div>
					<div class="ckinterfacecolumn ckquickstyle-hide" style="margin-left:10px;width: 200px;" data-quickid="<?php echo $prefix; ?>fullwidth">
						<div class="ckinterfacetitle" style="text-align:left;padding-left:0px;margin-top:0px;"><?php echo TCK_Text::_('CK_FULLWIDTH'); ?></div>
							<div style="text-align:left;">
								<div class="ckquickstyle-hide"><?php echo TCK_Text::_('CK_FULLWIDTH_DESC'); ?></div>
								<div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>width.png" width="15" height="15" align="top" /></div><div style="float:left;">
									<select class="inputbox" name="<?php echo $prefix; ?>fullwidth" id="<?php echo $prefix; ?>fullwidth" style="width: 150px">
										<option value="0"><?php echo TCK_Text::_('CK_NO') ?></option>
										<option value="1"><?php echo TCK_Text::_('CK_YES') ?></option>
									</select>
								</div><div style="float:left;text-align:left;margin-left:3px;"></div>
							</div>
					</div>
		<?php } ?>
				<div class="ckinterfacecolumn ckquickstyle-hide">
					<div style="margin:10px 0 0 15px;"><img src="<?php echo $this->imagespath; ?>formatting.png" width="200" height="150" /></div>
				</div>

				<div class="ckclr"></div>
			</div>
		</div>
		<?php
	}

	public function createDecoration($prefix) {
		?>
		<div class="ckinterfaceblock" >
			<div class="ckinterfaceblocktitle ckquickstyle-hide"><?php echo TCK_Text::_('CK_DECORATION'); ?></div>
			<div class="ckinterfaceblockaccordion">
				<div class="ckinterfacecolumn" style="margin-left:0px;" data-quickid="<?php echo $prefix; ?>borderradius">
					<div class="ckinterfacetitle" style=""><?php echo TCK_Text::_('CK_ROUNDED_CORNERS'); ?>
					</div>
					<div class="ckinterfacecolumn">
						<div><div style="float:left;text-align:right;margin:5px 3px 0 0;"><img src="<?php echo $this->imagespath; ?>topright_corner.png" width="18" height="18" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>borderradiustopright" id="<?php echo $prefix; ?>borderradiustopright" size="1" value="" style="" data-quicktargetgroup="<?php echo $prefix; ?>borderradius" /></div>
						<div><div style="float:left;text-align:right;margin:5px 3px 0 0;"><img src="<?php echo $this->imagespath; ?>bottomright_corner.png" width="18" height="18" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>borderradiusbottomright" id="<?php echo $prefix; ?>borderradiusbottomright" size="1" value="" style="" data-quicktargetgroup="<?php echo $prefix; ?>borderradius" /></div>
						<div><div style="float:left;text-align:right;margin:5px 3px 0 0;"><img src="<?php echo $this->imagespath; ?>bottomleft_corner.png" width="18" height="18" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>borderradiusbottomleft" id="<?php echo $prefix; ?>borderradiusbottomleft" size="1" value="" style=""  data-quicktargetgroup="<?php echo $prefix; ?>borderradius" /></div>
						<div><div style="float:left;text-align:right;margin:5px 3px 0 0;"><img src="<?php echo $this->imagespath; ?>topleft_corner.png" width="18" height="18" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>borderradiustopleft" id="<?php echo $prefix; ?>borderradiustopleft" size="1" value="" style="" data-quicktargetgroup="<?php echo $prefix; ?>borderradius" /></div>
					</div>
					<div class="ckinterfacecolumn" style="width:100px;">
						<div style="width: 38px;height: 98px;position: absolute;top: 15px;left: 3px;"><img src="<?php echo $this->imagespath; ?>all_corners.png" width="38" height="98" /></div>
						<div style="position: absolute;top: 50px;left: 45px;">
							<input class="inputbox" type="text" name="<?php echo $prefix; ?>borderradius" id="<?php echo $prefix; ?>borderradius" size="1" value="" style="" data-quicktargetgroup="<?php echo $prefix; ?>borderradius" />
						</div>
					</div>
					<div style="clear:both;"></div>
				</div>
				<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>borders">
					<div class="ckinterfacetitle" style=""><?php echo TCK_Text::_('CK_BORDERS'); ?></div>
					<div style="text-align: left;">
						<span style="padding-left:30px;"><?php echo TCK_Text::_('CK_COLOR'); ?></span><span style="padding-left:30px;"><?php echo TCK_Text::_('CK_SIZE'); ?></span><span style="padding-left:20px;"><?php echo TCK_Text::_('CK_STYLE'); ?></span>
					</div>
					<div style="text-align: left;clear:both;">
						<div style="width:15px;float:left;text-align:right;margin:5px 3px 0 0;">
		<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
						</div>
						<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>bordertopcolor" id="<?php echo $prefix; ?>bordertopcolor" size="7" style="" />
						<input class="inputbox" type="text" style="" name="<?php echo $prefix; ?>bordertopsize" id="<?php echo $prefix; ?>bordertopsize" data-quicktargetgroup="<?php echo $prefix; ?>borders" />

						<select class="inputbox" name="<?php echo $prefix; ?>bordertopstyle" id="<?php echo $prefix; ?>bordertopstyle" style="width:80px;">
							<option value="solid">solid</option>
							<option value="dotted">dotted</option>
							<option value="dashed">dashed</option>
						</select>
					</div>
					<div style="text-align: left;">
						<div style="width:15px;float:left;text-align:right;margin:5px 3px 0 0;">
		<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
						</div>
						<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderrightcolor" id="<?php echo $prefix; ?>borderrightcolor" size="7" style="" />
						<input class="inputbox" type="text" style="" name="<?php echo $prefix; ?>borderrightsize" id="<?php echo $prefix; ?>borderrightsize" data-quicktargetgroup="<?php echo $prefix; ?>borders" />

						<select class="inputbox" name="<?php echo $prefix; ?>borderrightstyle" id="<?php echo $prefix; ?>borderrightstyle" style="width:80px;">
							<option value="solid">solid</option>
							<option value="dotted">dotted</option>
							<option value="dashed">dashed</option>
						</select>
					</div>
					<div style="text-align: left;">
						<div style="width:15px;float:left;text-align:right;margin:5px 3px 0 0;">
		<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
						</div>
						<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderbottomcolor" id="<?php echo $prefix; ?>borderbottomcolor" size="7" style="" />
						<input class="inputbox" type="text" style="" name="<?php echo $prefix; ?>borderbottomsize" id="<?php echo $prefix; ?>borderbottomsize" data-quicktargetgroup="<?php echo $prefix; ?>borders" />

						<select class="inputbox" name="<?php echo $prefix; ?>borderbottomstyle" id="<?php echo $prefix; ?>borderbottomstyle" style="width:80px;">
							<option value="solid">solid</option>
							<option value="dotted">dotted</option>
							<option value="dashed">dashed</option>
						</select>
					</div>
					<div style="text-align: left;">
						<div style="width:15px;float:left;text-align:right;margin:5px 3px 0 0;">
		<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
						</div>
						<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderleftcolor" id="<?php echo $prefix; ?>borderleftcolor" size="7" style="" />
						<input class="inputbox" type="text" style="" name="<?php echo $prefix; ?>borderleftsize" id="<?php echo $prefix; ?>borderleftsize" data-quicktargetgroup="<?php echo $prefix; ?>borders" />

						<select class="inputbox" type="text" name="<?php echo $prefix; ?>borderleftstyle" id="<?php echo $prefix; ?>borderleftstyle" style="width:80px;" >
							<option value="solid">solid</option>
							<option value="dotted">dotted</option>
							<option value="dashed">dashed</option>
						</select>
					</div>
				</div>
				<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>borders">
					<div style="margin-left: 30px;"><?php echo TCK_Text::_('CK_ALL'); ?></div>
					<div style="width:15px;float:left;text-align:right;margin:5px 3px 0 0;">
						<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
					</div>
					<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderscolor" id="<?php echo $prefix; ?>borderscolor" size="7" style="" />
					<input class="inputbox" type="text" style="" name="<?php echo $prefix; ?>borderssize" id="<?php echo $prefix; ?>borderssize" data-quicktargetgroup="<?php echo $prefix; ?>borders" />
					<select class="inputbox" type="text" name="<?php echo $prefix; ?>bordersstyle" id="<?php echo $prefix; ?>bordersstyle" style="width:80px;">
						<option value="solid">solid</option>
						<option value="dotted">dotted</option>
						<option value="dashed">dashed</option>
					</select>
				</div>
				<div class="ckinterfacecolumn ckquickstyle-hide">
					<div style="margin:3px 0 0 0px;"><img src="<?php echo $this->imagespath; ?>borders.png" width="200" height="170" /></div>
				</div>
				<div class="ckclr"></div>
			</div>
		</div>
		<?php
	}

	public function createOutline($prefix) {
		?>
		<div class="ckinterfaceblock" >
			<div class="ckinterfaceblocktitle ckquickstyle-hide"><?php echo TCK_Text::_('CK_OUTLINE'); ?></div>
			<div class="ckinterfaceblockaccordion">
				<div class="ckinterfacecolumn" data-quickid="<?php echo $prefix; ?>outline">
					<div class="ckinterfacetitle" style=""><?php echo TCK_Text::_('CK_BORDERS'); ?></div>
					<div style="width:15px;float:left;text-align:right;margin:5px 3px 0 0;">
						<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
					</div>
					<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>outlinecolor" id="<?php echo $prefix; ?>outlinecolor" size="7" style="" />
					<input class="inputbox" type="text" style="" name="<?php echo $prefix; ?>outlinesize" id="<?php echo $prefix; ?>outlinesize" data-quicktargetgroup="<?php echo $prefix; ?>outline" />
					<select class="inputbox" type="text" name="<?php echo $prefix; ?>outlinestyle" id="<?php echo $prefix; ?>outlinestyle" style="width:80px;">
						<option value="solid">solid</option>
						<option value="dotted">dotted</option>
						<option value="dashed">dashed</option>
					</select>
				</div>
				<div class="ckclr"></div>
			</div>
		</div>
		<?php
	}

	public function createShadow($prefix) {
		?>
		<div class="ckinterfaceblock" data-quickid="<?php echo $prefix; ?>shadow">
			<div class="ckinterfaceblocktitle"><?php echo TCK_Text::_('CK_SHADOW'); ?></div>
			<div class="ckinterfaceblockaccordion">
				<div class="" style="text-align: left;">
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_SHADOW'); ?></div>
					<div>
							<input class="inputbox colorPicker" type="text" value="" name="<?php echo $prefix; ?>shadowcolor" id="<?php echo $prefix; ?>shadowcolor" size="6" style="width:72px;" data-quicktargetgroup="<?php echo $prefix; ?>shadow" />
							<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/> <?php echo TCK_Text::_('CK_COLOR'); ?>
					</div>
					<div>
							<input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>shadowopacity" id="<?php echo $prefix; ?>shadowopacity" size="1" style="width:72px;"/> <?php echo TCK_Text::_('CK_OPACITY'); ?>
							<input class="inputbox" type="hidden" value="" name="<?php echo $prefix; ?>shadowbefore" id="<?php echo $prefix; ?>shadowbefore" />
							<input class="inputbox" type="hidden" value="" name="<?php echo $prefix; ?>shadowafter" id="<?php echo $prefix; ?>shadowafter" />
							<input class="inputbox" type="hidden" value="" name="<?php echo $prefix; ?>shadowcustom" id="<?php echo $prefix; ?>shadowcustom" />
						</div>
					</div>
				<div>
					<div class="ckinterfacetitle ckquickstyle-hide"><?php echo TCK_Text::_('CK_WIDTH'); ?></div>
					<div>
						<input class="inputbox" type="text" name="<?php echo $prefix; ?>shadowblur" id="<?php echo $prefix; ?>shadowblur" size="1" value="" style="width:72px;" data-quicktargetgroup="<?php echo $prefix; ?>shadow"/> <?php echo TCK_Text::_('CK_BLUR'); ?>
				</div>
					<div>
						<input class="inputbox" type="text" name="<?php echo $prefix; ?>shadowspread" id="<?php echo $prefix; ?>shadowspread" size="1" value="" style="width:72px;" data-quicktargetgroup="<?php echo $prefix; ?>shadow"/> <?php echo TCK_Text::_('CK_SPREAD'); ?>
					</div>
				</div>
				<div class="ckinterfacecolumn" >
					<div class="ckinterfacetitle ckquickstyle-hide"><?php echo TCK_Text::_('CK_OFFSET'); ?></div>
					<div>
						<input class="inputbox" type="text" name="<?php echo $prefix; ?>shadowoffseth" id="<?php echo $prefix; ?>shadowoffseth" size="1" value="" style="width:72px;"/>
						<div style="width:18px;text-align:center;display:inline-block;"><?php echo TCK_Text::_('x'); ?></div>
						<input class="inputbox" type="text" name="<?php echo $prefix; ?>shadowoffsetv" id="<?php echo $prefix; ?>shadowoffsetv" size="1" value="" style="width:72px;"/>
						<div style="width:18px;text-align:center;display:inline-block;"><?php echo TCK_Text::_('y'); ?></div>
					</div>
				</div>
				<div class="ckinterfacecolumn" >
					<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_DIRECTION'); ?></div>
					<div>
						<select class="inputbox" type="list" name="<?php echo $prefix; ?>shadowinset" id="<?php echo $prefix; ?>shadowinset" value="" >
							<option value="0"><?php echo TCK_Text::_('CK_OUTSIDE'); ?></option>
							<option value="1"><?php echo TCK_Text::_('CK_INSIDE'); ?></option>
						</select>
					</div>
				</div>
				<div class="ckclr"></div>
			</div>
		</div>
		<?php
	}

	/*
	 * Get the list of fonts squirrel
	 * @return Array
	 */
	function _getFonts() {
		$fonts = Array();
//		$db = \Joomla\CMS\Factory::getDBO();
//		$query = "SELECT * FROM #__templateck_fonts";
//		$db->setQuery($query);
//		$rows = $db->loadObjectList('fontfamilies');

		$rows = $this->_getFontsData();
		foreach ($rows as $row) {
			$fontfamilies = explode(",", $row->fontfamilies);
			foreach ($fontfamilies as $fontfamily) {
				$fonts[] = $fontfamily;
//				$fonts[] = "'" . $fontfamily . "'" .(isset($row->additional_fonts) && $row->additional_fonts ? ', ' . trim($row->additional_fonts, ',') : '');
			}
		}

		return $fonts;
	}
	
	/*
	 * Get the list of fonts squirrel
	 * @return Array
	 */
	function _getFontsData() {
		$db = \Joomla\CMS\Factory::getDBO();
		$query = "SELECT * FROM #__templateck_fonts";
		$db->setQuery($query);
		$rows = $db->loadObjectList('fontfamilies');

		return $rows;
	}
}
