<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class CKBrowse {

	/*
	 * Get a list of folders and files 
	 */
	public static function getFileTypes($type, $auto = true) {
		$input = new TCK_Input();

		$type = $auto ? $input->get('type', $type, 'string') : $type;

		switch ($type) {
			case 'video' :
				$filetypes = array('.mp4', '.ogv', '.webm', '.MP4', '.OGV', '.WEBM');
				break;
			case 'audio' :
				$filetypes = array('.mp3', '.ogg', '.MP3', '.OGG');
				break;
			case 'image' :
			default :
				$filetypes = array('.jpg', '.jpeg', '.png', '.gif', '.tiff', '.JPG', '.JPEG', '.PNG', '.GIF', '.TIFF', '.ico', '.svg', '.webp', '.WEBP', '.avif', '.AVIF');
				break;
		}

		return $filetypes;
	}

	/*
	 * Get a list of folders and files 
	 */
	public static function getItemsList($type = 'image') {
		$input = \Templatecreatorck\CKFof::getApplication()->input;

		$type = $input->get('type', $type, 'string');

		$filetypes = self::getFileTypes($type);
//		switch ($type) {
//			case 'video' :
//				$filetypes = array('.mp4', '.ogv', '.webm', '.MP4', '.OGV', '.WEBM');
//				break;
//			case 'audio' :
//				$filetypes = array('.mp3', '.ogg', '.MP3', '.OGG');
//				break;
//			case 'image' :
//			default :
//				$filetypes = array('.jpg', '.jpeg', '.png', '.gif', '.tiff', '.JPG', '.JPEG', '.PNG', '.GIF', '.TIFF', '.ico', '.svg', '.WEBP', '.webp');
//				break;
//			case 'all' :
//			case 'files' :
//				$filetypes = array('.pdf', '.jpg', '.jpeg', '.png', '.gif', '.tiff', '.JPG', '.JPEG', '.PNG', '.GIF', '.TIFF', '.ico', '.svg', '.mp3', '.ogg', '.MP3', '.OGG', '.mp4', '.ogv', '.webm', '.MP4', '.OGV', '.WEBM', '.WEBP', '.webp');
//				break;
//		}
		$folder = $input->get('folder', '', 'string') ? '/' . trim($input->get('folder', '', 'string'), '/') : '/' . trim(\Joomla\CMS\Component\ComponentHelper::getParams('com_pagebuilderck')->get('imagespath', 'images/pagebuilderck'), '/');

		// makes replacement if specific user management is set
		if (stristr($folder, '$userid')) {
			self::$isRestrictedUser = true;
			$user = \Joomla\CMS\Factory::getUser();
			$folder = str_replace('$userid', 'user_' . $user->id, $folder);
			if (! file_exists(JPATH_SITE . '/' . $folder)) {
				mkdir(JPATH_SITE . '/' . $folder);
			}
		}

		// no folder filtering 
		if (\Joomla\CMS\Component\ComponentHelper::getParams('com_templateck')->get('imagespathexclusive', '0') == '0') {
			$folder = $input->get('folder', 'images', 'string');
		} else {
			// check if folder exists, if not then create it
			if (!is_dir(JPATH_SITE . $folder)) {
				mkdir(JPATH_SITE . $folder);
			}
		}

		$tree = new stdClass();

		// list the files in the root folder
		$fName = self::createFolderObj(TEMPLATECREATORCK_SITE_ROOT . '/' . $folder, $tree, 1);
		$tree->$fName->files = self::getImagesInFolder(TEMPLATECREATORCK_SITE_ROOT . '/' . $folder, implode('|', $filetypes));

		// look for all folder and files
		self::getSubfolder(TEMPLATECREATORCK_SITE_ROOT . '/' . $folder, $tree, implode('|', $filetypes), 2);
		$tree = self::prepareList($tree);

		return $tree;
	}

	/* 
	 * List the subfolders and files according to the filter
	 */
	private static function getSubfolder($folder, &$tree, $filter, $level) {
		$folders = TCK_Folder::folders($folder, '.', $recurse = false, $fullpath = true);
		natcasesort($folders);

		if (! count($folders)) return;

		foreach ($folders as $f) {
			$fName = self::createFolderObj($f, $tree, $level);

			// list all authorized files from the folder
			// self::getImagesInFolder($f, $tree, $fName, $filter, $level);

			// recursive loop
			self::getSubfolder($f, $tree, $filter, $level+1);
		}
		return;
	}
	
	private static function createFolderObj($f, &$tree, $level) {
		$fName = TCK_File::makeSafe(str_replace(JPATH_SITE, '', $f));
		$tree->$fName = new stdClass();
//		$name = explode('/', $f);
//		$name = end($name);
		$name = basename($f);
		$tree->$fName->name = $name;
		$tree->$fName->path = $f;
		$tree->$fName->level = $level;
		$tree->$fName->files = false;

		return $fName;
		}

	/* 
	 * List the subfolders and files according to the filter
	 */
	public static function getImagesInFolder($f, $filter = '.') {

			// list all authorized files from the folder
			$files = TCK_Folder::files($f, $filter, $recurse = false, $fullpath = false);
			if (is_array($files)) natcasesort($files);

			return $files;
		}

	/* 
	 * Set level diff and check for depth
	 */
	private static function prepareList($items) {
		if (! $items) return $items;

		$lastitem = 0;
		foreach ($items as $i => $item)
		{
			self::prepareItem($item);

			if ($item->level != 0) {
				if (isset($items->$lastitem))
				{
					$items->$lastitem->deeper     = ($item->level > $items->$lastitem->level);
					$items->$lastitem->shallower  = ($item->level < $items->$lastitem->level);
					$items->$lastitem->level_diff = ($items->$lastitem->level - $item->level);
				}
			}
			$lastitem = $i;

			
		}

		// for the last item
		if (isset($items->$lastitem))
		{
			$items->$lastitem->deeper     = (1 > $items->$lastitem->level);
			$items->$lastitem->shallower  = (1 < $items->$lastitem->level);
			$items->$lastitem->level_diff = ($item->level - 1);
		}

		return $items;
	}

	/* 
	 * Set the default values
	 */
	private static function prepareItem(&$item) {
		$item->deeper     = false;
		$item->shallower  = false;
		$item->level_diff = 0;
		$item->basepath = str_replace(TEMPLATECREATORCK_SITE_ROOT, '', $item->path);
		$item->basepath = str_replace('\\', '/', $item->basepath);
		$item->basepath = trim($item->basepath, '/');
	}

	/**
	 * Get the file and store it on the server
	 * 
	 * @return mixed, the method return
	 */
	public static function ajaxAddPicture() {
		// check why it does not work
		if (! \Joomla\CMS\Session\Session::checkToken('get')) {
			$msg = TCK_Text::_('JINVALID_TOKEN');
			echo '{"error" : "' . $msg . '"}';
			exit;
		}

		$input = new TCK_Input();
		$file = $input->files->get('file', '', 'array');
		$imgpath = '/' . trim($input->get('path', '', 'string'), '/') . '/';

		if (!is_array($file)) {
			$msg = TCK_Text::_('CK_NO_FILE_RECEIVED');
			echo '{"error" : "' . $msg . '"}';
			exit;
		}

		// If there are no files to upload - then bail
		if (empty($file))
		{
			$msg = \Templatecreatorck\CKText::_('CK_NO_FILE_RECEIVED');
			echo '{"error" : "' . $msg . '"}';
			exit;
		}
		
		$filename = TCK_File::makeSafe($file['name']);

		// check the file extension // TODO recup preg_match de local dev
		// if (TCK_File::getExt($filename) != 'jpg') {
			// $msg = TCK_Text::_('CK_NOT_JPG_FILE');
			// echo '{"error" : "'  $msg  '"}';
			// exit;
		// }

		//Set up the source and destination of the file
		$src = $file['tmp_name'];

		// check if the file exists
		if (!$src || !file_exists($src)) {
			$msg = TCK_Text::_('CK_FILE_NOT_EXISTS');
			echo '{"error" : "' . $msg . '"}';
			exit;
		}

		// check if folder exists, if not then create it
		if (!TCK_Folder::exists(TEMPLATECREATORCK_SITE_ROOT . $imgpath)) {
			if (!TCK_Folder::create(TEMPLATECREATORCK_SITE_ROOT . $imgpath)) {
				$msg = TCK_Text::_('CK_UNABLE_TO_CREATE_FOLDER') . ' : ' . $imgpath;
				echo '{"error" : "' . $msg . '"}';
				exit;
			}
		}

		$file['filepath'] = TEMPLATECREATORCK_SITE_ROOT . $imgpath;

		// Trigger the onContentBeforeSave event.
		$object_file = new \Templatecreatorck\CKObject($file);
//		$result = CKFof::triggerEvent('onContentBeforeSave', array('com_media.file', &$object_file, true));

		/*if (in_array(false, $result, true))
		{
			// There are some errors in the plugins
			JError::raiseWarning(100, \Templatecreatorck\CKText::plural('COM_MEDIA_ERROR_BEFORE_SAVE', count($errors = $object_file->getErrors()), implode('<br />', $errors)));

			return false;
		}*/

		// write the file
		if (! TCK_File::copy($src, TEMPLATECREATORCK_SITE_ROOT . $imgpath . $filename)) {
			$msg = TCK_Text::_('CK_UNABLE_WRITE_FILE');
			echo '{"error" : "' . $msg . '"}';
			exit;
		}
		
		$type = TCK_File::getExt($filename);
		switch ($type) {
			 case 'video' :
				 $fileicon = TEMPLATECREATORCK_MEDIA_URI . '/images/' . 'file_video.png';
				 break;
			 case 'audio' :
				 $fileicon = TEMPLATECREATORCK_MEDIA_URI . '/images/' . 'file_audio.png';
				 break;
			case 'pdf' :
				$fileicon = TEMPLATECREATORCK_MEDIA_URI . '/images/' . 'file_pdf.png';
				break;
			default :
				$fileicon = $imgpath . $filename;
				break;
		}
		

		echo '{"img" : "' . $fileicon . '", "filename" : "' . $filename . '"}';
		exit;
	}

	public static function createFolder($path, $folder) {
		$path = TCK_Path::clean(TEMPLATECREATORCK_SITE_ROOT . '/' . $path . '/' . $folder);

		if (!is_dir($path) && !is_file($path))
			{
				if (TCK_Folder::create($path))
				{
					$data = "<html>\n<body bgcolor=\"#FFFFFF\">\n</body>\n</html>";
					file_put_contents($path . '/index.html', $data);
				} else {
					return false;
}
		}
		return true;
	}

	public static function getTypeByFilename($filename) {
		$videoFiletypes = self::getFileTypes('video', false);
		$audioFiletypes = self::getFileTypes('audio', false);
		$imageFiletypes = self::getFileTypes('image', false);
		$allFiletypes = self::getFileTypes('all', false);
		$ext = \Templatecreatorck\CKFile::getExt($filename);

		if (in_array('.' . $ext, $videoFiletypes)) return 'video';
		if (in_array('.' . $ext, $audioFiletypes)) return 'audio';
		if (in_array('.' . $ext, $imageFiletypes)) return 'image';
		if (in_array('.' . $ext, $allFiletypes)) return 'all';
		return 'none';
	}
}
