/**
 * @name		Template Creator CK 3
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

function TCK_WidgetScrolltoEnable() {
	if (! confirm('This will enable the plugin Scroll To CK, continue ?')) return;

	var myurl = URIBASE + "/index.php?option=com_templateck&task=ajaxCallWidgetAction";
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'scrollto',
			func: 'enablePlugin'
		}
	}).done(function(code) {
		if (code == '1') {
			$ck('.widgetrow[data-name="scrollto"]').attr('data-enabled', '1');
			$ck('#widgetsElements .widget[data-name="scrollto"]').attr('data-enabled', '1');
		} else {
			alert('A problem occured, the plugin can not be enabled.')
		}
	}).fail(function() {
		alert(Joomla.JText._('CK_FAILED', 'Failed'));
	});
}

function TCK_WidgetScrolltoDisable() {
	if (! confirm('This will disable the plugin Scroll To CK, continue ?')) return;

	var myurl = URIBASE + "/index.php?option=com_templateck&task=ajaxCallWidgetAction";
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'scrollto',
			func: 'disablePlugin'
		}
	}).done(function(code) {
		if (code == '1') {
			$ck('.widgetrow[data-name="scrollto"]').attr('data-enabled', '0');
			$ck('#widgetsElements .widget[data-name="scrollto"]').attr('data-enabled', '0');
		} else {
			alert('A problem occured, the plugin can not be disabled.')
		}
	}).fail(function() {
		alert(Joomla.JText._('CK_FAILED', 'Failed'));
	});
}

