<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
 
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKView;

class TemplateckViewIcons extends CKView {

	/**
	 * Icons view display method
	 * @return void
	 * */
	function display($tpl = null) {
		$user = \Joomla\CMS\Factory::getUser();
		$authorised = ($user->authorise('core.create', 'com_templateck') || (count($user->getAuthorisedCategories('com_templateck', 'core.create'))));

		if ($authorised !== true)
		{
			throw new Exception(TCK_Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		parent::display($tpl);

		exit();
	}
}
