<?php
/**
 * @copyright	Copyright (C) 2022. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

$input = new TCK_Input();
$prefix = $input->get('prefix', '', 'string');
?>
<link rel="preconnect" href="https://fonts.gstatic.com">
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckframework.css" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/font-awesome.min.css" type="text/css" />
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/jquery.min.js" type="text/javascript"></script>

<div class="ckinterface" style="padding: 20px;">
	<div id="fontslistcontainer">
	<p>
		<input id ="cksearchfontcategory" name="cksearchfontcategory" type="text" style="height:auto;margin:0;width: 500px;max-width:100%;" onchange="ckSearchFontCategory()" />
		<div class="ckbutton-group">
		<button class="ckbutton" onclick="ckSearchFontCategory()"><span class="fack fack-search"></span> <?php echo TCK_Text::_('CK_SEARCH') ?></button><i class="fack fack-pulse fack-spinner"></i>
		<button class="ckbutton" onclick="jQuery('#cksearchfontcategory').val('');ckSearchFontCategory();"><span class="fack fack-times"></span> <?php echo TCK_Text::_('CK_CLEAR') ?></button><i class="fack fack-pulse fack-spinner"></i>
		</div>
	</p>
	<?php /*<p>
		<label for=""><?php echo TCK_Text::_('CK_CATEGORY') ?></label>
		<select id="ckselectfontcategory" onchange="ckFilterFontCategory()">
			<option value=""><?php echo TCK_Text::_('CK_ALL') ?></option>
			<option value="sans-serif">sans-serif</option>
			<option value="serif">serif</option>
			<option value="handwriting">handwriting</option>
			<option value="display">display</option>
			<option value="monospace">monospace</option>
		</select></p>
		*/ ?>
	<p>
		<label for=""><?php echo TCK_Text::_('CK_USE_LOCAL_GFONTS') ?></label>
		<select id="ckuselocalgfonts" name="ckuselocalgfonts">
			<option value="1"><?php echo TCK_Text::_('CK_YES') ?></option>
			<option value="0"><?php echo TCK_Text::_('CK_NO') ?></option>
		</select>
		<p><?php echo TCK_Text::_('CK_USE_LOCAL_GFONTS_DESC') ?></p>
	</p>
	<div id="ckgooglefontslist" class="ckfontslist"></div>
	</div>
	<div id="ckgooglefontdetails"></div>
	<div id="ckgooglefontpanel">
		<div id="ckgooglefontpanel-list"></div>
		<div id="ckgooglefontpanel-toolbar">
			<div class="ckbutton ckbutton-primary" onclick="ckSaveFonts()"><i class="fack fack-save"></i> <?php echo TCK_Text::_('CK_SAVE') ?></div>
			<div class="ckbutton" onclick="ckExitFonts()"><?php echo TCK_Text::_('CK_EXIT') ?></div>
		</div>
	</div>
</div>
<script>
var TEMPLATECREATORCK_ADMIN_URL = '<?php echo TEMPLATECREATORCK_ADMIN_URL ?>';
var CKTOKEN = '<?php echo TemplateckHelper::getToken() ?>=1';

function ckgetFontsLibrary(targetId) {
	var setVar = 'google';
	jQuery('#' + targetId).addClass('ckwait');
	var debug = false;

	// sessionStorage.setItem('fonts_library_' + setVar,'');
	if (!debug && window.sessionStorage && sessionStorage.getItem('fonts_library_' + setVar)) {
		var html = sessionStorage.getItem('fonts_library_' + setVar);
		jQuery('#' + targetId).empty().append(html);
		jQuery('#' + targetId).removeClass('ckwait');
		ckScrollFonts();
		// load the data
		ckLoadFontsDataFromInterface();
	} else {
		console.log('depuis ajax');
		// var url = 'https://media.joomlack.fr/api/fonts/list/google';
		var url = 'https://www.googleapis.com/webfonts/v1/webfonts?key=AIzaSyA1U444P79sRH3hB2nOTHmiDjL_URoLsWU';
		jQuery.ajax({
			url: url,
			dataType: 'jsonp',
			cache: true,
			jsonpCallback: "joomlack_jsonpcallback",
			timeout: 20000,
			success: function (response) {
				jQuery('#' + targetId).removeClass('ckwait');
				var html = '';
				var items = response.items;
				for (var i=0;i<items.length;i++) {
					html += ckFontItemDisplay(items[i]);
				}
				html = '<p class="ckfontslistnumber">' + i + ' fonts found</p>' + html;
				jQuery('#' + targetId).empty().append(html);
				sessionStorage.setItem('fonts_library_' + setVar, html);
				ckScrollFonts();
				// load the data
				ckLoadFontsDataFromInterface();
			},
			fail: function() {
				alert('Error : Unable to connect to the library. Please contact an administrator');
			},
			complete: function() {

			},
			error: function(request, status, error) {

			}
		});
	}
}
// immediately load the library in the page
ckgetFontsLibrary('ckgooglefontslist');

function ckFontItemDisplay(item) {
	var name = item.family;
	var styles = item.variants;
//	var subsets = item.subsets;
	var category = item.category;
	var html = '';
	html += '<div class="ckfontitem" onclick="ckShowFontDetails(this)" loading="lazy" data-font="' + name + '" data-name="' + name.toLowerCase() + '" data-category="' + category + '">'
				+ '<div class="ckfontitem-json">' + JSON.stringify(item) + '</div>'
				+ '<div class="ckfontitem-name">' + name + '</div>'
				+ '<div class="ckfontitem-styles"><span class="ckfontitem-styles-count">' + styles.length + '</span> <?php echo TCK_Text::_('CK_STYLES') ?></div>'
				+ '<div class="ckfontitem-state"></div>'
				+ '<div class="ckfontitem-demo">Almost before we knew it, we had left the ground.</div>'
			+ '</div>';

	return html;
}

function ckScrollFonts() {
	var limit = jQuery(window).scrollTop() + jQuery(window).height();
	var items = jQuery('.ckfontitem:not([data-loaded="1"])');

	items.each(function(i) {
		var $item = jQuery(this);
		if ($item.offset().top < limit && document.getElementById('ckgooglefontslist').style.display !== 'none') {
			
			ckLoadGoogleFontForPreview($item);
		} else {
			return false;
		}
	});
}

function ckLoadGoogleFontForPreview($item) {
	var name = $item.attr('data-font');
	var fontfamily = name.replace(/\+/g, ' ');
	jQuery(document.head).append('<link href="https://fonts.googleapis.com/css2?family=' + name + '" rel="stylesheet">')
	$item.attr('data-loaded', '1');
	$item.find('.ckfontitem-demo').css('font-family', fontfamily).css('color', '#333');
	$item.find('.ckfontitem-state').attr('data-state', '1');
}

function ckFilterFontCategory() {
	var cat = jQuery('#ckselectfontcategory').val();
	if (! cat) {
		jQuery('.ckfontitem').show();
		return;
	} else {
		jQuery('.ckfontitem').hide();
		jQuery('.ckfontitem[data-category="' + cat + '"]').show();
	}
}

function ckSearchFontCategory() {
	var search = jQuery('#cksearchfontcategory').val().trim().toLowerCase();
	if (! search) {
		jQuery('.ckfontitem').show();
		return;
	} else {
		jQuery('.ckfontitem').hide();
		var items = jQuery('.ckfontitem[data-name*="' + search + '"]');
		items.show();
		items.each(function(i) {
			var $item = jQuery(this);
			ckLoadGoogleFontForPreview($item);
		});
	}
}

function ckShowFontDetails(item) {
	var $item = jQuery(item);
	var settings = $item.find('.ckfontitem-json').html();
	var settingsObj = JSON.parse(settings);
	jQuery('#ckgooglefontslist').hide();
	jQuery('#fontslistcontainer').hide();
	var details = ckFontDetailsDisplay(settingsObj);
	jQuery('#ckgooglefontdetails').empty().show().append(details).append('<div class="ckfontitem-json">' + settings + '</div>');
	ckAddEventOnButtons();
	ckCheckSelectedFonts();
}

function ckFontDetailsDisplay(item) {
	var name = item.family;
	var category = item.category;
	var subsets = item.subsets;
	var variants = item.variants;
	var text = 'Almost before we knew it, we had left the ground.';
	var html = '';
	html += '<div class="ckfontitem-details" data-font="' + name + '" data-name="' + name.toLowerCase() + '" data-category="' + category + '">'
				+ '<div class="ckfontitem-details-close ckbutton" onclick="ckBackTofontsList()"><span class="fack fack-chevron-left"></span> <?php echo TCK_Text::_('CK_BACK') ?></div>'
				+ '<div class="ckfontitem-name">' + name + '</div>'
				+ '<div class="ckfontitem-details-styles"><?php echo TCK_Text::_('CK_STYLES') ?></div>'
	for (var i = 0; i < variants.length; i++) {
		var variant = variants[i]; // can be 'regular', '500italic'
		var fontweight = variant.replace('italic', '');
		var fontstyle = '';
		if (variant.indexOf('italic') > -1) fontstyle = 'italic';
		if (fontweight == 'regular') fontweight = '400';
		if (fontweight == '') fontweight = '400';
		var variantdetail = (fontweight == variant) ? variant : variant + ' ' + fontweight;
		var style = 'style="font-family:' + name + ';' + (fontstyle ? 'font-style:' + fontstyle : '') + ';font-weight:' + fontweight + ';"'
		html += '<div class="ckfontitem-variant-line" data-variant="'+ variant + '" data-weight="'+ fontweight + '" data-style="'+ fontstyle + '" data-file="' + item.files[variant] + '">'
			
			+ '<div class="ckfontitem-variant-detail"> ' + variantdetail + '</div>'
			+ '<div class="ckfontitem-variant-checkbox-button">'
			+ '<input type="checkbox" name="ckfontitem-variant-checkbox" id="ckfontitem-variant-checkbox-' + i + '" />&nbsp;'
			+ '<label class="ckfontitem-variant-checkbox-label" for="ckfontitem-variant-checkbox-' + i + '"><?php echo TCK_Text::_('CK_USE_THIS_STYLE') ?></label>'
			+ '</div>'
			+ '<div class="ckfontitem-variant" ' + style + '>' + text + '</div>'
			+ '</div>'
	}
	html += '</div>';

	return html;
}

function ckBackTofontsList() {
	jQuery('#ckgooglefontdetails').hide();
	jQuery('#ckgooglefontslist').show();
	jQuery('#fontslistcontainer').show();
}

function ckDownloadGFontFiles() {
	var fontitems = jQuery('#ckgooglefontpanel .ckfontlistitem');

	var f = 0;
	fontitems.each(function() {
		f++;
		var fontitem = jQuery(this);

		var v = 0;
		var variants = fontitem.find('.ckfontlistitem-variant');
		var fontvarsregular = new Array();
		var fontvarsitalic = new Array();
		variants.each(function() {
			v++;
			var listitem = jQuery(this);
			var url = jQuery(this).attr('data-file');
			var variantWeight = jQuery(this).attr('data-weight') ? jQuery(this).attr('data-weight') : '400';
			var variantStyle = jQuery(this).attr('data-style');
			if (variantStyle === 'italic') {
				fontvarsitalic.push('1' + ',' + variantWeight);
			} else {
				fontvarsregular.push('0' + ',' + variantWeight);
			}
		});
		fontvarsregular.sort();
		fontvarsitalic.sort();
		fontvarsregular = fontvarsregular.join(';');
		fontvarsitalic = fontvarsitalic.join(';');

		if (fontvarsregular) {
			var fontvars = fontvarsregular + (fontvarsitalic ? ';' + fontvarsitalic : '');
		} else {
			var fontvars = fontvarsitalic;
		}

		// create the font css url
		var fontname = fontitem.attr('data-font');
		// console.log(fontname);
		fontname = fontname.replace(/ /g, '+');

		var fonturl = 'https://fonts.googleapis.com/css2?family=' + fontname + ':ital,wght@' + fontvars + '&display=swap';
		//https://fonts.googleapis.com/css2?family=Alegreya:ital,wght@1,600&display=swap
		// 0 = regular
		// 1 = italic
		// 600 = font weight
		
		// load the stylesheet in the page
		window.parent.ckAddGooglefontStylesheet(fontname, fonturl);

		if (document.getElementById('ckuselocalgfonts').value == '1') {
		var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=loadgfontcss&" + CKTOKEN;
		// var url = 'https://media.joomlack.fr/api/fonts/list/google';
		jQuery.ajax({
			type: "POST",
			async: "false",
			url: myurl,
			data: {
				'url' : fonturl,
				'fontname' : fontname
			}
		}).done(function(code) {
			var result = JSON.parse(code);
			if (result.status === '0') {
				alert(result.msg);
			}
			
			fontitem.find('.ckfontlistitem-title').append('<span class="ckbadge ckbadge-success ckfontlistitem-filesize">' + parseInt(parseInt(result.filesize) / 1000) + ' kb</span>');
			fontitem.attr('data-cssurl', result.file);
			f--;

			if (f === 0) {
				ckAfterFontsDownloaded();
			}
		}).fail(function(code) {
			alert(TCK.Text._('CK_FAILED', 'Failed'));
		});
		} else {
			ckAfterFontsDownloaded();
		}
	});
}

function ckAddEventOnButtons() {
	jQuery('[name="ckfontitem-variant-checkbox"]').on('change', function() {
		var variant = jQuery(jQuery(this).parents('.ckfontitem-variant-line')[0]);
		var font = jQuery('#ckgooglefontdetails');
		var fontName = font.find('.ckfontitem-name')[0].innerHTML;
		var variantName = variant.attr('data-variant');
		var fontWeight = variant.attr('data-weight');
		var fontStyle = variant.attr('data-style');
		var fontFile = variant.attr('data-file');

		if (this.checked) {
			ckAddStyleInPanel(fontName, variantName, fontWeight, fontStyle, fontFile);
		} else {
			ckRemoveStyleInPanel(fontName, variantName, fontWeight, fontStyle);
		}
	});
}

function ckAddStyleInPanel(fontName, variantName, fontWeight, fontStyle, fontFile) {
	if (! jQuery('#ckgooglefontpanel-list .ckfontlistitem[data-font="' + fontName + '"]').length) {
		jQuery('#ckgooglefontpanel-list').append(
			'<div class="ckfontlistitem" data-font="' + fontName + '">'
			+ '<h3 class="ckfontlistitem-title"><a href="javascript:void(0)" onclick="ckShowFontDetailsFromPanel(\'' + fontName + '\')">' + fontName + '</a></h3>'
			+ '<div class="ckfontlistitem-variants"></div>'
			+ '</div>');
	}
	var listitem = jQuery('#ckgooglefontpanel-list .ckfontlistitem[data-font="' + fontName + '"]');
	// var fontitem = jQuery('#ckgooglefontdetails .ckfontitem-details[data-font="' + fontName + '"] .ckfontitem-variant-line[data-variant="' + variantName + '"]');
	// console.log(fontitem.attr('data-file'));

	if (! listitem.find('.ckfontlistitem-variant[data-variant="' + variantName + '"]').length) {
		listitem.find('.ckfontlistitem-variants').append('<div class="ckfontlistitem-variant" data-font="' + fontName + '" data-variant="' + variantName + '" data-weight="' + fontWeight + '" data-style="' + fontStyle + '" data-file="' + fontFile + '">' 
		+ '<span>' + fontWeight + ' ' + fontStyle + '</span>' 
		+ '<div class="ckfontlistitem-variant-button-remove" onclick="ckRemoveStyleFromPanel(this)"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><<path d="M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM168 232C154.7 232 144 242.7 144 256C144 269.3 154.7 280 168 280H344C357.3 280 368 269.3 368 256C368 242.7 357.3 232 344 232H168z"/></svg></div>'
		+ '</div>');
	}
}

function ckRemoveStyleInPanel(fontName, variantName, fontWeight, fontStyle) {
	var confirmed = window.parent.ckRemoveGoogleFont(fontName);
	if (! confirmed) return;

	var listitem = jQuery('#ckgooglefontpanel .ckfontlistitem[data-font="' + fontName + '"]');
	if (listitem.find('.ckfontlistitem-variant').length > 1) {
		listitem.find('.ckfontlistitem-variant[data-variant="' + variantName + '"]').remove();
	} else {
		listitem.remove();
	}
	jQuery('#ckgooglefontdetails .ckfontitem-details[data-font="' + fontName + '"] .ckfontitem-variant-line[data-variant="' + variantName + '"] input[type="checkbox"]').prop('checked', '');
	ckSaveFonts();
}

function ckRemoveStyleFromPanel(btn) {
	var variant = jQuery(jQuery(btn).parents('.ckfontlistitem-variant')[0]);
	var fontName = variant.attr('data-font');
	var variantName = variant.attr('data-variant');
	ckRemoveStyleInPanel(fontName, variantName);
}

function ckShowFontDetailsFromPanel(fontName) {
	var $item = jQuery('#ckgooglefontslist .ckfontitem[data-name="' + fontName.toLowerCase() + '"]');
	$item.trigger('click');
	ckLoadGoogleFontForPreview($item);
}

function ckCheckSelectedFonts() {
	var fontName = jQuery('#ckgooglefontdetails .ckfontitem-details').attr('data-font');
	var listitem = jQuery('#ckgooglefontpanel .ckfontlistitem[data-font="' + fontName + '"]');
	var variants = listitem.find('.ckfontlistitem-variant');
	variants.each(function() {
		var variant = jQuery(this).attr('data-variant');
		jQuery('#ckgooglefontdetails .ckfontitem-details .ckfontitem-variant-line[data-variant="' + variant + '"]').find('input[name="ckfontitem-variant-checkbox"]').prop('checked', 'checked');
	});
}

function ckSaveFonts() {
	ckAddSpinnerIcon(jQuery('#ckgooglefontpanel-toolbar .ckbutton-primary'));
	jQuery('.ckfontlistitem-filesize').remove();
	jQuery('#ckgooglefontpanel-info').remove();
	ckDownloadGFontFiles();
}

function ckAddSpinnerIcon(btn) {
	if (! btn.attr('data-class')) var icon = btn.find('.fack').attr('class');
	btn.attr('data-class', icon).find('.fack').attr('class', 'fa fack-spinner fack-pulse').css('opacity', '1');
}

function ckRemoveSpinnerIcon(btn) {
	btn.find('.fack').attr('class', btn.attr('data-class'));
}

function ckExitFonts() {
	window.parent.CKBox.close();
}

function ckAfterFontsDownloaded() {
	var filesizes = jQuery('.ckfontlistitem-filesize');
	var totalfilesize = 0;
	filesizes.each(function() {
		totalfilesize += parseInt(jQuery(this).text())
	});
	jQuery('#ckgooglefontpanel-info').remove();
	jQuery('#ckgooglefontpanel').append('<div id="ckgooglefontpanel-info"><?php echo TCK_Text::_('CK_TOTAL_FILE_SIZE', true) ?> : ' + totalfilesize + ' kb' + '</div>');
	
	var bodyfontsprops = window.parent.ckGetPropsForBloc('body', 'googlefonts');
	var listitems = jQuery('#ckgooglefontpanel .ckfontlistitem');
	var fontslist = new Array();
	var cssurllist = new Array();
	var variantslist = new Array();
	listitems.each(function() {
		fontslist.push(jQuery(this).attr('data-font').replace(/ /g, '+'));
		cssurllist.push(jQuery(this).attr('data-cssurl'));
		var variants = new Array();
		jQuery(this).find('.ckfontlistitem-variant').each(function() {
			variants.push(jQuery(this).attr('data-weight') + '||' + jQuery(this).attr('data-style'));
		});
		variantslist.push(jQuery(this).attr('data-font') + '@' + variants.join(';'));
	});

	fontslist = fontslist.join(',');
	cssurllist = cssurllist.join(',');
	variantslist = variantslist.join(',');
	bodyfontsprops.attr('fontslist', fontslist);
	bodyfontsprops.attr('cssurllist', cssurllist);
	bodyfontsprops.attr('variantslist', variantslist);
	bodyfontsprops.attr('uselocal', document.getElementById('ckuselocalgfonts').value);
	window.parent.ckAddGoogleFontsToList();
	ckRemoveSpinnerIcon(jQuery('#ckgooglefontpanel-toolbar .ckbutton-primary'));
}

jQuery(window).scroll(function() {
	ckScrollFonts();
});

jQuery(document.body).scroll(function() {
	ckScrollFonts();
});

function ckLoadFontsDataFromInterface() {
	var bodyfontsprops = window.parent.ckGetPropsForBloc('body', 'googlefonts');
	if (! bodyfontsprops.length) return;

	var fontslist = bodyfontsprops.attr('fontslist');
	var variantslist = bodyfontsprops.attr('variantslist');
	var uselocal = bodyfontsprops.attr('uselocal');
	if (uselocal == '1') {
		document.getElementById('ckuselocalgfonts').value = '1';
	} else {
		document.getElementById('ckuselocalgfonts').value = '0';
	}
	if (fontslist) {

		if (variantslist) {
			var list = variantslist.split(',');
		} else { // for old method, B/C
			var list = fontslist.split(','); //Alegreya+Sans:ital,wght@1,100
	//		var list = fontName + ':ital,wght@0,400'; //Alegreya+Sans:ital,wght@1,100
			for (var i=0; i < list.length; i++) {
//				console.log('list');
//				console.log(list[i]);
				list[i] = list[i] + '@400';
	//			list[i] = list[i] + '@0,400';
			}
		}

		for (var i=0; i < list.length; i++) {
			var row = list[i]; 							// ABeeZee@regular;italic
			var splitted = row.split('@');
			var fontName = splitted[0]; 					// ABeeZee
			var $item = jQuery('.ckfontitem[data-font="' + fontName + '"]');
			var settings = $item.find('.ckfontitem-json').html();
			var settingsObj = JSON.parse(settings);
			var variants = splitted[1].split(';');			// regular;italic

			for (var j=0; j < variants.length; j++) {
				var variantName = variants[j].replace('||', '');			// regular
				var fontWeight = variantName.replace('italic', '');
				var fontStyle = '';
				if (variantName.indexOf('italic') > -1) fontStyle = 'italic';
				if (fontWeight == 'regular') fontWeight = '400';
				if (variantName == '400') variantName = 'regular';
				if (variantName == '400italic') variantName = 'italic';
				var fontFile = settingsObj.files[variantName];

				ckAddStyleInPanel(fontName, variantName, fontWeight, fontStyle, fontFile);
			}
		}
	}
}


</script>
<style>
html {
	overflow-y: hidden;
}

body {
	background: #fff;
	overflow-y: scroll;
	max-height: 100%;
}

* {
	box-sizing: border-box;
}

#fontpreview {
	font-size: 28px;
	display: block;
	line-height: 1.5em;
	padding: 20px 0;
}

label {
	display: inline-block !important;
	min-width: 200px;
}

.fack-spinner {
	opacity: 0;
}

.ckfontslist * {
	box-sizing: border-box;
}

.ckfontslistnumber {
	flex: 1 1 100%;
}

.ckfontitem {
	flex: 1 1 auto;
	min-width: 250px;
	width: 350px;
	cursor: pointer;
	border: 1px solid #ddd;
	border-radius: 5px;
	padding: 15px;
	color: #333;
	font-size: 13px;
	margin: 15px;
	position: relative;
}

.ckfontitem:hover {
	box-shadow: #ccc 0 0 15px;
}

.ckfontslist {
	display: flex;
	flex-wrap: wrap;
}

body {
	width: calc(100% - 300px);
}

.ckfontitem-name {
	font-size: 14px;
	color: #444;
}

.ckfontitem-demo {
	font-size: 40px;
	text-align: left;
	line-height: 1;
	margin: 10px 0;
	color: #fff;
}

.ckfontitem-json {
	display: none;
}

.ckfontitem-styles {
	position: absolute;
	right: 50px;
	top: 15px;
	color: #999;
}

.ckfontitem-state {
	position: absolute;
	right: 15px;
	top: 15px;
	width: 10px;
	height: 10px;
	/*background: #ddd;*/
	border-radius: 50%;
}

.ckfontitem-state[data-state="1"] {
	/*background: green;*/
}

.ckfontitem-variant {
	font-size: 60px;
	line-height: 1;
	white-space: nowrap;
	overflow: hidden;
	padding: 15px;
	margin: 10px 0;
	border: 1px solid #ddd;
	overflow: auto;
	border-radius: 5px;
}

.ckfontitem-variant-detail {
	display: inline-block;
}

input[name="ckfontitem-variant-checkbox"]:checked ~ .ckfontitem-variant {
	border-color: rgba(82,168,236,0.8);
}

input[name="ckfontitem-variant-checkbox"]:checked + label {
	color: rgba(82,168,236,1);
	border-color: rgba(82,168,236,1);
}

.ckfontitem-details .ckfontitem-name {
	font-size: 36px;
	line-height: 1;
	margin: 20px;
}

.ckfontitem-details-styles {
	color: #aaa;
	font-size: 20px;
	line-height: 1;
	margin: 5px 0 20px;;
}

#ckgooglefontpanel {
	position: fixed;
	top: 0;
	bottom: 0;
	right: 0;
	width: 300px;
	background: #fff;
	box-shadow: rgba(0,0,0,0.5) 0 0 10px;
	z-index: 1111;
	padding-bottom: 80px;
}

label.ckfontitem-variant-checkbox-label {
	margin: 0;
	color: #666;
	font-size: 16px;
	background: #fff;
	border: #ddd 1px solid;
	padding: 5px 20px 5px 30px;
	display: inline-block;
	min-width: 0;
	width: auto;
	border-radius: 3px;
}

label.ckfontitem-variant-checkbox-label:hover {
	background: #eee;
	border: #eee 1px solid;
}

.ckfontitem-variant-checkbox-button {
	display: inline-block;
	margin: 0 20px;
	position: relative;
}

input[name="ckfontitem-variant-checkbox"] {
	position: absolute;
	margin: 10px;
}

.ckfontlistitem-variant-button-remove svg {
	width: 16px;
	height: 16px;
	line-height: 0;
	fill: #fff;
	background: #333;
	border-radius: 50%;
	border: 1px solid #333;
	box-sizing: border-box;
}

.ckfontlistitem-variant-button-remove {
	display: inline-block;
	margin-left: auto;
	border-radius: 50%;
	height: 16px;
	width: 16px;
	box-sizing: content-box;
	border: 5px solid transparent;
	cursor: pointer;
}

.ckfontlistitem-variant-button-remove:hover {
	border: 5px solid rgba(82,168,236,0.2);
}

.ckfontlistitem {
	margin: 10px;
	border: 1px solid #ddd;
	border-radius: 4px;
	padding: 10px;
}

.ckfontlistitem-title {
	color: #1a73e8;
}

.ckfontlistitem-variant {
	font-size: 14px;
	display: flex;
}

div#ckgooglefontpanel-toolbar {
	position: absolute;
	bottom: 0;
	left: 0;
	right: 0;
	background: #eee;
	padding: 20px;
	height: 80px;
	box-sizing: border-box;
}

#ckgooglefontpanel-toolbar {
	text-align: center;
}

#ckgooglefontpanel-toolbar .ckbutton {
	padding: 7px 20px;
	border-radius: 4px;
}

#ckgooglefontpanel .ckfontlistitem-filesize {
	height: 18px;
	margin-top: 3px;
	float: right;
}

#ckgooglefontpanel-info {
	margin: 10px;
	padding: 10px;
	background: #eee;
	color: #666;
	border-radius: 4px;
}

#ckgooglefontpanel-list {
	height: calc(100% - 80px);
	overflow: auto;
}

</style>