<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

use Templatecreatorck\CKModel;
use Templatecreatorck\CKFof;

class TemplateckModelQuickdata extends CKModel
{
	function __construct() {
		parent::__construct();
	}
	
	/**
	 * Method to install the demo data
	 *
	 * @access	public
	 * @return	true on success
	 */
	public function getModules() {
		$app = \Templatecreatorck\CKFof::getApplication();
		$name = $app->input->get('name', '', 'string');

		$modulesList = TEMPLATECREATORCK_SITE_ROOT . '/templates/' . $name . '/modules.qdtck';
		if (! file_exists($modulesList)) 
			$modulesList = TEMPLATECREATORCK_SITE_ROOT . '/templates/' . $name . '/modules.txt';
		
		if (! file_exists($modulesList)) return array();

		$modules = file_get_contents($modulesList);
		$modules = unserialize($modules);

		$existingTypes = array();
		foreach ($modules as &$module) {
			$type = $module->module;
			// check if the module type is installed in the website
			if (array_key_exists($type, $existingTypes)) {
				$module->installed = $existingTypes[$type];
			} else {
				$module->installed = $this->checkIfModuleTypeExists($type);
				$existingTypes[$type] = $module->installed;
			}			
		}

		return $modules;
	}

	private function replaceRoot($text) {
		$text = str_replace("\|URIBASE\|", \Templatecreatorck\CKUri::root(true), $text);

		return $text;
	}

	private function checkIfModuleTypeExists($type) {
		$result = CKFof::dbLoadResult("SELECT extension_id FROM #__extensions WHERE element = '" . $type . "'");

		return $result;
	}

	public function importModule($module) {
		$module->params = $this->replaceRoot($module->params);
		$module->id = 0;
		$module->publish_up = null;
		$module->publish_down = null;
		$moduleid = CKFof::dbStore('#__modules', $module);
		$assign = array('id' => 0, 'moduleid' => $moduleid, 'menuid' => 0);
		$assignment = CKFof::dbStore('#__modules_menu', $assign);

		return $moduleid;
	}
}
