<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

class TemplateckInstaller extends \Templatecreatorck\CKObject {

	/**
	 * Install an extension from either folder, url or upload.
	 *
	 * @return  boolean result of install.
	 *
	 * @since   1.5
	 */
	public function install()
	{
		// $this->setState('action', 'install');

		// Set FTP credentials, if given.
		\Joomla\CMS\Application\CliApplicationentHelper::setCredentialsFromRequest('ftp');
		$app = \Templatecreatorck\CKFof::getApplication();

		// Load installer plugins for assistance if required:
		\Joomla\CMS\Plugin\PluginHelper::importPlugin('installer');
		$dispatcher = JEventDispatcher::getInstance();

		$package = null;

		// This event allows an input pre-treatment, a custom pre-packing or custom installation.
		// (e.g. from a JSON description).
		$results = $dispatcher->trigger('onInstallerBeforeInstallation', array($this, &$package));

		if (in_array(true, $results, true))
		{
			return true;
		}

		if (in_array(false, $results, true))
		{
			return false;
		}

		// $installType = $app->input->getWord('installtype');
		$installType = 'url';
		$package = $this->_getPackageFromUrl();

		// This event allows a custom installation of the package or a customization of the package:
		$results = $dispatcher->trigger('onInstallerBeforeInstaller', array($this, &$package));

		if (in_array(true, $results, true))
		{
			return true;
		}

		if (in_array(false, $results, true))
		{
			if (in_array($installType, array('upload', 'url')))
			{
				\Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
			}

			return false;
		}

		// Was the package unpacked?
		if (!$package || !$package['type'])
		{
			if (in_array($installType, array('upload', 'url')))
			{
				\Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
			}

			$app->enqueueMessage(TCK_Text::_('COM_INSTALLER_UNABLE_TO_FIND_INSTALL_PACKAGE'), 'error');

			return false;
		}

		// Get an installer instance.
		$installer = \Joomla\CMS\Installer\Installer::getInstance();

		// Install the package.
		if (!$installer->install($package['dir']))
		{
			// There was an error installing the package.
			$msg = TCK_Text::sprintf('COM_INSTALLER_INSTALL_ERROR', TCK_Text::_('COM_INSTALLER_TYPE_TYPE_' . strtoupper($package['type'])));
			$result = false;
			$msgType = 'error';
		}
		else
		{
			// Package installed sucessfully.
			$msg = TCK_Text::sprintf('COM_INSTALLER_INSTALL_SUCCESS', TCK_Text::_('COM_INSTALLER_TYPE_TYPE_' . strtoupper($package['type'])));
			$result = true;
			$msgType = 'message';
		}

		// This event allows a custom a post-flight:
		$dispatcher->trigger('onInstallerAfterInstaller', array($this, &$package, $installer, &$result, &$msg));

		// Set some model state values.
		$app = \Templatecreatorck\CKFof::getApplication();
		$app->enqueueMessage($msg, $msgType);
		// $this->setState('name', $installer->get('name'));
		// $this->setState('result', $result);
		$app->setUserState('com_installer.message', $installer->message);
		$app->setUserState('com_installer.extension_message', $installer->get('extension_message'));
		$app->setUserState('com_installer.redirect_url', $installer->get('redirect_url'));

		// Cleanup the install files.
		if (!is_file($package['packagefile']))
		{
			$config = \Joomla\CMS\Factory::getConfig();
			$package['packagefile'] = $config->get('tmp_path') . '/' . $package['packagefile'];
		}

		\Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);

		return $result;
	}

	/**
	 * Install an extension from a URL.
	 *
	 * @return  Package details or false on failure.
	 *
	 * @since   1.5
	 */
	protected function _getPackageFromUrl()
	{
		$input = \Templatecreatorck\CKFof::getApplication()->input;

		// Get the URL of the package to install.
		$url = $input->getString('install_url');

		// Did you give us a URL?
		if (!$url)
		{
			throw new Exception(TCK_Text::_('COM_INSTALLER_MSG_INSTALL_ENTER_A_URL'), 403);

			return false;
		}

		// Handle updater XML file case:
		if (preg_match('/\.xml\s*$/', $url))
		{
			jimport('joomla.updater.update');
			$update = new \Joomla\CMS\Updater\Update;
			$update->loadFromXml($url);
			$package_url = trim($update->get('downloadurl', false)->_data);

			if ($package_url)
			{
				$url = $package_url;
			}

			unset($update);
		}

		// Download the package at the URL given.
		$p_file = \Joomla\CMS\Installer\InstallerHelper::downloadPackage($url);

		// Was the package downloaded?
		if (!$p_file)
		{
			throw new Exception(TCK_Text::_('COM_INSTALLER_MSG_INSTALL_INVALID_URL'), 403);

			return false;
		}

		$config   = \Joomla\CMS\Factory::getConfig();
		$tmp_dest = $config->get('tmp_path');

		// Unpack the downloaded package file.
		$package = \Joomla\CMS\Installer\InstallerHelper::unpack($tmp_dest . '/' . $p_file, true);

		return $package;
	}
}