<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die();

use Templatecreatorck\CKController;
use Templatecreatorck\CKFof;

class TemplateckControllerFont extends CKController {

	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct() {
		parent::__construct();
	}

	/**
	 * display input form to select a zip file
	 * @return void
	 */
	function installTheme() {
		$this->input->set('view', 'fonts');
		$this->input->set('layout', 'install');

		parent::display();
	}

	/**
	 * display input form to select a zip file
	 * @return void
	 */
	function installFontsquirrel() {
		$this->input->set('view', 'fonts');
		$this->input->set('layout', 'installfontsquirrel');

		parent::display();
	}

	/**
	 * display input form to select a zip file
	 * @return void
	 */
	function installFontgoogle() {
		$this->input->set('view', 'fonts');
		$this->input->set('layout', 'installfontgoogle');

		parent::display();
	}

	/**
	 * import a font from fontsquirrel
	 * @return void
	 */
	function importzipfromsquirrel() {
		$model = $this->getModel();
		if (!$model->installFontsquirrel()) {
			$msg = TCK_Text::_('CK_INSTALL_FONT_ERROR');
			$link = 'index.php?option=com_templateck&view=fonts&layout=install';
			$type = 'error';
		} else {
			$msg = TCK_Text::_('CK_FONT_INSTALLED');
			$link = 'index.php?option=com_templateck&view=fonts';
			$type = 'message';
		}

		CKFof::redirect($link, $msg, $type);
	}

	/**
	 * import a font from google
	 * @return void
	 */
	function importstylesfromgoogle() {
		$model = $this->getModel();
		if (!$model->installFontgoogle()) {
			$msg = TCK_Text::_('CK_INSTALL_FONT_ERROR');
			$link = 'index.php?option=com_templateck&view=fonts&layout=install';
			$type = 'error';
		} else {
			$msg = TCK_Text::_('CK_FONT_INSTALLED');
			$link = 'index.php?option=com_templateck&view=fonts';
			$type = 'message';
		}

		CKFof::redirect($link, $msg, $type);
	}

	/**
	 * import a font from google
	 * @return void
	 */
	function delete() {
		$model = $this->getModel();
		$cids = $this->input->get('cid', array(0), 'post', 'array');
		if (!$model->delete($cids)) {
			$msg = TCK_Text::_('CK_DELETE_FONT_ERROR');
			$link = 'index.php?option=com_templateck&view=fonts&layout=install';
			$type = 'error';
		} else {
			$msg = TCK_Text::_('CK_FONT_DELETED');
			$link = 'index.php?option=com_templateck&view=fonts';
			$type = 'message';
		}

		CKFof::redirect($link, $msg, $type);
	}

	function cancel() {
		//Redirect back to list
		CKFof::redirect('index.php?option=com_templateck&view=fonts', false);
	}
}
