<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
if (! defined('TCK_ARTICLE_IMAGEPOSITION')) define('TCK_ARTICLE_IMAGEPOSITION', 'above');

// Create a shortcut for params.
$params  = &$this->item->params;
$canEdit = $this->item->params->get('access-edit');
$info    = $this->item->params->get('info_block_position', 0);

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (\Joomla\CMS\Language\Associations::isEnabled() && $params->get('show_associations'));
?>

<?php if ($this->item->state == 0 || strtotime($this->item->publish_up) > strtotime(\Joomla\CMS\Factory::getDate())
	|| ((strtotime($this->item->publish_down) < strtotime(\Joomla\CMS\Factory::getDate())) && $this->item->publish_down != \Templatecreatorck\CKFof::getDbo()->getNullDate())) : ?>
	<div class="system-unpublished">
<?php endif; ?>

<?php if (TCK_ARTICLE_IMAGEPOSITION !== 'under') echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.intro_image', $this->item); ?>
		
<?php if ($params->get('show_title')) : ?>
	<h2 class="item-title tck-article-title" itemprop="headline">
	<?php if ($params->get('link_titles') && $params->get('access-view')) : ?>
		<a href="<?php echo \Joomla\CMS\Router\Route::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)); ?>" itemprop="url">
			<?php echo $this->escape($this->item->title); ?>
		</a>
	<?php else : ?>
		<?php echo $this->escape($this->item->title); ?>
	<?php endif; ?>
	</h2>
<?php endif; ?>

<?php if ($this->item->state == 0) : ?>
	<span class="label label-warning"><?php echo \Templatecreatorck\CKText::_('JUNPUBLISHED'); ?></span>
<?php endif; ?>
<?php if (strtotime($this->item->publish_up) > strtotime(\Joomla\CMS\Factory::getDate())) : ?>
	<span class="label label-warning"><?php echo \Templatecreatorck\CKText::_('JNOTPUBLISHEDYET'); ?></span>
<?php endif; ?>
<?php if ((strtotime($this->item->publish_down) < strtotime(\Joomla\CMS\Factory::getDate())) && $this->item->publish_down != \Templatecreatorck\CKFof::getDbo()->getNullDate()) : ?>
	<span class="label label-warning"><?php echo \Templatecreatorck\CKText::_('JEXPIRED'); ?></span>
<?php endif; ?>

<?php if ($canEdit || $params->get('show_print_icon') || $params->get('show_email_icon')) : ?>
	<?php echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.icons', array('params' => $params, 'item' => $this->item, 'print' => false)); ?>
<?php endif; ?>

<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
<?php echo $this->item->event->afterDisplayTitle; ?>

<?php // Todo Not that elegant would be nice to group the params ?>
<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
	|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author') || $assocParam); ?>

<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
	<?php // Todo: for Joomla4 joomla.content.info_block.block can be changed to joomla.content.info_block ?>
	<?php echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.info_block.block', array('item' => $this->item, 'params' => $params, 'position' => 'above')); ?>
<?php endif; ?>
<?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
	<?php echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.tags', $this->item->tags->itemTags); ?>
<?php endif; ?>

<?php if (TCK_ARTICLE_IMAGEPOSITION === 'under') echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.intro_image', $this->item); ?>

<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
<?php echo $this->item->event->beforeDisplayContent; ?>
<div itemprop="articleBody" class="tck-article-body">
<?php echo $this->item->introtext; ?>
</div>
<?php if ($info == 1 || $info == 2) : ?>
	<?php if ($useDefList) : ?>
		<?php // Todo: for Joomla4 joomla.content.info_block.block can be changed to joomla.content.info_block ?>
		<?php echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.info_block.block', array('item' => $this->item, 'params' => $params, 'position' => 'below')); ?>
	<?php endif; ?>
	<?php if ($params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
		<?php echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.tags', $this->item->tags->itemTags); ?>
	<?php endif; ?>
<?php endif; ?>

<?php if ($params->get('show_readmore') && $this->item->readmore) :
	if ($params->get('access-view')) :
		$link = \Joomla\CMS\Router\Route::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language));
	else :
		$menu = \Templatecreatorck\CKFof::getApplication()->getMenu();
		$active = $menu->getActive();
		$itemId = $active->id;
		$link = new \Joomla\CMS\Uri\Uri(\Joomla\CMS\Router\Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
		$link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)));
	endif; ?>

	<?php echo \Joomla\CMS\Layout\LayoutHelper::render('joomla.content.readmore', array('item' => $this->item, 'params' => $params, 'link' => $link)); ?>

<?php endif; ?>

<?php if ($this->item->state == 0 || strtotime($this->item->publish_up) > strtotime(\Joomla\CMS\Factory::getDate())
	|| ((strtotime($this->item->publish_down) < strtotime(\Joomla\CMS\Factory::getDate())) && $this->item->publish_down != $this->db->getNullDate() )) : ?>
	</div>
<?php endif; ?>

<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
<?php echo $this->item->event->afterDisplayContent; ?>
