<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_contenthistory
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\Contenthistory\Administrator\View\Compare;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\Component\Contenthistory\Administrator\Model\CompareModel;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * View class for a list of contenthistory.
 *
 * @since  3.2
 */
class HtmlView extends BaseHtmlView
{
    /**
     * An array of items
     *
     * @var  array
     */
    protected $items;

    /**
     * The model state
     *
     * @var  \Joomla\Registry\Registry
     */
    protected $state;

    /**
     * Method to display the view.
     *
     * @param   string  $tpl  A template file to load. [optional]
     *
     * @return  void
     *
     * @since   3.2
     */
    public function display($tpl = null)
    {
        /** @var CompareModel $model */
        $model = $this->getModel();
        $model->setUseExceptions(true);

        $this->state = $model->getState();
        $this->items = $model->getItems();

        parent::display($tpl);
    }
}
