<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// no direct access
defined('TCK_LOADED') or die;
$this->_callfonts();
if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
	$lang = \Joomla\CMS\Factory::getLanguage();
	$lang->load('com_templateck', JPATH_ADMINISTRATOR);
	$lang->load('com_templateck', JPATH_SITE);
}
// set browser cache to 0 to refresh and show the real page 
//header("Cache-Control: no-cache, no-store, must-revalidate");
//header("Pragma: no-cache");
//header("Expires: 0");
?>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<base href="<?php echo TEMPLATECREATORCK_ADMIN_URL ?>" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="Expires" content="Tue, 01 Jan 1995 12:12:12 GMT">
<meta http-equiv="Pragma" content="no-cache">
<link href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/images/logo_ck_64_white.png" rel="shortcut icon" type="image/vnd.microsoft.icon" />
<title>Template Creator CK</title>
<script type="text/javascript">
	var URIROOT = "<?php echo TEMPLATECREATORCK_URI_ROOT; ?>";
	var URIBASE = "<?php echo TEMPLATECREATORCK_URI_BASE; ?>";
	var TEMPLATEID = "<?php echo $this->item->id; ?>";
	var TEMPLATEIDENTIFIER = "<?php echo $this->item->identifier; ?>";
	var CKCLIPBOARD = '';
	var CLIPBOARDCOLORCK = '';
	var CKBLOCCKSTYLESBACKUP = '';
	var CKFAVORITELOCKED = '';
	var CKTOKEN = '<?php echo TemplateckHelper::getToken() ?>=1';
	var TEMPLATECREATORCK_ADMIN_URL = '<?php echo TEMPLATECREATORCK_ADMIN_URL ?>';
	var TEMPLATECREATORCK_PATH = '<?php echo addslashes(TEMPLATECREATORCK_PATH) ?>';
	var TEMPLATECREATORCK_MEDIA_URI = '<?php echo TEMPLATECREATORCK_MEDIA_URI ?>';
	var TEMPLATECREATORCK_URI = '<?php echo TEMPLATECREATORCK_URI ?>';
	var TEMPLATECREATORCK_ENABLE_SAVE_ELEMENTS = '<?php echo $this->input->get('elements', 0, 'int') ?>';
	var TEMPLATECREATORCK_PLATFORM = '<?php echo TEMPLATECREATORCK_PLATFORM ?>';
</script>
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckframework.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckbox.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/colpick.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/templateck_template.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/font-awesome.v4.tck.min.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />
<?php Templatecreatorck\CKFramework::loadFaIconsInline() ?>
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/codemirror.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />

<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/jquery.min.js" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/jquery-ui-1.10.4.custom.min.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckbox.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/templateck_template.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/templateck_template_joomla.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/colpick.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/html2canvas.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/codemirror.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/php.js" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/javascript.js" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/css.js" type="text/javascript"></script>

<script type="text/javascript">
	$ck(document).ready(function() {
		ckInitInterface();
		<?php 
		// load only if a new template, to get the list of avaiable premade templates
		if (! isset($this->item->stylecode) || ! $this->item->htmlcode) { ?>
		ckGetLibraryTemplates();
		<?php } ?>
		CKBox.initialize({});
		CKBox.assign($ck('a.modal'), {
			parse: 'rel'
		});
		window.setInterval("ckKeepAlive()", 600000);
		$ck('#ckleftpanel .ckmyfavorite').each(function() {
			ckSeparateStylesForBlock(this.id);
		});
		<?php if ($this->input->get('quickdata', 0, 'int') === 1) { ?>
		ckShowQuickDataImport();
		<?php } ?>
		ckSaveAction();
		$ck('#ckundo').addClass('ckdisabled');
		$ck('#ckredo').addClass('ckdisabled');
	});

	function ckKeepAlive() {
		jQuery.ajax({type: "POST", url: "<?php echo TEMPLATECREATORCK_ADMIN_URL ?>"});
	}

	(function() {
		var strings = {
		  "CK_TEMPLATE_MUST_HAVE_NAME":"<?php echo TCK_Text::_('CK_TEMPLATE_MUST_HAVE_NAME') ?>",
		  "TEMPLATE_MUST_HAVE_WIDTH":"<?php echo TCK_Text::_('TEMPLATE_MUST_HAVE_WIDTH') ?>",
		  "CK_LOADING":"<?php echo TCK_Text::_('CK_LOADING') ?>",
		  "CK_LOAD_SUCCESS_STEP1":"<?php echo TCK_Text::_('CK_LOAD_SUCCESS_STEP1') ?>",
		  "CK_LOAD_FAILURE_STEP1":"<?php echo TCK_Text::_('CK_LOAD_FAILURE_STEP1') ?>",
		  "CK_LOAD_SUCCESS_STEP_ARCHIVE":"<?php echo TCK_Text::_('CK_LOAD_SUCCESS_STEP_ARCHIVE') ?>",
		  "CK_LOAD_FAILURE_STEP_ARCHIVE":"<?php echo TCK_Text::_('CK_LOAD_FAILURE_STEP_ARCHIVE') ?>",
		  "CK_LOAD_SUCCESS_STEP_XML":"<?php echo TCK_Text::_('CK_LOAD_SUCCESS_STEP_XML') ?>",
		  "CK_LOAD_FAILURE_STEP_XML":"<?php echo TCK_Text::_('CK_LOAD_FAILURE_STEP_XML') ?>",
		  "CK_LOAD_SUCCESS_STEP_CSS":"<?php echo TCK_Text::_('CK_LOAD_SUCCESS_STEP_CSS') ?>",
		  "CK_LOAD_FAILURE_STEP_CSS":"<?php echo TCK_Text::_('CK_LOAD_FAILURE_STEP_CSS') ?>",
		  "CK_PREVIEW_TEMPLATE":"<?php echo TCK_Text::_('CK_PREVIEW_TEMPLATE') ?>",
		  "CK_ONLY_ONE_COMPONENT":"<?php echo TCK_Text::_('CK_ONLY_ONE_COMPONENT') ?>",
		  "CK_COPYTOCLIPBOARD":"<?php echo TCK_Text::_('CK_COPYTOCLIPBOARD') ?>",
		  "CK_COPYFROMCLIPBOARD":"<?php echo TCK_Text::_('CK_COPYFROMCLIPBOARD') ?>",
		  "CK_CLIPBOARDEMPTY":"<?php echo TCK_Text::_('CK_CLIPBOARDEMPTY') ?>",
		  "TEMPLATE_MUST_HAVE_CONTENT":"<?php echo TCK_Text::_('TEMPLATE_MUST_HAVE_CONTENT') ?>",
		  "CK_INVALID_ID":"<?php echo TCK_Text::_('CK_INVALID_ID') ?>",
		  "CK_ENTER_VALID_ID":"<?php echo TCK_Text::_('CK_ENTER_VALID_ID') ?>",
		  "CK_ENTER_VALID_POSITION":"<?php echo TCK_Text::_('CK_ENTER_VALID_POSITION') ?>",
		  "CK_ENTER_UNIQUE_ID":"<?php echo TCK_Text::_('CK_ENTER_UNIQUE_ID') ?>",
		  "CK_ENTER_UNIQUE_POSITION":"<?php echo TCK_Text::_('CK_ENTER_UNIQUE_POSITION') ?>",
		  "CK_POSITION_ALREADY_USED":"<?php echo TCK_Text::_('CK_POSITION_ALREADY_USED') ?>",
		  "CK_CHOOSE_BLOC_TYPE":"<?php echo TCK_Text::_('CK_CHOOSE_BLOC_TYPE') ?>",
		  "CK_ERASE_WITH_NEW_THEME":"<?php echo TCK_Text::_('CK_ERASE_WITH_NEW_THEME') ?>",
		  "JLIB_FORM_FIELD_INVALID":"<?php echo TCK_Text::_('JLIB_FORM_FIELD_INVALID') ?>",
		  "CK_DIRECTCOPY_BUTTON":"<?php echo TCK_Text::_('CK_DIRECTCOPY_BUTTON') ?>",
		  "CK_INSTALL_BUTTON":"<?php echo TCK_Text::_('CK_INSTALL_BUTTON') ?>",
		  "CK_DIRECTCOPY_BUTTON_DESC":"<?php echo TCK_Text::_('CK_DIRECTCOPY_BUTTON_DESC') ?>",
		  "CK_INSTALL_BUTTON_DESC":"<?php echo TCK_Text::_('CK_INSTALL_BUTTON_DESC') ?>",
		  "CK_MOVE_TOOLTIP":"<?php echo TCK_Text::_('CK_MOVE_TOOLTIP') ?>",
		  "CK_CSS_TOOLTIP":"<?php echo TCK_Text::_('CK_CSS_TOOLTIP') ?>",
		  "CK_FAVORITE_TOOLTIP":"<?php echo TCK_Text::_('CK_FAVORITE_TOOLTIP') ?>",
		  "CK_MODULES_TOOLTIP":"<?php echo TCK_Text::_('CK_MODULES_TOOLTIP') ?>",
		  "CK_ROW_TOOLTIP":"<?php echo TCK_Text::_('CK_ROW_TOOLTIP') ?>",
		  "CK_BANNER_TOOLTIP":"<?php echo TCK_Text::_('CK_BANNER_TOOLTIP') ?>",
		  "CK_MAINCONTENT_TOOLTIP":"<?php echo TCK_Text::_('CK_MAINCONTENT_TOOLTIP') ?>",
		  "CK_ERASE_WITH_NEW_FAVORITE":"<?php echo TCK_Text::_('CK_ERASE_WITH_NEW_FAVORITE') ?>",
		  "CK_SUCCESS_CREATING_FAVORITEFILE":"<?php echo TCK_Text::_('CK_SUCCESS_CREATING_FAVORITEFILE') ?>",
		  "CK_SELECT_PALETTE":"<?php echo TCK_Text::_('CK_SELECT_PALETTE') ?>",
		  "CK_OK":"<?php echo TCK_Text::_('CK_OK') ?>",
		  "CK_CLEAR":"<?php echo TCK_Text::_('CK_CLEAR') ?>",
		  "CK_COPY":"<?php echo TCK_Text::_('CK_COPY') ?>",
		  "CK_PASTE":"<?php echo TCK_Text::_('CK_PASTE') ?>",
		  "CK_NO_MORE_UNDO":"<?php echo TCK_Text::_('CK_NO_MORE_UNDO') ?>",
		  "CK_NO_MORE_REDO":"<?php echo TCK_Text::_('CK_NO_MORE_REDO') ?>",
		  "CK_EDIT":"<?php echo TCK_Text::_('CK_EDIT') ?>",
		  "CK_DELETE":"<?php echo TCK_Text::_('CK_DELETE') ?>",
		  "CK_BACK_TO_WIDGETS_LIST":"<?php echo TCK_Text::_('CK_BACK_TO_WIDGETS_LIST') ?>",
		  "CK_SAVE_CLOSE":"<?php echo TCK_Text::_('CK_SAVE_CLOSE') ?>",
		  "CK_MODULE_EDITION_TOOLTIP":"<?php echo TCK_Text::_('CK_MODULE_EDITION_TOOLTIP') ?>",
		  "CK_SAVE_FIRST_USE_MODULE":"<?php echo TCK_Text::_('CK_SAVE_FIRST_USE_MODULE') ?>",
		  "CK_MODULE_INSTALL_FAILED":"<?php echo TCK_Text::_('CK_MODULE_INSTALL_FAILED') ?>",
		  "CK_MODULE_INSTALL_SUCCESS":"<?php echo TCK_Text::_('CK_MODULE_INSTALL_SUCCESS') ?>",
		  "CK_TOGGLE_STATE":"<?php echo TCK_Text::_('CK_TOGGLE_STATE') ?>",
		  "CK_POSITION":"<?php echo TCK_Text::_('CK_POSITION') ?>",
		  "CK_HTML_ID":"<?php echo TCK_Text::_('CK_HTML_ID') ?>",
		  "CK_FULLWIDTH":"<?php echo TCK_Text::_('CK_FULLWIDTH') ?>",
		  "CK_FILTER_BY_GROUP":"<?php echo TCK_Text::_('CK_FILTER_BY_GROUP') ?>",
		  "CK_SAVE":"<?php echo TCK_Text::_('CK_SAVE') ?>",
		  "CK_LOAD_FAILURE_TEMPLATE_CREATION":"<?php echo TCK_Text::_('CK_LOAD_FAILURE_TEMPLATE_CREATION') ?>",
		  "CK_RESPONSIVE_SETTINGS_SHOWN":"<?php echo TCK_Text::_('CK_RESPONSIVE_SETTINGS_SHOWN') ?>",
		  "CK_RESPONSIVE_SETTINGS_HIDDEN":"<?php echo TCK_Text::_('CK_RESPONSIVE_SETTINGS_HIDDEN') ?>",
		  "CK_RESPONSIVE_SETTINGS_ALIGNED":"<?php echo TCK_Text::_('CK_RESPONSIVE_SETTINGS_ALIGNED') ?>",
		  "CK_RESPONSIVE_SETTINGS_STACKED":"<?php echo TCK_Text::_('CK_RESPONSIVE_SETTINGS_STACKED') ?>",
		  "CK_EXIT_RESPONSIVE_FIRST":"<?php echo TCK_Text::_('CK_EXIT_RESPONSIVE_FIRST') ?>",
		  "CK_DETAILS":"<?php echo TCK_Text::_('CK_DETAILS') ?>",
		  "CK_LOAD":"<?php echo TCK_Text::_('CK_LOAD') ?>",
		  "CK_DESCRIPTION":"<?php echo TCK_Text::_('CK_DESCRIPTION') ?>",
		  "CK_AUTHOR":"<?php echo TCK_Text::_('CK_AUTHOR') ?>",
		  "CK_PRICE":"<?php echo TCK_Text::_('CK_PRICE') ?>",
		  "CK_FREE":"<?php echo TCK_Text::_('CK_FREE') ?>",
		  "CK_PAGES":"<?php echo TCK_Text::_('CK_PAGES') ?>",
		  "CK_DEMO":"<?php echo TCK_Text::_('CK_DEMO') ?>",
		  "CK_DEMO_NOT_AVAILABLE":"<?php echo TCK_Text::_('CK_DEMO_NOT_AVAILABLE') ?>",
		  "CK_DOCUMENTATION":"<?php echo TCK_Text::_('CK_DOCUMENTATION') ?>",
		  "CK_MANUAL_TEMPLATE_INSTALL_INFOS":"<?php echo TCK_Text::_('CK_MANUAL_TEMPLATE_INSTALL_INFOS') ?>",
		  "CK_READ_DOCUMENTATION":"<?php echo TCK_Text::_('CK_READ_DOCUMENTATION') ?>",
		  "CK_DOWNLOAD":"<?php echo TCK_Text::_('CK_DOWNLOAD') ?>",
		  "CK_MANUAL_DOWNLOAD":"<?php echo TCK_Text::_('CK_MANUAL_DOWNLOAD') ?>",
		  "CK_CONFIRM":"<?php echo TCK_Text::_('CK_CONFIRM') ?>",
		  "CK_CSS_CLASS":"<?php echo TCK_Text::_('CK_CSS_CLASS') ?>",
		  "CK_BACK":"<?php echo TCK_Text::_('CK_BACK') ?>",
		  "CK_QUICK_STYLES":"<?php echo TCK_Text::_('CK_QUICK_STYLES') ?>",
		  "CK_CONFIRM_CLEAR_STYLES":"<?php echo TCK_Text::_('CK_CONFIRM_CLEAR_STYLES') ?>",
		  "CK_EQUALHEIGHTS_TOOLTIP":"<?php echo TCK_Text::_('CK_EQUALHEIGHTS_TOOLTIP') ?>"};
		if (typeof TCK == 'undefined') {
			TCK = {};
			TCK.Text = strings;
		}
		else {
			TCK.Text.load(strings);
		}
	})();
</script>
