<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
//require_once JPATH_COMPONENT . '/helpers/templateck.php';

$document = \Joomla\CMS\Factory::getDocument();
$document->addStyleSheet('components/com_templateck/assets/admin.css');
$document->addStyleSheet('components/com_templateck/assets/ckframework.css');
?>
<div class="ckadminarea"><?php
// check for the update
$latest_version = TemplateckController::get_latest_version();
$is_outdated = TemplateckController::is_outdated();
if ($latest_version !== false) {
	if ($is_outdated) {
		echo '<p class="ckalert ckalert-warning">' . TCK_Text::_('CK_IS_OUTDATED') . ' : <b>' . $latest_version . '</b></p>';
	} else {
		echo '<p class="ckalert ckalert-success">' . TCK_Text::_('CK_IS_UPTODATE') . '</p>';
	}
} else {
	//echo '<p class="alertck">Impossible de lire le fichier de mise à jour sur https://www.template-creator.com</p>';
}
?>
<style>
	.aboutversion {
		margin: 10px;
		padding: 10px;
		font-size: 20px;
		font-color: #000;

	}
	.ckabout {
		background: url("https://media.joomlack.fr/images/texture/texture_003.jpg") center center repeat;
		background-size: auto auto;
		color: #fff;
		font-family: verdana;
		font-size: 13px;
		border-radius: 5px;
		box-shadow: #111 0 0 5px;
		background-size: cover;
		position: relative;
		overflow: hidden;
		text-align: center;
	}
	.ckabout > .inner {
		padding: 20px;
		background: rgba(40,40,40,0.7);
	}
	.ckabout > .inner > *{
		padding: 10px;
	}
	.ckabout > .inner br {
		margin: 10px;
		display: block;
	}
	.ckabout a {
		color: orange;
	}
</style>
<div class="aboutversion"><?php echo TCK_Text::_('CK_TEMPLATECK_VERSION') . ' ' . $this->tckversion; ?></div>

<?php //echo TCK_Text::_('CK_TEMPLATECK_DESC'); ?>
<div class="ckabout">
	<div class="inner">
		<div class="ckcenter"><img src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/images/logo_templateck.png" /></div>
		<p class="ckcenter"><a href="https://www.template-creator.com" target="_blank">https://www.template-creator.com</a></p>
		<p class="ckcenter"><?php echo \Joomla\CMS\Language\Text::_('CK_TEMPLATECK_DESC2'); ?></p>
	</div>
</div>
<?php
$release_notes = TemplateckController::get_release_notes();
if ($release_notes !== false) {
	if (substr($release_notes, 0, 1) != '*') {
		echo '<p class="alertck">Unable to read the file tck_update, there is an error with the characters</p>';
	} else {
		$versions = explode('*', htmlspecialchars($release_notes));
		if ($is_outdated) {
			echo '<br /><p style="text-transform:uppercase;text-decoration: underline;">Release notes :</p><br />';
		}
		foreach ($versions as $v) {
			if (strlen($v) > 0) {
				$lines = explode("\n", $v);
				if (version_compare(trim($lines[0]), $this->tckversion) <= 0) {
					break;
				}
				echo '<h4>' . htmlspecialchars($lines[1]) . '</h4>';
				echo '<ul>';
				for ($i = 2; $i < count($lines); $i++) {
					if (strlen(trim($lines[$i])) > 0) {
						echo '<li>' . htmlspecialchars($lines[$i]) . '</li>';
					}
				}
				echo '</ul>';
			}
		}
	}
}
?>
</div>