<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access.
defined('TCK_LOADED') or die;

use Templatecreatorck\CKModel;
use Templatecreatorck\CKFof;

/**
 * Templateck model.
 */
class TemplateckModelTemplate extends CKModel {

	protected $table = '#__templateck_templates';

	var $item = null;

	function __construct() {
		parent::__construct();
	}

	/**
	 * Method to get an ojbect.
	 *
	 * @param	integer	The id of the object to get.
	 *
	 * @return	mixed	Object on success, false on failure.
	 */
	public function getItem($id = 0) {
		if (empty($this->item)) {
			$id = $this->input->get('id', $id, 'int');
			$this->item = CKFof::dbLoad($this->table, $id);
		}

		// if new template, we must fill with the default data set in the component
		if ($this->item->id == 0) {
			$this->fillDefaultInfos();
		}

		// fix for RSFirewall
		if ($this->item->htmlcode) {
			$this->item->htmlcode = str_replace('<s-tyle>', '<style>', $this->item->htmlcode);
		}

		$this->item->layouts = $this->getLayouts($id);

		return $this->item;
	}

	private function fillDefaultInfos() {
		// get global component params
		$templateckParams = \Joomla\CMS\Component\ComponentHelper::getParams('com_templateck');
		$params = $templateckParams->toObject();
		if ((TEMPLATECREATORCK_ISJ4 || TEMPLATECREATORCK_ISJ5) && ! $this->item->joomlaversion) $this->item->joomlaversion = 'j4';
		$this->item = (object) array_merge( 
					(array) $this->item, (array) $params); 
	}

	public function getLayouts($id) {
		$l = $this->initLayouts();
		if (! $id) return $l;

		$query = 'SELECT id,type,htmlcode FROM #__templateck_layouts WHERE template_id=' . (int) $id;
		$layouts = CKFof::dbLoadObjectList($query, 'type');

		foreach($layouts as $layout) {
			$l[$layout->type] = new stdClass();
			$l[$layout->type]->id = $layout->id;
			$l[$layout->type]->htmlcode = $layout->htmlcode;
		}

		return $l;
	}

	private function initLayouts() {
		$l = array();
		$types = array('error404');

		foreach ($types as $type) {
			$l[$type] = new stdClass();
			$l[$type]->id = 0;
			$l[$type]->htmlcode = '';
		}
		return $l;
	}

	/**
	 * Method to save the form data.
	 *
	 */
	public function save($data) {
		$id = (!empty($data['id'])) ? $data['id'] : (int) $this->getState('template.id');
		$user = \Joomla\CMS\Factory::getUser();
		$data['htmlcode'] = $this->input->get('htmlcode', '', 'raw');
		$data['stylecode'] = $this->input->get('stylecode', '', 'raw');
		$htmlcode_responsive = $this->input->get('htmlcode_responsive', '', 'raw');
		if ($htmlcode_responsive) $data['htmlcode_responsive'] = $htmlcode_responsive;
		$modules = $this->input->get('modules', '', 'string');
		if ($modules) $data['modules'] = $modules;
		$data['widgets'] = $this->input->get('widgets', '', 'raw');
		$data['identifier'] = \Joomla\CMS\User\UserHelper::genRandomPassword(10);

		if ($id) {
			//Check the user can edit this item
			$authorised = $user->authorise('core.edit', 'template.' . $id);
		} else {
			//Check the user can create new items in this section
			$authorised = $user->authorise('core.create', 'com_templateck');
		}

		if ($authorised !== true) {
			throw new Exception(TCK_Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		// make a backup before save
		$this->makeBackup();

		// get existing template data
		$table = CKFof::dbLoad($this->table, $data['id']);

		// automatically update the template name in the folder
		if ($data['id'] != 0 && $table->name !== $data['name']) {
			$this->changeTemplateName($table->name, $data['name']);
		}

		// save the data in the table
		$templateid = CKFof::dbStore($this->table, $data);
		if (! $templateid) return false;

		$layouts = $this->input->get('layouts', '', 'array');

		if ($layouts) {
			$layoutsid = $this->input->get('layoutsid', 0, 'array');
			foreach ($layouts as $name => $layout) {
				$layout_id = $layoutsid[$name] ? $layoutsid[$name] : 0;
				$table = CKFof::dbLoad('#__templateck_layouts', $layout_id);
				$table->template_id = $templateid;
				$table->type = $name;
				$table->htmlcode = trim($layout);
				$table->styles = '';
				$table->published = 1;

				if (CKFof::dbStore('#__templateck_layouts', $table) === false) {
					return false;
				}
			}
		}

		return $templateid;
	}

	public function changeTemplateName($oldname, $newname) {
		if (! $oldname) return;

		if (! TCK_Folder::exists(TEMPLATECREATORCK_PROJECTS_PATH . '/' . $oldname) && ! TCK_Folder::exists(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $oldname)) {
			return;
		}
		if (TCK_Folder::exists(TEMPLATECREATORCK_PROJECTS_PATH . '/' . $oldname)) {
			$movefolder = TCK_Folder::move(TEMPLATECREATORCK_PROJECTS_PATH . '/' . $oldname, TEMPLATECREATORCK_PROJECTS_PATH . '/' . $newname);
			if ($movefolder !== true) {
				\Joomla\CMS\Factory::getApplication()->enqueueMessage(TCK_Text::_('CK_UNABLE_TO_RENAME_FOLDER') . ' : ' . TEMPLATECREATORCK_PROJECTS_PATH . '/' . $newname, 'warning');
			}
		}

		if (TCK_Folder::exists(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $oldname)) {
			$movefolder = TCK_Folder::move(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $oldname, TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $newname);
			if ($movefolder !== true) {
				\Joomla\CMS\Factory::getApplication()->enqueueMessage(TCK_Text::_('CK_UNABLE_TO_RENAME_FOLDER') . ' : ' . TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $newname, 'warning');
			}
		}
	}

	public function delete($id) {
		$path = TEMPLATECREATORCK_PROJECTS_PATH;
		$table = CKFof::dbLoad($this->table, (int)$id);
		if (TCK_Folder::exists($path . $table->name)) {
			TCK_Folder::delete($path . $table->name);
		}

		return parent::delete($id);
	}
	
	private function makeBackup() {
		$path = TEMPLATECREATORCK_PATH . '/backup';

		$item = $this->getItem();
		$exportfiletext = json_encode($item);

		// create the folder
		if (! TCK_Folder::exists($path . '/' . $item->id . '_bak/')) {
			TCK_Folder::create($path . '/' . $item->id . '_bak/');
		}

		// check if we have more than 5 existing backups, delete the old one
		$existingBackups = TCK_Folder::files($path . '/' . $item->id . '_bak/', '^backup_' . $item->id);
		if (count($existingBackups) > 5) {
//			$this->deleteOldestBackup($path . '/' . $item->id . '_bak/');
			natsort($existingBackups);
			$oldest = $existingBackups[0];
			TCK_File::delete($path . '/' . $item->id . '_bak/' . $oldest);
		}

		$exportfiledest = $path . '/' . $item->id . '_bak/backup_' . $item->id . '_' . date("d-m-Y-G-i-s") . '.tck3';
		TCK_File::write($exportfiledest, $exportfiletext);
		
	}
	
//	private function deleteOldestBackup($path) {
//		$files = TCK_Folder::files($path, '^backup_' . $item->id);
//
//		natsort($files);
//
//		$oldest = $files[0];
//		Jfile::delete($path . $oldest);
//	}

	/**
	 * Method to install a gabarit
	 *
	 * @access	public
	 * @return	true on success
	 */
	public function import() {
		$fileInput = new TCK_Input($_FILES);
		$file = $fileInput->get('file', null, 'array');
		if (!is_array($file))
			return false;

		//Clean up filename to get rid of strange characters like spaces etc
		$filename = TCK_File::makeSafe($file['name']);

		// check if the file exists
		if (TCK_File::getExt($filename) != 'tck3' && TCK_File::getExt($filename) != 'tck3z') {
			$msg = TCK_Text::_('CK_NOT_TCK3_AND_NOT_TCK3Z_FILE');
			CKFof::redirect(TEMPLATECREATORCK_ADMIN_URL, $msg, 'error');
			return false;
		}
		if (TCK_File::getExt($filename) === 'tck3') {
			if (! $this->import_tck3_file($file) ) {
				return false;
			}
		} else if (TCK_File::getExt($filename) === 'tck3z') {
			if (! $this->import_tck3z_file($file) ) {
				return false;
			}
		}

		return true;
	}
	
	private function import_tck3_file($file) {
		//Set up the source and destination of the file
		$src = $file['tmp_name'];

		// check if the file exists
		if (!$src || !file_exists($src)) {
			$msg = TCK_Text::_('CK_FILE_NOT_EXISTS');
			CKFof::redirect(TEMPLATECREATORCK_ADMIN_URL, $msg, 'error');
			return false;
		}

		// read the file
		if (!$filecontent = file_get_contents($src)) {
			$msg = TCK_Text::_('CK_UNABLE_READ_FILE');
			CKFof::redirect(TEMPLATECREATORCK_ADMIN_URL, $msg, 'error');
			return false;
		}

		// get the two parts, template and mobile data
		$filecontent = str_replace("|URIBASE|", TEMPLATECREATORCK_URI_ROOT, $filecontent);
		$filecontent = str_replace("|TCK_COMPONENT|", "components/com_templateck", $filecontent);
		$filecontent = str_replace("|TCK_ADMIN_COMPONENT|", "administrator/components/com_templateck", $filecontent);
		
		// |TCK_COMPONENT| = components/com_templateck - administrator/components/com_templateck
		$gabarittmp = explode("||TCK||", $filecontent);
		$gabarit = isset($gabarittmp[0]) ? json_decode($gabarittmp[0]) : json_decode($filecontent);
		if ($gabarit === null)
			return false;
		$gabaritmobile = isset($gabarittmp[1]) ? json_decode($gabarittmp[1]) : json_decode('{}');
		$gabarit->id = '0'; // set id to 0 to automatically increment value in database
		$gabarit->htmlcode = str_replace("|IMPORTFOLDER|", "images/" . $gabarit->name, $gabarit->htmlcode);
		$gabarit->htmlcode = stripslashes($gabarit->htmlcode);
		// do the replacement also for the stylecode
		if (isset($gabarit->stylecode)) {
			$gabarit->stylecode = str_replace("|IMPORTFOLDER|", "images/" . $gabarit->name, $gabarit->stylecode);
			$gabarit->stylecode = stripslashes($gabarit->stylecode);
		}

		if (TEMPLATECREATORCK_PLATFORM == 'joomla' && TEMPLATECREATORCK_ISJ5) {
			$gabarit->joomlaversion = 'j5';
		} else if (TEMPLATECREATORCK_PLATFORM == 'joomla' && TEMPLATECREATORCK_ISJ4) {
			$gabarit->joomlaversion = 'j4';
		}

		// Store the template to the database
		$result = CKFof::dbStore($this->table, $gabarit);
		if ($result === false) {
			return false;
		}

		return $result;
	}
	
	private function extractFilesFromTck3z ($file) {
		include_once TEMPLATECREATORCK_PATH . '/helpers/zip.php';

		// instanciate ZIP archiver
		$archiver = new CKArchiveZip();

		// extract archive
		$gabarit_folder_name = TCK_File::stripext($file['name']);
		$dest_extracted_zip_folder = TEMPLATECREATORCK_SITE_ROOT . '/tmp/' . $gabarit_folder_name;
		$isSuccess = $archiver->extract($file['tmp_name'], $dest_extracted_zip_folder, $options = array());

		if ($isSuccess === false) {
			return false;
}
		return $dest_extracted_zip_folder;
	}

	private function import_tck3z_file($file) {
		$dest_extracted_zip_folder = $this->extractFilesFromTck3z($file);
		$files = TCK_Folder::files($dest_extracted_zip_folder, '.tck3');
		if (count($files) > 1) {
			// more than one file to import found
			$msg = TCK_Text::_('CK_MULTIPLE_TCK3_FILES_FOUND');
			CKFof::redirect("index.php?option=com_templateck&view=templateinfos&layout=install", $msg, 'error');
			return false;
		}
		$gabaritfilename = $files[0];
		$template_folder_name = str_replace('.tck3', '', $gabaritfilename);

		// import the tck3 gabarit file
		// $gabarit_file = array('tmp_name' => $dest_extracted_zip_folder . '/' . $template_folder_name . '.tck3');
		$gabarit_file = array('tmp_name' => $dest_extracted_zip_folder . '/' . $gabaritfilename);
		$id = $this->import_tck3_file($gabarit_file);
		if ($id === false) {
			return false;
		}

		// create the destination folder for images
		if (! TCK_Folder::exists( TEMPLATECREATORCK_SITE_ROOT . '/images/' . $template_folder_name ) ) {
			TCK_Folder::create( TEMPLATECREATORCK_SITE_ROOT . '/images/' . $template_folder_name );
		}
		// copy the images
		$exclude_files = array('tck3','css','php');
		$files = TCK_Folder::files($dest_extracted_zip_folder, false, true, true);
		foreach ($files as $file) {
			$filename = explode('/', $file);
			$filename = end($filename);
			if (! in_array(TCK_File::getExt($file), $exclude_files) ) {
				TCK_File::copy($file, TEMPLATECREATORCK_SITE_ROOT . '/images/' . $template_folder_name . '/' . $filename);
			}
		}

		$templatePath = TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $template_folder_name;
		// create the destination folder for css
		if (! TCK_Folder::exists( $templatePath . '/css' ) ) {
			TCK_Folder::create( $templatePath );
		}

		// copy the custom.css file
		if ( file_exists($dest_extracted_zip_folder . '/custom.css' ) ) {
			// create the destination folder for css
			if (! TCK_Folder::exists( $templatePath . '/css' ) ) {
				TCK_Folder::create( $templatePath . '/css' );
			}
			TCK_File::copy($dest_extracted_zip_folder . '/custom.css', $templatePath . '/css/custom.css' );
		}

		// copy the custom.css file
		if ( file_exists($dest_extracted_zip_folder . '/custom.js' ) ) {
			// create the destination folder for css
			if (! TCK_Folder::exists( $templatePath . '/js' ) ) {
				TCK_Folder::create( $templatePath . '/js' );
			}
			TCK_File::copy($dest_extracted_zip_folder . '/custom.js', $templatePath . '/css/custom.js' );
		}

		// copy the modules data file
		if ( file_exists($dest_extracted_zip_folder . '/modules.txt' ) ) {
			TCK_File::copy($dest_extracted_zip_folder . '/modules.txt', $templatePath . '/modules.qdtck' );
		}
		if ( file_exists($dest_extracted_zip_folder . '/modules.qdtck' ) ) {
			TCK_File::copy($dest_extracted_zip_folder . '/modules.qdtck', $templatePath . '/modules.qdtck' );
		}

		// copy the html folder
		if ( TCK_Folder::exists( $dest_extracted_zip_folder . '/html' ) ) {
			// create the destination folder for css
			if (! TCK_Folder::exists( $templatePath . '/html' ) ) {
				TCK_Folder::create( $templatePath . '/html' );
			}
			TCK_Folder::copy($dest_extracted_zip_folder . '/html', $templatePath . '/html', '', true);
		}

		// copy the customheader.php file
		if (file_exists($dest_extracted_zip_folder . '/customheader.php') ) {
			TCK_File::copy($dest_extracted_zip_folder . '/customheader.php', $templatePath . '/customheader.php' );
		}

		// copy the customheader.php file
		if (file_exists($dest_extracted_zip_folder . '/customendbody.php') ) {
			TCK_File::copy($dest_extracted_zip_folder . '/customendbody.php', $templatePath . '/customendbody.php' );
		}

		// install modules
		/*if ( file_exists($dest_extracted_zip_folder . '/modules.txt' ) ) {
			// create the destination folder for css
			$modulesdata = file_get_contents($dest_extracted_zip_folder . '/modules.txt');
			$this->getModulesList($modulesdata);
		}*/

		// remove the copy from the tmp folder
		TCK_Folder::delete($dest_extracted_zip_folder);

		return $id;
	}

	public function export() {
		$this->input = CKFof::getInput();
		// path to store the file
		$path = TEMPLATECREATORCK_PATH . '/export';
		$id = $this->input->get('id', 0, 'int');

		// get the item data
		$item = $this->getItem($id);
		$name = $this->input->get('name', $item->name, 'string');

		// get the item encoded to be saved
//		$exportfiletext = $model->getExportFile($item);
		$exportfiletext = TemplateckHelper::getExportFile($item);
		$exportfiledest = $path . '/' . $name . '.tck3';
		// delete the gabarit folder and recreate it, so it is empty
		if (TCK_Folder::exists($path . '/' . $name . '_gabarit/')) {
			TCK_Folder::delete($path . '/' . $name . '_gabarit/');
		}
		TCK_Folder::create($path . '/' . $name . '_gabarit/');

		// replace the path for imageurl data
		preg_match_all('/imageurl=\\\"(.*?)\\\"/i', $exportfiletext, $files);
		preg_match_all('/customimage.?=\\\"(.*?)\\\"/i', $exportfiletext, $files2);

		$allimgs = array_merge($files[1], $files2[1]);

		foreach ($allimgs as $i => $file) {
			if (! $file) continue;
			$filename = explode('/', $file);
			$filename = end($filename);

			$exportfiletext = str_replace('imageurl=\"' . $file, 'imageurl=\"|IMPORTFOLDER|\/' . $filename , $exportfiletext);
			$exportfiletext = str_replace('<img src=\"\/' . $file, '<img src=\"|URIBASE|\/|IMPORTFOLDER|\/' . $filename , $exportfiletext);
			$exportfiletext = str_replace("url('\/" . $file, "url('|URIBASE|\/|IMPORTFOLDER|\/" . $filename , $exportfiletext);
			if (TEMPLATECREATORCK_URI_ROOT && TEMPLATECREATORCK_URI_ROOT != '/') 
				$exportfiletext = str_replace(addcslashes(TEMPLATECREATORCK_URI_ROOT, '/'), '|URIBASE|', $exportfiletext);
			$file = str_replace('|URIBASE|\/', '', $file);
			$exportfiletext = str_replace($file, '|IMPORTFOLDER|\/' . $filename , $exportfiletext);

			// save the images
			$localfile = trim(stripslashes(str_replace('|URIBASE|', '', $file)), '/');
			if (! TCK_File::copy(TEMPLATECREATORCK_SITE_ROOT . '/' . $localfile, $path . '/' . $name . '_gabarit/' . $filename) ) {
				$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_COPY_IMAGE') . ' : ' . TEMPLATECREATORCK_SITE_ROOT . '/' . $localfile . '</p>';
			} else {
				$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_COPY_IMAGE') . ' : ' . TEMPLATECREATORCK_SITE_ROOT . '/' . $localfile . '</p>';
			}
			echo $msg;
		}

		// replace the path for <img /> tags
		preg_match_all('/ <img src=\\\"(.*?)\\\"/i', $exportfiletext, $imgs);
		foreach ($imgs[1] as $i => $file) {
			$filename = explode('/', $file);
			$filename = end($filename);
			$exportfiletext = str_replace($file, '|URIBASE|\/|IMPORTFOLDER|\/' . $filename , $exportfiletext);
		}


		// create the file .tck3
		$exportfiletext = str_replace("administrator/components/com_templateck", "|TCK_ADMIN_COMPONENT|",  $exportfiletext);
		$exportfiletext = str_replace("components/com_templateck", "|TCK_COMPONENT|",  $exportfiletext);
		if (!TCK_File::write($exportfiledest, $exportfiletext)) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATE_GABARIT') . '</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATE_GABARIT') . '</p>';
		}
		echo $msg;

		// save the gabarit file
		if (! TCK_File::copy($exportfiledest, $path . '/' . $name . '_gabarit/' . $name . '.tck3' ) ) {
			$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_COPY_GABARIT') . '</p>';
		} else {
			$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_COPY_GABARIT') . '</p>';
		}
		echo $msg;

		$templatePath = TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $name;
		// save the html folder
		if (TCK_Folder::exists( $templatePath . '/html' ) ) {
			TCK_Folder::create($path . '/' . $name . '_gabarit/html');
			TCK_Folder::copy($templatePath . '/html', $path . '/' . $name . '_gabarit/html/', '', true);
		}

		// save the custom.css file
		if (TCK_File::exists($templatePath . '/css/custom.css') ) {
			TCK_File::copy($templatePath . '/css/custom.css', $path . '/' . $name . '_gabarit/custom.css' );
		}

		// save the customheader.php file
		if (TCK_File::exists($templatePath . '/customheader.php') ) {
			TCK_File::copy($templatePath . '/customheader.php', $path . '/' . $name . '_gabarit/customheader.php' );
		}

		// save the customheader.php file
		if (TCK_File::exists($templatePath . '/customendbody.php') ) {
			TCK_File::copy($templatePath . '/customendbody.php', $path . '/' . $name . '_gabarit/customendbody.php' );
		}

		// save the custom js file
		if (TCK_File::exists($templatePath . '/js/custom.js') ) {
			TCK_File::copy($templatePath . '/js/custom.js', $path . '/' . $name . '_gabarit/custom.js' );
		}


		//save the modules data
		if (! empty($item->modules)) {
			$modules = explode(',', $item->modules);
			$modulesdata = array();
			$db = \Joomla\CMS\Factory::getDbo();
			foreach($modules as $module) {
				$query = "SELECT * FROM #__modules WHERE position='" . $module . "' AND published='1' AND client_id='0'";
				// $db->setQuery($query);
				$moduleObj = CKFof::dbLoadObjectList($query);

				if (!empty($moduleObj)) {
					$modulesdata = array_merge($moduleObj, $modulesdata);
				} else {
					// add the SQL field to the main table
		//			$db->setQuery('ALTER TABLE `#__templateck_fonts` ADD `alternatives` text NOT NULL;');
		//			if (!$db->query()) {
		//				echo '<p class="alert alert-danger">Error during export of module ID ' . $moduleObj->id .'</p>';
		//			} else {
		//				echo '<p class="alert alert-success">Table alternatives updated !</p>';
		//			}
				}
			}
			$modulesdata = serialize($modulesdata);
			$modulesdata = $this->replaceRoot($modulesdata);
			file_put_contents($path . '/' . $name . '_gabarit/modules.txt', $modulesdata);
		}

		// save the template into zip
		if (TCK_Folder::exists($templatePath)) {
			$files = TCK_Folder::files($templatePath, false, true, true);
			$exporter = new ZipArchiver();
			$isSuccess = $exporter->create($files, $templatePath . '.zip', $templatePath , true);

			TCK_File::copy(TEMPLATECREATORCK_SITE_ROOT . '/templates/' . $name . '.zip', $path . '/' . $name . '_gabarit/' . $name . '.zip');
			// return message after creating the zip archive
			if (!$isSuccess && $exporter->getError()) {
				$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_ARCHIVE') . '</p>';
			} else {
				$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_ARCHIVE') . '</p>';
			}
		}

		echo $msg;

		$files = TCK_Folder::files($path . '/' . $name . '_gabarit/', false, true, true);
		$exporter = new ZipArchiver();
		$isSuccess = $exporter->create($files, $path . '/' . $name . '_gabarit.tck3z',$path . '/' . $name . '_gabarit', true);
		echo '<p style="padding: 15px;"><a class="ckdownload" style="background: #3D3D3D;border-radius: 3px;color: #E1E1E1;cursor: pointer;margin: 3px;padding: 2px 5px;text-decoration: none;" target="_blank" href="' . TEMPLATECREATORCK_MEDIA_URI . '/export/' . $name . '_gabarit.tck3z">' . TCK_Text::_('CK_DOWNLOAD_GABARIT') . '</a></p>';
//		TemplateckHelper::pushFileForDownload($name . '_gabarit.tck3z', );
//		header("Location: " . \Joomla\CMS\Uri\Uri::root() . "administrator/components/com_templateck/export/" . $name . "_gabarit.tck3z");
		// or however you get the path

		exit;
	}

	private function replaceRoot($text) {

		if (\Joomla\CMS\Uri\Uri::root(true)) {
			$text = str_replace("'\\" . \Joomla\CMS\Uri\Uri::root(true), "'\|URIBASE\|", $text);
		}
		return $text;
	}

	/**
	 * Method to install a gabarit
	 *
	 * @access	public
	 * @return	true on success
	 */
	public function ajaxInstallGabarit($url) {

		set_time_limit(0);
		try {
			$file = file_get_contents(urldecode($url));
		} catch (Exception $e) {
			echo 'Exception : ',  $e->getMessage(), "\n";
			exit;
		}
		if ($file === false) return false;

		$names = explode('/', $url);
		$filename = end($names);
		$name = \Joomla\CMS\Filesystem\File::stripExt($filename);

		$dest = TEMPLATECREATORCK_PATH . '/tmp/' . $name . '.zip';
		file_put_contents($dest, $file);

		// give the gabarit file to import
		$ffile = array('name' => $name, 'tmp_name' => $dest);
		$id = $this->import_tck3z_file($ffile);

		return $id;
	}

	function copy($id) {
		$item = $this->getItem($id);
		$item->id = 0;

		if (file_exists(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $item->name . '-copy')) {
			CKFof::enqueueMessage(\Joomla\CMS\Language\Text::_('CK_ERROR_COPY_TEMPLATE_FOLDER_EXISTS') . ' <a href="https://www.template-creator.com/fr/documentation-category/installation/how-to-remove-a-template" target="_blank">' . \Joomla\CMS\Language\Text::_('CK_SEE_DOCUMENTATION') . '</a>', 'warning');
			return false;
		}

		// copy the whole template folder with html and custom css
		if (!$this->copyFolder($item, '-copy')) {
			CKFof::enqueueMessage(\Joomla\CMS\Language\Text::_('CK_ERROR_COPY_TEMPLATE_FOLDER'), 'warning');
			return false;
		}
		
		// give the new name
		$item->name .= '-copy';

		// Store the table to the database
		$templateid = CKFof::dbStore($this->table, $item);

		$query = "SELECT * FROM #__templateck_layouts WHERE template_id = " . (int) $id;
		$layouts = CKFof::dbLoadObjectList($query);

		if (! empty($layouts)) {
			foreach ($layouts as $layout) {
				$layout->id = 0;
				$layout->template_id = $templateid;
				// Store the table to the database
				CKFof::dbStore('#__templateck_layouts', $layout);
			}
		}

		return true;
	}

	private function copyFolder($data, $suffix) {
		$path = TEMPLATECREATORCK_TEMPLATES_PATH;
		if (file_exists($path . '/' . $data->name)) {
			if (!\Joomla\CMS\Filesystem\Folder::copy($path . '/' . $data->name, $path . '/' . $data->name . $suffix)) {
				return false;
			}
		}

		// update the name in the xml file
		$xmlPath = $path . '/' . $data->name . $suffix . '/templateDetails.xml';
		$xml = file_get_contents($xmlPath);
		$xml = str_replace('<name>' . $data->name . '</name>', '<name>' . $data->name . $suffix . '</name>', $xml);
		file_put_contents($xmlPath, $xml);

		return true;
	}
}