<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$templateid = $this->input->get('templateid', ''); 
$templatename = $this->input->get('templatename', '', 'string');
$path = TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename;

if (! $templatename) {
	TemplateckHelper::renderNoNameMessage();
	return;
}

$customcode = '';
$customcodeendbody = '';
// test if a custom css exists
if (file_exists($path . '/customheader.php')) {
	$customcode = file_get_contents($path . '/customheader.php');
} 
//else {
//	$db = \Joomla\CMS\Factory::getDbo();
//	$query = ' SELECT options FROM #__templateck_templates' .
//			' WHERE id = ' . $templateid;
//	$db->setQuery($query);
//	$customcode = $db->loadResult();
//}

if (file_exists($path . '/customendbody.php')) {
	$customcodeendbody = file_get_contents($path . '/customendbody.php');
}
?>
<script>
var editor_customcode = CodeMirror.fromTextArea(document.getElementById("customcode"), {
	mode: "javascript",
//	styleActiveLine: true,
	lineNumbers: true,
	lineWrapping: true,
	autoRefresh:true
});
var editor_customcodeendbody = CodeMirror.fromTextArea(document.getElementById("customcodeendbody"), {
	mode: "javascript",
//	styleActiveLine: true,
	lineNumbers: true,
	lineWrapping: true,
	autoRefresh:true
});
setTimeout(function() {
	editor_customcode.refresh();
	editor_customcodeendbody.refresh();
}, 100);
</script>
<div class="cktitle"><?php echo TCK_Text::_('CK_PAGECUSTOMCODE_INFOS'); ?></div>
<div class="ckinterfacedesc"><?php echo TCK_Text::_('CK_PAGECUSTOMCODE_DESC'); ?></div>
<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_CUSTOMCODE_IN_HEAD'); ?></div>
<textarea id="customcode" cols="50" rows="20" style="color: #777;"><?php echo $customcode; ?></textarea>
<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_CUSTOMCODE_END_BODY'); ?></div>
<textarea id="customcodeendbody" cols="50" rows="20" style="color: #777;"><?php echo $customcodeendbody; ?></textarea>