<?php
/**
 * @name		Template Creator CK 3
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr - https://www.wp-pluginsck.com
 */

defined('TCK_LOADED') or die;

class TCK_WidgetTopfixedwrapper {

	private $name = 'topfiwedwrapper';

	public function loadWidget() {
		?>
		<script src="<?php echo TEMPLATECREATORCK_PLUGIN_URL ?>/widgets/topfixedwrapper/interface.js" type="text/javascript"></script>
		<?php
	}
	

	public function renderFrontendWidget($templatepath, $templatename, $data) {
		$blocs = CKWidgets::parseWidgetData($data);
		if (empty($blocs)) return;

		$jsCalls = array();
		foreach ($blocs as $bloc) {
			$jsCalls[] = "new TCK_TopFixedWrapper('#" . $bloc->{'data-id'} . "', {"
					. "offset : '" . $bloc->{'data-offset'} . "',"
					. "effect : '" . $bloc->{'data-effect'} . "',"
					. "resolution : '" . $bloc->{'data-resolution'} . "'"
					. "});";
		}
		$jsCalls = implode(' ', $jsCalls);
		TCK_Folder::create(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename . '/js');
		TCK_File::copy(TEMPLATECREATORCK_PATH . '/widgets/topfixedwrapper/topfixedwrapper.js', TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename . '/js/topfixedwrapper.js');
		
		$widget = array();
		$widget['php'] = '';
		$widget['script'] = '<script src="' . $templatepath . '/js/topfixedwrapper.js" type="text/javascript" ></script>';
		$widget['scriptDeclaration'] = 'jQuery(document).ready(function(){ ' . $jsCalls . ' });';
		$widget['stylesheet'] = '';
		$widget['styleDeclaration'] = '';
		$widget['jquery'] = true;

		return $widget;
	}

	public function onAfterInstall() {
		
	}
	
	public function listWrapperOptions() {
		$input = new TCK_Input();
		$blocsList = $input->get('blocsList', '', 'string');
		$blocsList = json_decode(stripslashes($blocsList));

		$this->showInfos();
		$this->renderTopBar();
		foreach ($blocsList as $bloc) {
			$this->renderOptions($bloc);
		}

		$this->renderCss();
//		echo $html;
		exit();
	}

	private function showInfos() {
		?>
		<p><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_WRAPPER_INFOS') ?></p>
		<p><span class="cklabel"><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_OFFSET') ?></span> : <?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_OFFSET_DESC') ?></p>
		<p><span class="cklabel"><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_EFFECT') ?></span> : <?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_EFFECT_DESC') ?></p>
		<p><span class="cklabel"><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_RESOLUTION') ?></span> : <?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_RESOLUTION_DESC') ?></p>
		<?php
	}
	
	private function renderTopBar() {
		?>
		<div class="widgettopbar">
			<div>
				<span style="display:inline-block;width: 165px;font-weight: bold;"><?php echo TCK_Text::_('CK_BLOCK') ?></span>
				<span style="display:inline-block;width: 65px;font-weight: bold;"><?php echo TCK_Text::_('CK_ACTION') ?></span>
			</div>
			<p></p>
		</div>
		<?php
	}
	
	private function renderOptions($bloc) {
		$prefix = $bloc->id;
		$btnClass = $bloc->enabled ? ' active ckbutton-info' : '';
	?>
		<div class="datarow widgetrow" style="text-align:left;" data-id="<?php echo $bloc->id ?>">
			<span style="display:inline-block;width: 150px;" class=""><?php echo $bloc->id ?></span>
			<span style="display:inline-block;" class="ckselecttopfixedwrapper ckbutton <?php echo $btnClass ?>" onclick="TCK_WidgetTopfixedwrapperToggle(this)" data-state="<?php echo $bloc->enabled ?>"><span class="fack fack-check-square-o"></span> <?php echo TCK_Text::_('CK_SELECT'); ?></span>
			<span>
				<span><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_OFFSET') ?></span>
				<input type="text" class="inputbox offset" value="<?php echo $bloc->offset ?>" onchange="TCK_WidgetTopfixedwrapperSetOptions(this)" style="width:120px;"/>
			</span>
			<span>
				<span><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_EFFECT') ?></span>
				<select class="inputbox effect" type="list" name="<?php echo $prefix; ?>effect" id="<?php echo $prefix; ?>effect" value="" style="width:100px;" onchange="TCK_WidgetTopfixedwrapperSetOptions(this)">
					<option value="0" <?php echo $this->isSelected($bloc->effect, '0') ?>><?php echo TCK_Text::_('JNO'); ?></option>
					<option value="1" <?php echo $this->isSelected($bloc->effect, '1') ?>><?php echo TCK_Text::_('JYES'); ?></option>
				</select>
			</span>
			<span>
				<span><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_RESOLUTION') ?></span>
				<input type="text" placeholder="800" class="inputbox resolution" value="<?php echo $bloc->resolution ?>" onchange="TCK_WidgetTopfixedwrapperSetOptions(this)" />px
			</span>
			<div class="clr"></div>
		</div>
	<?php
	}
	
	private function renderCss() {
		?>
		<style>

		</style>
		<?php
	}

	private function isSelected($ref, $option) {
		if ($ref == $option) return ' selected="selected"';
		return '';
	}
}
