<?php
/**
 * @name		Template Creator CK 3
 * @copyright	Copyright (C) 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr - https://www.ceikay.com
 */

defined('TCK_LOADED') or die;

class TCK_WidgetMobilemenu {

	private $name = 'mobilemenu';

	public $pluginUrl;

	public $pluginPage;

	private $pluginName = 'mobilemenuck';

	private $imagespath;

	public function __construct() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			$this->pluginUrl = 'https://www.joomlack.fr/index.php?option=com_dms&task=doc_download&id=163&updater=true';
			$this->pluginPage = 'https://www.joomlack.fr/en/joomla-extensions/mobile-menu-ck';
		} else if (TEMPLATECREATORCK_PLATFORM == 'wordpress') {
			$this->pluginUrl = 'https://downloads.wordpress.org/plugin/mobile-menu-ck.zip';
			$this->pluginPage = 'https://www.ceikay.com/plugins/mobile-menu-ck';
		}
		$this->imagespath = TEMPLATECREATORCK_MEDIA_URL . '/images/interface';
	}

	/*
	 * Needed function
	 */
	public function onAfterInstall() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			require_once(TEMPLATECREATORCK_PATH . '/helpers/ckinstaller.php');
			$installer = new CKInstaller();
			$result = $installer->install($this->pluginUrl, $this->pluginName, 'plugin');

			return $result;
		}
	}

	public function enablePlugin() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			if (! $installed = $this->isInstalled()) {
				$installed = $this->onAfterInstall();
			}
			if ($installed) {
				return $this->updatePluginState('1');
			} else {
				return false;
			}
		} else {
			return '1';
		}
	}

	public function disablePlugin() {
		return $this->updatePluginState('0');
	}

	public function isInstalled() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			// auto enable the plugin
			$db = \Joomla\CMS\Factory::getDbo();
			$db->setQuery("SELECT extension_id FROM #__extensions WHERE `element` = 'mobilemenuck' AND `type` = 'plugin'");
			return $db->loadResult();
		}
	}

	public function updatePluginState($state) {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			// auto enable the plugin
			$db = \Joomla\CMS\Factory::getDbo();
			$db->setQuery("UPDATE #__extensions SET enabled = '" . $state . "' WHERE `element` = 'mobilemenuck' AND `type` = 'plugin'");
			return $db->execute();
		}
	}

	public function loadWidget() {
		?>
		<script src="<?php echo TEMPLATECREATORCK_MEDIA_URL ?>/widgets/mobilemenu/interface.js" type="text/javascript"></script>
		<?php
	}

	public function renderFrontendWidget($templatepath, $templatename, $data) {
		require_once(TEMPLATECREATORCK_PATH . '/helpers/ckwidgets.php');
		$blocs = CKWidgets::parseWidgetData($data);
		if (empty($blocs)) return;

		$phpCalls = array();
		foreach ($blocs as $bloc) {
			if (! isset($bloc->{'data-mobilemenuck_enable'}) || $bloc->{'data-mobilemenuck_enable'} == '0')
			continue;

			$themeid = isset($bloc->{'data-mobilemenuck_style'}) ? (int) $bloc->{'data-mobilemenuck_style'} : 'null';
			$phpCalls[] = "
// load the mobile menu
if (function_exists('loadMobileMenuCK')) {
	\$id = loadMobileMenuCK('#" . $bloc->{'data-id'} . "', 
		array(
		'container' => 'menu'
		,'showmobilemenutext' => 'default'
		,'mobilemenutext' => '" . addslashes(isset($bloc->{'data-mobilemenuck_mobilemenutext'}) ? $bloc->{'data-mobilemenuck_mobilemenutext'} : 'default') . "'
		,'container' => '" . addslashes(isset($bloc->{'data-mobilemenuck_container'}) ? $bloc->{'data-mobilemenuck_container'} : 'body') . "'
		,'detectiontype' => '" . (isset($bloc->{'data-mobilemenuck_detectiontype'}) ? $bloc->{'data-mobilemenuck_detectiontype'} : 'resolution') . "'
		,'resolution' => '" . addslashes(isset($bloc->{'data-mobilemenuck_resolution'}) ? $bloc->{'data-mobilemenuck_resolution'} : '640') . "'
		,'usemodules' => '" . (isset($bloc->{'data-mobilemenuck_usemodules'}) ? $bloc->{'data-mobilemenuck_usemodules'} : '0') . "'
		,'useimages' => '" . (isset($bloc->{'data-mobilemenuck_useimages'}) ? $bloc->{'data-mobilemenuck_useimages'} : '0') . "'
		,'showlogo' => '" . (isset($bloc->{'data-mobilemenuck_showlogo'}) ? $bloc->{'data-mobilemenuck_showlogo'} : '0') . "'
		,'showdesc' => '" . (isset($bloc->{'data-mobilemenuck_showdesc'}) ? $bloc->{'data-mobilemenuck_showdesc'} : '0') . "'
		,'displaytype' => '" . (isset($bloc->{'data-mobilemenuck_displaytype'}) ? $bloc->{'data-mobilemenuck_displaytype'} : 'accordion') . "'
		,'displayeffect' => '" . (isset($bloc->{'data-mobilemenuck_displayeffect'}) ? $bloc->{'data-mobilemenuck_displayeffect'} : 'normal') . "'
		,'menuwidth' => '" . addslashes(isset($bloc->{'data-mobilemenuck_menuwidth'}) ? $bloc->{'data-mobilemenuck_menuwidth'} : '300') . "'
		,'openedonactiveitem' => '" . (isset($bloc->{'data-mobilemenuck_openedonactiveitem'}) ? $bloc->{'data-mobilemenuck_openedonactiveitem'} : '1') . "'
		));
	loadThemeMobileMenuCK(\$id, $themeid);
} else {
	// echo '<p><a href=\"https://www.template-creator.com/fr/documentation-category/layout/mobile-menu\">The plugin Mobile Menu CK is missing. This is needed for your template.</a></p>';
}
";
		}
		$widget = array();
		$widget['php'] = "\t" . implode("\n\t\t", $phpCalls);
		$widget['script'] = '';
		$widget['scriptDeclaration'] = '';
		$widget['stylesheet'] = '';
		$widget['styleDeclaration'] = '';

		return $widget;
	}


	public function listOptions() {
		$input = new TCK_Input();
		$blocsList = $input->get('blocsList', '', 'string');
		$blocsList = json_decode(stripslashes($blocsList));

		$this->showInfos();
		$this->renderTopBar();
		foreach ($blocsList as $bloc) {
			$this->renderOptions($bloc);
		}

//		$this->renderCss();
		exit();
	}

	private function showInfos() {
		?>
		<p><?php echo TCK_Text::_('CK_WIDGET_MOBILEMENU_INFOS') ?></p>
		<?php /*<p><span class="cklabel"><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_OFFSET') ?></span> : <?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_OFFSET_DESC') ?></p>
		<p><span class="cklabel"><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_EFFECT') ?></span> : <?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_EFFECT_DESC') ?></p>
		<p><span class="cklabel"><?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_RESOLUTION') ?></span> : <?php echo TCK_Text::_('CK_WIDGET_TOP_FIXED_RESOLUTION_DESC') ?></p>
		<?php */
	}

	private function renderTopBar() {
		?>
		<div class="widgettopbar">
			<div>
				<span style="display:inline-block;width: 165px;font-weight: bold;"><?php echo TCK_Text::_('CK_BLOCK') ?></span>
				<span style="display:inline-block;width: 65px;font-weight: bold;"><?php echo TCK_Text::_('CK_ACTION') ?></span>
			</div>
			<p></p>
		</div>
		<?php
	}
	
	private function renderOptions($bloc) {
		$prefix = $bloc->id;
		$btnClass = $bloc->enabled ? ' active ckbutton-info' : '';
	?>
		<div class="datarow widgetrow" style="text-align:left;" data-id="<?php echo $bloc->id ?>">
			<span style="display:inline-block;width: 150px;" class=""><?php echo $bloc->id ?></span>
			<span style="display:inline-block;" class="ckselectmobilemenu ckbutton <?php echo $btnClass ?>" onclick="TCK_WidgetMobilemenuToggle(this, !$ck(this).hasClass('active'))" data-state="<?php echo $bloc->enabled ?>"><span class="fack fack-check-square-o"></span> <?php echo TCK_Text::_('CK_SELECT'); ?></span>
			<div class="clr"></div>
		</div>
	<?php
	}

	public function listPluginOptions() {
		$input = new TCK_Input();
		$blocid = $input->get('blocid', '', 'string');
		$this->interface = new CKInterface();
		?>
		<div class="ckleftpanelheader">
			<span class="ckleftpaneltitle">
				<?php echo TCK_Text::_('CK_WIDGET_MOBILEMENU'); ?>
				<span class="ckleftpanelsubtitle ckleftpanelsubtitleunder">[ <?php echo $blocid ?> ]</span>
			</span>
			<span class="ckleftpanelheadericon cksave ckhastip" title="<?php echo TCK_Text::_('CK_SAVE_CLOSE'); ?>" onclick="TCK_WidgetMobilemenuSavePopup();ckCloseEdition();"><span class="fack fack-check"></span></span>
		</div>
		<?php

		$isPro = false;
		$isInstalled = false;
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			$pluginFile = JPATH_SITE . '/plugins/system/mobilemenuck/helpers/helper.php';
			if (! file_exists($pluginFile)) {
				echo '<p class="ckalert">' . TCK_Text::_('PLG_MOBILEMENUCK_PLUGIN_MISSING') . '</p>';
				echo '<p class="ckoption"><a class="ckbutton" href="' . $this->pluginPage . '" target="_blank">' . TCK_Text::_('PLG_MOBILEMENUCK_DOWNLOAD'). '</a></p>';
				return;
			}
			require_once($pluginFile);
			if (! method_exists('\Mobilemenuck\Menu','getDefaultOptions')) {
				echo '<p class="ckalert">' . TCK_Text::_('PLG_MOBILEMENUCK_PLUGIN_NOT_UPTODATE') . '</p>';
				echo '<p class="ckoption"><a class="ckbutton" href="' . $this->pluginPage . '" target="_blank">' . TCK_Text::_('PLG_MOBILEMENUCK_DOWNLOAD'). '</a></p>';
				return;
			}
			if (! \Mobilemenuck\Helper::checkIsProVersion()) {
				$isPro = false;
				$promessage =  \Mobilemenuck\Helper::renderProMessage();
			} else {
				$isPro = true;
				$promessage = '';
			}
			$isInstalled = true;
		} else if (TEMPLATECREATORCK_PLATFORM == 'wordpress') {
			$pluginFile = ABSPATH . '/wp-content/plugins/mobile-menu-ck/helpers/helper.php';
			if (! file_exists($pluginFile)) {
				echo '<p class="ckalert">' . TCK_Text::_('PLG_MOBILEMENUCK_PLUGIN_MISSING') . '</p>';
				echo '<p class="ckoption"><a class="ckbutton" href="' . $this->pluginPage . '" target="_blank">' . TCK_Text::_('PLG_MOBILEMENUCK_DOWNLOAD'). '</a></p>';
				return;
			}
			$Mobilemenuck = \Mobilemenuck\Mobilemenuck::getInstance();
			$Mobilemenuck->callHelpers();
			if (! method_exists('\Mobilemenuck\Menu','getDefaultOptions')) {
				echo '<p class="ckalert">' . TCK_Text::_('PLG_MOBILEMENUCK_PLUGIN_NOT_UPTODATE') . '</p>';
				echo '<p class="ckoption"><a class="ckbutton" href="' . $this->pluginPage . '" target="_blank">' . TCK_Text::_('PLG_MOBILEMENUCK_DOWNLOAD'). '</a></p>';
				return;
			}
			if (! defined('CK_LOADED')) define('CK_LOADED', '1');
//			require_once(ABSPATH . '/wp-content/plugins/mobile-menu-ck/mobile-menu-ck.php');
//			require_once(ABSPATH . '/wp-content/plugins/mobile-menu-ck/helpers/menuhelper.php');
//			require_once(ABSPATH . '/wp-content/plugins/mobile-menu-ck/helpers/menu.php');
			// get the template creator class
			

			if (! \Mobilemenuck\Helper::checkIsProVersion()) {
				$isPro = false;
				$promessage =  \Mobilemenuck\Helper::renderProMessage();
			} else {
				$isPro = true;
				$promessage = '';
			}
			$isInstalled = true;
		} else {
			$isPro = false;
			$isInstalled = false;
		}
		if (! $isInstalled) {
			echo '<p class="ckoption"><a href="' . $this->pluginPage . '" target="_blank">' . TCK_Text::_('PLG_MOBILEMENUCK_PLUGIN_MISSING'). '</a></p>';
			echo '<p class="ckoption"><a class="ckbutton" href="' . $this->pluginPage . '" target="_blank">' . TCK_Text::_('PLG_MOBILEMENUCK_DOWNLOAD'). '</a></p>';
			return;
		}

		$defaultOptions = \Mobilemenuck\Menu::getDefaultOptions();
		?>
		<input id="mobilemenuck_id" type="hidden" value="<?php echo $blocid ?>" />
		<div class="ckoption datarow" data-id="<?php echo $blocid ?>">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_ENABLE_LABEL', 'switch.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_enable" id="mobilemenuck_enable" value="" style="width:105px;" onchange="TCK_WidgetMobilemenuToggle(this, this.value)" >
					<option value="0" selected="selected"><?php echo TCK_Text::_('NO'); ?></option>
					<option value="1"><?php echo TCK_Text::_('YES'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_SELECT_STYLE_LABEL', 'palette.png') ?>
			<span class="ckoption-field">
				<?php if ($isPro) {
					$styles = \Mobilemenuck\Helper::getStyles('name, id');
					foreach ($styles as $style) {
						?>
						<input type="hidden" class="mobilemenuck_style" name="mobilemenuck_style_<?php echo $style->name ?>" id="mobilemenuck_style_<?php echo $style->name ?>" data-name="<?php echo $style->name ?>" data-id="<?php echo $style->id ?>" />
						<?php
					}
					if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
						$selectUrl = 'index.php?option=com_mobilemenuck&view=styles&tmpl=component&layout=modal&returnFunc=ckMobilemenuSelectStyle';
						$editUrl = 'index.php?option=com_mobilemenuck&view=style&tmpl=component&layout=modal';
					} else if (TEMPLATECREATORCK_PLATFORM == 'wordpress') {
						$selectUrl = 'admin.php?page=mobilemenuck_styles&layout=modal&returnFunc=ckMobilemenuSelectStyle';
						$editUrl = 'admin.php?page=mobilemenuck_edit_style&layout=modal';
					}
					?>
					<input type="hidden" class="mobilemenufield" name="mobilemenuck_style" id="mobilemenuck_style" value="<?php echo (isset($defaultOptions['style']) ? $defaultOptions['style'] : '') ?>" />
					<input type="text" class="inputbox mobilemenufield" disabled name="mobilemenuck_stylename" id="mobilemenuck_stylename" value="" style="width:100px;"/>
					<div class="ckbutton" onclick="CKBox.open({url: '<?php echo $selectUrl ?>'})"><?php echo TCK_Text::_('PLG_MOBILEMENUCK_SELECT') ?></div>
					<div class="ckbutton" onclick="if (jQuery('#mobilemenuck_style').val()) {CKBox.open({url: '<?php echo $editUrl ?>&id='+jQuery('#mobilemenuck_style').val()+''}) } else { alert(' <?php echo TCK_Text::_('PLG_MOBILEMENUCK_SELECT_FIRST', true) ?> ');}"><?php echo TCK_Text::_('PLG_MOBILEMENUCK_EDIT', true) ?></div>
					<div class="ckbutton" onclick="jQuery('#mobilemenuck_style').val('');jQuery('#mobilemenuck_stylename').val('');"><?php echo TCK_Text::_('PLG_MOBILEMENUCK_CLEAR', true) ?></div>
				<?php
				} else {
					echo $promessage;
				}
				?>
			</span>
		</div>
		<?php /*
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_MERGE_WITH_LABEL', 'palette.png') ?>
			<span class="ckoption-field">
				<?php if ($isPro) {
					?>
				créer bouton
				<?php
				} else {
					echo $promessage;
				}
				?>
			</span>
		</div>
		*/ ?>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_DETECTIONTYPE_LABEL', 'ipod.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_detectiontype" id="mobilemenuck_detectiontype" value="<?php echo $defaultOptions['detectiontype'] ?>" style="width:105px;" onchange="TCK_WidgetMobilemenuToggleShowon(this.value, 'resolution', 'mobilemenuck_resolution')">
					<option value="resolution" <?php echo $this->isSelected($defaultOptions['detectiontype'], 'resolution') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_RESOLUTION'); ?></option>
					<option value="tablet" <?php echo $this->isSelected($defaultOptions['detectiontype'], 'tablet') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_TABLET'); ?></option>
					<option value="phone" <?php echo $this->isSelected($defaultOptions['detectiontype'], 'phone') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_PHONE'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_MOBILERESOLUTION_LABEL', 'width.png') ?>
			<span class="ckoption-field">
				<input type="text" placeholder="640" class="inputbox mobilemenufield" name="mobilemenuck_resolution" id="mobilemenuck_resolution" value="<?php echo $defaultOptions['resolution'] ?>" style="width:100px;" />
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_CONTAINER_LABEL', 'application_side_tree.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_container" id="mobilemenuck_container" value="<?php echo $defaultOptions['container'] ?>" style="width:105px;" >
					<option value="body" <?php echo $this->isSelected($defaultOptions['container'], 'body') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_BODY'); ?></option>
					<option value="menucontainer" <?php echo $this->isSelected($defaultOptions['container'], 'menucontainer') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_MENUCONTAINER'); ?></option>
					<option value="topfixed" <?php echo $this->isSelected($defaultOptions['container'], 'topfixed') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_TOPFIXED'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_MOBILEMENUWIDTH_LABEL', 'width.png') ?>
			<span class="ckoption-field">
				<input type="text" placeholder="300" class="inputbox mobilemenufield" name="mobilemenuck_menuwidth" id="mobilemenuck_menuwidth" value="<?php echo $defaultOptions['menuwidth'] ?>" style="width:100px;" />
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_DISPLAYEFFECT_LABEL', 'chart_line.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_displayeffect" id="mobilemenuck_displayeffect" value="<?php echo $defaultOptions['displayeffect'] ?>" style="width:105px;" >
					<option value="normal" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'normal') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_NORMAL'); ?></option>
					<option value="slideleft" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'slideleft') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_SLIDELEFT'); ?></option>
					<option value="slideright" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'slideright') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_SLIDERIGHT'); ?></option>
					<option value="slideleftover" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'slideleftover') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_SLIDELEFT_OVER'); ?></option>
					<option value="sliderightover" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'sliderightover') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_SLIDERIGHT_OVER'); ?></option>
					<option value="topfixed" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'topfixed') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_TOPFIXED'); ?></option>
					<option value="open" <?php echo $this->isSelected($defaultOptions['displayeffect'], 'open') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_OPEN_SLIDE'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_DISPLAYTYPE_LABEL', 'application_side_boxes.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_displaytype" id="mobilemenuck_displaytype" value="<?php echo $defaultOptions['displaytype'] ?>" style="width:105px;" >
					<option value="flat" <?php echo $this->isSelected($defaultOptions['displaytype'], 'flat') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_FLAT'); ?></option>
					<option value="accordion" <?php echo $this->isSelected($defaultOptions['displaytype'], 'accordion') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_ACCORDION'); ?></option>
					<option value="fade" <?php echo $this->isSelected($defaultOptions['displaytype'], 'fade') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_FADELEVELS'); ?></option>
					<option value="push" <?php echo $this->isSelected($defaultOptions['displaytype'], 'push') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_PUSHLEVELS'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_MOBILEUSEIMAGE_LABEL', 'image.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_useimages" id="mobilemenuck_useimages" value="<?php echo $defaultOptions['useimages'] ?>" style="width:105px;" >
					<option value="0" <?php echo $this->isSelected($defaultOptions['useimages'], '0') ?>><?php echo TCK_Text::_('NO'); ?></option>
					<option value="1" <?php echo $this->isSelected($defaultOptions['useimages'], '1') ?>><?php echo TCK_Text::_('YES'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_MOBILEUSEMODULE_LABEL', 'bricks.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_usemodules" id="mobilemenuck_usemodules" value="<?php echo $defaultOptions['usemodules'] ?>" style="width:105px;" >
					<option value="0" <?php echo $this->isSelected($defaultOptions['usemodules'], '0') ?>><?php echo TCK_Text::_('NO'); ?></option>
					<option value="1" <?php echo $this->isSelected($defaultOptions['usemodules'], '1') ?>><?php echo TCK_Text::_('YES'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_SHOWMOBILEMENUTEXT_LABEL', 'text_smallcaps.png') ?>
			<span class="ckoption-field">
				<select class="inputbox mobilemenufield" type="list" name="mobilemenuck_showmobilemenutext" id="mobilemenuck_showmobilemenutext" value="<?php echo $defaultOptions['showmobilemenutext'] ?>" style="width:105px;" onchange="TCK_WidgetMobilemenuToggleShowon(this.value, 'custom','mobilemenuck_mobilemenutext')">
					<option value="default" <?php echo $this->isSelected($defaultOptions['showmobilemenutext'], 'default') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_DEFAULTTEXT'); ?></option>
					<option value="custom" <?php echo $this->isSelected($defaultOptions['showmobilemenutext'], 'custom') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_CUSTOMTEXT'); ?></option>
					<option value="none" <?php echo $this->isSelected($defaultOptions['showmobilemenutext'], 'none"') ?>><?php echo TCK_Text::_('PLG_MOBILEMENUCK_NONE'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('PLG_MOBILEMENUCK_MOBILEMENUTEXT_LABEL', 'text_signature.png') ?>
			<span class="ckoption-field">
				<input type="text" placeholder="" class="inputbox mobilemenufield" name="mobilemenuck_mobilemenutext" id="mobilemenuck_mobilemenutext" value="<?php echo $defaultOptions['mobilemenutext'] ?>" style="width:100px;" />
			</span>
		</div>
		<script>
			$ck('.mobilemenufield').trigger('change');
			$ck('.mobilemenufield').change(function() {
				TCK_WidgetMobilemenuSavePopup();
			});
		</script>
		<?php
	}

	private function isSelected($ref, $option) {
		if ($ref == $option) return ' selected="selected"';
		return '';
	}
}
