<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKView;
use Templatecreatorck\CKFof;
use Templatecreatorck\Helper;

/**
 * View class for a list of Templateck.
 */
class TemplateckViewTemplates extends CKView {

	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->items = $this->get('Items');

		$this->checkDbIntegrity();

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar() {
		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		\Joomla\CMS\Toolbar\ToolbarHelper::title(TCK_Text::_('COM_TEMPLATECK_TITLE_TEMPLATES'), 'templates.png');


		if (CKFof::userCan('create')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::addNew('template.edit', 'JTOOLBAR_NEW');
		}

		TemplateckHelper::loadCkbox();
		TemplateckHelper::loadCkFramework();
		if (CKFof::userCan('edit')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::editList('template.edit', 'JTOOLBAR_EDIT');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('template.copy', 'tck-copyTemplate', 'tck-copyTemplate', 'CK_COPY_TEMPLATE');

			$importButton = '<button class="btn btn-small" onclick="CKBox.open({handler: \'inline\', content: \'ckimportmodal\', fullscreen: false, size: {x: \'600px\', y: \'200px\'}});">
									<span class="icon-forward-2"></span>
									' . TCK_Text::_('CK_IMPORT') . '
								</button>';
			$bar->appendButton('Custom', $importButton, 'import');
			$exportButton = '<button class="btn btn-small" onclick="ckExportPage(document.adminForm);">
									<span class="icon-share"></span>
									' . TCK_Text::_('CK_EXPORT') . '
								</button>';
			$bar->appendButton('Custom', $exportButton, 'export');
		}

		// show delete button
		if (CKFof::userCan('delete')) {
				\Joomla\CMS\Toolbar\ToolbarHelper::trash('template.delete', 'JTOOLBAR_TRASH');
				\Joomla\CMS\Toolbar\ToolbarHelper::divider();
		}

		// show options button
		if (CKFof::userCan('core.admin')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::preferences('com_templateck');
		}

		if (version_compare(JVERSION, '4') < 0) TemplateckHelper::addSidebar();
	}

	private function checkDbIntegrity() {
		$this->searchColumn('widgets');
		$this->searchColumn('modules');
		$this->searchColumn('stylecode', 'longtext');
		$this->searchColumn('identifier', 'varchar(10)');
		$this->searchTable('layouts');
	}

	private function searchColumn($name, $type = 'text') {
		$db = \Joomla\CMS\Factory::getDbo();
		// test if the widget columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_templates LIKE '" . $name . "'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_templates` ADD `' . $name . '` ' . $type . ' NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table column ' . $name . ' update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table column ' . $name . ' updated !</p>';
				}
			}
		} else {
			echo 'SQL error - Check existing ' . $name . ' column';
			return false;
		}
	}

	/**
	 * Look if the table exists, if not then create it
	 * 
	 * @param type $tableName
	 */
	private function searchTable($tableName) {
		$db = \Joomla\CMS\Factory::getDbo();

		$tablesList = $db->getTableList();
		$tableExists = in_array($db->getPrefix() . 'templateck_' . $tableName, $tablesList);
		// test if the table not exists

		if (! $tableExists) {
			$query = "CREATE TABLE IF NOT EXISTS #__templateck_" . $tableName . " (
	`id` int(11) NOT NULL AUTO_INCREMENT,
	`template_id` int(11) NOT NULL,
	`type` text NOT NULL,
	`htmlcode` longtext NOT NULL,
	`styles` text NOT NULL,
	`published` int(11) NOT NULL DEFAULT '1',
	PRIMARY KEY (`id`)
	)";
			$db->setQuery($query);
//			// add the SQL field to the main table
//			$query = 'ALTER TABLE `' . $table . '` ADD `' . $name . '` text NOT NULL;';
			if (! $db->execute($query)) {
				echo '<p class="alert alert-danger">Error during table ' . $tableName . ' creation process !</p>';
			} else {
				echo '<p class="alert alert-success">Table ' . $tableName . ' created with success !</p>';
			}
		} 
	}

}
