<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$objclass = $this->input->get('objclass', '');
$objmoduleposition = $this->input->get('objmoduleposition', '');
$objid = $this->input->get('ckobjid', '');
$objtype = $this->input->get('element', '');
$expertmode = $this->input->get('expertmode', false);
$saveFunc = $this->input->get('savefunc', '', 'cmd');
$saveFunc = $saveFunc ? $saveFunc . '();' : '';

$showheight = (stristr($objclass, 'mainbanner') OR stristr($objclass, 'bannerlogo') OR stristr($objclass, 'horizmenu')) ? true : false;
$showwidth = ((stristr($objclass, 'wrapper') OR stristr($objclass, 'bannerlogo') OR stristr($objclass, 'banner') OR stristr($objclass, 'column')) AND !stristr($objclass, 'content')) ? true : false;
$isContent = (stristr($objclass, 'content') OR stristr($objclass, 'bannerlogodesc')) ? true : false;
$isBody = stristr($objclass, 'body') ? true : false;
$isWrapper = stristr($objclass, 'wrapper') ? true : false;
$isContainer = (stristr($objclass, 'body') OR stristr($objclass, 'wrapper') OR stristr($objclass, 'mainbanner') OR stristr($objclass, 'bannerlogo') OR stristr($objclass, 'flexiblemodules') OR stristr($objclass, 'maincontent') OR stristr($objclass, 'content') OR stristr($objclass, 'ckrow') OR ( stristr($objclass, 'center') && !stristr($objclass, 'centertop') && !stristr($objclass, 'centerbottom') && !stristr($objclass, 'halign-center') )) ? true : false;
$isColumn = (stristr($objclass, 'column1') OR stristr($objclass, 'column2')) ? true : false;
$isLogo = (stristr($objclass, 'bannerlogo')) ? true : false;
$isCustomStyle = ($objtype == 'customstyle') ? true : false;
$isFavorite = (stristr($objclass, 'ckmyfavorite')) ? true : false;
$isModulesContainer = stristr($objclass, 'flexiblemodules') ? true : false;
$isMaincontentContainer = stristr($objclass, 'maincontent') ? true : false;
$isSingleModule = (stristr($objclass, 'singlemodule') || (stristr($objclass, 'flexiblemodule') && !stristr($objclass, 'flexiblemodules'))) ? true : false;
$isHoriznav = (stristr($objclass, 'horiznav') || stristr($objclass, 'bannermenu')) ? true : false;
$isRow = (stristr($objclass, 'ckrow')) ? true : false;
$isMenu = $isHoriznav || $objtype === 'mod_menu';
$menustyles = new CKInterface();
$hasModule = (stristr($objclass, 'singlemodule') || stristr($objclass, 'column1') || stristr($objclass, 'column2') || stristr($objclass, 'module') || stristr($objclass, 'menu') || stristr($objclass, 'flexiblemodule') && !stristr($objclass, 'flexiblemodules')) ? true : false;
?>


<div id="ckelementscontainer" class="ckinterface" style="background: #eee;">
	<?php if ($isCustomStyle) { ?>
		<div class="ckinterfacesliderback ckinterfacesliderback-stylescss">
			<button class="ckinterfaceslider-back-button" tabindex="0">
			</button>
			<div class="ckinterfaceslidertitle">
				<?php echo TCK_Text::_('CK_CUSTOM_STYLES_CREATOR') ?>
		<?php if (! $isCustomStyle && ! $isFavorite) { ?><span class="ckleftpanelsubtitle ckleftpanelsubtitleunder">[ <?php echo $objid ?> ]</span><?php } ?>
</div>
		</div>
		<div class="ckleftpanel-tools">
			<span class="ckbutton cksave ckleftpanelheadericon-apply ckhastip" title="<?php echo TCK_Text::_('CK_APPLY'); ?>" onclick="<?php echo $saveFunc ?>ckRenderCss();"><span class="fack fack-check"></span></span>
		</div>
		<div class="ckbutton" onclick="ckRemoveCustomStyle()"><span class="fack fack-remove" style="color:red;"></span> <?php echo TCK_Text::_('CK_DELETE') ?></div>
		<div class="ckbutton" onclick="ckExportCustomStyle()"><span class="fack fack-share" ></span> <?php echo TCK_Text::_('CK_EXPORT') ?></div>
		<div class="ckoption">
			<?php $this->interface->createLabel('CK_STYLE_NAME', 'text_signature.png') ?>
			<span class="ckoption-field">
				<input class="inputboxfake ckhastip" type="text" title="<?php echo TCK_Text::_('CK_STYLE_NAME_DESC'); ?>" name="ckcustomstylename" id="ckcustomstylename" value="" onchange="ckUpdateCustomStyleData()" />
			</span>
		</div>
		<div class="ckoption">
			<?php $this->interface->createLabel('CK_CSS_SELECTOR', 'text_signature.png') ?>
			<span class="ckoption-field">
				<input class="inputboxfake ckhastip" type="text" title="<?php echo TCK_Text::_('CK_CSS_SELECTOR_DESC'); ?>" name="ckcustomstylecssselector" id="ckcustomstylecssselector" value="" onchange="ckUpdateCustomStyleData()" />
			</span>
		</div>
		<div class="ckproperty" data-id="tab_blocstyles">
		<?php echo $this->interface->createBlocStyles($objid, '', $expertmode) ?>
		</div>
	<?php } else if ($isLogo) { ?>
		<div class="ckclr"></div>
		<div id="elementscontent" class="ckinterfacesliderparent">
			<div class="ckinterfacesliderback ckinterfacesliderback-stylescss">
				<button class="ckinterfaceslider-back-button" tabindex="0">
				</button>
				<div class="ckinterfaceslidertitle">
					<?php echo TCK_Text::_('CK_EDIT') ?>
					<?php if (! $isCustomStyle && ! $isFavorite) { ?><span class="ckleftpanelsubtitle ckleftpanelsubtitleunder">[ <?php echo $objid ?> ]</span><?php } ?>
				</div>
			</div>
			<div class="ckleftpanel-tools">
				<span class="ckbutton cksave ckleftpanelheadericon-apply ckhastip" title="<?php echo TCK_Text::_('CK_APPLY'); ?>" onclick="ckRenderCss();"><span class="fack fack-check"></span></span>
			</div>
			<div class="ckinterfacesliderlinks">
				<div class="ckinterfacesliderlink" tab="tab_blocstyles"><?php echo TCK_Text::_('CK_LOGO_STYLES'); ?></div>
				<div class="ckinterfacesliderlink" tab="tab_logodescstyles"><?php echo TCK_Text::_('CK_LOGODESC_STYLES'); ?></div>
			</div>
			<div class="ckinterfaceslidercontent">
				<div class="ckinterfaceslider ckproperty" data-id="tab_blocstyles">
					<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_LOGO_STYLES')) ?>
					<div class="inner">
				<?php echo $menustyles->createLogoStyles('bloc', $objclass) ?>
			</div>
				</div>
				<div class="ckinterfaceslider ckproperty" data-id="tab_logodescstyles">
					<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_LOGODESC_STYLES')) ?>
					<div class="inner">
				<div class="ckoption">
					<span class="ckoption-label">
						<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>switch.png" width="16" height="16" />
						<?php echo TCK_Text::_('CK_USE_LOGODESC'); ?>
					</span>
					<span class="ckoption-field ckbutton-group">
						<input type="radio" class="logodesc inputbox" value="1" id="uselogodescyes" name="uselogodesc" />
						<label class="ckbutton" for="uselogodescyes"><?php echo TCK_Text::_('JYES'); ?>
						</label><input type="radio" class="logodesc inputbox" value="0" id="uselogodescno" name="uselogodesc" />
						<label class="ckbutton"  for="uselogodescno"><?php echo TCK_Text::_('JNO'); ?>
						</label>
					</span>
					<div class="ckclr"></div>
				</div>
				<div class="ckoption">
					<span class="ckoption-label">
						<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
						<?php echo TCK_Text::_('CK_LOGODESC_TEXT'); ?></span>
					<span class="ckoption-field">
							<input class="logodesc inputbox" type="text" name="logodesctext" id="logodesctext" value="" style="width:220px;" />
					</span>
					<div class="ckclr"></div>
				</div>
				<br />
				<?php echo $menustyles->createBlocStyles('logodesc', $objclass, $expertmode, false) ?>
					</div>
				</div>
			</div>
			
				<div class="ckclr"></div>
			</div>
		<?php
	} else { 
		$menulinktext = $isWrapper ? TCK_Text::_('CK_WRAPPER_STYLES') : TCK_Text::_('CK_BLOCK_STYLES');
		$blocinfos = $isWrapper ? TCK_Text::_('CK_WRAPPER_INFOS') : TCK_Text::_('CK_BLOC_INFOS');
		$blocdesc = $isWrapper ? TCK_Text::_('CK_WRAPPER_DESC') : TCK_Text::_('CK_BLOC_DESC');
		?>
		<div class="ckclr"></div>
		<div id="elementscontent" class="ckinterfacesliderparent">
			<div class="ckinterfacesliderback ckinterfacesliderback-stylescss" <?php echo ($saveFunc ? 'onmousedown="' . $saveFunc . '"' : '') ?>>
				<button class="ckinterfaceslider-back-button" tabindex="0">
				</button>
				<div class="ckinterfaceslidertitle">
					<?php echo TCK_Text::_('CK_EDIT') ?>
					<?php if (! $isCustomStyle && ! $isFavorite) { ?><span class="ckleftpanelsubtitle ckleftpanelsubtitleunder">[ <?php echo $objid ?> ]</span><?php } ?>
				</div>
			</div>
			<div class="ckleftpanel-tools">
				<span class="ckbutton cksave ckleftpanelheadericon-apply ckhastip" title="<?php echo TCK_Text::_('CK_APPLY'); ?>" onclick="<?php echo $saveFunc ?>ckRenderCss();"><span class="fack fack-check"></span></span>
				<?php if (! $isCustomStyle && ! $isFavorite) { ?>
				<span class="ckbutton ckcopy ckhastip" onclick="ckCopyToClipboard(this)" title="<?php echo TCK_Text::_('CK_COPY_CSS'); ?>"><span class="fack fack-files-o"></span> <?php echo TCK_Text::_('CK_COPY'); ?></span>
				<span class="ckbutton ckpaste ckhastip" onclick="ckPasteFromClipboard(this)" title="<?php echo TCK_Text::_('CK_PASTE_CSS'); ?>"><span class="fack fack-clipboard"></span> <?php echo TCK_Text::_('CK_PASTE'); ?></span>
				<div class="ckbutton" onclick="ckQuickStyles()"><span class="fack fack-bolt"></span> <?php echo TCK_Text::_('CK_QUICK_STYLES') ?></div>
				<span class="ckbutton ckclean ckhastip" onclick="ckClearStylesFromPanel();"><span class="fack fack-paint-brush"></span> <?php echo TCK_Text::_('CK_CLEAR'); ?></span>
				<?php } ?>
			</div>
			<div class="ckinterfacesliderlinks">
				<div class="ckinterfacesliderlink" tab="tab_settings"><?php echo TCK_Text::_('CK_SETTINGS'); ?></div>
				<?php if ($isRow) { ?><div class="ckinterfacesliderlink" tab="tab_columns" onmousedown="ckShowColumnsEdition('<?php echo $objid ?>', true)"><?php echo TCK_Text::_('CK_COLUMNS'); ?></div><?php } ?>
			<?php if ($isWrapper || ($isRow && $expertmode == 'true')) { ?>
				<div class="ckinterfacesliderlink" tab="tab_bodystyles"><?php echo TCK_Text::_('CK_BODY_STYLES'); ?></div>
				<?php } ?>
				<div class="ckinterfacesliderlink" tab="tab_blocstyles" ><?php echo $menulinktext; ?></div>
				<?php if (($expertmode == 'true' && !$isContainer) || $isColumn) { ?>
					<div class="ckinterfacesliderlink<?php if ($expertmode == 'true') echo ' ckexpertmode'; ?>" tab="tab_modulestyles"><?php echo TCK_Text::_('CK_MODULES_STYLES'); ?></div>
				<?php } ?>
				<?php if (!$isContainer) { ?>
					<div class="ckinterfacesliderlink" tab="tab_moduletitlestyles"><?php echo TCK_Text::_('CK_MODULES_TITLE_STYLES'); ?></div>
					<div class="ckinterfacesliderlink" tab="tab_moduletextstyles"><?php echo TCK_Text::_('CK_MODULES_TEXT_STYLES'); ?></div>
					<?php if ($isSingleModule) { ?>
					<div class="ckinterfacesliderlink" tab="tab_iconstyles"><?php echo TCK_Text::_('CK_ICON_STYLES'); ?></div>
					<?php } ?>
					<?php if ($expertmode == 'true' || $isMenu) { ?>
					<div class="ckinterfacesliderlink<?php if ($expertmode == 'true' && !$isHoriznav) echo ' ckexpertmode'; ?>" tab="tab_menustyles"><?php echo TCK_Text::_('CK_MENUS_STYLES'); ?></div>
					<?php } ?>
				<?php } ?>
				<?php if ($isContainer || $isSingleModule) { ?>
				<div class="ckinterfacesliderlink" tab="tab_videobgstyles"><?php echo TCK_Text::_('CK_VIDEO_BACKGROUND_STYLES'); ?></div>
				<?php } ?>
				<?php if ($isContainer) { ?>
				<div class="ckinterfacesliderlink" tab="tab_divider"><?php echo TCK_Text::_('CK_DIVIDER'); ?></div>
				<?php } ?>
			</div>
			<div class="ckinterfaceslidercontent">
				<div class="ckinterfaceslider" data-id="tab_settings">
					<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_SETTINGS')) ?>
					<div class="inner">
						<div class="ckoption">
							<?php $this->interface->createLabel('CK_HTML_ID') ?>
							<span class="ckoption-field">
								<input class="inputboxfake ckhastip" type="text" name="settings_blocid" id="settings_blocid" value="" style="width:220px;" />
							</span>
						</div>
						<div class="ckoption">
							<?php $this->interface->createLabel('CK_CSS_CLASS') ?>
							<span class="ckoption-field">
								<input class="inputbox ckhastip" type="text" name="settings_cssclass" id="settings_cssclass" value="" style="width:220px;" />
							</span>
						</div>
						<?php if ($hasModule) { ?>
						<div class="ckoption">
							<?php $this->interface->createLabel('CK_POSITION') ?>
							<span class="ckoption-field">
								<input class="inputboxfake ckhastip" type="text" name="settings_moduleposition" id="settings_moduleposition" value="" style="width:220px;" />
							</span>
						</div>
						<div class="ckoption">
							<div class="ckbutton" onclick="ckShowModulesList('<?php echo $objtype ?>', '<?php echo $objmoduleposition ?>', '<?php echo $objid ?>')" style="display:block;"><span class="fack fack-cogs"></span> <?php echo TCK_Text::_('CK_MODULE_EDITION_TOOLTIP') ?></div>
						</div>
						<?php } ?>
						<hr/>
						<div class="ckoption">
							<div class="ckbutton" onclick="ckDeleteBloc('<?php echo $objid ?>')" style="display:block;"><span class="fack fack-times" style="color:red;"></span> <?php echo TCK_Text::_('CK_REMOVE') ?></div>
						</div>
					</div>
				</div>
				<div class="ckinterfaceslider" data-id="tab_columns">
				</div>
				<?php if ($isWrapper || ($isRow && $expertmode == 'true')) { ?>
					<div class="ckinterfaceslider ckproperty" data-id="tab_bodystyles">
						<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_BODY_STYLES')) ?>
						<div class="inner">
					<?php echo $menustyles->createBlocStyles('body', 'wrapper', $expertmode) ?>
				</div>
					</div>
			<?php } ?>
				<div class="ckinterfaceslider ckproperty" data-id="tab_blocstyles">
					<?php TemplateckHelper::renderInterfaceSliderTitle($menulinktext) ?>
					<div class="inner">
				<?php echo $menustyles->createBlocStyles('bloc', $objclass, $expertmode) ?>
			</div>
				</div>
			<?php if (($expertmode == 'true' && !$isContainer) || $isColumn) { ?>
				<div class="ckinterfaceslider ckproperty" data-id="tab_modulestyles">
					<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_MODULES_STYLES')) ?>
					<div class="inner">
					<?php echo $menustyles->createModuleStyles('module', $objclass) ?>
				</div>
				</div>
			<?php } ?>
			<?php if (!$isContainer) { ?>
					<div class="ckinterfaceslider ckproperty" data-id="tab_moduletitlestyles">
						<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_MODULES_TITLE_STYLES')) ?>
						<div class="inner">
					<?php echo $menustyles->createModuletitleStyles('moduletitle', $objclass) ?>
				</div>
					</div>
					<div class="ckinterfaceslider ckproperty" data-id="tab_moduletextstyles">
						<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_MODULES_TEXT_STYLES')) ?>
						<div class="inner">
					<?php echo $menustyles->createBlocStyles('moduletext', $objclass) ?>
				</div>
					</div>
				<?php if ($isSingleModule) { ?>
					<div class="ckinterfaceslider ckproperty ckquickstyle-hide" data-id="tab_iconstyles">
						<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_ICON_STYLES')) ?>
						<div class="inner">
					<?php echo $menustyles->createIconStyles('icon', $fromicon = '.ckfocus span.fack', $objclass = '', $space = false, $align = true, $font = true) /* onclick="$ck('<?php echo $fromicon ?>').remove()"*/ ?>
				</div>
					</div>
				<?php } ?>
				<?php if ($expertmode == 'true' || $isMenu) { ?>
					<div class="ckinterfaceslider" data-id="tab_menustyles" style="position:relative;">
					<div class="inner"></div>
				</div>
				<script>ckLoadTab_menustyles();</script>
				<?php } ?>
			<?php } ?>
			

			<?php if ($isContainer || $isSingleModule) { ?>
					<div class="ckinterfaceslider ckproperty" data-id="tab_videobgstyles">
						<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_VIDEO_BACKGROUND_STYLES')) ?>
						<div class="inner">
					<?php echo $menustyles->createVideobgStyles() ?>
							<div class="ckclr"></div>
				</div>
					</div>
			<?php } ?>
			<?php if ($isContainer) { ?>
					<div class="ckinterfaceslider ckproperty" data-id="tab_divider">
						<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_DIVIDER')) ?>
						<div class="inner">
					<?php echo $menustyles->createDivider() ?>
					<div class="ckclr"></div>
				</div>
					</div>
			<?php } ?>
		</div>
		</div>
	<?php } ?>
</div>
<div class="ckclr"></div>
<script language="javascript" type="text/javascript">
	ckInitOptionsTabs();
	ckInitColorPickers();
	ckInitModalPopup();
	ckInitOptionsAccordions($ck('#ckedition')); // note : ckpreviewedition
	ckInitOptionsSliders($ck('#ckelementscontainer .ckinterfacesliderparent'));
	ckInitRangeInputs();
</script>