<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */


// no direct access
defined('_JEXEC') or die('Restricted access');

class com_templateckInstallerScript {

	function preflight() {
		$db = \Joomla\CMS\Factory::getDbo();

		$tablesList = $db->getTableList();
		$tableExists = in_array($db->getPrefix() . 'templateck_templates', $tablesList);
		if ($tableExists) {
			$this->updateTable350();
			$this->updateTable399();
			$this->updateTable400();
		}
	}

	function postflight() {
		?>
		<style>
			.aboutversion {
				margin: 10px;
				padding: 10px;
				font-size: 20px;
				font-color: #000;

			}
			.ckabout {
				background: url("https://media.joomlack.fr/images/texture/texture_003.jpg") center center repeat;
				background-size: auto auto;
				color: #fff;
				font-family: verdana;
				font-size: 13px;
				border-radius: 5px;
				box-shadow: #111 0 0 5px;
				background-size: cover;
				position: relative;
				overflow: hidden;
				text-align: center;
			}
			.ckabout > .inner {
				padding: 20px;
				background: rgba(40,40,40,0.7);
			}
			.ckabout > .inner > *{
				padding: 10px;
			}
			.ckabout > .inner br {
				margin: 10px;
				display: block;
			}
			.ckabout a {
				color: orange;
			}
		</style>
		<div class="ckabout">
			<div class="inner">
				<div class="ckcenter"><img src="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/administrator/components/com_templateck/images/logo_templateck.png" /></div>
				<p class="ckcenter"><a href="https://www.template-creator.com" target="_blank">https://www.template-creator.com</a></p>
				<p class="ckcenter"><?php echo \Joomla\CMS\Language\Text::_('CK_TEMPLATECK_DESC2'); ?></p>
			</div>
		</div>
		<?php
	}

	function update( $parent ) {
		// check the installed version
		$oldversion = $this->getParam('version');
		if (version_compare($oldversion, '4.0.0') < 0) {
			$this->updateTable400();
		}
		if (version_compare($oldversion, '3.5.0') < 0) {
			$this->updateTable350();
		}
		if (version_compare($oldversion, '3.4.4') >= 0) {
			//echo 'Update script loaded you have the last version';
			return;
		}
		// this is an old version, then update the table
		$this->updateTable();
	}

	/*
	 * get a variable from the manifest file (actually, from the manifest cache).
	 */
	function getParam( $name ) {
		$db = \Joomla\CMS\Factory::getDbo();
		$db->setQuery('SELECT manifest_cache FROM #__extensions WHERE element = "com_templateck"');
		$manifest = json_decode( $db->loadResult(), true );
		return $manifest[ $name ];
	}

	/*
	* update the table
	*/
	function updateTable() {
		$db = \Joomla\CMS\Factory::getDbo();
		// test for order column title depending on virtuemart version

		// test if the columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_fonts LIKE 'additional_fonts'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_fonts` ADD `additional_fonts` text NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table templateck update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table templateck_fonts updated !</p>';
				}
			}
		} else {
			echo 'Erreur de données SQL - Test si champ responsive existe';
			return false;
		}
	}

	/*
	* update the table
	*/
	function updateTable350() {
		$db = \Joomla\CMS\Factory::getDbo();

		// test if the columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_templates LIKE 'widgets'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_templates` ADD `widgets` text NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table widgets update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table widgets updated !</p>';
				}
			}
		} else {
			echo 'SQL error - Check existing widgets column';
			return false;
		}
	}

	/*
	* update the table
	*/
	function updateTable399() {
		$db = \Joomla\CMS\Factory::getDbo();

		// test if the columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_templates LIKE 'modules'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_templates` ADD `modules` text NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table modules update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table modules updated !</p>';
				}
			}
		} else {
			echo 'SQL error - Check existing modules column';
			return false;
		}
	}

	function updateTable400() {
		$db = \Joomla\CMS\Factory::getDbo();

		// test if the columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_templates LIKE 'stylecode'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_templates` ADD `stylecode` longtext NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table stylecode update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table stylecode updated !</p>';
				}
			}
		} else {
			// echo 'SQL error - Check existing stylecode column';
			// return false;
		}
		$sql = "CREATE TABLE IF NOT EXISTS `#__templateck_layouts` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`template_id` int(11) NOT NULL,
			`type` text NOT NULL,
			`htmlcode` longtext NOT NULL,
			`styles` text NOT NULL,
			`published` int(11) NOT NULL DEFAULT '1',
			PRIMARY KEY (`id`)
		  );";
		$db->setQuery($query);
		if ($db->execute()) {
			echo '<p class="alert alert-success">Table layouts created !</p>';
		} else {
			echo '<p class="alert alert-danger">Error during table layouts creation process !</p>';
		}
	}
}