<?php
/**
 * @package RSForm! Pro
 * @copyright (C) 2007-2019 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class RsformViewEmail extends HtmlView
{
	public function display($tpl = null)
	{
        if (!Factory::getUser()->authorise('forms.manage', 'com_rsform'))
        {
            throw new Exception(Text::_('COM_RSFORM_NOT_AUTHORISED_TO_USE_THIS_SECTION'));
        }

		$this->formId        = $this->get('FormId');
        $this->type          = $this->get('Type');
		$this->row           = $this->get('Item');
		$this->form          = $this->get('Form');
		$this->lang          = $this->get('CurrentLanguage');
		$this->translateIcon = RSFormProHelper::translateIcon();

		$displayPlaceholders    = RSFormProHelper::generateQuickAddGlobal('display', true);
		$quickfields            = $this->get('quickfields');
		foreach ($quickfields as $fields)
		{
			$displayPlaceholders = array_merge($displayPlaceholders, $fields['display']);
		}

		$this->document->addScriptDeclaration('RSFormPro.Placeholders = ' . json_encode(array_values($displayPlaceholders)) . ';');

		parent::display($tpl);
	}
}