/*
 * Regular.js - A light and simple JavaScript Library
 * Copyright © 2025 Regular Labs - All Rights Reserved
 * License https://github.com/regularlabs/regularjs/blob/master/LICENCE MIT
 */
"use strict";if(typeof window.Regular==='undefined'||typeof Regular.version==='undefined'||Regular.version<1.5){window.Regular=new function(){this.version=1.5;this.alias=function(word){if(typeof window[word]!=='undefined'){console.error(`Cannot set'${word}'as an alias of Regular,as it already exists.`);return false;}
window[word]=$;return true;};this.hasClasses=function(selector,classes,matchAll=true){if(!selector){return false;}
const element=typeof selector==='string'?document.querySelector(selector):selector;if(!element){return false;}
if(typeof classes==='string'){classes=classes.split(' ');}
let hasClass=false;for(const clss of classes){hasClass=element.classList.contains(clss);if(matchAll&&!hasClass){return false;}
if(!matchAll&&hasClass){return true;}}
return hasClass;};this.addClasses=function(selector,classes){doClasses('add',selector,classes);};this.removeClasses=function(selector,classes){doClasses('remove',selector,classes);};this.toggleClasses=function(selector,classes,force){switch(force){case true:doClasses('add',selector,classes);break;case false:doClasses('remove',selector,classes);break;default:doClasses('toggle',selector,classes);break;}};this.makeVisible=function(selector){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.makeVisible(subElement));return;}
let computedDisplay=getComputedStyle(element,'display');if(!('origDisplay'in element)){element.origDisplay=computedDisplay==='none'?getDefaultComputedStyle(element,'display'):computedDisplay;}
if(element.origDisplay){element.style.display=element.origDisplay;element.style.visibility='visible';return;}
if(computedDisplay==='none'){element.style.display=('origDisplay'in element)?element.origDisplay:'';}
let elementType=element.nodeName.toLowerCase();switch(elementType){case'tr':elementType='table-row';break;case'td':case'th':elementType='table-cell';break;case'caption':elementType='table-caption';break;case'col':elementType='table-column';break;case'colgroup':elementType='table-column-group';break;case'table':elementType='table';break;case'thead':elementType='table-header-group';break;case'tbody':elementType='table-row-group';break;case'tfoot':elementType='table-footer-group';break;default:elementType='block';break;}
element.style.display=elementType;element.style.visibility='visible';};this.show=function(selector){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.show(subElement));return;}
this.makeVisible(element);element.style.opacity=1;};this.hide=function(selector){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.hide(subElement));return;}
const computedDisplay=getComputedStyle(element,'display');if(computedDisplay!=='none'&&!('origDisplay'in element)){element.origDisplay=computedDisplay;}
element.style.display='none';element.style.visibility='hidden';element.style.opacity=0;};this.toggle=function(selector,force){if(!selector){return;}
switch(force){case true:$.show(selector);break;case false:$.hide(selector);break;default:const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.toggle(subElement));return;}
element.style.display==='none'?$.show(selector):$.hide(selector);break;}};this.fadeIn=function(selector,duration=250,oncomplete){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;this.makeVisible(element);$.fadeTo(element,1,duration,()=>{$.show(element);if(oncomplete){oncomplete.call(element);}});};this.fadeOut=function(selector,duration=250,oncomplete){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;$.fadeTo(element,0,duration,()=>{$.hide(element);if(oncomplete){oncomplete.call(element);}});};this.fadeTo=function(selector,opacity,duration=250,oncomplete){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>$.fadeTo(subElement,opacity,duration));return;}
const wait=50;const nr_of_steps=duration/wait;const change=1/nr_of_steps;element.style.opacity=getComputedStyle(element,'opacity');if(opacity===element.style.opacity){element.setAttribute('data-fading','');if(oncomplete){oncomplete.call(element);}
return;}
this.makeVisible(element);const direction=opacity>element.style.opacity?'in':'out';element.setAttribute('data-fading',direction);(function fade(){if(element.getAttribute('data-fading')&&element.getAttribute('data-fading')!==direction){return;}
const new_opacity=direction==='out'?parseFloat(element.style.opacity)-change:parseFloat(element.style.opacity)+change;if((direction==='in'&&new_opacity>=opacity)||(direction==='out'&&new_opacity<=opacity)){element.style.opacity=opacity;element.setAttribute('data-fading','');if(oncomplete){oncomplete.call(element);}
return;}
element.style.opacity=new_opacity;setTimeout(()=>{fade.call();},wait);})();};this.onReady=function(func){document.addEventListener('DOMContentLoaded',func);};this.createElementFromHTML=function(html){return document.createRange().createContextualFragment(html);};this.loadUrl=function(url,data,success,fail){const request=new XMLHttpRequest();request.open('POST',url,true);request.setRequestHeader('Content-type','application/x-www-form-urlencoded');request.onreadystatechange=function(){if(this.readyState!==4){return;}
if(this.status===200){success&&success.call(null,this.responseText,this.status,this);return;}
fail&&fail.call(null,this.responseText,this.status,this);};request.send(this.toUrlQueryString(data));};this.toUrlQueryString=function(data,prefix){if(typeof data!=='object'){return data;}
const parts=[];if(!(Symbol.iterator in Object(data))){data=Object.entries(data);}
for(let i in data){let value=data[i];let name='';if(value instanceof Array){[name,value]=value;}
let key=name?(prefix?`${prefix}[${name}]`:name):prefix;if(!key){continue;}
if(value!==null&&typeof value==='object'){if(value instanceof Array){key+='[]';}
parts.push(this.toUrlQueryString(value,key));continue;}
parts.push(`${key}=${value}`);}
return parts.join('&');};this.as=this.alias;this.hasClass=this.hasClasses;this.addClass=this.addClasses;this.removeClass=this.removeClasses;this.toggleClass=this.toggleClasses;const doClasses=function(action,selector,classes){if(!selector){return;}
const element=typeof selector==='string'?document.querySelectorAll(selector):selector;if('forEach'in element){element.forEach(subElement=>doClasses(action,subElement,classes));return;}
if(typeof classes==='string'){classes=classes.split(' ');}
element.classList[action](...classes);};const getComputedStyle=function(element,property){if(!element){return null;}
return window.getComputedStyle(element).getPropertyValue(property);};const getDefaultComputedStyle=function(element,property){if(!element){return null;}
const defaultElement=document.createElement(element.nodeName);document.body.append(defaultElement);let propertyValue=window.getComputedStyle(defaultElement).getPropertyValue(property);defaultElement.remove();return propertyValue;};const $=this;};}
