/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('23', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=321 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages'),
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields'),
('21', 'com_guidedtours');
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int unsigned NOT NULL,
  `notify` tinyint unsigned NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('stats_lastrun', '1738924990'),
('stats_siteid', '7fa3650e4fcb03dbc2942288947379540e275a77'),
('stats_siteurl', '4149cf980766a92111766536103df852');
/**ABDB**/CREATE TABLE `#__akeebabackup_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `backupstart` timestamp NULL DEFAULT NULL,
  `backupend` timestamp NULL DEFAULT NULL,
  `status` enum('run','fail','complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',
  `origin` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',
  `profile_id` bigint NOT NULL DEFAULT '1',
  `archivename` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `absolute_path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `multipart` int NOT NULL DEFAULT '0',
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backupid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesexist` tinyint NOT NULL DEFAULT '1',
  `remote_filename` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_size` bigint NOT NULL DEFAULT '0',
  `frozen` tinyint(1) NOT NULL DEFAULT '0',
  `instep` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_backups`  VALUES 
('22', 'Backup taken on Wednesday, 18 June 2025 18:26 SAST', 'For live', '2025-06-18 16:27:01', '2025-06-18 16:27:18', 'complete', 'backend', 'full', '1', 'site-20250618-182701-iWNj4wNQsl43pDYm.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250618-182701-iWNj4wNQsl43pDYm.zip', '0', 'backend', 'id-20250618-162701-10359', '0', NULL, '52333463', '0', '1'),
('23', 'Backup taken on Thursday, 19 June 2025 09:48 SAST', 'Before updates', '2025-06-19 07:48:40', '2025-06-19 07:49:19', 'complete', 'backend', 'full', '1', 'site-20250619-094840-F3WVOK6gXsfG9Nly.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250619-094840-F3WVOK6gXsfG9Nly.zip', '0', 'backend', 'id-20250619-074840-491237', '0', NULL, '52333661', '0', '1'),
('24', 'Backup taken on Thursday, 19 June 2025 10:27 SAST', 'Before updates', '2025-06-19 08:27:30', '2025-06-19 08:28:00', 'complete', 'backend', 'full', '1', 'site-20250619-102730-hyuK71YtqOalxwvt.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250619-102730-hyuK71YtqOalxwvt.zip', '0', 'backend', 'id-20250619-082730-509182', '0', NULL, '52333757', '0', '1'),
('25', 'Backup taken on Monday, 07 July 2025 13:13 SAST', 'Before updates', '2025-07-07 11:13:36', '2025-07-07 11:13:51', 'complete', 'backend', 'full', '1', 'site-20250707-131336-7Ji2ygNZg8116WXe.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250707-131336-7Ji2ygNZg8116WXe.zip', '0', 'backend', 'id-20250707-111336-470538', '0', NULL, '52334467', '0', '1'),
('26', 'Backup taken on Monday, 07 July 2025 13:14 SAST', 'For use', '2025-07-07 11:14:47', '2025-07-07 11:14:59', 'complete', 'backend', 'full', '1', 'site-20250707-131447-9fqClk1nu-FhwrXr.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250707-131447-9fqClk1nu-FhwrXr.zip', '0', 'backend', 'id-20250707-111447-824676', '1', NULL, '52366776', '0', '1'),
('27', 'Backup taken on Saturday, 12 July 2025 11:50 SAST', 'Before updates', '2025-07-12 09:51:02', '2025-07-12 09:51:17', 'complete', 'backend', 'full', '1', 'site-20250712-115102-rOIQqDWl4DBuf_RO.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250712-115102-rOIQqDWl4DBuf_RO.zip', '0', 'backend', 'id-20250712-095102-299621', '1', NULL, '52377085', '0', '1'),
('28', 'Backup taken on Saturday, 12 July 2025 11:52 SAST', 'To use offline', '2025-07-12 09:52:08', '2025-07-12 09:52:20', 'complete', 'backend', 'full', '1', 'site-20250712-115208-BocIsuJyC1flO3QF.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250712-115208-BocIsuJyC1flO3QF.zip', '0', 'backend', 'id-20250712-095208-490992', '1', NULL, '52416676', '0', '1'),
('29', 'Backup taken on Thursday, 17 July 2025 19:20 SAST', 'Before updates', '2025-07-17 17:20:49', '2025-07-17 17:21:15', 'complete', 'backend', 'full', '1', 'site-20250717-192049-kJtfm-JF013XMVMH.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250717-192049-kJtfm-JF013XMVMH.zip', '0', 'backend', 'id-20250717-172049-334384', '1', NULL, '52416851', '0', '1'),
('30', 'Backup taken on Tuesday, 12 August 2025 18:23 SAST', 'Before updates', '2025-08-12 16:23:25', '2025-08-12 16:23:51', 'complete', 'backend', 'full', '1', 'site-20250812-182325-5KwusDaMraH5uhdi.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250812-182325-5KwusDaMraH5uhdi.zip', '0', 'backend', 'id-20250812-162325-536256', '1', NULL, '52508040', '0', '1'),
('31', 'Backup taken on Wednesday, 13 August 2025 12:26 SAST', 'To use for Musoya', '2025-08-13 10:27:07', '2025-08-13 10:27:08', 'complete', 'backend', 'full', '1', 'site-20250813-122707-s0eQ1LxU7QgiUTKK.zip', '/home/tscdemo/public_html/base/administrator/components/com_akeebabackup/backup/site-20250813-122707-s0eQ1LxU7QgiUTKK.zip', '0', 'backend', 'id-20250813-102707-433029', '1', NULL, '0', '0', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_profiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `filters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quickicon` tinyint NOT NULL DEFAULT '1',
  `access` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_profiles`  VALUES 
('1', 'Client Backup', '###AES128###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', '', '1', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '0', '201', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.api\":{\"8\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '17', '42', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.execute.transition\":{\"6\":1,\"5\":1}}'),
('9', '1', '43', '44', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '45', '46', '1', 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '47', '50', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
('12', '11', '48', '49', '2', 'com_languages.language.1', 'English (en-GB)', '{}'),
('13', '1', '51', '52', '1', 'com_login', 'com_login', '{}'),
('14', '1', '53', '54', '1', 'com_mails', 'com_mails', '{}'),
('15', '1', '55', '56', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '57', '62', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
('17', '1', '63', '64', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '65', '140', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
('19', '1', '141', '144', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('20', '1', '145', '146', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
('21', '1', '147', '148', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
('23', '1', '149', '150', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
('24', '1', '155', '158', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
('26', '1', '159', '160', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '23', '2', 'com_content.category.2', 'General', '{}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{}'),
('30', '19', '142', '143', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
('32', '24', '156', '157', '2', 'com_users.category.7', 'Uncategorised', '{}'),
('33', '1', '161', '162', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '163', '164', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
('35', '1', '165', '166', '1', 'com_tags', 'com_tags', '{}'),
('36', '1', '167', '168', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('37', '1', '169', '170', '1', 'com_ajax', 'com_ajax', '{}'),
('38', '1', '171', '172', '1', 'com_postinstall', 'com_postinstall', '{}'),
('39', '18', '66', '67', '2', 'com_modules.module.1', 'Main Menu', '{}'),
('40', '18', '68', '69', '2', 'com_modules.module.2', 'Login', '{}'),
('41', '18', '70', '71', '2', 'com_modules.module.3', 'Popular Articles', '{}'),
('42', '18', '72', '73', '2', 'com_modules.module.4', 'Recently Added Articles', '{}'),
('43', '18', '74', '75', '2', 'com_modules.module.8', 'Toolbar', '{}'),
('44', '18', '76', '77', '2', 'com_modules.module.9', 'Notifications', '{}'),
('45', '18', '78', '79', '2', 'com_modules.module.10', 'Logged-in Users', '{}'),
('46', '18', '80', '81', '2', 'com_modules.module.12', 'Admin Menu', '{}'),
('49', '18', '86', '87', '2', 'com_modules.module.15', 'Title', '{}'),
('50', '18', '88', '89', '2', 'com_modules.module.16', 'Login Form', '{}'),
('51', '18', '90', '91', '2', 'com_modules.module.17', 'Breadcrumbs', '{}'),
('52', '18', '92', '93', '2', 'com_modules.module.79', 'Multilanguage status', '{}'),
('53', '18', '96', '97', '2', 'com_modules.module.86', 'Joomla Version', '{}'),
('54', '16', '58', '59', '2', 'com_menus.menu.1', 'Main Menu', '{}'),
('55', '18', '100', '101', '2', 'com_modules.module.87', 'Sample Data', '{}'),
('56', '8', '24', '41', '2', 'com_content.workflow.1', 'COM_WORKFLOW_BASIC_WORKFLOW', '{}'),
('57', '56', '25', '26', '3', 'com_content.stage.1', 'COM_WORKFLOW_BASIC_STAGE', '{}'),
('58', '56', '27', '28', '3', 'com_content.transition.1', 'UNPUBLISH', '{}'),
('59', '56', '29', '30', '3', 'com_content.transition.2', 'PUBLISH', '{}'),
('60', '56', '31', '32', '3', 'com_content.transition.3', 'TRASH', '{}'),
('61', '56', '33', '34', '3', 'com_content.transition.4', 'ARCHIVE', '{}'),
('62', '56', '35', '36', '3', 'com_content.transition.5', 'FEATURE', '{}'),
('63', '56', '37', '38', '3', 'com_content.transition.6', 'UNFEATURE', '{}'),
('64', '56', '39', '40', '3', 'com_content.transition.7', 'PUBLISH_AND_FEATURE', '{}'),
('65', '1', '151', '152', '1', 'com_privacy', 'com_privacy', '{}'),
('66', '1', '153', '154', '1', 'com_actionlogs', 'com_actionlogs', '{}'),
('67', '18', '82', '83', '2', 'com_modules.module.88', 'Latest Actions', '{}'),
('68', '18', '84', '85', '2', 'com_modules.module.89', 'Privacy Dashboard', '{}'),
('70', '18', '94', '95', '2', 'com_modules.module.103', 'Site', '{}'),
('71', '18', '98', '99', '2', 'com_modules.module.104', 'System', '{}'),
('72', '18', '102', '103', '2', 'com_modules.module.91', 'System Dashboard', '{}'),
('73', '18', '104', '105', '2', 'com_modules.module.92', 'Content Dashboard', '{}'),
('74', '18', '106', '107', '2', 'com_modules.module.93', 'Menus Dashboard', '{}'),
('75', '18', '108', '109', '2', 'com_modules.module.94', 'Components Dashboard', '{}'),
('76', '18', '110', '111', '2', 'com_modules.module.95', 'Users Dashboard', '{}'),
('77', '18', '112', '113', '2', 'com_modules.module.99', 'Frontend Link', '{}'),
('78', '18', '114', '115', '2', 'com_modules.module.100', 'Messages', '{}'),
('79', '18', '116', '117', '2', 'com_modules.module.101', 'Post Install Messages', '{}'),
('80', '18', '118', '119', '2', 'com_modules.module.102', 'User Status', '{}'),
('82', '18', '120', '121', '2', 'com_modules.module.105', '3rd Party', '{}'),
('83', '18', '122', '123', '2', 'com_modules.module.106', 'Help Dashboard', '{}'),
('84', '18', '124', '125', '2', 'com_modules.module.107', 'Privacy Requests', '{}'),
('85', '18', '126', '127', '2', 'com_modules.module.108', 'Privacy Status', '{}'),
('86', '18', '128', '129', '2', 'com_modules.module.96', 'Popular Articles', '{}'),
('87', '18', '130', '131', '2', 'com_modules.module.97', 'Recently Added Articles', '{}'),
('88', '18', '132', '133', '2', 'com_modules.module.98', 'Logged-in Users', '{}'),
('89', '18', '134', '135', '2', 'com_modules.module.90', 'Login Support', '{}'),
('90', '1', '173', '174', '1', 'com_scheduler', 'com_scheduler', '{}'),
('91', '1', '175', '176', '1', 'com_associations', 'com_associations', '{}'),
('92', '1', '177', '178', '1', 'com_categories', 'com_categories', '{}'),
('93', '1', '179', '180', '1', 'com_fields', 'com_fields', '{}'),
('94', '1', '181', '182', '1', 'com_workflow', 'com_workflow', '{}'),
('95', '1', '183', '184', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('96', '18', '136', '137', '2', 'com_modules.module.109', 'Guided Tours', '{}'),
('97', '1', '185', '186', '1', 'com_scheduler.task.1', 'com_scheduler.task.1', '{}'),
('98', '1', '187', '188', '1', 'com_scheduler.task.2', 'com_scheduler.task.2', '{}'),
('99', '1', '189', '190', '1', 'com_scheduler.task.3', 'com_scheduler.task.3', '{}'),
('100', '1', '191', '192', '1', 'com_templateck', 'com_templateck', '{}'),
('101', '1', '193', '194', '1', 'com_akeebabackup', 'com_akeebabackup', '{}'),
('102', '1', '195', '196', '1', 'com_jce', 'COM_JCE', '{}'),
('103', '1', '197', '198', '1', 'com_rsform', 'com_rsform', '{}'),
('104', '18', '138', '139', '2', 'com_modules.module.110', 'Copyright', '{}'),
('105', '27', '19', '20', '3', 'com_content.article.1', 'Home', '{}'),
('106', '1', '199', '200', '1', 'com_osmap', 'COM_OSMAP', '{}'),
('107', '16', '60', '61', '2', 'com_menus.menu.2', 'Hidden Menu', '{}'),
('108', '27', '21', '22', '3', 'com_content.article.2', 'Page Not Found', '{}');
/**ABDB**/CREATE TABLE `#__associations` (
  `id` int NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int unsigned NOT NULL,
  `banner_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banners` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cid` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int NOT NULL DEFAULT '0',
  `impmade` int NOT NULL DEFAULT '0',
  `clicks` int NOT NULL DEFAULT '0',
  `clickurl` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `published` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__categories`  VALUES 
('1', '0', '0', '0', '11', '0', '', 'system', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('2', '27', '1', '1', '2', '1', 'general-category', 'com_content', 'General', 'general-category', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2025-01-29 07:27:22', '0', '*', '1'),
('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('7', '32', '1', '9', '10', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__contact_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint unsigned NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `catid` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content`  VALUES 
('1', '105', 'Home', 'home-info', '<p>Lorem Ipsum</p>', '', '1', '2', '2024-10-22 12:35:13', '15', '', '2024-10-22 12:35:13', '15', NULL, NULL, '2024-10-22 12:35:13', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '1', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('2', '108', 'Page Not Found', '404', '<p>Oops! The page you\'re looking for can\'t be found.</p>\r\n<p>&nbsp;</p>\r\n<p>Please navigate back to our <a href=\"index.php?Itemid=101\" target=\"_self\" title=\"Home\">home page</a>.</p>', '', '1', '2', '2025-02-02 09:19:12', '15', '', '2025-02-02 09:19:12', '15', NULL, NULL, '2025-02-02 09:19:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"noindex, nofollow\",\"author\":\"\",\"rights\":\"\"}', '0', '*', '');
/**ABDB**/CREATE TABLE `#__content_frontpage` (
  `content_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_rating` (
  `content_id` int NOT NULL DEFAULT '0',
  `rating_sum` int unsigned NOT NULL DEFAULT '0',
  `rating_count` int unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_types` (
  `type_id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=10000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_types`  VALUES 
('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('2', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
('3', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('4', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
('5', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('6', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('7', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('8', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('9', 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('10', 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('11', 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
('12', 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('13', 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');
/**ABDB**/CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';
/**ABDB**/CREATE TABLE `#__extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL,
  `enabled` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '1',
  `protected` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `locked` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  `manifest_cache` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int DEFAULT '0',
  `state` int DEFAULT '0',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=294 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('1', '0', 'com_wrapper', 'component', 'com_wrapper', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, '0', '0', NULL),
('2', '0', 'com_admin', 'component', 'com_admin', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, '0', '0', NULL),
('3', '0', 'com_banners', 'component', 'com_banners', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, '0', '0', NULL),
('4', '0', 'com_cache', 'component', 'com_cache', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, '0', '0', NULL),
('5', '0', 'com_categories', 'component', 'com_categories', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, '0', '0', NULL),
('6', '0', 'com_checkin', 'component', 'com_checkin', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, '0', '0', NULL),
('7', '0', 'com_contact', 'component', 'com_contact', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"show_misc\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('8', '0', 'com_cpanel', 'component', 'com_cpanel', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, '0', '0', NULL),
('9', '0', 'com_installer', 'component', 'com_installer', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, '0', '0', NULL),
('10', '0', 'com_languages', 'component', 'com_languages', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, '0', '0', NULL),
('11', '0', 'com_login', 'component', 'com_login', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, '0', '0', NULL),
('12', '0', 'com_media', 'component', 'com_media', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"restrict_uploads_extensions\":\"bmp,gif,jpg,jpeg,png,webp,avif,ico,mp3,m4a,mp4a,ogg,mp4,mp4v,mpeg,mov,odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png,jpeg,webp,avif\",\"audio_extensions\":\"mp3,m4a,mp4a,ogg\",\"video_extensions\":\"mp4,mp4v,mpeg,mov,webm\",\"doc_extensions\":\"odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,image\\/webp,image\\/avif,audio\\/ogg,audio\\/mpeg,audio\\/mp4,video\\/mp4,video\\/webm,video\\/mpeg,video\\/quicktime,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\"}', '', NULL, NULL, '0', '0', NULL),
('13', '0', 'com_menus', 'component', 'com_menus', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('14', '0', 'com_messages', 'component', 'com_messages', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('15', '0', 'com_modules', 'component', 'com_modules', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '', '', NULL, NULL, '0', '0', NULL),
('16', '0', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"sef_ids\":1}', '', NULL, NULL, '0', '0', NULL),
('17', '0', 'com_plugins', 'component', 'com_plugins', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '', '', NULL, NULL, '0', '0', NULL),
('18', '0', 'com_templates', 'component', 'com_templates', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png,webp\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass,json\",\"font_formats\":\"woff,woff2,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, '0', '0', NULL),
('19', '0', 'com_content', 'component', 'com_content', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"0\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":100,\"show_tags\":\"1\",\"record_hits\":\"1\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":0,\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_configure_edit_options\":\"1\",\"show_permissions\":\"1\",\"show_associations_edit\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":0,\"blog_class_leading\":\"\",\"num_intro_articles\":20,\"blog_class\":\"boxed\",\"num_columns\":4,\"multi_column_order\":\"0\",\"num_links\":0,\"show_subcategory_content\":\"0\",\"link_intro_image\":\"1\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"display_num\":\"10\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_ids\":1,\"custom_fields_enable\":\"1\",\"workflow_enabled\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('20', '0', 'com_config', 'component', 'com_config', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, '0', '0', NULL),
('21', '0', 'com_redirect', 'component', 'com_redirect', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '', '', NULL, NULL, '0', '0', NULL),
('22', '0', 'com_users', 'component', 'com_users', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"0\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"domains\":[],\"reset_count\":10,\"reset_time\":1,\"minimum_length\":12,\"minimum_integers\":1,\"minimum_symbols\":1,\"minimum_uppercase\":1,\"minimum_lowercase\":1,\"frontend_show_title\":\"1\",\"captive_template\":\"\",\"mfaonsilent\":\"0\",\"silentresponses\":\"cookie, passwordless\",\"mfaredirectonlogin\":\"0\",\"mfaredirecturl\":\"\",\"mfatrycount\":10,\"mfatrytime\":1,\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('23', '0', 'com_finder', 'component', 'com_finder', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('24', '0', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"customurl\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('25', '0', 'com_tags', 'component', 'com_tags', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_description\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('26', '0', 'com_contenthistory', 'component', 'com_contenthistory', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, '0', '0', NULL),
('27', '0', 'com_ajax', 'component', 'com_ajax', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, '0', '0', NULL),
('28', '0', 'com_postinstall', 'component', 'com_postinstall', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, '0', '0', NULL),
('29', '0', 'com_fields', 'component', 'com_fields', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL),
('30', '0', 'com_associations', 'component', 'com_associations', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, '0', '0', NULL),
('31', '0', 'com_privacy', 'component', 'com_privacy', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, '0', '0', NULL),
('32', '0', 'com_actionlogs', 'component', 'com_actionlogs', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_fields\",\"com_guidedtours\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_scheduler\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, '0', '0', NULL),
('33', '0', 'com_workflow', 'component', 'com_workflow', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('34', '0', 'com_mails', 'component', 'com_mails', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '', '', NULL, NULL, '0', '0', NULL),
('35', '0', 'com_scheduler', 'component', 'com_scheduler', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('36', '0', 'com_guidedtours', 'component', 'com_guidedtours', '', '', '1', '0', '0', '0', '1', '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('37', '0', 'lib_joomla', 'library', 'joomla', '', '', '0', '1', '1', '1', '1', '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '0', '0', NULL),
('38', '0', 'lib_phpass', 'library', 'phpass', '', '', '0', '1', '1', '1', '1', '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.5.1\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, '0', '0', NULL),
('39', '0', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, '0', '0', NULL),
('40', '0', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('41', '0', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, '0', '0', NULL),
('42', '0', 'mod_banners', 'module', 'mod_banners', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, '0', '0', NULL),
('43', '0', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, '0', '0', NULL),
('44', '0', 'mod_custom', 'module', 'mod_custom', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL),
('45', '0', 'mod_feed', 'module', 'mod_feed', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL),
('46', '0', 'mod_footer', 'module', 'mod_footer', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, '0', '0', NULL),
('47', '0', 'mod_login', 'module', 'mod_login', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL),
('48', '0', 'mod_menu', 'module', 'mod_menu', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL),
('49', '0', 'mod_articles_news', 'module', 'mod_articles_news', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, '0', '0', NULL),
('50', '0', 'mod_random_image', 'module', 'mod_random_image', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, '0', '0', NULL),
('51', '0', 'mod_related_items', 'module', 'mod_related_items', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, '0', '0', NULL),
('52', '0', 'mod_stats', 'module', 'mod_stats', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, '0', '0', NULL),
('53', '0', 'mod_syndicate', 'module', 'mod_syndicate', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, '0', '0', NULL),
('54', '0', 'mod_users_latest', 'module', 'mod_users_latest', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('55', '0', 'mod_whosonline', 'module', 'mod_whosonline', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, '0', '0', NULL),
('56', '0', 'mod_wrapper', 'module', 'mod_wrapper', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, '0', '0', NULL),
('57', '0', 'mod_articles_category', 'module', 'mod_articles_category', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, '0', '0', NULL),
('58', '0', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, '0', '0', NULL),
('59', '0', 'mod_languages', 'module', 'mod_languages', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, '0', '0', NULL),
('60', '0', 'mod_finder', 'module', 'mod_finder', '', '', '0', '1', '0', '0', '1', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, '0', '0', NULL),
('61', '0', 'MOD_ARTICLES', 'module', 'mod_articles', '', '', '0', '1', '0', '0', '1', '{\"name\":\"MOD_ARTICLES\",\"type\":\"module\",\"creationDate\":\"2024-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.2.0\",\"description\":\"MOD_ARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Articles\",\"filename\":\"mod_articles\"}', '', '', NULL, NULL, '0', '0', NULL),
('62', '0', 'mod_custom', 'module', 'mod_custom', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL),
('63', '0', 'mod_feed', 'module', 'mod_feed', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL),
('64', '0', 'mod_latest', 'module', 'mod_latest', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('65', '0', 'mod_logged', 'module', 'mod_logged', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, '0', '0', NULL),
('66', '0', 'mod_login', 'module', 'mod_login', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL),
('67', '0', 'mod_loginsupport', 'module', 'mod_loginsupport', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, '0', '0', NULL),
('68', '0', 'mod_menu', 'module', 'mod_menu', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL),
('69', '0', 'mod_popular', 'module', 'mod_popular', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, '0', '0', NULL),
('70', '0', 'mod_quickicon', 'module', 'mod_quickicon', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, '0', '0', NULL),
('71', '0', 'mod_frontend', 'module', 'mod_frontend', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Frontend\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, '0', '0', NULL),
('72', '0', 'mod_messages', 'module', 'mod_messages', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Messages\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('73', '0', 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PostInstallationMessages\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('74', '0', 'mod_user', 'module', 'mod_user', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\User\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, '0', '0', NULL),
('75', '0', 'mod_title', 'module', 'mod_title', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Title\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, '0', '0', NULL),
('76', '0', 'mod_toolbar', 'module', 'mod_toolbar', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Toolbar\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, '0', '0', NULL),
('77', '0', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\MultilangStatus\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('78', '0', 'mod_version', 'module', 'mod_version', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('79', '0', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL),
('80', '0', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('81', '0', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('82', '0', 'mod_sampledata', 'module', 'mod_sampledata', '', '', '1', '0', '1', '0', '1', '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('83', '0', 'mod_latestactions', 'module', 'mod_latestactions', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('84', '0', 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('85', '0', 'mod_submenu', 'module', 'mod_submenu', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('86', '0', 'mod_privacy_status', 'module', 'mod_privacy_status', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('87', '0', 'mod_guidedtours', 'module', 'mod_guidedtours', '', '', '1', '0', '1', '0', '1', '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('88', '0', 'plg_actionlog_joomla', 'plugin', 'joomla', '', 'actionlog', '0', '1', '1', '0', '1', '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('89', '0', 'plg_api-authentication_basic', 'plugin', 'basic', '', 'api-authentication', '0', '0', '1', '0', '1', '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('90', '0', 'plg_api-authentication_token', 'plugin', 'token', '', 'api-authentication', '0', '1', '1', '0', '1', '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('91', '0', 'plg_authentication_cookie', 'plugin', 'cookie', '', 'authentication', '0', '1', '1', '0', '1', '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '', '', NULL, NULL, '1', '0', NULL),
('92', '0', 'plg_authentication_joomla', 'plugin', 'joomla', '', 'authentication', '0', '1', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '2', '0', NULL),
('93', '0', 'plg_authentication_ldap', 'plugin', 'ldap', '', 'authentication', '0', '0', '1', '0', '1', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, '3', '0', NULL),
('94', '0', 'plg_behaviour_compat', 'plugin', 'compat', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_compat\",\"type\":\"plugin\",\"creationDate\":\"2023-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_COMPAT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat\",\"filename\":\"compat\"}', '{\"classes_aliases\":\"1\",\"es5_assets\":\"1\"}', '', NULL, NULL, '1', '0', NULL),
('95', '0', 'plg_behaviour_taggable', 'plugin', 'taggable', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('96', '0', 'plg_behaviour_versionable', 'plugin', 'versionable', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('97', '0', 'plg_content_confirmconsent', 'plugin', 'confirmconsent', '', 'content', '0', '0', '1', '0', '1', '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('98', '0', 'plg_content_contact', 'plugin', 'contact', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '2', '0', NULL),
('99', '0', 'plg_content_emailcloak', 'plugin', 'emailcloak', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, '3', '0', NULL),
('100', '0', 'plg_content_fields', 'plugin', 'fields', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '4', '0', NULL),
('101', '0', 'plg_content_finder', 'plugin', 'finder', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '5', '0', NULL),
('102', '0', 'plg_content_joomla', 'plugin', 'joomla', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '6', '0', NULL),
('103', '0', 'plg_content_loadmodule', 'plugin', 'loadmodule', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, NULL, '7', '0', NULL),
('104', '0', 'plg_content_pagebreak', 'plugin', 'pagebreak', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, '8', '0', NULL),
('105', '0', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, '9', '0', NULL),
('106', '0', 'plg_content_vote', 'plugin', 'vote', '', 'content', '0', '0', '1', '0', '1', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '', '', NULL, NULL, '10', '0', NULL),
('107', '0', 'plg_editors-xtd_article', 'plugin', 'article', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '', '', NULL, NULL, '1', '0', NULL),
('108', '0', 'plg_editors-xtd_contact', 'plugin', 'contact', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '2', '0', NULL),
('109', '0', 'plg_editors-xtd_fields', 'plugin', 'fields', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '3', '0', NULL),
('110', '0', 'plg_editors-xtd_image', 'plugin', 'image', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '', '', NULL, NULL, '4', '0', NULL),
('111', '0', 'plg_editors-xtd_menu', 'plugin', 'menu', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, '5', '0', NULL),
('112', '0', 'plg_editors-xtd_module', 'plugin', 'module', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, '6', '0', NULL),
('113', '0', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, '7', '0', NULL),
('114', '0', 'plg_editors-xtd_readmore', 'plugin', 'readmore', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '', '', NULL, NULL, '8', '0', NULL),
('115', '0', 'plg_editors_codemirror', 'plugin', 'codemirror', '', 'editors', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"6.0.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, '1', '0', NULL),
('116', '0', 'plg_editors_none', 'plugin', 'none', '', 'editors', '0', '1', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '', '', NULL, NULL, '2', '0', NULL),
('117', '0', 'plg_editors_tinymce', 'plugin', 'tinymce', '', 'editors', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"6.8.5\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"blocks\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styles\",\"|\",\"blocks\",\"fontfamily\",\"fontsize\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"jtemplate\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, '3', '0', NULL),
('118', '0', 'plg_extension_finder', 'plugin', 'finder', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '1', '0', NULL),
('119', '0', 'plg_extension_joomla', 'plugin', 'joomla', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '2', '0', NULL),
('120', '0', 'plg_extension_namespacemap', 'plugin', 'namespacemap', '', 'extension', '0', '1', '1', '1', '1', '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('121', '0', 'plg_fields_calendar', 'plugin', 'calendar', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, '1', '0', NULL),
('122', '0', 'plg_fields_checkboxes', 'plugin', 'checkboxes', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, '2', '0', NULL),
('123', '0', 'plg_fields_color', 'plugin', 'color', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, '3', '0', NULL),
('124', '0', 'plg_fields_editor', 'plugin', 'editor', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '{\"buttons\":0,\"width\":\"100%\",\"height\":\"250px\",\"filter\":\"\\\\Joomla\\\\CMS\\\\Component\\\\ComponentHelper::filterText\"}', '', NULL, NULL, '4', '0', NULL),
('125', '0', 'plg_fields_imagelist', 'plugin', 'imagelist', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, '5', '0', NULL),
('126', '0', 'plg_fields_integer', 'plugin', 'integer', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, '6', '0', NULL),
('127', '0', 'plg_fields_list', 'plugin', 'list', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, '7', '0', NULL),
('128', '0', 'plg_fields_media', 'plugin', 'media', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, '8', '0', NULL),
('129', '0', 'plg_fields_radio', 'plugin', 'radio', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, '9', '0', NULL),
('130', '0', 'plg_fields_sql', 'plugin', 'sql', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, '10', '0', NULL),
('131', '0', 'plg_fields_subform', 'plugin', 'subform', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, '11', '0', NULL),
('132', '0', 'plg_fields_text', 'plugin', 'text', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, '12', '0', NULL),
('133', '0', 'plg_fields_textarea', 'plugin', 'textarea', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '{\"rows\":10,\"cols\":10,\"maxlength\":\"\",\"filter\":\"\\\\Joomla\\\\CMS\\\\Component\\\\ComponentHelper::filterText\"}', '', NULL, NULL, '13', '0', NULL),
('134', '0', 'plg_fields_url', 'plugin', 'url', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, '14', '0', NULL),
('135', '0', 'plg_fields_user', 'plugin', 'user', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, '15', '0', NULL),
('136', '0', 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, '16', '0', NULL),
('137', '0', 'plg_filesystem_local', 'plugin', 'local', '', 'filesystem', '0', '1', '1', '0', '1', '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('138', '0', 'plg_finder_categories', 'plugin', 'categories', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '', '', NULL, NULL, '1', '0', NULL),
('139', '0', 'plg_finder_contacts', 'plugin', 'contacts', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '', '', NULL, NULL, '2', '0', NULL),
('140', '0', 'plg_finder_content', 'plugin', 'content', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '', '', NULL, NULL, '3', '0', NULL),
('141', '0', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, '4', '0', NULL),
('142', '0', 'plg_finder_tags', 'plugin', 'tags', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '', '', NULL, NULL, '5', '0', NULL),
('143', '0', 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, '2', '0', NULL),
('144', '0', 'plg_installer_override', 'plugin', 'override', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, '4', '0', NULL),
('145', '0', 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, '1', '0', NULL),
('146', '0', 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, '3', '0', NULL),
('147', '0', 'plg_installer_webinstaller', 'plugin', 'webinstaller', '', 'installer', '0', '0', '1', '0', '1', '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{\"tab_position\":\"1\"}', '', NULL, NULL, '5', '0', NULL),
('148', '0', 'plg_media-action_crop', 'plugin', 'crop', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('149', '0', 'plg_media-action_resize', 'plugin', 'resize', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('150', '0', 'plg_media-action_rotate', 'plugin', 'rotate', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('151', '0', 'plg_privacy_actionlogs', 'plugin', 'actionlogs', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('152', '0', 'plg_privacy_consents', 'plugin', 'consents', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('153', '0', 'plg_privacy_contact', 'plugin', 'contact', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('154', '0', 'plg_privacy_content', 'plugin', 'content', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('155', '0', 'plg_privacy_message', 'plugin', 'message', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('156', '0', 'plg_privacy_user', 'plugin', 'user', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('157', '0', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '1', '0', NULL),
('158', '0', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, '2', '0', NULL),
('159', '0', 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, '3', '0', NULL),
('160', '0', 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, '4', '0', NULL),
('161', '0', 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('162', '0', 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, '6', '0', NULL),
('163', '0', 'plg_quickicon_eos', 'plugin', 'eos', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '', '', NULL, NULL, '7', '0', NULL),
('164', '0', 'plg_sampledata_blog', 'plugin', 'blog', '', 'sampledata', '0', '0', '1', '0', '1', '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, '1', '0', NULL),
('165', '0', 'plg_sampledata_multilang', 'plugin', 'multilang', '', 'sampledata', '0', '0', '1', '0', '1', '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '', '', NULL, NULL, '2', '0', NULL),
('166', '0', 'plg_schemaorg_article', 'plugin', 'article', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_article\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('167', '0', 'plg_schemaorg_blogposting', 'plugin', 'blogposting', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_blogposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BLOGPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\BlogPosting\",\"filename\":\"blogposting\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('168', '0', 'plg_schemaorg_book', 'plugin', 'book', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_book\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BOOK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Book\",\"filename\":\"book\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('169', '0', 'plg_schemaorg_event', 'plugin', 'event', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_event\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_EVENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Event\",\"filename\":\"event\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('170', '0', 'plg_schemaorg_jobposting', 'plugin', 'jobposting', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_jobposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_JOBPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\JobPosting\",\"filename\":\"jobposting\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('171', '0', 'plg_schemaorg_organization', 'plugin', 'organization', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_organization\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_ORGANIZATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Organization\",\"filename\":\"organization\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('172', '0', 'plg_schemaorg_person', 'plugin', 'person', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_person\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_PERSON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Person\",\"filename\":\"person\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('173', '0', 'plg_schemaorg_recipe', 'plugin', 'recipe', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_recipe\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_RECIPE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Recipe\",\"filename\":\"recipe\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('174', '0', 'plg_schemaorg_custom', 'plugin', 'custom', '', 'schemaorg', '0', '1', '1', '0', '0', '{\"name\":\"plg_schemaorg_custom\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Custom\",\"filename\":\"custom\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('175', '0', 'plg_system_accessibility', 'plugin', 'accessibility', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, '10', '0', NULL),
('176', '0', 'plg_system_actionlogs', 'plugin', 'actionlogs', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '11', '0', NULL),
('177', '0', 'plg_system_cache', 'plugin', 'cache', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, '12', '0', NULL),
('178', '0', 'plg_system_debug', 'plugin', 'debug', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, '13', '0', NULL),
('179', '0', 'plg_system_fields', 'plugin', 'fields', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '14', '0', NULL),
('180', '0', 'plg_system_highlight', 'plugin', 'highlight', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '', '', NULL, NULL, '15', '0', NULL),
('181', '0', 'plg_system_httpheaders', 'plugin', 'httpheaders', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, '16', '0', NULL),
('182', '0', 'plg_system_jooa11y', 'plugin', 'jooa11y', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, '17', '0', NULL),
('183', '0', 'plg_system_languagecode', 'plugin', 'languagecode', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, '18', '0', NULL),
('184', '0', 'plg_system_languagefilter', 'plugin', 'languagefilter', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, '19', '0', NULL),
('185', '0', 'plg_system_log', 'plugin', 'log', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '', '', NULL, NULL, '20', '0', NULL),
('186', '0', 'plg_system_logout', 'plugin', 'logout', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '', '', NULL, NULL, '21', '0', NULL),
('187', '0', 'plg_system_privacyconsent', 'plugin', 'privacyconsent', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '22', '0', NULL),
('188', '0', 'plg_system_redirect', 'plugin', 'redirect', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '', '', NULL, NULL, '23', '0', NULL),
('189', '0', 'plg_system_remember', 'plugin', 'remember', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '', '', NULL, NULL, '25', '0', NULL),
('190', '0', 'plg_system_schedulerunner', 'plugin', 'schedulerunner', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, '26', '0', NULL),
('191', '0', 'plg_system_schemaorg', 'plugin', 'schemaorg', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_schemaorg\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SYSTEM_SCHEMAORG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Schemaorg\",\"filename\":\"schemaorg\"}', '{}', '', NULL, NULL, '27', '0', NULL),
('192', '0', 'plg_system_sef', 'plugin', 'sef', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '{\"domain\":\"\",\"indexphp\":\"1\",\"trailingslash\":\"0\",\"enforcesuffix\":\"1\",\"strictrouting\":\"1\"}', '', NULL, NULL, '28', '0', NULL),
('193', '0', 'plg_system_shortcut', 'plugin', 'shortcut', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '{}', '', NULL, NULL, '29', '0', NULL),
('194', '0', 'plg_system_skipto', 'plugin', 'skipto', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, '30', '0', NULL),
('195', '0', 'plg_system_stats', 'plugin', 'stats', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"06761a0f517f1080322f8f49555373f04c0c1501\",\"interval\":12}', '', NULL, NULL, '31', '0', NULL),
('196', '0', 'plg_system_task_notification', 'plugin', 'tasknotification', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, '32', '0', NULL),
('197', '0', 'plg_system_webauthn', 'plugin', 'webauthn', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, '33', '0', NULL),
('198', '0', 'plg_task_check_files', 'plugin', 'checkfiles', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('199', '0', 'plg_task_deleteactionlogs', 'plugin', 'deleteactionlogs', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_deleteactionlogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_DELETEACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DeleteActionLogs\",\"filename\":\"deleteactionlogs\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('200', '0', 'plg_task_globalcheckin', 'plugin', 'globalcheckin', '', 'task', '0', '1', '1', '0', '0', '{\"name\":\"plg_task_globalcheckin\",\"type\":\"plugin\",\"creationDate\":\"2023-06-22\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_GLOBALCHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Globalcheckin\",\"filename\":\"globalcheckin\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('201', '0', 'plg_task_requests', 'plugin', 'requests', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('202', '0', 'plg_task_privacyconsent', 'plugin', 'privacyconsent', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('203', '0', 'plg_task_rotatelogs', 'plugin', 'rotatelogs', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_rotatelogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_ROTATELOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\RotateLogs\",\"filename\":\"rotatelogs\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('204', '0', 'plg_task_sessiongc', 'plugin', 'sessiongc', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2023-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SessionGC\",\"filename\":\"sessiongc\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('205', '0', 'plg_task_site_status', 'plugin', 'sitestatus', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('206', '0', 'plg_task_updatenotification', 'plugin', 'updatenotification', '', 'task', '0', '0', '1', '0', '1', '{\"name\":\"plg_task_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('207', '0', 'plg_multifactorauth_totp', 'plugin', 'totp', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, '1', '0', NULL),
('208', '0', 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, '2', '0', NULL),
('209', '0', 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, '3', '0', NULL),
('210', '0', 'plg_multifactorauth_email', 'plugin', 'email', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, '4', '0', NULL),
('211', '0', 'plg_multifactorauth_fixed', 'plugin', 'fixed', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, '5', '0', NULL),
('212', '0', 'plg_user_contactcreator', 'plugin', 'contactcreator', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"4\",\"autopublish\":\"0\"}', '', NULL, NULL, '1', '0', NULL),
('213', '0', 'plg_user_joomla', 'plugin', 'joomla', '', 'user', '0', '1', '1', '0', '1', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, '2', '0', NULL),
('214', '0', 'plg_user_profile', 'plugin', 'profile', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, '3', '0', NULL),
('215', '0', 'plg_user_terms', 'plugin', 'terms', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('216', '0', 'plg_user_token', 'plugin', 'token', '', 'user', '0', '1', '1', '0', '1', '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('217', '0', 'plg_webservices_banners', 'plugin', 'banners', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('218', '0', 'plg_webservices_config', 'plugin', 'config', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('219', '0', 'plg_webservices_contact', 'plugin', 'contact', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('220', '0', 'plg_webservices_content', 'plugin', 'content', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('221', '0', 'plg_webservices_installer', 'plugin', 'installer', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('222', '0', 'plg_webservices_languages', 'plugin', 'languages', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('223', '0', 'plg_webservices_media', 'plugin', 'media', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('224', '0', 'plg_webservices_menus', 'plugin', 'menus', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('225', '0', 'plg_webservices_messages', 'plugin', 'messages', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('226', '0', 'plg_webservices_modules', 'plugin', 'modules', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('227', '0', 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, '10', '0', NULL),
('228', '0', 'plg_webservices_plugins', 'plugin', 'plugins', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, '11', '0', NULL),
('229', '0', 'plg_webservices_privacy', 'plugin', 'privacy', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, '12', '0', NULL),
('230', '0', 'plg_webservices_redirect', 'plugin', 'redirect', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, '13', '0', NULL),
('231', '0', 'plg_webservices_tags', 'plugin', 'tags', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '14', '0', NULL),
('232', '0', 'plg_webservices_templates', 'plugin', 'templates', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, '15', '0', NULL),
('233', '0', 'plg_webservices_users', 'plugin', 'users', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, '16', '0', NULL),
('234', '0', 'plg_workflow_featuring', 'plugin', 'featuring', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('235', '0', 'plg_workflow_notification', 'plugin', 'notification', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('236', '0', 'plg_workflow_publishing', 'plugin', 'publishing', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('237', '0', 'plg_system_guidedtours', 'plugin', 'guidedtours', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, '24', '0', NULL),
('238', '0', 'atum', 'template', 'atum', '', '', '1', '1', '1', '0', '1', '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '', '', NULL, NULL, '0', '0', NULL),
('239', '0', 'cassiopeia', 'template', 'cassiopeia', '', '', '0', '1', '1', '0', '1', '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":0,\"backTop\":0}', '', NULL, NULL, '0', '0', NULL),
('240', '0', 'files_joomla', 'file', 'joomla', '', '', '0', '1', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2025-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.2\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('241', '0', 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '', '0', '1', '1', '1', '1', '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2025-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.2.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, '0', '0', NULL),
('242', '241', 'English (en-GB)', 'language', 'en-GB', '', '', '0', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.2\",\"description\":\"en-GB site language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('243', '241', 'English (en-GB)', 'language', 'en-GB', '', '', '1', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.2\",\"description\":\"en-GB administrator language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('244', '241', 'English (en-GB)', 'language', 'en-GB', '', '', '3', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.2\",\"description\":\"en-GB api language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('246', '0', 'com_templateck', 'component', 'com_templateck', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_templateck\",\"type\":\"component\",\"creationDate\":\"April 2013\",\"author\":\"Cedric Keiflin\",\"copyright\":\"Copyright (C) 2013. All rights reserved.\",\"authorEmail\":\"ced1870@gmail.com\",\"authorUrl\":\"https:\\/\\/www.template-creator.com\",\"version\":\"5.5.9\",\"description\":\"CK_TEMPLATECK\",\"group\":\"\",\"changelogurl\":\"\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('247', '0', 'Scroll To CK', 'plugin', 'scrolltock', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"Scroll To CK\",\"type\":\"plugin\",\"creationDate\":\"D\\u00e9cembre 2014\",\"author\":\"C\\u00e9dric KEIFLIN\",\"copyright\":\"C\\u00e9dric KEIFLIN\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/www.joomlack.fr\",\"version\":\"1.4.1\",\"description\":\"PLG_SCROLLTOCK_XML_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"scrolltock\"}', '{\"fxduration\":\"1000\",\"offsety\":\"0\",\"keephash\":\"0\",\"mobile_resolution\":\"\",\"mobile_offsety\":\"\",\"activatetotop\":\"1\",\"totop_startoffset\":\"100\",\"totop_showtext\":\"0\",\"totop_hideresolution\":\"\",\"totop_width\":\"50\",\"totop_height\":\"50\",\"totop_backgroundcolor\":\"rgba(255, 255, 255, 1)\",\"totop_backgroundimage\":\"\",\"totop_opacity\":\"1\",\"totop_bordercolor\":\"rgba(169, 169, 169, 1)\",\"totop_borderwidth\":\"2px\",\"totop_borderradius\":\"0\",\"totop_shadowcolor\":\"\",\"totop_shadowwidth\":\"\",\"totop_color\":\"\",\"totop_hovercolor\":\"\",\"totop_fontsize\":\"\",\"totop_fontfamily\":\"\",\"totop_padding\":\"\",\"totop_margin\":\"auto 5px 90px auto\"}', '', NULL, NULL, '6', '0', ''),
('248', '250', 'com_akeebabackup', 'component', 'com_akeebabackup', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_akeebabackup\",\"type\":\"component\",\"creationDate\":\"2025-07-21\",\"author\":\"Akeeba Ltd\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"no-reply@akeeba.com\",\"authorUrl\":\"www.akeeba.com\",\"version\":\"10.0.5\",\"description\":\"COM_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Component\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"frontend_secret_word\":\"###AES128###oZNKz8qLWD5YdvpLeDsIeEpQU1SHJsUDUG8BRgwq6Iet4QAtjyPWG31yiFfockmXUjFTN7olTAPdtZBk76ztDmIVf3DbDtxBDlEM3Kci6zgB71YqSlBJVvPpSgeP3gDHlk59rG3rqRoAAAAA\",\"no_flush\":0,\"confwiz_upgrade\":1,\"siteurl\":\"https:\\/\\/demo.tscmedia.co.za\\/base\\/\",\"jlibrariesdir\":\"\\/home\\/tscdemo\\/public_html\\/base\\/libraries\",\"show_howtorestoremodal\":0}', '', NULL, NULL, '0', '0', NULL),
('249', '250', 'PLG_QUICKICON_AKEEBABACKUP', 'plugin', 'akeebabackup', '', 'quickicon', '0', '1', '1', '0', '0', '{\"name\":\"PLG_QUICKICON_AKEEBABACKUP\",\"type\":\"plugin\",\"creationDate\":\"2025-07-21\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeeba.com\",\"version\":\"10.0.5\",\"description\":\"PLG_QUICKICON_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Plugin\\\\QuickIcon\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"enablewarning\":\"1\",\"warnfailed\":\"1\",\"maxbackupperiod\":\"24\",\"profileid\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('250', '0', 'pkg_akeebabackup', 'package', 'pkg_akeebabackup', '', '', '0', '1', '1', '0', '0', '{\"name\":\"pkg_akeebabackup\",\"type\":\"package\",\"creationDate\":\"2025-07-21\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"10.0.5\",\"description\":\"PKG_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_akeebabackup\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('251', '260', 'COM_JCE', 'component', 'com_jce', '', '', '1', '1', '0', '0', '0', '{\"name\":\"COM_JCE\",\"type\":\"component\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"COM_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{\"custom_help\":\"0\",\"help_url\":\"\",\"help_method\":\"reference\",\"help_pattern\":\"tanya\",\"feed\":\"0\",\"feed_limit\":\"2\",\"inline_help\":\"1\",\"updates_key\":\"WF414F058A82C7E9F089AFF63D3879E5A2\",\"replace_media_manager\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('253', '260', 'plg_editors_jce', 'plugin', 'jce', '', 'editors', '0', '1', '1', '0', '0', '{\"name\":\"plg_editors_jce\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"WF_EDITOR_PLUGIN_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\Jce\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('254', '260', 'plg_extension_jce', 'plugin', 'jce', '', 'extension', '0', '1', '1', '0', '0', '{\"name\":\"plg_extension_jce\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"PLG_EXTENSION_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('255', '260', 'plg_installer_jce', 'plugin', 'jce', '', 'installer', '0', '1', '1', '0', '0', '{\"name\":\"plg_installer_jce\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"PLG_INSTALLER_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Jce\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('256', '260', 'plg_quickicon_jce', 'plugin', 'jce', '', 'quickicon', '0', '1', '1', '0', '0', '{\"name\":\"plg_quickicon_jce\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"PLG_QUICKICON_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('257', '260', 'plg_system_jce', 'plugin', 'jce', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_jce\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"PLG_SYSTEM_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{\"column_styles\":\"1\"}', '', NULL, NULL, '7', '0', NULL),
('258', '260', 'plg_fields_mediajce', 'plugin', 'mediajce', '', 'fields', '0', '1', '1', '0', '0', '{\"name\":\"plg_fields_mediajce\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"https:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"PLG_FIELDS_MEDIAJCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\MediaJce\",\"filename\":\"mediajce\"}', '{\"legacymedia\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('259', '260', 'plg_system_jcepro', 'plugin', 'jcepro', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_jcepro\",\"type\":\"plugin\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"https:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.89\",\"description\":\"PLG_SYSTEM_JCEPRO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\JcePro\",\"filename\":\"jcepro\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('260', '0', 'PKG_JCE', 'package', 'pkg_jce', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_JCE\",\"type\":\"package\",\"creationDate\":\"16-07-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.9.89\",\"description\":\"PKG_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('261', '0', 'plg_system_jcemediabox', 'plugin', 'jcemediabox', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_jcemediabox\",\"type\":\"plugin\",\"creationDate\":\"23-09-2024\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2024 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"www.joomlacontenteditor.net\",\"version\":\"2.2.1\",\"description\":\"PLG_SYSTEM_JCEMEDIABOX_XML_DESC\",\"group\":\"\",\"filename\":\"jcemediabox\"}', '{\"theme\":\"standard\",\"transitionspeed\":\"500\",\"overlay\":\"1\",\"overlayopacity\":\"\",\"overlaycolor\":\"\",\"width\":\"\",\"height\":\"\",\"close\":\"2\",\"swipe\":\"1\",\"icons\":\"0\",\"dynamic_themes\":\"0\",\"expand_on_click\":\"1\",\"lightbox\":\"0\",\"shadowbox\":\"0\"}', '', NULL, NULL, '8', '0', ''),
('263', '264', 'PLG_SYSTEM_REGULARLABS', 'plugin', 'regularlabs', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_REGULARLABS\",\"type\":\"plugin\",\"creationDate\":\"June 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"25.6.10828\",\"description\":\"PLG_SYSTEM_REGULARLABS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\System\\\\RegularLabs\",\"filename\":\"regularlabs\"}', '{\"combine_admin_menu\":\"0\",\"max_list_count\":\"10000\"}', '', NULL, NULL, '4', '0', NULL),
('264', '0', 'PKG_REGULARLABS', 'package', 'pkg_regularlabs', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_REGULARLABS\",\"type\":\"package\",\"creationDate\":\"June 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"25.6.10828\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_regularlabs\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('265', '267', 'PLG_SYSTEM_SOURCERER', 'plugin', 'sourcerer', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_SOURCERER\",\"type\":\"plugin\",\"creationDate\":\"June 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"12.1.0\",\"description\":\"PLG_SYSTEM_SOURCERER_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\System\\\\Sourcerer\",\"filename\":\"sourcerer\"}', '{\"enable_css\":\"1\",\"enable_js\":\"1\",\"enable_php\":\"1\",\"forbidden_php\":\"dl, escapeshellarg, escapeshellcmd, exec, passthru, popen, proc_close, proc_open, shell_exec, symlink, system\",\"forbidden_tags\":\"\",\"@wizard\":\"0\",\"button_text\":\"Code\",\"enable_frontend\":\"1\",\"color_code\":\"1\",\"syntax_word\":\"source\",\"tag_characters\":\"{.}\",\"trim\":\"0\",\"enable_in_head\":\"0\",\"remove_from_search\":\"0\",\"include_path\":\"\\/\",\"tmp_path\":\"\",\"place_comments\":\"1\"}', '', NULL, NULL, '5', '0', NULL),
('266', '267', 'PLG_EDITORS-XTD_SOURCERER', 'plugin', 'sourcerer', '', 'editors-xtd', '0', '1', '1', '0', '0', '{\"name\":\"PLG_EDITORS-XTD_SOURCERER\",\"type\":\"plugin\",\"creationDate\":\"June 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"12.1.0\",\"description\":\"PLG_EDITORS-XTD_SOURCERER_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\EditorButton\\\\Sourcerer\",\"filename\":\"sourcerer\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('267', '0', 'PKG_SOURCERER', 'package', 'pkg_sourcerer', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_SOURCERER\",\"type\":\"package\",\"creationDate\":\"June 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"12.1.0\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_sourcerer\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('268', '0', 'com_rsform', 'component', 'com_rsform', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_rsform\",\"type\":\"component\",\"creationDate\":\"February 2025\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2025 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"3.4.0\",\"description\":\"COM_RSFORM_INSTALL_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('269', '0', 'plg_installer_rsform', 'plugin', 'rsform', '', 'installer', '0', '1', '1', '0', '0', '{\"name\":\"plg_installer_rsform\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"RSJoomla!\",\"copyright\":\"(c) 2015 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"https:\\/\\/www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_INSTALLER_RSFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('270', '0', 'System - RSForm! Pro Delete Submissions', 'plugin', 'rsformdeletesubmissions', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"System - RSForm! Pro Delete Submissions\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2019 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_SYSTEM_RSFORMDELETESUBMISSIONS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsformdeletesubmissions\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('271', '0', 'Page Cache - RSForm! Pro', 'plugin', 'rsform', '', 'pagecache', '0', '1', '1', '0', '0', '{\"name\":\"Page Cache - RSForm! Pro\",\"type\":\"plugin\",\"creationDate\":\"September 2023\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2023 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_PAGECACHE_RSFORM_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('272', '0', 'PLG_SYSTEM_RSFORMCONSOLE', 'plugin', 'rsformconsole', '', 'system', '0', '0', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_RSFORMCONSOLE\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"RSJoomla!\",\"copyright\":\"(c) 2015 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"https:\\/\\/www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_SYSTEM_RSFORMCONSOLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Rsjoomla\\\\Plugin\\\\System\\\\Rsformconsole\",\"filename\":\"rsformconsole\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('273', '0', 'Content - RSForm! Pro', 'plugin', 'rsform', '', 'content', '0', '0', '1', '0', '0', '{\"name\":\"Content - RSForm! Pro\",\"type\":\"plugin\",\"creationDate\":\"June 2015\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2017 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"3.0.1\",\"description\":\"PLG_CONTENT_RSFORM_DESC\",\"group\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('275', '0', 'COM_OSMAP', 'component', 'com_osmap', '', '', '1', '1', '0', '0', '0', '{\"name\":\"COM_OSMAP\",\"type\":\"component\",\"creationDate\":\"August 11 2025\",\"author\":\"Joomlashack\",\"copyright\":\"2016-2025 Joomlashack. All rights reserved.\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\\/\",\"version\":\"5.0.20\",\"description\":\"COM_OSMAP_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"osmap\"}', '{}', '{\"author\":\"Joomlashack\"}', NULL, NULL, '0', '0', NULL),
('277', '0', 'plg_system_osmylicensesmanager', 'plugin', 'osmylicensesmanager', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_osmylicensesmanager\",\"type\":\"plugin\",\"creationDate\":\"March 18 2024\",\"author\":\"Joomlashack\",\"copyright\":\"Copyright 2016-2024 Joomlashack. All rights reserved\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\",\"version\":\"2.0.17\",\"description\":\"PLG_SYSTEM_OSMYLICENSESMANAGER_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"osmylicensesmanager\"}', '[]', '{\"author\":\"Joomlashack\"}', NULL, NULL, '34', '0', NULL),
('278', '0', 'PLG_OSMAP_JOOMLA', 'plugin', 'joomla', '', 'osmap', '0', '1', '1', '0', '0', '{\"name\":\"PLG_OSMAP_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"August 11 2025\",\"author\":\"Joomlashack\",\"copyright\":\"2016-2025 Joomlashack. All rights reserved.\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\\/\",\"version\":\"5.0.20\",\"description\":\"PLG_OSMAP_JOOMLA_PLUGIN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '{\"expand_categories\":\"1\",\"expand_featured\":\"1\",\"max_category_level\":\"all\",\"include_archived\":\"2\",\"show_unauth\":\"0\",\"add_pagebreaks\":\"1\",\"max_art\":\"0\",\"article_order\":\"0\",\"article_orderdir\":\"0\",\"prepare_content\":\"1\",\"add_images\":\"1\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"-1\",\"art_priority\":\"-1\",\"art_changefreq\":\"-1\",\"keywords\":\"metakey\"}', '', NULL, NULL, '0', '0', NULL),
('285', '0', 'plg_extension_joomlaupdate', 'plugin', 'joomlaupdate', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"PLG_EXTENSION_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '0', '0', NULL),
('290', '264', 'Regular Labs Library', 'library', 'regularlabs', '', '', '0', '1', '1', '0', '0', '{\"name\":\"Regular Labs Library\",\"type\":\"library\",\"creationDate\":\"June 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"25.6.10828\",\"description\":\"Regular Labs Library - used by Regular Labs extensions\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Library\",\"filename\":\"regularlabs\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('291', '0', 'plg_captcha_hcaptcha', 'plugin', 'hcaptcha', '', 'captcha', '0', '1', '1', '0', '0', '{\"name\":\"plg_captcha_hcaptcha\",\"type\":\"plugin\",\"creationDate\":\"January 2024\",\"author\":\"data2site\",\"copyright\":\"Copyright (C) 2021-2024 by data2site.com. All rights reserved.\",\"authorEmail\":\"support@data2site.com\",\"authorUrl\":\"https:\\/\\/data2site.com\",\"version\":\"1.4.3\",\"description\":\"PLG_CAPTCHA_HCAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"hcaptcha\"}', '{\"publicKey\":\"b5f60c1a-849a-46f8-86d4-3f1e23641696\",\"privateKey\":\"ES_dba68a47630e4a31a3164ff681bd6324\",\"theme\":\"light\",\"size\":\"normal\"}', '', NULL, NULL, '0', '0', ''),
('292', '0', 'System - RSForm! Pro hCaptcha', 'plugin', 'rsfphcaptcha', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"System - RSForm! Pro hCaptcha\",\"type\":\"plugin\",\"creationDate\":\"April 2020\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2020-2022 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"3.1.3\",\"description\":\"PLG_SYSTEM_RSFPHCAPTCHA_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsfphcaptcha\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('293', '0', 'Joomlashack Framework', 'library', 'allediaframework', '', '', '0', '1', '1', '0', '0', '{\"name\":\"Joomlashack Framework\",\"type\":\"library\",\"creationDate\":\"January 14 2025\",\"author\":\"Joomlashack\",\"copyright\":\"Copyright 2016-2023 Joomlashack.com\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\\/\",\"version\":\"3.7.4\",\"description\":\"Shared library for Joomlashack extensions\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"allediaframework\"}', '{}', '{\"author\":\"Joomlashack\"}', NULL, NULL, '0', '0', NULL);/**ABDB**/
/**ABDB**/CREATE TABLE `#__fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `required` tinyint NOT NULL DEFAULT '0',
  `only_use_in_subform` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_categories` (
  `field_id` int NOT NULL DEFAULT '0',
  `category_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_values` (
  `field_id` int unsigned NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` mediumtext COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_filters` (
  `filter_id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `map_count` int unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_links` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '1',
  `state` int NOT NULL DEFAULT '1',
  `access` int NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int NOT NULL,
  `object` mediumblob,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_language` (`language`),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_links`  VALUES 
('1', 'index.php?option=com_content&view=category&id=2', 'index.php?option=com_content&view=category&id=2', 'General', '', '2025-01-29 07:27:22', '1f98a63896086e839d243bc120ba1aea', '1', '1', '1', '*', NULL, NULL, '2024-10-22 11:45:17', NULL, '0', '0', '1', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:17:{s:2:\"id\";i:2;s:5:\"alias\";s:16:\"general category\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":2:{s:6:\"author\";s:0:\"\";s:6:\"robots\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:3:\"lft\";i:1;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:15:\"category_layout\";s:0:\"\";s:5:\"image\";s:0:\"\";s:9:\"image_alt\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:15;s:8:\"modified\";s:19:\"2025-01-29 07:27:22\";s:11:\"modified_by\";i:15;s:4:\"slug\";s:18:\"2:general-category\";s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_content&view=category&id=2\";i:12;N;i:13;s:19:\"2024-10-22 11:45:17\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:7:\"General\";i:17;i:1;i:18;s:47:\"index.php?option=com_content&view=category&id=2\";}'),
('2', 'index.php?option=com_content&view=article&id=1', 'index.php?option=com_content&view=article&id=1:home-info&catid=2', 'Home', ' Lorem Ipsum ', '2024-10-22 12:35:13', '8ff4bdc9ba466ccf13b521419f9b7131', '1', '1', '1', '*', '2024-10-22 12:35:13', NULL, '2024-10-22 12:35:13', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:13:\" Lorem Ipsum \";i:3;a:25:{s:2:\"id\";i:1;s:5:\"alias\";s:9:\"home info\";s:7:\"summary\";s:18:\"<p>Lorem Ipsum</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:15;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2024-10-22 12:35:13\";s:11:\"modified_by\";i:15;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:7:\"General\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:11:\"1:home-info\";s:7:\"catslug\";s:9:\"2:general\";s:6:\"author\";s:15:\"Tanya TSC Media\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2024-10-22 12:35:13\";i:10;N;i:11;s:64:\"index.php?option=com_content&view=article&id=1:home-info&catid=2\";i:12;N;i:13;s:19:\"2024-10-22 12:35:13\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:6;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:15:\"Tanya TSC Media\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:8;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"General\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:10;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:4:\"Home\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=1\";}'),
('3', 'index.php?option=com_content&view=article&id=2', 'index.php?option=com_content&view=article&id=2:404&catid=2', 'Page Not Found', ' Oops! The page you\'re looking for can\'t be found. Please navigate back to our home page. ', '2025-02-02 09:19:12', '318c73d16b7abb0f51d146d1b6675ace', '1', '1', '1', '*', '2025-02-02 09:19:12', NULL, '2025-02-02 09:19:12', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:90:\" Oops! The page you\'re looking for can\'t be found. Please navigate back to our home page. \";i:3;a:25:{s:2:\"id\";i:2;s:5:\"alias\";s:3:\"404\";s:7:\"summary\";s:181:\"<p>Oops! The page you\'re looking for can\'t be found.</p>\r\n<p>&nbsp;</p>\r\n<p>Please navigate back to our <a href=\"index.php?Itemid=101\" target=\"_self\" title=\"Home\">home page</a>.</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:15;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2025-02-02 09:19:12\";s:11:\"modified_by\";i:15;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"0\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"0\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:17:\"noindex, nofollow\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:7:\"General\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:5:\"2:404\";s:7:\"catslug\";s:18:\"2:general-category\";s:6:\"author\";s:15:\"Tanya TSC Media\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2025-02-02 09:19:12\";i:10;N;i:11;s:58:\"index.php?option=com_content&view=article&id=2:404&catid=2\";i:12;N;i:13;s:19:\"2025-02-02 09:19:12\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:6;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:15:\"Tanya TSC Media\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:8;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"General\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:10;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}}i:16;s:14:\"Page Not Found\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=2\";}');
/**ABDB**/CREATE TABLE `#__finder_links_terms` (
  `link_id` int unsigned NOT NULL,
  `term_id` int unsigned NOT NULL,
  `weight` float unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_logging` (
  `searchterm` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `query` blob NOT NULL,
  `hits` int NOT NULL DEFAULT '1',
  `results` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`md5sum`),
  KEY `searchterm` (`searchterm`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_taxonomy` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint unsigned NOT NULL DEFAULT '1',
  `access` tinyint unsigned NOT NULL DEFAULT '1',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_access` (`access`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_level` (`level`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_taxonomy`  VALUES 
('1', '0', '0', '19', '0', '', 'ROOT', 'root', '1', '1', '*'),
('2', '1', '1', '6', '1', 'type', 'Type', 'type', '1', '1', '*'),
('3', '2', '2', '3', '2', 'type/category', 'Category', 'category', '1', '1', '*'),
('4', '1', '7', '10', '1', 'language', 'Language', 'language', '1', '1', '*'),
('5', '4', '8', '9', '2', 'language/4086f6336014c75439f87cbda42d9c51', '*', '4086f6336014c75439f87cbda42d9c51', '1', '1', '*'),
('6', '2', '4', '5', '2', 'type/article', 'Article', 'article', '1', '1', '*'),
('7', '1', '11', '14', '1', 'author', 'Author', 'author', '1', '1', '*'),
('8', '7', '12', '13', '2', 'author/tanya-tsc-media', 'Tanya TSC Media', 'tanya-tsc-media', '1', '1', '*'),
('9', '1', '15', '18', '1', 'category', 'Category', 'category', '1', '1', '*'),
('10', '9', '16', '17', '2', 'category/general', 'General', 'general', '1', '1', '*');
/**ABDB**/CREATE TABLE `#__finder_taxonomy_map` (
  `link_id` int unsigned NOT NULL,
  `node_id` int unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_taxonomy_map`  VALUES 
('1', '3'),
('1', '5'),
('2', '5'),
('2', '6'),
('2', '8'),
('2', '10'),
('3', '5'),
('3', '6'),
('3', '8'),
('3', '10');
/**ABDB**/CREATE TABLE `#__finder_terms` (
  `term_id` int unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `links` int NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_stem` (`stem`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_terms_common` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `custom` int NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_terms_common`  VALUES 
('a', 'en', '0'),
('about', 'en', '0'),
('above', 'en', '0'),
('after', 'en', '0'),
('again', 'en', '0'),
('against', 'en', '0'),
('all', 'en', '0'),
('am', 'en', '0'),
('an', 'en', '0'),
('and', 'en', '0'),
('any', 'en', '0'),
('are', 'en', '0'),
('aren\'t', 'en', '0'),
('as', 'en', '0'),
('at', 'en', '0'),
('be', 'en', '0'),
('because', 'en', '0'),
('been', 'en', '0'),
('before', 'en', '0'),
('being', 'en', '0'),
('below', 'en', '0'),
('between', 'en', '0'),
('both', 'en', '0'),
('but', 'en', '0'),
('by', 'en', '0'),
('can\'t', 'en', '0'),
('cannot', 'en', '0'),
('could', 'en', '0'),
('couldn\'t', 'en', '0'),
('did', 'en', '0'),
('didn\'t', 'en', '0'),
('do', 'en', '0'),
('does', 'en', '0'),
('doesn\'t', 'en', '0'),
('doing', 'en', '0'),
('don\'t', 'en', '0'),
('down', 'en', '0'),
('during', 'en', '0'),
('each', 'en', '0'),
('few', 'en', '0'),
('for', 'en', '0'),
('from', 'en', '0'),
('further', 'en', '0'),
('had', 'en', '0'),
('hadn\'t', 'en', '0'),
('has', 'en', '0'),
('hasn\'t', 'en', '0'),
('have', 'en', '0'),
('haven\'t', 'en', '0'),
('having', 'en', '0'),
('he', 'en', '0'),
('he\'d', 'en', '0'),
('he\'ll', 'en', '0'),
('he\'s', 'en', '0'),
('her', 'en', '0'),
('here', 'en', '0'),
('here\'s', 'en', '0'),
('hers', 'en', '0'),
('herself', 'en', '0'),
('him', 'en', '0'),
('himself', 'en', '0'),
('his', 'en', '0'),
('how', 'en', '0'),
('how\'s', 'en', '0'),
('i', 'en', '0'),
('i\'d', 'en', '0'),
('i\'ll', 'en', '0'),
('i\'m', 'en', '0'),
('i\'ve', 'en', '0'),
('if', 'en', '0'),
('in', 'en', '0'),
('into', 'en', '0'),
('is', 'en', '0'),
('isn\'t', 'en', '0'),
('it', 'en', '0'),
('it\'s', 'en', '0'),
('its', 'en', '0'),
('itself', 'en', '0'),
('let\'s', 'en', '0'),
('me', 'en', '0'),
('more', 'en', '0'),
('most', 'en', '0'),
('mustn\'t', 'en', '0'),
('my', 'en', '0'),
('myself', 'en', '0'),
('no', 'en', '0'),
('nor', 'en', '0'),
('not', 'en', '0'),
('of', 'en', '0'),
('off', 'en', '0'),
('on', 'en', '0'),
('once', 'en', '0'),
('only', 'en', '0'),
('or', 'en', '0'),
('other', 'en', '0'),
('ought', 'en', '0'),
('our', 'en', '0'),
('ours', 'en', '0'),
('ourselves', 'en', '0'),
('out', 'en', '0'),
('over', 'en', '0'),
('own', 'en', '0'),
('same', 'en', '0'),
('shan\'t', 'en', '0'),
('she', 'en', '0'),
('she\'d', 'en', '0'),
('she\'ll', 'en', '0'),
('she\'s', 'en', '0'),
('should', 'en', '0'),
('shouldn\'t', 'en', '0'),
('so', 'en', '0'),
('some', 'en', '0'),
('such', 'en', '0'),
('than', 'en', '0'),
('that', 'en', '0'),
('that\'s', 'en', '0'),
('the', 'en', '0'),
('their', 'en', '0'),
('theirs', 'en', '0'),
('them', 'en', '0'),
('themselves', 'en', '0'),
('then', 'en', '0'),
('there', 'en', '0'),
('there\'s', 'en', '0'),
('these', 'en', '0'),
('they', 'en', '0'),
('they\'d', 'en', '0'),
('they\'ll', 'en', '0'),
('they\'re', 'en', '0'),
('they\'ve', 'en', '0'),
('this', 'en', '0'),
('those', 'en', '0'),
('through', 'en', '0'),
('to', 'en', '0'),
('too', 'en', '0'),
('under', 'en', '0'),
('until', 'en', '0'),
('up', 'en', '0'),
('very', 'en', '0'),
('was', 'en', '0'),
('wasn\'t', 'en', '0'),
('we', 'en', '0'),
('we\'d', 'en', '0'),
('we\'ll', 'en', '0'),
('we\'re', 'en', '0'),
('we\'ve', 'en', '0'),
('were', 'en', '0'),
('weren\'t', 'en', '0'),
('what', 'en', '0'),
('what\'s', 'en', '0'),
('when', 'en', '0'),
('when\'s', 'en', '0'),
('where', 'en', '0'),
('where\'s', 'en', '0'),
('which', 'en', '0'),
('while', 'en', '0'),
('who', 'en', '0'),
('who\'s', 'en', '0'),
('whom', 'en', '0'),
('why', 'en', '0'),
('why\'s', 'en', '0'),
('with', 'en', '0'),
('won\'t', 'en', '0'),
('would', 'en', '0'),
('wouldn\'t', 'en', '0'),
('you', 'en', '0'),
('you\'d', 'en', '0'),
('you\'ll', 'en', '0'),
('you\'re', 'en', '0'),
('you\'ve', 'en', '0'),
('your', 'en', '0'),
('yours', 'en', '0'),
('yourself', 'en', '0'),
('yourselves', 'en', '0');
/**ABDB**/CREATE TABLE `#__finder_tokens` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint unsigned NOT NULL DEFAULT '2',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_stem` (`stem`),
  KEY `idx_context` (`context`),
  KEY `idx_language` (`language`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_tokens_aggregate` (
  `term_id` int unsigned NOT NULL,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL DEFAULT '0',
  `context` tinyint unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL DEFAULT '0',
  `total_weight` float unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_types`  VALUES 
('1', 'Category', ''),
('2', 'Contact', ''),
('3', 'Article', ''),
('4', 'News Feed', ''),
('5', 'Tag', '');
/**ABDB**/CREATE TABLE `#__guidedtour_steps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tour_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `position` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int NOT NULL,
  `interactive_type` int NOT NULL DEFAULT '1',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_tour` (`tour_id`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__guidedtour_steps`  VALUES 
('1', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_DESCRIPTION', '1', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_guidedtours&view=tours', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('2', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_DESCRIPTION', '2', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('3', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_DESCRIPTION', '3', 'top', '#jform_url', '2', '2', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('4', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_DESCRIPTION', '4', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('5', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_DESCRIPTION', '5', 'top', 'joomla-field-fancy-select .choices', '2', '3', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('6', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_AUTOSTART_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_AUTOSTART_DESCRIPTION', '6', 'bottom', '#jform_autostart0', '2', '3', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('7', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_DESCRIPTION', '7', 'top', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('8', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_DESCRIPTION', '8', 'bottom', '', '0', '1', 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('9', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_DESCRIPTION', '9', 'top', '#toursList tbody tr:nth-last-of-type(1) td:nth-of-type(5) .btn', '2', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('10', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_DESCRIPTION', '10', 'bottom', '.button-new', '2', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('11', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_DESCRIPTION', '11', 'bottom', '#jform_title', '2', '2', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('12', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_DESCRIPTION', '12', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('13', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_DESCRIPTION', '13', 'bottom', '#jform_published', '2', '3', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('14', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_DESCRIPTION', '14', 'top', '#jform_position', '2', '3', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('15', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_DESCRIPTION', '15', 'top', '#jform_target', '2', '3', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('16', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_DESCRIPTION', '16', 'top', '#jform_type', '2', '3', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('17', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_DESCRIPTION', '17', 'bottom', '#save-group-children-save .button-save', '2', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('18', '2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_DESCRIPTION', '18', 'bottom', '', '0', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('19', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_DESCRIPTION', '19', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_content&view=articles', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('20', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_DESCRIPTION', '20', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('21', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_DESCRIPTION', '21', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('22', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_DESCRIPTION', '22', 'bottom', '#jform_articletext,#jform_articletext_ifr', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('23', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_DESCRIPTION', '23', 'bottom', '#jform_state', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('24', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_DESCRIPTION', '24', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('25', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_DESCRIPTION', '25', 'bottom', '#jform_featured0', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('26', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_DESCRIPTION', '26', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('27', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_DESCRIPTION', '27', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('28', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_DESCRIPTION', '28', 'top', '#jform_note', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('29', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_DESCRIPTION', '29', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('30', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_DESCRIPTION', '30', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('31', '3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_DESCRIPTION', '31', 'bottom', '', '0', '1', 'administrator/index.php?option=com_content&view=article&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('32', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_DESCRIPTION', '32', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('33', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_DESCRIPTION', '33', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('34', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_DESCRIPTION', '34', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('35', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_DESCRIPTION', '35', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('36', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_DESCRIPTION', '36', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('37', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_DESCRIPTION', '37', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('38', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_DESCRIPTION', '38', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('39', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_DESCRIPTION', '39', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('40', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_DESCRIPTION', '40', 'top', '#jform_note', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('41', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_DESCRIPTION', '41', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('42', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_DESCRIPTION', '42', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('43', '4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_DESCRIPTION', '43', 'bottom', '', '0', '1', 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('44', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_DESCRIPTION', '44', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_menus&view=menus', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('45', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_DESCRIPTION', '45', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('46', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_DESCRIPTION', '46', 'top', '#jform_menutype', '2', '2', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('47', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_DESCRIPTION', '47', 'top', '#jform_menudescription', '2', '2', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('48', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_DESCRIPTION', '48', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('49', '5', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_DESCRIPTION', '49', 'bottom', '', '0', '1', 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('50', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_DESCRIPTION', '50', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_tags&view=tags', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('51', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_DESCRIPTION', '51', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('52', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_DESCRIPTION', '52', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('53', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_DESCRIPTION', '53', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('54', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_DESCRIPTION', '54', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('55', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_DESCRIPTION', '55', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('56', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_DESCRIPTION', '56', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('57', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_DESCRIPTION', '57', 'top', '#jform_note', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('58', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_DESCRIPTION', '58', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('59', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_DESCRIPTION', '59', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('60', '6', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_DESCRIPTION', '60', 'bottom', '', '0', '1', 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('61', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_DESCRIPTION', '61', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_banners&view=banners', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('62', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_DESCRIPTION', '62', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('63', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_DESCRIPTION', '63', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('64', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_DESCRIPTION', '64', 'bottom', '.col-lg-9', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('65', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_DESCRIPTION', '65', 'bottom', '#jform_state', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('66', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_DESCRIPTION', '66', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('67', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_DESCRIPTION', '67', 'bottom', '#jform_sticky1', '2', '3', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('68', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_DESCRIPTION', '68', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('69', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_DESCRIPTION', '69', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('70', '7', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_DESCRIPTION', '70', 'bottom', '', '0', '1', 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('71', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_DESCRIPTION', '71', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_contact&view=contacts', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('72', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_DESCRIPTION', '72', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('73', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_DESCRIPTION', '73', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('74', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_DESCRIPTION', '74', 'bottom', '.col-lg-9', '0', '1', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('75', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_DESCRIPTION', '75', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('76', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_DESCRIPTION', '76', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('77', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_DESCRIPTION', '77', 'bottom', '#jform_featured0', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('78', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_DESCRIPTION', '78', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('79', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_DESCRIPTION', '79', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('80', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_DESCRIPTION', '80', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('81', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_DESCRIPTION', '81', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('82', '8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_DESCRIPTION', '82', 'bottom', '', '0', '1', 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('83', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_DESCRIPTION', '83', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('84', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_DESCRIPTION', '84', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('85', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_DESCRIPTION', '85', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('86', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_DESCRIPTION', '86', 'bottom', '#jform_link', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('87', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_DESCRIPTION', '87', 'bottom', '#jform_description,#jform_description_ifr', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('88', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_DESCRIPTION', '88', 'bottom', '#jform_published', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('89', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_DESCRIPTION', '89', 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('90', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_DESCRIPTION', '90', 'bottom', '#jform_access', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('91', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_DESCRIPTION', '91', 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', '2', '3', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('92', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_DESCRIPTION', '92', 'top', '#jform_version_note', '2', '2', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('93', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_DESCRIPTION', '93', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('94', '9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_DESCRIPTION', '94', 'bottom', '', '0', '1', 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('95', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_DESCRIPTION', '95', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_finder&view=filters', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('96', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_DESCRIPTION', '96', 'bottom', '#jform_title', '2', '2', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('97', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_DESCRIPTION', '97', 'bottom', '#jform_alias', '2', '2', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('98', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_DESCRIPTION', '98', 'bottom', '.col-lg-9', '0', '1', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('99', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_DESCRIPTION', '99', 'bottom', '#jform_state', '2', '3', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('100', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_DESCRIPTION', '100', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('101', '10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_DESCRIPTION', '101', 'bottom', '', '0', '1', 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('102', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_DESCRIPTION', '102', 'bottom', '.button-new', '2', '1', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('103', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_DESCRIPTION', '103', 'bottom', '#jform_name', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('104', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_DESCRIPTION', '104', 'bottom', '#jform_username', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('105', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_DESCRIPTION', '105', 'bottom', '#jform_password', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('106', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_DESCRIPTION', '106', 'bottom', '#jform_password2', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('107', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_DESCRIPTION', '107', 'bottom', '#jform_email', '2', '2', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('108', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_DESCRIPTION', '108', 'top', '#jform_sendEmail0', '2', '3', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('109', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_DESCRIPTION', '109', 'top', '#jform_block0', '2', '3', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('110', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_DESCRIPTION', '110', 'top', '#jform_requireReset0', '2', '3', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('111', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_DESCRIPTION', '111', 'bottom', '#save-group-children-save .button-save', '2', '1', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('112', '11', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_DESCRIPTION', '112', 'bottom', '', '0', '1', 'administrator/index.php?option=com_users&view=user&layout=edit', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('113', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_MENUS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_MENUS_DESCRIPTION', '113', 'right', '#sidebarmenu', '0', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('114', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_QUICKACCESS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_QUICKACCESS_DESCRIPTION', '114', 'center', '', '0', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('115', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_NOTIFICATIONS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_NOTIFICATIONS_DESCRIPTION', '115', 'left', '.quickicons-for-update_quickicon .card', '0', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('116', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_TOPBAR_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_TOPBAR_DESCRIPTION', '116', 'bottom', '#header', '0', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('117', '12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_FINALWORDS_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_FINALWORDS_DESCRIPTION', '117', 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', '0', '1', '', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '*', '', NULL),
('118', '13', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_3_STEP_0_TITLE', '1', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_3_STEP_0_DESCRIPTION', '0', 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', '0', '1', '', '2025-04-19 02:55:01', '0', '2025-04-19 02:55:01', '0', NULL, NULL, '*', '', '\"{\"required\":1,\"requiredvalue\":\"\"}\"');
/**ABDB**/CREATE TABLE `#__guidedtours` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uid` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `access` int unsigned NOT NULL DEFAULT '0',
  `autostart` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`),
  KEY `idx_uid` (`uid`(191))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__guidedtours`  VALUES 
('1', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_TITLE', 'joomla-guidedtours', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_DESCRIPTION', '1', '[\"com_guidedtours\"]', 'administrator/index.php?option=com_guidedtours&view=tours', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('2', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_TITLE', 'joomla-guidedtoursteps', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_DESCRIPTION', '2', '[\"com_guidedtours\"]', 'administrator/index.php?option=com_guidedtours&view=tours', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('3', 'COM_GUIDEDTOURS_TOUR_ARTICLES_TITLE', 'joomla-articles', 'COM_GUIDEDTOURS_TOUR_ARTICLES_DESCRIPTION', '3', '[\"com_content\",\"com_categories\"]', 'administrator/index.php?option=com_content&view=articles', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('4', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_TITLE', 'joomla-categories', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_DESCRIPTION', '4', '[\"com_content\",\"com_categories\"]', 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('5', 'COM_GUIDEDTOURS_TOUR_MENUS_TITLE', 'joomla-menus', 'COM_GUIDEDTOURS_TOUR_MENUS_DESCRIPTION', '5', '[\"com_menus\"]', 'administrator/index.php?option=com_menus&view=menus', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('6', 'COM_GUIDEDTOURS_TOUR_TAGS_TITLE', 'joomla-tags', 'COM_GUIDEDTOURS_TOUR_TAGS_DESCRIPTION', '6', '[\"com_tags\"]', 'administrator/index.php?option=com_tags&view=tags', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('7', 'COM_GUIDEDTOURS_TOUR_BANNERS_TITLE', 'joomla-banners', 'COM_GUIDEDTOURS_TOUR_BANNERS_DESCRIPTION', '7', '[\"com_banners\"]', 'administrator/index.php?option=com_banners&view=banners', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('8', 'COM_GUIDEDTOURS_TOUR_CONTACTS_TITLE', 'joomla-contacts', 'COM_GUIDEDTOURS_TOUR_CONTACTS_DESCRIPTION', '8', '[\"com_contact\"]', 'administrator/index.php?option=com_contact&view=contacts', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('9', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_TITLE', 'joomla-newsfeeds', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_DESCRIPTION', '9', '[\"com_newsfeeds\"]', 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('10', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_TITLE', 'joomla-smartsearch', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_DESCRIPTION', '10', '[\"com_finder\"]', 'administrator/index.php?option=com_finder&view=filters', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('11', 'COM_GUIDEDTOURS_TOUR_USERS_TITLE', 'joomla-users', 'COM_GUIDEDTOURS_TOUR_USERS_DESCRIPTION', '11', '[\"com_users\"]', 'administrator/index.php?option=com_users&view=users', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '0'),
('12', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_TITLE', 'joomla-welcome', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_DESCRIPTION', '12', '[\"com_cpanel\"]', 'administrator/index.php', '2024-10-22 11:45:19', '15', '2024-10-22 11:45:19', '15', NULL, NULL, '1', '*', '', '1', '1'),
('13', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_3_TITLE', 'joomla-whatsnew-5-3', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_5_3_DESCRIPTION', '0', '[\"com_cpanel\"]', 'administrator/index.php', '2025-04-19 02:55:01', '0', '2025-04-19 02:55:01', '0', NULL, NULL, '1', '*', '', '1', '1');
/**ABDB**/CREATE TABLE `#__history` (
  `version_id` int unsigned NOT NULL AUTO_INCREMENT,
  `item_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL,
  `editor_user_id` int unsigned NOT NULL DEFAULT '0',
  `character_count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__history`  VALUES 
('1', 'com_content.category.2', '', '2024-10-22 12:34:36', '15', '563', '2d8a010e65100a544191d27a61be862bd7553cd7', '{\"id\":\"2\",\"asset_id\":27,\"parent_id\":1,\"lft\":1,\"rgt\":2,\"level\":1,\"path\":\"uncategorised\",\"extension\":\"com_content\",\"title\":\"General\",\"alias\":\"general\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":15,\"checked_out_time\":\"2024-10-22 12:34:30\",\"access\":1,\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"15\",\"created_time\":\"2024-10-22 11:45:17\",\"modified_user_id\":15,\"modified_time\":\"2024-10-22 12:34:36\",\"hits\":0,\"language\":\"*\",\"version\":1}', '0'),
('2', 'com_content.article.1', '', '2024-10-22 12:35:13', '15', '1589', 'b9dabdddf598897dc7b500050c838b2d825fe758', '{\"id\":1,\"asset_id\":105,\"title\":\"Home\",\"alias\":\"home-info\",\"introtext\":\"<p>Lorem Ipsum<\\/p>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":2,\"created\":\"2024-10-22 12:35:13\",\"created_by\":15,\"created_by_alias\":\"\",\"modified\":\"2024-10-22 12:35:13\",\"modified_by\":15,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2024-10-22 12:35:13\",\"publish_down\":null,\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":\\\"\\\",\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":\\\"\\\",\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":\\\"\\\",\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":\"1\",\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":1,\"hits\":0,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"note\":\"\"}', '0'),
('3', 'com_content.category.2', '', '2025-01-29 07:27:22', '15', '566', '2bbd9d2b91fee3e51540b156402a23cbf64e7f4d', '{\"id\":\"2\",\"asset_id\":27,\"parent_id\":1,\"lft\":1,\"rgt\":2,\"level\":1,\"path\":\"general\",\"extension\":\"com_content\",\"title\":\"General\",\"alias\":\"general-category\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":15,\"checked_out_time\":\"2025-01-29 07:27:16\",\"access\":1,\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"15\",\"created_time\":\"2024-10-22 11:45:17\",\"modified_user_id\":15,\"modified_time\":\"2025-01-29 07:27:22\",\"hits\":0,\"language\":\"*\",\"version\":1}', '0'),
('4', 'com_content.article.2', '', '2025-02-02 09:19:12', '15', '1784', 'f8534f30cc6b5f092356f47cc69222b0123261cc', '{\"id\":2,\"asset_id\":108,\"title\":\"Page Not Found\",\"alias\":\"404\",\"introtext\":\"<p>Oops! The page you\'re looking for can\'t be found.<\\/p>\\r\\n<p>&nbsp;<\\/p>\\r\\n<p>Please navigate back to our <a href=\\\"index.php?Itemid=101\\\" target=\\\"_self\\\" title=\\\"Home\\\">home page<\\/a>.<\\/p>\",\"fulltext\":\"\",\"state\":\"1\",\"catid\":2,\"created\":\"2025-02-02 09:19:12\",\"created_by\":15,\"created_by_alias\":\"\",\"modified\":\"2025-02-02 09:19:12\",\"modified_by\":15,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2025-02-02 09:19:12\",\"publish_down\":null,\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":\\\"\\\",\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":\\\"\\\",\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":\\\"\\\",\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":1,\"hits\":0,\"metadata\":\"{\\\"robots\\\":\\\"noindex, nofollow\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"note\":\"\"}', '0');
/**ABDB**/CREATE TABLE `#__languages` (
  `lang_id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__languages`  VALUES 
('1', '0', 'en-GB', 'English (en-GB)', 'English (United Kingdom)', 'en', 'en_gb', '', '', '', '', '1', '1', '1');
/**ABDB**/CREATE TABLE `#__mail_templates` (
  `template_id` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `htmlbody` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__mail_templates`  VALUES 
('com_actionlogs.notification', 'com_actionlogs', '', 'COM_ACTIONLOGS_EMAIL_SUBJECT', 'COM_ACTIONLOGS_EMAIL_BODY', 'COM_ACTIONLOGS_EMAIL_HTMLBODY', '', '{\"tags\":[\"messages\",\"message\",\"date\",\"extension\",\"username\"]}'),
('com_config.test_mail', 'com_config', '', 'COM_CONFIG_SENDMAIL_SUBJECT', 'COM_CONFIG_SENDMAIL_BODY', '', '', '{\"tags\":[\"sitename\",\"method\"]}'),
('com_contact.mail', 'com_contact', '', 'COM_CONTACT_ENQUIRY_SUBJECT', 'COM_CONTACT_ENQUIRY_TEXT', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}'),
('com_contact.mail.copy', 'com_contact', '', 'COM_CONTACT_COPYSUBJECT_OF', 'COM_CONTACT_COPYTEXT_OF', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\",\"contactname\"]}'),
('com_messages.new_message', 'com_messages', '', 'COM_MESSAGES_NEW_MESSAGE', 'COM_MESSAGES_NEW_MESSAGE_BODY', '', '', '{\"tags\":[\"subject\",\"message\",\"fromname\",\"sitename\",\"siteurl\",\"fromemail\",\"toname\",\"toemail\"]}'),
('com_privacy.notification.admin.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.admin.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.userdataexport', 'com_privacy', '', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_SUBJECT', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_BODY', '', '', '{\"tags\":[\"sitename\",\"url\"]}'),
('com_users.massmail.mail', 'com_users', '', 'COM_USERS_MASSMAIL_MAIL_SUBJECT', 'COM_USERS_MASSMAIL_MAIL_BODY', '', '', '{\"tags\":[\"subject\",\"body\",\"subjectprefix\",\"bodysuffix\"]}'),
('com_users.password_reset', 'com_users', '', 'COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT', 'COM_USERS_EMAIL_PASSWORD_RESET_BODY', '', '', '{\"tags\":[\"name\",\"email\",\"sitename\",\"link_text\",\"link_html\",\"token\"]}'),
('com_users.registration.admin.new_notification', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.admin.verification_request', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"email\",\"username\",\"activate\"]}'),
('com_users.registration.user.admin_activated', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.registration_mail', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.registration_mail_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.self_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.self_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.reminder', 'com_users', '', 'COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT', 'COM_USERS_EMAIL_USERNAME_REMINDER_BODY', '', '', '{\"tags\":[\"name\",\"username\",\"sitename\",\"email\",\"link_text\",\"link_html\"]}'),
('plg_multifactorauth_email.mail', 'plg_multifactorauth_email', '', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_SUBJECT', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_BODY', '', '', '{\"tags\":[\"code\",\"sitename\",\"siteurl\",\"username\",\"email\",\"fullname\"]}'),
('plg_system_tasknotification.failure_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\", \"exit_code\", \"exec_data_time\", \"task_output\"]}'),
('plg_system_tasknotification.fatal_recovery_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.orphan_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.success_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_BODY', '', '', '{\"tags\":[\"task_id\", \"task_title\", \"exec_data_time\", \"task_output\"]}'),
('plg_task_privacyconsent.request.reminder', 'plg_task_privacyconsent', '', 'PLG_TASK_PRIVACYCONSENT_EMAIL_REMIND_SUBJECT', 'PLG_TASK_PRIVACYCONSENT_EMAIL_REMIND_BODY', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('plg_task_updatenotification.mail', 'plg_task_updatenotification', '', 'PLG_TASK_UPDATENOTIFICATION_EMAIL_SUBJECT', 'PLG_TASK_UPDATENOTIFICATION_EMAIL_BODY', '', '', '{\"tags\":[\"newversion\",\"curversion\",\"sitename\",\"url\",\"link\",\"releasenews\"]}'),
('plg_user_joomla.mail', 'plg_user_joomla', '', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_SUBJECT', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"url\",\"username\",\"password\",\"email\"]}');
/**ABDB**/CREATE TABLE `#__menu` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int unsigned DEFAULT NULL COMMENT 'FK to #__users.id',
  `checked_out_time` datetime DEFAULT NULL COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu`  VALUES 
('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', NULL, NULL, '0', '0', '', '0', '', '0', '93', '0', '*', '0', NULL, NULL),
('2', 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '1', '1', '1', '3', NULL, NULL, '0', '0', 'class:bookmark', '0', '', '1', '10', '0', '*', '1', NULL, NULL),
('3', 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners&view=banners', 'component', '1', '2', '2', '3', NULL, NULL, '0', '0', 'class:banners', '0', '', '2', '3', '0', '*', '1', NULL, NULL),
('4', 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&view=categories&extension=com_banners', 'component', '1', '2', '2', '5', NULL, NULL, '0', '0', 'class:banners-cat', '0', '', '4', '5', '0', '*', '1', NULL, NULL),
('5', 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', '1', '2', '2', '3', NULL, NULL, '0', '0', 'class:banners-clients', '0', '', '6', '7', '0', '*', '1', NULL, NULL),
('6', 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', '1', '2', '2', '3', NULL, NULL, '0', '0', 'class:banners-tracks', '0', '', '8', '9', '0', '*', '1', NULL, NULL),
('7', 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '1', '1', '1', '7', NULL, NULL, '0', '0', 'class:address-book', '0', '', '11', '20', '0', '*', '1', NULL, NULL),
('8', 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact&view=contacts', 'component', '1', '7', '2', '7', NULL, NULL, '0', '0', 'class:contact', '0', '', '12', '13', '0', '*', '1', NULL, NULL),
('9', 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&view=categories&extension=com_contact', 'component', '1', '7', '2', '5', NULL, NULL, '0', '0', 'class:contact-cat', '0', '', '14', '15', '0', '*', '1', NULL, NULL),
('10', 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '1', '1', '1', '16', NULL, NULL, '0', '0', 'class:rss', '0', '', '23', '28', '0', '*', '1', NULL, NULL),
('11', 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds&view=newsfeeds', 'component', '1', '10', '2', '16', NULL, NULL, '0', '0', 'class:newsfeeds', '0', '', '24', '25', '0', '*', '1', NULL, NULL),
('12', 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&view=categories&extension=com_newsfeeds', 'component', '1', '10', '2', '5', NULL, NULL, '0', '0', 'class:newsfeeds-cat', '0', '', '26', '27', '0', '*', '1', NULL, NULL),
('13', 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '1', '1', '1', '23', NULL, NULL, '0', '0', 'class:search-plus', '0', '', '29', '38', '0', '*', '1', NULL, NULL),
('14', 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags&view=tags', 'component', '1', '1', '1', '25', NULL, NULL, '0', '1', 'class:tags', '0', '', '39', '40', '0', '', '1', NULL, NULL),
('15', 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations&view=associations', 'component', '1', '1', '1', '30', NULL, NULL, '0', '0', 'class:language', '0', '', '21', '22', '0', '*', '1', NULL, NULL),
('16', 'main', 'mod_menu_fields', 'Contact Custom Fields', '', 'Contacts/Contact Custom Fields', 'index.php?option=com_fields&context=com_contact.contact', 'component', '1', '7', '2', '29', NULL, NULL, '0', '0', 'class:messages-add', '0', '', '16', '17', '0', '*', '1', NULL, NULL),
('17', 'main', 'mod_menu_fields_group', 'Contact Custom Fields Group', '', 'Contacts/Contact Custom Fields Group', 'index.php?option=com_fields&view=groups&context=com_contact.contact', 'component', '1', '7', '2', '29', NULL, NULL, '0', '0', 'class:messages-add', '0', '', '18', '19', '0', '*', '1', NULL, NULL),
('18', 'main', 'com_finder_index', 'Smart-Search-Index', '', 'Smart Search/Smart-Search-Index', 'index.php?option=com_finder&view=index', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder', '0', '', '30', '31', '0', '*', '1', NULL, NULL),
('19', 'main', 'com_finder_maps', 'Smart-Search-Maps', '', 'Smart Search/Smart-Search-Maps', 'index.php?option=com_finder&view=maps', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder-maps', '0', '', '32', '33', '0', '*', '1', NULL, NULL),
('20', 'main', 'com_finder_filters', 'Smart-Search-Filters', '', 'Smart Search/Smart-Search-Filters', 'index.php?option=com_finder&view=filters', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder-filters', '0', '', '34', '35', '0', '*', '1', NULL, NULL),
('21', 'main', 'com_finder_searches', 'Smart-Search-Searches', '', 'Smart Search/Smart-Search-Searches', 'index.php?option=com_finder&view=searches', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder-searches', '0', '', '36', '37', '0', '*', '1', NULL, NULL),
('101', 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=article&id=1', 'component', '1', '1', '1', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '41', '42', '1', '*', '0', NULL, NULL),
('169', 'hidden-menu', 'Page Not Found', 'page-not-found', '', 'page-not-found', 'index.php?option=com_content&view=article&id=2', 'component', '1', '1', '1', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"noindex, nofollow\"}', '43', '44', '0', '*', '0', NULL, NULL),
('267', 'main', 'COM_JCE', 'com-jce', '', 'com-jce', 'index.php?option=com_jce&view=cpanel', 'component', '1', '1', '1', '251', NULL, NULL, '0', '1', 'class:component', '0', '{}', '45', '54', '0', '', '1', NULL, NULL),
('268', 'main', 'COM_JCE_MENU_CPANEL', 'com-jce-menu-cpanel', '', 'com-jce/com-jce-menu-cpanel', 'index.php?option=com_jce&view=cpanel', 'component', '1', '267', '2', '251', NULL, NULL, '0', '1', 'class:component', '0', '{}', '46', '47', '0', '', '1', NULL, NULL),
('269', 'main', 'COM_JCE_MENU_CONFIG', 'com-jce-menu-config', '', 'com-jce/com-jce-menu-config', 'index.php?option=com_jce&view=config', 'component', '1', '267', '2', '251', NULL, NULL, '0', '1', 'class:component', '0', '{}', '48', '49', '0', '', '1', NULL, NULL),
('270', 'main', 'COM_JCE_MENU_PROFILES', 'com-jce-menu-profiles', '', 'com-jce/com-jce-menu-profiles', 'index.php?option=com_jce&view=profiles', 'component', '1', '267', '2', '251', NULL, NULL, '0', '1', 'class:component', '0', '{}', '50', '51', '0', '', '1', NULL, NULL),
('271', 'main', 'COM_JCE_MENU_FILEBROWSER', 'com-jce-menu-filebrowser', '', 'com-jce/com-jce-menu-filebrowser', 'index.php?option=com_jce&view=browser', 'component', '1', '267', '2', '251', NULL, NULL, '0', '1', 'class:component', '0', '{}', '52', '53', '0', '', '1', NULL, NULL),
('272', 'main', 'COM_AKEEBABACKUP', 'com-akeebabackup', '', 'com-akeebabackup', 'index.php?option=com_akeebabackup', 'component', '1', '1', '1', '248', NULL, NULL, '0', '1', 'class:component', '0', '{}', '55', '64', '0', '', '1', NULL, NULL),
('273', 'main', 'COM_AKEEBABACKUP_CONTROLPANEL', 'com-akeebabackup-controlpanel', '', 'com-akeebabackup/com-akeebabackup-controlpanel', 'index.php?option=com_akeebabackup&view=Controlpanel', 'component', '1', '272', '2', '248', NULL, NULL, '0', '1', 'class:component', '0', '{}', '56', '57', '0', '', '1', NULL, NULL),
('274', 'main', 'COM_AKEEBABACKUP_CONFIGURATION', 'com-akeebabackup-configuration', '', 'com-akeebabackup/com-akeebabackup-configuration', 'index.php?option=com_akeebabackup&view=Configuration', 'component', '1', '272', '2', '248', NULL, NULL, '0', '1', 'class:component', '0', '{}', '58', '59', '0', '', '1', NULL, NULL),
('275', 'main', 'COM_AKEEBABACKUP_BACKUP', 'com-akeebabackup-backup', '', 'com-akeebabackup/com-akeebabackup-backup', 'index.php?option=com_akeebabackup&view=Backup', 'component', '1', '272', '2', '248', NULL, NULL, '0', '1', 'class:component', '0', '{}', '60', '61', '0', '', '1', NULL, NULL),
('276', 'main', 'COM_AKEEBABACKUP_MANAGE', 'com-akeebabackup-manage', '', 'com-akeebabackup/com-akeebabackup-manage', 'index.php?option=com_akeebabackup&view=Manage', 'component', '1', '272', '2', '248', NULL, NULL, '0', '1', 'class:component', '0', '{}', '62', '63', '0', '', '1', NULL, NULL),
('277', 'main', 'COM_OSMAP_TITLE', 'com-osmap-title', '', 'com-osmap-title', 'index.php?option=com_osmap', 'component', '1', '1', '1', '275', NULL, NULL, '0', '1', 'class:component', '0', '{}', '65', '66', '0', '', '1', NULL, NULL),
('278', 'main', 'RSFormPro', 'rsformpro', '', 'rsformpro', 'index.php?option=com_rsform', 'component', '1', '1', '1', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '67', '82', '0', '', '1', NULL, NULL),
('279', 'main', 'COM_RSFORM_DASHBOARD', 'com-rsform-dashboard', '', 'rsformpro/com-rsform-dashboard', 'index.php?option=com_rsform', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '68', '69', '0', '', '1', NULL, NULL),
('280', 'main', 'COM_RSFORM_MANAGE_FORMS', 'com-rsform-manage-forms', '', 'rsformpro/com-rsform-manage-forms', 'index.php?option=com_rsform&view=forms', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '70', '71', '0', '', '1', NULL, NULL),
('281', 'main', 'COM_RSFORM_MANAGE_SUBMISSIONS', 'com-rsform-manage-submissions', '', 'rsformpro/com-rsform-manage-submissions', 'index.php?option=com_rsform&view=submissions', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '72', '73', '0', '', '1', NULL, NULL),
('282', 'main', 'COM_RSFORM_MANAGE_DIRECTORY_SUBMISSIONS', 'com-rsform-manage-directory-submissions', '', 'rsformpro/com-rsform-manage-directory-submissions', 'index.php?option=com_rsform&view=directory', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '74', '75', '0', '', '1', NULL, NULL),
('283', 'main', 'COM_RSFORM_CONFIGURATION', 'com-rsform-configuration', '', 'rsformpro/com-rsform-configuration', 'index.php?option=com_rsform&view=configuration', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '76', '77', '0', '', '1', NULL, NULL),
('284', 'main', 'COM_RSFORM_BACKUP_SCREEN', 'com-rsform-backup-screen', '', 'rsformpro/com-rsform-backup-screen', 'index.php?option=com_rsform&view=backupscreen', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '78', '79', '0', '', '1', NULL, NULL),
('285', 'main', 'COM_RSFORM_RESTORE_SCREEN', 'com-rsform-restore-screen', '', 'rsformpro/com-rsform-restore-screen', 'index.php?option=com_rsform&view=restorescreen', 'component', '1', '278', '2', '268', NULL, NULL, '0', '1', 'class:component', '0', '{}', '80', '81', '0', '', '1', NULL, NULL),
('286', 'main', 'COM_TEMPLATECK', 'com-templateck', '', 'com-templateck', 'index.php?option=com_templateck', 'component', '1', '1', '1', '246', NULL, NULL, '0', '1', 'class:component', '0', '{}', '83', '92', '0', '', '1', NULL, NULL),
('287', 'main', 'COM_TEMPLATECK_TITLE_TEMPLATES', 'com-templateck-title-templates', '', 'com-templateck/com-templateck-title-templates', 'index.php?option=com_templateck', 'component', '1', '286', '2', '246', NULL, NULL, '0', '1', 'class:templatecreatorck', '0', '{}', '84', '85', '0', '', '1', NULL, NULL),
('288', 'main', 'CK_SUBMENU_FONTS', 'ck-submenu-fonts', '', 'com-templateck/ck-submenu-fonts', 'index.php?option=com_templateck&view=fonts', 'component', '1', '286', '2', '246', NULL, NULL, '0', '1', 'class:templatecreatorck-fonts', '0', '{}', '86', '87', '0', '', '1', NULL, NULL),
('289', 'main', 'CK_ABOUT', 'ck-about', '', 'com-templateck/ck-about', 'index.php?option=com_templateck&view=about', 'component', '1', '286', '2', '246', NULL, NULL, '0', '1', 'class:templatecreatorck-about', '0', '{}', '88', '89', '0', '', '1', NULL, NULL),
('290', 'main', 'CK_HELP', 'ck-help', '', 'com-templateck/ck-help', 'index.php?option=com_templateck&view=help', 'component', '1', '286', '2', '246', NULL, NULL, '0', '1', 'class:templatecreatorck-fonts', '0', '{}', '90', '91', '0', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__menu_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu_types`  VALUES 
('1', '0', 'mainmenu', 'Main Menu', 'The main menu for the site', '0', '1'),
('2', '107', 'hidden-menu', 'Hidden Menu', '', '0', '0');
/**ABDB**/CREATE TABLE `#__messages` (
  `message_id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int unsigned NOT NULL DEFAULT '0',
  `user_id_to` int unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `priority` tinyint unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__messages_cfg` (
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci,
  `ordering` int NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint unsigned NOT NULL DEFAULT '1',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules`  VALUES 
('1', '39', 'Main Menu', '', '', '1', 'MainMenu', NULL, NULL, NULL, NULL, '1', 'mod_menu', '1', '0', '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('2', '40', 'Login', '', '', '1', 'login', NULL, NULL, NULL, NULL, '1', 'mod_login', '1', '1', '', '1', '*'),
('3', '41', 'Popular Articles', '', '', '6', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('4', '42', 'Recently Added Articles', '', '', '4', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('8', '43', 'Toolbar', '', '', '1', 'toolbar', NULL, NULL, NULL, NULL, '1', 'mod_toolbar', '3', '1', '', '1', '*'),
('9', '44', 'Notifications', '', '', '3', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '3', '1', '{\"context\":\"update_quickicon\",\"header_icon\":\"icon-sync\",\"show_jupdate\":\"1\",\"show_eupdate\":\"1\",\"show_oupdate\":\"1\",\"show_privacy\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('10', '45', 'Logged-in Users', '', '', '2', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('12', '46', 'Admin Menu', '', '', '1', 'menu', NULL, NULL, NULL, NULL, '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*'),
('15', '49', 'Title', '', '', '1', 'title', NULL, NULL, NULL, NULL, '1', 'mod_title', '3', '1', '', '1', '*'),
('16', '50', 'Login Form', '', '', '7', 'sidebar-right', NULL, NULL, NULL, NULL, '0', 'mod_login', '1', '1', '{\"greeting\":\"1\",\"name\":\"0\"}', '0', '*'),
('17', '51', 'Breadcrumbs', '', '', '1', 'breadcrumb', NULL, NULL, NULL, NULL, '1', 'mod_breadcrumbs', '1', '0', '{\"showHere\":1,\"showHome\":1,\"homeText\":\"\",\"showLast\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":0,\"cache_time\":0,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*'),
('79', '52', 'Multilanguage status', '', '', '2', 'status', NULL, NULL, NULL, NULL, '1', 'mod_multilangstatus', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('86', '53', 'Joomla Version', '', '', '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_version', '3', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', '1', '*'),
('87', '55', 'Sample Data', '', '', '1', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_sampledata', '6', '1', '{\"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('88', '67', 'Latest Actions', '', '', '3', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_latestactions', '6', '1', '{\"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('89', '68', 'Privacy Dashboard', '', '', '5', 'cpanel', NULL, NULL, NULL, NULL, '1', 'mod_privacy_dashboard', '6', '1', '{\"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('90', '89', 'Login Support', '', '', '1', 'sidebar', NULL, NULL, NULL, NULL, '1', 'mod_loginsupport', '1', '1', '{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '1', '*'),
('91', '72', 'System Dashboard', '', '', '1', 'cpanel-system', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('92', '73', 'Content Dashboard', '', '', '1', 'cpanel-content', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('93', '74', 'Menus Dashboard', '', '', '1', 'cpanel-menus', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('94', '75', 'Components Dashboard', '', '', '1', 'cpanel-components', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('95', '76', 'Users Dashboard', '', '', '1', 'cpanel-users', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', '1', '*'),
('96', '86', 'Popular Articles', '', '', '3', 'cpanel-content', NULL, NULL, NULL, NULL, '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('97', '87', 'Recently Added Articles', '', '', '4', 'cpanel-content', NULL, NULL, NULL, NULL, '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('98', '88', 'Logged-in Users', '', '', '2', 'cpanel-users', NULL, NULL, NULL, NULL, '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\": \"12\",\"header_tag\":\"h2\"}', '1', '*'),
('99', '77', 'Frontend Link', '', '', '5', 'status', NULL, NULL, NULL, NULL, '1', 'mod_frontend', '1', '1', '', '1', '*'),
('100', '78', 'Messages', '', '', '4', 'status', NULL, NULL, NULL, NULL, '1', 'mod_messages', '3', '1', '', '1', '*'),
('101', '79', 'Post Install Messages', '', '', '3', 'status', NULL, NULL, NULL, NULL, '1', 'mod_post_installation_messages', '3', '1', '', '1', '*'),
('102', '80', 'User Status', '', '', '6', 'status', NULL, NULL, NULL, NULL, '1', 'mod_user', '3', '1', '', '1', '*'),
('103', '70', 'Site', '', '', '1', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '1', '1', '{\"context\":\"site_quickicon\",\"header_icon\":\"icon-desktop\",\"show_global\":\"0\",\"show_checkin\":\"0\",\"show_cache\":\"0\",\"show_users\":\"0\",\"show_articles\":\"1\",\"show_featured\":\"0\",\"show_menuitems\":\"1\",\"show_workflow\":\"0\",\"show_banners\":\"0\",\"show_finder\":\"0\",\"show_newsfeeds\":\"0\",\"show_tags\":\"0\",\"show_redirect\":\"0\",\"show_associations\":\"0\",\"show_languages\":\"0\",\"show_modules\":\"1\",\"show_contact\":\"0\",\"show_categories\":\"0\",\"show_media\":\"1\",\"show_plugins\":\"1\",\"show_template_styles\":\"1\",\"show_template_code\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"0\"}', '1', '*'),
('104', '71', 'System', '', '', '2', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '1', '1', '{\"context\":\"system_quickicon\",\"header_icon\":\"icon-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('105', '82', '3rd Party', '', '', '4', 'icon', NULL, NULL, NULL, NULL, '1', 'mod_quickicon', '1', '1', '{\"context\":\"mod_quickicon\",\"header_icon\":\"icon-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('106', '83', 'Help Dashboard', '', '', '1', 'cpanel-help', NULL, NULL, NULL, NULL, '1', 'mod_submenu', '1', '0', '{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('107', '84', 'Privacy Requests', '', '', '1', 'cpanel-privacy', NULL, NULL, NULL, NULL, '1', 'mod_privacy_dashboard', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('108', '85', 'Privacy Status', '', '', '1', 'cpanel-privacy', NULL, NULL, NULL, NULL, '1', 'mod_privacy_status', '1', '1', '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', '1', '*'),
('109', '96', 'Guided Tours', '', '', '1', 'status', NULL, NULL, NULL, NULL, '1', 'mod_guidedtours', '1', '1', '', '1', '*'),
('110', '104', 'Copyright', '', '<p>Website &amp; Content Copyright © 2025 -&nbsp;{source}<span style=\"font-family: monospace; color: #555555;\"><span style=\"color: #0000cc;\">&lt;?php echo date(\"Y\") ?&gt;</span></span>{/source} Client Name. All Rights Reserved.</p>\r\n<p>Website Developed by <a href=\"https://www.tscmedia.co.za/\" target=\"_blank\" rel=\"noopener\" title=\"TSC Media | Web Design &amp; Hosting\">TSC Media</a>.</p>', '1', 'copyright', NULL, NULL, NULL, NULL, '1', 'mod_custom', '1', '0', '{\"prepare_content\":0,\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', '0', '*');
/**ABDB**/CREATE TABLE `#__modules_menu` (
  `moduleid` int NOT NULL DEFAULT '0',
  `menuid` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules_menu`  VALUES 
('1', '0'),
('2', '0'),
('3', '0'),
('4', '0'),
('6', '0'),
('7', '0'),
('8', '0'),
('9', '0'),
('10', '0'),
('12', '0'),
('14', '0'),
('15', '0'),
('16', '0'),
('17', '-101'),
('79', '0'),
('86', '0'),
('87', '0'),
('88', '0'),
('89', '0'),
('90', '0'),
('91', '0'),
('92', '0'),
('93', '0'),
('94', '0'),
('95', '0'),
('96', '0'),
('97', '0'),
('98', '0'),
('99', '0'),
('100', '0'),
('101', '0'),
('102', '0'),
('103', '0'),
('104', '0'),
('105', '0'),
('106', '0'),
('107', '0'),
('108', '0'),
('109', '0'),
('110', '0');
/**ABDB**/CREATE TABLE `#__newsfeeds` (
  `catid` int NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint NOT NULL DEFAULT '0',
  `numarticles` int unsigned NOT NULL DEFAULT '1',
  `cache_time` int unsigned NOT NULL DEFAULT '3600',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `rtl` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__osmap_items_settings` (
  `sitemap_id` int unsigned NOT NULL,
  `uid` varchar(100) NOT NULL DEFAULT '',
  `settings_hash` char(32) NOT NULL DEFAULT '',
  `published` tinyint unsigned NOT NULL DEFAULT '1',
  `changefreq` enum('always','hourly','daily','weekly','monthly','yearly','never') NOT NULL DEFAULT 'weekly',
  `priority` float NOT NULL DEFAULT '0.5',
  `format` tinyint unsigned DEFAULT '2' COMMENT 'Format of the setting: 1) Legacy Mode - UID Only; 2) Based on menu ID and UID',
  PRIMARY KEY (`sitemap_id`,`uid`,`settings_hash`),
  KEY `idx_sitemap_id` (`sitemap_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__osmap_sitemap_menus` (
  `sitemap_id` int unsigned NOT NULL,
  `menutype_id` int NOT NULL,
  `changefreq` enum('always','hourly','daily','weekly','monthly','yearly','never') NOT NULL DEFAULT 'weekly',
  `priority` float NOT NULL DEFAULT '0.5',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`sitemap_id`,`menutype_id`),
  KEY `idx_menutype_id` (`menutype_id`),
  KEY `idx_sitemaps_id` (`sitemap_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/INSERT INTO `#__osmap_sitemap_menus`  VALUES 
('1', '1', 'weekly', '0.5', '0');
/**ABDB**/CREATE TABLE `#__osmap_sitemaps` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `params` text,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `created_on` datetime DEFAULT NULL,
  `links_count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_default` (`is_default`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/**ABDB**/INSERT INTO `#__osmap_sitemaps`  VALUES 
('1', 'Default Sitemap', NULL, '1', '1', '2024-10-22 12:36:57', '0');
/**ABDB**/CREATE TABLE `#__overrider` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__postinstall_messages`  VALUES 
('1', '240', 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', '1', 'message', '', '', '', '', '3.2.0', '0'),
('2', '240', 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', '1', 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', '0'),
('3', '240', 'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_TITLE', 'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_BODY', 'PLG_SYSTEM_HTTPHEADERS_POSTINSTALL_INTRODUCTION_ACTION', 'plg_system_httpheaders', '1', 'action', 'site://plugins/system/httpheaders/postinstall/introduction.php', 'httpheaders_postinstall_action', 'site://plugins/system/httpheaders/postinstall/introduction.php', 'httpheaders_postinstall_condition', '4.0.0', '1'),
('4', '240', 'COM_USERS_POSTINSTALL_MULTIFACTORAUTH_TITLE', 'COM_USERS_POSTINSTALL_MULTIFACTORAUTH_BODY', 'COM_USERS_POSTINSTALL_MULTIFACTORAUTH_ACTION', 'com_users', '1', 'action', 'admin://components/com_users/postinstall/multifactorauth.php', 'com_users_postinstall_mfa_action', 'admin://components/com_users/postinstall/multifactorauth.php', 'com_users_postinstall_mfa_condition', '4.2.0', '1');
/**ABDB**/CREATE TABLE `#__privacy_consents` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `state` int NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;/**ABDB**/
