<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

use Templatecreatorck\CKView;

/**
 * Templatecks View
 */
class TemplateckViewFonts extends CKView {

	protected $items;

	protected $pagination;

	protected $state;

	protected $fonts;

	/**
	 * Fonts view display method
	 * @return void
	 * */
	function display($tpl = null) {
		\Joomla\CMS\Toolbar\ToolbarHelper::title(TCK_Text::_('CK_FONTS_MANAGER'), 'home_templateck');

		if ($this->input->get('layout') == 'installfontsquirrel' || $this->input->get('layout') == 'installfontgoogle') {
			\Joomla\CMS\Toolbar\ToolbarHelper::cancel('font.cancel', 'JTOOLBAR_CANCEL');
		} else {
			\Joomla\CMS\Toolbar\ToolbarHelper::trash('font.delete');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('font.installFontsquirrel', 'download', 'installTheme', 'CK_INSTALL_FONTSQUIRREL', false);
//			\Joomla\CMS\Toolbar\ToolbarHelper::editList('font.edit', 'JTOOLBAR_EDIT');
		}

		$this->checkDbIntegrity();

		// Get categories from the model
		$fonts = $this->get('fonts');
		$this->fonts = $fonts;
		$layout = $this->input->get('layout');
		if ((!$layout || $layout == 'default') && version_compare(JVERSION, '4') < 0) TemplateckHelper::addSidebar();
		parent::display($layout);
	}

	/**
	 * Load the fonts from the db and inject the css in the page
	 * @return void
	 */
	function _callfonts() {
		$fontstyles = '';
		$fontsheets = '';
		$db = \Joomla\CMS\Factory::getDBO();
		$query = "SELECT * FROM #__templateck_fonts";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		if (!$rows)
			return false;
		foreach ($rows as $row) {
			if (stristr($row->styles, '@import')) 
			{
				$fontsheets .= str_replace(");", "' rel='stylesheet' type='text/css'>", str_replace("@import url(", "<link href='", $row->styles));
			} else {
				$fontstyles .= str_replace("url('", "url('" . \Joomla\CMS\Uri\Uri::base(true) . "/components/com_templateck/fonts/" . $row->name . "/", $row->styles);
			}
		}
		if ($fontstyles)
			echo "<style type=\"text/css\">" . $fontstyles . "</style>";
		if ($fontsheets)
			echo $fontsheets;
	}
	
	private function checkDbIntegrity() {
		$db = \Joomla\CMS\Factory::getDbo();
		
		// test if the subset columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_fonts LIKE 'subset'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_fonts` ADD `subset` text NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table subset update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table subset updated !</p>';
				}
			}
		} else {
			echo 'SQL error - Check existing widgets column';
			return false;
		}
		// test if the alternatives columns not exists
		$query = "SHOW COLUMNS FROM #__templateck_fonts LIKE 'alternatives'";
		$db->setQuery($query);
		if ($db->execute()) {
			if ( $db->loadResult()) {
				//echo 'existe deja!';return;
			} else {
				// add the SQL field to the main table
				$db->setQuery('ALTER TABLE `#__templateck_fonts` ADD `alternatives` text NOT NULL;');
				if (!$db->execute()) {
					echo '<p class="alert alert-danger">Error during table widgets update process !</p>';
				} else {
					echo '<p class="alert alert-success">Table alternatives updated !</p>';
				}
			}
		} else {
			echo 'SQL error - Check existing widgets column';
			return false;
		}
		
	}

}
