<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
defined('TCK_LOADED') or die;
if (TEMPLATECREATORCK_PLATFORM == 'joomla') require_once 'ckmodules.php';

abstract class CKCreator {

	public static function getModule($blockid, $position, $name) {
		$module = CKModules::getInstance($name);
		$func = 'loadModule' . ucfirst($name);
		$html = self::$func($blockid, $position, $module);
//		$html = "<div id=\"" . $blockid . "\" class=\"module ckbloc\" ckmoduleposition=\"" . $position . "\" data-moduleid=\"0\" data-element=\"" . $module->element . "\" >
//			" . self::addJs($blockid) . "
//			<div class=\"ckstyle\"></div>
//			<div class=\"inner clearfix\">
//			<div class=\"tck-module\">
//				" . self::$func() . "
//			</div>
//			</div>
//		</div>";
		return $html;
	}

	public static function loadModuleSlideshowck($blockid, $position) {
		$html = "<div id=\"" . $blockid . "\" class=\"module ckbloc\" ckmoduleposition=\"" . $position . "\" data-moduleid=\"0\" data-element=\"mod_slideshowck\" >
			" . self::addJs($blockid) . "
			<div class=\"ckstyle\"></div>
			<div class=\"inner\">
			<div class=\"tck-module\">
				<img width=\"100%\" height=\"auto\" src=\"" . TEMPLATECREATORCK_MEDIA_URI . "/images/modules/slideshowck.jpg\" data-src=\"/administrator/components/com_templateck/images/modules/slideshowck.jpg\" />
			</div>
			</div>
		</div>";

		return $html;
	}

	public static function loadModuleMenu($blockid, $position, $module) {
		$html = "<div id=\"" . $blockid . "\" class=\"module ckbloc\" ckmoduleposition=\"" . $position . "\" data-moduleid=\"0\" data-element=\"mod_menu\" >
            " . self::addJs($blockid) . "
            <div class=\"ckstyle\"></div>
            <div class=\"inner\">
            <div class=\"tck-module\">
                " . self::fillMenu() . "
            </div>
            </div>
        </div>";

		return $html;
	}

	public static function openWrapper($blockid, $fluid = 'fluid') {
		$fluidClass = ($fluid == 'fluid') ? '-fluid' : '';
		$html = "<div id=\"" . $blockid . "\" class=\"wrapper ckbloc\">";
//            <script type=\"text/javascript\">jQuery(\"#" . $blockid . "\").mouseenter(function() {ckAddEdition(this);});
//        jQuery(\"#" . $blockid . "\").mouseleave(function() {ckRemoveEdition(this);});</script>
        $html .= "<div class=\"ckstyle\"></div>
            <div class=\"tck-container inner\">";
		return $html;
	}

	public static function closeWrapper() {
		$html = "</div>
        </div>";
		return $html;
	}

	public static function row($blockid) {
		$html = self::openRow($blockid, '4');
		$html .= self::openRowContainer($blockid . "column1", "25");
		$html .= self::closeRowContainer();
		$html .= self::openRowContainer($blockid . "column2", "25");
		$html .= self::closeRowContainer();
		$html .= self::openRowContainer($blockid . "column3", "25");
		$html .= self::closeRowContainer();
		$html .= self::openRowContainer($blockid . "column4", "25");
		$html .= self::closeRowContainer();
		$html .= self::closeRow();

		return $html;
	}

	public static function openRowContainer($id, $width) {
		$html = "<div class=\"ckrowcontainer\" id=\"" . $id . "\" style=\"width:" . $width . "%;\" data-width=\"" . $width . "\">";
		return $html;
	}

	public static function closeRowContainer() {
		$html = "</div>";
		return $html;
	}

	public static function openRow($blockid, $numberOfBlocs) {
		$html = "<div id=\"" . $blockid . "\" class=\"ckrow ckbloc\" numberofmodules=\"" . $numberOfBlocs . "\" paramslist=\"numberofmodules\" ckresponsive1=\"mobile_notaligned\" ckresponsive2=\"mobile_notaligned\" >
			" . self::addJs($blockid. "") . "
            <div class=\"ckstyle\"></div>
            <div class=\"inner\">";
		return $html;
	}
	
	public static function closeRow() {
		$html = "</div>
        </div>";
		return $html;
	}

	/*public static function addMaincontrol($type) {
		if ($type == 'container') {
			$html = "<div class=\"maincontrol " . $type . "\" onclick=\"ckCreateWrapperBloc(this)\">";
			$html .= TCK_Text::_('CK_ADD_WRAPPER');
		} else {
			$html = "<div class=\"maincontrol " . $type . "\" onclick=\"showBlocSelection(this)\">";
			$html .= TCK_Text::_('CK_ADD_BLOCK');
		}
		$html .= "</div>";
		return $html;
	}*/

	public static function singleModule($blockid, $position) {
		$html = "<div id=\"" . $blockid . "\" class=\"singlemodule ckbloc\" ckmoduleposition=\"" . $position . "\">
			" . self::addJs($blockid) . "
            <div class=\"ckstyle\"></div>
            <div class=\"inner\">
            <div class=\"tck-module\">
                " . self::fillNews() . "
            </div>
            </div>
        </div>";
		return $html;
	}

	public static function horizMenu($blockid, $position) {
		$html = "<div id=\"" . $blockid . "\" class=\"module horiznav ckbloc\" ckmoduleposition=\"" . $position . "\" data-element=\"mod_menu\" data-moduleid=\"0\">
            " . self::addJs($blockid) . "
            " . self::addMenuCssProps($blockid) . "
            <div class=\"ckstyle\">
                <style type=\"text/css\" >" . self::addMenuCKStyles($blockid) . "</style>
            </div>
            <div class=\"inner\">
            <div class=\"tck-module\">
                " . self::fillHorizmenu() . "
            </div>
            </div>
        </div>";
		return $html;
	}

	public static function custombloc($blockid, $position) {
		$html = "<div id=\"" . $blockid . "\" class=\"custombloc ckbloc\">
           " . self::addJs($blockid) . "
            <div class=\"ckstyle\"></div>
            <div class=\"inner\">
            <div class=\"customcont\" contenteditable=\"true\" style=\"height:75px;background-color:#efefef;border:1px solid #666;\">
            </div>
            </div>
        </div>";
		return $html;
	}

	public static function emptybloc($blockid, $position) {
		$html = "<div id=\"" . $blockid . "\" class=\"emptybloc ckbloc\">
           " . self::addJs($blockid) . "
            <div class=\"ckstyle\"></div>
            </div>
        </div>";
		return $html;
	}

	public static function logo($blockid) {
		$html = "<div id=\"" . $blockid . "\" class=\"bannerlogo logobloc ckbloc\">
                    <div class=\"tab_logodescstyles ckprops\" logodesccolor=\"#a3a3a3\" logodescfontsize=\"13\" logodescfontfamily=\"Arial, sans-serif\" logodescalignementcenter=\"checked\" uselogodescno=\"checked\" logodesctext=\"This is the slogan for my company\" fieldslist=\"logodesccolor,logodescfontsize,logodescfontfamily,logodescalignementleft,logodesctext,uselogodescno\"></div>
                    <div class=\"tab_blocstyles ckprops\" blocbackgroundimageurl=\"administrator/components/com_templateck/images/logo_fake.png\" blocwidth=\"\" logowidth=\"216\" logoheight=\"53\" fieldslist=\"blocbackgroundimageurl,blocwidth,logowidth,logoheight\"></div>
                    " . self::addJs($blockid . "") . "
                    <div class=\"ckstyle\">
                    <style type=\"text/css\" >#" . $blockid . " {}
					#" . $blockid . " > div.inner > .bannerlogodesc {
                    color: #a3a3a3;
                    text-align: left;
                    font-size: 13px;
                    font-family: Arial, sans-serif;
                    }

                    #" . $blockid . " > div.inner {
                    
                    }
                    </style>
                    </div>
                    <div class=\"inner\">
                        <img src=\"" . TEMPLATECREATORCK_MEDIA_URI . "/images/logo_fake.png\" width=\"216\" height=\"53\" />
                        <div class=\"bannerlogodesc\" style=\"display:none;\">
                            <div class=\"inner\">
                                <div>This is the slogan for my company</div>
                            </div>
                        </div>
                    </div>
                </div>";
		return $html;
	}

	public static function banner($blockid, $positions) {
		$positions = explode(',', $positions);

		$html = self::openRow($blockid . "row", '3');

		$html .= self::openRowContainer($blockid . "column1", "30");
		$html .= self::logo($blockid . "logo");
		$html .= self::closeRowContainer();
		
		$html .= self::openRowContainer($blockid . "column2", "30");
		$html .= self::singleModule($blockid . "module", $positions[0]);
		$html .= self::closeRowContainer();
		
		$html .= self::openRowContainer($blockid . "column3", "40");
		$html .= self::horizMenu($blockid . 'menu', $positions[1]);
		$html .= self::closeRowContainer();
		
		$html .= self::closeRow();
		return $html;
	}

	public static function flexiblemodules($blockid, $positions) {
		$positions = explode(',', $positions);
		$html = "<div id=\"" . $blockid . "\" class=\"flexiblemodules ckbloc\" ckresponsive1=\"mobile_notaligned\" ckresponsive2=\"mobile_notaligned\" >
            " . self::addJs($blockid) . "
            <div class=\"ckstyle\"></div>
            <div class=\"inner\">
                <div id=\"" . $blockid . "mod1\" class=\"flexiblemodule ckbloc\" ckmoduleposition=\"" . $positions[0] . "\">
                    " . self::addJs($blockid . "mod1") . "
                    <div class=\"ckstyle\"></div>
                    <div class=\"inner\">
                        <div class=\"tck-module\">
                            " . self::fillNews() . "
                        </div>
                    </div>
                </div>
                <div id=\"" . $blockid . "mod2\" class=\"flexiblemodule ckbloc\" ckmoduleposition=\"" . $positions[1] . "\">
                    " . self::addJs($blockid . "mod2") . "
                    <div class=\"ckstyle\"></div>
                    <div class=\"inner\">
                        <div class=\"tck-module\">
                            " . self::fillNews() . "
                        </div>
                    </div>
                </div>
                <div id=\"" . $blockid . "mod3\" class=\"flexiblemodule ckbloc\" ckmoduleposition=\"" . $positions[2] . "\">
                    " . self::addJs($blockid . "mod3") . "
                    <div class=\"ckstyle\"></div>
                    <div class=\"inner\">
                        <div class=\"tck-module\">
                            " . self::fillNews() . "
                        </div>
                    </div>
                </div>
                <div id=\"" . $blockid . "mod4\" class=\"flexiblemodule ckbloc\" ckmoduleposition=\"" . $positions[3] . "\">
                    " . self::addJs($blockid . "mod4") . "
                    <div class=\"ckstyle\"></div>
                    <div class=\"inner\">
                        <div class=\"tck-module\">
                            " . self::fillNews() . "
                        </div>
                    </div>
                </div>
                <div id=\"" . $blockid . "mod5\" class=\"flexiblemodule ckbloc\" ckmoduleposition=\"" . $positions[4] . "\">
                    " . self::addJs($blockid . "mod5") . "
                    <div class=\"ckstyle\"></div>
                    <div class=\"inner\">
                        <div class=\"tck-module\">
                            " . self::fillNews() . "
                        </div>
                    </div>
                </div>
                <div class=\"clr\"></div>
            </div>
        </div>";
		return $html;
	}

	public static function maincontent($blockid = '', $left = true, $right = true, $maintop = true, $mainbottom = true, $centertop = true, $centerbottom = true) {
		$isdisabledattributes = "";
		$isrighthidden = "";
		$isallhidden = "";
		$isallparenthidden = "";
		$maincontentclass = "";
		$leftdisabled = ($left) ? " isdisabled=\"false\"" : " isdisabled=\"true\"";
		$rightdisabled = ($right) ? " isdisabled=\"false\"" : " isdisabled=\"true\"";
		$maintopdisabled = ($maintop) ? " isdisabled=\"false\"" : " isdisabled=\"true\"";
		$mainbottomdisabled = ($mainbottom) ? " isdisabled=\"false\"" : " isdisabled=\"true\"";
		$centertopdisabled = ($centertop) ? " isdisabled=\"false\"" : " isdisabled=\"true\"";
		$centerbottomdisabled = ($centerbottom) ? " isdisabled=\"false\"" : " isdisabled=\"true\"";
		// main, maincenter, center, content
		$contenthidden = ($centertop && $centerbottom) ? " ishidden=\"false\"" : " ishidden=\"true\"";
		$centerhidden = ($right) ? " ishidden=\"false\"" : " ishidden=\"true\"";
		$maincenterhidden = ($maintop && $mainbottom) ? " ishidden=\"false\"" : " ishidden=\"true\"";
		$mainhidden = ($left) ? " ishidden=\"false\"" : " ishidden=\"true\"";
		$isdisabledattributes .= ($left) ? "" : " isdisabledmodulecolumn1=\"true\"";
		$isdisabledattributes .= ($right) ? "" : " isdisabledmodulecolumn2=\"true\"";
		$isdisabledattributes .= ($maintop) ? "" : " isdisabledmodulemaintop=\"true\"";
		$isdisabledattributes .= ($mainbottom) ? "" : " isdisabledmodulemainbottom=\"true\"";
		$isdisabledattributes .= ($centertop) ? "" : " isdisabledmodulecentertop=\"true\"";
		$isdisabledattributes .= ($centerbottom) ? "" : " isdisabledmodulecenterbottom=\"true\"";
		$maincontentclass .= ($left) ? "" : " noleftcol";
		$maincontentclass .= ($right) ? "" : " norightcol";
		$html = "<div id=\"" . $blockid . "maincontent\" class=\"maincontent ckbloc" . $maincontentclass . "\"" . $isdisabledattributes . " ckresponsive1=\"mobile_notaligned\" ckresponsive2=\"mobile_notaligned\">
            " . self::addJs($blockid . "maincontent") . "
            <div class=\"ckstyle\"></div>
            <div class=\"inner clearfix\">
            <div id=\"" . $blockid . "left\" class=\"column column1 ckbloc\" ckmoduleposition=\"position-7\"" . $leftdisabled . " blocwidth=\"25%\">
                " . self::addJs($blockid . "left") . "
                <div class=\"ckstyle\"></div>
                <div class=\"inner\">
                    <div class=\"tck-module\">
                        " . self::fillMenu() . "
                    </div>
                    <div class=\"tck-module\">
                        " . self::fillNews() . "
                    </div>
				</div>
				<div class=\"ckrowcontainer\" style=\"width:100%;\" data-width=\"100\"></div>
            </div>
            <div id=\"" . $blockid . "main\" class=\"column main ckbloc\"" . $mainhidden . ">
                " . self::addJs($blockid . "main") . "
                <div class=\"ckstyle\"></div>
                <div class=\"inner clearfix\">
					<div id=\"" . $blockid . "maintop\" class=\"maintop ckbloc v34\" " . $maintopdisabled . ">
						<div class=\"ckrowcontainer\" style=\"width:100%;\" data-width=\"100\">
							" . self::singleModule($blockid . "maintopmodule", "maintop") . "
                            </div>
                        </div>
                    <div id=\"" . $blockid . "maincenter\" class=\"maincenter ckbloc\"" . $maincenterhidden . ">
                        " . self::addJs($blockid . "maincenter") . "
                        <div class=\"ckstyle\"></div>
                        <div class=\"inner clearfix\">
                            <div id=\"" . $blockid . "center\" class=\"column center ckbloc\"" . $centerhidden . ">
                                " . self::addJs($blockid . "center") . "
                                <div class=\"ckstyle\"></div>
                                <div class=\"inner\">
                                    <div id=\"" . $blockid . "centertop\" class=\"centertop ckbloc v34\" " . $centertopdisabled . ">
										<div class=\"ckrowcontainer\" style=\"width:100%;\" data-width=\"100\">
											" . self::singleModule($blockid . "centertopmodule", "centertop") . "
                                            </div>
                                        </div>
                                    <div id=\"" . $blockid . "content\" class=\"content ckbloc\"" . $contenthidden . ">
                                        " . self::addJs($blockid . "content") . "
                                        <div class=\"ckstyle\"></div>
                                        <div class=\"inner\">
                                            " . self::fillContent() . "
                                        </div>
                                    </div>
									<div id=\"" . $blockid . "centerbottom\" class=\"centerbottom ckbloc v34\" " . $centerbottomdisabled . ">
										<div class=\"ckrowcontainer\" style=\"width:100%;\" data-width=\"100\">
											" . self::singleModule($blockid . "centerbottommodule", "centerbottom") . "
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <div id=\"" . $blockid . "right\" class=\"column column2 ckbloc\" ckmoduleposition=\"position-6\"" . $rightdisabled . " blocwidth=\"25%\" >
                                " . self::addJs($blockid . "right") . "
                                <div class=\"ckstyle\"></div>
                                <div class=\"inner\">
                                    <div class=\"tck-module\">
                                        " . self::fillNews() . "
                                    </div>
								</div>
								<div class=\"ckrowcontainer\" style=\"width:100%;\" data-width=\"100\"></div>
                            </div>
                            <div class=\"clr\"></div>
                        </div>
                    </div>
                    <div id=\"" . $blockid . "mainbottom\" class=\"mainbottom ckbloc v34\" " . $mainbottomdisabled . ">
						<div class=\"ckrowcontainer\" style=\"width:100%;\" data-width=\"100\">
							" . self::singleModule($blockid . "mainbottommodule", "mainbottom") . "
                            </div>
                        </div>
                    <div class=\"clr\"></div>
                </div>
            </div>
            <div class=\"clr\"></div>
            </div>
        </div>";
		return $html;
	}

	public static function addJs($blockid) {
		return '';
//		$html = "<script type=\"text/javascript\">jQuery(\"#" . $blockid . ",#" . $blockid . " > .inner > .ckrowcontainer\").mouseenter(function() {ckAddEdition(this);});
//        jQuery(\"#" . $blockid . ",#" . $blockid . " > .inner > .ckrowcontainer\").mouseleave(function() {ckRemoveEdition(this);});
//		</script>";
//
//		return $html;
	}

	public static function addMenuCssProps($blockid) {
		$html = '<div class="tab_secondlevellinkactive ckprops" level1itemactivebackgroundpositionend="100" level1itemactivebackgrounddirection="topbottom" level1itemactivebackgroundimageattachment="scroll" level1itemactivebackgroundimagerepeat="no-repeat" level1itemactivebackgroundimagesize="auto" level1itemactivebordertopstyle="solid" level1itemactiveborderrightstyle="solid" level1itemactiveborderbottomstyle="solid" level1itemactiveborderleftstyle="solid" level1itemactivebordersstyle="solid" level1itemactiveshadowinset="0" fieldslist="level1itemactivebackgroundpositionend,level1itemactivebackgrounddirection,level1itemactivebackgroundimageattachment,level1itemactivebackgroundimagerepeat,level1itemactivebackgroundimagesize,level1itemactivealignementleft,level1itemactivealignementcenter,level1itemactivealignementright,level1itemactivealignementjustify,level1itemactivebordertopstyle,level1itemactiveborderrightstyle,level1itemactiveborderbottomstyle,level1itemactiveborderleftstyle,level1itemactivebordersstyle,level1itemactiveshadowinset" data-id="nav"></div>
			<div class="tab_firstlevellinkactive ckprops" level0itemactivebackgroundpositionend="100" level0itemactivebackgrounddirection="topbottom" level0itemactivebackgroundimageattachment="scroll" level0itemactivebackgroundimagerepeat="no-repeat" level0itemactivebackgroundimagesize="auto" level0itemactivebordertopstyle="solid" level0itemactiveborderrightstyle="solid" level0itemactiveborderbottomstyle="solid" level0itemactiveborderleftstyle="solid" level0itemactivebordersstyle="solid" level0itemactiveshadowinset="0" fieldslist="level0itemactivebackgroundpositionend,level0itemactivebackgrounddirection,level0itemactivebackgroundimageattachment,level0itemactivebackgroundimagerepeat,level0itemactivebackgroundimagesize,level0itemactivealignementleft,level0itemactivealignementcenter,level0itemactivealignementright,level0itemactivealignementjustify,level0itemactivebordertopstyle,level0itemactiveborderrightstyle,level0itemactiveborderbottomstyle,level0itemactiveborderleftstyle,level0itemactivebordersstyle,level0itemactiveshadowinset" data-id="nav"></div>
			<div class="tab_moduletitlestyles ckprops" moduletitlebackgroundpositionend="100" moduletitlebackgrounddirection="topbottom" moduletitlebackgroundimageattachment="scroll" moduletitlebackgroundimagerepeat="no-repeat" moduletitlebackgroundimagesize="auto" moduletitlebordertopstyle="solid" moduletitleborderrightstyle="solid" moduletitleborderbottomstyle="solid" moduletitleborderleftstyle="solid" moduletitlebordersstyle="solid" moduletitleshadowinset="0" fieldslist="moduletitlebackgroundpositionend,moduletitlebackgrounddirection,moduletitlebackgroundimageattachment,moduletitlebackgroundimagerepeat,moduletitlebackgroundimagesize,moduletitlealignementleft,moduletitlealignementcenter,moduletitlealignementright,moduletitlealignementjustify,moduletitlebordertopstyle,moduletitleborderrightstyle,moduletitleborderbottomstyle,moduletitleborderleftstyle,moduletitlebordersstyle,moduletitleshadowinset" data-id="nav"></div>
			<div class="tab_blocstyles ckprops" blocbackgroundpositionend="100" blocbackgrounddirection="topbottom" blocbackgroundimageattachment="scroll" blocbackgroundimagerepeat="no-repeat" blocbackgroundimagesize="auto" blocbordertopstyle="solid" blocborderrightstyle="solid" blocborderbottomstyle="solid" blocborderleftstyle="solid" blocbordersstyle="solid" blocshadowinset="0" fieldslist="blocbackgroundpositionend,blocbackgrounddirection,blocbackgroundimageattachment,blocbackgroundimagerepeat,blocbackgroundimagesize,blocalignementleft,blocalignementcenter,blocalignementright,blocalignementjustify,blocbordertopstyle,blocborderrightstyle,blocborderbottomstyle,blocborderleftstyle,blocbordersstyle,blocshadowinset" data-id="nav"></div>
			<div class="tab_thirdlevelcontainer ckprops" level2bgmargintop="-30" level2bgmarginleft="190" fieldslist="level2bgbackgroundpositionend,level2bgbackgrounddirection,level2bgbackgroundimageattachment,level2bgbackgroundimagerepeat,level2bgbackgroundimagesize,level2bgmargintop,level2bgmarginleft,level2bgbordertopstyle,level2bgborderrightstyle,level2bgborderbottomstyle,level2bgborderleftstyle,level2bgbordersstyle,level2bgshadowinset" level2bgbackgroundpositionend="100" level2bgbackgrounddirection="topbottom" level2bgbackgroundimageattachment="scroll" level2bgbackgroundimagerepeat="no-repeat" level2bgbackgroundimagesize="auto" level2bgbordertopstyle="solid" level2bgborderrightstyle="solid" level2bgborderbottomstyle="solid" level2bgborderleftstyle="solid" level2bgbordersstyle="solid" level2bgshadowinset="0" data-id="nav"></div>
			<div class="tab_firstlevellink ckprops" level0itemmargins="2" level0itemmarginright="10" fieldslist="level0itembackgroundpositionend,level0itembackgrounddirection,level0itembackgroundimageattachment,level0itembackgroundimagerepeat,level0itembackgroundimagesize,level0itemalignementleft,level0itemalignementcenter,level0itemalignementright,level0itemalignementjustify,level0itemmarginright,level0itemmargins,level0itempaddingtop,level0itempaddingright,level0itempaddingbottom,level0itempaddingleft,level0itembordertopstyle,level0itemborderrightstyle,level0itemborderbottomstyle,level0itemborderleftstyle,level0itembordersstyle,level0itemshadowinset" level0itembackgroundpositionend="100" level0itembackgrounddirection="topbottom" level0itembackgroundimageattachment="scroll" level0itembackgroundimagerepeat="no-repeat" level0itembackgroundimagesize="auto" level0itempaddingtop="7" level0itempaddingright="10" level0itempaddingbottom="7" level0itempaddingleft="10" level0itembordertopstyle="solid" level0itemborderrightstyle="solid" level0itemborderbottomstyle="solid" level0itemborderleftstyle="solid" level0itembordersstyle="solid" level0itemshadowinset="0" data-id="nav"></div>
			<div class="tab_firstlevellinkhover ckprops" fieldslist="level0itemhoverbackgroundpositionend,level0itemhoverbackgrounddirection,level0itemhoverbackgroundimageattachment,level0itemhoverbackgroundimagerepeat,level0itemhoverbackgroundimagesize,level0itemhoveralignementleft,level0itemhoveralignementcenter,level0itemhoveralignementright,level0itemhoveralignementjustify,level0itemhoverbordertopstyle,level0itemhoverborderrightstyle,level0itemhoverborderbottomstyle,level0itemhoverborderleftstyle,level0itemhoverbordersstyle,level0itemhovershadowinset" level0itemhoverbackgroundpositionend="100" level0itemhoverbackgrounddirection="topbottom" level0itemhoverbackgroundimageattachment="scroll" level0itemhoverbackgroundimagerepeat="no-repeat" level0itemhoverbackgroundimagesize="auto" level0itemhoverbordertopstyle="solid" level0itemhoverborderrightstyle="solid" level0itemhoverborderbottomstyle="solid" level0itemhoverborderleftstyle="solid" level0itemhoverbordersstyle="solid" level0itemhovershadowinset="0" data-id="nav"></div>
			<div class="tab_secondlevelcontainer ckprops" level1bgbackgroundcolorstart="#ffffff" level1bgwidth="200" fieldslist="level1bgbackgroundcolorstart,level1bgbackgroundpositionend,level1bgbackgrounddirection,level1bgbackgroundimageattachment,level1bgbackgroundimagerepeat,level1bgbackgroundimagesize,level1bgwidth,level1bgbordertopstyle,level1bgborderrightstyle,level1bgborderbottomstyle,level1bgborderleftstyle,level1bgbordersstyle,level1bgshadowcolor,level1bgshadowblur,level1bgshadowinset" level1bgbackgroundpositionend="100" level1bgbackgrounddirection="topbottom" level1bgbackgroundimageattachment="scroll" level1bgbackgroundimagerepeat="no-repeat" level1bgbackgroundimagesize="auto" level1bgbordertopstyle="solid" level1bgborderrightstyle="solid" level1bgborderbottomstyle="solid" level1bgborderleftstyle="solid" level1bgbordersstyle="solid" level1bgshadowcolor="#c7c7c7" level1bgshadowblur="8" level1bgshadowinset="0" data-id="nav"></div>
			<div class="tab_secondlevellink ckprops" fieldslist="level1itembackgroundpositionend,level1itembackgrounddirection,level1itembackgroundimageattachment,level1itembackgroundimagerepeat,level1itembackgroundimagesize,level1itemalignementleft,level1itemalignementcenter,level1itemalignementright,level1itemalignementjustify,level1itempaddingtop,level1itempaddingright,level1itempaddingbottom,level1itempaddingleft,level1itembordertopstyle,level1itemborderrightstyle,level1itemborderbottomstyle,level1itemborderleftstyle,level1itembordersstyle,level1itemshadowinset" level1itembackgroundpositionend="100" level1itembackgrounddirection="topbottom" level1itembackgroundimageattachment="scroll" level1itembackgroundimagerepeat="no-repeat" level1itembackgroundimagesize="auto" level1itempaddingtop="7" level1itempaddingright="10" level1itempaddingbottom="7" level1itempaddingleft="10" level1itembordertopstyle="solid" level1itemborderrightstyle="solid" level1itemborderbottomstyle="solid" level1itemborderleftstyle="solid" level1itembordersstyle="solid" level1itemshadowinset="0" data-id="nav"></div>
			<div class="tab_secondlevellinkhover ckprops" level1itemhoverbackgroundcolorstart="#f0f0f0" fieldslist="level1itemhoverbackgroundcolorstart,level1itemhoverbackgroundpositionend,level1itemhoverbackgrounddirection,level1itemhoverbackgroundimageattachment,level1itemhoverbackgroundimagerepeat,level1itemhoverbackgroundimagesize,level1itemhoveralignementleft,level1itemhoveralignementcenter,level1itemhoveralignementright,level1itemhoveralignementjustify,level1itemhoverbordertopstyle,level1itemhoverborderrightstyle,level1itemhoverborderbottomstyle,level1itemhoverborderleftstyle,level1itemhoverbordersstyle,level1itemhovershadowinset" level1itemhoverbackgroundpositionend="100" level1itemhoverbackgrounddirection="topbottom" level1itemhoverbackgroundimageattachment="scroll" level1itemhoverbackgroundimagerepeat="no-repeat" level1itemhoverbackgroundimagesize="auto" level1itemhoverbordertopstyle="solid" level1itemhoverborderrightstyle="solid" level1itemhoverborderbottomstyle="solid" level1itemhoverborderleftstyle="solid" level1itemhoverbordersstyle="solid" level1itemhovershadowinset="0" data-id="nav"></div>
			';
		return $html;
	}

	public static function addMenuCKStyles($blockid) {
		$html = '#' . $blockid . ' ul.menu, #' . $blockid . ' ul.maximenuck {
            margin: 0;
            padding: 0;
}

#' . $blockid . ' ul.menu li, #' . $blockid . ' ul.maximenuck li  {
	margin: 0;
	padding: 0;
	display: inline-block;
	list-style:none;
}

#' . $blockid . ' ul.menu li li, #' . $blockid . ' ul.maximenuck li li {
	float: none;
	display: block;
}

#' . $blockid . ' ul.menu > li > a, #' . $blockid . ' ul.menu > li > span.separator,
#' . $blockid . ' ul.maximenuck > li > a, #' . $blockid . ' ul.maximenuck > li > span.separator{
    display:block;
	margin: 2px;
	margin-right: 10px;
	padding-top: 7px;
	padding-right: 10px;
	padding-bottom: 7px;
	padding-left: 10px;
}

#' . $blockid . ' ul.menu > li:hover > a, #' . $blockid . ' ul.menu > li:hover > span.separator,
#' . $blockid . ' ul.maximenuck > li:hover > a, #' . $blockid . ' ul.maximenuck > li:hover > span.separator {
}

#' . $blockid . ' ul.menu > li.active > a, #' . $blockid . ' ul.menu > li.active > span.separator,
#' . $blockid . ' ul.maximenuck > li.active > a, #' . $blockid . ' ul.maximenuck > li.active > span.separator {
}

#' . $blockid . ' ul.menu li li a, #' . $blockid . ' ul.menu li li span.separator,
#' . $blockid . ' ul.maximenuck li li a, #' . $blockid . ' ul.maximenuck li li span.separator {
    display:block;
	padding-top: 7px;
	padding-right: 10px;
	padding-bottom: 7px;
	padding-left: 10px;
}

#' . $blockid . ' ul.menu li li:hover > a, #' . $blockid . ' ul.menu li li:hover span.separator,
#' . $blockid . ' ul.maximenuck li li:hover > a, #' . $blockid . ' ul.maximenuck li li:hover span.separator {
	background: #f0f0f0;
}

#' . $blockid . ' ul.menu li li.active > a, #' . $blockid . ' ul.menu li li.active span.separator,
#' . $blockid . ' ul.maximenuck li li.active > a, #' . $blockid . ' ul.maximenuck li li.active span.separator{
}

/* code pour menu normal */
#' . $blockid . ' ul.menu li ul, #' . $blockid . ' ul.menu li:hover ul ul, #' . $blockid . ' ul.menu li:hover ul ul ul {
	position: absolute;
	left: -999em;
	z-index: 999;
        margin: 0;
        padding: 0;
	background: #ffffff;
	width: 200px;
	box-shadow: #c7c7c7 0px 0px 8px 0px;
	-moz-box-shadow: #c7c7c7 0px 0px 8px 0px;
	-webkit-box-shadow: #c7c7c7 0px 0px 8px 0px;
}


#' . $blockid . ' ul.menu li:hover ul ul, #' . $blockid . ' ul.menu li:hover li:hover ul ul, #' . $blockid . ' ul.menu li:hover li:hover li:hover ul ul,
#' . $blockid . ' ul.menu li.sfhover ul ul, #' . $blockid . ' ul.menu li.sfhover ul.sfhover ul ul, #' . $blockid . ' ul.menu li.sfhover ul.sfhover ul.sfhover ul ul {
	left: -999em;
}

#' . $blockid . ' ul.menu li:hover > ul, #' . $blockid . ' ul.menu li:hover ul li:hover > ul, #' . $blockid . ' ul.menu li:hover ul li:hover ul li:hover > ul, #' . $blockid . ' ul.menu li:hover ul li:hover ul li:hover ul li:hover > ul,
#' . $blockid . ' ul.menu li.sfhover ul, #' . $blockid . ' ul.menu li.sfhover ul li.sfhover ul, #' . $blockid . ' ul.menu li.sfhover ul li.sfhover ul li.sfhover ul, #' . $blockid . ' ul.menu li.sfhover ul li.sfhover ul li.sfhover ul li.sfhover ul {
	left: auto;
}

#' . $blockid . ' ul.menu li:hover ul li:hover ul {
	margin-top: -30px;
	margin-left: 190px;
}

/* fin code normal */

#' . $blockid . ' ul.maximenuCK li ul, #' . $blockid . ' ul.maximenuCK li:hover ul ul, #' . $blockid . ' ul.maximenuCK li:hover ul ul ul,
#' . $blockid . ' ul.maximenuck li ul, #' . $blockid . ' ul.maximenuck li:hover ul ul, #' . $blockid . ' ul.maximenuck li:hover ul ul ul {
	position: static !important;
	left: auto !important;
	background: transparent !important;
	border-radius: 0 !important;
    border: none !important;
	-moz-border-radius: 0 !important;
	-o-border-radius:  0 !important;
	-webkit-border-radius: 0 !important;
	width: 100% !important;
	box-shadow: none !important;
	-moz-box-shadow: none !important;
	-webkit-box-shadow: none !important;
}

#' . $blockid . ' ul.maximenuCK li ul ul,
#' . $blockid . ' ul.maximenuck li ul ul {
	margin: 0 !important;
}

#' . $blockid . ' li div.maxidrop-main {
	width: 200px;
}

#' . $blockid . ' li div.floatCK,
#' . $blockid . ' li div.floatck {
	background: #ffffff;
	box-shadow: #c7c7c7 0px 0px 8px 0px;
	-moz-box-shadow: #c7c7c7 0px 0px 8px 0px;
	-webkit-box-shadow: #c7c7c7 0px 0px 8px 0px;
}

#' . $blockid . ' ul li ul.maximenuCK2,
#' . $blockid . ' ul li ul.maximenuck2 {
    margin: 0;
    padding: 0;
}

#' . $blockid . ' ul li div.maximenuCK2,
#' . $blockid . ' ul li div.maximenuck2 {
    float: left;
    width: 100%;
}

#' . $blockid . ' li div.maxidrop-main div.maxidrop-main {
}

#' . $blockid . ' ul li.maximenuCK div.floatCK div.floatCK,
#' . $blockid . ' ul li.maximenuck div.floatck div.floatck {
	margin-top: -30px;
	margin-left: 190px;
}

#' . $blockid . ' span.descCK,
#' . $blockid . ' span.descck {
    display: block;
    line-height: 10px;
}

#' . $blockid . ' ul.menu li li {
    float: none;
    display: block;
} ';

		return $html;
	}

	public static function fillLoginform() {
		$html = "<h3>Login Form</h3>
            <form id=\"login-form\" class=\"form-inline\">
                <div class=\"userdata\">
                    <div id=\"form-login-username\" class=\"control-group\">
                        <div class=\"controls\">
                            <div class=\"input-prepend input-append\">
                                <span class=\"add-on\"><span class=\"icon-user tip\" title=\"User Name\"></span><label for=\"modlgn-username\" class=\"element-invisible\">User Name</label></span>
                                <input id=\"modlgn-username\" type=\"text\" name=\"username\" class=\"input-small\" tabindex=\"1\" size=\"18\" placeholder=\"User Name\" />
                            </div>
                        </div>
                    </div>
                    <div id=\"form-login-password\" class=\"control-group\">
                        <div class=\"controls\">
                            <div class=\"input-prepend input-append\">
                                <span class=\"add-on\"><span class=\"icon-lock tip\" title=\"Password\"></span><label for=\"modlgn-passwd\" class=\"element-invisible\">Password</label></span>
                                <input id=\"modlgn-passwd\" type=\"password\" name=\"password\" class=\"input-small\" tabindex=\"2\" size=\"18\" placeholder=\"Password\" />

                            </div>
                        </div>
                    </div>
                    <div id=\"form-login-remember\" class=\"control-group checkbox\">
                        <label for=\"modlgn-remember\" class=\"control-label\">Remember Me</label> <input id=\"modlgn-remember\" type=\"checkbox\" name=\"remember\" class=\"inputbox\" value=\"yes\"/>
                    </div>
                    <div id=\"form-login-submit\" class=\"control-group\">
                        <div class=\"controls\">
                            <input type=\"button\" tabindex=\"3\" name=\"\" class=\"btn btn-primary btn\" value=\"Log in\" />
                        </div>
                    </div>
                    <ul class=\"unstyled\">
                        <li>
                            <a href=\"javascript:void(0);\">
                            Create an account <span class=\"icon-arrow-right\"></span></a>
                        </li>
                    </ul>
                </div>
            </form>";

		return $html;
	}

	static function fillContent() {

		$html = "<div>
						<h1>H1 title</h1>
						<h2>H2 title</h2>
						<h3>H3 title</h3>
						<h4>H4 title</h4>
						<h5>H5 title</h5>
						<h6>H6 title</h6>
						<p>Lorem ipsum dolor sit amet. <a href=\"javascript:void(0)\">Here is a link!</a></p>
						<ul>
							<li>Lorem</li>
							<li>Ipsum</li>
							<li>Dolor</li>
							<li>Consectetur</li>
						</ul>
						<h3>Example table</h3>
						<table class='table'>
							  <thead>
								<tr>
								  <th>#</th>
								  <th>First Name</th>
								  <th>Last Name</th>
								  <th>Username</th>
								</tr>
							  </thead>
							  <tbody>
								<tr>
								  <td>1</td>
								  <td>Mark</td>
								  <td>Otto</td>
								  <td>@mdo</td>
								</tr>
								<tr>
								  <td>2</td>
								  <td>Jacob</td>
								  <td>Thornton</td>
								  <td>@fat</td>
								</tr>
								<tr>
								  <td>3</td>
								  <td>Larry</td>
								  <td>the Bird</td>
								  <td>@twitter</td>
								</tr>
							  </tbody>
						</table>
						<h3>Example forms</h3>
						<div>
							<input type=\"text\">Text input
						</div>
						<br />
						<div>
							<input type=\"checkbox\" value=\"option1\">Option one
						</div>
						<br />
						<div>
							<select>
								<option>something</option>
								<option>2</option>
								<option>3</option>
								<option>4</option>
								<option>5</option>
							</select>
						</div>
						<br />
						<div>
							<textarea rows=\"3\"></textarea>
						</div>
						<div>
							<button type=\"submit\" class=\"button\">I'm a button</button>
						</div>
						<div>
							<p class=\"readmore\">
									<a class=\"btn\" href=\"javascript:void(0)\" >
									<span class=\"icon-chevron-right\"></span> 
									Read more: 			Example		</a>
							</p>
						</div>
				</div>";
		return $html;
	}

	static function fillMenu() {
		$html = "<h3>Menu</h3>
				<div class=\"tck-module-text\">
                    <ul class=\"nav menu\">
                        <li class=\"item-437\"><a href=\"javascript:void(0);\" >Eget luctus</a></li>
                        <li class=\"item-280 parent\"><a href=\"javascript:void(0);\" >Leo congue</a></li>
                        <li class=\"item-278\"><a href=\"javascript:void(0);\" >Libero eget urna</a></li>
                        <li class=\"item-279\"><a href=\"javascript:void(0);\" >Molestie scelerisque</a></li>
                    </ul>
				</div>";
		return $html;
	}

	static function fillHorizmenu() {
		$html = "<div class=\"tck-module-text\">
			<ul class=\"nav menu\">
                <li id=\"item-435\" class=\"current active\"><a href=\"javascript:void(0);\">Nullam luctus</a></li>
                <li><a href=\"javascript:void(0);\">Vestibulum et neque</a></li>
                <li class=\"deeper parent\"><a href=\"javascript:void(0);\">Etiam feugiat</a>
                    <ul>
                        <li><a href=\"javascript:void(0);\">Aenean luctus</a></li>
                        <li class=\"deeper parent\"><a href=\"javascript:void(0);\">Nullam eu elit</a>
                            <ul>
                                <li id=\"item-475\"><a href=\"javascript:void(0);\">Phasellus tincidunt</a></li>
                            </ul>
                        </li>
                        <li id=\"item-439\"><a href=\"javascript:void(0);\">Morbi eget justo</a></li>
                    </ul>
                </li>
                <li id=\"item-448\"><a href=\"javascript:void(0);\">Donec</a></li>
            </ul>
		</div>";
		return $html;
	}

	static function fillNews() {
		$html = "<h3>Title</h3>
                <div class=\"tck-module-text\">
					<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed molestie scelerisque ultrices. Nullam venenatis, felis ut accumsan vestibulum, diam leo congue nisl, eget luctus sapien libero eget urna. Duis ac pellentesque nisi.</p>
				</div>";
		return $html;
	}

}
