<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKController;

class TemplateckControllerInterface extends CKController {

	protected $interface;

	protected $imagespath;

	/**
	 * Load the needed interface
	 * 
	 * @return void
	 */
	public function load() {
		// security check
		TemplateckHelper::checkAjaxToken();

		$layout = $this->input->get('layout', '', 'cmd');
		if (! $layout) return;

		$this->interface = new CKInterface();
		$this->imagespath = TEMPLATECREATORCK_MEDIA_URI . '/images/interface/';

		require_once(TEMPLATECREATORCK_PATH . '/interfaces/' . strtolower($layout) . '.php');
		exit;
	}
}