/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

var $ck = jQuery.noConflict();
var facktoload = false;
var editor_customcss_responsive = new Array();

// Only define the TCK namespace if not defined.
TCK = window.TCK || {};

TCK.Text = {
	strings: {},
	'_': function(key, def) {
		return typeof this.strings[key.toUpperCase()] !== 'undefined' ? this.strings[key.toUpperCase()] : def;
	},
	load: function(object) {
		for (var key in object) {
			this.strings[key.toUpperCase()] = object[key];
		}
		return this;
	}
};

function ckInitInterface() {
	ckConvertOldMaincontent();
	$ck('.ckbloc, .ckrowcontainer', $ck('#body')).each(function(i, bloc) {
		ckAddControlsOnHover(bloc);
	});
	$ck('.alert-message > a.close').click(function() {
		$ck(this).parent().remove();
	});

	ckFixBC();
	ckCheckExpertModeOnPageload();
	ckToggleBootstrap(); // Bootstrap fait chier
	ckInitSortables();
	//	ckAddFixedTopbar();
	ckConvertOldBanner();
	ckFixSources();
	ckFixRowContainerBC();
	ckInitTooltip();
	ckInitOptionsSliders();
	ckSeparateStylesForBlocks(); // for B/C, convert the existing blocks
	ckaddEventOnInfos();
	ckInitOptionsSliders($ck('#cklibraryelements'));
	ckInitGoogleFonts();

	// new features from v5
	ckInitLeftPanel();
	ckPreviewFillLayoutInterface(); // list the items in the left panel for creation mode
	ckInitOptionsSliders($ck('#ckinterfacesliderparent'));
	ckInitOptionsSliders($ck('#ckinterfaceslideraddons'));
	ckInitOptionsSlidersOver();
	ckInitOptionsAccordions();
	ckInitColorPickers();
	// ckInitTooltip(); // TODO : utiliser CKAPI.tooltip
	ckAddEventOnFields($ck('#menuck'), '');
}

var ckLeftPanelInitiated = false;
function ckInitLeftPanel() {
	ckCloseSliderOverTab();
	ckClosePreviewEdition();
	if (ckLeftPanelInitiated === true) return;
	$ck('.menuckpanel').click(function() {
		ckRemoveQuickStyles();
		var dataTarget = $ck(this).attr('data-target');
		// save responsive edition if it was the previous state
		if ($ck('.menuckpanel.active[data-target="responsive"]').length) {
			ckSaveResponsivePopup();
		}
		ckCloseSliderOverTab();
		ckClosePreviewEdition();
		if (dataTarget != 'settings') ckMoveInfosInForm(); // we need to move the infos in the form else we will loose them
		if (! $ck(this).attr('data-void')) ckActivatePanel(dataTarget);
		if ($ck(this).attr('data-interface')) {
			var target = $ck('.menuckpaneltarget[data-target="' + $ck(this).attr('data-target') + '"]');
			ckLoadInterface($ck(this).attr('data-interface'), target);
		} else if ($ck(this).attr('data-func')) {
			var func = $ck(this).attr('data-func');
			if (typeof(window[func]) == 'function') window[func]();
		}
		$ck('.ckelementsedition[data-target="actions"] .ckbutton').removeClass('active');
	});
	$ck('.ckelementsedition[data-target="actions"] .ckbutton').click(function() {
		if ($ck(this).hasClass('active')) {
			$ck('.ckelementsedition[data-target="actions"] .ckbutton').removeClass('active');
		} else if ($ck(this).hasClass('ckactivable')) {
			$ck('.ckelementsedition[data-target="actions"] .ckbutton').removeClass('active');
			$ck(this).addClass('active');
		}
	});
	ckLeftPanelInitiated = true;
}


function ckFixBC() {
	$ck('#body').addClass('body');
	$ck('.moduletable').addClass('tck-module');
	$ck('.widget').addClass('tck-module');
	$ck('.container').addClass('tck-container');
//		.removeClass('container');
	$ck('.container-fluid').addClass('tck-container-fluid');
	// since 4.0.19
//	$ck('.tck-container-fluid').addClass('tck-container').removeClass('tck-container-fluid');
	$ck('.flexiblemodules > .inner, .ckrow > .inner').removeClass('clearfix');

	
	var patt = new RegExp("\<h3\>Module\<\/h3\>");
	if (
		$ck('.mainbanner').length 
		|| 
		patt.test($ck('#body').html())
		) {
		alert('Warning : An old version has been detected. Your template will be automatically converted.');
		$ck('#body h3').text('Title');
		$ck('.ckstyle > style').each(function() {
			$ck(this).html($ck(this).html().replace('url(/images', 'url(' + URIROOT + '/images'));
		});
		// replace the maincontent
		var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxbcmaincontent&" + CKTOKEN;
		$ck.ajax({
			type: "POST",
			url: myurl
		}).done(function(code) {
			$ck('#body .maincontent').after(code).remove();
			$ck('#body .maincontent, #body .maincontent .ckbloc, #body .maincontent .ckrowcontainer').each(function(i, bloc) {
				ckAddControlsOnHover(bloc);
			});
		}).fail(function(code) {
			alert(TCK.Text._('CK_FAILED', 'Failed'));
		});
		// replace the banner
		var oldbanner = $ck('#body .mainbanner');
		var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxbcbanner&" + CKTOKEN;
		$ck.ajax({
			type: "POST",
			url: myurl,
			data: {
				blockid : oldbanner.attr('id') + 'new'
			}
		}).done(function(code) {
//			oldbanner.after(code);
//			oldbanner.find('> .inner > div:not(.clr)').each(function(i) {
//				$ck(this).css('width', '');
//				$ck('#' + oldbanner.attr('id') + 'new').find('.ckrowcontainer').eq(i).append($ck(this));
//			});
//			oldbanner.remove();
//			$ck('#body .maincontent, #body .maincontent .ckbloc, #body .maincontent .ckrowcontainer').each(function(i, bloc) {
//				ckAddControlsOnHover(bloc);
//			});
		}).fail(function(code) {
			alert(TCK.Text._('CK_FAILED', 'Failed'));
		});
	}

	// B/C for article details
//	if ($ck('.ckstylecontainer[data-id="body"] .tab_articledetailsstyles').length) {
//		alert('INFO : you are using the old styles in "Page >> Content >> Article details". Please move your styles to "Layouts >> Article >> Details"');
//		let detailsmoved = confirm('Have you moved your styles ? If yes, then the old styles will be removed and this message will disappear');
//		if (detailsmoved) {
//			alert('ok! ');
//			$ck('.ckstylecontainer[data-id="body"] .tab_articledetailsstyles').remove();
//		}
//		if ($ck('.ckstylecontainer[data-id="ckcustomlayoutarticle"]').length) {
//			console.log('details layout already exist')
//		}
//	}
}

function ckInitGoogleFonts() {
	var bodyfontsprops = ckGetPropsForBloc('body', 'googlefonts');
	var fontslist = bodyfontsprops.attr('fontslist') ? bodyfontsprops.attr('fontslist') : '';
	fontslist = fontslist ? fontslist.split(',')  : new Array();
	for (var i=0; i < fontslist.length; i++) {
		ckAddGooglefontStylesheet(fontslist[i]);
	}
}
function ckaddEventOnInfos() {
	$ck('#ckinfospopup input, #ckinfospopup textarea').change(function() {
		this.value = this.value.replace('&', '');
	});
}
/* Method that will fix the path for elements when moving between domains/servers */
function ckFixSources() {
	$ck('[data-src]').each(function() {
		if ($ck(this).attr('src') != URIROOT + $ck(this).attr('data-src'))
			$ck(this).attr('src', URIROOT + $ck(this).attr('data-src'));
	});
}

/* Method introduced after the 3.4 version to update the old banners */
function ckConvertOldBanner() {
	$ck('.ckrowcontainer > .bannerlogo').css('width','auto').find('.tab_blocstyles').attr('blocwidth', '');
}

/* Method introduced after the 3.4 version to update the old maincontent */
function ckConvertOldMaincontent() {
	$ck('.column1,.column2').each(function() {
		if( ! $ck(this).find('.ckrowcontainer').length) {
			$ck(this).append('<div class="ckrowcontainer"></div>');
		}
	});
}


function ckSeparateStylesForBlocks() {
	$ck('#cktemplatecontainer .ckbloc').each(function() {
		var block = $ck(this);
		if (block.find('> .ckstyle').length || block.find('> .ckprops').length) {
			ckSeparateStylesForBlock(this.id);
		}
	});
}

/* separate the styles elements in the page 
 * NOTE : must use block and not blockid to get the reference of the element when using ckAddBlock
 * isinstance : true to set if we pass a jQuery instance of the object or only the ID
 * */
function ckSeparateStylesForBlock(blocid, isinstance) {
	if (! isinstance) isinstance = false;
	var block = isinstance ? blocid : $ck('#' +blocid);
	blocid = !isinstance ? blocid : block.attr('id');
	// if no styles to separate, exit
	if (! block.find('> .ckstyle').length && ! block.find('> .ckprops').length) return;

	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	// add ckstyle
	if (block.find('> .ckstyle').length) {
		var blockckstyle = block.find('> .ckstyle');
		ckSetStyleForBloc(blocid, blockckstyle.html());
		blockckstyle.remove();
	}

	// add properties
	if (block.find('> .ckprops').length) {
		var blockckprops = block.find('> .ckprops');
		styleswrapper.find('> .ckprops').remove();
		blockckprops.each(function() {
			styleswrapper.append($ck(this));
//			$ck(this).remove();
		});
	}
}
/* return the wrapper for ckstyle and ckprops for the bloc ID */
function ckGetStylesWrapperForBlock(blocid) {
	if (! $ck('.ckstylecontainer[data-id="' + blocid + '"]', $ck('#ckstylescontainer')).length) $ck('#ckstylescontainer').append('<div class="ckstylecontainer" data-id="' + blocid + '"></div>');
	return $ck('.ckstylecontainer[data-id="' + blocid + '"]', $ck('#ckstylescontainer'));
}
/* create the div that wraps the ckstyle and ckprops for the bloc ID */
//function ckCreateStylesWrapperForBlock(block) {
//	var blocid = block.attr('id');
//	var ckstylescontainer = $ck('#ckstylescontainer');
//	var blockstylecontainer = $ck('<div class="ckstylecontainer" data-id="' + blocid + '"></div>');
//	ckstylescontainer.append(blockstylecontainer);
//}

/* create new styles elements for the new block */
function ckDuplicateStylesForBlock(blocid, newid) {
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var copy = styleswrapper.clone();
	copy.attr('data-id', newid);
	$ck('#ckstylescontainer').append(copy);
	var newstyleswrapper = ckGetStylesWrapperForBlock(newid);
	ckReplaceStyleId(newstyleswrapper, blocid, newid);
}

function ckReplaceStyleId(wrapper, oldID, newID) {
	var re = new RegExp(oldID, 'g');
	var stylecontainer = ckGetStyleForBloc(newID);
	stylecontainer.html(stylecontainer.html().replace(re,newID));
	wrapper.attr('data-id', newID);
}
/* remove the wrapper and all inside */
function ckRemoveStylesForBlock(blocid) {
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	styleswrapper.remove();
}
/* return the ckstyle element for the bloc ID */
function ckGetStyleForBloc(blocid) {
	// ckstyleresponsive ckresponsiverange4
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var rangeNumber = ckGetResponsiveRangeNumber();
	var variationNumber = ckGetVariationRangeNumber();
	if (rangeNumber && rangeNumber !== '5') {
		var selector = '.ckstyleresponsive.ckresponsiverange' + rangeNumber;
		var responsiveClass = 'ckresponsiverange' + rangeNumber + ' ckstyleresponsive';
	} else if (variationNumber && variationNumber !== '0') {
		var selector = '.ckstylevariation.ckvariationrange' + variationNumber;
		var responsiveClass = 'ckvariationrange' + variationNumber + ' ckstylevariation';
	} else {
		var selector = '> .ckstyle';
		var responsiveClass = 'ckstyle';
	}
//	var selector = (rangeNumber && rangeNumber !== '5') ||  ? '.ckstyleresponsive.ckresponsiverange' + rangeNumber : '> .ckstyle';
//	var responsiveClass = rangeNumber && rangeNumber !== '5' ? 'ckresponsiverange' + rangeNumber + ' ckstyleresponsive' : 'ckstyle';
	if (! styleswrapper.find(selector).length) styleswrapper.append('<div class="' + responsiveClass + '"></div>');
	return styleswrapper.find(selector);
}

/* set the css code in the ckstyle element for the bloc ID */
function ckSetStyleForBloc(blocid, csscode, merge) {
	if (!merge) merge = false;
	var stylecontainer = ckGetStyleForBloc(blocid);
	if (merge == true) {
		stylecontainer.append(csscode);
	} else {
		stylecontainer.empty().append(csscode);
	}
}

/* return the ckprops element for the bloc ID */
function ckGetPropsForBloc(blocid, tabid) {
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var responsiveRangeNumber = ckGetResponsiveRangeNumber();
	var variationRangeNumber = ckGetVariationRangeNumber();
	if (responsiveRangeNumber&& responsiveRangeNumber !== '5') {
		var tabSelector = '_ckresponsiverange' + responsiveRangeNumber +'.ckresponsive' + responsiveRangeNumber;
		var tabClass = '_ckresponsiverange' + responsiveRangeNumber + ' ckresponsive ckresponsive' + responsiveRangeNumber;
	} else if (variationRangeNumber&& variationRangeNumber !== '0') {
		var tabSelector = '_ckvariationrange' + variationRangeNumber +'.ckvariation' + variationRangeNumber;
		var tabClass = '_ckvariationrange' + variationRangeNumber + ' ckvariation ckvariation' + variationRangeNumber;
	} else {
		var tabSelector = '';
		var tabClass = '';
	}
		// example of responsive tab : tab_labelstyles_ckresponsiverange4 ckprops ckresponsive ckresponsive4
	if (! styleswrapper.find('> .ckprops.' + tabid + tabSelector).length) styleswrapper.append('<div class="' + tabid + tabClass + ' ckprops" />');

	return styleswrapper.find('> .ckprops.' + tabid + tabSelector);
}

/* fill the ckprops element with the options values, remove the unused */
function ckSaveEditionFields(focusprop, tabid) {
	$ck('.inputbox', $ck('[data-id="' + tabid + '"]')).each(function(i, field) {
		field = $ck(field);
		if (field.attr('type') != 'radio') {
			if (field.attr('value') && field.attr('value') != 'default') {
				focusprop.attr(field.attr('id'), field.attr('value'));
			} else {
				focusprop.removeAttr(field.attr('id'));
			}
		} else {
			if (field.attr('checked')) {
				focusprop.attr(field.attr('id'), 'checked');
			} else {
				focusprop.removeAttr(field.attr('id'));
			}
		}
	});
}

/* create the list of fields that are used in the edition to store on the ckprops element */
function ckGetEditionFieldslist(focus, tabid) {
	fieldslist = new Array();
	$ck('.inputbox', $ck('[data-id="' + tabid + '"]')).each(function(i, el) {
		if ($ck(el).attr('value') && $ck(el).attr('value') != 'default')
			fieldslist.push($ck(el).attr('id'));
	});
	if (tabid == 'tab_blocstyles' && (focus.hasClass('bannerlogo') || focus.hasClass('banner') || focus.hasClass('bannermenu')) )
		fieldslist.push('blocwidth');
	return fieldslist.join(',');
}

function ckAddFixedTopbar(){
	$ck(window).bind('scroll resize load', function() {
		if ($ck(window).scrollTop() > $ck('#ckleftpanel').offset().top) {
			$ck('#ckleftpanel')
				.addClass('floating')
				.css({'position' : 'fixed', 'top': '0', 'height': ''})
				.before('<div id="ckleftpanel_tmp" style="height:0px;"></div>');
		} else if ($ck('#ckleftpanel_tmp').length && $ck(window).scrollTop() < $ck('#ckleftpanel_tmp').offset().top){
			$ck('#ckleftpanel_tmp').remove();
			$ck('#ckleftpanel')
				.removeClass('floating')
				.css({'position' : 'absolute', 'top': '', height: ($ck(window).height() - $ck('#ckleftpanel').offset().top + $ck(window).scrollTop()) + 'px'});
		} else if(! $ck('#ckleftpanel').hasClass('floating')) {
			$ck('#ckleftpanel')
				.css({'top': '', height: ($ck(window).height() - $ck('#ckleftpanel').offset().top + $ck(window).scrollTop()) + 'px'});
		}
	});
}
/* Functions to manage colors conversion */
function ckHexToR(h) {
	return parseInt((ckCutHex(h)).substring(0, 2), 16)
}
function ckHexToG(h) {
	return parseInt((ckCutHex(h)).substring(2, 4), 16)
}
function ckHexToB(h) {
	return parseInt((ckCutHex(h)).substring(4, 6), 16)
}
function ckCutHex(h) {
	return (h.charAt(0) == "#") ? h.substring(1, 7) : h
}
function ckHexToRGB(h) {
	return 'rgb(' + ckHexToR(h) + ',' + ckHexToG(h) + ',' + ckHexToB(h) + ')';
}

/* Repeat the strings n times */
function ckStrRepeat(text, times){
	var result='';
	while (times > 0) {
		if (times&1)
			result+=text;
		times>>=1;
		text+=text;
	}
	return result;
}

function ckSetPaletteColors() {
	var colors = new Array();
	$ck('#ckcolorspalette .colorPicker').each(function() {
		colors.push($ck(this).val().replace('#', ''));
	});
	colors = colors.join(',');
	ckSetPaletteOnColorPicker(colors, 'colpick_palette');
}

function ckSetPaletteOnColorPicker(colors, object) {
	CKBox.close();
	colors = colors.split(',');
	$ck('span',$ck('#'+object)).each(function(i, el) {
		$ck(el).css('background-color', '#'+colors[i]);
	});
	$ck('#body').attr('colorpalette', colors);
}

function ckOnSortStart(ui) {
	ui.helper.find('.editorck').hide();
	ui.helper.addClass('cksorting');
	// reduce the big elements for better visibility
	if (ui.item.hasClass('maincontent') || ui.item.hasClass('wrapper')) {
		ui.placeholder.addClass('cksorting');
	}
	if (ui.item.hasClass('wrapper') || ui.item.hasClass('cklibraryitemwrapper')) {
		$ck('.wrapper:not(.blocselect)').addClass('cksorting');
	}
}

function ckOnSortStop(ui) {
	ui.item.removeClass('cksorting');
	$ck('.cksorting').removeClass('cksorting');
	ckSaveAction();
}

function ckInitSortables() {
	$ck("#body").sortable({
		items: ".wrapper",
		axis: "y",
		handle: "> .editorck .controlMove",
		forcePlaceholderSize: true,
		forceHelperSize: true,
		dropOnEmpty: true,
//		tolerance: "pointer",
		placeholder: "ckplaceholder",
		zIndex: 999999,
		sort: function( event, ui ) {
			$ck("#body").sortable('refreshPositions');
//			ckOnSortStart(ui);
		},
		receive: function( event, ui ) {
			var newblock = $ck(this).find('.blocselect');
			if (ui.sender.hasClass('dragtoaddwrapper')) {
				newblock.css('float', 'none').addClass('ckwait');
				ckCreateWrapperBloc(newblock);
			} else if (ui.sender.hasClass('ckdragtoaddelement')) {
				var newblock = $ck(this).find('.ckdragtoaddelement');
				newblock.css('float', 'none').addClass('ckwait');
				ckLoadLibraryElement(newblock);
			} else {
				newblock.remove();
			}
		},
		stop: function( event, ui ) {
//			ckOnSortStop(ui);
			ckPreviewFillLayoutInterface()
		},
		out: function( event, ui ) {
//			ckOnSortStop(ui);
		}
	});
	
	$ck( ".wrapper > .inner" ).sortable({
		items: "> .ckbloc",
		// containment: "parent",
		// axis: "y",
		connectWith: ".wrapper > .inner",
//		connectWith: ".wrapper > .inner, .ckrowcontainer",
		tolerance: "pointer",
		handle: "> .editorck .controlMove",
		forceHelperSize: true,
		dropOnEmpty: true,
		forcePlaceholderSize: true,
		placeholder: "ckplaceholder",
		zIndex: 9999,
		sort: function( event, ui ) {
//			ckOnSortStart(ui);
		},
		start: function( event, ui ){
			ui.placeholder.height(parseInt($ck('> .inner',ui.helper).height()));
			ui.placeholder.parent().trigger('mouseover');
		},
		receive: function( event, ui ) {
			var newblock = $ck(this).find('.blocselect');
			if (ui.sender.hasClass('dragtoadd')) {
				newblock.css('float', 'none').addClass('ckwait');
				createBloc(newblock, ui.sender.attr('data-type'));
				ckMakeRowcontainerSortable($ck('.ckrowcontainer'));
			} else if (ui.sender.hasClass('ckdragtoaddelement')) {
				var newblock = $ck(this).find('.ckdragtoaddelement');
				newblock.css('float', 'none').addClass('ckwait');
				ckLoadLibraryElement(newblock);
			} else {
				newblock.remove();
			}
			ui.placeholder.parent().trigger('mouseleave');
		}, 
		stop: function( event, ui ){
//			ckOnSortStop(ui);
			ui.placeholder.parent().trigger('mouseleave');
			if (! $ck(ui.item).hasClass('blocselect')) {
				ckSaveAction(); // only save action if not from left menu
			}
			ckPreviewFillLayoutInterface();
		},
		out: function( event, ui ) {
//			ckOnSortStop(ui);
		}
	});
	
	$ck( ".wrapper > .inner .ckbloc" ).sortable({
		items: "> .inner > .ckbloc",
		// containment: "parent",
		helper: "clone",
		handle: "> .editorck .controlMove",
		forcePlaceholderSize: true,
		tolerance: "pointer",
		placeholder: "placeholderchild",
		sort: function( event, ui ) {
			ckOnSortStart(ui);
		},
		start: function( event, ui ){
			if (! ui.item.hasClass('ckrowcontainer')) {
				ui.placeholder.width(parseInt($ck('> .inner',ui.helper).width()));
				ui.placeholder.append('<div class="inner" />');
			} else {
				ui.placeholder.width(ui.helper.width() - 2);
				ui.placeholder.append('<div class="inner" />');
			}
			ui.placeholder.parent().trigger('mouseover');
		},
		stop: function( event, ui ) {
			ckOnSortStop(ui);
			ui.item.css('display', '');
			ui.placeholder.parent().trigger('mouseleave');
			ckPreviewFillLayoutInterface();
		},
		out: function( event, ui ) {
			ckOnSortStop(ui);
		}
	});
	
	$ck( ".ckrowcontainer" ).each(function(i, item){
		ckMakeRowcontainerSortable(item);
	});
	
	$ck( ".ckrow > .inner" ).sortable({
		items: "> .ckrowcontainer",
		helper: "clone",
		handle: "> .editorck .controlMove",
		forcePlaceholderSize: true,
		tolerance: "pointer",
		placeholder: "placeholderchild",
		start: function( event, ui ){
			if (! ui.item.hasClass('ckrowcontainer')) {
				ui.placeholder.width(parseInt($ck('> .inner',ui.helper).width()));
				ui.placeholder.append('<div class="inner" />');
			} else {
				ui.placeholder.width(ui.helper.width() - 2);
				ui.placeholder.append('<div class="inner" />');
			}
		},
		stop: function( event, ui ) {
			ckOnSortStop(ui);
			ckPreviewFillLayoutInterface();
		},
		out: function( event, ui ) {
			ckOnSortStop(ui);
		}
	});

	$ck( ".wrapper .main" ).sortable({
		items: ".column2, .center",
		// containment: "parent",
		connectWith: ".main",
		helper: "clone",
		handle: "> .editorck .controlMove",
		forcePlaceholderSize: true,
		placeholder: "placeholderchild",
		sort: function( event, ui ) {
			ckOnSortStart(ui);
		},
		start: function( event, ui ){
			ui.placeholder.width($ck('> .inner',ui.helper).width());
			ui.placeholder.append('<div class="inner" />')
		},
		change: function( event, ui ) {
			// moveBloc(ui);
		},
		stop: function( event, ui ) {
			ckOnSortStop(ui);
			ckPreviewFillLayoutInterface();
		},
		out: function( event, ui ) {
			ckOnSortStop(ui);
		}
	});
	
	ckAddDraggableToBlocks();
	
	$ck( ".dragtoadd.row, .dragtoadd.banner" ).draggable({
		connectToSortable: ".wrapper > .inner, #ckPreviewLayout .ckPreviewLayout_wrapper > li > ul",
		helper: "clone",
		tolerance: "pointer",
		appendTo: "body",
		scroll: false,
		start: function( event, ui ) {
//			$ck('#ckleftpanel').css('overflow', 'visible');
		},
		stop: function( event, ui ) {
//			$ck('#ckleftpanel').css('overflow', '');
		}
	});

	$ck( ".dragtoaddwrapper" ).draggable({
		connectToSortable: "#body, #ckPreviewLayout",
		helper: "clone",
		appendTo: "body",
		scroll: false,
		// revert: "invalid"
		start: function( event, ui ) {
//			$ck('#ckleftpanel').css('overflow', 'visible');
		},
		stop: function( event, ui ) {
//			$ck('#ckleftpanel').css('overflow', '');
		}
	});
}

function ckAddDraggableToBlocks() {
	$ck( ".dragtoadd:not(.row):not(.banner)" ).draggable({
		// connectToSortable: ".wrapper > .inner, .wrapper > .inner > .ckbloc > .inner, .wrapper > .inner > .ckbloc > .inner > .ckrowcontainer, .wrapper > .inner > .ckbloc > .inner > .ckrowcontainer > .ckbloc > .inner > .ckrowcontainer",
		connectToSortable: ".wrapper > .inner, .ckrowcontainer, #ckPreviewLayout .ckPreviewLayout_wrapper > li > ul, #ckPreviewLayout [data-type=\"row\"] > ul > li > ul",
		helper: "clone",
		appendTo: "body",
		scroll: false,
		// cancel: '.ckrowcontainer'
		// revert: "invalid"
		// tolerance: "pointer",
		start: function( event, ui ){
//			$ck('#ckleftpanel').css('overflow', 'visible');
			$ck('.ckrowcontainer').each(function(i, item){
				item = $ck(item);
				if (! item.find('*').length) {
					item.addClass('empty');
				}
	});
			$ck('#ckPreviewLayout').addClass('dragging');
		},
		stop: function( event, ui ){
//			$ck('#ckleftpanel').css('overflow', '');
			$ck('.ckrowcontainer.empty').removeClass('empty');
			$ck('#ckPreviewLayout').removeClass('dragging');
		}
	});
}

function ckAddDraggableToLibraryElements() {
	$ck('.ckdragtoaddelement.cklibraryitemwrapper').draggable({
		connectToSortable: '#body,#ckPreviewLayout',
		helper: 'clone',
		appendTo: 'body',
		scroll: false,
		start: function( event, ui ) {
			ui.helper.addClass('ckdraggingelement');
		},
		stop: function( event, ui ) {
		}
	});

	$ck('.ckdragtoaddelement:not(.cklibraryitemwrapper)').draggable({
		connectToSortable: '.wrapper > .inner,#ckPreviewLayout .ckPreviewLayout_wrapper > li > ul',
		helper: 'clone',
		appendTo: 'body',
		scroll: false,
		start: function( event, ui ) {
			ui.helper.addClass('ckdraggingelement');
		},
		stop: function( event, ui ) {
		}
	});
}

function ckMakeRowcontainerSortable(item) {
	$ck(item).sortable({
		items: ".ckbloc",
		// cancel: '.ckrow',
		// containment: "parent",
		helper: "clone",
		handle: "> .editorck .controlMove",
		forcePlaceholderSize: true,
		connectWith: ".ckrowcontainer, .wrapper > .inner",
		// tolerance: "pointer",
		placeholder: "ckplaceholder",
		sort: function( event, ui ) {
			ui.helper.find('.editorck').hide();
			if (ui.placeholder.parents('.ckrow').length > 1) {
				ui.helper.addClass('tocancel');
}
		},
		start: function( event, ui ){
			ui.placeholder.height(parseInt($ck('> .inner',ui.helper).height()));
			ui.placeholder.parent().trigger('mouseover');
		},
		stop: function( event, ui ){
			ui.placeholder.parent().trigger('mouseleave');
			ckSaveAction();
			ckPreviewFillLayoutInterface();
		},
		receive: function( event, ui ) {
			if (ui.sender.find('*').length == 0) {
				ui.sender.html(ui.sender.html().trim());
			}
			if (ui.sender.attr('data-type') == 'row' && ui.helper && ui.helper.hasClass('tocancel')) {
				ui.helper.remove();
				ui.placeholder.remove();
				$ck(this).find('.blocselect').remove();
				alert('This is too much ! You can not use more than 2 levels of imbrication');
				// return false;
			} else {
				var newblock = $ck(this).find('.blocselect');
				if (ui.sender.hasClass('dragtoadd')) {
					newblock.css('float', 'none').addClass('ckwait');
					createBloc(newblock, ui.sender.attr('data-type'));
				} else if (ui.sender.hasClass('ckdragtoaddelement')) {
					var newblock = $ck(this).find('.ckdragtoaddelement');
					newblock.css('float', 'none').addClass('ckwait');
					ckLoadLibraryElement(newblock);
				} else {
					newblock.remove();
				}
			}
			ui.placeholder.parent().trigger('mouseleave');
		}
	});
}

/*function jInsertEditorText(text, editor) {
	var newEl = new Element('span').set('html', text);
	var valeur = newEl.getChildren()[0].getAttribute('src');
	$(editor).value = valeur;
	$(editor).fireEvent('change');
	$ck('#'+editor).trigger('change');
}*/

function ckSelectFile(file, field) {
	if (! field) {
		alert('ERROR : no field given in the function ckSelectFile');
		return;
	}
	$ck('#'+field).val(file).trigger('change');
//	CKBox.close();
}

function ckInitTooltip(el, attrib) {
	attrib = attrib || 'title';
	el = el || document;
	$ck( el ).tooltip({
		items: ".ckhastip",
		content: function() {
			return $ck(this).attr(attrib);
		},
		close: function( event, ui ) {
			ui.tooltip.hide();
		},
		position: {
			my: "center bottom-20",
			at: "left top",
			using: function( position, feedback ) {
				$ck( this ).css( position );
			}
		},
		track: false,
		tooltipClass: "cktooltipinfo"
	});
}

function ckInitModalPopup() {
	CKBox.initialize({});
	CKBox.assign($ck('a.modal'), {
		parse: 'rel'
	});
}

function initModalPopup() {
	// for B/C in widgets
	ckInitModalPopup();
}

function ckInitOptionsAccordions(wrap) {
	wrap = wrap ? wrap : $ck('#ckedition');
	$ck('.ckinterfaceblockaccordion', wrap).hide();
	$ck('.ckproperty, .ckinterfaceblock', wrap).each(function(i, tab) {
		tab = $ck(tab);
		$ck('.ckinterfaceblocktitle:not(.ckinitiated)', tab).each(function() {
			$ck(this).addClass('ckinitiated');
			$ck(this).click(function() {
				if (!$ck(this).hasClass('ckopen')) {
					blocstyle = $ck(this).next('.ckinterfaceblockaccordion');
					$ck(this).addClass('ckopen');
					blocstyle.slideDown('fast');
				} else {
					$ck(this).next('.ckinterfaceblockaccordion').slideUp('fast');
					$ck(this).removeClass('ckopen');
				}
			});
		});
	});

}

function ckInitOptionsTabs(wrap) {
	wrap = wrap ? wrap : $ck('#menuck');
	$ck('.ckinterfacetab:not(.ckcurrent)', wrap).hide();
	$ck('.ckinterfacetablink', wrap).each(function(i, tab) {
		tab = $ck(tab);
		tab.click(function() {
			if (!$ck(this).hasClass('ckopen') && !$ck(this).hasClass('ckcurrent')) {
				$ck(this).addClass('ckopen');
				$ck('#ckleftpanel .ckinterfacetab.ckinterfacetab_fullscreen').fadeOut('fast');
				$ck('#' + tab.attr('tab')).slideDown('fast');
			} else {
				$ck('#' + tab.attr('tab')).slideUp('fast');
				$ck(this).removeClass('ckopen');
			}
			$ck(this).removeClass('ckcurrent');
			$ck('#' + tab.attr('tab')).removeClass('ckcurrent');
		});
	});
}

/*function ckInitOptionsSliders(wrap) {
	wrap = wrap ? wrap : $ck('#ckelementscontainer');
	$ck('.ckinterfaceslider', wrap).hide();
	$ck('.ckinterfacesliderlink', wrap).each(function(i, tab) {
		tab = $ck(tab);
		var targetTab = $ck('#' + tab.attr('tab'));
		tab.click(function() {
			$ck('#' + tab.attr('tab')).show();
			wrap.stop().animate({'margin-left': '-300px'});
		});
		$ck('.ckinterfacesliderback').click(function() {
			wrap.stop().animate({'margin-left': '0'});
			$ck('.ckinterfaceslider', wrap).hide();
			$ck('.ckinterfacesliderlink', wrap);
		});
		if (targetTab.find('.ckinterfacesliderlink').length) {
			ckInitOptionsSliders(targetTab);
		}
	});
}*/

function ckInitColorPickers() {
	var startcolor = '';
	$ck('.colorPicker').each(function(i, picker) {
		picker = $ck(picker);
		picker.mousedown(function() {
			if (picker.val()) {
				startcolor = picker.val().replace('#','');
			} else {
				startcolor = 'fff000';
			}
			picker.colpick({
				layout:'full',
				color: startcolor,
				livePreview: true,
				submitText: TCK.Text._('CK_OK', 'OK'),
				cleanerText: TCK.Text._('CK_CLEAR', 'Clear'),
				copyText: TCK.Text._('CK_COPY', 'Copy'),
				pasteText: TCK.Text._('CK_PASTE', 'Paste'),
				selectPalette: TCK.Text._('CK_SELECT_PALETTE', 'Select a palette'),
				onChange:function(hsb,hex,rgb,el,bySetColor,rgba) {
					if (rgba && rgba !== 0) {
						picker.val('rgba(' + rgba + ')').css('background-color','rgba(' + rgba + ')');
					} else if (picker.val()
						&& picker.val().indexOf("r") == -1
						&& picker.val().indexOf("v") == -1
						&& picker.val().indexOf("t") == -1) {
						$ck(el).css('background-color','#'+hex);
						ckSetPickercolor(picker);
						// force the # character
						if (picker.val().indexOf("#") == -1) picker.val('#'+picker.val());
					} else {
						$ck(el).css('background-color','');
					}
					// Fill the text box just if the color was set using the picker, and not the colpickSetColor function.
					if (picker.val().indexOf("r") == -1
						&& picker.val().indexOf("t") == -1) {
						if(!bySetColor) $ck(el).val('#' + hex);
					}
				},
				onSubmit:function(hsb,hex,rgb,el,bySetColor) {
//					picker.trigger('change');
					ckRenderCss();
				},
				onClean: function(button, cal) {
					picker.val('');
					picker.css('background', 'none');
//					picker.trigger('change');
				},
				onCopy: function(color, cal) {
					CLIPBOARDCOLORCK = picker.val();
				},
				onPaste: function(color, cal) {
					picker.val(CLIPBOARDCOLORCK);
					picker.css('background', CLIPBOARDCOLORCK);
//					picker.trigger('change');
					ckSetPickercolor(picker);
				},
				onPaletteColor: function(hsb,hex,rgb,el,bySetColor) {
					picker.val('#'+hex);
					picker.css('background','#'+hex);
//					picker.trigger('change');
					ckSetPickercolor(picker);
				},
			}).keyup(function(){
				$ck(this).colpickSetColor(this.value);
//				picker.trigger('change');
			});
		});
	});
}

/**
 * Method to give a black or white color to have a good contrast
 */
function ckSetPickercolor(picker) {
//	if (picker.val().indexOf("#") == -1) {
//		picker.css('color', '').css('background', '');
//		return;
//	}
	pickercolor =
			0.213 * ckHexToR(picker.val()) / 100 +
			0.715 * ckHexToG(picker.val()) / 100 +
			0.072 * ckHexToB(picker.val()) / 100
			< 1.5 ? '#FFF' : '#000';
	picker.css('color', pickercolor);
	return pickercolor;
}

function ckCreateGradientPreview(prefix) {
	if (!$ck('#'+prefix + 'gradientpreview'))
		return;
	var area = $ck('#'+prefix + 'gradientpreview');
	/*if ($ck('#'+prefix + 'backgroundcolorstart') && $ck('#'+prefix + 'backgroundcolorstart').val()) {
		$ck('#'+prefix + 'backgroundcolorend').removeAttr('disabled');
		$ck('#'+prefix + 'backgroundpositionend').removeAttr('disabled');
	} else {
		$ck('#'+prefix + 'backgroundcolorend').attr({'disabled': 'disabled', 'value': ''});
		$ck('#'+prefix + 'backgroundcolorend').css('background-color', '');
		$ck('#'+prefix + 'backgroundpositionend').attr({'disabled': 'disabled', 'value': '100'});
	}
	if ($ck('#'+prefix + 'backgroundcolorend') && $ck('#'+prefix + 'backgroundcolorend').val()) {
		$ck('#'+prefix + 'backgroundcolorstop1').removeAttr('disabled');
		$ck('#'+prefix + 'backgroundpositionstop1').removeAttr('disabled');
		$ck('#'+prefix + 'backgroundopacity').attr({'disabled': 'disabled', 'value': ''});
	} else {
		$ck('#'+prefix + 'backgroundcolorstop1').attr({'disabled': 'disabled', 'value': ''});
		$ck('#'+prefix + 'backgroundcolorstop1').css('background-color', '');
		$ck('#'+prefix + 'backgroundpositionstop1').attr({'disabled': 'disabled', 'value': ''});
		$ck('#'+prefix + 'backgroundopacity').removeAttr('disabled');
	}
	if ($ck('#'+prefix + 'backgroundcolorstop1') && $ck('#'+prefix + 'backgroundcolorstop1').val()) {
		$ck('#'+prefix + 'backgroundcolorstop2').removeAttr('disabled');
		$ck('#'+prefix + 'backgroundpositionstop2').removeAttr('disabled');
	} else {
		$ck('#'+prefix + 'backgroundcolorstop2').attr({'disabled': 'disabled', 'value': ''});
		$ck('#'+prefix + 'backgroundcolorstop2').css('background-color', '');
		$ck('#'+prefix + 'backgroundpositionstop2').attr({'disabled': 'disabled', 'value': ''});
	}*/

	var gradientstop1 = '';
	var gradientstop2 = '';
	var gradientend = '';
	var gradientpositionstop1 = '';
	var gradientpositionstop2 = '';
	var gradientpositionend = '';
	if ($ck('#'+prefix + 'backgroundpositionstop1') && $ck('#'+prefix + 'backgroundpositionstop1').val())
		gradientpositionstop1 = $ck('#'+prefix + 'backgroundpositionstop1').val() + '%';
	if ($ck('#'+prefix + 'backgroundpositionstop2') && $ck('#'+prefix + 'backgroundpositionstop2').val())
		gradientpositionstop2 = $ck('#'+prefix + 'backgroundpositionstop2').val() + '%';
	if ($ck('#'+prefix + 'backgroundpositionstop3') && $ck('#'+prefix + 'backgroundpositionend').val())
		gradientpositionend = $ck('#'+prefix + 'backgroundpositionend').val() + '%';
	if ($ck('#'+prefix + 'backgroundcolorstop1') && $ck('#'+prefix + 'backgroundcolorstop1').val())
		gradientstop1 = $ck('#'+prefix + 'backgroundcolorstop1').val() + ' ' + gradientpositionstop1 + ',';
	if ($ck('#'+prefix + 'backgroundcolorstop2') && $ck('#'+prefix + 'backgroundcolorstop2').val())
		gradientstop2 = $ck('#'+prefix + 'backgroundcolorstop2').val() + ' ' + gradientpositionstop2 + ',';
	if ($ck('#'+prefix + 'backgroundcolorend') && $ck('#'+prefix + 'backgroundcolorend').val())
		gradientend = $ck('#'+prefix + 'backgroundcolorend').val() + ' ' + gradientpositionend;
	var stylecode = '<style type="text/css">'
			+ '#' + prefix + 'gradientpreview {'
			+ 'background:' + $ck('#'+prefix + 'backgroundcolorstart').val() + ';'
			+ 'background-image: -o-linear-gradient(top,' + $ck('#'+prefix + 'backgroundcolorstart').val() + ',' + gradientstop1 + gradientstop2 + gradientend + ');'
			+ 'background-image: -webkit-linear-gradient(top,' + $ck('#'+prefix + 'backgroundcolorstart').val() + ',' + gradientstop1 + gradientstop2 + gradientend + ');'
			+ 'background-image: -webkit-gradient(linear, left top, left bottom,' + $ck('#'+prefix + 'backgroundcolorstart').val() + ',' + gradientstop1 + gradientstop2 + gradientend + ');'
			+ 'background-image: -moz-linear-gradient(top,' + $ck('#'+prefix + 'backgroundcolorstart').val() + ',' + gradientstop1 + gradientstop2 + gradientend + ');'
			+ 'background-image: -ms-linear-gradient(top,' + $ck('#'+prefix + 'backgroundcolorstart').val() + ',' + gradientstop1 + gradientstop2 + gradientend + ');'
			+ 'background-image: linear-gradient(top,' + $ck('#'+prefix + 'backgroundcolorstart').val() + ',' + gradientstop1 + gradientstop2 + gradientend + ');'
			+ '}'
			+ '</style>';
	area.find('.injectstyles').html(stylecode);
}

function ckShowColorsPalette() {
	$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSetPaletteColors();CKBox.close()">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxcolorspalette&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: true,
		data: {
		}
	}).done(function(code) {
		$ck('#ckcolorspalette').remove();
		var colorspalette = $ck(code);
		$ck(document.body).append(colorspalette);
		colorspalette.hide();
		CKBox.open({handler: 'inline', content: 'ckcolorspalette', footerHtml: $boxfooterhtml, style: {padding: '10px'}, size: {x: '600px', y: '400px'}});
		var colors = $ck('#body').attr('colorpalette');
		if (colors) {
			colors = colors.split(',');
			for (var i=0; i< colors.length; i++) {
				var field = $ck('#ckcolorspalette .colorPicker').eq(i);
				if (colors[i]) {
					field.attr('value', '#' + colors[i]).trigger('change');
					field.css('background-color', field.attr('value'));
					ckSetPickercolor(field);
				}
			}
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckToggleExpertMode(button) {
	button = $ck(button);
	if ($ck('#body').hasClass('expert')) {
		$ck('#body').removeClass('expert');
		$ck(button).removeClass('ckexpertmode');
		$ck('.menuckpanel[data-target="expert"]').removeClass('ckexpertmode');
	} else {
		$ck('#body').addClass('expert');
		$ck(button).addClass('ckexpertmode');
		$ck('.menuckpanel[data-target="expert"]').addClass('ckexpertmode');
	}
}

function ckPrintPositions() {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	$ck('.controlfocus').removeClass('controlfocus');
//	$ck('#ckedition').empty().fadeIn();
//	$ck('html, body').animate({scrollTop: 0}, 'slow');
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	$ck('.ckbloc').each(function(i, el) {
		el = $ck(el);
		if (el.attr('ckmoduleposition')) {
			elpos = $ck('<div class="ckmodulepositionpreview"><span class="ckmodulepositionpreview_name">'+el.attr('ckmoduleposition')+'</span></div>')
			el.append(elpos);
			el.css('position', 'relative');
			elpos.css('position', 'absolute')
				.css('top', 0)
				.css('left', 0)
				.css('right', 0)
				.css('bottom', 0)
		}
	});
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxprintpositions&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templatename: $ck('#name').val()
		}
	}).done(function(code) {
		$ck(document.body).append('<div id="ckprintpositionresult">' + code + '</div>');
		$ck('#ckwaitoverlay').remove();
		html2canvas($ck('#body'), {
			onrendered: function(canvas) {
				$ck('#ckwaitoverlay').remove();
	//			document.body.appendChild(canvas);
				$ck('#ckprintpositionscontainer').empty().append(canvas);
				$ck('.ckmodulepositionpreview').remove();
			}
		});
		CKBox.open({'handler': 'inline', 'content': 'ckprintpositionresult', style: {padding: '10px'}});
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
	
	
}

function ckCheckExpertModeOnPageload() {
	if ($ck('#body').hasClass('expert')) {
		$ck('#menuck .menuckpanel[data-target="expert"]').addClass('ckexpertmode');
	} else {
		$ck('#menuck .menuckpanel[data-target="expert"]').removeClass('ckexpertmode');
	}
}

//function showThemes() {
//	$ck('.ckleftpanel').not($ck('#showthemes')).fadeOut();
//	$ck('#showthemes').fadeIn();
//}

//function hideThemes() {
//	$ck('#showthemes').fadeOut();
//}

function ckSubmitButtonSave() {
	// force to save the left panel in responsive mode
	if ($ck('#cktoolbarResponsive').length) {
		ckSaveResponsivePopup();
	}

	if (! $ck('#name').val()) {
		$ck('#name').addClass('invalid').focus();
//		alert(TCK.Text._('CK_TEMPLATE_MUST_HAVE_NAME', 'You must give a name to the template'));
		ckAskForName()
		return;
	}
	// replace the informations into the form to be saved
	ckMoveInfosInForm()

	ckCleanTemplateName();
	$ck('#name').removeClass('invalid');
	// clean the interface
	$ck('.editorck').remove();
	$ck('.ckhover').removeClass('ckhover');
	ckRemoveColumnEdition();
	ckRemoveWorkspaceWidth();
//	$ck('#body').removeClass('ckresponsiveactive');

	// save the widgets data
	var widgets = Object();
	$ck('#widgetsElements .widget').each(function(i) {
		var widget = new Object();
		widget['name'] = $ck(this).attr('data-name');
		widget['enabled'] = $ck(this).attr('data-enabled');
		widget['data'] = $ck(this).find('.widgetdata').html();
		widgets[$ck(this).attr('data-name')] = widget;
	});
	var jsonWidgets = JSON.stringify(widgets);
	jsonWidgets = jsonWidgets.replace(/"/g, "|qq|")
	jsonWidgets = jsonWidgets.replace(/</g, "|lt|")
	jsonWidgets = jsonWidgets.replace(/>/g, "|gt|")
	$ck('#widgets').attr('value', jsonWidgets);

	// save the module positions
	var modulepositions = new Array();
	$ck('.ckbloc[isdisabled!=true]').each(function(i, el) {
		if ($ck(el).attr('ckmoduleposition')) modulepositions.push($ck(el).attr('ckmoduleposition'));
	});
	modulepositions = modulepositions.join(',');
	$ck('#modules').attr('value', modulepositions);

	$ck('.layoutfield').each(function() {
		var type = $ck(this).attr('data-type');
		$ck(this).attr('value',$ck('#layout_' + type + '_html').html());
	});
	
	// save the template code
	$ck('#htmlcode').attr('value', $ck('#ckhtmlcontainer').html().trim());
	$ck('#stylecode').attr('value', $ck('#ckstylescontainer').html().trim());
	ckSubmitButton('template.save');
}

function ckAskForName() {
	var name =  prompt(TCK.Text._('CK_TEMPLATE_MUST_HAVE_NAME', 'You must give a name to the template'));
	if (name) $ck('#name').val(name).removeClass('invalid');
}

function ckSubmitButton(task, form) {
	if (!form) {
		form = document.getElementById('adminForm');
	}

	if (task) {
		form.task.value = task;
	}

	// Submit the form.
	// Create the input type="submit"
	var button = document.createElement('input');
	button.style.display = 'none';
	button.type = 'submit';

	// Append it and click it
	form.appendChild(button).click();

	// If "submit" was prevented, make sure we don't get a build up of buttons
	form.removeChild(button);
}

function ckToggleBootstrap() {
	var bodyProps = ckGetPropsForBloc('body', 'tab_blocstyles');
	if (bodyProps.length && bodyProps.attr('blocloadboostrap') == '0' || $ck('#joomlaversion').attr('value') != 'j3') {
		$ck("#bootstrapload").empty();
		$ck('#bootstrapload').append('<link rel="stylesheet" type="text/css" href="' + TEMPLATECREATORCK_MEDIA_URI + '/default.css">');
		$ck("#bootstrapload").removeClass('bootstraploaded');
	} else if (bodyProps.length && bodyProps.attr('blocloadboostrap') == '1' && !$ck("#bootstrapload").hasClass('bootstraploaded')) {
		$ck("#bootstrapload").empty();
		$ck('#bootstrapload').append('<link rel="stylesheet" type="text/css" href="' + TEMPLATECREATORCK_MEDIA_URI + '/bootstrap.css">');
		$ck("#bootstrapload").addClass('bootstraploaded');
	}
}

function ckToogleWrapperFluid() {
	var styleswrapper = ckGetStylesWrapperForBlock('body');
	if (!$ck('#blocwrapperfluid').length && $ck('> .tab_blocstyles', styleswrapper).length && !$ck('> .tab_blocstyles', styleswrapper).attr('blocwrapperfluid'))
		return;
	if ($ck('#blocwrapperfluid').length) {
		value = $ck('#blocwrapperfluid').attr('value');
	} else {
		value = $ck('> .tab_blocstyles', styleswrapper).attr('blocwrapperfluid');
	}
	if (value == 'fluid') {
		$ck('.tck-container').removeClass('tck-container').addClass('tck-container-fluid');
	} else {
		$ck('.tck-container-fluid').removeClass('tck-container-fluid').addClass('tck-container');
	}
}

function ckCopyToClipboard(button) {
	CKCLIPBOARD = new Array();
	$ck('.inputbox').each(function(i, el) {
		var tmp = new Object()
		CKCLIPBOARD[el.id] = el.value;
		if ($ck(el).attr('type') == 'radio') {
			if ($ck(el).attr('checked')) {
				CKCLIPBOARD[el.id] = 'checked';
			} else {
				CKCLIPBOARD[el.id] = '';
			}
		}
	});
	alert(TCK.Text._('CK_COPYTOCLIPBOARD', 'Current styles copied to clipboard !'));
}

function ckPasteFromClipboard(button) {
	if (CKCLIPBOARD) {
		if (!confirm(TCK.Text._('CK_COPYFROMCLIPBOARD', 'Apply styles from Clipboard ? This will replace all current existing styles.')))
			return;
		for (var field in CKCLIPBOARD) {
			$ck('#' + field).val(CKCLIPBOARD[field]);
			if ($ck('#' + field).attr('type') == 'radio') {
				if (CKCLIPBOARD[field] == 'checked') $ck('#' + field).attr('checked', CKCLIPBOARD[field]);
			}
			if ($ck('#' + field).hasClass('colorPicker')) ckSetPickercolor($ck('#' + field));
		}
		ckRenderCss();
	} else {
		alert(TCK.Text._('CK_CLIPBOARDEMPTY', 'Clipboard is empty'));
	}
}

function ckResetCss(button) {
	if (!confirm(TCK.Text._('CK_CONFIRM_RESET_STYLES', 'Are you sure to reset ? This will remove all existing styles.')))
		return;
	$ck('#ckedition .inputbox').each(function() {
		var field = $ck(this);
		field.val('');
		if (field.attr('type') == 'radio') {
			field.removeAttr('checked');
		}
		if (field.hasClass('colorPicker')) ckSetPickercolor(field);
	});
	ckRenderCss();
}

function ckCleanTemplateName() {
	var input = $ck('#name');
	var name = input.val();
	name = ckAlphaNumeric(name);
	name = name.toLowerCase();
	input.val(name);
}

function ckAlphaNumeric(s, allowspace) {
	if (!allowspace) allowspace = false;
	if (allowspace) {
		return s.replace(/[^a-z0-9-_? ]/gi,'');
	} else {
		return s.replace(/[^a-z0-9-_?]/gi,'');
	}
}
/*
 * Show the window for global infos (name, date, author...)
 */
function ckEditGlobalinfos() {
	CKBox.open({'handler': 'inline', 'content': 'ckinfospopup', 'size': {x: '700px', y: '500px'}});
}

/*
 * Function to load the HTML modele in the page
 */
function ckLoadLayout(name) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=" + name + "&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl
	}).done(function(code) {
		$ck("#ckhtmlcontainer").html(code);
		if ($ck('#joomlaversion').attr('value') == 'j3') {
			$ck('#body > .tab_blocstyles').attr('blocloadboostrap', '1');
		}
		ckLoadTheme('default');
		$ck("#menuck").removeClass('hiddenpanel');
		ckInitInterface();
		$ck('body').removeClass('ckfirststep');
		CKBox.close();
	}).fail(function(code) {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckLoadTheme(themename) {
//	valid = '1';
//	valid = confirm(TCK.Text._('CK_ERASE_WITH_NEW_THEME', 'WARNING : This will erase your data with the new theme, continue ?'));
//	if (valid == null || valid == "")
//		return;
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxloadtheme&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {themename: themename}
	}).done(function(code) {
		ckApplyTheme(code);
		ckToggleBootstrap();
		$ck('#ckwaitoverlay').remove();
		ckShowWizard();
		ckSaveAction();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckApplyTheme(code) {
	code = code.replace(/\|di\|/g, "#");
	theme = JSON.parse(code);
	for (i = 0; i < theme.length; i++) {
		bloc = theme[i];
		if (!bloc)
			continue;
		focusblocs = $ck(bloc['type']);
		focusblocs.each(function(k, focusbloc) {
			j = 0;
			focusbloc = $ck(focusbloc);
			while (bloc['ckprops' + j]) {
				var blocClass = $ck('<div ' + bloc['ckprops' + j] + ' />').removeClass('ckprops').attr('class');
				var blocid = focusbloc.attr('id');
				$ck('> .' + blocClass, focusbloc).remove();
//				$ck('#ckstylescontainer').find('.ckstyle[data-id="' + focusbloc.attr('id') + '"].' + blocClass).remove();
//				$ck('#ckstylescontainer').prepend('<div ' + bloc['ckprops' + j] + ' data-id="' + focusbloc.attr('id') + '" />');
				var styleswrapper = ckGetStylesWrapperForBlock(blocid);
				styleswrapper.append('<div ' + bloc['ckprops' + j] + ' />')
				j++;
			}
			if (bloc['style']) {
				blocstyle = bloc['style'].replace(/\|ID\|/g, focusbloc.attr('id'))
							.replace(/\|URIBASE\|/g, URIBASE + "/")
							.replace(/\|TCK_COMPONENT\|/g, "components/com_templateck")
							.replace(/\|TCK_ADMIN_COMPONENT\|/g, "administrator/components/com_templateck")
							;
				ckSetStyleForBloc(blocid, '<style>' + blocstyle + '</style>');
				focusbloc.find('> .ckstyle').remove();
//				$ck('#ckstylescontainer').prepend('<div class="ckstyle" data-id="' + focusbloc.attr('id') + '" ><style>' + blocstyle + '</style></div>');
//				$ck('#ckstylescontainer').find('.ckstyle[data-id="' + focusbloc.attr('id') + '"]').empty().append('<style>' + blocstyle + '</style>');
			}
		});
	}
	ckSeparateStylesForBlocks();
	ckToogleWrapperFluid();
}

function ckGetTheme() {
	var blocs = new Array();
	var types = Array('.body', '.wrapper', '.mainbanner', '.bannerlogo', '.bannermenu', '.bannerlogodesc', '.banner', '.horiznav', '.singlemodule', '.flexiblemodules',
			'.flexiblemodules > .inner > .flexiblemodule:first-child', '.flexiblemodules > .inner > .flexiblemodule:first-child + .flexiblemodule', '.flexiblemodules > .inner > .flexiblemodule:first-child + .flexiblemodule + .flexiblemodule', '.flexiblemodules > .inner > .flexiblemodule:first-child + .flexiblemodule + .flexiblemodule + .flexiblemodule', '.flexiblemodules > .inner > .flexiblemodule:first-child + .flexiblemodule + .flexiblemodule + .flexiblemodule + .flexiblemodule',
			'.maincontent', '.column1', '.main', '.maintop', '.maincenter', '.mainbottom', '.center',
			'.column2', '.centertop', '.centerbottom', '.content');
	for (i = 0; i < types.length; i++) {
		type = types[i];
		if (!$ck(type).length) {
			alert('pas de ' + type + ' dans la page !');
			continue;
		}
		bloc = $ck(type);
		var cssblocs = new Object();
		cssblocs['type'] = type;
		var blocid = bloc.attr('id');
		blocstyle = ($ck('#ckstylescontainer').find('.ckstylecontainer[data-id="' + blocid + '"] .ckstyle').length && $ck('#ckstylescontainer').find('.ckstylecontainer[data-id="' + blocid + '"] .ckstyle').html()) ? $ck('#ckstylescontainer').find('.ckstylecontainer[data-id="' + blocid + '"] .ckstyle').html() : '';
		if (blocstyle) {
			var id = new RegExp(bloc.attr('id'), "g");
			blocstyle = blocstyle.replace(id, "|ID|");
			var uri = new RegExp(URIBASE + "/", "g");
			blocstyle = blocstyle.replace(uri, "|URIBASE|");
		}
		cssblocs['style'] = blocstyle;
		$ck('#ckstylescontainer').find('.ckstylecontainer[data-id="' + blocid + '"] .ckprops').each(function(i, ckprops) {
			ckprops = $ck(ckprops);
			text = 'class="' + ckprops.attr('class') + '" ';
			fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
			text += 'fieldslist="' + ckprops.attr('fieldslist') + '" ';
			for (var f=0; f<fieldslist.length; f++) {
				var fieldname = fieldslist[f];
				text += fieldname + '="' + ckprops.attr(fieldname) + '" ';
			}
			cssblocs['ckprops' + i] = text;
		});
		blocs[i] = cssblocs;
	}
	return blocs;
}

function ckSaveTheme() {
	var theme = ckGetTheme();
	theme = JSON.stringify(theme);
	theme = theme.replace(/#/g, "|di|");
	var themename = prompt('nom du theme ?');
	if (themename == null || themename == '')
		return;
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxsavetheme&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			theme: theme,
			themename: themename
		}
	}).done(function(code) {
		$ck("#themefile").html(code);
//		checkModules();
	}).fail(function(code) {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}


/*=================================*/
/*		Favorite management
/*=================================*/

function ckRemoveFavorite(btn) {
	if (!confirm(TCK.Text._('CK_CONFIRM_DELETE','Are you sure that you want to delete ?'))) return;
	var favorite = $ck($ck(btn).parents('.ckmyfavoriterow')[0]).find('> .ckmyfavorite');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxRemoveFavorite&" + CKTOKEN;
	var name = favorite.attr('data-name');
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: name,
		}
	}).done(function(code) {
		try {
			response = JSON.parse(code);
			if (response.status == '1') {
				$ck('#ckmyfavorite' + name).parent().remove();
				ckRemoveStylesForBlock('ckmyfavorite' + name);
				alert(TCK.Text._('CK_SUCCESS', 'Success !'));
			} else {
				alert(TCK.Text._('CK_FAILED', 'Failed'));
			}
		}
		catch(err) {
			alert( 'ERROR : ' + err.message );
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckEditFavorite(btn) {
	var bloc = $ck($ck(btn).parents('.ckmyfavoriterow')[0]).find('> .ckmyfavorite');
	$ck('.ckfocusfavorite').removeClass('ckfocusfavorite'); // needed because focus is removed on panel close
	bloc.addClass('ckfocusfavorite'); // needed because focus is removed on panel close
	ckShowEdition(bloc.attr('id'), 'ckSaveFavoritePopup');
}

function ckSaveFavoritePopup(blocid, workspace) {
//	ckSaveEdition(blocid, workspace, 'ckAfterSaveFavoritePopup'); 
	ckRenderCss(blocid, workspace, $ck('.ckfocus'), false, 'ckAfterSaveFavoritePopup'); //blocid, editionarea, focus, forpreviewarea, returnFunc
}

function ckAfterSaveFavoritePopup() {
	var favorite = $ck('.ckfocusfavorite');
	var blocid = favorite.attr('id');
	var stylecode = ckGetStyleForBloc(blocid).html();
	var id = new RegExp(blocid, "g");
	stylecode = stylecode.replace(id, "|ID|");
	var uri = new RegExp(URIBASE + "/", "g");
	stylecode = stylecode.replace(uri, "|URIBASE|");
	stylecode = stylecode.replace(/#/g, "|di|");
	favorite.find('.favoritethumbstyles').html(stylecode);

	ckSaveFavorite(favorite, favorite.attr('data-name').replace('favorite', ''));
	$ck('.ckfocusfavorite').removeClass('ckfocusfavorite');
}

function ckGetFavorite(focus) {
	// var bloc = $ck('.ckfocusfavorite');
	var bloc = focus;
	var blocid = bloc.attr('id');
	var cssbloc = new Object();
	cssbloc['class'] = bloc.attr('class');
	var blocstyle = ckGetStyleForBloc(blocid);
	blocstyle = (blocstyle.length && blocstyle.html()) ? blocstyle.html() : '';
	blocss = '';
	if (blocstyle) {
		var id = new RegExp(bloc.attr('id'), "g");
		blocstyle = blocstyle.replace(id, "|ID|");
		blocss = blocstyle;
		var uri = new RegExp(URIBASE + "/", "g");
		blocstyle = blocstyle.replace(uri, "|URIBASE|");
	}
	cssbloc['css'] = blocss;
	cssbloc['style'] = blocstyle;
	
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	styleswrapper.find('> .ckprops').each(function(i, ckprops) {
		ckprops = $ck(ckprops);
		text = 'class="' + ckprops.attr('class') + '" ';
		fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
		text += 'fieldslist="' + ckprops.attr('fieldslist') + '" ';

		for (var f = 0;f < fieldslist.length; f++ ) {
			text += fieldslist[f] + '="' + ckprops.attr(fieldslist[f]) + '" ';
		}
		cssbloc['ckprops' + i] = text;
	});

	return cssbloc;
}

function ckSaveFavorite(focus, id) {
	if (! id) id = -1;
	var favorite = ckGetFavorite(focus);
	var favoriteStyle = favorite['style'];
	favoritestring = JSON.stringify(favorite);
	favoritestring = favoritestring.replace(/#/g, "|di|");
	
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxsavefavorite&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			favorite: favoritestring,
			id: id,
			focusclass: $ck('.focus').attr('class')
			}
	}).done(function(code) {
		try {
			response = JSON.parse(code);
			if (response.status == '1') {
				if (id == -1) ckAddFavoriteToList(response.msg, favorite);
				ckSeparateStylesForBlock('ckmyfavoritefavorite' + response.msg);
				// alert(TCK.Text._('CK_SUCCESS_CREATING_FAVORITEFILE', 'Success !'));
			} else {
				alert(TCK.Text._('CK_FAILED', 'Failed'));
			}
		}
		catch(err) {
			alert( 'ERROR : ' + err.message );
		}
		// if (parseInt(code) == code) {
			// $ck('#showfavorites > div').append('<div class="favoritethumb" onmouseout="ckRestoreBeforeFavorite()" onmouseover="ckPreviewFavoriteDirect(this)" onclick="ckLoadFavorite(\'favorite' + code + '\', \'favorites\', 1)"><img src="'+URIBASE+'/components/com_templateck/images/favorite.png" style="height:32px;width:32px;margin:0;padding:0;" />'
					// + '<div class="favoritethumbstyles">'+favoriteStyle+'</div>'
					// + '</div>');
			// alert(TCK.Text._('CK_SUCCESS_CREATING_FAVORITEFILE', 'Success !'));
		// } else {
			// alert(TCK.Text._('CK_FAILED', 'Failed'));
		// }
	}).fail(function(code) {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckAddFavoriteToList(i, favorite) {
	var name = 'favorite' + i;
	var html = '<div class="ckmyfavoriterow clearfix">'
					+ '<div class="ckmyfavoritename">'
						+ '<span class="ckmyfavoritenamevalue">' + name + '</span>'
						+ '<div class="ckbutton ckedit" style="padding: 1px 4px;margin: 0 10px;" onclick="ckEditFavoriteName(this)"><span class="fack fack-edit"></span></div><div class="ckbutton ckvalidate" style="padding: 1px 4px;margin: 0 10px;" onclick="ckSaveFavoriteName(this)"><span class="fack fack-check"></span></div>'
					+ '</div>'
					+ '<div id="ckmyfavorite' + name + '" data-name="' + name + '" style="" class="favoritethumb ckmyfavorite" data-merge="0" onmouseout="ckRestoreBeforeFavorite()" onmouseover="ckPreviewFavoriteDirect(this)" onclick="ckLoadFavorite(\'' + name + '\', \'favorites\', 1, this)">'
						+ '<div class="ckstyle">' + favorite['style'].replace(/\|di\|/g,'#').replace(/\|ID\|/g, 'ckmyfavorite' + name) + '</div>'
						+ '<div class="inner">'
							+ 'Lorem ipsum dolor sit amet'
							+ '<div class="favoritethumbstyles">' + favorite['style'] + '</div>'
						+ '</div>'
					+ '</div>'
					+ '<div class="ckbutton" onclick="ckEditFavorite(this);"><span class="fack fack-edit"></span> ' + TCK.Text._('CK_EDIT') + '</div>'
					+ '<div class="ckbutton" onclick="ckRemoveFavorite(this);"><span class="fack fack-remove" style="color:red;"></span> ' + TCK.Text._('CK_DELETE') + '</div>'
				+ '</div>';
	$ck('#showfavorites > .inner').prepend(html);
	var newfavorite = $ck('#ckmyfavorite' + name);
	j = 0;
	while (favorite['ckprops' + j]) {
		blocClass = $ck('<div ' + favorite['ckprops' + j] + ' />', newfavorite).removeClass('ckprops').attr('class');
		$ck('> .' + blocClass, newfavorite).remove();
		newfavorite.prepend('<div ' + favorite['ckprops' + j] + ' />');
		j++;
	}
	return html;
}

function ckLoadFavorite(name, folder, apply, thumb) {
	CKFAVORITELOCKED = 1;
	var valid = '1';
	if (apply == 1) {
		valid = confirm(TCK.Text._('CK_ERASE_WITH_NEW_FAVORITE', 'WARNING : This will erase your data with the new favorite, continue ?'));
		if (valid == null || valid == "") {
			CKFAVORITELOCKED = 0;
			ckRestoreBeforeFavorite();
			return;
		}
	} else {
		
	}

	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxloadfavorite&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: name,
			folder: folder
		}
	}).done(function(code) {
		if (apply == 1) {
			ckApplyFavorite(code, thumb);
			ckCloseEdition();
		} else {
			previewFavorite(code);
		}
		ckSaveAction();
		$ck('#ckwaitoverlay').remove();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckRestoreBeforeFavorite() {
	if ( CKFAVORITELOCKED == 1 )
		return;
	if (CKBLOCCKSTYLESBACKUP != 'undefined') {
		focusbloc = $ck('.ckfocus');
//		$ck('> .ckstyle', focusbloc).empty().html(CKBLOCCKSTYLESBACKUP);
		ckSetStyleForBloc(focusbloc.attr('id'), CKBLOCCKSTYLESBACKUP)
	}
}

function ckPreviewFavoriteDirect(thumb) {
	if ( CKFAVORITELOCKED == 1 )
		return;
	thumb = $ck(thumb);
	
	var focusbloc = $ck('.ckfocus');
	if (! focusbloc.length) return;
//	CKBLOCCKSTYLESBACKUP = $ck('> .ckstyle', focusbloc).html();
	if (thumb.attr('data-merge') === '1') {
		var stylecode = thumb.find('.favoritethumbstyles').text();
//		var re = /\/\*shadow start\*\/(.*?)\/\*shadow end\*\//gi; 
		var re = /(\/\*shadow start\*\/([\s\S]*)?\/\*shadow end\*\/)/gi; 
		stylecode = stylecode.replace(/\|di\|/g, "#");
		stylecode = stylecode.replace(/\|ID\|/g, focusbloc.attr('id')).replace(/\|URIBASE\|/g, URIBASE + "/");
		var focusblocstyle = ckGetStyleForBloc(focusbloc.attr('id')).find('style').text();
		focusblocstyle = focusblocstyle.replace(re, '');
		focusblocstyle = focusblocstyle + stylecode;
		ckSetStyleForBloc(focusbloc.attr('id'), '<style>' + focusblocstyle + '</style>');
//		$ck('> .ckstyle', focusbloc).empty().append('<style>' + focusblocstyle + '</style>');
	} else {
		var stylecode = thumb.find('.favoritethumbstyles').html();
		stylecode = stylecode.replace(/\|di\|/g, "#");
		stylecode = stylecode.replace(/\|ID\|/g, focusbloc.attr('id')).replace(/\|URIBASE\|/g, URIBASE + "/");
//		$ck('> .ckstyle', focusbloc).empty().append(stylecode);

		ckSetStyleForBloc(focusbloc.attr('id'), stylecode);
	}
}

function ckApplyFavorite(code, thumb) {
	var focusbloc = $ck('.ckfocus');
	var blocid = focusbloc.attr('id');
	thumb = $ck(thumb);
	code = code.replace(/\|di\|/g, "#");
	bloc = JSON.parse(code);
	
	if (!bloc)
		return;

	j = 0;
	if (thumb.attr('data-merge') === '1') {
		while (bloc['ckprops' + j]) {
			blocClass = $ck('<div ' + bloc['ckprops' + j] + ' />', focusbloc).removeClass('ckprops').attr('class');
			ckpropshtml = ckGetPropsForBloc(blocid, blocClass);
			var re = /(\/\*shadow start\*\/([\s\S]*)?\/\*shadow end\*\/)/gi;
			blocstyle = bloc['style'].replace(/\|ID\|/g, focusbloc.attr('id')).replace(/\|URIBASE\|/g, URIBASE + "/");
			blocstyle = '/*shadow start*/' + blocstyle + '/*shadow end*/';
			var focusstyle = ckGetStyleForBloc(blocid);
			if (focusstyle.html().match(re)) {
				var blocstyle = focusstyle.html().replace(re, blocstyle);
				ckSetStyleForBloc(blocid, blocstyle);
//				$ck('> .ckstyle', focusbloc).empty().append(blocstyle);
			} else {
//				$ck('> .ckstyle', focusbloc).append(blocstyle);
				ckSetStyleForBloc(blocid, blocstyle, true);
			}
			if (ckpropshtml.length) {
				var blocmerge = $ck('<div ' + bloc['ckprops' + j] + ' />');
				var fieldslistmerge = blocmerge.attr('fieldslist').split(',');

				for (k=0;k<fieldslistmerge.length;k++) {
					if (! ckpropshtml.attr(fieldslistmerge[k])) {
						ckpropshtml.attr('fieldslist', ckpropshtml.attr('fieldslist') + ',' + fieldslistmerge[k]);
					}
					ckpropshtml.attr(fieldslistmerge[k], blocmerge.attr(fieldslistmerge[k]));
				}
			} else {
				var styleswrapper = ckGetStylesWrapperForBlock(blocid);
				styleswrapper.prepend('<div ' + bloc['ckprops' + j] + ' />');
//				focusbloc.prepend('<div ' + bloc['ckprops' + j] + ' />');
			}
			j++;
		}
	} else {
		var styleswrapper = ckGetStylesWrapperForBlock(blocid);
		$ck('> .ckstyle', styleswrapper).empty();
		$ck('> .ckprops', styleswrapper).remove();
		while (bloc['ckprops' + j]) {
			blocClass = $ck('<div ' + bloc['ckprops' + j] + ' />', focusbloc).removeClass('ckprops').attr('class');
			$ck('> .' + blocClass, focusbloc).remove();
			styleswrapper.prepend('<div ' + bloc['ckprops' + j] + ' />');
			j++;
		}

		if (bloc['style']) {
			blocstyle = bloc['style'].replace(/\|ID\|/g, focusbloc.attr('id')).replace(/\|URIBASE\|/g, URIBASE + "/");
			$ck('> .ckstyle', styleswrapper).empty().append('<style>' + blocstyle + '</style>');
		}
	}
	
	CKFAVORITELOCKED = 0;
}

function ckShowFavoritesPanel(blocid) {
	ckCloseEdition();
	CKFAVORITELOCKED = 1;
	bloc = $ck('#' + blocid);
	$ck('.ckfocus').removeClass('ckfocus');
	bloc.addClass('ckfocus');
	CKBLOCCKSTYLESBACKUP = ckGetStyleForBloc(blocid).html();
	$ck('#ckfavoritespanel .ckinterfacesliderparent').css('margin-left', '0');
	$ck('#ckfavoritespanel').css('display', 'block').animate({'left': '0px', 'opacity': 1}, 300);
	// if the favorite panel is already opened
//	if ($ck('#ckfavoritespanel').length) {
		$ck('.objid', $ck('#ckfavoritespanel')).text(bloc.attr('id'));
		CKFAVORITELOCKED = 0;
//		return;
//	}
}

function ckCloseFavoritePanel(force) {
	if (! force ) force = false;
	if ( $ck('#ckfavoritespanel').hasClass('cksticked') && !force ) {
//		CKBLOCCKSTYLESBACKUP = $ck('> .ckstyle', $ck('.ckfocus')).html();
		CKBLOCCKSTYLESBACKUP = ckGetStyleForBloc($ck('.ckfocus').attr('id')).html();
		return;
	}
	$ck('#ckfavoritespanel').animate(
		{'left': '150px', 'opacity': '0'}, 
		function() {
			$ck('#ckfavoritespanel').css('display', 'none');
			}
		);
	if ($ck('#ckleftpanel').attr('data-reduced') == 'true') $ck('#ckleftpanel').addClass('reduced').removeAttr('data-reduced');
}

function ckEditFavoriteName(btn) {
	var namefield = $ck($ck(btn).parents('.ckmyfavoriterow')[0]).find('.ckmyfavoritename');
	var namevalue = namefield.find('.ckmyfavoritenamevalue').hide().text();
	namefield.find('.ckedit').hide();
	namefield.find('.ckvalidate').css('display', 'inline-block');
	namefield.prepend('<input type="text" class="ckmyfavoritenameedition" value="' + namevalue + '"/>');
}

function ckSaveFavoriteName(btn) {
	var namefield = $ck($ck(btn).parents('.ckmyfavoriterow')[0]).find('.ckmyfavoritename');
	var newname = ckAlphaNumeric(namefield.find('.ckmyfavoritenameedition').val(), true);
	namefield.find('.ckmyfavoritenamevalue').text(newname);
	namefield.find('input.ckmyfavoritenameedition').remove();
	namefield.find('.ckedit').show();
	namefield.find('.ckvalidate').hide();
	namefield.find('.ckmyfavoritenamevalue').show();
	var filename = $ck($ck(btn).parents('.ckmyfavoriterow')[0]).find('.ckmyfavorite').attr('data-name');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxrenamefavorite&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			filename: filename,
			name: newname,
		}
	}).done(function(code) {
		try {
			response = JSON.parse(code);
			if (response.status == '1') {
				// $ck('#ckmyfavorite' + name).parent().remove();
				// alert(TCK.Text._('CK_SUCCESS', 'Success !'));
			} else {
				alert(TCK.Text._('CK_FAILED', 'Failed'));
			}
		}
		catch(err) {
			alert( 'ERROR : ' + err.message );
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckCreateWrapperBloc(currentbloc) {
	ckAddBlock('wrapper', ckGetWrapperProposal(), '', currentbloc);
}

function ckGetWrapperProposal() {
	var i = 1;
	while ($ck('#wrapper' + i).length && i < 1000) {
		i++;
	}
	return 'wrapper' + i;
}

function createBloc(currentbloc, type) {
	idproposal = ckGetIdProposal(type);
	positionsproposal = ckGetPositionsProposal(type).join();
	ckAddBlock(type, idproposal, positionsproposal, currentbloc);
}

function ckGetIdProposal(type, id) {
	if (!id) id = '';
	var suggestion;
	switch (type) {
		case 'singlemodule':
		default:
			suggestion = 'block';
			break;
		case 'module-slideshowck':
			suggestion = 'slideshow';
			break;
		case 'flexiblemodules':
			suggestion = 'blocks';
			break;
		case 'rowcontainer':
			suggestion = id;
			break;
		case 'horizmenu':
			suggestion = 'nav';
			break;
		case 'banner':
			suggestion = 'banner';
			break;
		case 'custombloc':
			suggestion = 'custom';
			break;
		case 'row':
			suggestion = 'row';
			break;
		case 'logo':
			suggestion = 'logo';
			break;
	}
	var i = 1;
	outer:
	for (i=1;i<1000;i++) {
		if (type == 'flexiblemodules') {
			var subs = Array('mod1', 'mod2', 'mod3', 'mod4', 'mod5');
			var isValid = true;
			for (s=0;s<subs.length;s++) {
				var sub = subs[s];
				if ($ck('#' + suggestion + i + sub).length) {
					isValid = false;
					continue outer;
				}
			}
			if (! isValid) {
				continue outer;
			} else {
				return suggestion + i;
			}
		} else if (type == 'rowcontainer') {
			if (! $ck('#' + suggestion + 'column' + i).length)
				return suggestion + 'column' + i;
		} else {
			if (! $ck('#' + suggestion + i).length)
				return suggestion + i;
		}
	}

	return suggestion + i;
}

function ckGetPositionsProposal(type) {
	var positions = new Array();
	var suggestion = new Array();
	$ck('.ckbloc').each(function(i, bloc) {
		bloc = $ck(bloc);
		if (bloc.attr('ckmoduleposition'))
			positions.push(bloc.attr('ckmoduleposition'));
	});
	i = 0;
	found = 0;
	switch (type) {
		case 'row':
			n = 4;
			break;
		case 'flexiblemodules':
			n = 5;
			break;
		case 'banner':
			n = 2;
			break;
		default:
			n = 1;
			break;
	}
	while (found < n) {
		if ($ck.inArray("position-" + i, positions) == -1) {
			suggestion.push("position-" + i);
			found++;
		}
		i++;
	}
	return suggestion;
}

function ckAddBlock(type, blockid, blockposition, currentbloc) {
	$ck('#ckedition').empty().hide();
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxcreatebloc&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: false,
		data: {
			tmpl: 'component',
			blockid: blockid,
			blockposition: blockposition,
			fluid: $ck('#body > .tab_blocstyles').attr('blocwrapperfluid'),
			type: type
		}
	}).done(function(code) {
		// if (type == 'wrapper') {
		var newblock = $ck(code);
		if (currentbloc) {
			$ck(currentbloc).fadeOut(500, function() {
				$ck(currentbloc).before(newblock);
				$ck(currentbloc).remove();
				ckInitSortables();
				if (type.substring(0,7) == 'module-') {
					ckSearchExistingModules($ck('#'+blockid).attr('data-element'), blockposition, blockid)
				}
				ckPreviewFillLayoutInterface();
				ckSaveAction();
			});
			ckSeparateStylesForBlock(newblock, true);
		} else {
			$ck('.ckfocus > .inner').append(newblock);
			if (type.substring(0,7) == 'module-') {
				ckSearchExistingModules($ck('#'+blockid).attr('data-element'), blockposition, blockid)
			}
			ckSeparateStylesForBlock(newblock, true);
			ckPreviewFillLayoutInterface();
			ckSaveAction();
		}
		newblock.find('.ckrowcontainer, .flexiblemodule').each(function() {
			ckAddControlsOnHover($ck(this));
		});
		ckAddControlsOnHover(newblock);
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}


function ckSearchExistingModules(type, blockposition, blockid) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + '&task=ajaxSearchExistingModules&' + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: true,
		data: {
			position: blockposition,
			type: type
		}
	}).done(function(code) {
		try {
			response = JSON.parse(code);
			if (response.status == '1') {
//				if (response.count > 0) {
					ckShowModulesList(type, blockposition, blockid);
//				} else {
//					ckAddModule(type, blockposition, blockid);
//				}
			} else {
				alert(response.message);
			}
		}
		catch(err) {
			alert( 'ERROR : ' + err.message );
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckAddModule(type, blockposition, blockid) {
	if (! type) {
		ckShowModuleSelectList(blockposition, blockid);
		return;
	}
	var myurl = TEMPLATECREATORCK_ADMIN_URL + '&task=ajaxPublishModule&' + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: true,
		data: {
			blockposition: blockposition,
			type: type,
			templateid: TEMPLATEID
		}
	}).done(function(code) {
		try {
			response = JSON.parse(code);
			if (response.status == '1') {
				$ck('#' + blockid).attr('data-moduleid', response.id);
				ckOpenModuleOptions(response.id, 1, type);
//				ckShowModulesList(type, blockposition, blockid);
			} else {
				alert(response.message);
			}
			ckSaveAction();
		}
		catch(err) {
			alert( 'ERROR : ' + err.message );
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckShowModuleSelectList(blockposition, blockid) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxmoduleselect&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: true,
		data: {
			blockposition: blockposition,
			blockid: blockid
		}
	}).done(function(code) {
		$ck('#ckmodulesselectlist').remove();
		var moduleslist = $ck(code);
		$ck(document.body).append(moduleslist);
		moduleslist.hide();
		CKBox.open({handler: 'inline', content: 'ckmodulesselectlist', style: {padding: '10px'}});
		// $ck('.ckboxmodal-back').attr('onclick', '');
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckCallShowModulesList(blockid) {
	var block = $ck('#'+blockid);
	var position = block.attr('ckmoduleposition');
	var type = block.attr('data-element');
	ckShowModulesList(type, position, blockid);
}

function ckShowModulesList(type, blockposition, blockid) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxmoduleslist&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: true,
		data: {
			position: blockposition,
			type: type,
			blockid: blockid
		}
	}).done(function(code) {
		$ck('#ckmoduleslist').remove();
		var moduleslist = $ck(code);
		$ck(document.body).append(moduleslist);
		moduleslist.hide();
		CKBox.open({handler: 'inline', content: 'ckmoduleslist', style: {padding: '10px'}, size: {x: '600px', y: '500px'}});
		// $ck('.ckboxmodal-back').attr('onclick', '');
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckAssignModule(blockid, moduleid) {
	$ck('#'+blockid).attr('data-moduleid', moduleid);
	CKBox.close();
}

function ckToggleModuleState(btn, id, state) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxToggleModuleState&" + CKTOKEN;
		$ck.ajax({
			type: "POST",
			url: myurl,
			async: true,
			data: {
				moduleid: id,
				state: $ck(btn).attr('data-state')
			}
		}).done(function(code) {
			try {
				response = JSON.parse(code);
				if (response.status == '1') {
					if (response.state == 0) {
						$ck(btn).removeClass('ckbutton-success').addClass('ckbutton-danger').attr('data-state', response.state);
						$ck(btn).find('.fack').removeClass('fack-check').addClass('fack-times');
					} else {
						$ck(btn).removeClass('ckbutton-danger').addClass('ckbutton-success').attr('data-state', response.state);
						$ck(btn).find('.fack').removeClass('fack-times').addClass('fack-check');
					}
				} else {
					alert(response.message);
				}
			}
			catch(err) {
				alert( 'ERROR : ' + err.message );
			}
		}).fail(function() {
			alert(TCK.Text._('CK_FAILED', 'Failed'));
		});
}

function ckOpenModuleOptions(id, firstuse, type, blockposition, blockid) {
	if (! firstuse) {
		ckShowModulesList(type, blockposition, blockid);
	} else {
		ckShowModuleOptions(id, firstuse);
	}
}

function ckShowModuleOptions(id, firstuse) {
	CKBox.close();
	if (! firstuse) firstuse = false;
	$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveIframe(this, \''+id+'\');CKBox.close(this, \'1\')">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
	CKBox.open({handler: 'iframe', style: {padding: '10px'}, footerHtml: $boxfooterhtml, url: URIROOT + '/administrator/index.php?option=com_modules&amp;client_id=0&amp;task=module.edit&amp;id='+id+'&amp;tmpl=component&amp;view=module&amp;layout=modal'});
	if (firstuse) {
		alert(TCK.Text._('CK_SAVE_FIRST_USE_MODULE', 'Please save the module options to create it correctly the first time you use it.'));
	}
}

function ckSaveIframe(btn, id) {
	var iframe = $ck('iframe', $ck($ck(btn).parents('.ckboxmodal')[0])).contents();
	if (iframe.find('#applyBtn').length) {
		iframe.find('#applyBtn').click();
	} else {
		iframe.find('#saveBtn').click();
	}
}

// needed for B/C
function addControlsOnHover(bloc) {
	ckAddControlsOnHover(bloc);
}

function ckAddControlsOnHover(bloc) {
	bloc = $ck(bloc);
	if ($ck('> .editorck', bloc).length)
		return;
	var timeout;
	bloc.mouseenter(function() {
		if (! $ck('#cktemplatecontainer').hasClass('ckcssmanager')
			&& ! $ck('#body').hasClass('ckresponsiveactive')) {
			ckAddEdition(this);
		}
		$ck('#ckPreviewLayout .ckfocus').removeClass('ckfocus');
	});
	bloc.mouseleave(function() {
		el = $ck(this);
//		clearTimeout (el.timeout);
//		el.timeout = setTimeout (function() {
			if (! $ck('#cktemplatecontainer').hasClass('ckcssmanager')
				&& ! $ck('#body').hasClass('ckresponsiveactive')
				) {
				ckRemoveEdition(el);
			}
//		}, 200);
		
	});
}

function ckAddEdition(bloc, i) {
	if (!i)
		i = 0;
	bloc = $ck(bloc);
	if (bloc.hasClass('ui-sortable-helper')) return;
	if ($ck('> .editorck', bloc).length && i == 0)
		return;
//	var leftpos = bloc.position().left;
//	var toppos = bloc.position().top;
	bloc.css('position','relative');
	bloc.addClass('ckhover');
	var editorclass = '';
	if (i == 0)
		editorclass = ' mainroot';
	var editor = '<div class="editorck' + editorclass + '" id="' + bloc.attr('id') + '-edition"></div>';
	editor = $ck(editor);
	editor.css({
		// 'left': leftpos,
		// 'top': toppos,
		'left': 0,
		'top': 0,
		'position': 'absolute',
		'z-index': 100 + i,
		'width': bloc.outerWidth()
	});
	ckAddEditionControls(editor, bloc);
	bloc.append(editor);
	editor.css('display', 'none').fadeIn('fast');
}

function ckAddEditionControls(editor, bloc) {
	var blocid = bloc.attr('id');
	var controlclass = 'innermodule';
	var fadebloc = false;
	if (bloc.hasClass('flexiblemodules')
			|| bloc.hasClass('singlemodule')
			|| bloc.hasClass('maincontent')
			|| bloc.hasClass('mainbanner')
			|| bloc.hasClass('wrapper')
			) {
		controlclass = 'mainleft';
		fadebloc = true;
	}

	var controls = "<div class=\"ckfields " + controlclass + "\">"
			+ "<div class=\"controlDel isControl\" onclick=\"ckDeleteBloc('" + bloc.attr('id') + "');\"></div>"
//			+ "<div class=\"controlUp isControl\" onclick=\"moveblocUp('" + bloc.attr('id') + "'," + fadebloc + ");\"></div>"
//			+ "<div class=\"controlDown isControl\" onclick=\"moveblocDown('" + bloc.attr('id') + "'," + fadebloc + ");\"></div>"
			+ "<div class=\"controlMove isControl ckhastip\" title=\"" + TCK.Text._('CK_MOVE_TOOLTIP', 'Move the element with drag and drop') + "\"></div>"
			+ "<div class=\"controlCss isControlResponsive isControl ckhastip\" title=\"" + TCK.Text._('CK_CSS_TOOLTIP', 'Edit the styles of the element') + "\" onclick=\"ckShowEdition('" + bloc.attr('id') + "');\"></div>"
			+ "<div class=\"controlCss isControl ckhastip\" title=\"" + TCK.Text._('CK_CSS_TOOLTIP', 'Edit the styles of the element') + "\" onclick=\"ckShowEdition('" + bloc.attr('id') + "');\"></div>"
			+ "<div class=\"controlFavorite isControl ckhastip\" title=\"" + TCK.Text._('CK_FAVORITE_TOOLTIP', 'Design suggestions') + "\" onclick=\"ckShowFavoritesPanel('" + bloc.attr('id') + "');\"></div>";
	// for responsive
	if (!bloc.hasClass('content') && !bloc.hasClass('main') && !bloc.hasClass('center') && bloc.attr('id') != 'wrapper') {
		if (bloc.hasClass('ckrow') || bloc.hasClass('flexiblemodules') 
			|| bloc.hasClass('maincontent') || bloc.hasClass('maincenter')
			|| bloc.hasClass('horiznav')
			) {
			controls += '<div class="isControlResponsive isControl ckhastip" data-class="ckalign" data-mobile="mobile_default" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_ALIGNED') + '" onclick="ckToggleResponsive(this);" ></div>'
				+ '<div class="isControlResponsive isControl ckhastip" data-class="ckstack" data-mobile="mobile_notaligned" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_STACKED') + '" onclick="ckToggleResponsive(this);" ></div>';
		} else {
			controls += '<div class="isControl isControlResponsive ckhastip" data-class="ckshow" data-mobile="mobile_default" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_SHOWN', 'Show') + '" onclick="ckToggleResponsive(this)"></div>'
		}
		if (!bloc.hasClass('maincontent') && !bloc.hasClass('maincenter') && !bloc.hasClass('center') && !bloc.hasClass('main')) {
			controls +=  '<div class="isControl isControlResponsive ckhastip" data-class="ckhide" data-mobile="mobile_hide" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_HIDDEN', 'Hide') + '" onclick="ckToggleResponsive(this)"></div>'
		}
		if (bloc.hasClass('horiznav')) {
			controls +=  '<div class="isControl isControlResponsive ckhastip" data-class="ckhamburger" data-mobile="mobile_hamburger" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_HAMBURGER', 'Hamburger icon') + '" onclick="ckToggleResponsive(this)"><span class="fack fack-bars"></span></div>'
		}
		// mobile menu ck activation, check if the widget and plugin activated
		if (bloc.hasClass('horiznav')) {
			var mobilemenuenabled = '0';
			var widgetsettings = $ck('#widgetsElements').find('[data-name="mobilemenu"] [data-id="' + bloc.attr('id') + '"]');
			if (widgetsettings.length) {
				if (widgetsettings.attr('data-mobilemenuck_enable') == '1') {
					mobilemenuenabled = '1';
				}
			}
			var displaymobilebutton = $ck('#widgetsElements').find('[data-name="mobilemenu"]').length && $ck('#widgetsElements').find('[data-name="mobilemenu"]').attr('data-enabled') == '1' ? 'block' : 'none';
			controls +=  '<div class="isControl isControlResponsive ckhastip" style="display:' + displaymobilebutton + '" data-class="ckmobilemenu" data-enabled="' + mobilemenuenabled + '" data-mobile="mobile_mobilemenuck" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_MOBILEMENU', 'Mobile Menu CK') + '" onclick="ckLoadWidgetMobilemenuck(this);"><span class="fack fack-mobile fack-lg"></span></div>'
		}
	}
	if (TEMPLATECREATORCK_ENABLE_SAVE_ELEMENTS == '1') {
		controls += "<div class=\"controlSave isControl ckhastip\" title=\"" + TCK.Text._('CK_SAVE') + "\" onclick=\"ckSaveItem('" + bloc.attr('id') + "');\"></div>";
	}
	if (!bloc.hasClass('flexiblemodule') && !bloc.hasClass('maincontent')  && !bloc.hasClass('column') && !bloc.hasClass('content') && !bloc.hasClass('maincenter')) {
		controls += "<div class=\"controlCopy isControl ckhastip\" title=\"" + TCK.Text._('CK_COPY') + "\" onclick=\"ckDuplicateItem('" + bloc.attr('id') + "');\"></div>"
	}
	if (bloc.hasClass('flexiblemodules')) {
		controls += "<div class=\"controlModules isControl ckhastip\" title=\"" + TCK.Text._('CK_MODULES_TOOLTIP', 'Edit the blocks width and number') + "\" onclick=\"ckShowModulesPopup('" + bloc.attr('id') + "')\"></div>";
//		controls += "<div class=\"controlEqualHeights isControl ckhastip\" title=\"" + TCK.Text._('CK_EQUALHEIGHTS_TOOLTIP', 'Set equal height on all blocks') + "\" onclick=\"setEqualHeights('" + bloc.attr('id') + "')\"></div>";
	}
	if (bloc.hasClass('ckrow'))
		controls += "<div class=\"controlRow isControl ckhastip\" title=\"" + TCK.Text._('CK_ROW_TOOLTIP', 'Edit the blocks width and number') + "\" onclick=\"ckShowColumnsEdition('" + bloc.attr('id') + "')\">" + bloc.find('> .inner > .ckrowcontainer').length + "</div>";
//	if (bloc.hasClass('mainbanner'))
//		controls += "<div class=\"controlBanner isControl ckhastip\" title=\"" + TCK.Text._('CK_BANNER_TOOLTIP', 'Edit the blocks width and number') + "\" onclick=\"showBannerPopup('" + bloc.attr('id') + "')\"></div>";
	if (bloc.hasClass('maincontent')) {
		controls += "<div class=\"controlMaincontent isControl ckhastip\" title=\"" + TCK.Text._('CK_MAINCONTENT_TOOLTIP', 'Edit the columns width and number') + "\" onclick=\"ckShowMaincontentPopup('" + bloc.attr('id') + "')\"></div>";
//		controls += "<div class=\"controlEqualHeights isControl ckhastip\" title=\"" + TCK.Text._('CK_EQUALHEIGHTS_TOOLTIP', 'Edit the styles of the element') + "\" onclick=\"setEqualHeights('" + bloc.attr('id') + "')\"></div>";
	}
	if (bloc.hasClass('wrapper')) {
		var styleswrapper = ckGetStylesWrapperForBlock(blocid);
		if ($ck('> .tab_blocstyles', styleswrapper).attr('blocfullwidth') == 1) {
			var isFullwidth = ' ckactive';
		} else {
			var isFullwidth = '';
		}
		controls += '<div class="controlFullwidth isControl ckhastip' + isFullwidth + '" title="'+TCK.Text._('CK_FULLWIDTH')+'" onclick="ckToggleFullwidth(\'' + bloc.attr('id') + '\');"></div>';
	}
	if ((bloc.hasClass('module') || bloc.attr('ckmoduleposition')) &&  TEMPLATECREATORCK_PLATFORM == 'joomla') {
		var type = bloc.attr('data-element') ? bloc.attr('data-element') : '';
		controls += "<div class=\"controlModule isControl ckhastip\" title=\"" + TCK.Text._('CK_MODULE_EDITION_TOOLTIP', 'Edit the module options') + "\" onclick=\"ckShowModulesList('" + type + "', '" + bloc.attr('ckmoduleposition') + "', '" + bloc.attr('id') + "')\"></div>";
	}
	if (blocid === 'body') {
		var blocclass = bloc.attr('data-class') ? bloc.attr('data-class') : '';
	} else {
		var blocclass = bloc.find('> .inner').attr('data-class') ? bloc.find('> .inner').attr('data-class') : '';
	}
	controls += "<span class=\"editorcktitle ckhastip\" title=\"" + TCK.Text._('CK_HTML_ID', 'Element ID') + "\" onclick=\"ckChangeBlocId(this)\">" + bloc.attr('id') + "</span>";
	controls += "<span class=\"editorckclass ckhastip\" title=\"" + TCK.Text._('CK_CSS_CLASS', 'CSS Class') + "\" onclick=\"ckChangeBlocClass(this)\">" + blocclass + "</span>";
	if (bloc.attr('ckmoduleposition'))
		controls += "<span class=\"editorckposition ckhastip\" title=\"" + TCK.Text._('CK_POSITION', 'Module position') + "\" onclick=\"changeBlocPosition(this)\">" + bloc.attr('ckmoduleposition') + "</span>";
	controls += "</div>";

	if (bloc.hasClass('ckrowcontainer')) {
		var blocclass = bloc.attr('ckclass') ? bloc.attr('ckclass') : '';
		var controls = "<div class=\"ckfields " + controlclass + "\">"
			+ '<div class="isControl isControlResponsive ckhastip" data-class="ckshow" data-mobile="mobile_default" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_SHOWN', 'Show') + '" onclick="ckToggleResponsive(this)"></div>'
			+ '<div class="isControl isControlResponsive ckhastip" data-class="ckhide" data-mobile="mobile_hide" title="' + TCK.Text._('CK_RESPONSIVE_SETTINGS_HIDDEN', 'Hide') + '" onclick="ckToggleResponsive(this)"></div>'
			+ "<div class=\"controlMove isControl\"></div>"
			+ "<div class=\"controlCss isControlResponsive isControl ckhastip\" title=\"" + TCK.Text._('CK_CSS_TOOLTIP', 'Edit the styles of the element') + "\" onclick=\"ckShowEdition('" + bloc.attr('id') + "');\"></div>"
			+ "<div class=\"controlCss isControl ckhastip\" title=\"" + TCK.Text._('CK_CSS_TOOLTIP', 'Edit the styles of the element') + "\" onclick=\"ckShowEdition('" + bloc.attr('id') + "');\"></div>"
			+ "<div class=\"controlValignDefault isControl ckhastip" + (blocclass == '' ? ' active' : '') + "\" title=\"" + TCK.Text._('CK_VALIGN_DEFAULT', 'Default vertical alignment') + "\" onclick=\"ckToggleVerticalAlign('" + bloc.attr('id') + "', 'default', this);\"></div>"
			+ "<div class=\"controlValignTop isControl ckhastip" + (blocclass == 'valign-top' ? ' active' : '') + "\" title=\"" + TCK.Text._('CK_VALIGN_TOP', 'Top vertical alignment') + "\" onclick=\"ckToggleVerticalAlign('" + bloc.attr('id') + "', 'top', this);\"></div>"
			+ "<div class=\"controlValignCenter isControl ckhastip" + (blocclass == 'valign-center' ? ' active' : '') + "\" title=\"" + TCK.Text._('CK_VALIGN_CENTER', 'Center vertical alignment') + "\" onclick=\"ckToggleVerticalAlign('" + bloc.attr('id') + "', 'center', this);\"></div>"
			+ "<div class=\"controlValignBottom isControl ckhastip" + (blocclass == 'valign-bottom' ? ' active' : '') + "\" title=\"" + TCK.Text._('CK_VALIGN_BOTTOM', 'Bottom vertical alignment') + "\" onclick=\"ckToggleVerticalAlign('" + bloc.attr('id') + "', 'bottom', this);\"></div>"
			+ "</div>";
	}

	editor.append(controls);
	ckInitTooltip(editor, 'title');
}

function ckLoadWidgetMobilemenuck(btn) {
	var btn = $ck(btn);
	var bloc = $ck(btn.parents('.editorck')[0]).parent();
	TCK_WidgetMobilemenuEditPluginOptions(bloc);
}

function ckToggleVerticalAlign(blocid, pos, btn) {
	var focus = $ck('#' + blocid);
	focus.removeClass('valign-top').removeClass('valign-center').removeClass('valign-bottom');
	if (pos != 'default') {
		focus.addClass('valign-' + pos);
		focus.attr('ckclass', 'valign-' + pos);
	} else {
		focus.attr('ckclass', '');
	}
	$ck(btn).parent().find('[class*="controlValign"]').removeClass('active');
	$ck(btn).addClass('active');
}

function ckToggleHorizontalAlign(blocid, pos) {
	var focus = $ck('#' + blocid);
	focus.removeClass('halign-left').removeClass('halign-center').removeClass('halign-right');
	if (pos != 'default') {
		focus.addClass('halign-' + pos);
		focus.attr('ckclass', 'halign-' + pos);
	} else {
		focus.attr('ckclass', '');
	}
}

function ckSetHorizontalAlignLeft(blocid) {
	pos = 'left';
	ckToggleHorizontalAlign(blocid, pos);
}

function ckSetHorizontalAlignCenter(blocid) {
	pos = 'center';
	ckToggleHorizontalAlign(blocid, pos);
}

function ckSetHorizontalAlignRight(blocid) {
	pos = 'right';
	ckToggleHorizontalAlign(blocid, pos);
}

function ckSetHorizontalAlignDefault(blocid) {
	pos = 'default';
	ckToggleHorizontalAlign(blocid, pos);
}

function ckToggleFullwidth(blocid) {
	var focus = $ck('#' + blocid);
	// check if the attributes already exists on the bloc, else create it
	tabid = 'tab_blocstyles';
//	if (!$ck('> .' + tabid, focus).length) {
//		ckCreatePropsForBloc(focus, tabid);
//	}
	focusprop = ckGetPropsForBloc(blocid, tabid);

	if (focusprop.attr('blocfullwidth') == '0' || !focusprop.attr('blocfullwidth')) {
		focusprop.attr('blocfullwidth', '1');
		$ck('> .inner', focus).removeClass('tck-container').removeClass('tck-container-fluid')
			.removeClass('container').removeClass('container-fluid');
		focus.find('.controlFullwidth').addClass('ckactive');
	} else if (focus.hasClass('wrapper')) {
		focusprop.attr('blocfullwidth', '0');
		$ck('> .inner', focus).addClass('tck-container');
		focus.find('.controlFullwidth').removeClass('ckactive');
	}
	ckSaveAction();
}

function ckDuplicateItem(blocid) {
	var bloc = $ck('#' + blocid);

	if (bloc.find('.ckbloc.maincontent').length) {
		alert('You can not duplicate the maincontent, please move it to another place.');
		return;
	}

	var bloccopy = bloc.clone();
	var type = ckGetBlockType(bloc);
	var newid = (type == 'wrapper' ? ckGetWrapperProposal() : ckGetIdProposal(type));
//	var newid = getNewId(blocid);
	if (! newid) return;
	var position =  bloc.attr('ckmoduleposition');

	bloc.after(bloccopy);
	bloccopy.removeClass('editfocus');
	bloccopy.find('> .editorck').remove();
//	ckReplaceId(bloccopy, newid);
	bloccopy.attr('id', newid);
	ckDuplicateStylesForBlock(blocid, newid);
	if (position) {
		var newposition = ckGetPositionsProposal('block');
		bloccopy.attr('ckmoduleposition', newposition);
	}
	ckInitSortables();
	ckAddControlsOnHover(bloccopy);

	bloccopy.find('.ckbloc, .ckrowcontainer').each(function() {
		$this = $ck(this);
		var blocid = $this.attr('id');
		$this.removeClass('editfocus');
		var type = ckGetBlockType($this);
		var parentid = '';
		if ($this.hasClass('ckrowcontainer')) {
			parentid = $ck($this.parents('.ckrow')[0]).attr('id');
		}
		var newid = (type == 'wrapper' ? ckGetWrapperProposal() : ckGetIdProposal(type, parentid));
//		newid = getNewId($this.attr('id'));
		if (! newid) return;
		
		position =  $this.attr('ckmoduleposition');
		if (position) {
			newposition = ckGetPositionsProposal('block');
			$this.attr('ckmoduleposition', newposition);
		}
//		ckReplaceId($this, newid);
		$this.attr('id', newid);
		ckDuplicateStylesForBlock(blocid, newid);
		ckInitSortables();
		ckAddControlsOnHover($this);
	});
	ckSaveAction();
}

function getNewId(id) {
	var newid = id + 'copy';
	var i = 0;
	while (! validateBlocId(newid) && i < 1000) {
		newid = newid + 'copy';
		i++;
	}

	if (i == 1000) {
		alert('Error when trying to give a new ID. Will exit copy.')
		return false;
	}

	return newid;
}

function setEqualHeights(blocid) {
	bloc = $ck('#' + blocid);
	if (bloc.attr('ckclass') && bloc.attr('ckclass').indexOf('equalheights') != -1) {
		bloc.attr('ckclass', bloc.attr('ckclass').replace('equalheights', ''));
	} else {
		ckclass = bloc.attr('ckclass') ? bloc.attr('ckclass') + ' equalheights' : 'equalheights';
		bloc.attr('ckclass', ckclass.trim());
	}
	ckSaveAction();
}

function ckRemoveEdition(bloc, all) {
	if (!all)
		all = false;
	bloc = $ck(bloc);
	bloc.removeClass('ckhover');
	if (all = true) {
		$ck('.editorck', bloc).remove();
	} else {
		$ck('> .editorck', bloc).remove();
	}
}

function ckDeleteBloc(blocid) {
	bloc = $ck('#' + blocid);

	if (bloc.find('.ckbloc.maincontent').length) {
		alert('You can not delete the maincontent, please move it to another place.');
		return;
	}

	if (confirm('Do you want to delete ?')) {
		ckRemoveStylesForBlock(blocid);
		bloc.find('.ckbloc, .ckrowcontainer').each(function() {
			ckRemoveStylesForBlock($ck(this).attr('id'));
		})
		bloc.remove();
	}

	ckSaveAction();
}

function ckChangeBlocId(btn) {
	if ($ck('#body').hasClass('ckresponsiveactive')) {
		alert(TCK.Text._('CK_EXIT_RESPONSIVE_FIRST'));
		return;
	}
	var bloc = ckGetBlockFromBtn(btn);
	blocid = bloc.attr('id');
	if (bloc.attr('id') == 'wrapper' || bloc.attr('id') == 'body')
		return;
	var result = prompt(TCK.Text._('CK_ENTER_UNIQUE_ID', 'Please enter a unique ID (must be a text)'), bloc.attr('id'));
	if (!result)
		return;
	result = ckValidateName(result);
	if (validateBlocId(result))
		ckUpdateIdPosition(blocid, result, '');
	ckSaveAction();
}

function ckGetBlockFromBtn(btn) {
	return $ck($ck(btn).parents('.ckbloc')[0]);
}

function changeBlocPosition(btn) {
	if ($ck('#body').hasClass('ckresponsiveactive')) {
		alert(TCK.Text._('CK_EXIT_RESPONSIVE_FIRST'));
		return;
	}
	var bloc = ckGetBlockFromBtn(btn);
	blocid = bloc.attr('id');

	var result = prompt(TCK.Text._('CK_ENTER_UNIQUE_POSITION', 'Please enter a unique Position (must be a text)'), bloc.attr('ckmoduleposition'));
	if (!result)
		return;
	if (TEMPLATECREATORCK_ENABLE_SAVE_ELEMENTS == '1') {
		ckUpdateIdPosition(blocid, '', result);
	} else {
		result = ckValidatePositionName(result);
		if (validateBlocPosition(result))
			ckUpdateIdPosition(blocid, '', result);
		ckSaveAction();
	}
}

function validateBlocId(newid) {
	if (newid != null && newid != "" && !$ck('#' + newid).length) {
		return true;
	} else if ($ck('#' + newid).length) {
		alert(TCK.Text._('CK_INVALID_ID', 'ID invalid or already exist'));
		return false;
	} else if (newid == null || newid == "") {
		alert(TCK.Text._('CK_ENTER_VALID_ID', 'Please enter a valid ID'));
		return false;
	}
	return true;
}

function ckValidateName(name) {
	var name = name.replace(/[^a-z0-9-_?]/gi,'');
	// name = name.toLowerCase();
	return name;
}

function ckValidatePositionName(name) {
	var name = name.replace(/[^a-z0-9_?-]/gi,'');
	name = name.toLowerCase();
	return name;
}

function validateBlocPosition(newposition) {
	if (newposition == null || newposition == "") {
		alert(TCK.Text._('CK_ENTER_VALID_POSITION', 'Please enter a valid position'));
		return false;
	}
	var alreadyexists = false;
	$ck('.ckbloc').each(function(i, bloc) {
		bloc = $ck(bloc);
		if (bloc.attr('ckmoduleposition') == newposition && bloc.attr('isdisabled') != 'true') {
			alert(TCK.Text._('CK_POSITION_ALREADY_USED', 'Position already used'));
			alreadyexists = true;
		}
	});
	return !alreadyexists;
}

function ckUpdateIdPosition(blocid, newid, newposition) {
	bloc = $ck('#' + blocid);
	if (newposition) {
		$ck('.editorckposition', bloc).html(newposition);
		bloc.attr('ckmoduleposition', newposition);
	}
	if (newid) {
		$ck('.editorcktitle', bloc).html(newid);
		ckReplaceId(bloc, newid);
		bloc.find('.ckrowcontainer').each(function() {
			var column = $ck(this);

			// fix for columns not having ID, example maincontent
			if (! column.attr('id')) {
				var columnid = ckGetIdProposal('rowcontainer', blocid);
				column.attr('id', columnid);
			}

			var newcolumnid = ckGetIdProposal('rowcontainer', newid);
			ckReplaceId(column, newcolumnid);
		});
	}
	
	$ck('.ckPreviewLayoutItem[data-id="' + blocid + '"]').find('.ckPreviewLayoutItemName').text(newid);
	$ck('.ckPreviewLayoutItem[data-id="' + blocid + '"]').attr('data-id', newid);
	ckSaveAction();
}

function ckReplaceId(el, newid) {
	var blocid = el.attr('id');
	var re = new RegExp(blocid, 'g');
	var blocstyles = ckGetStyleForBloc(blocid);
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	blocstyles.html(blocstyles.html().replace(re,newid));
	styleswrapper.attr('data-id', newid);
	el.attr('id', newid);
}

function ckCallImageManagerPopup(id, type) {
//	if (TEMPLATECK.ISJ4 == '1') {
//		$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckGetJ4Image(\'' + id + '\');CKBox.close(this);">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
//		CKBox.open({id: 'ckmediamanager', handler: 'iframe', url: URIROOT + '/administrator/index.php?option=com_media&view=media&e_name='+id+'&tmpl=component'
//		, footerHtml: $boxfooterhtml});
//	} else {
	if (! type) type = 'image';
		CKBox.open({id: 'ckmediamanager', handler: 'iframe', url: TEMPLATECREATORCK_ADMIN_URL + '&view=browse&type=' + type + '&func=ckSelectFile&field='+id+'&tmpl=component'});
//	}
}

// automatically catch the event for the J4 media manager
window.document.addEventListener('onMediaFileSelected', e => {
	TEMPLATECK.selectedImage = e.detail;
});

function ckGetJ4Image(field_id) {
	var data = TEMPLATECK.selectedImage;
	if (!data || typeof data === 'object' && (!data.path || data.path === '')) {
	  Joomla.selectedFile = {};
	  // resolve({
		// resp: {
		  // success: false
		// }
	  // });
	  return;
	}

	const execTransform = (resp) => {
		if (resp.success === true) {
		  if (resp.data[0].url) {
			if (/local-/.test(resp.data[0].adapter)) {
			  // const {
				// rootFull
			  // } = Joomla.getOptions('system.paths'); // eslint-disable-next-line prefer-destructuring

			  // Joomla.selectedFile.url = resp.data[0].url.split(rootFull)[1];
			  // }
			  var imageurl = resp.data[0].url.split(TEMPLATECK.URIROOTABS)[1];
			  ckSelectFile(imageurl, field_id);
			} else if (resp.data[0].thumb_path) {
			  Joomla.selectedFile.thumb = resp.data[0].thumb_path;
			}
		  } else {
			Joomla.selectedFile.url = false;
		  }
		}
	}

	$ck.ajax({
		url: TEMPLATECK.URIROOT + '/administrator/index.php?option=com_media&format=json&task=api.files&url=true&path=' + data.path + '&format=json&' + TEMPLATECK.TOKEN,
	})
	.done(function( response ) {
		const resp = JSON.parse(response);
		execTransform(resp);
		TEMPLATECK.selectedImage = {}; // empty the image selection
	})
	.fail(function() {
		alert('FAILED');
	});
}

function ckShowMediaManager(id, type) {
	ckCallImageManagerPopup(id, type);
}

function ckCloseMediaManager() {
	CKBox.close('#ckmediamanager .ckboxmodal-button');
}

function ckCallGoogleFontPopup(prefix) {
	CKBox.open({url: TEMPLATECREATORCK_ADMIN_URL + '&view=fontselect&tmpl=component&prefix=' + prefix})
}

function ckSetGoogleFont(prefix, fonturl, fontname, fontweight) {
	if (! fontname) return;
	fontname = ckCapitalize(fontname).trim("'");
	if (! fonturl) fonturl = "//fonts.googleapis.com/css2?family="+fontname.replace(' ', '+');
	if (! fontweight) fontweight = $ck('#' + prefix + 'fontweight').val();
	// check if the google font exists
	jQuery.ajax({
		url: fonturl,
	})
	.done(function( data ) {
		if (data) {
			if (prefix) {
				$ck('#' + prefix + 'googlefont').removeClass('invalid');
				$ck('#' + prefix + 'googlefont').val(fontname);
				$ck('#' + prefix + 'fontweight').val(fontweight);
				$ck('#' + prefix + 'fontfamily').val('googlefont').trigger('change');
			}
			ckAddGooglefontStylesheet(fontname, fonturl);
		} else {
			$ck('#' + prefix + 'googlefont').addClass('invalid');
		}
	})
	.fail(function() {
		$ck('#' + prefix + 'googlefont').addClass('invalid');
	});
}

function ckAddGooglefontStylesheet(fontname, fonturl) {
	if (! fonturl) fonturl = "//fonts.googleapis.com/css2?family="+fontname.replace(/ /g, '+');
	var exist = false;

	$ck('#googlefontscall link').each(function(i, sheet) {
		if ($ck(sheet).attr('href') == fonturl) exist = true;
	});
	if (exist == false ) {
		$ck('#googlefontscall').append("<link href='"+fonturl+"' rel='stylesheet' type='text/css'>");
	}

	// extract the real font name for the url
	var re = /family=(.*?)$/;
	var fontName = fonturl.match(re);
	if (typeof(fontName[1]) == 'undefined') {
		alert('Font name not found');
		return '';
	}
	var fullfontname = fontName[1].trim().trim("'");
	
	var bodyfontsprops = ckGetPropsForBloc('body', 'googlefonts');
	var fontslist = bodyfontsprops.attr('fontslist') ? bodyfontsprops.attr('fontslist') : '';
	fontslist = fontslist ? fontslist.split(',')  : new Array();
	if (fontslist.indexOf(fullfontname) == -1) {
		fontslist.push(fullfontname);
	}
	fontslist = fontslist.join(',');
	bodyfontsprops.attr('fontslist', fontslist);
}

function ckAddGoogleFontsToList() {
	var bodyfontsprops = ckGetPropsForBloc('body', 'googlefonts');
	var fontslist = bodyfontsprops.attr('fontslist') ? bodyfontsprops.attr('fontslist') : '';
	if (! fontslist) return;

	fontslist = fontslist ? fontslist.split(',')  : new Array();
	$ck('#ckedition select[id$="fontfamily"], #ckinterfaceparams select[id$="fontfamily"]').each(function() {
		for (var i=0; i < fontslist.length; i++) {
			var fontName = fontslist[i].replace(/\+/g, ' ');
			if ($ck(this).find('option[value="' + fontName + '"]').length === 0) {
				$ck(this)
					.append($ck('<option>', { value : fontName })
					.text(fontName));
			}
		}
	});
}

function ckShowEdition(blocid, savefunc, onAfterLoaded) {
	if (! savefunc) savefunc = '';
	if (! onAfterLoaded) onAfterLoaded = '';

	ckRemoveQuickStyles();
	ckClosePageSettingsPanel();
	ckCloseFavoritePanel();
	var bloc = $ck('#' + blocid);
	$ck('.ckfocus').removeClass('ckfocus');
	bloc.addClass('ckfocus');
	$ck('#ckedition').css({'left': '150px', 'opacity': 0, 'display': 'block'}); // note : ckpreviewedition
	var editionarea = $ck('#ckedition'); // note : ckpreviewedition

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxstylescss&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			objclass: bloc.attr('class'),
			objmoduleposition: bloc.attr('ckmoduleposition'),
			expertmode: $ck('#body').hasClass('expert'),
			savefunc: savefunc,
			element: bloc.attr('data-element'),
			ckobjid: bloc.attr('id')
		}
	}).done(function(code) {
		$ck('#ckedition').empty().animate({'left': '0px', 'opacity': 1}, 300).append(code); // note : ckpreviewedition
		$ck('#ckedition').find('.ckinterfacesliderback-stylescss').on('click', function() { // note : ckpreviewedition
			ckClosePreviewEdition();
		});
		ckAddGoogleFontsToList();
		ckFillEdition(blocid);
		ckFillEditionSettings(blocid);
		ckAddEventOnFields(editionarea, blocid);
		if (onAfterLoaded && typeof(window[onAfterLoaded]) == 'function') window[onAfterLoaded]();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckAddEventOnFields(editionarea, blocid, fieldscontainer) {
	if (! fieldscontainer) fieldscontainer = editionarea;
	$ck('.inputbox:not(.colorPicker):not(.cknoupdate)', fieldscontainer).change(function() {
		ckRenderCss(blocid, editionarea);
	});
	$ck('.colorPicker:not(.cknoupdate),.inputbox[type=radio]:not(.cknoupdate)', fieldscontainer).blur(function() {
		ckRenderCss(blocid, editionarea);
	});
	$ck('.inputbox.cknoupdate', fieldscontainer).mouseup(function() {
		ckRenderCss(blocid, editionarea);
	});
}

function forceColorPickerChanges(picker) {
	$ck(picker).trigger('blur');
}

function ckShowModulesPopup(blocid) {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	bloc = $ck('#' + blocid);
	$ck('.ckfocus').removeClass('ckfocus');
	bloc.addClass('ckfocus');
//	$ck('#ckedition').empty().fadeIn();
//	$ck('html, body').animate({scrollTop: 0}, 'slow');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxmodulesmanager&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
		}
	}).done(function(code) {
		$ck('#ckpopup').empty().append(code);
		$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveModulesPopup();CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
		CKBox.open({handler: 'inline', content: 'ckpopup', style: {padding: '10px'}, size: {x: '1150px', y: '550px'}, footerHtml: $boxfooterhtml});
		$ck('#ckwaitoverlay').remove();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckShowRowPopup(blocid) {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	bloc = $ck('#' + blocid);
	$ck('.ckfocus').removeClass('ckfocus');
	bloc.addClass('ckfocus');
//	$ck('html, body').animate({scrollTop: 0}, 'slow');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxrowmanager&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
		}
	}).done(function(code) {
		$ck('#ckpopup').empty().append(code);
		$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveRowPopup();CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
		CKBox.open({handler: 'inline', content: 'ckpopup', size: {x: '1100px', y: '300px'}, style: {padding: '10px'}, footerHtml: $boxfooterhtml});
		$ck('#ckwaitoverlay').remove();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckRemoveColumnEdition() {
	$ck('.ckcolwidthedition').remove();
	$ck('.ckcolwidthediting').removeClass('ckcolwidthediting');
}

function ckShowColumnsEdition(blocid, inleftpanel) {
	if (! inleftpanel) inleftpanel = false;
	// ckCloseEdition();
	$ck('#ckedition').css('display', 'block');
	ckRemoveColumnEdition() 
	var row = $ck('#' + blocid);
	$ck('.ckfocus').removeClass('ckfocus');
	row.addClass('ckfocus');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxcolumnsmanager&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
		}
	}).done(function(code) {
		if (inleftpanel) {
			$ck('[data-id="tab_columns"]').empty().append(code).fadeIn();
		} else {
			$ck('#ckedition').empty().animate({'left': '0px', 'opacity': 1}).append(code);
			$ck('#ckedition .ckinterfacesliderback').click(function() {ckCloseEdition()});
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		// $ck('#ckwaitoverlay').remove();
	});
}

function ckShowMaincontentPopup(blocid) {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	bloc = $ck('#' + blocid);
	$ck('.ckfocus').removeClass('ckfocus');
	bloc.addClass('ckfocus');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxmaincontentmanager&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
		}
	}).done(function(code) {
		$ck('#ckpopup').empty().append(code);
		$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveMaincontentPopup();CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
		CKBox.open({handler: 'inline', content: 'ckpopup', style: {padding: '10px'}, size: {x: '900px', y: '550px'}, footerHtml: $boxfooterhtml});
		$ck('#ckwaitoverlay').remove();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckShowParamsPopup() {
	var target = $ck('.menuckpaneltarget[data-target="settings"]');
	// if (target.attr('data-loaded') == '1') return;
	ckMoveInfosInForm();
	ckClosePreviewEdition();
	$ck('#ckedition').empty();
	$ck('.ckfocus').removeClass('focus');
	bloc = $ck('#body');
	bloc.addClass('ckfocus');
	var editionarea = target;
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxparams&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			expertmode: $ck('#body').hasClass('expert'),
			joomlaversion: $ck('#joomlaversion').attr('value')
		}
	}).done(function(code) {
		target.find('> .inner').empty().append(code);
		ckAddGoogleFontsToList();
		ckFillEdition('body');
		ckAddEventOnFields(editionarea, 'body');
		initBulletlist(); // to render the selected bullet style
		// load the informations
		ckMoveInfosInPanel();
//		ckAddGoogleFontsToList();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		// $ck('#ckwaitoverlay').remove();
	});
}

function ckShowResponsiveEdition() {
	var target = $ck('.menuckpaneltarget[data-target="responsive"]');

	// if content already loaded, exit
	if (target.attr('data-loaded') == '1') {
		ckSwitchResponsive('5', true);
		return;
	}

	// get blocks
	blocs = ckGetBlocks();
	blocs = JSON.stringify(blocs);
	blocs = blocs.replace(/#/g, "|di|");
	bloc = $ck('#body');

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxresponsive&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			blocs: blocs,
			htmlcode_responsive: $ck('#htmlcode_responsive').val(),
			templateid: TEMPLATEID
		}
	}).done(function(code) {
		target.find('> .inner').empty().append(code);
		ckFillEdition('body');
		ckSetResponsiveValues();
		ckSwitchResponsive('5', true);
		target.attr('data-loaded', '1');
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckSetResponsiveValues() {
	var values = $ck('#body').attr('responsivevalues');
	if (! values) values = '524,758,950,1024';
	values = values.split(',');
	$ck('#cktoolbarResponsive .inputbox').each(function(i) {
		this.value = values[i];
		$ck(this).attr('data-value', values[i]);
	});
}

function ckFillEdition(blocid) {
//	bloc = $ck(blocid);
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var responsiveRangeNumber = ckGetResponsiveRangeNumber();
	var variationRangeNumber = ckGetVariationRangeNumber();
	if (responsiveRangeNumber&& responsiveRangeNumber !== '5') {
		var suffix = '.ckresponsive' + responsiveRangeNumber;
	} else if (variationRangeNumber&& variationRangeNumber !== '0') {
		var suffix = '.ckvariation' + variationRangeNumber;
	} else {
		var suffix = ':not(.ckresponsive):not(.ckvariation)';
	}
//	var suffix = rangeNumber && rangeNumber !== '5' ? '.ckresponsive' + rangeNumber : ':not(.ckresponsive)';

	styleswrapper.find('.ckprops' + suffix).each(function(i, ckprops) {
		ckprops = $ck(ckprops);

		// retrocompatibilite shapes before V5
		if (ckprops.hasClass('tab_divider')) {
			if (ckprops.attr('dividershape') && ckprops.attr('dividershape') != '0' && ckprops.attr('dividerposition') == 'bottom'
			) {
					ckBcShapes(ckprops);
			}
		}
		ckprops.attr('dividerposition', 'top');
		ckprops.attr('divider-2position', 'bottom');
		// end retrocompatibilite

		fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
		for (j=0;j<fieldslist.length;j++) {
			fieldname = fieldslist[j];
			if (!$ck('#' + fieldname).length)
				continue;
			cssvalue = ckprops.attr(fieldname);
			field = $ck('#' + fieldname);

			if (field.attr('type') == 'radio') {
				if (cssvalue == 'checked') {
					field.attr('checked', 'checked');
				} else {
					field.removeAttr('checked');
				}
			} else if (cssvalue) {
				field.attr('value', cssvalue);
				if (field.hasClass('colorPicker') && field.attr('value')) {
					ckSetPickercolor(field);
					field.css('background-color', field.attr('value'));
					if (field.attr('id').indexOf('backgroundcolorend') != -1) {
						prefix = field.attr('id').replace("backgroundcolorend", "");
						if (prefix && $ck('#blocbackgroundcolorstart').attr('value'))
							ckCreateGradientPreview(prefix);
					}
					if (field.attr('id').indexOf('backgroundcolorstart') != -1) {
						prefix = field.attr('id').replace("backgroundcolorstart", "");
						if (prefix && $ck('#blocbackgroundcolorstart').attr('value'))
							ckCreateGradientPreview(prefix);
					}
				}
			} else {
				field.attr('value', '');
			}
			// B/C for google fonts before 5.2.0
			if (field.attr('id').indexOf('fontfamily') != -1) {
				prefix = field.attr('id').replace("fontfamily", "");

				googlefontvalue = ckprops.attr(prefix + 'googlefont');
				if (googlefontvalue) {
					field.attr('value', googlefontvalue);
				}
			}
		}
		// retrocompatibilite banner
		if (!ckprops.attr('logowidth')) {
			$ck('#logowidth').attr('value', ckprops.attr('blocwidth'));
			$ck('#logoheight').attr('value', ckprops.attr('blocheight'));
		}
		// end retrocompatibilite
	});
	// B/C for V5 shape dividers
	if ($ck('#' + blocid + ' .tck-divider-top.ckflip-vertical').length) {
		$ck('#ckedition #dividerflipvertical1').attr('checked', 'checked');
		$ck('#ckedition #dividerflipvertical0').removeAttr('checked');
	}
	if ($ck('#' + blocid + ' .tck-divider-bottom.ckflip-vertical').length) {
		$ck('#ckedition #divider-2flipvertical1').attr('checked', 'checked');
		$ck('#ckedition #divider-2flipvertical0').removeAttr('checked');
	}
	$ck('.ckrangeinputupdate').trigger('input');
	if ($ck('#iconicontype').val() == 'svg') {
		$ck('#fontawesomefieldset,#fontawesomefieldsetoptions').hide();
		$ck('#iconsvgfieldset').show();
	} else {
		$ck('#fontawesomefieldset,#fontawesomefieldsetoptions').show();
		$ck('#iconsvgfieldset').hide();
	}

	// add management for text align buttons
	$ck('label[for*=alignement]').click(function() {
		let $label = $ck(this);
		let targetId = $label.attr('for');
		let $input = $ck('#' + targetId);
		let checked = $input.prop('checked') === true ? true : false;

		if (checked) {
			setTimeout(function() {
				$input.prop('checked', false);
				$input.trigger('change');
			}, 5);
		}
	});
}

function ckBcShapes(ckprops) {
	var attrs = ['shape','position','fliphorizontal','flipvertical','placement','height','width','color'];
	var prefix = 'divider-2';
	for (var i =0; i< attrs.length; i++) {
		let val = ckprops.attr(prefix + attrs[i]);
		ckprops.attr('BCdividerBC2' + attrs[i], val);
		ckprops.removeAttr(prefix + attrs[i]);
	}
	var prefix = 'divider';
	for (var i =0; i< attrs.length; i++) {
		let val = ckprops.attr(prefix + attrs[i]);
		ckprops.attr('divider-2' + attrs[i], val);
		ckprops.removeAttr(prefix + attrs[i]);
	}
	var prefix = 'BCdividerBC2';
	for (var i =0; i< attrs.length; i++) {
		let val = ckprops.attr(prefix + attrs[i]);
		ckprops.attr('divider' + attrs[i], val);
		ckprops.removeAttr(prefix + attrs[i]);
	}
	// ckprops.attr('dividerposition', 'top');
	// ckprops.attr('divider-2position', 'bottom');
	ckprops.attr('fieldslist', 'dividershape,dividerposition,dividercolor,dividerfliphorizontal,dividerflipvertical,dividerplacement,dividerheight,dividerwidth,dividercolor,divider-2shape,divider-2position,divider-2fliphorizontal,divider-2flipvertical,divider-2placement,divider-2height,divider-2width,divider-2color');

}

function ckFillEditionSettings(blocid) {
	var focus = $ck('#' + blocid);
	$ck('#ckedition #settings_blocid').val(blocid); // ckChangeBlocId
	var blocinner = focus.find('> .inner');
	if (! blocinner.length && focus.hasClass('ckrowcontainer')) {
		blocinner = focus;
	}
	$ck('#ckedition #settings_cssclass').val(blocinner.attr('data-class')); // ckChangeBlocClass
	$ck('#ckedition #settings_moduleposition').val(focus.attr('ckmoduleposition')); // changeBlocPosition

	// add event on fields
	$ck('#ckedition #settings_blocid').change(function() {
		result = ckValidateName(this.value);
		const blocidonthefly = $ck('.ckfocus').attr('id');
		if (validateBlocId(result)) {
			ckUpdateIdPosition(blocidonthefly, result, '');
		}
	});
	$ck('#ckedition #settings_cssclass').change(function() {
//		var blocinner = focus.find('> .inner');
//		if (! blocinner.length && focus.hasClass('ckrowcontainer')) {
//			blocinner = focus;
//		}
		var oldclass = blocinner.attr('data-class') ? blocinner.attr('data-class') : '';
		var newclass = this.value;
		if (newclass) newclass = ckAlphaNumeric(newclass, true);
		this.value = newclass;
		if ($ck('> .editorck > .ckfields .editorckclass', focus).length) $ck('> .editorck > .ckfields .editorckclass', focus).html(newclass);
		blocinner.removeClass(oldclass);
		blocinner.addClass(newclass);
		blocinner.attr('data-class', newclass);
	});
	$ck('#ckedition #settings_moduleposition').change(function() {
		const blocidonthefly = $ck('.ckfocus').attr('id');
		var result = this.value;
		if (TEMPLATECREATORCK_ENABLE_SAVE_ELEMENTS == '1') {
			ckUpdateIdPosition(blocidonthefly, '', result);
		} else {
			result = ckValidatePositionName(result);
			if (validateBlocPosition(result))
				ckUpdateIdPosition(blocidonthefly, '', result);
		}
	});
}

function ckSaveEditionSettings(blocid) {
	// do nothing
}

function saveEditionPopup(blocid, workspace, returnFunc, hide) {
	// for B/C in widgets
	ckSaveEdition(blocid, workspace, returnFunc, hide, false, $ck('#popup_editionck'));
}

function ckSaveEdition(blocid, workspace, returnFunc, hide, genCss, editionarea) {
	if (! hide) hide = false;
	if (! returnFunc) returnFunc = '';
	if (! genCss) genCss = ''; // needed for element like table where we have a preview area in the edition
	if (!editionarea) workspace = null;
	editionarea = editionarea ? editionarea : $ck('#ckedition');
	var focus = blocid ? $ck('#' + blocid) : $ck('.ckfocus');
//	var rangeNumber = ckGetResponsiveRangeNumber();

	$ck('.ckproperty', editionarea).each(function(i, tab) {
		tab = $ck(tab);
		tabid = tab.attr('data-id');
//		(!$ck('> .' + tabid, focus).length) ? ckCreatePropsForBloc(focus, tabid) : $ck('> .' + tabid, focus).empty();
//		focusprop = $ck('> .' + tabid, focus);
//		focusprop = $ck('#ckstylescontainer').find('.ckprops[data-id="' + blocid + '"].' + tabid);
		var focusprop = ckGetPropsForBloc(blocid, tabid);
		ckSaveEditionFields(focusprop, tabid);
		fieldslist = ckGetEditionFieldslist(focus, tabid);
		focusprop.attr('fieldslist', fieldslist);
	});
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	if (focus.hasClass('bannerlogo'))
		ckGetPreviewlogo(focus);
	if (focus.hasClass('wrapper') && $ck('> .tab_blocstyles', styleswrapper).attr('blocfullwidth') == 1) {
		$ck('> .inner', focus).removeClass('tck-container').removeClass('tck-container-fluid');
	} else if (focus.hasClass('wrapper')) {
		$ck('> .inner', focus).addClass('tck-container');
	}
	ckToogleWrapperFluid();
	ckToggleBootstrap();

	if (hide) editionarea.empty().hide();
}

function ckSaveLayoutPopup(layout) {
	if (typeof(window['ckBeforeSaveLayoutPopup' + layout]) == 'function') window['ckBeforeSaveLayoutPopup' + layout]();
	ckSaveEdition('layout_' + layout + '_html', '', 'ckAfterSaveLayoutPopup' + layout, '', '', $ck('#ckpopup'));
}

function saveCustomCode() {
	if (!$ck('#customcode').length) return;
	editor_customcode.save(); // save the editor to the textarea
	editor_customcodeendbody.save(); // save the editor to the textarea
	var customcode = $ck('#customcode').attr('value');
	var customcodeendbody = $ck('#customcodeendbody').attr('value');
	
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxsavecustomcode&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templateid: TEMPLATEID,
			templatename: $ck('#name').val(),
			customcode: customcode,
			customcodeendbody: customcodeendbody
		}
	}).done(function(code) {

	}).fail(function() {
		alert(TCK.Text._('CK_FAILED_CUSTOMCODE', 'Failed to save Custom Code'));
	});
}

function saveCustomCss(layout) {
	if (! layout) layout = '';
	let layouttab = '';
	if (layout) {
		layouttab = 'layout';
	}
	if (!$ck('#customcss').length) return;
	editor_customcss.save(); // save the editor to the textarea
	if (! layout) editor_customcssprint.save(); // save the editor to the textarea
	var customcss = $ck('#customcss').attr('value');
	var customcssprint = $ck('#customcssprint').attr('value');
	
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxsavecustomcss" + layouttab + "&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templateid: TEMPLATEID,
			templatename: $ck('#name').val(),
			customcss: customcss,
			customlayout: layout,
			customcssprint: customcssprint
		}
	}).done(function(code) {

	}).fail(function() {
		alert(TCK.Text._('CK_FAILED_CUSTOMCSS', 'Failed to save Custom CSS'));
	});
}

function ckGetImageSrc(src) {
	if (src.indexOf('http')!= -1) return src;
	return URIROOT + '/' + src;
}

function ckGetPreviewlogo(focus) {
	var logoimg = $ck('img', focus);
	var styleswrapper = ckGetStylesWrapperForBlock(focus.attr('id'));
	if ($ck('> .tab_blocstyles', styleswrapper).attr('logoheight'))
		logoimg.attr('height', $ck('> .tab_blocstyles', styleswrapper).attr('logoheight'));
	if ($ck('> .tab_blocstyles', styleswrapper).attr('logowidth'))
		logoimg.attr('width', $ck('> .tab_blocstyles', styleswrapper).attr('logowidth'));
	if ($ck('> .tab_blocstyles', styleswrapper).attr('blocbackgroundimageurl')) {
		focus.css('background', 'none');
		var logosrc = ckGetImageSrc($ck('> .tab_blocstyles', styleswrapper).attr('blocbackgroundimageurl'))
		logoimg.attr('src', logosrc);
		logoimg.attr('data-src', '/' + $ck('> .tab_blocstyles', styleswrapper).attr('blocbackgroundimageurl').trim('/'));
	}
	if ($ck('> .tab_logodescstyles', styleswrapper).attr('uselogodescno') && $ck('> .tab_logodescstyles', styleswrapper).attr('uselogodescno') == 'checked') {
		focus.find('.bannerlogodesc').hide();
	} else {
		focus.find('.bannerlogodesc').show();
		if ($ck('> .tab_logodescstyles', styleswrapper).attr('logodesctext')) focus.find('.bannerlogodesc').find('> .inner div').text($ck('> .tab_logodescstyles', styleswrapper).attr('logodesctext'));
	}
	if ($ck('> .tab_blocstyles', styleswrapper).attr('logoaligncenter') && $ck('> .tab_blocstyles', styleswrapper).attr('logoaligncenter') == 'checked') {
		focus.attr('ckclass', 'tck-logo-center');
	} else if ($ck('> .tab_blocstyles', styleswrapper).attr('logoalignright') && $ck('> .tab_blocstyles', styleswrapper).attr('logoalignright') == 'checked') {
		focus.attr('ckclass', 'tck-logo-right');
	} else {
		focus.attr('ckclass', '');
	}
	logofieldslist = $ck('> .tab_blocstyles', styleswrapper).attr('fieldslist');
	if (logofieldslist.toLowerCase().indexOf('blocwidth') == -1)
		logofieldslist += ',blocwidth';
	if (logofieldslist.toLowerCase().indexOf('blocheight') == -1)
		logofieldslist += ',blocheight';
	
	$ck('> .tab_blocstyles', styleswrapper).attr('fieldslist', logofieldslist);
	ckSetTemplateOptions(focus);
	ckSaveAction();
}

function ckSetTemplateOptions(focus) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxSetTemplateOptions&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templatename: $ck('#name').attr('value'),
			blocid: focus.attr('id'),
			logoalt: $ck('#logoalt').attr('value'),
			logolink: $ck('#logolink').attr('value'),
			uselogodesc: $ck('[name="uselogodesc"]:checked').attr('id'),
			logodesctext: $ck('#logodesctext').attr('value'),
			logoimg: $ck('img', focus).attr('data-src'),
			logowidth: $ck('img', focus).attr('width'),
			logoheight: $ck('img', focus).attr('height')
		}
	}).done(function(code) {
		// do nothing here as there is no problem if the template options are not updated
	}).fail(function() {

	});
}

function ckSaveResponsivePopup() {
	ckAddSpinnerIcon($ck('.ckleftpanelheadericon.cksave'));
	$ck('.blocresolution').each(function(i, resolution) {
		attribute = $ck(resolution).attr('id');
		$ck('.ckbloc', resolution).each(function(j, responsivebloc) {
			responsivebloc = $ck(responsivebloc);
			responsiveblocid = responsivebloc.attr('ckid');
			$ck('#' + responsiveblocid).attr(attribute, responsivebloc.attr('ckmobile'));
		});
	});
	ckSetReponsiveValues();
	ckSaveResponsiveCustomcode();
	$ck('#body .ckbloc').each(function() {
		$bloc = $ck(this);
		$bloc.removeClass('ckmobileediting');
		$bloc.find('.ckmobileoverlay').remove();
	});
	$ck('.ckbloc, .ckrowcontainer', $ck('#body')).each(function(i, bloc) {
		ckRemoveEdition(bloc);
	});
//	$ck('#cktoolbarResponsive').fadeOut();
	ckRemoveWorkspaceWidth();
//	$ck('.ckcolwidthedition').remove();
	$ck('.editorckresponsive').remove();
	ckSaveEdition('body', '', '', '', '', '.menuckpaneltarget[data-target="responsive"]');
	ckRemoveSpinnerIcon($ck('.ckleftpanelheadericon.cksave'));
}

function ckSetReponsiveValues() {
	var values = new Array();
	$ck('#cktoolbarResponsive .inputbox').each(function() {
		values.push(this.value);
	});
	values = values.join(',');
	$ck('#body').attr('responsivevalues', values);
}

function ckToggleResponsiveCustomCss() {
	$ck('#ckresponsivecustomcss').fadeToggle();
}

function ckSaveResponsiveCustomcode() {
	if (!$ck('.responsiveCustomcode').length) return;

	customcodes = '';
	var j = 1;
	$ck('.responsiveCustomcode').each(function(i, csscode) {
//		editor_customcss_responsive[j].save(); // save the editor to the textarea
		var code = $ck(csscode).attr('value').replace(/]/g, "|bbe|");
		customcodes += '[resolution'+$ck(csscode).attr('data-resolution')+']=['+code+']';
		j++;
	});

	// new method, store in the field to be saved with the template
	$ck('#htmlcode_responsive').val(customcodes);
}

function ckSwitchResponsive(responsiverange, force) {
//	var responsiverange = ckGetResponsiveRange();
	if (! force) force = false;
//	var resolution = parseFloat($ck('#ckresponsive' + responsiverange + 'value').val());
	var button = $ck('#ckresponsive' + responsiverange + 'button');

	// do nothing if click on the active button
	if (button.hasClass('active')) return;
	if (button.hasClass('active') && !force) {
		ckRemoveWorkspaceWidth();
	} else {
		$ck('#cktoolbarResponsive .ckbutton').removeClass('active').removeClass('ckbutton-warning');
		button.addClass('active').addClass('ckbutton-warning');
		ckSetWorkspaceWidth(responsiverange);
	}

	$ck('.ckbloc, .ckrowcontainer', $ck('#body')).each(function(i, bloc) {
		ckAddEdition(bloc);
		$ck('> .editorck .isControlResponsive', $ck(bloc)).removeClass('active');
		var mobilevalue = $ck(bloc).attr('ckresponsive' + responsiverange) ? $ck(bloc).attr('ckresponsive' + responsiverange) : 'mobile_default';
		$ck('> .editorck .isControlResponsive[data-mobile="' + mobilevalue + '"]', $ck(bloc)).addClass('active');
	});
}

function ckSetWorkspaceWidth(range) {
	var resolution = parseFloat($ck('#responsivevalue' + (range - 1)).val());
	var workspace = $ck('#body');
	workspace.css('width', resolution + 'px').attr('ckresponsiverange', range).addClass('ckresponsiveactive');
	if (range == '5') {
		workspace.css('width', '');
	}
	$ck('#menuck').attr('ckresponsiverange', range).addClass('ckresponsiveactive');
}

function ckRemoveWorkspaceWidth() {
	$ck('#cktoolbarResponsive .ckbutton').removeClass('active');
	var workspace = $ck('#body');
	workspace.css('width','').attr('ckresponsiverange', '').removeClass('ckresponsiveactive');
	$ck('#menuck').attr('ckresponsiverange', '').removeClass('ckresponsiveactive');
}

function ckGetResponsiveRange() {
	var responsiverange = $ck('#body').attr('ckresponsiverange') ? $ck('#body').attr('ckresponsiverange') : '5';
	return responsiverange;
}

function ckToggleResponsive(btn) {
	var btn = $ck(btn);
	var ckbloc = $ck(btn.parents('.editorck')[0]).parent();
	var ckresponsiverange = ckGetResponsiveRange();
	var setting = btn.attr('data-mobile');

	// make the eye button to auto disable on reclic
	if (setting === 'mobile_hide' && btn.hasClass('active')) {
		btn.parent().find('> .isControlResponsive[data-mobile="mobile_default"]').click();
		return;
	}

	$ck('> .editorck .isControlResponsive', ckbloc).removeClass('active');
	btn.addClass('active');
	ckbloc.attr('ckresponsive' + ckresponsiverange, setting);

	if (ckbloc.hasClass('column1') || ckbloc.hasClass('column2')) {
		if (ckbloc.hasClass('column1') && setting == 'mobile_hide') {
			$ck('.maincontent').attr('ckresponsive' + ckresponsiverange, 'mobile_lefthidden');
		} else if (ckbloc.hasClass('column1')) {
			$ck('.maincontent').attr('ckresponsive' + ckresponsiverange, '');
	}
	if (ckbloc.hasClass('column2') && setting == 'mobile_hide') {
			$ck('.maincenter').attr('ckresponsive' + ckresponsiverange, 'mobile_righthidden');
		} else if (ckbloc.hasClass('column2')) {
			$ck('.maincenter').attr('ckresponsive' + ckresponsiverange, '');
		}
	}
}

function ckGetdefaultwidth(nbmodules) {
	var defaultwidths = new Array();
	defaultwidth = 100 / parseInt(nbmodules);
	for (i = 0; i < nbmodules; i++) {
		defaultwidths.push(defaultwidth);
	}
	return defaultwidths;
}

function ckSaveModulesPopup() {
	var editionarea = $ck('#ckedition');
	var focus = $ck('.ckfocus');
	numberofmodules = $ck('#modulenumberselect').attr('value');
	focus.attr('numberofmodules', numberofmodules);
	var focusfieldslist = new Array();
	$ck('.modulemanagercontainer').each(function(i, modulesrow) {
		modulesrow = $ck(modulesrow);
		nbmodules = modulesrow.attr('nbmodules');
		moduleswidth = new Array();
		$ck('.modulewidthselect', modulesrow).each(function(j, module) {
			module = $ck(module);
			moduleswidth.push(parseFloat(module.attr('value')));
		});
		focus.attr('moduleswidth' + (i + 2), moduleswidth.join(','));
		focus.attr('isdisabledmodule' + (i + 2), modulesrow.hasClass('disabled'));
		focus.find('.flexiblemodule:eq(' + (i + 1) + ')').attr('isdisabled', modulesrow.hasClass('disabled'));

	});

	moduleswidth = focus.attr('moduleswidth' + numberofmodules) ? focus.attr('moduleswidth' + numberofmodules).split(',') : ckGetdefaultwidth(numberofmodules);
	$ck('.flexiblemodule', focus).each(function(i, module) {
		module = $ck(module);
		module.css('width', parseFloat(moduleswidth[i]) + '%');
		focusfieldslist.push('moduleswidth' + (i + 2));
		focusfieldslist.push('isdisabledmodule' + (i + 2));
	});
	focusfieldslist.push('numberofmodules');
	focus.attr('paramslist', focusfieldslist.join(','));
	editionarea.empty().hide();
}

function ckSaveRowPopup() {
	var editionarea = $ck('#ckedition');
	var focus = $ck('.ckfocus');
	numberofmodules = $ck('#blocnumberselect').attr('value');
	focus.attr('numberofmodules', numberofmodules);
	var focusfieldslist = new Array();

	if ($ck('> .inner > .ckrowcontainer', focus).length < numberofmodules) {
		nbexistingblocs = $ck('> .inner > .ckrowcontainer', focus).length;
		$ck(document.body).append('<div id="ckwaitoverlay"></div>');
		for (var i=0; i < (numberofmodules - nbexistingblocs); i++) {
			// createEmptyBloc(focus);
			ckCreateRowContainer(focus);
		}
		$ck('#ckwaitoverlay').remove();
	}
	$ck('> .inner > .ckrowcontainer', focus).each(function(i, bloc) {
		bloc = $ck(bloc);
		bloc.css('width', parseFloat($ck('.modulewidthselect').eq(i).val()) + '%');
		bloc.attr('data-width', parseFloat($ck('.modulewidthselect').eq(i).val()));
		if (i >= numberofmodules) {
			if (bloc.find('.ckbloc').length) {
				bloc.prev().append(bloc.find('.ckbloc'));
				bloc.remove();
			} else {
				bloc.remove();
			}
		}
	});
	focusfieldslist.push('numberofmodules');
	focus.attr('paramslist', focusfieldslist.join(','));
	editionarea.empty().hide();
	ckSaveAction();
}

function ckCreateRowContainer(focus) {
	var idbase = focus.attr('id') + 'column';
	var containerid = ckGetNewStyleId(idbase);
	var newcontainer = $ck('<div class="ckrowcontainer" id="' + idbase + containerid + '"></div>');
	focus.find('> .inner').append(newcontainer);
	ckMakeRowcontainerSortable(newcontainer);
	ckAddControlsOnHover(newcontainer);
}

function ckFixRowContainerBC() {
	$ck('.ckrow').each(function() {
		$row = $ck(this);
		var idbase = $row.attr('id') + 'column';
		$row.find('.ckrowcontainer').each(function() {
			$col = $ck(this);
			if (! $col.attr('id')) {
				var containerid = ckGetNewStyleId(idbase);
				$col.attr('id', idbase + containerid);
			}
		});
		
	});
}

function ckSaveMaincontentPopup() {
	var editionarea = $ck('#ckedition');
	var focus = $ck('.ckfocus');
	$ck('.maincontentmanager').each(function(i, module) {
		module = $ck(module);
		var target = module.attr('target');
		focus.attr('isdisabledmodule' + target, module.hasClass('disabled'));
		focus.find('.' + target).attr('isdisabled', module.hasClass('disabled'));
	});
	if ((focus.find('.maintop').attr('isdisabled') == 'true' && focus.find('.mainbottom').attr('isdisabled') == 'true')
//			|| focus.find('.column2').attr('isdisabled') == 'true'
		) {
		focus.find('.maincenter').attr('ishidden', 'true');
	} else {
		focus.find('.maincenter').attr('ishidden', 'false');
	}
	if (focus.find('.centertop').attr('isdisabled') == 'true'
			&& focus.find('.centerbottom').attr('isdisabled') == 'true') {
		focus.find('.content').attr('ishidden', 'true');
	} else {
		focus.find('.content').attr('ishidden', 'false');
	}
	if (focus.find('.column2').attr('isdisabled') == 'true') {
		focus.addClass('norightcol');
		focus.find('.center').attr('ishidden', 'true');
	} else {
		focus.removeClass('norightcol');
		focus.find('.center').attr('ishidden', 'false');
	}
	if (focus.find('.column1').attr('isdisabled') == 'true') {
		focus.addClass('noleftcol');
		focus.find('.main').attr('ishidden', 'true');
	} else {
		focus.removeClass('noleftcol');
		focus.find('.main').attr('ishidden', 'false');
	}
	focus.find('.column1').attr('blocwidth', $ck('#blocwidthselectleft').attr('value'));
	focus.find('.column2').attr('blocwidth', $ck('#blocwidthselectright').attr('value'));
	updateColumnsWidth();
	editionarea.empty().hide();
	ckSaveAction();
}

function updateColumnsWidth() {
	var focus = $ck('.ckfocus');
	var column1width = focus.find('.column1').attr('blocwidth');
	var mainwidth = focus.find('.column1').attr('isdisabled') == 'true' ? '100%' : (100 - parseFloat(column1width)) + '%';
	var rightwidthratio = parseFloat((100 - parseFloat(column1width))/100);
	var column2width = (parseFloat(focus.find('.column2').attr('blocwidth')) / rightwidthratio) + '%';
	var centerwidth = focus.find('.column2').attr('isdisabled') == 'true' ? '100%' : (100 - parseFloat(column2width)) + '%';
	focus.find('.column1').css('width', column1width);
	focus.find('.main').css('width', mainwidth);
	focus.find('.column2').css('width', column2width);
	focus.find('.center').css('width', centerwidth);
}

function saveBannerPopup() {
	var editionarea = $ck('#ckedition');
	var focus = $ck('.ckfocus');
	$ck('.bannermanager').each(function(i, module) {
		module = $ck(module);
		var target = module.attr('target');
		focus.attr('isdisabledmodule' + target, module.hasClass('disabled'));
		focus.find('.' + target).attr('isdisabled', module.hasClass('disabled'));
	});

	logotabblocstyles = focus.find('.bannerlogo > .tab_blocstyles');
	if (logotabblocstyles.length) {
		logofieldslist = logotabblocstyles.attr('fieldslist');
		if (logofieldslist.toLowerCase().indexOf('blocwidth') == -1) logofieldslist += ',blocwidth';
		logotabblocstyles.attr('fieldslist', logofieldslist);
	}
	
	moduletabblocstyles = focus.find('.banner > .tab_blocstyles');
	if (moduletabblocstyles.length) {
		modulefieldslist = moduletabblocstyles.attr('fieldslist');
		if (modulefieldslist.toLowerCase().indexOf('blocwidth') == -1) modulefieldslist += ',blocwidth';
		moduletabblocstyles.attr('fieldslist', modulefieldslist);
	}
	
	menutabblocstyles = focus.find('.bannermenu > .tab_blocstyles');
	if (menutabblocstyles.length) {
		menufieldslist = menutabblocstyles.attr('fieldslist');
		if (menufieldslist.toLowerCase().indexOf('blocwidth') == -1) menufieldslist += ',blocwidth';
		menutabblocstyles.attr('fieldslist', menufieldslist);
	}

	focus.find('.bannerlogo > .tab_blocstyles').attr('blocwidth', $ck('#blocwidthselectlogo').attr('value'));
	focus.find('.banner > .tab_blocstyles').attr('blocwidth', $ck('#blocwidthselectmodule').attr('value'));
	focus.find('.bannermenu > .tab_blocstyles').attr('blocwidth', $ck('#blocwidthselectmenu').attr('value'));

	focus.find('.bannerlogo').css('width', $ck('#blocwidthselectlogo').attr('value'));
	focus.find('.banner').css('width', $ck('#blocwidthselectmodule').attr('value'));
	focus.find('.bannermenu').css('width', $ck('#blocwidthselectmenu').attr('value'));
	
	editionarea.empty().hide();
	ckSaveAction();
}

function ckRenderCss(blocid, editionarea, focus, forpreviewarea, returnFunc) {
	ckAddSpinnerIcon($ck('.ckleftpanel-tools .cksave'));
	editionarea = editionarea ? editionarea : $ck('#ckedition');
	focus = focus ? $ck(focus) : $ck('.ckfocus');
	forpreviewarea = forpreviewarea ? forpreviewarea : false; // TODO check if needed
	returnFunc = returnFunc ? returnFunc : '';
	blocid = blocid ? blocid : focus.attr('id');
	// check for responsive state
//	var isResponsive = false;
	var responsiveRangeNumber = ckGetResponsiveRangeNumber();
	var variationRangeNumber = ckGetVariationRangeNumber();
//	if ($ck('#body').hasClass('ckresponsiveactive') && $ck('#body').attr('ckresponsiverange')) {
//		isResponsive = true;
//	}

	if (forpreviewarea) {
		blocid = focus.attr('id');
	}
	
	var fieldslist = new Array();
	fields = new Object();
	$ck('.inputbox', editionarea).each(function(i, el) {
		el = $ck(el);
		fields[el.attr('name')] = el.val();
		if (el.attr('type') == 'radio') {
			if (el.attr('checked')) {
				fields[el.attr('id')] = 'checked';
			} else {
				fields[el.attr('id')] = '';
			}
		}
	});

	var styleswrapper = ckGetStylesWrapperForBlock(blocid);

//	var responsiveSelector = responsiveRangeNumber&& responsiveRangeNumber !== '5' ? '.ckresponsiverange' + responsiveRangeNumber : '';
	if (responsiveRangeNumber&& responsiveRangeNumber !== '5') {
		var selector = '.ckresponsiverange' + responsiveRangeNumber;
	} else if (variationRangeNumber&& variationRangeNumber !== '0') {
		var selector = '.ckvariationrange' + variationRangeNumber;
	} else {
		var selector = '';
	}

	$ck('> .ckprops' + selector, styleswrapper).each(function(i, ckprops) {
		ckprops = $ck(ckprops);
		fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
		for (j=0;j<fieldslist.length;j++) {
			fieldname = fieldslist[j];
			if (typeof(fields[fieldname]) == 'null' || typeof(fields[fieldname]) == 'undefined') 
				fields[fieldname] = ckprops.attr(fieldname);
		}
	});

	fields = JSON.stringify(fields);
	customstyles = new Object();
	$ck('.menustylescustom').each(function() {
		$this = $ck(this);
		customstyles[$this.attr('data-prefix')] = $this.attr('data-rule');
	});
	customstyles = JSON.stringify(customstyles);

	ckSaveEdition(blocid, '', '', false, false, editionarea); // TODO : pass the responsive code to save with resopnsive suffix
	ckUpdateSvgIconSettings();
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxrendercss&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templatename: $ck('#name').attr('value'),
			objclass: focus.attr('class'),
			ckobjid: blocid,
			action: 'preview',
			fields: fields,
			customstyles: customstyles,
			responsiveRangeNumber: responsiveRangeNumber,
			variationRangeNumber: variationRangeNumber
		}
	}).done(function(code) {
		if (forpreviewarea) $ck('> .ckstyle', $ck('#' + blocid)).empty().append(code);
//		var csscode = code.replace(/\|ID\|/g, '#'+blocid);
//		$ck('> .ckstyle', $ck('#' + blocid)).empty().append(csscode);
		ckSetStyleForBloc(blocid, code); // TODO pass the responsive range to save in another item
		if (CKBLOCCKSTYLESBACKUP != 'undefined') {
			CKBLOCCKSTYLESBACKUP = code;
		}
//		$ck('.ckstyle[data-id="' + blocid + '"]', $ck('#ckstylescontainer, #ckelementscontentfavorites #' + blocid)).empty().append(code);
		ckRemoveSpinnerIcon($ck('.ckleftpanel-tools .cksave'));
		$ck('#ckparamsfake').empty();
		if (typeof(window[returnFunc]) == 'function') window[returnFunc]();
		ckSaveAction();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckAddSpinnerIcon(btn) {
	if (! btn.attr('data-class')) var icon = btn.find('.fack').attr('class');
	btn.attr('data-class', icon).find('.fack').attr('class', 'fack fack-spinner fack-pulse');
}

function ckRemoveSpinnerIcon(btn) {
	btn.find('.fack').attr('class', btn.attr('data-class'));
}

function ckCloseEdition(keepopen) {
	if (! keepopen) keepopen = $ck('.ckleftpanel').hasClass('cksticked');
	if (typeof ckBeforeCloseEditionPopup == 'function') { ckBeforeCloseEditionPopup(); }
	if (! keepopen) $ck('#ckedition').empty().fadeOut();
	$ck('.ckfocus').removeClass('ckfocus');
}

function ckLoadTab_menustyles() {
	bloc = $ck('[data-id="tab_menustyles"] > .inner');
	if (bloc.html().trim())
		return;
	bloc.append('<div id="ckwaitoverlay"></div>');
	var blocid = $ck('.ckfocus').attr('id');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxtabmenustyles&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			objclass: bloc.attr('class'),
			expertmode: $ck('#body').hasClass('expert')
		}
	}).done(function(code) {
		bloc.empty().append(code);
		ckAddGoogleFontsToList()
		ckFillEdition(blocid);
		ckAddEventOnFields($ck('#ckedition'), blocid, bloc);
//		loadPreviewAreaStyles('#' + $ck('.ckfocus').attr('id'));
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckLoadTab_customcode() {
	bloc = $ck('#tab_customcode');
	var boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="saveCustomCode();CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
//	if (bloc.html()) {
//		CKBox.open({handler: 'inline', content: 'tab_customcode', footerHtml: boxfooterhtml});
//		return;
//	}
	bloc.append('<div id="ckwaitoverlay"></div>');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxtabcustomcode&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templateid: TEMPLATEID,
			templatename: $ck('#name').val()
		}
	}).done(function(code) {
		bloc.empty().append(code);
		CKBox.open({handler: 'inline', content: 'tab_customcode', footerHtml: boxfooterhtml});
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckLoadTab_customcss(layout) {
	if (! layout) layout = '';
	let layouttab = '';
	if (layout) {
		layouttab = 'layout';
	}
	bloc = $ck('#tab_customcss');
	var boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="saveCustomCss(\'' + layout + '\');CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
//	if (bloc.html()) {
//		CKBox.open({handler: 'inline', content: 'tab_customcss', footerHtml: boxfooterhtml});
//		return;
//	}
	bloc.append('<div id="ckwaitoverlay"></div>');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxtabcustomcss" + layouttab + "&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templateid: TEMPLATEID,
			customlayout: layout,
			templatename: $ck('#name').val()
		}
	}).done(function(code) {
		bloc.empty().append(code);
		CKBox.open({handler: 'inline', content: 'tab_customcss', footerHtml: boxfooterhtml});
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckShowLayoutPopup(layout) {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxlayout" + layout + "&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templatename: $ck('#name').val()
		}
	}).done(function(code) {
		$ck('#ckpopup').empty().append(code);
		$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveLayoutPopup(\'error404\');CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
		CKBox.open({handler: 'inline', content: 'ckpopup', style: {padding: '10px'}, footerHtml: $boxfooterhtml});
		$ck('#ckwaitoverlay').remove();
		ckAddGoogleFontsToList();
		ckFillEdition('layout_' + layout + '_html');
//		loadPreviewAreaStyles('#layout_' + layout + '_html', 'previewarealayout' + layout);
		if (typeof(window['ckUpdateLayoutPreview' + layout]) == 'function') window['ckUpdateLayoutPreview' + layout]();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

/* ----------------------------------------------------------------------------------------------------------------------------------------
 TEMPLATE CREATION AND PREVIEW
 ---------------------------------------------------------------------------------------------------------------------------------------------*/

/*
 * Create the full template archive
 */
function ckCreateTemplate(action) {
	if ($ck('#name').attr('value') == '') {
		alert(TCK.Text._('TEMPLATE_MUST_HAVE_NAME', 'You must give a name to the template'));
		ckEditGlobalinfos();
		$ck('#name').focus();
		return;
	}

	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	var blocs = ckGetBlocks();
	blocs = JSON.stringify(blocs);
	blocs = blocs.replace(/#/g, "|di|");
	
	// responsive, loop though the 4 resolutions
	var responsiveCss = new Object();
	for (var r=4; r>=1; r--) {
			var responsiveCssByResolution = ckGetResponsiveCssByResolution(r);
			responsiveCss['responsivecss' + r] = responsiveCssByResolution;
	}
	responsiveCss = JSON.stringify(responsiveCss);

	// responsive, loop though the 4 resolutions
	var variationCss = new Object();
	// TODO il faut faire un check pour connaitre le nombre de variations
	for (var r=4; r>=1; r--) {
		var variationCssByNumber = ckGetvariationCssByNumber(r);
		variationCss['variationcss' + r] = variationCssByNumber;
	}
	variationCss = JSON.stringify(variationCss);
	var htmlcode = ckMakeHtmlOutput();
	// get the widgets list
	var widgets = ckGetWidgetsData();
	jsonWidgets = JSON.stringify(widgets);

	var layoutcommentscss = $ck('#layout_comments_html > .ckstyle').length ? $ck('#layout_comments_html > .ckstyle').text() : '';
	var layouterror404custommessage = $ck('#layout_error404_html > .error404custommessage').length ? $ck('#layout_error404_html > .error404custommessage').html() : '';

	var positions = [];
	$ck('.ckbloc').each(function(i, bloc) {
		bloc = $ck(bloc);
		if (bloc.attr('isdisabled') == 'true') {
			bloc.find('.ckbloc').attr('isdisabled' , 'true');
		} else if (bloc.attr('isdisabled') == 'false'){
//			bloc.find('.ckbloc').attr('isdisabled' , 'false'); // don't do that else it will force to enable all blocks
		}
		if (bloc.attr('ckmoduleposition') && bloc.attr('isdisabled') != 'true') {
			positions.push(bloc.attr('ckmoduleposition'));
		}
	});

	var customstyles = new Object();
	var customstylesObject = new Object();
	$ck('#ckstylescontainer [data-id^="ckcustomstyle"]').each(function() {
		$this = $ck(this);
		customstyles[$this.attr('data-id')] = $this.attr('data-cssselector') ? '.' + $this.attr('data-cssselector') : '.' + $this.attr('data-id');
		customstylesObject[$this.attr('data-id')] = {'cssselector' : $this.attr('data-cssselector'), 'name' : $this.attr('data-name')};
	});
	customstyles = JSON.stringify(customstyles);
	customstylesObject = JSON.stringify(customstylesObject);

	var customslayoutcss = '';
	$ck('#ckstylescontainer [data-id^="ckcustomlayout"]').each(function() {
		$this = $ck(this);
		if ($this.find('style').length) customslayoutcss += $this.find('style').html();
	});

	var bodyfontsprops = ckGetPropsForBloc('body', 'googlefonts');
	var googlefonts = bodyfontsprops.attr('fontslist') ? bodyfontsprops.attr('fontslist') : '';
	var googlefontsuselocal = bodyfontsprops.attr('uselocal') ? bodyfontsprops.attr('uselocal') : '0';
	var svgicons = new Object();
	$ck('#body .fack svg').each(function() {
		svgicons[$ck(this).parent().attr('data-path')] = this.outerHTML;
	});
	svgicons = JSON.stringify(svgicons);

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxcreatetemplate&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			bodycode: htmlcode["body"],
			headcode: htmlcode["head"].replace(/<\?/g, '|ot|').replace(/\?>/g, '|ct|'),
			csscode: htmlcode["css"],
			joomlaversion: $ck('#joomlaversion').attr('value'),
			templatename: $ck('#name').attr('value'),
			creationdate: $ck('#creationdate').attr('value'),
			author: $ck('#author').attr('value'),
			authorEmail: $ck('#authoremail').attr('value'),
			authorUrl: $ck('#authorurl').attr('value'),
			copyright: $ck('#copyright').attr('value'),
			license: $ck('#license').attr('value'),
			version: $ck('#version').attr('value'),
			description: $ck('#description').attr('value'),
			blocs: blocs,
			id: TEMPLATEID,
			action: action,
			widgets: jsonWidgets,
			facktoload: ($ck('.fack > span').length > 0),
			column1width: COLUMN1WIDTH,
			column2width: COLUMN2WIDTH,
			templateid: TEMPLATEID,
			templateidentifier: TEMPLATEIDENTIFIER,
			htmlcode_responsive: $ck('#htmlcode_responsive').val(),
			responsivevalues: $ck('#body').attr('responsivevalues'),
			layoutcommentscss: layoutcommentscss,
			layouterror404custommessage: layouterror404custommessage,
			customstyles: customstyles,
			customstylesobject: customstylesObject,
			customslayoutcss: customslayoutcss,
			positions: positions,
			colors: $ck('#body').attr('colorpalette'),
			googlefonts: googlefonts,
			googlefontsuselocal: googlefontsuselocal,
			svgicons: svgicons.replace(/</g, '|lt|').replace(/>/g, '|gt|'),
			responsivecss: responsiveCss,
			variationcss: variationCss
		},
		statusCode: {
			500: function(r) {
				alert('Template Creator CK Error message : you go a 500 error, this is an error on your server. Please contact the support to find a solution.');
			}
		}
	}).done(function(code) {
		$ck('#ckwaitoverlay').remove();
		$ck('#ckpopup').empty().append(code);
		CKBox.open({handler: 'inline', content: 'ckpopup', size: {x: '700px'}, style: {padding: '10px'} });

		ckAutoCreateThumbs();
		if (action == 'install') {
			ckInstallTemplate();
		}
	}).fail(function() {
		$ck('#ckwaitoverlay').remove();
		$ck('#ckpopup').empty().append(TCK.Text._('CK_LOAD_FAILURE_TEMPLATE_CREATION', 'The template creation encountered some errors'));
	});

}

function ckGetBlocks() {
	var blocs = new Array();
	var cssblocs = new Object();
	var i = 0;
	$ck('.ckbloc, .ckrowcontainer').each(function(j, bloc) {
		bloc = $ck(bloc);
		var blocid = bloc.attr('id') ? bloc.attr('id') : bloc.attr('data-id');
		if (bloc.attr('isdisabled') == 'true') {
			bloc.find('.ckbloc').attr('isdisabled' , 'true');
		} else if (bloc.attr('isdisabled') == 'false'){
//			bloc.find('.ckbloc').attr('isdisabled' , 'false');
		}
		if (bloc.attr('isdisabled') != 'true' && blocid) {
			
			var cssblocs = ckGetBlock(bloc, j)
			blocs[i] = cssblocs;
			i++;
		}
	});
	$ck('#ckstylescontainer [data-id^="ckcustomstyle"], #ckstylescontainer [data-id^="ckcustomlayout"]').each(function(j, bloc) {
		bloc = $ck(bloc);
		var blocid = bloc.attr('id') ? bloc.attr('id') : bloc.attr('data-id');
		if (bloc.attr('isdisabled') != 'true' && blocid) {
			var cssblocs = ckGetBlock(bloc, j)
			blocs[i] = cssblocs;
			i++;
		}
	});

	return blocs;
}

function ckGetBlock(bloc, j) {
	var responsiverange = ''; // not used for now
	var blocid = bloc.attr('id') ? bloc.attr('id') : bloc.attr('data-id');
	var blocinner = blocid === 'body' ? bloc : bloc.find('> .inner');
	var cssblocs = new Object();
	var fieldslist = new Array();
	cssblocs['class'] = bloc.attr('class');
	cssblocs['ckid'] = blocid;
//			if (bloc.attr('id') == "body" || bloc.attr('id') == "wrapper")
//				cssblocs['ckid'] = bloc.attr('id');
	cssblocs['ckclass'] = bloc.attr('ckclass') ? bloc.attr('ckclass') : '';
	cssblocs['data-class'] = blocinner.attr('data-class') ? blocinner.attr('data-class') : '';
	cssblocs['ckmoduleposition'] = bloc.attr('ckmoduleposition');
	cssblocs['ckmodulestyle'] = bloc.attr('ckmodulestyle');
	cssblocs['ckresponsive1'] = bloc.attr('ckresponsive1');
	cssblocs['ckresponsive2'] = bloc.attr('ckresponsive2');
	cssblocs['ckresponsive3'] = bloc.attr('ckresponsive3');
	cssblocs['ckresponsive4'] = bloc.attr('ckresponsive4');
	cssblocs['ckresponsive5'] = bloc.attr('ckresponsive5');
	cssblocs['isdisabled'] = bloc.attr('isdisabled');
	cssblocs['ishidden'] = bloc.attr('ishidden');
	cssblocs['icon'] = bloc.find('.fack').attr('data-type');
	cssblocs['iconpos'] = (bloc.find('.fack').attr('data-pos') ? bloc.find('.fack').attr('data-pos') : '');
	cssblocs['iconsize'] = (bloc.find('.fack').attr('data-size') ? bloc.find('.fack').attr('data-size') : '');
	cssblocs['iconvpos'] = (bloc.find('.fack').attr('data-vpos') ? bloc.find('.fack').attr('data-vpos') : '');
	cssblocs['iconpath'] = (bloc.find('.fack').attr('data-path') ? bloc.find('.fack').attr('data-path') : '');

	if (bloc.hasClass('ckrow')) {
		cssblocs['children'] = new Array();
		bloc.find('.ckbloc').each(function(i, el){ 
			if (! $ck(el).hasClass('flexiblemodule'))
				cssblocs['children'].push($ck(el).attr('id'));
		});
	}
	if (bloc.attr('fieldslist'))
		fieldslist = bloc.attr('fieldslist').split(",");
	var paramslist = bloc.attr('paramslist') ? bloc.attr('paramslist').split(",") : Array();
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var selector = responsiverange && responsiverange !== '5' ? '.ckresponsive' + responsiverange : ':not(.ckresponsive):not(.ckvariation)';
	styleswrapper.find('> .ckprops' + selector).each(function(i, ckprops) {
		ckprops = $ck(ckprops);
		fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
		for (j=0;j<fieldslist.length;j++) {
			fieldname = fieldslist[j];
			cssblocs[fieldname] = ckprops.attr(fieldname);
		}
	});
	for (j=0;j<paramslist.length;j++) {
		fieldname = paramslist[j];
		cssblocs[fieldname] = bloc.attr(fieldname);
	}
	return cssblocs;
}


/**
 *
 * Function to generate the preview button
 */

function makePreviewStep() {
	var myurl = URIROOT + "/index.php?option=com_content&templatename=" + $ck('#name').attr('value') + "&template=templatecreatorck&tmpl=preview";
	var previewlink = '<p styles="padding:15px"><a class="ckpreview ckbuttonstyle" href="' + myurl + '" target="_blank">' + TCK.Text._('CK_PREVIEW_TEMPLATE', 'Preview the template') + '</a></p>';
	$ck('.packagesteparchive').append(previewlink);
	ckAutoCreateThumbs();
}


/**
 *
 * Function to generate final html code
 */
function ckMakeHtmlOutput() {
	var code = new Array('head', 'body');
	var video = ckGetVideoCode($ck('#body'));
	code['head'] = '';
	code['body'] = '' + video["code"];
	code['css'] = '';
	var j = 0;
	var wrappercondition = false;
	iW = 0; // index for wrappers
	$ck('.wrapper.ckbloc, .wrapper > .inner > .ckbloc').each(function(i, bloc) {
		bloc = $ck(bloc);
		var retrievecode = '';

		// Begin the modules code construction
		codetmp = ckGetBlockHtml(bloc, j, 0);
		code['body'] += codetmp['body'];
		code['head'] += codetmp['head'];
		code['css'] += codetmp['css'];

		// construct a wrapper
		if (bloc.hasClass('wrapper')) {
			retrievecode = ckMakeWrapper(bloc, iW, wrappercondition);
			code['body'] += retrievecode['body'];
			code['head'] += retrievecode['head'];
			wrappercondition = retrievecode['wrappercondition'];
			iW++;
		}

		code['body'] += '|rr|';
		j++;
	});

	code['body'] += '|tab|</div>|rr|'
					+ '</div>|rr|';

	if (wrappercondition) {
		code['body'] += '<?php endif; ?>';
	}

	return code;
}



/***********************************************
 * modules html creation *
 * *********************************************/

function ckAddVideoBackground(bloc) {
	var blocprops = ckGetPropsForBloc(bloc.attr('id'), 'tab_videobgstyles');
	var webmurl = blocprops.attr('blocvideourlwebm') ? blocprops.attr('blocvideourlwebm') : '';
	var mp4url = blocprops.attr('blocvideourlmp4') ? blocprops.attr('blocvideourlmp4') : '';
	var ogvurl = blocprops.attr('blocvideourlogv') ? blocprops.attr('blocvideourlogv') : '';
	var youtubeurl = blocprops.attr('blocvideourlyoutube') ? blocprops.attr('blocvideourlyoutube') : '';
	var muted = (blocprops.attr('blocvideomuted1') && blocprops.attr('blocvideomuted1') == 'checked') ? '' :' muted';
	var videocode = '';
	var poster = blocprops.attr('blocvideoposter') ? 'poster="' + blocprops.attr('blocvideoposter') + '"' : '';

	if (webmurl || mp4url || ogvurl) {
		videocode = '|tab||tab|<video autoplay playsinline loop' + muted + ' ' + poster + ' class="videobackground">|rr|'
						+ (webmurl ? '|tab||tab||tab|<source src="'+webmurl+'" type="video/webm">|rr|' : '')
						+(mp4url ? '|tab||tab||tab|<source src="'+mp4url+'" type="video/mp4">|rr|' : '')
						+(ogvurl ? '|tab||tab||tab|<source src="'+ogvurl+'" type="video/ogg">|rr|' : '')
					+'|tab||tab|</video>|rr|';
	} else if (youtubeurl) {
		youtubeurl = youtubeurl.replace('watch?v=', 'embed/');
		youtubeurl = youtubeurl.replace('https://youtu.be/', 'https://youtube.com/embed/');
		youtubeurl += '?autoplay=1&loop=0&rel=0&showinfo=0&controls=0&autohide=1';
		var ratioyoutube = blocprops.attr('blocratioyoutube') ? blocprops.attr('blocratioyoutube') : '';
		ratioyoutube = ratioyoutube ? ' style="padding-bottom:' + ratioyoutube + ';"' : '';
		videocode = '|tab||tab|<div class="videobackground_yt1">|rr|'
						+ '|tab||tab||tab|<div class="videobackground_yt2" ' + ratioyoutube + '>|rr|'
						+ '|tab||tab||tab||tab|<iframe src="'+youtubeurl+'" class="videobackground" frameborder="0" allow="autoplay;" ></iframe>|rr|'
					+'|tab||tab||tab|</div>|rr|'
					+'|tab||tab|</div>|rr|';
	}
	return videocode;
}

function ckCheckVideoBackground(bloc) {
	var blocprops = ckGetPropsForBloc(bloc.attr('id'), 'tab_videobgstyles');
	if (blocprops.length 
			&& (
				blocprops.attr('blocvideourlmp4')
				|| blocprops.attr('blocvideourlwebm')
				|| blocprops.attr('blocvideourlogv')
				|| blocprops.attr('blocvideourlyoutube')
			)
		)
			return true;
	return false;
}

function ckGetVideoCode(bloc) {
	var video = new Array();
	video['code'] = '';
	video['class'] = '';
	if (ckCheckVideoBackground(bloc)) {
		video['code'] = ckAddVideoBackground(bloc);
		video['class'] = ' hasvideobackground';
	}
	return video;
}

function ckGetIconAttribs(bloc) {
	if (! bloc.find('.fack').length) return '';
	var fack = bloc.find('.fack');
	if (fack.find('svg').length) {
		var icon = ' icon="svg"';
		var iconpos = ' iconpos="' + (fack.attr('data-pos') ? fack.attr('data-pos') : '') + '"';
		var iconsize = '';
		var iconvpos = '';
		var iconpath = ' iconpath="' + (fack.attr('data-path') ? fack.attr('data-path') : '') + '"';
		facktoload = false;
	} else {
		var icon = ' icon="' + fack.attr('data-type') + '"';
		var iconpos = ' iconpos="' + (fack.attr('data-pos') ? fack.attr('data-pos') : '') + '"';
		var iconsize = ' iconsize="' + (fack.attr('data-size') ? fack.attr('data-size') : '') + '"';
		var iconvpos = ' iconvpos="' + (fack.attr('data-vpos') ? fack.attr('data-vpos') : '') + '"';
		var iconpath = '';
		facktoload = true;
	}

	return icon + iconpos + iconsize + iconvpos + iconpath;
}

/**
 * Function to get all children bloc and get their module position
 *
 */
function getChildrenBlocksPositions(bloc) {
	var positions = bloc.find('.ckbloc').map(function() {
		if ($ck(this).attr('isdisabled') != 'true') return $ck(this).attr('ckmoduleposition'); 
	});
	
	return positions;
}

/**
 * Function to write the countModules condition for all blocks
 *
 */
function makeChildrenBlocksConditions(positions) {
	positions = $ck.makeArray(positions); // convert object to array

	var conditions = positions.join("', true) || CKCOUNTMODULE('");
	conditions = "CKCOUNTMODULE('" + conditions + "', true) || $tckedition";

	return conditions;
}

function ckGetShapeDividerHtml(bloc) {
	var html = '';
	bloc.find('> .tck-divider-container').each(function() {
		html += $ck(this)[0].outerHTML;
	});
	return html;
}

/**
 * Function to render a wrapper
 *
 */
function ckMakeWrapper(bloc,iW, wrappercondition) {
	var code = new Array("head", "body");
	code['head'] = '';
	code['body'] = '';
//	code["wrappercondition"] = wrappercondition;
	var video = ckGetVideoCode(bloc);
	var blocid = bloc.attr('id');
	var blocclass = ckGetBlocClass(bloc, true);
	blocclass += video["class"];
	blocclass = blocclass ? ' class="tck-wrapper ' + blocclass + '"' : ' class="tck-wrapper"';
	if (bloc.find('.ckbloc.singlemodule,.ckbloc.horiznav,.ckbloc.flexiblemodule').length
		&& ! bloc.find('.maincontent').length
		&& ! bloc.find('.logobloc').length
		&& ! bloc.find('.customcont').length
		) {
		// singlemodule, horiznav, flexiblemodule
		var childrenPositions = getChildrenBlocksPositions(bloc);
		var conditions = makeChildrenBlocksConditions(childrenPositions);
		code['wrappercondition'] = true;
	} else {
		code['wrappercondition'] = false;
	}
	var wrapperinnerclass = $ck('.inner', bloc).hasClass('tck-container') || $ck('.inner', bloc).hasClass('tck-container-fluid') ? $ck('.inner', bloc).attr('class').replace('ui-sortable', '') : $ck('.inner', bloc).attr('class').replace('ui-sortable', '').replace('container', 'tck-container');
	// since 4.0.19
	wrapperinnerclass = wrapperinnerclass.replace('tck-container-fluid', 'tck-container');

	// fix problems
	$ck('.inner', bloc).removeClass('tck-').removeClass('-fluid');

	wrapperinnerclasses = wrapperinnerclass.split(' ');
	for(var i = 0; i < wrapperinnerclasses.length; i++) {
		if (wrapperinnerclasses[i] === 'container'
			|| wrapperinnerclasses[i] === 'container-fluid'
		) {
			wrapperinnerclasses.splice(i, 1);
		}
	}
	wrapperinnerclass = wrapperinnerclasses.join(' ');

//	var shapedivider = bloc.find('> .tck-divider-container').length ? bloc.find('> .tck-divider-container')[0].outerHTML : '';
	var shapedivider = ckGetShapeDividerHtml(bloc);

	if (iW == 0) {
		if (code['wrappercondition'] == true) {
			code['body'] += '<?php if(' + conditions + ') : ?>|rr|';
		}
		
		code['body'] += '<div id="' + blocid + '"' + blocclass + '>|rr|'
				+ shapedivider
				+ video['code']
				+ '|tab|<div class="' + wrapperinnerclass +'">|rr|';
	} else {
		code['body'] = '|tab|</div>|rr|'
				+ '</div>|rr|';
		if (wrappercondition == true) {
			code['body'] += '<?php endif; ?>|rr|';
		}
		if (code['wrappercondition'] == true) {
			code['body'] +=  '<?php if(' + conditions + ') : ?>|rr|';
		}
		code['body'] +=  '<div id="' + blocid +'"' + blocclass + '>|rr|'
				+ shapedivider
				+ video['code']
				+ '|tab|<div class="' + wrapperinnerclass + video["class"] +'">|rr|';
	}
	// code['body'] += video['code'];

	return code;
}

/**
 * Function to render some flexible modules
 *
 */
function ckMakeHtmlRow(bloc, j, nbtabs) {
	// initialisation
	bloc = $ck(bloc);
	var code = new Array('head', 'body', 'css');
	code['head'] = '';
	code['body'] = '';
	code['css'] = '';

	var video = ckGetVideoCode(bloc);
	
//	var blocclass = bloc.attr('data-class') ? ' class="clearfix ' + bloc.attr("data-class") + '"' : ' class="clearfix"';
	var shapedivider = ckGetShapeDividerHtml(bloc);
	var rowclass = ckGetBlocClass(bloc, false, 'tck-row' + (shapedivider ? ' tck-relative' : ''));
	var rowinnerclass = ckGetBlocInnerClass(bloc, true);
//	var shapedivider = bloc.find('> .tck-divider-container').length ? bloc.find('> .tck-divider-container')[0].outerHTML : '';
	// singlemodule, horiznav, flexiblemodule
	var conditions = false;
	if (! bloc.find('.logobloc, .emptybloc, .custombloc').length) {
		var childrenPositions = getChildrenBlocksPositions(bloc);
		if (childrenPositions.length) {
			conditions = makeChildrenBlocksConditions(childrenPositions);
		}
	}

	if (conditions !== false) code['body'] += '|tab|<?php if (' + conditions + ') : ?>|rr|'
	code['body'] +=  '|tab|<section id="' + bloc.attr('id') + '" ' + rowclass + '>|rr|'
			+ shapedivider
			+ '|tab||tab|<div class="inner' + rowinnerclass + video["class"] +'">|rr|';

	code['body'] += video['code'];

	$ck('.ckrowcontainer', bloc).each(function(i, container) {
		container = $ck(container);
		var columnid = container.attr('id') ? ' id="' + container.attr('id') + '"' : '';
		var columnclass = ckGetBlocClass(container, true);
		var columnwidth = container.attr('data-real-width') ? container.attr('data-real-width') : container.attr('data-width') + '%';
		code['css'] += '#' + container.attr('id') + ' { width: ' + columnwidth + '; }' + "\n\n";
		code['body'] += '|tab||tab||tab|<div class="flexiblecolumn ' + columnclass + '"' + columnid + '>|rr|';
		$ck('.ckbloc', container).each(function(i, module) {
			module = $ck(module);
//			var modulemoduleposition = ckGetBlocModulePosition(module);
//			var moduleclass = ckGetBlocClass(bloc);
//			var moduleinnerclass = ckGetBlocInnerClass(bloc, true);
//			module.ckid = module.attr("id") ? ' id="' + module.attr("id") + '"' : '';
//			module.classe = module.attr("ckclass") ? ' class="' + module.attr("ckclass") + '"' : '';
//			module.jdocstyle = module.attr("ckmodulestyle") ? ' style="' + module.attr("ckmodulestyle") + '"' : ',';
//			module.jdocposition = module.attr("ckmoduleposition") ? module.attr("ckmoduleposition") : '';

			var tmpcode = ckGetBlockHtml(module, j+'r'+i, 3);
			code['head'] += tmpcode['head'];
			code['body'] += tmpcode['body'];
		});
		code['body'] += '|tab||tab||tab|</div>|rr|';
	});
	code['body'] += '|tab||tab|</div>|rr|'
			+ '|tab|</section>|rr|'
	if (conditions !== false) code['body'] += '|tab|<?php endif; ?>|rr||rr|';

	return code;
}

function ckGetBlocModulePosition(bloc) {
	return bloc.attr('ckmoduleposition') ? bloc.attr('ckmoduleposition') : '';
}

function ckGetBlocClass(bloc, withouthtml, additionalclass) {
	if (! withouthtml) withouthtml = false;
	if (! additionalclass) additionalclass = '';
	var blocclass = bloc.attr('ckclass') ? bloc.attr('ckclass') : '';
	if (withouthtml) {
		return blocclass + ((additionalclass && blocclass) ? ' ' + additionalclass : additionalclass);
	} else {
		if (blocclass || additionalclass) blocclass = ' class="' + blocclass + ((additionalclass && blocclass) ? ' ' + additionalclass : additionalclass) + '"';
	}

	return blocclass;
}

function ckGetBlocInnerClass(bloc, withouthtml) {
	if (! withouthtml) withouthtml = false;
	var blocclass = bloc.find('> .inner').attr('data-class') ? bloc.find('> .inner').attr('data-class') : '';
	if (withouthtml) {
		return blocclass ? ' ' + blocclass : '';
	} else {
		if (blocclass) blocclass = ' class="' + blocclass + '"';
	}
	return blocclass;
}
/**
 * Render a single module
 *
 */
function ckMakeHtmlSingleModule(bloc, nbtabs) {
	var code = new Array('head', 'body');
	code['head'] = '';
	code['body'] = '';

	var video = ckGetVideoCode(bloc);
	var offsettabs = ckStrRepeat('|tab|', nbtabs);
	var bloctag = (bloc[0] == $ck('.ckbloc').last()[0] ? 'footer' : 'div');
	var blocmoduleposition = ckGetBlocModulePosition(bloc);
	var blocclass = ckGetBlocClass(bloc, false, '');
	var blocinnerclass = ckGetBlocInnerClass(bloc, true);
	code['body'] = offsettabs + '|tab|<?php if (CKCOUNTMODULE(\'' + blocmoduleposition + '\', true) || $tckedition) : ?>|rr|'
			+ offsettabs + '|tab|<'+bloctag+' id="' + bloc.attr('id') + '" ' + blocclass + '>|rr|'
			+ offsettabs + '|tab||tab|<div class="inner' + video['class'] + blocinnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + blocmoduleposition + '">|rr|'
			+ offsettabs + video['code']
			+ offsettabs + '|tab||tab||tab|CKLOADMODULE(' + blocmoduleposition + ',' + ckGetIconAttribs(bloc) + ')|rr|'
			+ offsettabs + '|tab||tab|</div>|rr|'
			+ offsettabs + '|tab|</'+bloctag+'>|rr|'
			+ offsettabs + '|tab|<?php endif; ?>|rr|';
	return code;
}


/**
 * Function to render some flexible modules
 *
 */
function ckMakeHtmlFlexibleModules(bloc, j, nbtabs) {
	// initialisation
	bloc = $ck(bloc);
	var code = new Array('head', 'body');
	code['head'] = '';
	code['body'] = '';

	var shapedivider = ckGetShapeDividerHtml(bloc);
	var video = ckGetVideoCode(bloc);
	var offsettabs = ckStrRepeat('|tab|', nbtabs);
	var blocclass = ckGetBlocClass(bloc, false, 'tck-modules' + (shapedivider ? ' tck-relative ' : ''));
	var blocinnerclass = ckGetBlocInnerClass(bloc, true);
	code['body'] += offsettabs + '|tab|<?php if ($nbmodules' + j + ' || $tckedition) : ?>|rr|'
			+ offsettabs + '|tab|<section id="' + bloc.attr('id') + '" ' + blocclass + '>|rr|'
			+ offsettabs + '|tab||tab|<div class="inner' + blocinnerclass + video['class'] + ' <?php echo \'n\'.$nbmodules' + j + ' ?>">|rr|'
			+ offsettabs + shapedivider;
			+ offsettabs + video['code'];

	code['head'] += '<?php|rr|'
			+ '$nbmodules' + j + ' = ';

	$ck('.flexiblemodule', bloc).each(function(i, module) {
		module = $ck(module);
		if (module.attr('isdisabled') != 'true') {
			if (i > 0)
				code["head"] += ' + ';
			video = ckGetVideoCode(module);
			// retrieve data for the block
			var modulemoduleposition = ckGetBlocModulePosition(module);
			var moduleclass = ckGetBlocClass(module, true);
			var moduleinnerclass = ckGetBlocInnerClass(module, true);

			code['body'] += offsettabs + '|tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + modulemoduleposition + '\', true) || $tckedition) : ?>|rr|'
					+ offsettabs + '|tab||tab||tab|<div id="' + module.attr('id') + '"' + ' class="flexiblemodule ' + moduleclass + '">|rr|'
					+ offsettabs + '|tab||tab||tab||tab|<div class="inner' + moduleinnerclass + video['class'] + ' <?php echo $tckeditionclass ?>" data-position="' + modulemoduleposition + '">|rr|'
					+ offsettabs + video['code']
					+ offsettabs + '|tab||tab||tab||tab||tab|CKLOADMODULE(' + modulemoduleposition + ',' + ckGetIconAttribs(module) + ')|rr|'
					+ offsettabs + '|tab||tab||tab||tab|</div>|rr|'
					+ offsettabs + '|tab||tab||tab|</div>|rr|'
					+ offsettabs + '|tab||tab||tab|<?php endif; ?>|rr|';

			code['head'] += '(bool)CKCOUNTMODULE(\'' + modulemoduleposition + '\', true)';
		}
	});
	code['body'] += offsettabs + '|tab||tab|</div>|rr|'
			+ offsettabs + '|tab|</section>|rr|'
			+ offsettabs + '|tab|<?php endif; ?>|rr||rr|';

	code['head'] += ';|rr|'
			+ '?>|rr|';

	return code;
}

/**
 * Function to render a banner with logo
 *
 */
function ckMakeHtmlLogo(bloc, nbtabs) {
	// initialisation
	var code = new Array('head', 'body');
	code['head'] = '';
	code['body'] = '';

	var offsettabs = ckStrRepeat('|tab|', nbtabs);
	// retrieve data for the block
	var blocid = bloc.attr('id');
	var blocclass = ckGetBlocClass(bloc, false, 'tck-logo');
	var blocinnerclass = ckGetBlocInnerClass(bloc, true);
	var blocprops = ckGetPropsForBloc(blocid, 'tab_blocstyles')
	bloc.logoimage = $ck('img', bloc) ? $ck('img', bloc).attr('src').split("/").reverse()[0] : '';
	bloc.logowidth = blocprops.attr("logowidth") ? ' width="<?php echo CKGETOPTION(\''+bloc.attr("id")+'_logowidth\', \'' + ckTestUnit(blocprops.attr("logowidth")) + '\') ?>"' : '';
	bloc.logoheight = blocprops.attr("logoheight") ? ' height="<?php echo CKGETOPTION(\''+bloc.attr("id")+'_logoheight\', \'' + ckTestUnit(blocprops.attr("logoheight")) + '\') ?>"' : '';

	var logodesc = $ck('> .inner > .bannerlogodesc', bloc);
	var logodesccode = '';
	if (logodesc.length) {
		logodesccode = offsettabs + '|tab||tab||tab|<?php if (CKGETOPTION(\'' + blocid + '_logodescription\')) { ?>|rr|'
				+ offsettabs + '|tab||tab||tab|<div class="bannerlogodesc">|rr|'
				+ offsettabs + '|tab||tab||tab||tab|<div class="inner"><?php echo htmlspecialchars(CKGETOPTION(\'' + blocid + '_logodescription\'));?></div>|rr|'
				+ offsettabs + '|tab||tab||tab|</div>|rr|'
				+ offsettabs + '|tab||tab||tab|<?php } ?>|rr|';
	}

	code['body'] += offsettabs + '|tab|<div id="' + blocid + '"' + blocclass + '>|rr|'
			+ offsettabs + '|tab||tab|<div class="inner' + blocinnerclass + '">|rr|'
			+ offsettabs + '|tab||tab||tab|<?php if (CKGETOPTION(\'' + blocid + '_logolink\')) { ?>|rr|'
			+ offsettabs + '|tab||tab||tab|<a href="<?php echo htmlspecialchars(CKGETOPTION(\'' + blocid + '_logolink\')); ?>">|rr|'
			+ offsettabs + '|tab||tab||tab|<?php } ?>|rr|'
			+ offsettabs + '|tab||tab||tab||tab|<img class="tck-logo-img" src="<?php echo |bs|Joomla|bs|CMS|bs|Uri|bs|Uri::root(true) . \'/\' .  trim(\'/\' . CKGETOPTION(\'' + blocid + '_logoimgsrc\', $this->baseurl . \'/templates/\' . $this->template . \'/images/' + bloc.logoimage + '\'), \'/\') ?>"' + bloc.logowidth + bloc.logoheight + ' alt="<?php echo htmlspecialchars(CKGETOPTION(\'' + blocid + '_logotitle\',\'\'));?>" />|rr|'
			+ offsettabs + '|tab||tab||tab|<?php if (CKGETOPTION(\'' + blocid + '_logolink\')) { ?>|rr|'
			+ offsettabs + '|tab||tab||tab|</a>|rr|'
			+ offsettabs + '|tab||tab||tab|<?php } ?>|rr|'
			+ logodesccode
			+ offsettabs + '|tab||tab|</div>|rr|'
			+ offsettabs + '|tab|</div>|rr|';

	return code;
}

/**
 * Function to render a banner with logo
 *
 */
function ckMakeHtmlBanner(bloc, blocid, blocclass, task, nbtabs) {
	// initialisation
	var code = new Array("head", "body");
	code['head'] = '';
	code['body'] = '';

	var video = ckGetVideoCode(bloc);

	code['body'] += '|tab|<header' + blocid + blocclass + '>|rr|'
			+ '|tab||tab|<div class="inner' + video['class'] + '">|rr|'
			+ '|tab||tab|' + video['code'];

	$ck('.ckbloc', bloc).each(function(i, module) {
		module = $ck(module);
		// retrieve data for the block
		var modulemoduleposition = ckGetBlocModulePosition(module);
		var moduleid = module.attr('id');
		var moduleclass = ckGetBlocClass(module);
		var moduleinnerclass = ckGetBlocInnerClass(module, true);

		if (module.hasClass('bannerlogo')) {
			module.logoimage = $ck('img', module) ? $ck('img', module).attr('src').split("/").reverse()[0] : '';
			module.logowidth = $ck('.tab_blocstyles', module).attr("logowidth") ? ' width="<?php echo CKGETOPTION(\''+module.attr("id")+'_logowidth\', \'' + ckTestUnit($ck('.tab_blocstyles', module).attr("logowidth")) + '\') ?>"' : '';
			module.logoheight = $ck('.tab_blocstyles', module).attr("logoheight") ? ' height="<?php echo CKGETOPTION(\''+module.attr("id")+'_logoheight\', \'' + ckTestUnit($ck('.tab_blocstyles', module).attr("logoheight")) + '\') ?>"' : '';

			logodesc = $ck('> .inner > .bannerlogodesc', module);
			logodesccode = '';
			if (logodesc.length) {
				logodesccode = '|tab||tab||tab||tab||tab|<?php if (CKGETOPTION(\''+module.attr("id")+'_logodescription\')) { ?>|rr|'
						+ '|tab||tab||tab||tab||tab|<div class="bannerlogodesc">|rr|'
						+ '|tab||tab||tab||tab||tab||tab|<div class="inner"><?php echo htmlspecialchars(CKGETOPTION(\''+module.attr("id")+'_logodescription\'));?></div>|rr|'
						+ '|tab||tab||tab||tab||tab|</div>|rr|'
						+ '|tab||tab||tab||tab||tab|<?php } ?>|rr|';
			}

			code['body'] += '|tab||tab||tab|<div' + moduleid + moduleclass + '>|rr|'
					+ '|tab||tab||tab||tab|<div class="inner' + moduleinnerclass + '">|rr|'
					+ '|tab||tab||tab||tab||tab|<?php if (CKGETOPTION(\''+ moduleid +'_logolink\')) { ?>|rr|'
					+ '|tab||tab||tab||tab||tab|<a href="<?php echo htmlspecialchars(CKGETOPTION(\''+moduleid+'_logolink\')); ?>">|rr|'
					+ '|tab||tab||tab||tab||tab|<?php } ?>|rr|'
					+ ( task == 'preview' ? '|tab||tab||tab||tab||tab||tab|<img src="'+$ck('img', module).attr('src')+'"' + module.logowidth + module.logoheight + ' alt="<?php echo htmlspecialchars(CKGETOPTION(\''+moduleid+'_logotitle\',\'\'));?>" />|rr|' : '|tab||tab||tab||tab||tab||tab|<img src="<?php echo CKGETOPTION(\''+moduleid+'_logoimgsrc\', $this->baseurl . \'/templates/\' . $this->template . \'/images/' + module.logoimage + '\') ?>"' + module.logowidth + module.logoheight + ' alt="<?php echo htmlspecialchars(CKGETOPTION(\''+moduleid+'_logotitle\',\'\'));?>" />|rr|')
					+ '|tab||tab||tab||tab||tab|<?php if (CKGETOPTION(\''+moduleid+'_logolink\')) { ?>|rr|'
					+ '|tab||tab||tab||tab||tab|</a>|rr|'
					+ '|tab||tab||tab||tab||tab|<?php } ?>|rr|'
					+ logodesccode
					+ '|tab||tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab|</div>|rr|';


		} else if (!module.hasClass('bannerlogodesc') && (module.attr('isdisabled') == 'false' || !module.attr('isdisabled'))) {
			code['body'] += '|tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + modulemoduleposition + '\', true) || $tckedition) : ?>|rr|'
					+ '|tab||tab||tab|<div' + moduleid + moduleclass + '>|rr|'
					+ '|tab||tab||tab||tab|<div class="inner' + moduleinnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + modulemoduleposition + '">|rr|';
					if (module.hasClass('bannermenu')) {
						code['body'] += '|tab||tab||tab||tab|<label for="' +  moduleid + '-mobileck" class="mobileckhambuger_togglerlabel" style="display:none;">&#x2261;</label>|rr|'
						+ '|tab||tab||tab||tab|<input id="' + moduleid + '-mobileck" class="mobileckhambuger_toggler" type="checkbox" style="display:none;"/>|rr|'
					}
					code['body'] += '|tab||tab||tab||tab||tab|CKLOADMODULE(' + modulemoduleposition + ',' + ckGetIconAttribs(module) + ')|rr|'
					+ '|tab||tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab|<?php endif; ?>|rr|';
		}

	});
	code['body'] += '|tab||tab|<div class="clr"></div>|rr|'
			+ '|tab||tab|</div>|rr|'
			+ '|tab|</header>|rr|';

	return code;
}

/**
 * Function to render a banner with logo (old method)
 *
 */
function ckMakeHtmlOldBanner(bloc, task) {
	// initialisation
	var code = new Array('head', 'body');
	code['head'] = '';
	code['body'] = '';

	var blocclass = ckGetBlocClass(bloc);
	var blocinnerclass = ckGetBlocInnerClass(bloc, true);

	code['body'] += '|tab|<header' + blocid + blocclass + '>|rr|'
			+ '|tab||tab|<div class="inner clearfix' + blocinnerclass + '">|rr|';

	$ck('.ckbloc', bloc).each(function(i, module) {
		module = $ck(module);
		// retrieve data for the block
		var modulemoduleposition = ckGetBlocModulePosition(module);
		var moduleid = module.attr('id');
		var moduleclass = ckGetBlocClass(module);
		var moduleinnerclass = ckGetBlocInnerClass(module, true);

		if (module.hasClass('bannerlogo')) {
			module.logoimage = $ck('img', module) ? $ck('img', module).attr('src').split("/").reverse()[0] : '';
			module.logowidth = $ck('.tab_blocstyles', module).attr("logowidth") ? ' width="<?php echo CKGETOPTION(\''+module.attr("id")+'_logowidth\', \'' + ckTestUnit($ck('.tab_blocstyles', module).attr("logowidth")) + '\') ?>"' : '';
			module.logoheight = $ck('.tab_blocstyles', module).attr("logoheight") ? ' height="<?php echo CKGETOPTION(\''+module.attr("id")+'_logoheight\', \'' + ckTestUnit($ck('.tab_blocstyles', module).attr("logoheight")) + '\') ?>"' : '';

			logodesc = $ck('> .inner > .bannerlogodesc', module);
			logodesccode = '';
			if (logodesc.length) {
				logodesccode = '|tab||tab||tab||tab||tab|<?php if (CKGETOPTION(\'logodescription\')) { ?>|rr|'
						+ '|tab||tab||tab||tab||tab|<div class="bannerlogodesc">|rr|'
						+ '|tab||tab||tab||tab||tab||tab|<div class="inner clearfix"><?php echo htmlspecialchars(CKGETOPTION(\'logodescription\'));?></div>|rr|'
						+ '|tab||tab||tab||tab||tab|</div>|rr|'
						+ '|tab||tab||tab||tab||tab|<?php } ?>|rr|';
			}

			code['body'] += '|tab||tab||tab|<div id="' + moduleid + '" ' + moduleclass + '>|rr|'
					+ '|tab||tab||tab||tab|<div class="inner clearfix' + moduleinnerclass + '">|rr|'
					+ '|tab||tab||tab||tab||tab|<?php if (CKGETOPTION(\'' + moduleid + '_logolink\')) { ?>|rr|'
					+ '|tab||tab||tab||tab||tab|<a href="<?php echo htmlspecialchars(CKGETOPTION(\''+ moduleid +'_logolink\')); ?>">|rr|'
					+ '|tab||tab||tab||tab||tab|<?php } ?>|rr|'
					+ ( task == 'preview' ? '|tab||tab||tab||tab||tab||tab|<img src="'+$ck('img', module).attr('src')+'"' + module.logowidth + module.logoheight + ' alt="<?php echo htmlspecialchars(CKGETOPTION(\''+ moduleid +'_logotitle\',\'\'));?>" />|rr|' : '|tab||tab||tab||tab||tab||tab|<img src="<?php echo CKGETOPTION(\''+ moduleid +'_logoimgsrc\', $this->baseurl . \'/templates/\' . $this->template . \'/images/' + module.logoimage + '\') ?>"' + module.logowidth + module.logoheight + ' alt="<?php echo htmlspecialchars(CKGETOPTION(\''+ moduleid +'_logotitle\',\'\'));?>" />|rr|')
					+ '|tab||tab||tab||tab||tab|<?php if (CKGETOPTION(\''+ moduleid +'_logolink\')) { ?>|rr|'
					+ '|tab||tab||tab||tab||tab|</a>|rr|'
					+ '|tab||tab||tab||tab||tab|<?php } ?>|rr|'
					+ logodesccode
					+ '|tab||tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab|</div>|rr|';


		} else if (!module.hasClass('bannerlogodesc')) {
			code['body'] += '|tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + modulemoduleposition + '\', true)) : ?>|rr|'
					+ '|tab||tab||tab|<div' + moduleid + moduleclass + '>|rr|'
					+ '|tab||tab||tab||tab|<div class="inner clearfix">|rr|'
					+ '|tab||tab||tab||tab||tab|CKLOADMODULE(' + modulemoduleposition + ',' + ckGetIconAttribs(module) + ')|rr|'
					+ '|tab||tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab|<?php endif; ?>|rr|';
		}

	});
	code['body'] += '|tab||tab|<div class="clr"></div>|rr|'
			+ '|tab||tab|</div>|rr|'
			+ '|tab|</header>|rr|';

	return code;
}


/**
 * Function to render a horizontal menu
 *
 */
function ckMakeHtmlHorizNav(bloc, nbtabs) {
	// initialisation
	var code = new Array('head', 'body');
	code['head'] = '';
	code['body'] = '';

	var blocmoduleposition = ckGetBlocModulePosition(bloc);
	var blocclass = ckGetBlocClass(bloc);
	var blocinnerclass = ckGetBlocInnerClass(bloc, true);

	var needHamburger =false;
	for (var i = 1; i <= 5; i++) {
		if (bloc.attr('ckresponsive' + i) == 'mobile_hamburger') 
			needHamburger = true;
	}
	var offsettabs = ckStrRepeat('|tab|', nbtabs);
	code['body'] = offsettabs + '|tab|<?php if (CKCOUNTMODULEMENU(\'' + blocmoduleposition + '\', true) || $tckedition) : ?>|rr|'
			+ offsettabs + '|tab|<nav id="' + bloc.attr('id') + '"' + blocclass + '>|rr|'
			+ offsettabs + '|tab||tab|<div class="inner' + blocinnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + blocmoduleposition + '">|rr|';
			if (needHamburger) {
				code['body'] += offsettabs + '|tab||tab||tab|<label for="' + blocmoduleposition + '-mobileck" class="mobileckhambuger_togglerlabel" style="display:none;">&#x2261;</label>|rr|'
					+ offsettabs + '|tab||tab||tab|<input id="' + blocmoduleposition + '-mobileck" class="mobileckhambuger_toggler" type="checkbox" style="display:none;"/>|rr|';
			}
			code['body'] += offsettabs + '|tab||tab||tab|CKLOADMODULEMENU(' + blocmoduleposition + ','  + ckGetIconAttribs(bloc) + ')|rr|'
			+ offsettabs + '|tab||tab|</div>|rr|'
			+ offsettabs + '|tab|</nav>|rr|'
			+ offsettabs + '|tab|<?php endif; ?>|rr|';
	return code;
}

/*
 * Function to render a complex component layout
 *
 */

function ckMakeHtmlMaincontent(bloc, j, nbtabs) {
	var code = new Array('head', 'body');
	code['head'] = '';
	code['body'] = '';

	column1width = 0;
	column2width = 0;

	var jj = 1; // internal var used for additionnal blocks conditions
	var blocclass = ckGetBlocClass(bloc, true);
	var blocinnerclass = ckGetBlocInnerClass(bloc, true);
	var shapedivider = ckGetShapeDividerHtml(bloc);

	// begin the global container
	code['body'] += '|tab|<div id="' + bloc.attr('id') + '" class="maincontent ' + blocclass + (shapedivider ? 'tck-relative ' : '') + '<?php echo $mainclass ?>">|rr|'
			+ shapedivider
			+ '|tab||tab|<div class="inner clearfix' + blocinnerclass + '">|rr|';
	column1enabled = 1;
	column1 = '';
	column2enabled = 1;
	column2 = '';
	$ck('.ckbloc', bloc).each(function(i, column) {
		column = $ck(column);

		var columnid = column.attr('id');
		var columnmoduleposition = ckGetBlocModulePosition(column);
		var columnclass = ckGetBlocClass(column, true);
		var columninnerclass = ckGetBlocInnerClass(column, true);
//		column.ckid = column.attr("id") ? ' id="' + column.attr("id") + '"' : '';
//		column.classe = column.attr("ckclass") ? column.attr("ckclass") : '';
//		column.jdocstyle = column.attr("ckmodulestyle") ? ' style="' + column.attr("ckmodulestyle") + '"' : ',';
//		column.jdocposition = column.attr("ckmoduleposition") ? column.attr("ckmoduleposition") : '';

		// if the first big column
		if (column.hasClass('column1') && column.attr('isdisabled') != "true") {
//			column1 = column.jdocposition;
			column1width = column.attr('blocwidth') ? column.attr('blocwidth') : '200';
			var column1positions = $ck('.ckbloc', column).map(function() {return $ck(this).attr("ckmoduleposition"); });
			column1positions.push(column.attr("ckmoduleposition"));
			column1 = $ck.makeArray(column1positions);
			code['body'] += '|tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + column1.join('\', true) || CKCOUNTMODULE(\'') + '\', true) || $tckedition) : ?>|rr|'
					+ '|tab||tab||tab|<aside id="' + columnid + '" class="column column1' + columnclass + '">|rr|'
					+ '|tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + columnmoduleposition + '\', true)) : ?>|rr|'
					+ '|tab||tab||tab||tab|<div class="inner clearfix' + columninnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + columnmoduleposition + '">|rr|'
					+ '|tab||tab||tab||tab||tab|CKLOADMODULE(' + columnmoduleposition + ',' + ckGetIconAttribs(column) + ')|rr|'
					+ '|tab||tab||tab||tab|</div>|rr|'
					+ '|tab||tab||tab||tab|<?php endif; ?>|rr|';
			
			$ck('.ckbloc', column).each(function(i, module) {
				module = $ck(module);
//				var moduleid = module.attr('id');
//				var modulemoduleposition = ckGetBlocModulePosition(module);
//				var moduleclass = ckGetBlocClass(module, true);
//				var moduleinnerclass = ckGetBlocInnerClass(module, true);
//				module.ckid = module.attr("id") ? ' id="' + module.attr("id") + '"' : '';
//				module.classe = module.attr("ckclass") ? ' class="' + module.attr("ckclass") + '"' : '';
//				module.jdocstyle = module.attr("ckmodulestyle") ? ' style="' + module.attr("ckmodulestyle") + '"' : ',';
//				module.jdocposition = module.attr("ckmoduleposition") ? module.attr("ckmoduleposition") : '';

				var tmpcode = ckGetBlockHtml(module,j + 'mc' + jj, 3);
				jj++;
				code['head'] += tmpcode['head'];
				code['body'] += tmpcode['body'];
			});
			
			code['body'] += '|tab||tab||tab|</aside>|rr|'
					+ '|tab||tab||tab|<?php endif; ?>|rr|';
			
		} else if (column.hasClass('column1') && column.attr('isdisabled') == "true") {
			column1enabled = 0;
		}


		// if the main container column - look into to search for other blocks
		if (column.hasClass('main')) {
			if (column.attr('ishidden') != "true")
				code['body'] += '|tab||tab||tab|<div id="' + columnid + '" class="column main row-fluid' + columnclass + '">|rr|'
						+ '|tab||tab||tab||tab|<div class="inner clearfix' + columninnerclass + '">|rr|';

			// look for sub columns
			$ck('.ckbloc', column).each(function(h, subcolumn) {
				subcolumn = $ck(subcolumn);

				var subcolumnid = subcolumn.attr('id');
				var subcolumnmoduleposition = ckGetBlocModulePosition(subcolumn);
				var subcolumnclass = ckGetBlocClass(subcolumn);
				var subcolumninnerclass = ckGetBlocInnerClass(subcolumn, true);
//				subcolumn.ckid = subcolumn.attr("id") ? ' id="' + subcolumn.attr("id") + '"' : '';
//				subcolumn.classe = subcolumn.attr("ckclass") ? subcolumn.attr("ckclass") : '';
//				subcolumn.jdocstyle = subcolumn.attr("ckmodulestyle") ? ' style="' + subcolumn.attr("ckmodulestyle") + '"' : ',';
//				subcolumn.jdocposition = subcolumn.attr("ckmoduleposition") ? subcolumn.attr("ckmoduleposition") : '';

				if ((subcolumn.hasClass('maintop') || subcolumn.hasClass('mainbottom')) && subcolumn.attr('isdisabled') != "true") {
					// subcolumn.classe = (subcolumn.classe) ? 'class="' + subcolumn.classe + '"' : '';
					// code["body"] += '|tab||tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + subcolumn.jdocposition + '\')) : ?>|rr|'
							// + '|tab||tab||tab||tab||tab|<div' + subcolumn.ckid + subcolumn.classe + '>|rr|'
							// + '|tab||tab||tab||tab||tab||tab|<div class="inner clearfix">|rr|'
							// + '|tab||tab||tab||tab||tab||tab||tab|CKLOADMODULE(' + subcolumn.jdocposition + '"' + subcolumn.jdocstyle + ')|rr|'
							// + '|tab||tab||tab||tab||tab||tab|</div>|rr|'
							// + '|tab||tab||tab||tab||tab|</div>|rr|'
							// + '|tab||tab||tab||tab||tab|<?php endif; ?>|rr|';
					if (subcolumn.find('.ckrowcontainer').length) {
						$ck('.ckbloc', subcolumn).each(function(i, module) {
							module = $ck(module);
//							module.ckid = module.attr("id") ? ' id="' + module.attr("id") + '"' : '';
//							module.classe = module.attr("ckclass") ? ' class="' + module.attr("ckclass") + '"' : '';
//							module.jdocstyle = module.attr("ckmodulestyle") ? ' style="' + module.attr("ckmodulestyle") + '"' : ',';
//							module.jdocposition = module.attr("ckmoduleposition") ? module.attr("ckmoduleposition") : '';
//							module.jdocstyle = module.attr("ckmodulestyle") ? ' style="' + module.attr("ckmodulestyle") + '"' : ',';

							var tmpcode = ckGetBlockHtml(module, j + 'mc' + jj, 4);
							jj++;
							code['head'] += tmpcode['head'];
							code['body'] += tmpcode['body'];
						});
					} else { // retrocompatibility before 3.4
//						subcolumn.classe = (subcolumn.classe) ? 'class="' + subcolumn.classe + '"' : '';
						code['body'] += '|tab||tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + subcolumnmoduleposition + '\', true) || $tckedition) : ?>|rr|'
								+ '|tab||tab||tab||tab||tab|<div id="' + subcolumnid + '" ' + subcolumnclass + '>|rr|'
								+ '|tab||tab||tab||tab||tab||tab|<div class="inner' + subcolumninnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + subcolumnmoduleposition + '">|rr|'
								+ '|tab||tab||tab||tab||tab||tab||tab|CKLOADMODULE(' + subcolumnmoduleposition + ',' + ckGetIconAttribs(subcolumn) + ')|rr|'
								+ '|tab||tab||tab||tab||tab||tab|</div>|rr|'
								+ '|tab||tab||tab||tab||tab|</div>|rr|'
								+ '|tab||tab||tab||tab||tab|<?php endif; ?>|rr|';
					}
				}

				if (subcolumn.hasClass('maincenter')) {
					// begin the center container
					if (subcolumn.attr('ishidden') != "true")
						code['body'] += '|tab||tab||tab||tab||tab|<div id="' + subcolumnid + '" class="maincenter ' + columnclass + '">|rr|'
								+ '|tab||tab||tab||tab||tab||tab|<div class="inner clearfix' + subcolumninnerclass + '">|rr|';

					$ck('.ckbloc', subcolumn).each(function(g, centercolumn) {
						centercolumn = $ck(centercolumn);

//						centercolumn.ckid = centercolumn.attr("id") ? ' id="' + centercolumn.attr("id") + '"' : '';
//						centercolumn.classe = centercolumn.attr("ckclass") ? centercolumn.attr("ckclass") : '';
//						centercolumn.jdocstyle = centercolumn.attr("ckmodulestyle") ? ' style="' + centercolumn.attr("ckmodulestyle") + '"' : ',';
//						centercolumn.jdocposition = centercolumn.attr("ckmoduleposition") ? centercolumn.attr("ckmoduleposition") : '';
						var centercolumnid = centercolumn.attr('id');
						var centercolumnmoduleposition = ckGetBlocModulePosition(centercolumn);
						var centercolumnclass = ckGetBlocClass(centercolumn, true);
						var centercolumninnerclass = ckGetBlocInnerClass(centercolumn, true);

						if (centercolumn.hasClass('column2') && centercolumn.attr('isdisabled') != "true") {
//							column2 = centercolumn.jdocposition;
							column2width = centercolumn.attr('blocwidth') ? centercolumn.attr('blocwidth') : '200';
							var column2positions = $ck('.ckbloc', centercolumn).map(function() {return $ck(this).attr("ckmoduleposition"); });
							column2positions.push(centercolumn.attr("ckmoduleposition"));
							column2 = $ck.makeArray(column2positions);
							code['body'] += '|tab||tab||tab||tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + column2.join('\', true) || CKCOUNTMODULE(\'') + '\', true) || $tckedition) : ?>|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab|<aside id="' + centercolumn.attr('id') + '" class="column column2' + centercolumnclass + '">|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + centercolumnmoduleposition + '\', true) || $tckedition) : ?>|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab||tab|<div class="inner' + centercolumninnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + centercolumnmoduleposition + '">|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab|CKLOADMODULE(' + centercolumnmoduleposition + ',' + ckGetIconAttribs(centercolumn) + ')|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab||tab|<?php endif; ?>|rr|';
							$ck('.ckbloc', centercolumn).each(function(i, module) {
								module = $ck(module);
//								module.ckid = module.attr("id") ? ' id="' + module.attr("id") + '"' : '';
//								module.classe = module.attr("ckclass") ? ' class="' + module.attr("ckclass") + '"' : '';
//								module.jdocstyle = module.attr("ckmodulestyle") ? ' style="' + module.attr("ckmodulestyle") + '"' : ',';
//								module.jdocposition = module.attr("ckmoduleposition") ? module.attr("ckmoduleposition") : '';

								var tmpcode = ckGetBlockHtml(module, j + 'mc' + jj, 7);
								jj++;
								code['head'] += tmpcode['head'];
								code['body'] += tmpcode['body'];
							});

							code['body'] +=  '|tab||tab||tab||tab||tab||tab||tab|</aside>|rr|'
									+ '|tab||tab||tab||tab||tab||tab||tab|<?php endif; ?>|rr|';
						} else if (centercolumn.hasClass('column2') && centercolumn.attr('isdisabled') == "true") {
							column2enabled = 0;
						}

						if (centercolumn.hasClass('center')) {
							if (centercolumn.attr('ishidden') != "true")
								code["body"] += '|tab||tab||tab||tab||tab||tab||tab|<main id="' + centercolumnid + '" class="column center ' + centercolumnclass + '">|rr|'
										+ '|tab||tab||tab||tab||tab||tab||tab||tab|<div class="inner' + centercolumninnerclass + '">|rr|';

							// look for sub blocks
							$ck('.ckbloc', centercolumn).each(function(f, centerbloc) {
								centerbloc = $ck(centerbloc);
								var centerblocid = centerbloc.attr('id');
								var centerblocmoduleposition = ckGetBlocModulePosition(centerbloc);
								var centerblocclass = ckGetBlocClass(centerbloc);
								var centerblocinnerclass = ckGetBlocInnerClass(centerbloc, true);
//								centerbloc.ckid = centerbloc.attr("id") ? ' id="' + centerbloc.attr("id") + '"' : '';
//								centerbloc.classe = centerbloc.attr("ckclass") ? centerbloc.attr("ckclass") : '';
//								centerbloc.jdocstyle = centerbloc.attr("ckmodulestyle") ? ' style="' + centerbloc.attr("ckmodulestyle") + '"' : ',';
//								centerbloc.jdocposition = centerbloc.attr("ckmoduleposition") ? centerbloc.attr("ckmoduleposition") : '';

								if ((centerbloc.hasClass('centertop') || centerbloc.hasClass('centerbottom')) && centerbloc.attr('isdisabled') != "true") {
									// code["body"] += '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + centerbloc.jdocposition + '\')) : ?>|rr|'
											// + '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<div' + centerbloc.ckid + ' class="' + centerbloc.classe + '">|rr|'
											// + '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|<div class="inner clearfix">|rr|'
											// + '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|CKLOADMODULE(' + centerbloc.jdocposition + '"' + centerbloc.jdocstyle + ')|rr|'
											// + '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
											// + '|tab||tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
											// + '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<?php endif; ?>|rr|';
									if (centerbloc.find('.ckrowcontainer').length) {
										$ck('.ckbloc', centerbloc).each(function(i, module) {
											module = $ck(module);
//											module.ckid = module.attr("id") ? ' id="' + module.attr("id") + '"' : '';
//											module.classe = module.attr("ckclass") ? ' class="' + module.attr("ckclass") + '"' : '';
//											module.jdocstyle = module.attr("ckmodulestyle") ? ' style="' + module.attr("ckmodulestyle") + '"' : ',';
//											module.jdocposition = module.attr("ckmoduleposition") ? module.attr("ckmoduleposition") : '';

											var tmpcode = ckGetBlockHtml(module, j + 'mc' + jj, 7);
											jj++;
											code['head'] += tmpcode['head'];
											code['body'] += tmpcode['body'];

										});
									} else { // retrocompatibility before 3.4
										code["body"] += '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<?php if (CKCOUNTMODULE(\'' + centerblocmoduleposition + '\', true) || $tckedition) : ?>|rr|'
											+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<div id="' + centerblocid + '" class="' + centerblocclass + '">|rr|'
											+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|<div class="inner clearfix' + centerblocinnerclass + ' <?php echo $tckeditionclass ?>" data-position="' + centerblocmoduleposition + '">|rr|'
											+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|CKLOADMODULE(' + centerblocmoduleposition + ',' + ckGetIconAttribs(centerbloc) + ')|rr|'
											+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
											+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
											+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<?php endif; ?>|rr|';
									}
								}

								if (centerbloc.hasClass('content')) {
									if (centerbloc.attr('ishidden') != "true")
										code["body"] += '|tab||tab||tab||tab||tab||tab||tab||tab||tab|<div id="' + centerblocid + '" class="' + centerblocclass + '">|rr|'
												+ '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|<div class="inner clearfix' + centerblocinnerclass + '">|rr|';

									code["body"] += '|BODYCODE|';


									if (centerbloc.attr('ishidden') != "true")
										code["body"] += '|tab||tab||tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
									+'|tab||tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|';

								}
							});

							if (centercolumn.attr('ishidden') != "true")
								code["body"] += '|tab||tab||tab||tab||tab||tab||tab||tab|</div>|rr|'
										+ '|tab||tab||tab||tab||tab||tab||tab|</main>|rr|';

						}
					});

					// close the center container
					if (subcolumn.attr('ishidden') != "true")
						code["body"] += '|tab||tab||tab||tab||tab||tab|</div>|rr|'
								+ '|tab||tab||tab||tab||tab|</div>|rr|';
				}

			});

			// close main container column
			if (column.attr('ishidden') != "true")
				code["body"] += '|rr|'
						+ '|tab||tab||tab||tab|</div>|rr|'
						+ '|tab||tab||tab|</div>|rr|';
		}
	});


	// end floating and close the global container
	code["body"] += '|tab||tab||tab|<div class="clr"></div>|rr|'
			+ '|tab||tab|</div>|rr|'
			+ '|tab|</div>|rr|';

	code["head"] += '<?php|rr|'
			+ '$mainclass = "";|rr|';
	if (column1enabled == 1 && Array.isArray(column1)) {
		code["head"] += 'if (!CKCOUNTMODULE(\'' + column1.join('\', true) && !CKCOUNTMODULE(\'') + '\', true) && ! $tckedition) { $mainclass .= " noleft";}|rr|';
	} else {
		code["head"] += '$mainclass .= " noleft";|rr|';
	}
	if (column2enabled == 1 && Array.isArray(column2)) {
		code["head"] += 'if (!CKCOUNTMODULE(\'' + column2.join('\', true) && !CKCOUNTMODULE(\'') + '\', true) && ! $tckedition) { $mainclass .= " noright";}|rr|';
	} else {
		code["head"] += '$mainclass .= " noright";|rr|';
	}
	code["head"] += '$mainclass = trim($mainclass); ?>|rr||rr|';

	window['COLUMN1WIDTH'] = column1width;
	window['COLUMN2WIDTH'] = column2width;

	return code;
}

function ckTestUnit(value, defaultunit) {
	if (!defaultunit) defaultunit = "px";
	if (value.toLowerCase().indexOf('px') > -1 
		|| value.toLowerCase().indexOf('em') > -1 
		|| value.toLowerCase().indexOf('%') > -1
		|| value.toLowerCase().indexOf('rem') > -1
		|| value.toLowerCase().indexOf('vh') > -1
		|| value.toLowerCase().indexOf('vw') > -1
		)
		return value;

	return value + defaultunit;
}

function ckSelectFaIcon(iconclass) {
	ckSetFaIconPosition(iconclass);
	ckSetFaIconSize();
	$ck('#fontawesomefieldset').show();
	$ck('#fontawesomefieldsetoptions').show();
	$ck('#iconsvgfieldset').hide();
	$ck('#iconicontype').val('fontawesome');
}

function ckRemoveFaIcon(fromicon) {
	$ck(fromicon).remove();
	$ck('#fontawesomefieldset').hide();
	$ck('#fontawesomefieldsetoptions').hide();
	$ck('#iconsvgfieldset').hide();
}

function ckSetFaIconPosition(iconclass) {
	var focus = $ck('.ckfocus');
	if (! focus.find('span.fack').length && ! iconclass) return;
	if (! iconclass) iconclass = focus.find('span.fack > span').attr('class').replace('fack', '');
	focus.find('> .inner span.fack').remove();

	var iconposition = $ck('select[name="iconiconposition"]').val();
	switch (iconposition) {
		default:
		case 'left':
			focus.find('> .inner h3').prepend('<span class="fack" data-pos="left" data-type="' + iconclass + '" style="display:inline-block;"><span class="' + iconclass + '"></span></span>');
			break;
		case 'top':
			focus.find('> .inner h3').prepend('<span class="fack" data-pos="top" data-type="' + iconclass + '" style="display:block;"><span class="' + iconclass + '"></span></span>');
			break;
		case 'right':
			focus.find('> .inner h3').append('<span class="fack" data-pos="right" data-type="' + iconclass + '" style="display:inline-block;"><span class="' + iconclass + '"></span></span>');
			break;
		case 'bottom':
			focus.find('> .inner h3').append('<span class="fack" data-pos="bottom" data-type="' + iconclass + '" style="display:block;"><span class="' + iconclass + '"></span></span>');
			break;
	}
}

function ckSetFaIconCssClass() {
	var focus = $ck('.ckfocus');
	if (! focus.find('span.fack').length) return;
	var icon = focus.find('> .inner span.fack [class*="fa"]');
	var iconcssclass = $ck('input[name="iconicon_cssclass"]').val();
	icon.attr('class', iconcssclass);
//	ckSetFaIconSize();
//	ckSetFaIconVPosition();
}

function ckSetFaIconSize() {
	var focus = $ck('.ckfocus');
	if (! focus.find('span.fack').length) return;
	var icon = focus.find('> .inner span.fack > span');
	icon.removeClass('fack-lg')
		.removeClass('fack-2x')
		.removeClass('fack-3x')
		.removeClass('fack-4x')
		.removeClass('fack-5x');

//	var iconsize = $ck('input[name="iconiconsize"]:checked').val();
	var iconsize = $ck('select[name="iconiconsize"]').val();
	if (iconsize != 'default') {
		icon.addClass(iconsize);
		focus.find('> .inner span.fack').attr('data-size', iconsize);
	}
}

function ckSetFaIconVPosition() {
	var focus = $ck('.ckfocus');
	if (! focus.find('> .inner span.fack').length) return;
	var icon = focus.find('> .inner span.fack > span');
//	var iconVPos = $ck('input[name="iconiconvposition"]:checked').val();
	var iconVPos = $ck('select[name="iconiconvposition"]').val();
	icon.css('vertical-align', '');
	if (iconVPos != 'default') {
		icon.css('vertical-align', iconVPos);
		focus.find('> .inner span.fack').attr('data-vpos', iconVPos);
	} else {
		focus.find('> .inner span.fack').attr('data-vpos', '');
	}
	
}

function ckSelectSvgIcon(code, _path) {
	if (! code) return;
	var focus = $ck('.ckfocus');
	focus.find('> .inner span.fack').remove();
	focus.find('> .inner .tck-icon-svg').remove();

	var iconposition = $ck('select[name="iconiconposition"]').val();
	focus.find('> .inner h3').prepend('<span class="fack tck-icon-svg" data-path="' + _path + '" data-pos="' + iconposition + '" style="display:inline-block;">' + code + '</span>');
	var svg = focus.find('> .inner .fack > svg');

	// hack needed to remove square border on Tabler icons
	if (svg[0].classList.contains('icon-tabler')) {
		svg.find('path').first().remove();
	}
	svg.find('title').remove();

	CKBox.close();
	$ck('#fontawesomefieldset').hide();
	$ck('#fontawesomefieldsetoptions').hide();
	$ck('#iconsvgfieldset').show();
	ckUpdateSvgIconSettings();
	$ck('#iconicontype').val('svg');
}

function ckUpdateSvgIconSettings() {
	// if not a module, do nothing
	if (! $ck('.ckfocus').hasClass('singlemodule')
		&& ! $ck('.ckfocus').hasClass('flexiblemodule') ) {
		return;
	}
	if (! $ck('.ckfocus').find('> .inner span.fack svg').length) return;
	ckSetSvgIconSize();
	ckSetSvgIconStroke();
	ckSetSvgIconStrokeColor();
	ckSetSvgIconFillColor();
	ckSetSvgIconPosition();
	ckSetSvgIconVPosition();
}

function ckSetSvgIconSize() {
	var focus = $ck('.ckfocus');
	if (! focus.find('> .inner span.fack svg').length) return;
	var icon = focus.find('> .inner span.fack svg');
	var iconsize = $ck('input[name="iconiconsvgsize"]').val();
	icon.css({'width': iconsize, 'height': iconsize});
}

function ckSetSvgIconStroke() {
	var focus = $ck('.ckfocus');
	if (! focus.find('> .inner span.fack svg').length) return;
	var icon = focus.find('> .inner span.fack');
	var strokesize = $ck('input[name="iconiconsvgstroke"]').val();
//	var strokecolor = $ck('input[name="iconiconsvgstrokecolor"]').val();
//	if (! strokecolor) {
//		strokesize = 0;
//	}

	var svg = focus.find('> .inner .fack > svg');

	// hack needed for Ionicons that are 512px
	if (svg[0].classList.contains('ionicon')) {
		strokesize = strokesize * 16;
	}
	// hack needed for fontawesome that are 512px
	if (svg[0].innerHTML.indexOf('fontawesome') !== -1) {
		strokesize = strokesize * 16;
	}

	icon.find('svg, path, circle').each(function() {
		$ck(this).attr('stroke-width', strokesize);
	});
}

function ckSetSvgIconStrokeColor() {
	var strokecolor = $ck('input[name="iconiconsvgstrokecolor"]').val();
	if (! strokecolor) return;
	var focus = $ck('.ckfocus');
	if (! focus.find('> .inner span.fack').length) return;
	var icon = focus.find('> .inner span.fack');
	icon.find('svg, path, circle').each(function() {
		$ck(this).attr('stroke', strokecolor);
	});
}

function ckSetSvgIconFillColor() {
	var color = $ck('input[name="iconiconsvgfillcolor"]').val();
	
	var focus = $ck('.ckfocus');
	if (! focus.find('> .inner span.fack').length) return;
	var icon = focus.find('span.fack');
	icon.find('svg, path, circle').each(function() {
		if (! color) {
//			$ck(this).removeAttr('fill');
		} else {
			$ck(this).attr('fill', color);
		}
		
	});
}

function ckSetSvgIconPosition() {
	var focus = $ck('.ckfocus');
//	if (! focus.hasClass('singlemodule') && ! focus.hasClass('flexiblemodule')) return;
	if (! focus.find('> .inner span.fack svg').length) return;

	var fack = focus.find('> .inner span.fack').first();
	var title = fack.parent();
	title.find('span.fack').remove();

	var iconposition = $ck('select[name="iconiconsvgposition"]').val();

	switch (iconposition) {
		default:
		case 'left':
			title.prepend(fack);
			fack.css('display', 'inline-block');
			break;
		case 'top':
			title.prepend(fack);
			fack.css('display', 'block');
			break;
		case 'right':
			title.append(fack);
			fack.css('display', 'inline-block');
			break;
		case 'bottom':
			title.append(fack);
			fack.css('display', 'block');
			break;
	}

	fack = title.find('> span.fack');
	fack.attr('data-pos', iconposition);
}

function ckSetSvgIconVPosition() {
	var focus = $ck('.ckfocus');
	if (! focus.find('> .inner span.fack svg').length) return;
	var icon = focus.find('> .inner span.fack svg');
//	var iconVPos = $ck('input[name="iconiconvposition"]:checked').val();
	var iconVPos = $ck('select[name="iconiconsvgvposition"]').val();
	icon.css('vertical-align', '');
	if (iconVPos != 'default') {
		icon.css('vertical-align', iconVPos);
		focus.find('> .inner span.fack').attr('data-vpos', iconVPos);
	} else {
		focus.find('> .inner span.fack').attr('data-vpos', '');
	}
	
}

function previewVideoBackground() {
	var webmurl = $ck('#blocvideourlwebm').val().replace(URIROOT,'');
	var mp4url = $ck('#blocvideourlmp4').val().replace(URIROOT,'');
	var ogvurl = $ck('#blocvideourlogv').val().replace(URIROOT,'');
	var videocode = '<video autoplay playsinline loop muted poster="" class="videobackground">'
						+'<source src="'+URIROOT+'/'+webmurl+'" type="video/webm">'
						+'<source src="'+URIROOT+'/'+mp4url+'" type="video/mp4">'
						+'<source src="'+URIROOT+'/'+ogvurl+'" type="video/ogg">'
					+'</video>';
	var previewarea = $ck('#previewareabloc');
	if (previewarea.find('video').length) previewarea.find('video').remove();
	previewarea.css('position', 'relative').css('overflow','hidden').prepend(videocode);
}


/******* Undo and Redo actions *************/

var ckActionsPointer=-1;
var ckDoActionsList=new Array();

function ckSaveAction() {
	ckActionsPointer++;
	var x=document.getElementById('cktemplatecontainer').innerHTML;
	ckDoActionsList[ckActionsPointer]=x;
	// enable the undo button
	if (ckActionsPointer > 0) $ck('#ckundo').removeClass('ckdisabled');
	// clean the list of actions to avoid next actions to be in memory
	ckDoActionsList = ckDoActionsList.slice(0, ckActionsPointer + 1);
	$ck('#ckredo').addClass('ckdisabled');
}

function ckUndo() {
	var z = ckActionsPointer - 1;

	if (ckDoActionsList[z-1]) {
		document.getElementById('cktemplatecontainer').innerHTML = ckDoActionsList[z];
		$ck('#ckredo').removeClass('ckdisabled');
	} else {
		document.getElementById('cktemplatecontainer').innerHTML = ckDoActionsList[0];
		$ck('#ckundo').addClass('ckdisabled');
		$ck('#ckredo').removeClass('ckdisabled');
	}

	ckInitInterface();
	if (z < 0) {
		$ck('#ckundo').addClass('ckdisabled');
		return;
	}
	ckActionsPointer--;
}

function ckRedo() {
	var z=ckActionsPointer+1;

	if (ckDoActionsList[z]) {
		document.getElementById('cktemplatecontainer').innerHTML=ckDoActionsList[z];
		$ck('#ckundo').removeClass('ckdisabled');
		ckActionsPointer++;
	} else {

		$ck('#ckredo').addClass('ckdisabled');
		return;
	}

	ckInitInterface();
	if (z == ckDoActionsList.length -1) {
		$ck('#ckredo').addClass('ckdisabled');
		return;
	}
}


function ckToggleSubmenu(el) {
	el = $ck(el);
	if ($ck('#ckmodelewrapper').length) return;

	var submenu = el.next('.cksubmenu');
	$ck('.cksubmenu').not(submenu).hide('fast').removeClass('opened');
	
	if (! submenu.hasClass('opened')) {
		submenu.addClass('opened').show('fast', function() {hideSubmenuckOutsideClick(submenu), ckCheckSubmenuHeight(submenu); } );
	} else {
		submenu.hide('fast').removeClass('opened');
	}
	if (! submenu.hasClass('eventadded')) {
		submenu.addClass('eventadded').find('> a').on('click', function() {
			submenu.hide().removeClass('opened');
		});
		
	}
}

function ckCheckSubmenuHeight(submenu) {
	var top = submenu.position().top;
	var h = submenu.height();
	var winh = $ck(window).height();
	if (top + h > winh) {
		submenu.height(winh - top - 5);
	} else {
		submenu.height('auto');
	}
}

function hideSubmenuckOutsideClick(submenu) {
	$ck(window).one("click", function(event){
		if ( 
			submenu.hasClass('opened')
			&&
			submenu.has(event.target).length == 0 //checks if descendants of submenu was clicked
			&&
			!submenu.is(event.target) //checks if the submenu itself was clicked
			){
			// is outside
			submenu.hide('fast').removeClass('opened');
		} else {
			// is inside, do nothing
		}
	});
}

function ckShowRestorePopup() {
	CKBox.open({handler: 'inline', content: 'restoreModalck', style: {padding: '10px'}, size: {x: '600px', y: '400px'}});
}

function ckShowReplaceColorsPopup() {
	CKBox.open({handler: 'inline', content: 'replaceColorsModalck', style: {padding: '10px'}, size: {x: '600px', y: '350px'}});
}

function ckReplaceColors() {
	for (var i=0; i<5; i++) {
		var oldColor = $ck('#replacecolorold' + i).val();
		var newColor = $ck('#replacecolornew' + i).val();
		if (! oldColor || ! newColor) continue;
		var regEx = new RegExp(oldColor, "ig");
		$ck('#body .ckstyle, #ckstylescontainer .ckstyle').each(function() {
			var $st = $ck(this);
			$st.html($st.html().replace(regEx, newColor));
		});
		$ck('#body .ckprops, #ckstylescontainer .ckprops, #body .tck-divider-container').each(function() {
			this.outerHTML = this.outerHTML.replace(regEx, newColor);
		});
	}
	ckSaveAction();
	CKBox.close();
}

/* load the .pbck backup file and load it in the page */
function ckDoRestoration(id, name, index) {
	jQuery('.restoreline' + index + ' .processing').addClass('ckwait');
	var isLocked = parseInt(jQuery('.restoreline' + index + ' .locked').attr('data-locked'));
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxDoRestoration&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			id: id,
			name: name,
			isLocked: isLocked
		}
	}).done(function(code) {
		var result = JSON.parse(code);
		$ck('#ckhtmlcontainer').html(result.htmlcode);
		$ck('#ckstylescontainer').html(result.stylecode);
		CKBox.close();
		jQuery('.restoreline' + index + ' .processing').removeClass('ckwait');
		ckInitInterface();
		ckSaveAction();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckAddWaitOverlay() {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
}

function ckRemoveWaitOverlay() {
	$ck('#ckwaitoverlay').remove();
}

function ckShowWidgetsPopup() {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	ckCloseEdition();
	$ck('.ckfocus').removeClass('ckfocus');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxwidgetsmanager&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
		}
	}).done(function(code) {
		$ck('#ckpopup').empty().append(code);
//		$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveWizard();CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
		CKBox.open({handler: 'inline', content: 'ckpopup', style: {padding: '10px'}});
		$ck('#ckwaitoverlay').remove();
		ckCheckEnabledWidgets();
//		ckCheckWidgetsVersions();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckCheckEnabledWidgets() {
	$ck('#widgetsmanager .widgetrow').each(function() {
		$ck(this).attr('data-enabled', $ck('#widgetsElements .widget[data-name="' + $ck(this).attr('data-name') + '"]').attr('data-enabled'));
	});
}

function ckGetWidgetData(btn) {
	var widgetData = $ck($ck(btn).parents('.widgetrow')[0]);
	return widgetData;
}

function ckInstallWidget(btn, isupdate) {
	if (!isupdate) isupdate = false;
	ckAddSpinnerIcon($ck(btn));
	var widgetData = ckGetWidgetData(btn);
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxInstallWidget&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			url: widgetData.attr('data-url'),
			name: widgetData.attr('data-name')
//			type: widgetData.attr('data-type')
		}
	}).done(function(code) {
		if (code == '1') {
			$ck('#widgetsElements').append('<script src="' + TEMPLATECREATORCK_URI + '/widgets/' + widgetData.attr('data-name') + '/interface.js" type="text/javascript"></script>');
			widgetData.attr('data-installed', '1');
			widgetData.attr('data-update', '0');
			$ck(btn).parent().find('.widgetupdate').find('> .ckwait').attr('class', 'fa fack-refresh');
			if (!isupdate) ckEnableWidget(btn);
			
			if (! $ck('#widgetsElements .widget[data-name="' + widgetData.attr('data-name') + '"]').length) {
				$ck('#widgetsElements').append('<div class="widget" data-name="' + widgetData.attr('data-name') + '" data-enabled="0"></div>');
			}
		} else {
			alert(TCK.Text._('CK_WIDGET_INSTALL_FAILED', 'Widget installation failed'));
		}
		ckRemoveSpinnerIcon($ck(btn));
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckEnableWidget(btn) {
	var widgetData = ckGetWidgetData(btn);
	var funcName = 'TCK_Widget' + ckCapitalizeFirstLetter(widgetData.attr('data-name')) +'Enable';
	if (typeof(window[funcName]) == 'function') {
		window[funcName]();
		$ck('#widgetsElements .widget[data-name="' + widgetData.attr('data-name') + '"]').attr('data-enabled', '1');
	} else {
		alert('Error : Function TCK_Widget' + ckCapitalizeFirstLetter(widgetData.attr('data-name')) +'Enable is not found. Is the widget installed ?')
	}
	
}

function ckDisableWidget(btn) {
	var widgetData = ckGetWidgetData(btn);
	var funcName = 'TCK_Widget' + ckCapitalizeFirstLetter(widgetData.attr('data-name')) +'Disable';
	if (typeof(window[funcName]) == 'function') {
		window[funcName]();
	} else {
		alert('Error : Function TCK_Widget' + ckCapitalizeFirstLetter(widgetData.attr('data-name')) +'Disable is not found. Is the widget installed ?')
	}
}

function ckEditWidget(btn) {
	$ck('#widgetsmanager').hide();
	$ck('#widgetedition').fadeIn();
	var widgetData = ckGetWidgetData(btn);
	var funcName = 'TCK_Widget' + ckCapitalizeFirstLetter(widgetData.attr('data-name')) +'Edit';
	if (typeof(window[funcName]) == 'function') {
		window[funcName](btn);
	} else {
		alert('Error : Function TCK_Widget' + ckCapitalizeFirstLetter(widgetData.attr('data-name')) +'Edit is not found. Is the widget installed ?')
	}
}

function ckCapitalizeFirstLetter(string) {
	return string.charAt(0).toUpperCase() + string.slice(1);
}

function ckCapitalize(string) {
	return ckCapitalizeFirstLetter(string);
}

function ckAfterWidgetEditionDisplay() {
	$ck('#widgetedition').prepend('<div id="widgeteditionbackbutton" onclick="ckCloseWidgetEdition()" class="ckbutton"><span class="fack fack-arrow-left"></span>&nbsp;&nbsp;' + TCK.Text._('CK_BACK_TO_WIDGETS_LIST', 'Back to Widgets List') + '</div><p></p>');
}

function ckCloseWidgetEdition() {
	$ck('#widgetsmanager').fadeIn();
	$ck('#widgetedition').hide().empty();
}
/*
function ckCheckWidgetsVersions() {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCheckWidgetUpdate&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		dataType: 'json',
		data: {
		}
	}).done(function(response) {
		for(var name in response) {
			$ck('.widgetrow[data-name="' + name + '"]').attr('data-update', response[name]);
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED_CHECK_VERSION', 'Failed to check the widgets versions'));
	});
}*/

function ckGetWidgetsData() {
	var widgets = Object();
	$ck('#widgetsElements .widget').each(function(i) {
		var widget = new Object();
		widget['name'] = $ck(this).attr('data-name');
		widget['enabled'] = $ck(this).attr('data-enabled');
		widget['data'] = $ck(this).find('.widgetdata').html();
		if (typeof(window['ckAfterWidgetData' + widget['name']]) == 'function' && widget['enabled'] == '1') window['ckAfterWidgetData' + widget['name']](widget);
		widgets[$ck(this).attr('data-name')] = widget;
	});

	return widgets;
}

function ckInstallWidgetManually() {
	var files = document.getElementById('tck_file_upload').files;
	var formData = !!window.FormData ? new FormData() : null;
	for (var i = 0; i < files.length; i++) {

		if (!files[i].name.match(/.zip$/)) {
			alert('The file must be a ZIP : ' + files[i].name) ;
			continue ;
		}

		if (!!window.FormData) formData.append('file', files[i]);
		var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxAddWidgetManually&" + CKTOKEN;
		$ck.ajax({
			type: "POST",
			url: myurl,
			// async: false,
			data: formData,
			// data: {
				// file: files[i]
			// }
			dataType: 'json',
			processData: false,  // indique ? jQuery de ne pas traiter les données
			contentType: false,  // indique ? jQuery de ne pas configurer le contentType
		}).done(function(response) {
			if (response && response.success == '1') {
				alert(TCK.Text._('CK_WIDGET_INSTALL_SUCCESS', 'Widget installed correctly'));
				$ck('#widgetsElements').append('<script src="' + TEMPLATECREATORCK_URI + '/widgets/' + response.name + '/interface.js" type="text/javascript"></script>');
				var btn = $ck('.widgetrow[data-name="' + response.name + '"] .ckbutton');
				var widgetData = ckGetWidgetData(btn);
				widgetData.attr('data-installed', '1');
				widgetData.attr('data-update', '0');
				$ck(btn).parent().find('.widgetupdate').find('> .ckwait').attr('class', 'fa fack-refresh');
//				if (!isupdate) ckEnableWidget(btn);

				if (! $ck('#widgetsElements .widget[data-name="' + response.name + '"]').length) {
					$ck('#widgetsElements').append('<div class="widget" data-name="' + response.name + '" data-enabled="0"></div>');
				}
			} else {
				alert(TCK.Text._('CK_WIDGET_INSTALL_FAILED', 'Widget installation failed'));
			}
		}).fail(function() {
			// alert(TCK.Text._('CK_FAILED', 'Failed'));
		});
	}
}

/*=================================*/
/*		Modules management
/*=================================*/

function ckInstallModule(name) {
	var icon = $ck('.blocselect.'+name).find('.fack');
	icon.attr('data-class', icon.attr('class')).attr('class', 'fa fack-spinner fack-spin');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxInstallModule&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
//			url: url,
			name: name
		}
	}).done(function(code) {
		if (code == '1') {
			alert(TCK.Text._('CK_MODULE_INSTALL_SUCCESS', 'Widget installation successful !'));
			$ck('.blocselect.'+name).removeClass('notinstalled').addClass('dragtoadd').find('.installbutton').remove();
			ckAddDraggableToBlocks();
		} else {
			alert(TCK.Text._('CK_MODULE_INSTALL_FAILED', 'Widget installation failed'));
		}
		icon.attr('class', icon.attr('data-class'));
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
//		$ck('#ckwaitoverlay').remove();
	});
}


/*--------------------------------------------
--- 			Script for V4	 			--
----------------------------------------------*/
function ckCapitalize(s) {
	return s[0].toUpperCase() + s.slice(1);
}

function ckShowLayouts() {
	CKBox.open({'handler': 'inline', 'content': 'cklayoutslist', size: {x:'950px', y:'370px'}});
}

function ckGetLibraryTemplates() {
	$ck('#ckmodelslist').addClass('ckwait');
	var debug = false;
//	sessionStorage.setItem('templatecreatorck_library_templates','');
	if (!debug && window.sessionStorage && sessionStorage.getItem('templatecreatorck_library_templates')) {
		var categorieshtml = sessionStorage.getItem('templatecreatorck_library_templates');
		$ck('#ckmodelslist').empty().append(categorieshtml);
		$ck('#ckmodelslist').removeClass('ckwait');
		ckGetLibraryTemplatesRange(1);
	} else {
		var url = 'https://media.joomlack.fr/api/templatecreatorck/templates';
//		var url = 'https://localhost/media.joomlack.fr/api/templatecreatorck/templates';
		jQuery.ajax({
			url: url,
			dataType: 'jsonp',
			cache: false,
			jsonpCallback: "joomlack_jsonpcallback",
			timeout: 20000,
			success: function (response) {
				// convert the response object in array of keys sorted descending (=date)
				keysSorted = Object.keys(response).sort(function(a,b){return b - a})

				$ck('#ckmodelslist').removeClass('ckwait');
				var sectionhtml = '';
				sectionhtml += '<div class="ckgallerywrap">';
				var nbitems = 0;
				var nbitemsperpage = 8;
//				var i = 0;
//				for (var cat in response) {
					for (var i=0;i<keysSorted.length;i++) {
//					for (var i in response) {
//						var item = response[i];
						var item = response[keysSorted[i]];
						var dataid = item['infos']['category'].toLowerCase() + '-' + item['name'].toLowerCase();
						sectionhtml += 	 	'<div class="ckgalleryitem" data-id="' + dataid + '" data-category="' + item['infos']['category'].toLowerCase() + '" style="display:none;">'
												+ '<div class="ckgalleryiteminner">'
													+ '<div class="ckgalleryitemimage">'
														+ '<img src="" data-src="' + item['thumb'] + '" />'
													+ '</div>'
													+ '<div class="ckgalleryiteminfos">'
														+ '<div class="ckgalleryitemtitle">' + ckCapitalize(item['name']) + '</div>'
														+ '<div class="ckgalleryitempreviewbtn"><button class="ckbutton" onclick="ckPreviewGalleryItem(this)"><span class="fack fack-info"></span> '  + TCK.Text._('CK_DETAILS') + '</button></div>'
														+ '<div class="ckgalleryitemloadbtn"><button class="ckbutton" onclick="ckLoadTemplateFile(\'' + item['file'] + '\')"><span class="fack fack-download"></span> ' + TCK.Text._('CK_LOAD') + '</button></div>'
													+ '</div>'
													+ '<div class="ckgalleryitemdetails">'
														+ '<img src="" data-src="' + item['preview'] + '" />'
														+ '<div class="ckgalleryitemdetailsinfos">'
															+ '<div><span data-info="name">' + item['name'] + '</span></div>'
															+ '<div><span data-info="detaillabel">'  + TCK.Text._('CK_DESCRIPTION') + '</span> <span>' + item['infos']['description'] + '</span></div>'
															+ '<div><span data-info="detaillabel">'  + TCK.Text._('CK_AUTHOR') + '</span> <a href="'  + item['infos']['authorurl'] + '" target="_blank"><span>' + item['infos']['author'] + '</span></a></div>'
															+ '<div><span data-info="detaillabel">'  + TCK.Text._('CK_PRICE') + '</span> <span class="ckbadge">' + (item['infos']['free'] ? TCK.Text._('CK_FREE') : item['infos']['price']) + '</span></div>'
															+ '<div class="ckgalleryitemdetailsactions">'
																+ (item['infos']['demourl'] ? '<a class="ckbutton ckbutton-primary ckbutton-big" href="' + item['infos']['demourl'] + '" target="_blank"><span class="fack fack-desktop"></span> <span>'  + TCK.Text._('CK_DEMO') +  '</span></a>' : '<div class="ckalert">' + TCK.Text._('CK_DEMO_NOT_AVAILABLE') + '</div>')
																+ (item['infos']['documentationurl'] ? '<a class="ckbutton ckbutton-big" href="' + item['infos']['documentationurl'] + '" target="_blank"><span class="fack fack-file-text-o"></span> <span>'  + TCK.Text._('CK_DOCUMENTATION') +  '</span></a>' : '')
																+ '<div class="ckbutton ckbutton-danger ckbutton-big" onclick="ckLoadTemplateFile(\'' + item['file'] + '\')"><span class="fack fack-download"></span> <span>'  + TCK.Text._('CK_LOAD') + '</span></div>'
																+ '<a class="ckgalleryitemdetailmanualdownload" href="' + item['file'] + '"><span>'  + TCK.Text._('CK_MANUAL_DOWNLOAD') + '</span></a>'
															+ '</div>'
														+ '</div>'

														for (var d=0;d<item.length;d++) {
							sectionhtml +=						' | info : ' + item[d];
														}
							sectionhtml +=			 '</div>'
												+ '</div>'
											+ '</div>';

						nbitems++;
//						i++;
//						if (i == 3) i = 0;
					}
//				}

				var categorieshtml = sectionhtml
										+ '<div style="clear:both;"></div>';

				var nbpages = parseInt((nbitems -1) / nbitemsperpage) + 1;
				var pagination = '<div class="ckgallerypagination"><span class="">' + TCK.Text._('CK_PAGES') + '</span><div class="ckbutton-group">';
									for (var page=1; page <= nbpages; page++) {
										pagination += '<div class="ckgallerypaginationindex ckbutton" onclick="ckGetLibraryTemplatesRange(' + page + ', this)">' + page + '</div>';
									}
					pagination += '</div></div>';

				categorieshtml = pagination + categorieshtml;
				$ck('#ckmodelslist').append(categorieshtml);
				$ck('#ckmodelslist').removeClass('ckwait');
				ckGetLibraryTemplatesRange(1);
				sessionStorage.setItem('templatecreatorck_library_templates', categorieshtml);
			},
			fail: function() {
				alert('Error : Unable to connect to the library. Please contact an administrator');
			},
			complete: function() {

			},
			error: function(request, status, error) {

			}
		});
	}
}

function ckGetLibraryTemplatesRange(page, btn) {
	var start = 8 * (page -1);
	var end = 8 * page;
	$ck('#ckmodelslist').find('.ckgalleryitem').hide();
	$ck('#ckmodelslist').find('.ckgalleryitem').slice(start, end).each(function() {
		var image = $ck(this).find('.ckgalleryitemimage img');
		image.attr('src', image.attr('data-src'));
		$ck(this).fadeIn();
	});
	$ck('.ckgallerypagination').find('.active').removeClass('active');
	$ck('.ckgallerypaginationindex').eq(page-1).addClass('active');
}

function ckPreviewGalleryItem(btn) {
	var item = $ck($ck(btn).parents('.ckgalleryitem')[0]);
	$ck('#ckgalleryitemdetail').removeAttr('id');
	var details = item.find('.ckgalleryitemdetails').attr('id', 'ckgalleryitemdetail');
	var image = details.find('img');
	image.attr('src', image.attr('data-src'));
	CKBox.open({handler: 'inline', content: 'ckgalleryitemdetail', style: {padding: '10px'}});
}

function ckLoadTemplateFile(file) {
	ckAddWaitOverlay();
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=template.ajaxImport&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		dataType: "json",
		data: {
			gabariturl: file
		}
	}).done(function(response) {
		if (response.status == '1') {
			window.location.href = TEMPLATECREATORCK_ADMIN_URL + '&view=template&layout=edit&quickdata=1&id=' + response.id;
		} else {
			ckShowManualLoadTemplateFile(file);
			ckRemoveWaitOverlay();
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		ckRemoveWaitOverlay();
	});
}

function ckShowManualLoadTemplateFile(file) {
	$ck('#ckmanualtemplateinstuctions').remove();
	$ck(document.body).append('<div id="ckmanualtemplateinstuctions"><p>' + TCK.Text._('CK_MANUAL_TEMPLATE_INSTALL_INFOS') + '</p><p><a class="" href="https://www.template-creator.com/en/documentation-category/miscellaneous/manual-library-installation" target="_blank">' + TCK.Text._('CK_READ_DOCUMENTATION') + '</a></p><p></p><p style="text-align:center;"><a class="ckbutton" href="' + file + '" target="_blank">' + TCK.Text._('CK_DOWNLOAD') + '</a></p></div>');
	CKBox.open({handler: 'inline', content: 'ckmanualtemplateinstuctions', style: {padding: '10px'}, size: {x: '400px', y: '200px'}});
}

function ckShowWizard() {
	bloc = $ck('#body');
	$ck('#ckwizardmodal').addClass('ckwait');
	$ck('#ckwizardmodal .ckinterface').hide();
//	$ck('html, body').animate({scrollTop: 0}, 'slow');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxparams&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			expertmode: $ck('#body').hasClass('expert'),
			joomlaversion: $ck('#joomlaversion').attr('value')
		}
	}).done(function(code) {
		$ck('#ckwizardmodal').removeClass('ckwait');
		$ck('#ckparamsfake').empty().append(code);
		$ck('#ckwizardmodal .ckinterface').fadeIn();
		ckFillEdition('body');
		ckFillWizard();
		ckInitTooltip($ck('#ckwizardmodal'));
		$ck('#ckparamsfake #ckinterfaceparams').attr('id', 'ckinterfaceparamsfake');
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		// $ck('#ckwaitoverlay').remove();
	});
	$boxfooterhtml = '<a class="ckboxmodal-button" href="javascript:void(0);" onclick="ckSaveWizard();CKBox.close();">' + TCK.Text._('CK_SAVE_CLOSE') + '</a>';
//	$ck('#ckwizardmodal').show();
	CKBox.open({handler: 'inline', content: 'ckwizardmodal', style: {padding: '10px'}, size: {x: '600px', y: '400px'}, footerHtml: $boxfooterhtml});
}

function ckFillWizard() {
	$ck('#ckwizardmodal [data-id="name"]').val($ck('#name').val());
	$ck('.inputbox', $ck('#ckwizardmodal .ckinterface')).each(function(i, field) {
		var $field = $ck(field);
		var fieldid = $field.attr('data-id');
		var cssvalue = $ck('#' + fieldid).val();
		if ($field.attr('type') == 'radio') {
		} else if (cssvalue) {
			$field.attr('value', cssvalue);
			if ($field.hasClass('colorPicker') && $field.attr('value')) {
				ckSetPickercolor($field);
				$field.css('background-color', $field.attr('value'));
			}
		} else {
			$field.attr('value', '');
		}
	});
}

function ckSaveWizard() {
	$ck('#name').val($ck('#ckwizardmodal [data-id="name"]').val());
	$ck('.inputbox', $ck('#ckwizardmodal .ckinterface')).each(function(i, field) {
		var $field = $ck(field);
		var fieldid = $field.attr('data-id');
		var cssvalue = $field.val();
		if ($field.attr('type') == 'radio') {
			
		} else if (cssvalue) {
			$ck('#' + fieldid).val(cssvalue);
		} else {
			$ck('#' + fieldid).val('');
		}
	});
	ckRenderCss('body', $ck('#ckwizardmodal'), $ck('#body'), false);
}

function ckLoadEmptyLeftPanel() {
	$ck('#ckedition').append('<div class="ckleftpanelheader">'
	+'<span class="ckleftpanelheadericon ckclose" onclick="ckCloseEdition();">×</span>'
	+'</div>').show();
}

/*--------------------------------
--		Custom Styles Creator	--
-------------------------------- */

function ckShowCustomStyleInterface() {
	// only show the main part if no style loaded
	$ck('#ckcustomstylepreviewwrap').fadeIn();
	if (! $ck('#ckstylescontainer .ckstylecontainer[data-id^="ckcustomstyle"]').length) {
		ckCreateNewCustomStylesFields();
	} else {
		$ck('#ckstylescontainer .ckstylecontainer[data-id^="ckcustomstyle"]').each(function() {
			var prefix = $ck(this).attr('data-id');
			var index = prefix.replace('ckcustomstyle', '');
			var text = $ck(this).attr('data-name') ? $ck(this).attr('data-name') : 'style' + index;
			if (! $ck('#' + prefix).length) ckCreateNewCustomStylesFields(prefix, text, true); 
		});
	}
	ckMakeCustomStyleButtonsSortable();
	ckLoadEmptyLeftPanel();
	$ck('#ckcustomstylesbuttons > .ckbutton').first().trigger('click');
}

function ckShowLayoutEdition(layout) {
	$ck(document.body).append('<div id="ckwaitoverlay"></div>');
	$ck('#ckedition').css({'left': '150px', 'opacity': 0, 'display': 'block'}); // note : ckpreviewedition
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxlayout" + layout + "&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templatename: $ck('#name').val()
		}
	}).done(function(code) {
		$ck('#ckedition').empty().animate({'left': '0px', 'opacity': 1}, 300).append(code);
		$ck('#ckwaitoverlay').remove();
		ckAddGoogleFontsToList();
		ckFillEdition('ckcustomlayout' + layout);
		ckAddEventOnFields($ck('#ckedition'), 'ckcustomlayout' + layout);
		if (typeof(window['ckUpdateLayoutPreview' + layout]) == 'function') window['ckUpdateLayoutPreview' + layout]();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}

function ckMakeCustomStyleButtonsSortable() {
	$ck('#ckcustomstylesbuttons').sortable({
		items: ".ckbutton",
		helper: "clone",
		// handle: ".tableck-controlMove",
		forcePlaceholderSize: true,
		tolerance: "intersect",
		// placeholder: "ckplaceholder",
		start: function(e, ui){
		},
		stop: function( event, ui ) {
		},
	});
}

function ckShowCustomStyleEdition(prefix, btn) {
	prefix = prefix ? prefix : '';
	btn = btn ? btn : false;
	// only show the main part if no style loaded
	$ck('#ckcustomstylepreviewwrap').fadeIn();
	if (! prefix) return;
	btn = $ck(btn);
	$ck('#ckcustomstylesbuttons .active').removeClass('active');
	$ck('#ckcustomstylesbuttons .menustylescustom').removeClass('menustylescustom');
	btn.addClass('active');
	var styleswrapper = ckGetStylesWrapperForBlock(btn.attr('id'));
	var cssclass = styleswrapper.attr('data-cssselector') ? styleswrapper.attr('data-cssselector') : btn.attr('data-class');
	$ck('#ckcustomstylepreview > .inner').attr('class', 'inner ' + cssclass);

	btn.attr('class', 'active ckbutton menustylescustom').attr('data-rule', '.' + cssclass);
	ckShowEdition(btn.attr('id'), '', 'ckAfterShowCustomStyleEdition');
}

function ckAfterShowCustomStyleEdition() {
	var btn = $ck('#ckcustomstylesbuttons .ckfocus');
	var styleswrapper = ckGetStylesWrapperForBlock(btn.attr('id'));
	var name = styleswrapper.attr('data-name') ? styleswrapper.attr('data-name') : btn.text();
	var cssclass = styleswrapper.attr('data-cssselector') ? styleswrapper.attr('data-cssselector') : btn.attr('data-prefix');
	$ck('#ckcustomstylename').val(name);
	$ck('#ckcustomstylecssselector').val(cssclass);
}

function ckUpdateCustomStyleData() {
	var btn = $ck('#ckcustomstylesbuttons .ckfocus');
	var name = $ck('#ckcustomstylename').val().replace('"', '');
	$ck('#ckcustomstylename').val(name);
	var cssclass = ckAlphaNumeric($ck('#ckcustomstylecssselector').val());
	$ck('#ckcustomstylecssselector').val(cssclass)
	btn.text(name).attr('data-rule', '.' + cssclass);
	var styleswrapper = ckGetStylesWrapperForBlock(btn.attr('id'));
	styleswrapper.attr('data-name', name);
	styleswrapper.attr('data-cssselector', cssclass);
	$ck('#ckcustomstylepreview > .inner').attr('class', 'inner ' + cssclass);
	ckRenderCss();
}

function ckRemoveCustomStyle() {
	if (!confirm(TCK.Text._('CK_CONFIRM_DELETE','Are you sure that you want to delete ?'))) return;
	var btn = $ck('#ckcustomstylesbuttons .ckfocus');
	var styleswrapper = ckGetStylesWrapperForBlock(btn.attr('id'));
	styleswrapper.remove();
	btn.remove();
	ckClosePreviewEdition();
}

function ckBeforeCloseEditionPopup() {
	$ck('#ckcustomstylesbuttons .active').removeClass('active');
	$ck('#ckcustomstylepreviewwrap').fadeOut();
	if ($ck('#cktemplatecontainer').hasClass('ckcssmanager')) {
		ckManageHtmlCss();
	}
}

function ckCreateNewCustomStylesFields(prefix, text, notshowedition) {
	notshowedition = notshowedition ? notshowedition : false;
	if (! prefix) {
		var index = ckGetNewStyleId();
		var prefix = 'ckcustomstyle' + index;
		var text = 'style' + index;
	}
	var styleswrapper = ckGetStylesWrapperForBlock(prefix);
	var cssclass = styleswrapper.attr('data-cssselector') ? styleswrapper.attr('data-cssselector') : prefix;
	var newbutton = '<div id="' + prefix + '" data-prefix="' + prefix + '" data-rule=".' + cssclass + '" data-class="' + prefix + '" data-element="customstyle" onclick="ckShowCustomStyleEdition(\'' + prefix + '\', this)" class="ckbutton">'+text+'</div>';
	$ck('#ckcustomstylesbuttons').append(newbutton);

	if (! notshowedition) ckShowCustomStyleEdition(prefix, newbutton);
	return prefix;
}

function ckGetNewStyleId(idbase) {
	if (!idbase) idbase = 'ckcustomstyle';
	var i = 1;
	while ($ck('#' + idbase + i).length && i < 1000) {
		i++;
	}
	return i;
}

function ckManageHtmlCss() {
	if ($ck('#cktemplatecontainer').hasClass('ckcssmanager')) {
		$ck('#cktemplatecontainer').removeClass('ckcssmanager');
		$ck('.ckbloc').each(function() {
			ckRemoveEdition($ck(this));
		});
		ckCloseEdition();
	} else {
		// ckLoadEmptyLeftPanel();
		$ck('#cktemplatecontainer').addClass('ckcssmanager');
		$ck('.ckbloc:not(.ckbloclayout)').each(function(i, bloc) {
			ckAddEdition(bloc);
		});
	}
}

function ckChangeBlocClass(btn) {
	var bloc = ckGetBlockFromBtn(btn);
	// blocid = bloc.attr('id');
	var blocinner = bloc.attr('id') == 'body' ? bloc : bloc.find('> .inner');
	var oldclass = blocinner.attr('data-class') ? blocinner.attr('data-class') : '';
	var newclass = prompt(TCK.Text._('CK_ENTER_CSS_CLASS', 'Enter a CSS Class'), oldclass);
	if (newclass) newclass = ckAlphaNumeric(newclass, true);
	$ck('> .editorck > .ckfields .editorckclass', bloc).html(newclass);
	blocinner.removeClass(oldclass);
	blocinner.addClass(newclass);
	blocinner.attr('data-class', newclass);
}

/*--------------------------------
--		Elements library		--
-------------------------------- */

function ckSaveItem(blocid) {
	var name = prompt('Name to save the element');
	if (! name) return;
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var saveditem = $ck('#' + blocid).clone();
	ckRemoveEdition(saveditem, true);
	saveditem.prepend(styleswrapper.find('> .ckstyle').clone()).prepend(styleswrapper.find('> .ckprops').clone());
	saveditem.find('.ckbloc, .ckrowcontainer').each(function() {
		var $this = $ck(this);
		styleswrapper = ckGetStylesWrapperForBlock(this.id);
		$this.prepend(styleswrapper.find('> .ckstyle').clone()).prepend(styleswrapper.find('> .ckprops').clone());
	});
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxSaveElement&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name : name,
			html : saveditem[0].outerHTML
		}
	}).done(function(code) {
		alert(TCK.Text._('CK_SAVED', 'Saved'));
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

//function ckLoadLibraryElements() {
//	// ckGetLibraryTemplates à appeler par la suite pour charger les éléments
//	$ck('#ckaddblockmanager').stop().animate({'margin-left': '-300px'});
//	$ck('#ckleftpanel').animate({scrollTop: 0}, 0);
//}

function ckCloseLibraryElements() {
	$ck('#ckaddblockmanager').stop().animate({'margin-left': '0'});
}

function ckGetLibraryElements(type) {
	var container = $ck('[data-id="tab_library_' + type + '2"] > .inner')
	container.addClass('ckwait');
	var debug = true;
//	sessionStorage.setItem('templatecreatorck_library_elements_' + type,'');
	if (!debug && window.sessionStorage && sessionStorage.getItem('templatecreatorck_library_elements_' + type)) {
		var libraryhtml = sessionStorage.getItem('templatecreatorck_library_elements_' + type);
		container.empty().append(libraryhtml);
		container.removeClass('ckwait');
		ckAddDraggableToLibraryElements();
	} else {
		var dev = 0;
		if (dev) {
			var url = 'https://localhost/media.joomlack.fr/api/templatecreatorck/elements/' + type;
		} else {
			var url = 'https://media.joomlack.fr/api/templatecreatorck/elements/' + type;
		}
		jQuery.ajax({
			url: url,
			dataType: 'jsonp',
			cache: false,
			jsonpCallback: "joomlack_jsonpcallback",
			timeout: 20000,
			success: function (response) {
				container.removeClass('ckwait');
				var libraryhtml = '';
//				for (var i=0;i<response.length;i++) {
				for (var i in response) {
					var item = response[i];
					var dataid = type + '/' + item['name'].toLowerCase();
					var suffix = type;
					if (type == 'section' || type == 'header') suffix = 'wrapper';
					libraryhtml += 	 	'<div class="cklibraryitem cklibraryitem' + suffix + ' ckdragtoaddelement" data-id="' + dataid + '">'
											+ '<img src="' + item['thumb'] + '" />'
										+ '</div>'
										;
				}

				sessionStorage.setItem('templatecreatorck_library_elements_' + type, libraryhtml);
				// container.empty().append(libraryhtml);
				container.empty().append(libraryhtml);
				container.removeClass('ckwait');
				ckAddDraggableToLibraryElements();
			},
			fail: function() {
				alert('Error : Unable to connect to the library. Please contact an administrator');
			},
			complete: function() {

			},
			error: function(request, status, error) {

			}
		});
	}
}

function ckLoadLibraryElement(block) {
	// ex id = modules/module1
//	var myurl = 'https://media.joomlack.fr/api/templatecreatorck/element/' + block.attr('data-id');
	var dev = 0;
	if (dev) {
		var myurl = 'https://localhost/media.joomlack.fr/api/templatecreatorck/element/' + block.attr('data-id');
	} else {
		var myurl = 'https://media.joomlack.fr/api/templatecreatorck/element/' + block.attr('data-id');
	}
	$ck.ajax({
		url: myurl,
		dataType: 'jsonp',
		cache: false,
		jsonpCallback: "joomlack_jsonpcallback",
		timeout: 20000,
	}).done(function(code) {
		if (code != 'error') {
//			var newcode = $ck(code['htmlcode'].trim());
		
			var newelement = $ck(code);
			$ck(block).before(newelement);
			newelement.hide();
			$ck(block).fadeOut(500, function() {
				$ck(block).remove();
				ckInitSortables();
				newelement.fadeIn('slow');
				ckSaveAction();
			});
			
			newelement.attr('data-oldid', newelement.attr('id')).removeAttr('id');;
			ckReplaceIdPositionInBlock(newelement);
			ckSeparateStylesForBlock(newelement, true);
//			newelement.find('.ckbloc').each(function() {
//				var $this = $ck(this);
//				$this.attr('data-oldid', $this.attr('id'));
//				$this.attr('id', '');
//				$this.attr('ckmoduleposition', '');
//			}); 
//			$ck('#body').prepend(newelement);
			newelement.find('.ckbloc, .ckrowcontainer').each(function() {
				var $this = $ck(this);
				$this.attr('data-oldid', $this.attr('id')).removeAttr('id');;
				ckReplaceIdPositionInBlock($this);
				ckAddControlsOnHover($this);
				ckSeparateStylesForBlock($this, true);
			});

//			ckInitSortables();
			ckAddControlsOnHover(newelement);
		} else {
			alert(TCK.Text._('Error : Can not get the element. Please retry and contact the developer.'));
		}
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckReplaceIdPositionInBlock(block) {
	// .attr('data-type')
	var type = ckGetBlockType(block);
	var parentid = '';
	if (block.hasClass('ckrowcontainer')) {
		parentid = $ck(block.parents('.ckrow')[0]).attr('id');
	}
	var newid = (type == 'wrapper' ? ckGetWrapperProposal() : ckGetIdProposal(type, parentid));
	// ckReplaceId(block, newid);
	var re = new RegExp(block.attr('data-oldid'), 'g');
	if (block.find('> .ckstyle').length) block.find('> .ckstyle').html(block.find('> .ckstyle').html().replace(re,newid));
	block.attr('id', newid).removeAttr('data-oldid');
	if (block.attr('ckmoduleposition')) {
		var newposition = ckGetPositionsProposal('block').join();
		block.attr('ckmoduleposition', newposition);
	}
}

function ckGetBlockType(block) {
	var classes = Array('wrapper', 'logobloc', 'rowcontainer', 'row', 'horiznav', 'singlemodule', 'flexiblemodules', 'flexiblemodule', 'custombloc', 'module');
	var blockclass = block.attr('class');
	var type = 'block';
	for (var i=0; i<classes.length; i++) {
		if (blockclass.indexOf(classes[i]) !== -1) {
			type = classes[i];
			if (type == 'flexiblemodules') type = 'block';
			return type;
			break;
		}
	}
	return type;
}

function ckShowGoogleFontsManager() {
	var bodyprops = ckGetPropsForBloc('body', 'googlefonts');
	var fontslist = bodyprops.attr('fontslist');
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxgfontsmanager&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		async: true,
		data: {
			fontslist : fontslist
		}
	}).done(function(code) {
		$ck('#ckgfontsmanager').remove();
		var ckgfontsmanager = $ck(code);
		$ck(document.body).append(ckgfontsmanager);
		ckgfontsmanager.hide();
		CKBox.open({handler: 'inline', content: 'ckgfontsmanager', style: {padding: '10px'}, size: {x: '600px', y: '300px'}});
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function ckShowGoogleFontsManager2() {
	CKBox.open({handler: 'iframe', url: TEMPLATECREATORCK_ADMIN_URL + '&view=fontselect&layout=default2&tmpl=component'});
}

function ckRemoveGoogleFont(font) {
	if (!confirm(TCK.Text._('CK_CONFIRM_DELETE','Are you sure that you want to delete ?'))) return false;
	var bodyprops = ckGetPropsForBloc('body', 'googlefonts');
	var fontslist = bodyprops.attr('fontslist');
	fontslist = fontslist.split(',');
	fontslist.splice( fontslist.indexOf(font), 1 );
	bodyprops.attr('fontslist', fontslist);
	// remove the line in the interface
	$ck('#ckgfontsmanager tr[data-font="' + font + '"]').remove();
	// remove the stylesheet
	$ck('#googlefontscall link[href*="fonts.googleapis.com/css?family=' + font.replace(' ', '+') + '"]').remove();
	$ck('#googlefontscall link[href*="fonts.googleapis.com/css2?family=' + font.replace(' ', '+') + '"]').remove();
	$ck('#googlefontscall link[href*="' + font.replace(' ', '+') + '"]').remove();
	// remove the css on all blocks
	var re = new RegExp("'" + font + "'", 'g');
	var re2 = new RegExp(font, 'g');
	$ck('#ckstylescontainer .ckstyle').each(function() {
		this.innerHTML = this.innerHTML.replace(re, 'inherit');
		this.innerHTML = this.innerHTML.replace(re2, 'inherit');
	});
	// remove the properties on all blocks
	$ck('.ckprops[blocfontfamily="' + font + '"]').attr('blocfontfamily', 'default');
	$ck('.ckprops[moduletitlefontfamily="' + font + '"]').attr('moduletitlefontfamily', 'default');
	$ck('.ckprops[moduletextfontfamily="' + font + '"]').attr('moduletextfontfamily', 'default');
	$ck('.ckprops[blocgooglefont="' + font + '"]').removeAttr('blocgooglefont').removeAttr('blocfontfamily');
	$ck('.ckprops[moduletitlegooglefont="' + font + '"]').removeAttr('moduletitlegooglefont').removeAttr('moduletitlefontfamily');
	$ck('.ckprops[moduletextgooglefont="' + font + '"]').removeAttr('moduletextgooglefont').removeAttr('moduletextfontfamily');

	var optiontoremove = $ck('#ckedition select[id$="fontfamily"]').find('option[value="' + font.replace('+', ' ') + '"]');
	optiontoremove.remove();

	return true;
}

function ckUpdateShapeDivider(prefix) {
	var focus = $ck('.ckfocus');
	
	if (prefix == 'divider') {
	focus.find('.tck-divider1-container').remove();
	switch ($ck('#' + prefix + 'shape').val()) {
		case 'multiclouds' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 86.47" preserveAspectRatio="none"><g style="opacity:0.33"><path d="M823,15.52l.24-.07A27.72,27.72,0,0,0,864.3,30.53a46.9,46.9,0,0,0,51.9,28A55,55,0,0,0,1000,73.07V0H792C795.79,12,809.32,18.85,823,15.52Z"></path><path d="M23.71,83.4A50,50,0,0,0,85.39,48.77v-.05a25.19,25.19,0,0,0,20.89-4.31,32.67,32.67,0,0,0,12.82,7A32.88,32.88,0,0,0,154.31,0H0V68.64A49.74,49.74,0,0,0,23.71,83.4Z"></path></g><g style="opacity:0.66"><path d="M499.63,19.13h.08a8.91,8.91,0,0,0,12.64,6.15A15.07,15.07,0,0,0,528,35.9a17.67,17.67,0,0,0,33.67-9.55v0A8.9,8.9,0,0,0,567.86,22a11.61,11.61,0,0,0,7.48-22H503.08a11.65,11.65,0,0,0-1.71,4.21,9.2,9.2,0,0,0-3.85-.28c-4.65.65-8,4.58-7.37,8.77S495,19.78,499.63,19.13Z"></path><path d="M631.55,20.67c1,7.6,8.68,12.87,17.22,11.78a16.35,16.35,0,0,0,11.45-6.74,16.34,16.34,0,0,0,7.07,2.14A10.86,10.86,0,0,0,686.86,35a10.82,10.82,0,0,0,8.1-1c1.68,6.83,9,11.4,17,10.38a16,16,0,0,0,12.48-8.49,19.56,19.56,0,0,0,10.37,1.45,19.24,19.24,0,0,0,11.72-5.89,10.85,10.85,0,0,0,17.33-.92A10.81,10.81,0,0,0,776,31.2a17.64,17.64,0,0,0,3.38,1,18.52,18.52,0,0,0,16.52,6A18.82,18.82,0,0,0,809.34,30c2.67,10,12.75,17.44,24.8,17.44,9.38,0,17.57-4.5,22-11.2a32,32,0,0,0,16.53,4.5,31.47,31.47,0,0,0,20.23-7.14,17.75,17.75,0,0,0,28.32,2.09,17.74,17.74,0,0,0,22.71,1.75c4.13,10.05,15,17.22,27.72,17.22,13.43,0,24.75-8,28.33-18.88V0H599.32C607.84,23.13,631.55,20.67,631.55,20.67Z"></path><path d="M.74,30.73c0,12.33,11.21,22.33,25.08,22.36,10.84,0,20.08-6.07,23.61-14.62A15.09,15.09,0,0,0,68.74,37a15.1,15.1,0,0,0,24.1-1.74,26.76,26.76,0,0,0,17.2,6.1,27.24,27.24,0,0,0,14.07-3.81,22.33,22.33,0,0,0,18.71,9.56c11.24,0,20.49-7.56,21.62-17.28a14.92,14.92,0,0,0,10.72.18c3.29,7.35,12.1,11.63,21.28,9.81a20.31,20.31,0,0,0,13.62-9.33A20.31,20.31,0,0,0,219,32.56a13.49,13.49,0,0,0,24.86,7.25,13.43,13.43,0,0,0,10-1.91c2.66,8.32,12.06,13.37,21.9,11.42a19.93,19.93,0,0,0,14.75-11.58,24.3,24.3,0,0,0,13,.92,23.88,23.88,0,0,0,14-8.3,13.47,13.47,0,0,0,21.4-2.61,13.46,13.46,0,0,0,17.17-2c4.56,6.88,13.69,10.63,23.18,8.76,12.14-2.4,20.26-13.09,18.13-23.88A73.93,73.93,0,0,0,400.48,0H0V29.49C.24,29.91.48,30.32.74,30.73Z"></path></g><path d="M16.3,13.9c10.2,2.5,20.3-1.1,25.5-8.3a14.66,14.66,0,0,0,18.5,3A14.6,14.6,0,0,0,80,14.9a13.14,13.14,0,0,0,3.4-2.4,25.71,25.71,0,0,0,14.8,9.7,26,26,0,0,0,14.1-.4,21.75,21.75,0,0,0,15.4,13.3c10.6,2.6,21-2.4,24.3-11.3a15,15,0,0,0,10.7,2.6,17.69,17.69,0,0,0,1.6,2.2,14.69,14.69,0,0,0,17.6,3.5,7.46,7.46,0,0,0,1.2-.7,14.54,14.54,0,0,0,6.4-8.9,12.61,12.61,0,0,0,.4-2.8,20.63,20.63,0,0,0,9.8-1.8,11.35,11.35,0,0,0,1.5,2.3A22.35,22.35,0,0,0,214,28.6c11.2,2.8,22.4-3.1,24.8-13.1a24.63,24.63,0,0,0,16.3,11.6c9.8,2.1,19.4-1.7,24.2-8.7a14,14,0,0,0,17.8,2.4,14.07,14.07,0,0,0,19.1,5.4,12.25,12.25,0,0,0,3.1-2.4,22.5,22.5,0,0,0,5.8,5.3,25.42,25.42,0,0,0,16.1,4,30.38,30.38,0,0,0,6-1.2c.2.4.4.9.6,1.3a20.81,20.81,0,0,0,14.6,11c10.2,2.2,20-2.9,22.9-11.5a13.84,13.84,0,0,0,10.3,2.1,14,14,0,0,0,19.3,4.6,14.17,14.17,0,0,0,6.7-11.8,20,20,0,0,0,9.3-2,21.31,21.31,0,0,0,14,9.9c10.6,2.3,20.9-3.4,23.2-12.7a28.46,28.46,0,0,0,37.2,7.1,23.54,23.54,0,0,0,7.3-7.1,15.79,15.79,0,0,0,20.1,2.1,15.69,15.69,0,0,0,21.6,5.5,13.88,13.88,0,0,0,3.5-2.9,26.66,26.66,0,0,0,9.5,7.2,28.5,28.5,0,0,0,7,2.2,29.16,29.16,0,0,0,15.2-1.3c2.8,6.6,9.3,11.8,17.5,13.3,11.4,2.1,22.2-3.8,25.3-13.4,0-.1.1-.2.1-.4.3.2.7.4,1,.6a15.93,15.93,0,0,0,10.7,1.5,15.79,15.79,0,0,0,28.7-6c.1-.4.1-.8.2-1.2a10.87,10.87,0,0,0,.1-1.8,22.26,22.26,0,0,0,10.4-2.6,25,25,0,0,0,3.9,4.7,24.65,24.65,0,0,0,12.2,6A24.5,24.5,0,0,0,715.3,34a19.09,19.09,0,0,0,10.2-13.4h.5a21.68,21.68,0,0,0,21.1,13,13.67,13.67,0,0,0,1.9-.2,22.1,22.1,0,0,0,13.8-7.7,24.79,24.79,0,0,0,11.9,8.5,25.09,25.09,0,0,0,8.1,1.4,25.86,25.86,0,0,0,18.5-6.7,21.77,21.77,0,0,0,5.2-7.2,15,15,0,0,0,19.1-1,15,15,0,0,0,21,2,13.81,13.81,0,0,0,2.8-3.1A26.84,26.84,0,0,0,866.3,26a27.39,27.39,0,0,0,14-3.4,22.36,22.36,0,0,0,18.3,9.9c11.1.3,20.4-7,21.8-16.6a15,15,0,0,0,11.2.2,15,15,0,0,0,21.1,1,15.16,15.16,0,0,0,4.7-13.5A22.32,22.32,0,0,0,966.3,0H0V1.6A25.29,25.29,0,0,0,16.3,13.9Z"></path><path d="M983.6,7.3A22.61,22.61,0,0,0,1000,1.1V0H967.3A22.52,22.52,0,0,0,983.6,7.3Z"></path></svg>';
		break;
		case 'clouds' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 63.67" preserveAspectRatio="none"><path d="M916.2,58.53a46.9,46.9,0,0,1-46.1-17.89,32,32,0,0,1-14-4.4c-4.43,6.7-12.62,11.2-22,11.2-12,0-22.13-7.44-24.8-17.44a18.82,18.82,0,0,1-13.44,8.2,18.51,18.51,0,0,1-12.45-2.59h-.65a25.09,25.09,0,0,1-8.1-1.4,24.79,24.79,0,0,1-3.52-1.48,10.8,10.8,0,0,1-7.32-2.19,10.84,10.84,0,0,1-15.13,2.91,13.67,13.67,0,0,1-1.63.16,21.69,21.69,0,0,1-2.93,0,19.23,19.23,0,0,1-9.36,3.78,19.56,19.56,0,0,1-10.37-1.45A16,16,0,0,1,712,44.38c-7.56,1-14.51-3.07-16.67-9.28q-.71-.27-1.41-.58a10.82,10.82,0,0,1-7,.48,10.85,10.85,0,0,1-16.07,1.54,15.75,15.75,0,0,1-26.69.66,15.93,15.93,0,0,1-10.7-1.5c-.3-.2-.7-.4-1-.6,0,.2-.1.3-.1.4C629.2,45.1,618.4,51,607,48.9c-8.2-1.5-14.7-6.7-17.5-13.3a29.16,29.16,0,0,1-15.2,1.3,28.5,28.5,0,0,1-7-2.2,26.65,26.65,0,0,1-5.65-3.46A17.66,17.66,0,0,1,528,35.9a15.07,15.07,0,0,1-15.65-10.62,8.91,8.91,0,0,1-2.07.72L510,26a23.53,23.53,0,0,1-4.73,3.86,28.46,28.46,0,0,1-37.2-7.1c-2.3,9.3-12.6,15-23.2,12.7a21.31,21.31,0,0,1-14-9.9,20,20,0,0,1-9.3,2,14.17,14.17,0,0,1-6.7,11.8l-.05,0A14,14,0,0,1,395.6,34.8a13.84,13.84,0,0,1-10.3-2.1c-2.9,8.6-12.7,13.7-22.9,11.5a20.81,20.81,0,0,1-14.6-11c-.2-.4-.4-.9-.6-1.3a30.38,30.38,0,0,1-6,1.2,25.39,25.39,0,0,1-7.23-.41,13.46,13.46,0,0,1-16.46-2.33,23.88,23.88,0,0,1-14,8.3,24.3,24.3,0,0,1-13-.92,19.93,19.93,0,0,1-14.75,11.58c-9.84,2-19.24-3.1-21.9-11.42a13.43,13.43,0,0,1-10,1.91A13.49,13.49,0,0,1,219,32.56a20.31,20.31,0,0,1-8.94-2.07,20.31,20.31,0,0,1-13.62,9.33c-7.6,1.51-14.95-1.18-19.11-6.32a14.7,14.7,0,0,1-11.15-3.1,14.89,14.89,0,0,1-1.74-.57c-1,8.55-8.28,15.43-17.67,17a32.85,32.85,0,0,1-40.49-2.38,25.19,25.19,0,0,1-20.89,4.31v.09A50,50,0,0,1,0,68.64V86.47H1000V73.07a55,55,0,0,1-83.8-14.54Z" transform="translate(0 -22.8)"></path></svg>';
		break;
		case 'papertorn' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 80" preserveAspectRatio="none"><path d="M0,0V71.07l.22.05c2.83,1,7.45-4.57,7.45-4.57s13.36,6.34,14.9,6.6S30,76.45,30,76.45L36.7,71.5s5.4,6,8,4.95,16.19-8.88,17.73-3.55S64.2,80,65,80s5.4-5.59,6.42-5.59,11,2.79,11.82,2.79,7.71-5.84,9.25-6.6,18.24.51,22.1,2.66,14.13.13,19.79,0,25.18,1.9,25.18,1.9l8.48-1.9s0-5.46,1.8-5.2,9.25.51,9.25.51L180.34,65s20.81,2,22.1,2,2.31-3.81,4.37-3.81,14.13,3.81,15.42,3.81,9.25-3.55,11.56-3.81,8.48,5.08,10.28,5.58,55-6.6,55-6.6-.26-5.33,4.88-3.55,15.16,1.27,19.53,2,3.34,6.34,7.71,2.54,5.65-7.36,8.22-6.09,10.28,2.28,11,2.28,4.37-8.12,7.19-6.6,21.59,12.5,30.06,13.48,13.1-10.44,13.1-10.44l13.1,2.54s7.71,10.15,16.19,11.17,11,6.34,19.27,3.55,17.73-9.39,20-8.38,17.47-6.6,18.24-6.85,8.74.76,16.44.25,9.51-5.52,9.51-5.52,25.69-1.08,28.78,1.21,3.6,4.31,6.68,4.31,12.33-5.84,22.35-3.55,26,6.34,27.49,7.11,10.28-5.58,10.28-5.58,5.14,4.57,6.42,5.84,6.17.76,9.25,0,3.85-9.14,10-5.08,20.3-5.08,25.44,1S667,64,667,64s6.68-11.42,14.39-9.9S710.16,66.2,710.16,66.2l6.42-5.49,27.24-1.27s-1.28-7.11,6.17-5.33,10-.89,11-1.71,5.14-3.49,9,0,25.44,8.31,32.89,8.31,15.93-6.35,22.61-4.57,13.36-1.52,14.39-2-.77-4.65,6.42-3.47,19-.76,20.58-.25,6.17-.76,11.31-1.78,6.34-11.63,12.25-4.27,8.68,5.28,11.51,6.74,7.45,1.33,9.25,0-1.54-7.93,7.19-5.39,4.17,3.48,10.08,3,14.13,4.06,14.13,4.06,10.79-2,13.11-2.28,9.25-4.57,12.59-2.79,6.17,1.52,9,2.28,10-.51,11.82-1.78,2.57-6.35,7.71-3.55a11.91,11.91,0,0,1,3.14,2.18V0Z" style="opacity:0.66"></path><path d="M0,0V59.17c4.84-3,4.08,1,5.36-.23s0,0,2.57-1.27,3.08.51,7.19,1,2.83,2.54,2.83,2.54,8.74,5.08,10.28,4.57,4.88-9.14,4.37-10.15S40,61.22,40,61.22l4.37,3.3s9.76,2,11,1a59.11,59.11,0,0,1,8-4.57c1.8-.76,4.11,2.28,6.68,2.79s8.74,3.81,8.74,3.81S90.92,60.71,94,60.21s16.7,3.55,17.47,2,11.82-3,13.1-2.79,8.48,10.91,8.48,10.91l30.83-.51s6.68-6.09,7.45-7.61.26-1.78.26-1.78,9-4.57,10-4.57S193.18,61,193.18,61s10.54-4.06,14.39-5.08,6.68,1.52,12.85-2,19.79-2.79,20.56-3.3,7.45-6.34,12.85-9.39,11.31.76,13.1.76,7.71,5.33,10.79,4.57,10.28-5.33,13.62-5.33,2.83,2.28,10.28,1.78,5.91.51,12.59,4.32,8-2.29,12.85-3.55,1.8.25,4.63-.51a19,19,0,0,1,5.65-.76c1.29,0,2.57,1.52,8.74,3.55s5.91-.76,9.25-1.78,8.22-3.3,18.76-10.15,2.57,5.33,6.94,6.85,22.87,3.55,24.41,2,4.37-3,7.2-4.57,2.82-.51,3.59-.51,9,2.54,11.31,4.06,3.85,4.57,6.17,4.57,4.62-2.54,11-3.55-.26,4.82,0,5.58,2.06,0,5.4-.25,4.88-2.79,9.76-2.79,5.14,3.3,8.48,4.06,2.83,0,10.54-3.81,6.68-1.78,14.9-3.55,22.61,6.85,24.41,6.09,4.88-1.27,11.3-2.54,11.56,3,16.19,5.58,5.14-1.52,8.74-5.08,12.08.25,14.9.25,9.25-.25,13.36-.51,5.14-3,13.88-5.08,8,4.57,14.65,3.55,14.13-1.27,28-5.08,6.42,3,10.79,5.58,9,1.78,11.56,1.52S676,39.65,679.84,36.35s9.51,4.31,16.19,8.12,9.25,3.81,14.13,1.78,9.51-4.82,14.9-7.87,5.4,5.84,10,2.79,15.42.76,17.21-.25,8.48.76,15.42-1,1.8,2,7.45,6.85,3.08-2.29,15.42,1,28.52-2.29,32.89-3,4.88,5.33,9.25,5.84,5.4-4.82,9.76-7.87,17-.76,20.56-2a17.22,17.22,0,0,0,6.17-4.06s13.36,0,15.16-1.52,10.28-.76,13.36-.76,26,4.57,35.2,2.79,11.82-7.62,16.44-10.91,23.13,2.54,30.32,2.54,20.3-2.54,20.3-2.54V0Z"></path></svg>';
		break;
		case 'bridge' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 283 20.99" preserveAspectRatio="none"><path d="M81.66,18.4C67.67,6.89,32.57.93,18.57,20.33,14.2,14.75,6.34,11.48,0,9.75V0H0V21H143.75C134.52,9.95,107.42,1.35,81.66,18.4Z" transform="translate(0.02 -0.01)"></path><path d="M283,0V11c-3.82.72-6.67,2.21-13.46,9.21-15.71-21-52.38-5.64-55,.58-12.95-12.92-53.74-17.6-70.74.21H283V0Z" transform="translate(0.02 -0.01)"></path></svg>';
		break;
		case 'rockymoutain' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 90.1" preserveAspectRatio="none"><path d="M999.2,0V89.3c-2.1-.4-3.8.3-5.7.4,0,.1.1.2.1.3l-.3-.1a4.27,4.27,0,0,0-2.5-.1l-.1.1c-3.1-.8-2.6-3.4-8.3-3v-.5c-5.2-.2-10.4-.7-15.7-.5-5-.3-10.3-1.6-15.1-.8-5.6.9-10.9.7-16.4.8a29.31,29.31,0,0,0-7.2-1.2c-6.4-.3-8.2-2-8.6-4.3,0-.5-.2-1.1,1.2-1.5,3.9.1,5.7-1.1,8.4-2.1-4.9-1-9,.5-13.2.1h-2.4c-4.4-.6-.5-2.7-3.7-3.5a40,40,0,0,1-8.4-1.5c.3-2.6-3.8-4.2-8.5-5.5,0-1.1-.4-2.3,3.6-2.5h1.3l4.8-.5c3.3-.4,6.6-.9,9.7-1.5,1.8-.4,4-.6,4.9-1.5a.52.52,0,0,0,.4-.2c.1-.1,0-.2-.4-.3-2.2,0-4.4.1-6.6,0-4.4-.2-8.3,1.4-12.8.5a46.46,46.46,0,0,0-9.7-2l-2.4-1.5c.4-.1.4-.3,0-.5.7-2.2,3.8-3.3,9-3.5a6.54,6.54,0,0,0,3.1-.5c.4-2-2.7-1.1-4.9-1-2.5.8-4.9.2-7.3,0h-1.2c-3.5-2.3,2.3-3,4.6-4.1,4.6-2.2,4.5-2.8-2.1-4v-.5a257.26,257.26,0,0,0-29.1,1l-31.5,3.5a58.57,58.57,0,0,1-14.5,1.5c-1.2.7-3.1.4-4.8.5-1.3.7-3.2.4-4.9.5v.5c-7.2.4-14,1.5-20.7,2.5H779c-1.8-.7-4.2-1.2-5.3-2-5.1-3.7-13.8-5.8-21.2-8.5.1,0,.2-.1.3-.1.3-.3.2-.6-.5-.9-3.2-1.8-7.5-3.2-10.9-5l-1.2-.4a58.37,58.37,0,0,0-17-4.4,16.59,16.59,0,0,1-4.5-1.2c-8.4-2.7-15.5-6.4-27.9-5.9-1.8.1-3.2-.6-5-.8h-.2l-.1-.7a8.16,8.16,0,0,1-3.6-1.5c-8.7-2-18.3-3.1-27.8-4.1l-3.6-1-1.3-1c-5.8-.4-11.6-1.2-17,.5l-10.8.5a8.75,8.75,0,0,0-1.6-.2c-13.2-1.8-25.9-2.1-37.3,2.2-13.8.9-26.7,2.5-36.3,7.1l-2.6,2.5c-5.1,1.4-11.3,1.4-16.9,2-14.1.2-28.4-.3-41.8,2.2-.2,0-.4.1-.6.1-3.5.3-6,0-6-1.8,1.8-.8,1.7-1.7,0-2.5-1.5-2.3-6.3-4-6.2-6.5a16.84,16.84,0,0,1-4.8-2,42.72,42.72,0,0,0-21.8,2.5c-5.5.9-9,3.1-14.5,4l-2.5,1.4-4.8.5a13.86,13.86,0,0,1-5.3,1l-20,1.5a1.71,1.71,0,0,0-1.4,0c-6.9.5-12.2,3-19.9,2.9,3.2-.6,3-2.1,5.4-2.9.6-2.1.6-2.1-1.2-2.5-3.9.2-5.9,2.8-10.9,1.5-.4-.5-.5-1.2-2.4-.9h-.1c-1.3-1.4-2.2-3-7.5-2.2-.8.2-2.3-.5-3.4-.8,1.9-.8,3.3-1.7,4.9-2.5,2.5-.2,4.8-.5,6.1-1.5-.8-1.4-2.9-.7-4.8-.5a63.58,63.58,0,0,1-14.5,1c-1.5-.5-1-1,0-1.5l1.2-.5a11.6,11.6,0,0,0,2.4-2c2.7-.3,6.2.1,7.3-1.5h1.2c.7-.6,2.7-1.1,1.2-2l-6.1-1c-1.6.5-3.2-.7-4.8,0-6.7,1.1-13,2.7-20.6,2.5-.7.3-2,.2-2.6.5-2.4.2-5-.4-7.1.5-1.6,0-2.4.4-2.5,1l-2.3.5a36.43,36.43,0,0,0-13.4,3.5c-3.5.6-5.7,2.1-9.7,2.5-1.3,1.1-4.1,1.3-6.2,1.8-3.3.8-7.5,1.1-9.5,2.7-2.7-.1-3.5,1-4.9,1.6-4,1.8-9.8,3-12.1,5.5h-4.8c-3.4-1-7.3-.3-10.9-.5-1.9-1.3-1.6-3.6-7.9-3-1.5.1-4.2.5-4.7-.5s2.6-1.1,4.1-1.5c1.1-.4,3-.8,3-1.2.2-2.5,4.4-3.9,8.6-5.6-2.2-.3-5.1.3-6.4-.7-1.1-.9,3.7-.3,1.9-1.6-8.8,1.2-15.3,4-22.7,6.1l-3.7,1c-3.4.8-7.6,0-10.9,1-3.4.3-5.4,1.1-6.1,2.5-4.1,1.8-7.8,3.8-12.5,5.3A30.53,30.53,0,0,0,175.5,44c-1.9.4-3.5,1-3.6,2-2.2.6-4.5,1.2-4.8,2.5-3,.6-4,2-6,3-2,.4-3.6,1-3.7,2-3.3,1-4.3,2.4-4.2,4.1.1,2.5-3.7,4.7-9.3,5.5-3.5.5-7.1.9-10.7,1.4-4.5.6-9.4.5-13.6,1.6a8.07,8.07,0,0,1-5.7-.6c-1.6-.9-2.9-2.3-5.8-1.8s-2.7,2.1-2.7,3.3v1c-.1,0-.2.1-.3.2-1.6,1-2.4,2.4-6.6,2.3-3.9-.1-4.9-1.4-6.4-2.5,0-1.1-.4-2.1-3.3-2.8-.1,1.3-1.2,2.4.9,3.3-.1,1.4-3.8,1.9-4.9,3a4,4,0,0,0-2.4.5c-2.9.7-5.2.7-6.2-.9-.7-1.2-2.6-1.9-5.4-2.2-2.4,1.6-.6,3.7-4.1,5.1-6.5,0-4.6,2-4.8,3.4-.3,2.3-1.2,2.6-5.8,1.4-4-1.1-5-.3-5.1,1.2v4.8c-3.7-2.1-7.9-2.6-10.9-3.8l-1.2-2c.2-1.6-1.7-2.7-4.5-3.6-1.6-.5-3.1-.1-2.3.6,1.5,1.3-.5,2.8,2,4v1.5c-.4,2.6-7,4.2-6.1,7-3.6.8-6.8.9-9.1-.9-.7-.5-2.8-1.4-3.5-.4C13.7,89.9,9.1,89,5,89L1.3,85.5A2.07,2.07,0,0,0,0,84.4v5.7H1000V0Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'singlewave' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 99" preserveAspectRatio="none"><path d="M768.06,59.54C687,48.21,607.41,28.42,526.35,17.15,347.45-7.73,155.24,13.87.07,99H1000V68.11A1149.19,1149.19,0,0,1,768.06,59.54Z"></path></svg>';
		break;
		case 'multislope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none"><path d="M0,22.3V0H1000V100Z" transform="translate(0 0)" style="opacity:0.66"></path><path d="M0,6V0H1000V100Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'slope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 94" preserveAspectRatio="none"><polygon points="0 94 1000 94 0 0 0 94"></polygon></svg>';
		break;
		case 'waves3' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 84.94" preserveAspectRatio="none"><path d="M0,0V72.94c14.46,5.89,32.38,10.5,54.52.26,110.25-51,120.51,23.71,192.6-4.3,144.73-56.23,154.37,49.44,246.71,4.64C637,4.05,622.19,124.16,757.29,66.21c93-39.91,108.38,54.92,242.71-8.25V0Z" style="fill-rule:evenodd;opacity:0.33"></path><path d="M0,0V52.83c131.11,59.9,147-32.91,239.24,6.65,135.09,58,120.24-62.16,263.46,7.34,92.33,44.8,102-60.88,246.71-4.64,72.1,28,82.35-46.71,192.6,4.3,23.95,11.08,43,4.78,58-1.72V0Z" style="fill-rule:evenodd;opacity:0.66"></path><path d="M0,0V24.26c15.6,6.95,35.77,15.41,61.78,3.38,110.25-51,120.51,23.71,192.6-4.3C399.11-32.89,408.75,72.79,501.08,28,644.3-41.51,629.45,78.6,764.54,20.65,855.87-18.53,872.34,72.12,1000,15.7V0Z" style="fill-rule:evenodd"></path></svg>';
		break;
		case 'drip' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 91.02" preserveAspectRatio="none"><path d="M772,11c-32.4,4-58,9.51-58,9.51C685.3,26.69,659.67,34.32,658,35c-15.34,6.3-25.24,13.11-43,13-27.54-.18-37.37-16.79-56-11-19,5.91-19.53,26.54-35,27-13.47.4-16.5-15.14-36-18-1.32-.19-15.92-2.13-29,6-20.34,12.64-18.82,38.28-28,39-8.62.68-10.8-21.86-26-40-5.44-6.49-24.19-25.34-100-32a429.73,429.73,0,0,0-94,2C165,26.91,96.11,27.3,0,0V91H1000V0C894.78,1.07,813.3,5.92,772,11Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'asymslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none"><polygon points="0 89 741 89 0 0 0 89"></polygon><polygon points="741 89 1000 89 1000 0 741 89"></polygon></svg>';
		break;
		case 'vslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" style="width: 100%; max-width: 100%;"><polygon points="0 89 500 89 0 0 0 89"></polygon><polygon points="500 89 1000 89 1000 0 500 89"></polygon></svg>';
		break;
		case 'multivslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" style="width: 100%; max-width: 100%;"><polygon points="0 89 500 89 0 20 0 89"></polygon><polygon points="500 89 1000 89 1000 20 500 89"></polygon><polygon style="opacity: 0.6;" points="0 20 500 89 0 0 0 89"></polygon><polygon style="opacity: 0.6;" points="500 89 1000 20 1000 0 500 89"></polygon></svg>';
		break;
		case 'multiv3slope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" ><polygon points="0 89 500 89 0 40 0 89"></polygon><polygon points="500 89 1000 89 1000 40 500 89"></polygon><polygon style="opacity: 0.6;" points="0 40 500 89 0 20 0 69"></polygon><polygon style="opacity: 0.6;" points="500 89 1000 20 1000 40 500 89"></polygon><polygon style="opacity: 0.3;" points="0 20 500 89 0 0 0 89" ></polygon><polygon style="opacity: 0.3;" points="500 89 1000 20 1000 0 500 89"></polygon></svg>';
		break;
		case 'triangle' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 100"><polygon points="0 100 1000 100 1000 50 550 50 500 0 450 50 0 50 0 100"></polygon></svg>';
		break;
		case 'trianglesmall' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><polygon points="0 50 1000 50 1000 25 520 25 500 0 480 25 0 25 0 50"></polygon></svg>';
		break;
		case 'triangle3' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><polygon points="0 50 1000 50 1000 25 560 25 540 0 520 25 500 0 480 25 460 0 440 25 0 25 0 50"></polygon></svg>';
		break;
		case 'ellipse' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><path d="M0 50 C 200 0 500 0 1000 50 Z"></path></svg>';
		break;
		case 'none' :
		default :
			focus.find('.tck-divider-container').remove();
			return;
		break;
	}
	if (! focus.find('.tck-divider1-container').length) focus.prepend('<div class="tck-divider-container tck-divider1-container">' + svgpath + '</div>');

	var divider = focus.find('.tck-divider1-container');

	// position
	if ($ck('#' + prefix + 'position').val() == 'top') {
		divider.removeClass('tck-divider-bottom').addClass('tck-divider-top');
	} else {
		divider.removeClass('tck-divider-top').addClass('tck-divider-bottom');
	}
	// placement
	if ($ck('#' + prefix + 'placement').val() == 'over') {
		divider.removeClass('tck-divider-under').addClass('tck-divider-over');
	} else {
		divider.removeClass('tck-divider-over').addClass('tck-divider-under');
	}

	// flip
	if ($ck('#' + prefix + 'fliphorizontal').val() == '1') {
		divider.addClass('ckflip-horizontal');
	} else {
		divider.removeClass('ckflip-horizontal');
	}
	if ($ck('#' + prefix + 'flipvertical').val() == '1') {
		divider.addClass('ckflip-vertical');
	} else {
		divider.removeClass('ckflip-vertical');
	}

	divider.find('path, polygon').attr('fill', $ck('#' + prefix + 'color').val());
	divider.css('background-color', $ck('#' + prefix + 'bgcolor').val());
	divider.css('height', ckTestUnit($ck('#' + prefix + 'height').val()));
	divider.find('svg').css('width', ckTestUnit($ck('#' + prefix + 'width').val()));
	divider.find('svg').css('max-width', ckTestUnit($ck('#' + prefix + 'width').val()));
	
	} else {
	focus.find('.tck-divider2-container').remove();
	// for the 2nd divider
	switch ($ck('#' + prefix + 'shape').val()) {
		case 'multiclouds' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 86.47" preserveAspectRatio="none"><g style="opacity:0.33"><path d="M823,15.52l.24-.07A27.72,27.72,0,0,0,864.3,30.53a46.9,46.9,0,0,0,51.9,28A55,55,0,0,0,1000,73.07V0H792C795.79,12,809.32,18.85,823,15.52Z"></path><path d="M23.71,83.4A50,50,0,0,0,85.39,48.77v-.05a25.19,25.19,0,0,0,20.89-4.31,32.67,32.67,0,0,0,12.82,7A32.88,32.88,0,0,0,154.31,0H0V68.64A49.74,49.74,0,0,0,23.71,83.4Z"></path></g><g style="opacity:0.66"><path d="M499.63,19.13h.08a8.91,8.91,0,0,0,12.64,6.15A15.07,15.07,0,0,0,528,35.9a17.67,17.67,0,0,0,33.67-9.55v0A8.9,8.9,0,0,0,567.86,22a11.61,11.61,0,0,0,7.48-22H503.08a11.65,11.65,0,0,0-1.71,4.21,9.2,9.2,0,0,0-3.85-.28c-4.65.65-8,4.58-7.37,8.77S495,19.78,499.63,19.13Z"></path><path d="M631.55,20.67c1,7.6,8.68,12.87,17.22,11.78a16.35,16.35,0,0,0,11.45-6.74,16.34,16.34,0,0,0,7.07,2.14A10.86,10.86,0,0,0,686.86,35a10.82,10.82,0,0,0,8.1-1c1.68,6.83,9,11.4,17,10.38a16,16,0,0,0,12.48-8.49,19.56,19.56,0,0,0,10.37,1.45,19.24,19.24,0,0,0,11.72-5.89,10.85,10.85,0,0,0,17.33-.92A10.81,10.81,0,0,0,776,31.2a17.64,17.64,0,0,0,3.38,1,18.52,18.52,0,0,0,16.52,6A18.82,18.82,0,0,0,809.34,30c2.67,10,12.75,17.44,24.8,17.44,9.38,0,17.57-4.5,22-11.2a32,32,0,0,0,16.53,4.5,31.47,31.47,0,0,0,20.23-7.14,17.75,17.75,0,0,0,28.32,2.09,17.74,17.74,0,0,0,22.71,1.75c4.13,10.05,15,17.22,27.72,17.22,13.43,0,24.75-8,28.33-18.88V0H599.32C607.84,23.13,631.55,20.67,631.55,20.67Z"></path><path d="M.74,30.73c0,12.33,11.21,22.33,25.08,22.36,10.84,0,20.08-6.07,23.61-14.62A15.09,15.09,0,0,0,68.74,37a15.1,15.1,0,0,0,24.1-1.74,26.76,26.76,0,0,0,17.2,6.1,27.24,27.24,0,0,0,14.07-3.81,22.33,22.33,0,0,0,18.71,9.56c11.24,0,20.49-7.56,21.62-17.28a14.92,14.92,0,0,0,10.72.18c3.29,7.35,12.1,11.63,21.28,9.81a20.31,20.31,0,0,0,13.62-9.33A20.31,20.31,0,0,0,219,32.56a13.49,13.49,0,0,0,24.86,7.25,13.43,13.43,0,0,0,10-1.91c2.66,8.32,12.06,13.37,21.9,11.42a19.93,19.93,0,0,0,14.75-11.58,24.3,24.3,0,0,0,13,.92,23.88,23.88,0,0,0,14-8.3,13.47,13.47,0,0,0,21.4-2.61,13.46,13.46,0,0,0,17.17-2c4.56,6.88,13.69,10.63,23.18,8.76,12.14-2.4,20.26-13.09,18.13-23.88A73.93,73.93,0,0,0,400.48,0H0V29.49C.24,29.91.48,30.32.74,30.73Z"></path></g><path d="M16.3,13.9c10.2,2.5,20.3-1.1,25.5-8.3a14.66,14.66,0,0,0,18.5,3A14.6,14.6,0,0,0,80,14.9a13.14,13.14,0,0,0,3.4-2.4,25.71,25.71,0,0,0,14.8,9.7,26,26,0,0,0,14.1-.4,21.75,21.75,0,0,0,15.4,13.3c10.6,2.6,21-2.4,24.3-11.3a15,15,0,0,0,10.7,2.6,17.69,17.69,0,0,0,1.6,2.2,14.69,14.69,0,0,0,17.6,3.5,7.46,7.46,0,0,0,1.2-.7,14.54,14.54,0,0,0,6.4-8.9,12.61,12.61,0,0,0,.4-2.8,20.63,20.63,0,0,0,9.8-1.8,11.35,11.35,0,0,0,1.5,2.3A22.35,22.35,0,0,0,214,28.6c11.2,2.8,22.4-3.1,24.8-13.1a24.63,24.63,0,0,0,16.3,11.6c9.8,2.1,19.4-1.7,24.2-8.7a14,14,0,0,0,17.8,2.4,14.07,14.07,0,0,0,19.1,5.4,12.25,12.25,0,0,0,3.1-2.4,22.5,22.5,0,0,0,5.8,5.3,25.42,25.42,0,0,0,16.1,4,30.38,30.38,0,0,0,6-1.2c.2.4.4.9.6,1.3a20.81,20.81,0,0,0,14.6,11c10.2,2.2,20-2.9,22.9-11.5a13.84,13.84,0,0,0,10.3,2.1,14,14,0,0,0,19.3,4.6,14.17,14.17,0,0,0,6.7-11.8,20,20,0,0,0,9.3-2,21.31,21.31,0,0,0,14,9.9c10.6,2.3,20.9-3.4,23.2-12.7a28.46,28.46,0,0,0,37.2,7.1,23.54,23.54,0,0,0,7.3-7.1,15.79,15.79,0,0,0,20.1,2.1,15.69,15.69,0,0,0,21.6,5.5,13.88,13.88,0,0,0,3.5-2.9,26.66,26.66,0,0,0,9.5,7.2,28.5,28.5,0,0,0,7,2.2,29.16,29.16,0,0,0,15.2-1.3c2.8,6.6,9.3,11.8,17.5,13.3,11.4,2.1,22.2-3.8,25.3-13.4,0-.1.1-.2.1-.4.3.2.7.4,1,.6a15.93,15.93,0,0,0,10.7,1.5,15.79,15.79,0,0,0,28.7-6c.1-.4.1-.8.2-1.2a10.87,10.87,0,0,0,.1-1.8,22.26,22.26,0,0,0,10.4-2.6,25,25,0,0,0,3.9,4.7,24.65,24.65,0,0,0,12.2,6A24.5,24.5,0,0,0,715.3,34a19.09,19.09,0,0,0,10.2-13.4h.5a21.68,21.68,0,0,0,21.1,13,13.67,13.67,0,0,0,1.9-.2,22.1,22.1,0,0,0,13.8-7.7,24.79,24.79,0,0,0,11.9,8.5,25.09,25.09,0,0,0,8.1,1.4,25.86,25.86,0,0,0,18.5-6.7,21.77,21.77,0,0,0,5.2-7.2,15,15,0,0,0,19.1-1,15,15,0,0,0,21,2,13.81,13.81,0,0,0,2.8-3.1A26.84,26.84,0,0,0,866.3,26a27.39,27.39,0,0,0,14-3.4,22.36,22.36,0,0,0,18.3,9.9c11.1.3,20.4-7,21.8-16.6a15,15,0,0,0,11.2.2,15,15,0,0,0,21.1,1,15.16,15.16,0,0,0,4.7-13.5A22.32,22.32,0,0,0,966.3,0H0V1.6A25.29,25.29,0,0,0,16.3,13.9Z"></path><path d="M983.6,7.3A22.61,22.61,0,0,0,1000,1.1V0H967.3A22.52,22.52,0,0,0,983.6,7.3Z"></path></svg>';
		break;
		case 'clouds' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 63.67" preserveAspectRatio="none"><path d="M916.2,58.53a46.9,46.9,0,0,1-46.1-17.89,32,32,0,0,1-14-4.4c-4.43,6.7-12.62,11.2-22,11.2-12,0-22.13-7.44-24.8-17.44a18.82,18.82,0,0,1-13.44,8.2,18.51,18.51,0,0,1-12.45-2.59h-.65a25.09,25.09,0,0,1-8.1-1.4,24.79,24.79,0,0,1-3.52-1.48,10.8,10.8,0,0,1-7.32-2.19,10.84,10.84,0,0,1-15.13,2.91,13.67,13.67,0,0,1-1.63.16,21.69,21.69,0,0,1-2.93,0,19.23,19.23,0,0,1-9.36,3.78,19.56,19.56,0,0,1-10.37-1.45A16,16,0,0,1,712,44.38c-7.56,1-14.51-3.07-16.67-9.28q-.71-.27-1.41-.58a10.82,10.82,0,0,1-7,.48,10.85,10.85,0,0,1-16.07,1.54,15.75,15.75,0,0,1-26.69.66,15.93,15.93,0,0,1-10.7-1.5c-.3-.2-.7-.4-1-.6,0,.2-.1.3-.1.4C629.2,45.1,618.4,51,607,48.9c-8.2-1.5-14.7-6.7-17.5-13.3a29.16,29.16,0,0,1-15.2,1.3,28.5,28.5,0,0,1-7-2.2,26.65,26.65,0,0,1-5.65-3.46A17.66,17.66,0,0,1,528,35.9a15.07,15.07,0,0,1-15.65-10.62,8.91,8.91,0,0,1-2.07.72L510,26a23.53,23.53,0,0,1-4.73,3.86,28.46,28.46,0,0,1-37.2-7.1c-2.3,9.3-12.6,15-23.2,12.7a21.31,21.31,0,0,1-14-9.9,20,20,0,0,1-9.3,2,14.17,14.17,0,0,1-6.7,11.8l-.05,0A14,14,0,0,1,395.6,34.8a13.84,13.84,0,0,1-10.3-2.1c-2.9,8.6-12.7,13.7-22.9,11.5a20.81,20.81,0,0,1-14.6-11c-.2-.4-.4-.9-.6-1.3a30.38,30.38,0,0,1-6,1.2,25.39,25.39,0,0,1-7.23-.41,13.46,13.46,0,0,1-16.46-2.33,23.88,23.88,0,0,1-14,8.3,24.3,24.3,0,0,1-13-.92,19.93,19.93,0,0,1-14.75,11.58c-9.84,2-19.24-3.1-21.9-11.42a13.43,13.43,0,0,1-10,1.91A13.49,13.49,0,0,1,219,32.56a20.31,20.31,0,0,1-8.94-2.07,20.31,20.31,0,0,1-13.62,9.33c-7.6,1.51-14.95-1.18-19.11-6.32a14.7,14.7,0,0,1-11.15-3.1,14.89,14.89,0,0,1-1.74-.57c-1,8.55-8.28,15.43-17.67,17a32.85,32.85,0,0,1-40.49-2.38,25.19,25.19,0,0,1-20.89,4.31v.09A50,50,0,0,1,0,68.64V86.47H1000V73.07a55,55,0,0,1-83.8-14.54Z" transform="translate(0 -22.8)"></path></svg>';
		break;
		case 'papertorn' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 80" preserveAspectRatio="none"><path d="M0,0V71.07l.22.05c2.83,1,7.45-4.57,7.45-4.57s13.36,6.34,14.9,6.6S30,76.45,30,76.45L36.7,71.5s5.4,6,8,4.95,16.19-8.88,17.73-3.55S64.2,80,65,80s5.4-5.59,6.42-5.59,11,2.79,11.82,2.79,7.71-5.84,9.25-6.6,18.24.51,22.1,2.66,14.13.13,19.79,0,25.18,1.9,25.18,1.9l8.48-1.9s0-5.46,1.8-5.2,9.25.51,9.25.51L180.34,65s20.81,2,22.1,2,2.31-3.81,4.37-3.81,14.13,3.81,15.42,3.81,9.25-3.55,11.56-3.81,8.48,5.08,10.28,5.58,55-6.6,55-6.6-.26-5.33,4.88-3.55,15.16,1.27,19.53,2,3.34,6.34,7.71,2.54,5.65-7.36,8.22-6.09,10.28,2.28,11,2.28,4.37-8.12,7.19-6.6,21.59,12.5,30.06,13.48,13.1-10.44,13.1-10.44l13.1,2.54s7.71,10.15,16.19,11.17,11,6.34,19.27,3.55,17.73-9.39,20-8.38,17.47-6.6,18.24-6.85,8.74.76,16.44.25,9.51-5.52,9.51-5.52,25.69-1.08,28.78,1.21,3.6,4.31,6.68,4.31,12.33-5.84,22.35-3.55,26,6.34,27.49,7.11,10.28-5.58,10.28-5.58,5.14,4.57,6.42,5.84,6.17.76,9.25,0,3.85-9.14,10-5.08,20.3-5.08,25.44,1S667,64,667,64s6.68-11.42,14.39-9.9S710.16,66.2,710.16,66.2l6.42-5.49,27.24-1.27s-1.28-7.11,6.17-5.33,10-.89,11-1.71,5.14-3.49,9,0,25.44,8.31,32.89,8.31,15.93-6.35,22.61-4.57,13.36-1.52,14.39-2-.77-4.65,6.42-3.47,19-.76,20.58-.25,6.17-.76,11.31-1.78,6.34-11.63,12.25-4.27,8.68,5.28,11.51,6.74,7.45,1.33,9.25,0-1.54-7.93,7.19-5.39,4.17,3.48,10.08,3,14.13,4.06,14.13,4.06,10.79-2,13.11-2.28,9.25-4.57,12.59-2.79,6.17,1.52,9,2.28,10-.51,11.82-1.78,2.57-6.35,7.71-3.55a11.91,11.91,0,0,1,3.14,2.18V0Z" style="opacity:0.66"></path><path d="M0,0V59.17c4.84-3,4.08,1,5.36-.23s0,0,2.57-1.27,3.08.51,7.19,1,2.83,2.54,2.83,2.54,8.74,5.08,10.28,4.57,4.88-9.14,4.37-10.15S40,61.22,40,61.22l4.37,3.3s9.76,2,11,1a59.11,59.11,0,0,1,8-4.57c1.8-.76,4.11,2.28,6.68,2.79s8.74,3.81,8.74,3.81S90.92,60.71,94,60.21s16.7,3.55,17.47,2,11.82-3,13.1-2.79,8.48,10.91,8.48,10.91l30.83-.51s6.68-6.09,7.45-7.61.26-1.78.26-1.78,9-4.57,10-4.57S193.18,61,193.18,61s10.54-4.06,14.39-5.08,6.68,1.52,12.85-2,19.79-2.79,20.56-3.3,7.45-6.34,12.85-9.39,11.31.76,13.1.76,7.71,5.33,10.79,4.57,10.28-5.33,13.62-5.33,2.83,2.28,10.28,1.78,5.91.51,12.59,4.32,8-2.29,12.85-3.55,1.8.25,4.63-.51a19,19,0,0,1,5.65-.76c1.29,0,2.57,1.52,8.74,3.55s5.91-.76,9.25-1.78,8.22-3.3,18.76-10.15,2.57,5.33,6.94,6.85,22.87,3.55,24.41,2,4.37-3,7.2-4.57,2.82-.51,3.59-.51,9,2.54,11.31,4.06,3.85,4.57,6.17,4.57,4.62-2.54,11-3.55-.26,4.82,0,5.58,2.06,0,5.4-.25,4.88-2.79,9.76-2.79,5.14,3.3,8.48,4.06,2.83,0,10.54-3.81,6.68-1.78,14.9-3.55,22.61,6.85,24.41,6.09,4.88-1.27,11.3-2.54,11.56,3,16.19,5.58,5.14-1.52,8.74-5.08,12.08.25,14.9.25,9.25-.25,13.36-.51,5.14-3,13.88-5.08,8,4.57,14.65,3.55,14.13-1.27,28-5.08,6.42,3,10.79,5.58,9,1.78,11.56,1.52S676,39.65,679.84,36.35s9.51,4.31,16.19,8.12,9.25,3.81,14.13,1.78,9.51-4.82,14.9-7.87,5.4,5.84,10,2.79,15.42.76,17.21-.25,8.48.76,15.42-1,1.8,2,7.45,6.85,3.08-2.29,15.42,1,28.52-2.29,32.89-3,4.88,5.33,9.25,5.84,5.4-4.82,9.76-7.87,17-.76,20.56-2a17.22,17.22,0,0,0,6.17-4.06s13.36,0,15.16-1.52,10.28-.76,13.36-.76,26,4.57,35.2,2.79,11.82-7.62,16.44-10.91,23.13,2.54,30.32,2.54,20.3-2.54,20.3-2.54V0Z"></path></svg>';
		break;
		case 'bridge' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 283 20.99" preserveAspectRatio="none"><path d="M81.66,18.4C67.67,6.89,32.57.93,18.57,20.33,14.2,14.75,6.34,11.48,0,9.75V0H0V21H143.75C134.52,9.95,107.42,1.35,81.66,18.4Z" transform="translate(0.02 -0.01)"></path><path d="M283,0V11c-3.82.72-6.67,2.21-13.46,9.21-15.71-21-52.38-5.64-55,.58-12.95-12.92-53.74-17.6-70.74.21H283V0Z" transform="translate(0.02 -0.01)"></path></svg>';
		break;
		case 'rockymoutain' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 90.1" preserveAspectRatio="none"><path d="M999.2,0V89.3c-2.1-.4-3.8.3-5.7.4,0,.1.1.2.1.3l-.3-.1a4.27,4.27,0,0,0-2.5-.1l-.1.1c-3.1-.8-2.6-3.4-8.3-3v-.5c-5.2-.2-10.4-.7-15.7-.5-5-.3-10.3-1.6-15.1-.8-5.6.9-10.9.7-16.4.8a29.31,29.31,0,0,0-7.2-1.2c-6.4-.3-8.2-2-8.6-4.3,0-.5-.2-1.1,1.2-1.5,3.9.1,5.7-1.1,8.4-2.1-4.9-1-9,.5-13.2.1h-2.4c-4.4-.6-.5-2.7-3.7-3.5a40,40,0,0,1-8.4-1.5c.3-2.6-3.8-4.2-8.5-5.5,0-1.1-.4-2.3,3.6-2.5h1.3l4.8-.5c3.3-.4,6.6-.9,9.7-1.5,1.8-.4,4-.6,4.9-1.5a.52.52,0,0,0,.4-.2c.1-.1,0-.2-.4-.3-2.2,0-4.4.1-6.6,0-4.4-.2-8.3,1.4-12.8.5a46.46,46.46,0,0,0-9.7-2l-2.4-1.5c.4-.1.4-.3,0-.5.7-2.2,3.8-3.3,9-3.5a6.54,6.54,0,0,0,3.1-.5c.4-2-2.7-1.1-4.9-1-2.5.8-4.9.2-7.3,0h-1.2c-3.5-2.3,2.3-3,4.6-4.1,4.6-2.2,4.5-2.8-2.1-4v-.5a257.26,257.26,0,0,0-29.1,1l-31.5,3.5a58.57,58.57,0,0,1-14.5,1.5c-1.2.7-3.1.4-4.8.5-1.3.7-3.2.4-4.9.5v.5c-7.2.4-14,1.5-20.7,2.5H779c-1.8-.7-4.2-1.2-5.3-2-5.1-3.7-13.8-5.8-21.2-8.5.1,0,.2-.1.3-.1.3-.3.2-.6-.5-.9-3.2-1.8-7.5-3.2-10.9-5l-1.2-.4a58.37,58.37,0,0,0-17-4.4,16.59,16.59,0,0,1-4.5-1.2c-8.4-2.7-15.5-6.4-27.9-5.9-1.8.1-3.2-.6-5-.8h-.2l-.1-.7a8.16,8.16,0,0,1-3.6-1.5c-8.7-2-18.3-3.1-27.8-4.1l-3.6-1-1.3-1c-5.8-.4-11.6-1.2-17,.5l-10.8.5a8.75,8.75,0,0,0-1.6-.2c-13.2-1.8-25.9-2.1-37.3,2.2-13.8.9-26.7,2.5-36.3,7.1l-2.6,2.5c-5.1,1.4-11.3,1.4-16.9,2-14.1.2-28.4-.3-41.8,2.2-.2,0-.4.1-.6.1-3.5.3-6,0-6-1.8,1.8-.8,1.7-1.7,0-2.5-1.5-2.3-6.3-4-6.2-6.5a16.84,16.84,0,0,1-4.8-2,42.72,42.72,0,0,0-21.8,2.5c-5.5.9-9,3.1-14.5,4l-2.5,1.4-4.8.5a13.86,13.86,0,0,1-5.3,1l-20,1.5a1.71,1.71,0,0,0-1.4,0c-6.9.5-12.2,3-19.9,2.9,3.2-.6,3-2.1,5.4-2.9.6-2.1.6-2.1-1.2-2.5-3.9.2-5.9,2.8-10.9,1.5-.4-.5-.5-1.2-2.4-.9h-.1c-1.3-1.4-2.2-3-7.5-2.2-.8.2-2.3-.5-3.4-.8,1.9-.8,3.3-1.7,4.9-2.5,2.5-.2,4.8-.5,6.1-1.5-.8-1.4-2.9-.7-4.8-.5a63.58,63.58,0,0,1-14.5,1c-1.5-.5-1-1,0-1.5l1.2-.5a11.6,11.6,0,0,0,2.4-2c2.7-.3,6.2.1,7.3-1.5h1.2c.7-.6,2.7-1.1,1.2-2l-6.1-1c-1.6.5-3.2-.7-4.8,0-6.7,1.1-13,2.7-20.6,2.5-.7.3-2,.2-2.6.5-2.4.2-5-.4-7.1.5-1.6,0-2.4.4-2.5,1l-2.3.5a36.43,36.43,0,0,0-13.4,3.5c-3.5.6-5.7,2.1-9.7,2.5-1.3,1.1-4.1,1.3-6.2,1.8-3.3.8-7.5,1.1-9.5,2.7-2.7-.1-3.5,1-4.9,1.6-4,1.8-9.8,3-12.1,5.5h-4.8c-3.4-1-7.3-.3-10.9-.5-1.9-1.3-1.6-3.6-7.9-3-1.5.1-4.2.5-4.7-.5s2.6-1.1,4.1-1.5c1.1-.4,3-.8,3-1.2.2-2.5,4.4-3.9,8.6-5.6-2.2-.3-5.1.3-6.4-.7-1.1-.9,3.7-.3,1.9-1.6-8.8,1.2-15.3,4-22.7,6.1l-3.7,1c-3.4.8-7.6,0-10.9,1-3.4.3-5.4,1.1-6.1,2.5-4.1,1.8-7.8,3.8-12.5,5.3A30.53,30.53,0,0,0,175.5,44c-1.9.4-3.5,1-3.6,2-2.2.6-4.5,1.2-4.8,2.5-3,.6-4,2-6,3-2,.4-3.6,1-3.7,2-3.3,1-4.3,2.4-4.2,4.1.1,2.5-3.7,4.7-9.3,5.5-3.5.5-7.1.9-10.7,1.4-4.5.6-9.4.5-13.6,1.6a8.07,8.07,0,0,1-5.7-.6c-1.6-.9-2.9-2.3-5.8-1.8s-2.7,2.1-2.7,3.3v1c-.1,0-.2.1-.3.2-1.6,1-2.4,2.4-6.6,2.3-3.9-.1-4.9-1.4-6.4-2.5,0-1.1-.4-2.1-3.3-2.8-.1,1.3-1.2,2.4.9,3.3-.1,1.4-3.8,1.9-4.9,3a4,4,0,0,0-2.4.5c-2.9.7-5.2.7-6.2-.9-.7-1.2-2.6-1.9-5.4-2.2-2.4,1.6-.6,3.7-4.1,5.1-6.5,0-4.6,2-4.8,3.4-.3,2.3-1.2,2.6-5.8,1.4-4-1.1-5-.3-5.1,1.2v4.8c-3.7-2.1-7.9-2.6-10.9-3.8l-1.2-2c.2-1.6-1.7-2.7-4.5-3.6-1.6-.5-3.1-.1-2.3.6,1.5,1.3-.5,2.8,2,4v1.5c-.4,2.6-7,4.2-6.1,7-3.6.8-6.8.9-9.1-.9-.7-.5-2.8-1.4-3.5-.4C13.7,89.9,9.1,89,5,89L1.3,85.5A2.07,2.07,0,0,0,0,84.4v5.7H1000V0Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'singlewave' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 99" preserveAspectRatio="none"><path d="M768.06,59.54C687,48.21,607.41,28.42,526.35,17.15,347.45-7.73,155.24,13.87.07,99H1000V68.11A1149.19,1149.19,0,0,1,768.06,59.54Z"></path></svg>';
		break;
		case 'multislope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none"><path d="M0,22.3V0H1000V100Z" transform="translate(0 0)" style="opacity:0.66"></path><path d="M0,6V0H1000V100Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'slope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 94" preserveAspectRatio="none"><polygon points="0 94 1000 94 0 0 0 94"></polygon></svg>';
		break;
		case 'waves3' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 84.94" preserveAspectRatio="none"><path d="M0,0V72.94c14.46,5.89,32.38,10.5,54.52.26,110.25-51,120.51,23.71,192.6-4.3,144.73-56.23,154.37,49.44,246.71,4.64C637,4.05,622.19,124.16,757.29,66.21c93-39.91,108.38,54.92,242.71-8.25V0Z" style="fill-rule:evenodd;opacity:0.33"></path><path d="M0,0V52.83c131.11,59.9,147-32.91,239.24,6.65,135.09,58,120.24-62.16,263.46,7.34,92.33,44.8,102-60.88,246.71-4.64,72.1,28,82.35-46.71,192.6,4.3,23.95,11.08,43,4.78,58-1.72V0Z" style="fill-rule:evenodd;opacity:0.66"></path><path d="M0,0V24.26c15.6,6.95,35.77,15.41,61.78,3.38,110.25-51,120.51,23.71,192.6-4.3C399.11-32.89,408.75,72.79,501.08,28,644.3-41.51,629.45,78.6,764.54,20.65,855.87-18.53,872.34,72.12,1000,15.7V0Z" style="fill-rule:evenodd"></path></svg>';
		break;
		case 'drip' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 91.02" preserveAspectRatio="none"><path d="M772,11c-32.4,4-58,9.51-58,9.51C685.3,26.69,659.67,34.32,658,35c-15.34,6.3-25.24,13.11-43,13-27.54-.18-37.37-16.79-56-11-19,5.91-19.53,26.54-35,27-13.47.4-16.5-15.14-36-18-1.32-.19-15.92-2.13-29,6-20.34,12.64-18.82,38.28-28,39-8.62.68-10.8-21.86-26-40-5.44-6.49-24.19-25.34-100-32a429.73,429.73,0,0,0-94,2C165,26.91,96.11,27.3,0,0V91H1000V0C894.78,1.07,813.3,5.92,772,11Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'asymslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none"><polygon points="0 89 741 89 0 0 0 89"></polygon><polygon points="741 89 1000 89 1000 0 741 89"></polygon></svg>';
		break;
		case 'vslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" style="width: 100%; max-width: 100%;"><polygon points="0 89 500 89 0 0 0 89"></polygon><polygon points="500 89 1000 89 1000 0 500 89"></polygon></svg>';
		break;
		case 'multivslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" style="width: 100%; max-width: 100%;"><polygon points="0 89 500 89 0 20 0 89"></polygon><polygon points="500 89 1000 89 1000 20 500 89"></polygon><polygon style="opacity: 0.6;" points="0 20 500 89 0 0 0 89"></polygon><polygon style="opacity: 0.6;" points="500 89 1000 20 1000 0 500 89"></polygon></svg>';
		break;
		case 'multiv3slope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" ><polygon points="0 89 500 89 0 40 0 89"></polygon><polygon points="500 89 1000 89 1000 40 500 89"></polygon><polygon style="opacity: 0.6;" points="0 40 500 89 0 20 0 69"></polygon><polygon style="opacity: 0.6;" points="500 89 1000 20 1000 40 500 89"></polygon><polygon style="opacity: 0.3;" points="0 20 500 89 0 0 0 89" ></polygon><polygon style="opacity: 0.3;" points="500 89 1000 20 1000 0 500 89"></polygon></svg>';
		break;
		case 'triangle' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 100"><polygon points="0 100 1000 100 1000 50 550 50 500 0 450 50 0 50 0 100"></polygon></svg>';
		break;
		case 'trianglesmall' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><polygon points="0 50 1000 50 1000 25 520 25 500 0 480 25 0 25 0 50"></polygon></svg>';
		break;
		case 'triangle3' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><polygon points="0 50 1000 50 1000 25 560 25 540 0 520 25 500 0 480 25 460 0 440 25 0 25 0 50"></polygon></svg>';
		break;
		case 'ellipse' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><path d="M0 50 C 200 0 500 0 1000 50 Z"></path></svg>';
		break;
		case 'none' :
		default :
			focus.find('.tck-divider2-container').remove();
			return;
		break;
	}
	
	if ($ck('#divider-2shape').val()) {
		if (! focus.find('.tck-divider2-container').length) focus.prepend('<div class="tck-divider-container tck-divider2-container">' + svgpath + '</div>');
	} else {
		return;
	}
	var divider2 = focus.find('.tck-divider2-container');

	// position
	if ($ck('#' + prefix + 'position').val() == 'top') {
		divider2.removeClass('tck-divider-bottom').addClass('tck-divider-top');
	} else {
		divider2.removeClass('tck-divider-top').addClass('tck-divider-bottom');
	}
	// placement
	if ($ck('#' + prefix + 'placement').val() == 'over') {
		divider2.removeClass('tck-divider-under').addClass('tck-divider-over');
	} else {
		divider2.removeClass('tck-divider-over').addClass('tck-divider-under');
	}

	// flip
	if ($ck('#' + prefix + 'fliphorizontal').val() == '1') {
		divider2.addClass('ckflip-horizontal');
	} else {
		divider2.removeClass('ckflip-horizontal');
	}
	if ($ck('#' + prefix + 'flipvertical').val() == '1') {
		divider2.addClass('ckflip-vertical');
	} else {
		divider2.removeClass('ckflip-vertical');
	}

	divider2.find('path, polygon').attr('fill', $ck('#' + prefix + 'color').val());
	divider2.css('background-color', $ck('#' + prefix + 'bgcolor').val());
	divider2.css('height', ckTestUnit($ck('#' + prefix + 'height').val()));
	divider2.find('svg').css('width', ckTestUnit($ck('#' + prefix + 'width').val()));
	divider2.find('svg').css('max-width', ckTestUnit($ck('#' + prefix + 'width').val()));
	}
}

function ckShowQuickDataImport() {
	var name = $ck('#name').val();
	CKBox.open({id: 'ckimportquickdata', handler: 'iframe', url: TEMPLATECREATORCK_ADMIN_URL + '&view=quickdata&name=' + name + '&tmpl=component'});
}

function ckInitRangeInputs() {
	$ck('.ckrangeinputupdate').on('input', function() {
		// var $textfield = $ck('label[for="' + this.id + '"]');
		// $textfield.text(this.value);
		ckSetRrangeInputText(this);
		$ck(this).trigger('change');
	});
}

function ckSetRrangeInputText(field) {
	var $textfield = $ck(field).next();
	$textfield.text(field.value);
	$textfield.val(field.value);
}

function ckUpdateRangeInputs(field) {
	var $field = $ck(field);
	var rangeField = $field.prev('.ckrangeinputupdate');
	rangeField.val($field.val());
	rangeField.trigger('change');
}

/*-------------------------------
 * ---		Copy paste styles ---
 --------------------------------*/

function ckCopyStyles(blocid) {
	var item = ckGetObjectAnyway(blocid);

//	var props = ckGetPropsForBloc(item.attr('id'));
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	if (! styleswrapper.find('> .ckprops').length) return;

	var props =  styleswrapper.find('> .ckprops').clone();
	var style = ckGetStyleForBloc(item.attr('id'));
	TEMPLATECK.CLIPBOARD = {"ID" : item.attr('id'), "PROPS" : props, "STYLE" : style.html()};

//	alert(TCK.TexTCK.Text._('CK_COPYTOCLIPBOARD', 'Current styles copied to clipboard !'));
}

function ckPasteStyles(blocid) {
	var item = ckGetObjectAnyway(blocid);

	if (TEMPLATECK.CLIPBOARD) {
		if (!confirm(TCK.Text._('CK_COPYFROMCLIPBOARD', 'Apply styles from Clipboard ? This will replace all current existing styles.')))
			return;
		var styleswrapper = ckGetStylesWrapperForBlock(blocid)
		styleswrapper.find('> .ckprops').remove();
		styleswrapper.prepend(TEMPLATECK.CLIPBOARD.PROPS);
//		item.find('> .ckstyle').empty().append(TEMPLATECK.CLIPBOARD.STYLE);
		ckSetStyleForBloc(blocid, TEMPLATECK.CLIPBOARD.STYLE);
//		var re = new RegExp(TEMPLATECK.CLIPBOARD.ID, 'g');
		ckReplaceStyleId(styleswrapper, TEMPLATECK.CLIPBOARD.ID, item.attr('id'));
//		if (item.find('> .ckstyle').length) item.find('> .ckstyle').html(item.find('> .ckstyle').html().replace(re,item.attr('id')));
	} else {
		alert(TCK.Text._('CK_CLIPBOARDEMPTY', 'Clipboard is empty'));
	}
}

function ckGetObjectAnyway(foobar) {
	if (! (foobar instanceof $ck)) {
		if (! foobar.id && (typeof foobar == 'string' && foobar.indexOf('#') == -1)) {
			foobar = $ck('#' + foobar);
		} else {
			foobar = $ck(foobar);
		}
	}
	return foobar;
}



/*-------------------------------------
--- 	update for new version 5 	---
---------------------------------------*/



function ckPreviewFillLayoutInterface() {
	var frame = $ck('#body');
	var layoutwrap = $ck('#ckPreviewLayout');
	layoutwrap.empty();
	var wrappers = frame.find('> .ckbloc');
	var html = '';
	wrappers.each(function() {
		html += '<ul class="ckPreviewLayout_wrapper">' 
				+ ckPreviewLayoutExploreDom(this)
				+ '</ul>';
	});
	layoutwrap.append(html);
	ckEnablePreviewLayoutTogglers();
	ckEnablePreviewLayoutSortable();
	ckEnablePreviewLayoutOptions();
	ckEnablePreviewLayoutFocus();
	ckPreviewLayoutEnableOpenAll();
	ckPreviewLayoutEnableCloseAll();
}

function ckPreviewLayoutExploreDom(item) {
	if ($ck(item).attr('isdisabled') == 'true') return '';

	var children = $ck(item).find('> .inner > .ckbloc, > .inner > .ckrowcontainer, > .ckbloc, > .ckrowcontainer');
	var html = '', classes = '', toggleBtn = '', itemIcon = '', dataType = '', liclass = '';
	var dataAttrs = 'data-id="' + item.id + '"';
	// only for parent items
	if (children.length) {
//		dataAttrs += ' data-children="1"';
		classes += ' opened';
		toggleBtn += '<span class="ckPreviewLayoutItemToggler"><i class="fack fack-chevron-down"></i></span>';
	}
	// item icons
	if (item.className.indexOf('wrapper') != -1) {
		itemIcon = '<i class="fack fack-window-maximize"></i>';
		dataType = 'wrapper';
	} else if (item.className.indexOf('ckrow') != -1
			&& item.className.indexOf('ckrowcontainer') == -1) {
		itemIcon = '<i class="fack fack-columns"></i>';
		dataType = 'row';
	} else if (item.className.indexOf('flexiblemodules') != -1) {
		itemIcon = '<i class="fack fack-cubes"></i>';
		dataType = 'flexiblemodules';
	} else if (item.className.indexOf('singlemodule') != -1
			|| item.className.indexOf('flexiblemodule') != -1
			|| item.className.indexOf('column1') != -1
			|| item.className.indexOf('column2') != -1
			&& item.className.indexOf('flexiblemodules') == -1
			) {
		itemIcon = '<i class="fack fack-cube"></i>';
		dataType = 'singlemodule';
		liclass = 'ckbloc';
	} else if (item.className.indexOf('horiznav') != -1) {
		itemIcon = '<i class="fack fack-ellipsis-h"></i>';
		dataType = 'module-horizmenu';
		liclass = 'ckbloc';
	} else if (item.className.indexOf('module') != -1) {
		if (item.getAttribute('data-element') == 'mod_menu') {
			itemIcon = '<i class="fack fack-navicon"></i>';
			dataType = 'module-menu';
			liclass = 'ckbloc';
		} else if (item.getAttribute('data-element') == 'mod_slideshowck') {
			itemIcon = '<i class="fack fack-film"></i>';
			dataType = 'module-slideshowck';
			liclass = 'ckbloc';
		}
	} else if (item.className.indexOf('custombloc') != -1) {
		itemIcon = '<i class="fack fack-file-text-o"></i>';
		dataType = 'custombloc';
		liclass = 'ckbloc';
	} else if (item.className.indexOf('emptybloc') != -1) {
		itemIcon = '<i class="fack fack-question"></i>';
		dataType = 'emptybloc';
		liclass = 'ckbloc';
	} else if (item.className.indexOf('logobloc') != -1) {
		itemIcon = '<i class="fack fack-image"></i>';
		dataType = 'logo';
		liclass = 'ckbloc';
	}

	var optionBtn = '<span class="ckPreviewLayoutItemOptions"><i class="fack fack-cog"></i></span>';
	liclass = liclass ? ' class="' + liclass + '"' : '';
	if ($ck(item).attr('ishidden') != 'true' && $ck(item).attr('id')) {
		html += '<li' + liclass + ' data-type="' + dataType + '"><div class="ckPreviewLayoutItem' + classes + '" ' + dataAttrs +'>'
			+ itemIcon
			+ '<span class="ckPreviewLayoutItemName">' + item.id + '</span>'
			+ optionBtn
			+ toggleBtn
			+ '</div>';
	}
	html += '<ul>';
	if (children.length) {
		children.each(function() {
		html += '' 
	//				+ getPreviewLayoutItemHtml(this) 
					+ ckPreviewLayoutExploreDom(this)
					+ '';
		});
	}
	html += '</ul><li>' 
	return html;
}

function ckEnablePreviewLayoutTogglers() {
	$ck('#ckPreviewLayout .ckPreviewLayoutItemToggler').each(function() {
		var $this = $ck(this);
		var $parent =  $ck(this).parent();
		var $childCont = $parent.find('+ ul');
		$this.click(function() {
			if ($parent.hasClass('opened')) {
				$childCont.slideUp('fast');
				$parent.removeClass('opened');
				$parent.addClass('closed');
			} else {
				$childCont.slideDown('fast');
				$parent.addClass('opened');
				$parent.removeClass('closed');
			}
		});
	})
	
}

function ckPreviewLayoutEnableOpenAll() {
	$ck('#ckPreviewLayoutOpenAll').click(function() {
		$ck('#ckPreviewLayout ul ul').slideDown('fast').addClass('opened');
	});
}

function ckPreviewLayoutEnableCloseAll() {
	$ck('#ckPreviewLayoutCloseAll').click(function() {
		$ck('#ckPreviewLayout ul ul').slideUp('fast').removeClass('opened');
	});
}

function ckEnablePreviewLayoutSortable() {
	/*return;
	ckInitPreviewLayoutSortable();
//	console.log('virer cette fonction une fois fini');
	return;
	// wrapper, row, column, module
	// un module peut aller n'importe où sauf direct dans row. Il doit aller dans colonne
	$ck('#ckPreviewLayout ul').sortable({
		items: "> li",
		// containment: "parent",
		// axis: "y",
		connectWith: "#ckPreviewLayout ul",
		tolerance: "pointer",
//		handle: "> .editorck .controlMove",
		forceHelperSize: true,
		dropOnEmpty: true,
		forcePlaceholderSize: true,
		placeholder: "ckplaceholder",
		zIndex: 9999,
		sort: function( event, ui ) {

		},
		start: function( event, ui ){

		},
		receive: function( event, ui ) {

		}, 
		stop: function( event, ui ){

		},
		out: function( event, ui ) {
		}
	});*/
}

function ckEnablePreviewLayoutOptions() {
	$ck('#ckPreviewLayout .ckPreviewLayoutItemOptions').on('click', function() {
		var $item = $ck($ck(this).parents('.ckPreviewLayoutItem')[0])
		var id = $item.attr('data-id');
		ckShowEdition(id);
	});
	
}

function ckEnablePreviewLayoutFocus() {
	$ck('#ckPreviewLayout .ckPreviewLayoutItem').on('mouseover', function() {
		var $target = $ck('#body #' + this.getAttribute('data-id'));
		$target.addClass('ckhover');
	}).on('mouseleave', function() {
		var $this = $ck(this);
		if (! $this.hasClass('ckfocus')) {
			var $target = $ck('#body #' + this.getAttribute('data-id'));
			$target.removeClass('ckhover');
		}
	}).on('click', function() {
		var $this = $ck(this);
		var $target = $ck('#body #' + this.getAttribute('data-id'));
		if ($this.hasClass('ckfocus')) {
			$this.removeClass('ckfocus');
			$ck('.ckhover').removeClass('ckhover');
		} else {
			$ck('#ckPreviewLayout .ckfocus').removeClass('ckfocus');
			$ck('.ckhover').removeClass('ckhover');
			$this.addClass('ckfocus');
			$target.addClass('ckhover');
			$ck('html, body').animate( { scrollTop: $target.offset().top - 200, scrollLeft: $target.offset().left - 310 - $ck(document.body).css('margin-left') }, 300);
		}
	});
}

function ckClosePreviewEdition() {
	if (typeof ckBeforeCloseEditionPopup == 'function') { ckBeforeCloseEditionPopup(); } 
	$ck('#ckedition').animate({'left': '150px', 'opacity': 0}, function() { this.style.display = 'none'; }); // note : ckpreviewedition
	$ck('.ckfocus').removeClass('ckfocus');
}

function ckLoadInterface(interfacefile, target) {
	// return if has already been loaded
	if (target.attr('data-loaded') == '1') return;

	// add focus on the body for the general settings
	bloc = $ck('#body');
	bloc.addClass('ckfocus');

	var editionarea = $ck('#ckedition');
	editionarea.empty().fadeIn();

	var myurl = TEMPLATECREATORCK_ADMIN_URL + '&task=interface.load&layout=' + interfacefile +'&' + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			expertmode: $ck('#body').hasClass('expert'),
			joomlaversion: $ck('#joomlaversion').attr('value')
		}
	}).done(function(code) {
		target.find('> .inner').empty().append(code);
		ckFillEdition('body');
//		loadPreviewAreaStyles('#body');
		ckAddEventOnFields(target, 'body');

		// initBulletlist(); // to render the selected bullet style
		target.attr('data-loaded', '1');
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

/* override for the preview feature */
function ckInitOptionsSliders(wrap) {
	wrap = wrap ? wrap : $ck('#ckelementscontainer'); // TODO : erreur wrap
	$ck('.ckinterfaceslider', wrap).hide();
	$ck('.ckinterfacesliderlink', wrap).each(function(i, tab) {
		tab = $ck(tab);
		var $targetTab = $ck('[data-id="' + tab.attr('tab') + '"]');
		tab.click(function() {
			$ck('.ckinterfaceslider', $targetTab.parent()).hide();
			$ck('[data-id="' + tab.attr('tab') + '"]').show();
			wrap.stop().animate({'margin-left': '-=300px'}, 200);
		});
		$ck('.ckinterfacesliderback', wrap).click(function() {
			var sliderback = $ck(this);
			wrap.stop().animate({'margin-left': '+=300px'}, 200, function() {
				$ck(sliderback.parent('.ckinterfaceslider')).hide();
			});
		});
	});
}

function ckInitOptionsSlidersOver() {
	$ck('.ckinterfaceslidercontentover').hide();
	$ck('.ckinterfacesliderlinkover').each(function(i, link) {
		var $link = $ck(link);
		var $targetTab = $ck('#' + $link.attr('tab'));
		$link.click(function() {
			if ($targetTab.hasClass('opened')) {
				ckCloseSliderOverTab()
			} else {
				$link.addClass('active');
				$ck('.ckinterfaceslidercontentover').hide();
				$ck(document.body).append($targetTab);
				$targetTab.show('fast').addClass('opened');
				// $ck(document.body).stop().animate({'margin-left': '257px'});
				$ck(document.body).addClass('ckbodysmall');
			}
		});
		$ck('.ckinterfaceslideroverclose').click(function() {
			ckCloseSliderOverTab(tabid)
		});
	});
}

function ckCloseSliderOverTab() {
	// $ck(document.body).stop().animate({'margin-left': '0'}, 
		// function() {
//			$ck('.ckinterfaceslidercontentover').hide();
		// }
	// );
	$ck(document.body).removeClass('ckbodysmall');
	$ck('.ckinterfaceslidercontentover').hide('fast').removeClass('opened');
	$ck('.ckinterfacesliderlinkover').removeClass('active');
}

function ckActivatePanel(target) {
	$ck('.menuckpanel').removeClass('active');
	$ck('.menuckpanel[data-target="' + target + '"]').addClass('active');
	$ck('.menuckpaneltarget').hide();
	$ck('.menuckpaneltarget[data-target="' + target + '"]').show();
}

function ckSubmitButtonExit() {
	if (! confirm(TCK.Text._('CK_CONFIRM', 'Are you sure ?'))) return;
	window.location.href = TEMPLATECK.URITCK;
}

function ckMoveInfosInPanel() {
	if ($ck('[data-id="tab_page_infos"] > .inner #ckinfospopup').length) return;
	$ck('[data-id="tab_page_infos"] > .inner').append($ck('#ckinfospopup').show());
}

function ckMoveInfosInForm() {
	if ($ck('#adminForm #ckinfospopup').length) return;
	$ck('#adminForm').append($ck('#ckinfospopup'));
}

function ckClosePageSettingsPanel() {
	$ck('#adminForm').append($ck('#ckinfospopup'));
	var target = $ck('.menuckpaneltarget[data-target="settings"]');
	target.find('> .inner').empty();
	if ($ck('.menuckpanel[data-target="settings"]').hasClass('active')) {
		ckActivatePanel('create');
	}
}

function ckQuickStyles() {
	$ck('#ckedition').addClass('ckquickstyle-enabled');
	$ck('#ckedition .inputbox').each(function() {
		var $field = $ck(this);
		// for single field
		var quicktarget = $field.attr('data-quicktarget');
		if (quicktarget) {
			if ($field.val()) {
				$ck('[data-quickid="' + quicktarget + '"]').show();
			} else {
				$ck('[data-quickid="' + quicktarget + '"]').hide();
			}
		}
		// for grouped fields
		var quicktarget = $field.attr('data-quicktargetgroup');
		if (quicktarget) {
			var fields = $ck('[data-quicktargetgroup="' + quicktarget + '"]');
			var hasvalue = false;
			for (var i = 0; i < fields.length; i++) {
				var field = fields[i];
				if (field.tagName.toLowerCase() == 'input') {
					if ($ck(field).val()) hasvalue = true;
				} else if (field.tagName.toLowerCase() == 'select') {
					if ($ck(field).val() != 'default' && $ck(field).val() != '0') hasvalue = true;
				}
			}
			if (hasvalue == true) {
				$ck('[data-quickid="' + quicktarget + '"]').show().attr('data-show', '1');
			} else {
				$ck('[data-quickid="' + quicktarget + '"]').hide().attr('data-show', '0');
			}
		}
	});

	// show/hide parent title
	var quickids = $ck('#ckedition [data-quickid]');
	for (var i = 0; i < quickids.length; i++) {
		var quickid = quickids[i];
		if ($ck(quickid).css('display') == 'block') {
			$ck(quickid).closest('.ckinterfaceslider').attr('data-show', '1');
		}
	}
	$ck('.ckinterfaceslider[data-show="1"]').show();

	// remove the back button event
	$ck('#ckedition .ckinterfacesliderback').off('click');
	// add the back button<div class="ckinterfacesliderback">
	$ck('#ckedition').prepend(
		'<div class="ckinterfacesliderback ckquickstyle-back" onclick="ckRemoveQuickStyles();ckClosePreviewEdition()">'
			+'<button class="ckinterfaceslider-back-button" tabindex="0">'
			+ '</button>'
			+ '<div class="ckinterfaceslidertitle">' + TCK.Text._('CK_QUICK_STYLES') + '</div>'
		+ '</div>'
	);
}

function ckRemoveQuickStyles() {
	$ck('#ckedition').removeClass('ckquickstyle-enabled');
	$ck('[data-quickid]').show();
}

/*-----------------------------------------------------------*/


function ckUpdateShapeDivider(prefix) {
	// prefix is not used anymore
	// automatically update both dividers
	ckCreateShapeDividerNew('divider');
	ckCreateShapeDividerNew('divider-2');
}

function ckCreateShapeDividerNew(prefix) {
	var focus = $ck('#body .ckfocus');
	var flip = $ck('[name="' + prefix + 'flipvertical"]:checked').val();

	switch ($ck('#' + prefix + 'shape').val()) {
		case 'multiclouds' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 86.47" preserveAspectRatio="none"><g style="opacity:0.33"><path d="M823,15.52l.24-.07A27.72,27.72,0,0,0,864.3,30.53a46.9,46.9,0,0,0,51.9,28A55,55,0,0,0,1000,73.07V0H792C795.79,12,809.32,18.85,823,15.52Z"></path><path d="M23.71,83.4A50,50,0,0,0,85.39,48.77v-.05a25.19,25.19,0,0,0,20.89-4.31,32.67,32.67,0,0,0,12.82,7A32.88,32.88,0,0,0,154.31,0H0V68.64A49.74,49.74,0,0,0,23.71,83.4Z"></path></g><g style="opacity:0.66"><path d="M499.63,19.13h.08a8.91,8.91,0,0,0,12.64,6.15A15.07,15.07,0,0,0,528,35.9a17.67,17.67,0,0,0,33.67-9.55v0A8.9,8.9,0,0,0,567.86,22a11.61,11.61,0,0,0,7.48-22H503.08a11.65,11.65,0,0,0-1.71,4.21,9.2,9.2,0,0,0-3.85-.28c-4.65.65-8,4.58-7.37,8.77S495,19.78,499.63,19.13Z"></path><path d="M631.55,20.67c1,7.6,8.68,12.87,17.22,11.78a16.35,16.35,0,0,0,11.45-6.74,16.34,16.34,0,0,0,7.07,2.14A10.86,10.86,0,0,0,686.86,35a10.82,10.82,0,0,0,8.1-1c1.68,6.83,9,11.4,17,10.38a16,16,0,0,0,12.48-8.49,19.56,19.56,0,0,0,10.37,1.45,19.24,19.24,0,0,0,11.72-5.89,10.85,10.85,0,0,0,17.33-.92A10.81,10.81,0,0,0,776,31.2a17.64,17.64,0,0,0,3.38,1,18.52,18.52,0,0,0,16.52,6A18.82,18.82,0,0,0,809.34,30c2.67,10,12.75,17.44,24.8,17.44,9.38,0,17.57-4.5,22-11.2a32,32,0,0,0,16.53,4.5,31.47,31.47,0,0,0,20.23-7.14,17.75,17.75,0,0,0,28.32,2.09,17.74,17.74,0,0,0,22.71,1.75c4.13,10.05,15,17.22,27.72,17.22,13.43,0,24.75-8,28.33-18.88V0H599.32C607.84,23.13,631.55,20.67,631.55,20.67Z"></path><path d="M.74,30.73c0,12.33,11.21,22.33,25.08,22.36,10.84,0,20.08-6.07,23.61-14.62A15.09,15.09,0,0,0,68.74,37a15.1,15.1,0,0,0,24.1-1.74,26.76,26.76,0,0,0,17.2,6.1,27.24,27.24,0,0,0,14.07-3.81,22.33,22.33,0,0,0,18.71,9.56c11.24,0,20.49-7.56,21.62-17.28a14.92,14.92,0,0,0,10.72.18c3.29,7.35,12.1,11.63,21.28,9.81a20.31,20.31,0,0,0,13.62-9.33A20.31,20.31,0,0,0,219,32.56a13.49,13.49,0,0,0,24.86,7.25,13.43,13.43,0,0,0,10-1.91c2.66,8.32,12.06,13.37,21.9,11.42a19.93,19.93,0,0,0,14.75-11.58,24.3,24.3,0,0,0,13,.92,23.88,23.88,0,0,0,14-8.3,13.47,13.47,0,0,0,21.4-2.61,13.46,13.46,0,0,0,17.17-2c4.56,6.88,13.69,10.63,23.18,8.76,12.14-2.4,20.26-13.09,18.13-23.88A73.93,73.93,0,0,0,400.48,0H0V29.49C.24,29.91.48,30.32.74,30.73Z"></path></g><path d="M16.3,13.9c10.2,2.5,20.3-1.1,25.5-8.3a14.66,14.66,0,0,0,18.5,3A14.6,14.6,0,0,0,80,14.9a13.14,13.14,0,0,0,3.4-2.4,25.71,25.71,0,0,0,14.8,9.7,26,26,0,0,0,14.1-.4,21.75,21.75,0,0,0,15.4,13.3c10.6,2.6,21-2.4,24.3-11.3a15,15,0,0,0,10.7,2.6,17.69,17.69,0,0,0,1.6,2.2,14.69,14.69,0,0,0,17.6,3.5,7.46,7.46,0,0,0,1.2-.7,14.54,14.54,0,0,0,6.4-8.9,12.61,12.61,0,0,0,.4-2.8,20.63,20.63,0,0,0,9.8-1.8,11.35,11.35,0,0,0,1.5,2.3A22.35,22.35,0,0,0,214,28.6c11.2,2.8,22.4-3.1,24.8-13.1a24.63,24.63,0,0,0,16.3,11.6c9.8,2.1,19.4-1.7,24.2-8.7a14,14,0,0,0,17.8,2.4,14.07,14.07,0,0,0,19.1,5.4,12.25,12.25,0,0,0,3.1-2.4,22.5,22.5,0,0,0,5.8,5.3,25.42,25.42,0,0,0,16.1,4,30.38,30.38,0,0,0,6-1.2c.2.4.4.9.6,1.3a20.81,20.81,0,0,0,14.6,11c10.2,2.2,20-2.9,22.9-11.5a13.84,13.84,0,0,0,10.3,2.1,14,14,0,0,0,19.3,4.6,14.17,14.17,0,0,0,6.7-11.8,20,20,0,0,0,9.3-2,21.31,21.31,0,0,0,14,9.9c10.6,2.3,20.9-3.4,23.2-12.7a28.46,28.46,0,0,0,37.2,7.1,23.54,23.54,0,0,0,7.3-7.1,15.79,15.79,0,0,0,20.1,2.1,15.69,15.69,0,0,0,21.6,5.5,13.88,13.88,0,0,0,3.5-2.9,26.66,26.66,0,0,0,9.5,7.2,28.5,28.5,0,0,0,7,2.2,29.16,29.16,0,0,0,15.2-1.3c2.8,6.6,9.3,11.8,17.5,13.3,11.4,2.1,22.2-3.8,25.3-13.4,0-.1.1-.2.1-.4.3.2.7.4,1,.6a15.93,15.93,0,0,0,10.7,1.5,15.79,15.79,0,0,0,28.7-6c.1-.4.1-.8.2-1.2a10.87,10.87,0,0,0,.1-1.8,22.26,22.26,0,0,0,10.4-2.6,25,25,0,0,0,3.9,4.7,24.65,24.65,0,0,0,12.2,6A24.5,24.5,0,0,0,715.3,34a19.09,19.09,0,0,0,10.2-13.4h.5a21.68,21.68,0,0,0,21.1,13,13.67,13.67,0,0,0,1.9-.2,22.1,22.1,0,0,0,13.8-7.7,24.79,24.79,0,0,0,11.9,8.5,25.09,25.09,0,0,0,8.1,1.4,25.86,25.86,0,0,0,18.5-6.7,21.77,21.77,0,0,0,5.2-7.2,15,15,0,0,0,19.1-1,15,15,0,0,0,21,2,13.81,13.81,0,0,0,2.8-3.1A26.84,26.84,0,0,0,866.3,26a27.39,27.39,0,0,0,14-3.4,22.36,22.36,0,0,0,18.3,9.9c11.1.3,20.4-7,21.8-16.6a15,15,0,0,0,11.2.2,15,15,0,0,0,21.1,1,15.16,15.16,0,0,0,4.7-13.5A22.32,22.32,0,0,0,966.3,0H0V1.6A25.29,25.29,0,0,0,16.3,13.9Z"></path><path d="M983.6,7.3A22.61,22.61,0,0,0,1000,1.1V0H967.3A22.52,22.52,0,0,0,983.6,7.3Z"></path></svg>';
		break;
		case 'clouds' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 63.67" preserveAspectRatio="none"><path d="M916.2,58.53a46.9,46.9,0,0,1-46.1-17.89,32,32,0,0,1-14-4.4c-4.43,6.7-12.62,11.2-22,11.2-12,0-22.13-7.44-24.8-17.44a18.82,18.82,0,0,1-13.44,8.2,18.51,18.51,0,0,1-12.45-2.59h-.65a25.09,25.09,0,0,1-8.1-1.4,24.79,24.79,0,0,1-3.52-1.48,10.8,10.8,0,0,1-7.32-2.19,10.84,10.84,0,0,1-15.13,2.91,13.67,13.67,0,0,1-1.63.16,21.69,21.69,0,0,1-2.93,0,19.23,19.23,0,0,1-9.36,3.78,19.56,19.56,0,0,1-10.37-1.45A16,16,0,0,1,712,44.38c-7.56,1-14.51-3.07-16.67-9.28q-.71-.27-1.41-.58a10.82,10.82,0,0,1-7,.48,10.85,10.85,0,0,1-16.07,1.54,15.75,15.75,0,0,1-26.69.66,15.93,15.93,0,0,1-10.7-1.5c-.3-.2-.7-.4-1-.6,0,.2-.1.3-.1.4C629.2,45.1,618.4,51,607,48.9c-8.2-1.5-14.7-6.7-17.5-13.3a29.16,29.16,0,0,1-15.2,1.3,28.5,28.5,0,0,1-7-2.2,26.65,26.65,0,0,1-5.65-3.46A17.66,17.66,0,0,1,528,35.9a15.07,15.07,0,0,1-15.65-10.62,8.91,8.91,0,0,1-2.07.72L510,26a23.53,23.53,0,0,1-4.73,3.86,28.46,28.46,0,0,1-37.2-7.1c-2.3,9.3-12.6,15-23.2,12.7a21.31,21.31,0,0,1-14-9.9,20,20,0,0,1-9.3,2,14.17,14.17,0,0,1-6.7,11.8l-.05,0A14,14,0,0,1,395.6,34.8a13.84,13.84,0,0,1-10.3-2.1c-2.9,8.6-12.7,13.7-22.9,11.5a20.81,20.81,0,0,1-14.6-11c-.2-.4-.4-.9-.6-1.3a30.38,30.38,0,0,1-6,1.2,25.39,25.39,0,0,1-7.23-.41,13.46,13.46,0,0,1-16.46-2.33,23.88,23.88,0,0,1-14,8.3,24.3,24.3,0,0,1-13-.92,19.93,19.93,0,0,1-14.75,11.58c-9.84,2-19.24-3.1-21.9-11.42a13.43,13.43,0,0,1-10,1.91A13.49,13.49,0,0,1,219,32.56a20.31,20.31,0,0,1-8.94-2.07,20.31,20.31,0,0,1-13.62,9.33c-7.6,1.51-14.95-1.18-19.11-6.32a14.7,14.7,0,0,1-11.15-3.1,14.89,14.89,0,0,1-1.74-.57c-1,8.55-8.28,15.43-17.67,17a32.85,32.85,0,0,1-40.49-2.38,25.19,25.19,0,0,1-20.89,4.31v.09A50,50,0,0,1,0,68.64V86.47H1000V73.07a55,55,0,0,1-83.8-14.54Z" transform="translate(0 -22.8)"></path></svg>';
		break;
		case 'papertorn' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 80" preserveAspectRatio="none"><path d="M0,0V71.07l.22.05c2.83,1,7.45-4.57,7.45-4.57s13.36,6.34,14.9,6.6S30,76.45,30,76.45L36.7,71.5s5.4,6,8,4.95,16.19-8.88,17.73-3.55S64.2,80,65,80s5.4-5.59,6.42-5.59,11,2.79,11.82,2.79,7.71-5.84,9.25-6.6,18.24.51,22.1,2.66,14.13.13,19.79,0,25.18,1.9,25.18,1.9l8.48-1.9s0-5.46,1.8-5.2,9.25.51,9.25.51L180.34,65s20.81,2,22.1,2,2.31-3.81,4.37-3.81,14.13,3.81,15.42,3.81,9.25-3.55,11.56-3.81,8.48,5.08,10.28,5.58,55-6.6,55-6.6-.26-5.33,4.88-3.55,15.16,1.27,19.53,2,3.34,6.34,7.71,2.54,5.65-7.36,8.22-6.09,10.28,2.28,11,2.28,4.37-8.12,7.19-6.6,21.59,12.5,30.06,13.48,13.1-10.44,13.1-10.44l13.1,2.54s7.71,10.15,16.19,11.17,11,6.34,19.27,3.55,17.73-9.39,20-8.38,17.47-6.6,18.24-6.85,8.74.76,16.44.25,9.51-5.52,9.51-5.52,25.69-1.08,28.78,1.21,3.6,4.31,6.68,4.31,12.33-5.84,22.35-3.55,26,6.34,27.49,7.11,10.28-5.58,10.28-5.58,5.14,4.57,6.42,5.84,6.17.76,9.25,0,3.85-9.14,10-5.08,20.3-5.08,25.44,1S667,64,667,64s6.68-11.42,14.39-9.9S710.16,66.2,710.16,66.2l6.42-5.49,27.24-1.27s-1.28-7.11,6.17-5.33,10-.89,11-1.71,5.14-3.49,9,0,25.44,8.31,32.89,8.31,15.93-6.35,22.61-4.57,13.36-1.52,14.39-2-.77-4.65,6.42-3.47,19-.76,20.58-.25,6.17-.76,11.31-1.78,6.34-11.63,12.25-4.27,8.68,5.28,11.51,6.74,7.45,1.33,9.25,0-1.54-7.93,7.19-5.39,4.17,3.48,10.08,3,14.13,4.06,14.13,4.06,10.79-2,13.11-2.28,9.25-4.57,12.59-2.79,6.17,1.52,9,2.28,10-.51,11.82-1.78,2.57-6.35,7.71-3.55a11.91,11.91,0,0,1,3.14,2.18V0Z" style="opacity:0.66"></path><path d="M0,0V59.17c4.84-3,4.08,1,5.36-.23s0,0,2.57-1.27,3.08.51,7.19,1,2.83,2.54,2.83,2.54,8.74,5.08,10.28,4.57,4.88-9.14,4.37-10.15S40,61.22,40,61.22l4.37,3.3s9.76,2,11,1a59.11,59.11,0,0,1,8-4.57c1.8-.76,4.11,2.28,6.68,2.79s8.74,3.81,8.74,3.81S90.92,60.71,94,60.21s16.7,3.55,17.47,2,11.82-3,13.1-2.79,8.48,10.91,8.48,10.91l30.83-.51s6.68-6.09,7.45-7.61.26-1.78.26-1.78,9-4.57,10-4.57S193.18,61,193.18,61s10.54-4.06,14.39-5.08,6.68,1.52,12.85-2,19.79-2.79,20.56-3.3,7.45-6.34,12.85-9.39,11.31.76,13.1.76,7.71,5.33,10.79,4.57,10.28-5.33,13.62-5.33,2.83,2.28,10.28,1.78,5.91.51,12.59,4.32,8-2.29,12.85-3.55,1.8.25,4.63-.51a19,19,0,0,1,5.65-.76c1.29,0,2.57,1.52,8.74,3.55s5.91-.76,9.25-1.78,8.22-3.3,18.76-10.15,2.57,5.33,6.94,6.85,22.87,3.55,24.41,2,4.37-3,7.2-4.57,2.82-.51,3.59-.51,9,2.54,11.31,4.06,3.85,4.57,6.17,4.57,4.62-2.54,11-3.55-.26,4.82,0,5.58,2.06,0,5.4-.25,4.88-2.79,9.76-2.79,5.14,3.3,8.48,4.06,2.83,0,10.54-3.81,6.68-1.78,14.9-3.55,22.61,6.85,24.41,6.09,4.88-1.27,11.3-2.54,11.56,3,16.19,5.58,5.14-1.52,8.74-5.08,12.08.25,14.9.25,9.25-.25,13.36-.51,5.14-3,13.88-5.08,8,4.57,14.65,3.55,14.13-1.27,28-5.08,6.42,3,10.79,5.58,9,1.78,11.56,1.52S676,39.65,679.84,36.35s9.51,4.31,16.19,8.12,9.25,3.81,14.13,1.78,9.51-4.82,14.9-7.87,5.4,5.84,10,2.79,15.42.76,17.21-.25,8.48.76,15.42-1,1.8,2,7.45,6.85,3.08-2.29,15.42,1,28.52-2.29,32.89-3,4.88,5.33,9.25,5.84,5.4-4.82,9.76-7.87,17-.76,20.56-2a17.22,17.22,0,0,0,6.17-4.06s13.36,0,15.16-1.52,10.28-.76,13.36-.76,26,4.57,35.2,2.79,11.82-7.62,16.44-10.91,23.13,2.54,30.32,2.54,20.3-2.54,20.3-2.54V0Z"></path></svg>';
		break;
		case 'bridge' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 283 20.99" preserveAspectRatio="none"><path d="M81.66,18.4C67.67,6.89,32.57.93,18.57,20.33,14.2,14.75,6.34,11.48,0,9.75V0H0V21H143.75C134.52,9.95,107.42,1.35,81.66,18.4Z" transform="translate(0.02 -0.01)"></path><path d="M283,0V11c-3.82.72-6.67,2.21-13.46,9.21-15.71-21-52.38-5.64-55,.58-12.95-12.92-53.74-17.6-70.74.21H283V0Z" transform="translate(0.02 -0.01)"></path></svg>';
		break;
		case 'rockymoutain' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 500 118.77" preserveAspectRatio="none"><defs><style>.cls-2{opacity:0.5;}</style></defs><path class="cls-1" d="M500,200a7.35,7.35,0,0,0-.44-1.4,13,13,0,0,0-1.25-2c-1.45-2.12-1.48-2.21-1.8-2.39-.55-.32-1.19-.45-1.33-1-.1-.32.06-.68-.11-.75s-.45.23-.6.15.1-.5-.11-.72-.87.07-1.2-.19-.09-.54-.14-.94c-.08-.74-.9-1.23-1.46-1.58-3.16-2-4.78-3-5.91-4.38a22.57,22.57,0,0,1-1.51-2,4.47,4.47,0,0,0-1.14-1.49,6.8,6.8,0,0,0-.77-.57c-.36-.18-.67-.26-.74-.49s0-.27-.06-.34-.22,0-.36,0c-.32-.08-.17-.7-.58-.92s-.5,0-.66-.14.14-.78-.05-.88-.24.12-.57.17-.44-.13-.92-.15-.6.15-.93.05-.23-.14-.55-.41a6.83,6.83,0,0,0-.71-.51,5.93,5.93,0,0,0-2-.38,2.44,2.44,0,0,1-1.06-.24c-.23-.14-.18-.2-.49-.46-.51-.41-.77-.37-1-.7s-.11-.45-.28-.6c-.54-.48-2.6.42-3.35.76-1.78.78-2,1.17-2.91,1.22a7.5,7.5,0,0,1-2.33-.51c-2.19-.58-2.07-.41-2.85-.68-2.84-1-3.9-3-5.26-2.64a1.91,1.91,0,0,1-1.05.17c-.56-.13-.66-.61-1.15-.62s-.44.27-.87.26-.62-.32-.91-.24-.22.45-.49.53-.74-.62-1.33-.59-.5.49-1,.51-.91-.68-1.35-.56c-.16,0-.13.13-.45.33a4.22,4.22,0,0,1-.68.31,2.17,2.17,0,0,0-.83.71c-.83.94-2.34.34-3.51,1.36-.44.39-.43.66-1,.93a3.42,3.42,0,0,1-1.49.26c-.53,0-.71.14-2.94,1.13-2.66,1.2-3.16,1.39-3.93,1.34s-.72-.25-1.44-.24c-1.42,0-1.68.82-3,.85-1.08,0-1.45-.55-2.22-.29-.5.18-.59.5-1,1a6.44,6.44,0,0,1-2.93,1.49,14.82,14.82,0,0,1-3.69.47c-2.2.14-1.16.24-7.76,1.32-1,.16-2.83.45-3.31,1.47-.11.24-.1.42-.31.57-.86.59-3.24-.94-3.49-1.1-.67-.44-2.13-1.39-2-2.28,0-.15.11-.42-.07-.6s-.53-.08-.91-.19c-.72-.21-.5-.95-1.34-1.59-.61-.47-.94-.25-1.39-.73s-.31-.95-.74-1.12-.61,0-1.18.19c-.79.27-.78.47-1.24.53-.66.08-.91-.31-1.44-.15s-.59.5-.76.45.11-.7-.29-1.26a1.19,1.19,0,0,0-.91-.53c-.43,0-.63.4-.86.32s-.12-.42-.36-.79a2,2,0,0,0-.87-.63c-1.46-.76-1.44-1.33-2.17-1.35a2.4,2.4,0,0,0-1.43.58c-.84.6-.84,1.17-1.26,1.19s-.49-.33-1.47-1.36-1.36-1.21-1.62-1.21c-.44,0-.65.31-1.16.23s-.45-.27-.68-.26c-.49,0-.67.91-1,1.41-1.17,1.67-5.86,1.27-8.31.47-1.46-.48-2.19-.71-2.6-1.33-.18-.27-.43-.81-.95-.89-.21,0-.32,0-.75,0s-.54-.12-.78-.13a1.88,1.88,0,0,0-1.19.44c-.58.4-.89.31-3,1-2.92,1-5.08,1.68-5.23,2.7,0,.18,0,.69-.42.89-.19.1-.28,0-.58.1-.61.16-.6.61-1.15.72-.3.06-.33-.06-.73,0a2,2,0,0,0-.82.34c-.39.27-.29.38-.73.77s-.32.16-.9.59a1,1,0,0,1-.54.27c-.23,0-.31-.13-.5-.09s-.15.18-.39.4-.35.16-.47.31,0,.43-.08.68-.49.27-1.75.59c-.8.21-.87.26-.92.3-.53.43-.14,1.07-.62,1.37s-.66,0-1.18.2-.28.41-.75.74-.84.2-1.2.58c-.18.19-.15.29-.43.61a5.56,5.56,0,0,1-.49.44c-.72.62-.71.86-1.16,1.06a3.87,3.87,0,0,1-.74.15,3.19,3.19,0,0,0-1.51,1.21c-1.12,1.11-3.68.78-3.83.76-1.54-.21-2.6-1-4.25-2.34l-.87-.7c-.87-.72-1.31-1.08-1.62-1.38a5,5,0,0,1-1.76-2.47c-.12-.68,0-1.36-.35-1.49s-.56.14-.71,0,.05-.34,0-.72a1.53,1.53,0,0,0-.24-.72c-.45-.65-1.31-.44-1.65-1-.23-.39,0-.74-.24-.9s-.67.16-1,0-.07-.81-.53-1.15-.62-.05-.89-.3-.07-.74-.38-.93-.43,0-.76,0c-.84,0-1.49-.86-1.68-1.11-.77-1-.2-1.52-.89-2.15s-1.65-.56-1.69-1,.46-.43.44-.74-.84-.51-1.53-.87c-1.7-.88-2.25-3.07-2.54-4.23a4.61,4.61,0,0,0-.45-1.39c-.42-.75-.78-.79-1.26-1.6s-.24-.85-.69-1.49-1.15-1.3-1.6-1.17c-.25.07-.23.36-.73.66a1.52,1.52,0,0,1-.52.23c-.74.2-1.16-.23-1.65,0-.28.13-.2.31-.55.44a1.36,1.36,0,0,1-.88,0c-.35-.11-.31-.27-.6-.39a1.75,1.75,0,0,0-1.87.5c-.06.11-.09.24-.23.29s-.35-.08-.59-.13-.53.06-1.27.37c-1.2.49-1.35.43-1.41.39-.24-.16,0-.7-.17-.75s-.44.39-.57.34.06-.29-.06-.58-.37-.28-.47-.54.12-.37.15-.68c.06-.61-.71-1.29-1.1-1.21-.2,0-.16.25-.38.32-.41.12-1.2-.46-1.47-1.17-.15-.42,0-.54-.2-.82s-.66-.3-1.24-.68c-.75-.48-.8-1.08-1.13-1s-.5.87-.8.86-.26-.51-.72-.65a.79.79,0,0,0-.47,0c-.35.13-.29.5-.51.56-.41.12-1.11-1-1.37-.87s.06.6-.23.79a.85.85,0,0,1-.63,0c-1.37-.4-1.86-2.54-3.59-3a1.78,1.78,0,0,0-1.56.14c-.4.43.18,1.36,0,1.42s-.25-.3-.65-.57c-.66-.45-1.11-.11-1.71-.44-.85-.46-.4-1.36-1.37-1.89-.3-.17-.63-.23-.75-.52s.08-.55-.12-.71-.39,0-.56-.16,0-.55-.18-.66-.26.05-.41,0,0-.67-.34-1-1-.09-1.13-.37.13-.28.06-.6a.66.66,0,0,0-.3-.45c-.26-.14-.48,0-.65-.07s0-.53,0-1.2a1.63,1.63,0,0,0-.15-.74c-.29-.55-.84-.47-1.73-1.1-.7-.5-.8-.87-1.22-.85s-.41.22-1,.25c-.15,0-.48,0-.61-.13s0-.13-.09-.28-.25-.19-.35-.37,0-.2-.05-.44-.16-.2-.25-.42,0-.35-.08-.61a1.21,1.21,0,0,0-.32-.45c-.51-.57-.78-.87-1.13-.86s-.39.18-.57.11-.15-.36-.33-.41-.35.23-.53.2c-.38-.07-.13-1.33-.82-1.64-.19-.09-.33,0-.53-.19s-.23-.33-.35-.65a2.37,2.37,0,0,0-.65-1.07c-.26-.22-.36-.15-.75-.41a3,3,0,0,1-.78-.76,14.43,14.43,0,0,0-1.39-1.4c-1.59-1.45-4.38-.39-5.4-1.79-.18-.25,0-.2-.36-.91a5.8,5.8,0,0,0-1.49-2.2c-.45-.37-.82-.53-.93-1s.07-.37,0-.68-.48-.67-1.16-1.13-.64-.33-.87-.57c-.38-.4-.29-.65-.68-1a3.08,3.08,0,0,0-.83-.39,8.55,8.55,0,0,1-1.31-.8c-1.2-.74-1.82-.32-2.58-.88-1.12-.82-1-2.57-1.05-2.56s.13.74-.23.93a.94.94,0,0,1-1-.28c-.31-.37.08-.72,0-1.53-.07-.53-.35-1.21-.77-1.27s-.41.29-.71.27c-.61-.05-.54-1.47-1.45-1.76-.35-.1-.51,0-.92-.12s-.47-.51-.8-.6-.73.42-1.4.6c-1.16.3-2.73-.72-3.46-1.79a5.07,5.07,0,0,1-.44-.87,7.16,7.16,0,0,0-3.13-2.86c-2.11-1.14-3.6-.91-4.66-2.35a2.82,2.82,0,0,1-.27-.42c-1.21-2-1.15-3.5-1.86-3.59-.27,0-.47.16-.63,0s.14-.83-.11-1-.51.13-.61,0,.18-.32.08-.51-.47-.07-.61-.25.4-.8.18-1.07-.45,0-.61-.21.14-.51-.07-.79c-.11-.13-.24-.12-.3-.28s0-.21,0-.37a.89.89,0,0,0-.18-.55c-.28-.39-.9-.12-1.26-.47s0-.81-.37-1.14-.51-.1-.77-.33-.18-.55-.23-.86c-.09-.64-.65-.67-1.63-1.69s-.89-1.51-1.65-1.79c-.32-.12-.7-.17-.87-.46s0-.38,0-.73a1.73,1.73,0,0,0-.88-1.36c-.56-.3-1-.11-1.25-.41s.15-.43,0-.75-.56-.3-1.18-.74a4.58,4.58,0,0,1-.6-.52,7.09,7.09,0,0,0-1.91-1.08c-1.13-.55-.86-.94-2.13-1.86a9.49,9.49,0,0,0-3.33-1.51c-1.5-.38-1.43,0-2.89-.32a14.27,14.27,0,0,1-4.47-2,4.45,4.45,0,0,0-1.37-.68,2.89,2.89,0,0,0-1.92-.05c-.4.18-.42.42-1.15.83l-.58.28-1.24.59A8.69,8.69,0,0,0,182,85.25c-.64.69-.43.59-.8.94-1.47,1.37-3.07,1.29-3.54,2.41-.09.23,0,.25-.2.74a6.44,6.44,0,0,1-.7,1.47,10.08,10.08,0,0,1-1.13,1.3c-.92,1-.93,1.07-1.4,1.56s-.79.81-1.27,1.22a13.11,13.11,0,0,1-2.43,1.53c-.83.48-1.53,1.39-2.91,3.22-1,1.28-3.08,4.23-4.17,4.34a1.19,1.19,0,0,0-.56.19c-.29.22-.26.52-.33.81-.14.57-.59,1-1.49,1.74-.59.5-.79.54-.89.85-.16.46.21.68.35,1.28.24,1-.47,1.21-.93,3.15a3.85,3.85,0,0,1-.38,1.13c-.16.3-.28.42-.46.81s-.16.49-.29.78a5.36,5.36,0,0,1-1,1.19,6.93,6.93,0,0,0-.93,1.09,2.62,2.62,0,0,0-.33.67c-.28.88.17,1.34-.24,1.75-.15.14-.34.21-.41.44s0,.27,0,.44-.33.28-.56.43a1.74,1.74,0,0,0-.63.84c-.63,1.19-3.84,4.08-4.69,3.66-.14-.06-.23-.22-.44-.22s-.43.31-.71.29-.32-.3-.54-.29-.35.36-.64.82c-.46.75-.66.6-.86,1.07-.31.71.05,1.26-.37,1.5a2.09,2.09,0,0,0-.44.23c-.24.19-.25.37-.37.37s-.18-.18-.42-.48-.35-.44-.56-.52c-.47-.18-.94.26-1.13.11s.34-.7.29-1.51c0-.5-.31-1-.58-1s-.37.6-.74.64c-.53.05-.82-1.24-1.51-1.27-.39,0-.39.42-1.48,1.31-.71.57-1.12.73-1.18,1.16,0,.21,0,.54-.19.63s-.2,0-.29,0,.07.42-.07.73-.48.21-.91.67c-.16.18-.19.27-.37.36s-.38,0-.64.11-.47.33-.7.65-.21.47-.47.71-.21.12-.38.27c-.4.35-.28.6-.64,1s-.41.25-.63.56-.1.49-.3.84c-.27.5-.69.46-1,.91s-.1.63-.18,1.07c-.12.76-.68.75-1.82,2.12a6.43,6.43,0,0,0-1.35,2.11,1.63,1.63,0,0,1-.23.52c-.32.47-.75.52-1,1a1.39,1.39,0,0,0-.15.53c-.25.95-2.12,1.7-3.67,1.91a6.25,6.25,0,0,0-2.35.4,9.5,9.5,0,0,0-1,.59c-1.07.73-1,.79-1.21.85-1,.25-1.84-1.24-3-1-.42.09-.73.38-1.21.26-.28-.08-.43-.25-.65-.19s-.26.23-.44.45c-.32.42-.57.35-.89.66-.56.56-.12,1.16-.76,1.8a.6.6,0,0,1-.42.23c-.33,0-.43-.41-.78-.45s-.65.47-.92.4-.12-.26-.3-.6-.63-.84-1-.8-.53.68-.76.65-.16-.56-.47-.64-.24.09-.43.08c-.5,0-.71-.91-1-.89s-.16.28-.41.37-.59-.28-1-.31c-.69-.05-.84.84-2,1.22-.6.19-.67,0-1.39.22s-.82.57-1.38.61-.87-.3-1.4-.17a1.58,1.58,0,0,0-.68.48,18.8,18.8,0,0,1-2.27,1.55c-.88.55-1.05.61-1.26.6-.6,0-.85-.45-1.39-.39-.36,0-.58.28-.9.63-.79.88-.73,1.64-1.31,1.77-.24,0-.45,0-.67.12s-.1.09-.29.41-.33.54-.48.62-.23,0-.35.1c-.33.18-.11.7-.2,1.2a2.94,2.94,0,0,1-2.36,1.93,2,2,0,0,0-.7.15,1.86,1.86,0,0,0-.83.7c-.93,1.31-4.47.95-5.74,2.39a1.12,1.12,0,0,1-.76.49c-.48,0-.78-.46-1.1-.35s-.14.29-.42.44-.46,0-.68.1c-.38.2-.15.85-.44.94s-.39-.24-.63-.19-.21.74-.57,1.34a3.91,3.91,0,0,1-3.33,1.5c-.24,0-.75-.11-1,.11s-.06.38-.27.53-.36,0-.6.12-.26.47-.51.81c-.4.53-1,.25-1.75.82-.56.42-.58.83-.94.84s-.36-.31-.93-.53a1.61,1.61,0,0,0-1.2,0c-.22.14-.14.3-.38.51s-.91.38-1,.23.49-.73.26-1-.41-.16-.6-.13-.45.16-.86.78a3.79,3.79,0,0,0-.52.92c-.55,1.46-3.71,3.45-4.63,4-1.49.94-1,.39-2.83,1.47-.56.33-1,.58-1.3.46-.64-.22-.41-1.41-1.12-1.62-.33-.1-.45.15-.87.06-.61-.13-.56-.71-1.35-1.09-.1,0-.7-.33-1-.13a.62.62,0,0,0-.25.46c-.23.75-1.79.65-3.49,1.48a11.13,11.13,0,0,1-2.54,1.27c-.42.08-.93.12-.93.12a3.7,3.7,0,0,1-.89,0c-.64-.11-.71-.46-1.06-.49-.76-.07-.94,1.48-2.18,2s-2.12-.62-3.11-.15c-1.28.6-.93,3-1.91,3.09-.32.05-.63-.17-.93,0s-.21.31-.36.64c-.28.64-.57.61-.76,1.06-.3.74.33,1.19,0,1.51s-1-.16-1.86.19c-.57.22-.57.53-1.11.6s-.65-.12-1.11,0-.32.2-.67.38c-.75.38-1.17.05-1.6.38s-.18.75-.67,1.05c-.28.19-.45.09-.8.19-1.09.34-.79,1.82-2.08,2.53-.4.22-.5.12-.89.38-.58.38-.6.77-1.16,1.24a3.45,3.45,0,0,1-1,.57c-1.94.89-2.42,4.63-5.28,6-1.47.7-1.87,0-3.51.83-1.49.78-2,1.85-3.51,1.92a8.42,8.42,0,0,0-1.42,0A3.49,3.49,0,0,0,0,200Z" transform="translate(0 -81.23)"/><path class="cls-2" d="M490.75,187.83a1.28,1.28,0,0,1-.48-.09c-.25-.15,0-.36-.28-.46s-.31,0-.55,0a2,2,0,0,1-1.23-.54c-.57-.5-.15-.75-.65-1.06s-1.21-.27-1.24-.48.34-.21.33-.36-.62-.25-1.12-.43a3.09,3.09,0,0,1-1.86-2.08,1.71,1.71,0,0,0-.33-.68c-.3-.36-.56-.38-.92-.78s-.17-.42-.5-.73a1.79,1.79,0,0,0-1.17-.58c-.19,0-.17.18-.53.33a1.64,1.64,0,0,1-.38.11c-.54.1-.85-.11-1.21,0-.2.07-.15.15-.4.22a1.39,1.39,0,0,1-.64,0c-.26-.05-.23-.13-.44-.19a1.75,1.75,0,0,0-1.37.24c0,.06-.07.12-.17.15s-.25,0-.43-.07a2.32,2.32,0,0,0-.92.18c-.88.25-1,.22-1,.2s0-.35-.12-.37-.32.19-.42.16.05-.14,0-.28-.27-.14-.34-.26.08-.19.1-.34-.51-.63-.8-.59-.12.12-.27.15a1.29,1.29,0,0,1-1.08-.57c-.11-.21,0-.26-.14-.4s-.48-.15-.91-.33-.59-.53-.83-.52-.36.43-.58.43-.19-.25-.53-.32a.74.74,0,0,0-.34,0c-.25.06-.21.24-.37.27s-.81-.48-1-.43,0,.3-.17.39a.83.83,0,0,1-.47,0c-1-.2-1.35-1.24-2.61-1.48a1.86,1.86,0,0,0-1.15.07c-.29.21.14.66,0,.69s-.18-.15-.47-.28c-.48-.22-.81-.05-1.25-.21-.62-.23-.29-.67-1-.93-.23-.08-.46-.12-.55-.26s.06-.27-.08-.35-.3,0-.42-.08,0-.26-.13-.32-.19,0-.3,0,0-.33-.25-.48-.71-.05-.82-.19.09-.13,0-.29a.34.34,0,0,0-.22-.22c-.19-.07-.35,0-.47,0s0-.26,0-.59a.61.61,0,0,0-.11-.36c-.21-.27-.61-.23-1.26-.54s-.59-.42-.89-.42-.3.11-.69.13a1,1,0,0,1-.45-.06c-.06,0,0-.07-.06-.14s-.19-.09-.26-.18,0-.1,0-.22-.11-.1-.18-.21,0-.17-.06-.29-.05-.09-.23-.23c-.37-.28-.57-.42-.83-.42s-.28.09-.41.06-.11-.18-.25-.21-.25.12-.39.1-.09-.65-.59-.8a2.46,2.46,0,0,1-.39-.09c-.16-.08-.17-.17-.26-.32a1.16,1.16,0,0,0-.47-.53c-.19-.11-.27-.07-.55-.2a2.06,2.06,0,0,1-.57-.37,11,11,0,0,0-1-.69c-1.17-.71-3.21-.19-3.95-.88-.13-.12,0-.1-.27-.45a3,3,0,0,0-1.08-1.07c-.33-.19-.6-.26-.68-.48s0-.18,0-.33-.35-.33-.85-.56a5,5,0,0,1-.63-.27c-.28-.2-.22-.32-.5-.49a3.77,3.77,0,0,0-.61-.19,6.28,6.28,0,0,1-.95-.39c-.88-.36-1.33-.16-1.89-.43-.82-.4-.69-1.26-.77-1.26s.1.37-.17.46a.91.91,0,0,1-.72-.14c-.22-.18.06-.35,0-.75s-.25-.6-.56-.62-.3.14-.52.13c-.45,0-.39-.72-1.06-.86a6.12,6.12,0,0,1-.67-.07c-.35-.1-.35-.24-.59-.29s-.53.21-1,.29a3.39,3.39,0,0,1-2.53-.87,3.19,3.19,0,0,1-.32-.43,5.07,5.07,0,0,0-2.29-1.4c-1.54-.56-2.62-.45-3.4-1.16l-.2-.2c-.88-1-.84-1.72-1.35-1.77-.2,0-.35.09-.47,0s.11-.41-.08-.48-.37.06-.44,0,.13-.16.05-.25-.34,0-.44-.13.29-.39.13-.52-.32,0-.44-.11.1-.25-.06-.38-.17-.07-.22-.14,0-.11,0-.18a.36.36,0,0,0-.12-.27c-.21-.19-.66-.06-.93-.23s0-.4-.27-.57-.37,0-.56-.16-.13-.27-.17-.42c-.07-.31-.47-.33-1.19-.83s-.65-.74-1.21-.88c-.23-.05-.51-.08-.63-.22s0-.19,0-.36a.9.9,0,0,0-.64-.67c-.41-.14-.77-.05-.92-.2s.11-.21,0-.37-.4-.14-.86-.36c-.21-.1-.27-.16-.44-.25a5.61,5.61,0,0,0-1.39-.53c-.82-.28-.63-.46-1.56-.92a8.88,8.88,0,0,0-2.43-.74c-1.1-.18-1,0-2.11-.16a13.44,13.44,0,0,1-3.27-.95,3.62,3.62,0,0,0-1-.33,3,3,0,0,0-1.4,0c-.3.09-.31.21-.84.4l-.42.14-.91.29a6.56,6.56,0,0,0-1.92,1.07c-.46.33-.31.29-.58.46-1.07.67-2.24.63-2.58,1.18-.07.11,0,.12-.15.37a3.21,3.21,0,0,1-.51.72,6.82,6.82,0,0,1-.83.64c-.67.5-.68.52-1,.76s-.58.4-.93.6a11.39,11.39,0,0,1-1.77.75,7.62,7.62,0,0,0-2.13,1.58c-.7.63-2.25,2.08-3.05,2.13a1,1,0,0,0-.41.09c-.21.11-.19.26-.24.4s-.43.47-1.09.85c-.43.25-.57.27-.65.42s.15.33.26.63c.17.47-.35.59-.68,1.55a1.5,1.5,0,0,1-.28.55c-.11.15-.2.21-.34.4s-.11.24-.21.38-.11.15-.7.58a5.32,5.32,0,0,0-.68.54,1.33,1.33,0,0,0-.24.33c-.21.43.13.66-.17.86-.11.07-.25.1-.3.21s0,.14,0,.22-.24.14-.4.21a1,1,0,0,0-.46.41c-.47.59-2.81,2-3.43,1.8-.1,0-.17-.11-.33-.11s-.3.15-.51.15-.24-.15-.39-.15-.26.18-.47.41-.49.29-.63.52,0,.62-.27.74a1,1,0,0,0-.32.11c-.18.09-.18.18-.27.18s-.14-.09-.31-.24a1.08,1.08,0,0,0-.41-.25c-.34-.09-.69.12-.83.05s.26-.34.21-.74c0-.24-.22-.5-.42-.51s-.27.3-.53.32-.61-.61-1.11-.62c-.29,0-.29.2-1.09.64-.51.28-.81.36-.86.57s0,.27-.14.31-.14,0-.2,0,.05.2-.06.36-.34.1-.66.33c-.12.08-.14.13-.27.17a3.55,3.55,0,0,1-.47.06,1,1,0,0,0-.51.32c-.17.16-.16.23-.35.34s-.15.06-.27.14c-.3.17-.21.29-.47.5s-.3.12-.46.27-.08.24-.22.41-.5.23-.72.45-.08.31-.13.53c-.09.37-.5.36-1.33,1a3.45,3.45,0,0,0-1,1,.76.76,0,0,1-.16.26c-.24.23-.56.25-.75.48a.56.56,0,0,0-.11.26c-.18.47-1.55.83-2.68.94a6.28,6.28,0,0,0-1.72.19L345,172c-.79.36-.71.39-.89.42-.76.12-1.34-.61-2.19-.49a2.32,2.32,0,0,1-.88.13c-.21,0-.32-.12-.48-.09s-.19.11-.32.22-.42.17-.65.32c-.41.28-.09.57-.56.89a.55.55,0,0,1-.3.11c-.25,0-.32-.21-.57-.22s-.48.23-.67.19-.09-.13-.22-.29a1.09,1.09,0,0,0-.73-.4c-.3,0-.39.34-.56.32s-.12-.27-.34-.31-.18,0-.32,0c-.36,0-.51-.45-.75-.43s-.12.13-.31.18-.43-.14-.75-.16c-.51,0-.62.42-1.44.6-.43.1-.48,0-1,.11s-.61.28-1,.3-.64-.15-1-.08a1.09,1.09,0,0,0-.5.23,14.68,14.68,0,0,1-1.66.76,2.47,2.47,0,0,1-.92.3c-.44,0-.62-.23-1-.2a1.14,1.14,0,0,0-.66.32c-.58.43-.53.8-1,.86a2,2,0,0,0-.49.06c-.06,0-.07,0-.21.2s-.24.27-.35.31-.17,0-.26.05-.08.34-.14.59c-.12.45-1,.88-1.73.94a2.26,2.26,0,0,0-.51.07,1.47,1.47,0,0,0-.61.35c-.68.64-3.26.46-4.19,1.17a.89.89,0,0,1-.56.24c-.34,0-.57-.22-.8-.17s-.1.15-.31.22-.33,0-.49,0-.11.42-.32.47-.29-.12-.46-.1-.16.37-.42.66a3.53,3.53,0,0,1-2.43.74,1.46,1.46,0,0,0-.72.05c-.12.09,0,.19-.19.26s-.27,0-.44.06-.2.23-.38.4-.73.12-1.28.4-.42.41-.68.41-.26-.15-.68-.25a1.72,1.72,0,0,0-.88,0c-.16.07-.1.15-.28.25a1.09,1.09,0,0,1-.77.12c-.13-.1.37-.36.2-.5a.71.71,0,0,0-.44-.07,1,1,0,0,0-.63.39,1.69,1.69,0,0,0-.38.45c-.4.71-2.71,1.69-3.38,2-1.09.46-.7.19-2.07.72a1.77,1.77,0,0,1-.95.22c-.47-.11-.3-.69-.82-.79-.24,0-.33.07-.63,0s-.41-.35-1-.54a1.43,1.43,0,0,0-.76-.06c-.15.05-.16.16-.19.22-.16.37-1.3.32-2.54.73a10,10,0,0,1-1.86.63l-.68,0a3.46,3.46,0,0,1-.65,0c-.47,0-.52-.22-.78-.24-.54,0-.68.73-1.59,1s-1.55-.3-2.27-.07c-.93.3-.68,1.45-1.39,1.52-.24,0-.46-.09-.69,0s-.15.15-.26.31-.41.3-.55.52.24.59,0,.74-.71-.08-1.36.09c-.42.12-.42.27-.81.3a7.3,7.3,0,0,0-.81,0,2.34,2.34,0,0,0-.49.19c-.55.18-.85,0-1.17.18s-.13.37-.49.52a2.52,2.52,0,0,1-.58.09c-.8.17-.58.9-1.53,1.24-.29.11-.36.06-.65.19s-.43.38-.84.61a3.33,3.33,0,0,1-.71.28c-1.43.44-1.77,2.27-3.87,2.94-1.07.35-1.36,0-2.56.41s-1.49.91-2.57.94a8.85,8.85,0,0,0-1,0,2.85,2.85,0,0,0-1.43.62h233.2Z" transform="translate(0 -81.23)"/><path class="cls-2" d="M242.27,199.15a7.1,7.1,0,0,0-1.13,0c-1.16-.05-1.59-.7-2.76-1.18s-1.61-.08-2.77-.5c-2.26-.84-2.63-3.12-4.16-3.66a3.12,3.12,0,0,1-.77-.35c-.44-.29-.46-.52-.92-.76-.3-.15-.38-.09-.7-.23-1-.43-.78-1.33-1.64-1.54-.27-.06-.4,0-.63-.11s-.19-.45-.53-.65-.66,0-1.26-.23c-.27-.1-.27-.17-.52-.23a8.61,8.61,0,0,0-.88,0c-.42,0-.42-.23-.87-.36-.7-.22-1.21.08-1.47-.12s.24-.47,0-.92c-.15-.27-.38-.26-.6-.64-.11-.21-.11-.32-.28-.4s-.48,0-.73,0c-.78-.08-.51-1.51-1.51-1.88-.78-.29-1.49.38-2.45.09s-1.12-1.24-1.72-1.2c-.27,0-.33.24-.84.3a3.19,3.19,0,0,1-.7,0s-.39,0-.73-.07a9.92,9.92,0,0,1-2-.77c-1.34-.51-2.57-.45-2.75-.91,0-.08,0-.21-.19-.27a1.31,1.31,0,0,0-.83.07c-.62.23-.58.59-1.07.67-.32,0-.41-.1-.68,0-.55.13-.38.85-.88,1-.27.07-.58-.08-1-.28-1.48-.66-1.06-.32-2.23-.9-.73-.35-3.22-1.57-3.65-2.46a2.64,2.64,0,0,0-.41-.56c-.33-.37-.52-.45-.68-.47a.7.7,0,0,0-.48.08c-.18.17.36.5.21.62a1,1,0,0,1-.82-.14c-.2-.13-.13-.23-.31-.31a1.67,1.67,0,0,0-.94,0c-.45.14-.49.33-.74.32s-.29-.25-.73-.51c-.6-.34-1.07-.17-1.38-.5s-.14-.4-.41-.49-.32,0-.47-.08-.08-.21-.21-.31a1.31,1.31,0,0,0-.78-.07,3.53,3.53,0,0,1-2.62-.92c-.28-.37-.18-.78-.45-.82s-.34.17-.5.12,0-.45-.34-.57-.32,0-.54-.07-.16-.22-.32-.26-.5.23-.87.21a1,1,0,0,1-.61-.3c-1-.88-3.78-.66-4.51-1.45a1.48,1.48,0,0,0-.66-.43,1.87,1.87,0,0,0-.55-.09c-.78-.08-1.74-.62-1.86-1.18-.08-.3.1-.62-.16-.73-.09,0-.15,0-.27-.06s-.17-.11-.38-.38-.17-.22-.23-.25a1.58,1.58,0,0,0-.53-.07c-.46-.08-.41-.54-1-1.08a1.33,1.33,0,0,0-.71-.39c-.42,0-.62.24-1.09.24-.17,0-.31,0-1-.37a15,15,0,0,1-1.79-.94,1.24,1.24,0,0,0-.54-.29c-.41-.08-.61.13-1.1.1s-.46-.21-1.09-.37-.62,0-1.09-.14c-.88-.22-1-.77-1.55-.74-.35,0-.54.26-.81.19s-.19-.21-.33-.22-.42.53-.81.54c-.16,0-.21-.08-.35-.05s-.2.37-.36.39-.29-.37-.61-.4a1.06,1.06,0,0,0-.78.49c-.14.21-.11.34-.24.36s-.41-.26-.72-.24-.36.28-.62.28a.5.5,0,0,1-.33-.14c-.5-.39-.16-.76-.6-1.1-.25-.19-.45-.15-.7-.4s-.18-.25-.34-.28-.3.07-.52.12a2.37,2.37,0,0,1-1-.16c-.91-.15-1.54.76-2.36.6-.19,0-.11-.07-.95-.51-.33-.17-.55-.29-.75-.37a6.7,6.7,0,0,0-1.85-.24c-1.22-.12-2.7-.58-2.89-1.16a.89.89,0,0,0-.12-.33c-.21-.27-.55-.3-.81-.59a.91.91,0,0,1-.17-.32,4.28,4.28,0,0,0-1.07-1.29c-.9-.84-1.34-.82-1.44-1.29-.06-.27.07-.42-.14-.65s-.56-.25-.78-.56,0-.3-.23-.51-.28-.14-.5-.34-.19-.41-.51-.62c-.13-.09-.16-.07-.29-.17s-.19-.23-.38-.43a1,1,0,0,0-.55-.4,2.73,2.73,0,0,1-.5-.06,1,1,0,0,1-.29-.22c-.34-.28-.61-.22-.72-.41s.08-.39-.06-.45-.13,0-.22,0-.13-.26-.15-.38c-.05-.27-.37-.36-.93-.71-.86-.55-.86-.81-1.17-.8-.54,0-.77.81-1.19.77s-.35-.39-.58-.39-.43.33-.45.64c0,.49.39.82.22.92s-.52-.18-.89-.07a1.15,1.15,0,0,0-.44.31c-.19.18-.24.3-.33.3s-.11-.11-.29-.23a2.52,2.52,0,0,0-.35-.14c-.33-.14-.05-.48-.29-.91s-.31-.2-.68-.65c-.23-.28-.32-.51-.51-.51s-.21.18-.42.18-.31-.18-.56-.18-.24.1-.34.14c-.68.26-3.2-1.51-3.7-2.24a1.19,1.19,0,0,0-.5-.51c-.18-.08-.37-.12-.44-.26s0-.15,0-.27-.2-.18-.32-.27c-.32-.24,0-.52-.18-1.06a1.46,1.46,0,0,0-.27-.41,4.36,4.36,0,0,0-.73-.67c-.64-.53-.71-.64-.75-.72s-.08-.23-.23-.47-.24-.32-.37-.5a2.09,2.09,0,0,1-.3-.69c-.35-1.18-.92-1.34-.73-1.92.11-.37.4-.5.28-.78s-.24-.21-.7-.52c-.71-.47-1.07-.71-1.18-1.06,0-.18,0-.36-.26-.49a1.16,1.16,0,0,0-.44-.12c-.86-.07-2.53-1.87-3.29-2.64a8.39,8.39,0,0,0-2.29-2,11.09,11.09,0,0,1-1.92-.93c-.38-.25-.7-.51-1-.74s-.37-.33-1.1-1a7,7,0,0,1-.89-.8,3.47,3.47,0,0,1-.55-.89c-.13-.3-.09-.32-.16-.45-.37-.69-1.63-.64-2.78-1.48-.3-.21-.13-.15-.63-.57a6.89,6.89,0,0,0-2.07-1.32l-1-.36-.46-.17c-.57-.25-.58-.39-.91-.51a2.88,2.88,0,0,0-1.5,0,4,4,0,0,0-1.09.41,12.63,12.63,0,0,1-3.52,1.18c-1.15.21-1.09,0-2.27.2a9.08,9.08,0,0,0-2.63.92c-1,.57-.79.8-1.68,1.14a6,6,0,0,0-1.51.66,3.66,3.66,0,0,1-.46.31c-.5.27-.82.25-.94.45s.13.31,0,.46-.54.07-1,.25a1.08,1.08,0,0,0-.7.83c0,.21.11.3,0,.45s-.43.2-.68.27c-.6.17-.49.45-1.3,1.1s-1.21.64-1.29,1c0,.18,0,.37-.18.52s-.4.07-.6.2,0,.49-.29.7-.78.05-1,.28a.51.51,0,0,0-.14.34c0,.1.05.15,0,.23s-.15.09-.23.17.08.34-.06.48-.38,0-.49.13.33.48.15.65-.4,0-.48.15.14.25.06.31-.34-.07-.48,0,.12.49-.09.61-.28-.06-.49,0c-.56.06-.52,1-1.47,2.19a1.66,1.66,0,0,1-.21.26c-.84.87-2,.74-3.67,1.43a5.49,5.49,0,0,0-2.47,1.74,3.77,3.77,0,0,1-.34.54,3.38,3.38,0,0,1-2.73,1.08c-.53-.1-.74-.43-1.11-.36s-.26.24-.63.36-.45,0-.72.08c-.72.17-.66,1-1.14,1.07-.24,0-.32-.19-.57-.16s-.55.45-.6.77c-.08.5.22.71,0,.93a.89.89,0,0,1-.77.18c-.29-.12-.13-.57-.19-.57s.06,1.06-.82,1.56c-.61.34-1.09.08-2,.54a8,8,0,0,1-1,.48,2.82,2.82,0,0,0-.65.24c-.31.2-.24.36-.54.6s-.22.1-.68.35-.83.44-.91.69.06.22,0,.41-.39.36-.74.59a3.67,3.67,0,0,0-1.17,1.34c-.27.43-.15.4-.29.55-.8.85-3,.21-4.26,1.09a11.9,11.9,0,0,0-1.09.86,2.11,2.11,0,0,1-.61.46c-.31.16-.39.12-.6.25a1.46,1.46,0,0,0-.51.65c-.09.2-.1.31-.27.4a1.74,1.74,0,0,1-.42.11c-.54.19-.35,1-.65,1-.14,0-.26-.15-.42-.12s-.1.2-.26.25-.23-.06-.44-.07-.5.18-.9.53a1,1,0,0,0-.25.27c-.06.16,0,.22-.06.38s-.15.12-.2.25,0,.17,0,.27-.2.1-.27.23,0,.12-.07.17-.36.08-.49.08c-.42,0-.5-.15-.74-.16s-.41.21-1,.52c-.7.38-1.14.34-1.37.67a1,1,0,0,0-.12.45c0,.41.17.64,0,.73s-.31,0-.51.05a.4.4,0,0,0-.24.27c-.05.2.11.26.05.37s-.63,0-.89.23,0,.53-.27.59-.22,0-.32,0,0,.29-.14.41-.32,0-.45.09,0,.26-.09.44-.35.21-.59.31c-.77.33-.41.88-1.08,1.16-.48.2-.83,0-1.35.27-.31.16-.44.37-.51.34s.32-.6,0-.86a1.79,1.79,0,0,0-1.24-.09c-1.35.3-1.74,1.6-2.82,1.85a.84.84,0,0,1-.5,0c-.23-.12,0-.44-.18-.48s-.76.6-1.08.53-.13-.27-.41-.34a.69.69,0,0,0-.36,0c-.37.08-.38.39-.57.39s-.32-.5-.63-.52-.3.34-.89.64-.76.17-1,.41,0,.24-.16.5a1.32,1.32,0,0,1-1.15.71c-.17,0-.14-.17-.3-.19-.31-.05-.91.36-.87.74,0,.18.19.26.12.41s-.28.16-.37.33,0,.33-.05.35-.33-.24-.45-.21.06.37-.13.46-.17.06-1.11-.24c-.58-.18-.75-.27-1-.22s-.32.12-.47.08-.13-.11-.18-.18a1.66,1.66,0,0,0-1.47-.3c-.23.07-.2.17-.48.24a1.37,1.37,0,0,1-.69,0c-.27-.08-.21-.19-.44-.27-.38-.14-.71.12-1.3,0a1.7,1.7,0,0,1-.4-.14c-.4-.18-.38-.36-.58-.4-.36-.08-.94.35-1.26.71s-.2.47-.54.91-.67.52-1,1A1.7,1.7,0,0,0,0,179v20.93H243.81A2.89,2.89,0,0,0,242.27,199.15Z" transform="translate(0 -81.23)"/></svg>';
		break;
		case 'singlewave' :
			// var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 99" preserveAspectRatio="none"><path d="M768.06,59.54C687,48.21,607.41,28.42,526.35,17.15,347.45-7.73,155.24,13.87.07,99H1000V68.11A1149.19,1149.19,0,0,1,768.06,59.54Z"></path></svg>';
//			if (flip == '1') {
//				var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none" ><path d="M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z" fill="#ffffff"></path></svg>';
//			} else {
				var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none" ><path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z" fill="#ffffff"></path></svg>';
//			}
		break;
		case 'multislope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none"><path d="M0,22.3V0H1000V100Z" transform="translate(0 0)" style="opacity:0.66"></path><path d="M0,6V0H1000V100Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'slope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 94" preserveAspectRatio="none"><polygon points="0 94 1000 94 0 0 0 94"></polygon></svg>';
		break;
		case 'waves3' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 84.94" preserveAspectRatio="none"><path d="M0,0V72.94c14.46,5.89,32.38,10.5,54.52.26,110.25-51,120.51,23.71,192.6-4.3,144.73-56.23,154.37,49.44,246.71,4.64C637,4.05,622.19,124.16,757.29,66.21c93-39.91,108.38,54.92,242.71-8.25V0Z" style="fill-rule:evenodd;opacity:0.33"></path><path d="M0,0V52.83c131.11,59.9,147-32.91,239.24,6.65,135.09,58,120.24-62.16,263.46,7.34,92.33,44.8,102-60.88,246.71-4.64,72.1,28,82.35-46.71,192.6,4.3,23.95,11.08,43,4.78,58-1.72V0Z" style="fill-rule:evenodd;opacity:0.66"></path><path d="M0,0V24.26c15.6,6.95,35.77,15.41,61.78,3.38,110.25-51,120.51,23.71,192.6-4.3C399.11-32.89,408.75,72.79,501.08,28,644.3-41.51,629.45,78.6,764.54,20.65,855.87-18.53,872.34,72.12,1000,15.7V0Z" style="fill-rule:evenodd"></path></svg>';
		break;
		case 'drip' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 91.02" preserveAspectRatio="none"><path d="M772,11c-32.4,4-58,9.51-58,9.51C685.3,26.69,659.67,34.32,658,35c-15.34,6.3-25.24,13.11-43,13-27.54-.18-37.37-16.79-56-11-19,5.91-19.53,26.54-35,27-13.47.4-16.5-15.14-36-18-1.32-.19-15.92-2.13-29,6-20.34,12.64-18.82,38.28-28,39-8.62.68-10.8-21.86-26-40-5.44-6.49-24.19-25.34-100-32a429.73,429.73,0,0,0-94,2C165,26.91,96.11,27.3,0,0V91H1000V0C894.78,1.07,813.3,5.92,772,11Z" transform="translate(0 0)"></path></svg>';
		break;
		case 'asymslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none"><polygon points="0 89 741 89 0 0 0 89"></polygon><polygon points="741 89 1000 89 1000 0 741 89"></polygon></svg>';
		break;
		case 'vslope' :
				var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M1200 0L0 0 598.97 114.72 1200 0z" fill="#ffffff"></path></svg>';
		break;
		case 'vslopeinverse' :
				var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z" fill="#ffffff"></path></svg>';
		break;
		case 'multivslope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" style="width: 100%; max-width: 100%;"><polygon points="0 89 500 89 0 20 0 89"></polygon><polygon points="500 89 1000 89 1000 20 500 89"></polygon><polygon style="opacity: 0.6;" points="0 20 500 89 0 0 0 89"></polygon><polygon style="opacity: 0.6;" points="500 89 1000 20 1000 0 500 89"></polygon></svg>';
		break;
		case 'multiv3slope' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1000 89" preserveAspectRatio="none" ><polygon points="0 89 500 89 0 40 0 89"></polygon><polygon points="500 89 1000 89 1000 40 500 89"></polygon><polygon style="opacity: 0.6;" points="0 40 500 89 0 20 0 69"></polygon><polygon style="opacity: 0.6;" points="500 89 1000 20 1000 40 500 89"></polygon><polygon style="opacity: 0.3;" points="0 20 500 89 0 0 0 89" ></polygon><polygon style="opacity: 0.3;" points="500 89 1000 20 1000 0 500 89"></polygon></svg>';
		break;
		case 'triangle' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M649.97 0L550.03 0 599.91 54.12 649.97 0z" fill="#ffffff"></path></svg>';
		break;
		case 'triangleinverse' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M649.97 0L599.91 54.12 550.03 0 0 0 0 120 1200 120 1200 0 649.97 0z" fill="#ffffff"></path></svg>';
		break;
		case 'trianglesmall' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><polygon points="0 50 1000 50 1000 25 520 25 500 0 480 25 0 25 0 50"></polygon></svg>';
		break;
		case 'triangle3' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1000 50"><polygon points="0 50 1000 50 1000 25 560 25 540 0 520 25 500 0 480 25 460 0 440 25 0 25 0 50"></polygon></svg>';
		break;
		case 'ellipse' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M0,0V7.23C0,65.52,268.63,112.77,600,112.77S1200,65.52,1200,7.23V0Z" fill="#ffffff"></path></svg>';
		break;
		case 'ellipseinverse' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z" fill="#ffffff"></path></svg>';
		break;
		
		case 'book' :
			if (flip == '1') {
				var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z" fill="#ffffff"></path></svg>';
			} else {
				var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M1200,0H0V120H281.94C572.9,116.24,602.45,3.86,602.45,3.86h0S632,116.24,923,120h277Z" fill="#ffffff"></path></svg>';
			}
		break;
		case 'bubbles' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 143" preserveAspectRatio="none"><defs><style>.cls-2{opacity:0.5;}</style></defs><rect class="cls-1" width="500" height="44" transform="translate(500 44) rotate(-180)"/><circle class="cls-2" cx="240" cy="41" r="30"/><circle class="cls-2" cx="73" cy="55" r="50"/><circle class="cls-2" cx="400.5" cy="66.5" r="14.5"/><circle class="cls-2" cx="471.5" cy="63.5" r="8.5"/><circle class="cls-2" cx="383.97" cy="85.98" r="5"/><circle class="cls-2" cx="392.26" cy="96.59" r="3.33"/><circle class="cls-2" cx="384.33" cy="104.07" r="2.07"/><circle class="cls-2" cx="391.5" cy="111.24" r="1.5"/><circle class="cls-2" cx="464.91" cy="80.28" r="3.33"/><circle class="cls-2" cx="471.02" cy="89.34" r="1.5"/><circle class="cls-2" cx="190.87" cy="82.1" r="7.31"/><circle class="cls-2" cx="199.48" cy="98.6" r="4.51"/><circle class="cls-2" cx="192.75" cy="108.96" r="2.07"/><circle class="cls-2" cx="108.5" cy="128.5" r="14.5"/><path class="cls-1" d="M373.84,56.69A20.76,20.76,0,0,0,385,53.46a20.79,20.79,0,0,0,30.26,11.21,20.81,20.81,0,0,0,37-8.05,20.83,20.83,0,1,0-6.27-19.8,20.74,20.74,0,0,0-24.64-2.62,20.78,20.78,0,0,0-27.74-5.1,20.84,20.84,0,1,0-19.71,27.59Z" transform="translate(0 0)"/><path class="cls-1" d="M46.26,53.78a16,16,0,0,0,8.61-2.5A16.12,16.12,0,0,0,78.33,60,16.14,16.14,0,0,0,107,53.73a16.16,16.16,0,1,0-4.86-15.35,16.08,16.08,0,0,0-19.1-2,16.1,16.1,0,0,0-21.51-4A16.16,16.16,0,1,0,46.26,53.78Z" transform="translate(0 0)"/><circle class="cls-1" cx="230.91" cy="36.36" r="26.36"/><circle class="cls-1" cx="205.45" cy="43.64" r="26.36"/><circle class="cls-1" cx="178.36" cy="36.36" r="26.36"/><circle class="cls-1" cx="260.09" cy="28.94" r="26.36"/></svg>';
		break;
		case 'trees' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 95.32" preserveAspectRatio="none"><path class="cls-1" d="M113.72,166.67l-5-11.14a6.47,6.47,0,0,0,1.33-.18c.78-.19,1.78-.08,1.78-.74s-5.44-11.76-5.44-11.76a15.45,15.45,0,0,0,1.67-.19c.44-.11.26-.89.26-.89s1,1.19,1.44.93-.52-1.52-.52-1.52l-5.14-11.31a5.49,5.49,0,0,0,1.74-.15c.48-.22.15-1.15.15-1.15a11,11,0,0,0,1.73-.26c.71-.18-10.8-22.23-10.8-22.23s-.51-1.4-.88-1.4-10.84,22.26-10.84,22.26-.67.93-.19.93-.25,1.15.52,1.33S87,130.75,87,130.75l-4.67,12.06s-.88,1.26,0,1.44a4.67,4.67,0,0,0,1.67,0l-4.18,8.25s.07.74.59.74-4.7,11-4.7,11-1.55,1.78.15,2.18a3.14,3.14,0,0,0,2.89-.92s-.48,1.74,1.25,1.74,4.11-2.52,4.11-2.37S82.21,168,83.39,168s3.07-3,3.07-3-.88,2.29.12,2.29,1.51,0,1.51,0v7.1h12.32v-7.47s0,1.4.92,1.29,1.37-1.55,1.37-1.55-.41,1.4.56,1.66,1.73-2.47,1.73-2.47.71,2.88,2.11,2.88.82-2.66.82-2.66,1.1,3.07,2.29,2.84.52-2.51.52-2.51,2,1.63,2.55,1.63S113.72,166.67,113.72,166.67Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M145.9,168.05,143.61,163a2.78,2.78,0,0,0,.61-.09c.35-.08.8,0,.8-.33s-2.47-5.35-2.47-5.35a7.18,7.18,0,0,0,.76-.09c.2,0,.12-.4.12-.4s.43.54.65.42-.23-.69-.23-.69l-2.34-5.15a2.24,2.24,0,0,0,.79-.07c.22-.1.07-.52.07-.52a4.71,4.71,0,0,0,.79-.12c.32-.08-4.92-10.11-4.92-10.11s-.23-.64-.4-.64S132.91,150,132.91,150s-.3.42-.08.42-.12.52.23.61.66.71.66.71l-2.12,5.48s-.41.57,0,.66a2.13,2.13,0,0,0,.75,0l-1.9,3.76s0,.33.27.33-2.13,5-2.13,5-.71.81.06,1a1.42,1.42,0,0,0,1.32-.42s-.22.79.57.79,1.87-1.14,1.87-1.08-.85,1.42-.31,1.42,1.4-1.36,1.4-1.36-.41,1,.05,1,.69,0,.69,0v3.23h5.6v-3.4s0,.64.42.59.62-.7.62-.7-.18.63.26.75.79-1.12.79-1.12.32,1.31,1,1.31.37-1.21.37-1.21.5,1.39,1,1.29.24-1.14.24-1.14.9.74,1.16.74S145.9,168.05,145.9,168.05Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M401.66,183.9l-2.28-5.06a2.67,2.67,0,0,0,.6-.09c.35-.08.81,0,.81-.33s-2.47-5.35-2.47-5.35a7.07,7.07,0,0,0,.75-.09c.2,0,.12-.4.12-.4s.44.54.66.42-.24-.69-.24-.69l-2.34-5.15a2.51,2.51,0,0,0,.79-.07c.22-.1.07-.52.07-.52a4.71,4.71,0,0,0,.79-.12c.32-.08-4.91-10.11-4.91-10.11s-.24-.64-.41-.64-4.93,10.13-4.93,10.13-.3.42-.08.42-.12.52.24.61.65.7.65.7l-2.12,5.49s-.4.57,0,.66a2.18,2.18,0,0,0,.76,0l-1.9,3.75s0,.34.27.34-2.14,5-2.14,5-.71.81.07,1a1.41,1.41,0,0,0,1.31-.42s-.22.79.57.79,1.87-1.14,1.87-1.08-.84,1.42-.3,1.42,1.39-1.37,1.39-1.37-.4,1.05.05,1.05.69,0,.69,0v3.23h5.61V184s0,.64.42.59.62-.71.62-.71-.19.64.25.76.79-1.13.79-1.13.32,1.32,1,1.32.37-1.21.37-1.21.51,1.39,1.05,1.29.23-1.14.23-1.14.91.74,1.16.74S401.66,183.9,401.66,183.9Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M377.85,182.32l-3.08-6.81a3.93,3.93,0,0,0,.81-.11c.48-.11,1.09-.05,1.09-.45s-3.33-7.2-3.33-7.2a8.29,8.29,0,0,0,1-.11c.27-.07.16-.54.16-.54s.59.72.88.56-.31-.93-.31-.93l-3.15-6.92a3.16,3.16,0,0,0,1.06-.09c.3-.13.09-.7.09-.7a6.43,6.43,0,0,0,1.07-.16c.43-.11-6.61-13.59-6.61-13.59s-.32-.86-.54-.86S360.38,158,360.38,158s-.41.57-.11.57-.16.7.31.81.89,1,.89,1l-2.85,7.37s-.55.77,0,.88a2.77,2.77,0,0,0,1,0l-2.55,5s0,.45.36.45-2.87,6.72-2.87,6.72-.95,1.09.09,1.34a1.9,1.9,0,0,0,1.76-.57s-.29,1.06.77,1.06,2.51-1.53,2.51-1.44-1.13,1.9-.41,1.9,1.88-1.84,1.88-1.84-.54,1.41.07,1.41.93,0,.93,0V187h7.53v-4.57s0,.86.57.79.83-.95.83-.95-.25.86.34,1,1.07-1.52,1.07-1.52.43,1.77,1.29,1.77.49-1.63.49-1.63.68,1.88,1.41,1.74.31-1.54.31-1.54,1.22,1,1.56,1S377.85,182.32,377.85,182.32Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M436.53,180l-2.29-5.07a3,3,0,0,0,.61-.08c.35-.09.81,0,.81-.34s-2.48-5.35-2.48-5.35a6.5,6.5,0,0,0,.76-.08c.2-.05.12-.41.12-.41s.44.54.65.42-.23-.69-.23-.69l-2.34-5.15a2.42,2.42,0,0,0,.79-.06c.22-.1.07-.52.07-.52a6.21,6.21,0,0,0,.79-.12c.32-.09-4.91-10.11-4.91-10.11s-.24-.64-.41-.64-4.93,10.13-4.93,10.13-.3.42-.08.42-.12.52.23.6.66.71.66.71l-2.12,5.48s-.4.58,0,.66a2.36,2.36,0,0,0,.76,0l-1.9,3.75s0,.34.27.34-2.14,5-2.14,5-.71.81.07,1a1.41,1.41,0,0,0,1.31-.42s-.22.79.57.79,1.87-1.14,1.87-1.07-.84,1.41-.3,1.41,1.39-1.36,1.39-1.36-.4,1,.05,1,.69,0,.69,0v3.24h5.6v-3.4s0,.64.43.59.62-.71.62-.71-.19.64.25.76.79-1.13.79-1.13.32,1.31,1,1.31.37-1.21.37-1.21.5,1.4,1,1.3.24-1.15.24-1.15.91.74,1.16.74S436.53,180,436.53,180Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M469.23,175.45l-3.44-7.64a4.56,4.56,0,0,0,.91-.12c.53-.13,1.22-.05,1.22-.51s-3.73-8.06-3.73-8.06a9.27,9.27,0,0,0,1.14-.13c.3-.08.18-.61.18-.61s.66.81,1,.64-.36-1-.36-1l-3.52-7.76a3.75,3.75,0,0,0,1.19-.1c.33-.16.1-.79.1-.79a7.71,7.71,0,0,0,1.19-.18c.48-.13-7.4-15.24-7.4-15.24s-.36-1-.61-1-7.43,15.26-7.43,15.26-.46.64-.13.64-.18.78.36.91,1,1.07,1,1.07l-3.2,8.26s-.61.86,0,1a3.22,3.22,0,0,0,1.14,0L446,165.76s.05.51.4.51-3.22,7.53-3.22,7.53-1.06,1.22.1,1.5a2.17,2.17,0,0,0,2-.64s-.33,1.19.86,1.19,2.82-1.72,2.82-1.62-1.27,2.13-.46,2.13,2.11-2.05,2.11-2.05-.61,1.57.07,1.57,1,0,1,0v4.87h8.45V175.6s0,1,.63.89.94-1.07.94-1.07-.28,1,.38,1.14,1.19-1.7,1.19-1.7.48,2,1.45,2,.55-1.82.55-1.82.76,2.1,1.58,1.95.35-1.73.35-1.73,1.37,1.12,1.75,1.12S469.23,175.45,469.23,175.45Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M78.52,176.53,75.58,170a3.71,3.71,0,0,0,.78-.11c.45-.11,1,0,1-.43s-3.18-6.88-3.18-6.88.71,0,1-.11.15-.52.15-.52.56.69.85.54-.31-.89-.31-.89l-3-6.62a3.06,3.06,0,0,0,1-.08c.28-.13.09-.67.09-.67a8.19,8.19,0,0,0,1-.15c.41-.11-6.32-13-6.32-13s-.3-.83-.52-.83-6.34,13-6.34,13-.39.54-.11.54-.15.67.31.78.84.9.84.9l-2.73,7.06s-.51.73,0,.84a2.73,2.73,0,0,0,1,0l-2.45,4.83s.05.43.35.43-2.75,6.42-2.75,6.42-.91,1,.09,1.28a1.84,1.84,0,0,0,1.69-.54s-.28,1,.73,1,2.4-1.47,2.4-1.38-1.08,1.82-.39,1.82,1.8-1.75,1.8-1.75-.52,1.34.06,1.34.89,0,.89,0V181h7.2v-4.37s0,.82.55.76.8-.91.8-.91-.24.82.32,1,1-1.45,1-1.45.41,1.69,1.23,1.69.48-1.56.48-1.56.64,1.8,1.34,1.67.3-1.47.3-1.47,1.17.95,1.49.95S78.52,176.53,78.52,176.53Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M160.27,168.05,158,163a2.78,2.78,0,0,0,.61-.09c.35-.08.8,0,.8-.33s-2.47-5.35-2.47-5.35a7.18,7.18,0,0,0,.76-.09c.2,0,.12-.4.12-.4s.43.54.65.42-.23-.69-.23-.69l-2.34-5.15a2.24,2.24,0,0,0,.79-.07c.22-.1.07-.52.07-.52a4.71,4.71,0,0,0,.79-.12c.32-.08-4.92-10.11-4.92-10.11s-.23-.64-.4-.64S147.28,150,147.28,150s-.3.42-.08.42-.12.52.23.61.66.71.66.71L146,157.2s-.41.57,0,.66a2.19,2.19,0,0,0,.76,0l-1.91,3.76s0,.33.27.33-2.13,5-2.13,5-.71.81.06,1a1.42,1.42,0,0,0,1.32-.42s-.22.79.57.79,1.87-1.14,1.87-1.08-.85,1.42-.31,1.42,1.4-1.36,1.4-1.36-.4,1,0,1,.69,0,.69,0v3.23h5.6v-3.4s0,.64.42.59.63-.7.63-.7-.19.63.25.75.79-1.12.79-1.12.32,1.31,1,1.31.37-1.21.37-1.21.5,1.39,1,1.29.24-1.14.24-1.14.91.74,1.16.74S160.27,168.05,160.27,168.05Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M130.39,172.3l-2.29-5.07a3.11,3.11,0,0,0,.61-.08c.35-.09.8,0,.8-.34s-2.47-5.35-2.47-5.35a6.5,6.5,0,0,0,.76-.08c.2,0,.11-.41.11-.41s.44.54.66.42-.23-.68-.23-.68L126,155.56a2.51,2.51,0,0,0,.79-.07c.22-.1.06-.52.06-.52a6.26,6.26,0,0,0,.8-.12c.32-.08-4.92-10.11-4.92-10.11s-.23-.64-.4-.64-4.93,10.13-4.93,10.13-.3.42-.08.42-.12.52.23.6.66.71.66.71l-2.12,5.49s-.41.57,0,.65a2,2,0,0,0,.75,0l-1.9,3.75s0,.34.27.34-2.13,5-2.13,5-.71.81.06,1a1.42,1.42,0,0,0,1.31-.42s-.21.79.58.79,1.86-1.15,1.86-1.08-.84,1.41-.3,1.41,1.4-1.36,1.4-1.36-.41,1,.05,1h.69v3.23h5.6v-3.4s0,.64.42.59.62-.71.62-.71-.18.64.26.76.79-1.13.79-1.13.32,1.31,1,1.31.37-1.21.37-1.21.5,1.4,1,1.3.24-1.15.24-1.15.9.74,1.16.74S130.39,172.3,130.39,172.3Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M195.14,170.56l-2.29-5.07a3,3,0,0,0,.61-.08c.35-.09.81,0,.81-.34s-2.48-5.35-2.48-5.35a6.5,6.5,0,0,0,.76-.08c.2,0,.12-.41.12-.41s.44.54.66.42-.24-.69-.24-.69l-2.34-5.14a2.51,2.51,0,0,0,.79-.07c.22-.1.07-.52.07-.52a6.21,6.21,0,0,0,.79-.12c.32-.08-4.91-10.11-4.91-10.11s-.24-.64-.41-.64-4.93,10.13-4.93,10.13-.3.42-.08.42-.12.52.24.6.65.71.65.71l-2.12,5.48s-.4.58,0,.66a2.34,2.34,0,0,0,.76,0l-1.9,3.75s0,.34.27.34-2.14,5-2.14,5-.71.81.07,1a1.44,1.44,0,0,0,1.31-.42s-.22.79.57.79,1.87-1.15,1.87-1.08-.84,1.41-.3,1.41,1.39-1.36,1.39-1.36-.4,1,0,1h.69v3.23h5.61v-3.4s0,.64.42.59.62-.71.62-.71-.19.64.25.76.79-1.13.79-1.13.32,1.31,1,1.31.37-1.21.37-1.21.51,1.4,1,1.3.24-1.15.24-1.15.91.74,1.16.74S195.14,170.56,195.14,170.56Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M218.06,173.59l-2.79-6.18a3.7,3.7,0,0,0,.74-.1c.43-.11,1-.05,1-.42s-3-6.53-3-6.53a8.49,8.49,0,0,0,.93-.1c.24-.07.14-.5.14-.5s.53.66.8.52-.29-.85-.29-.85l-2.85-6.28a2.84,2.84,0,0,0,1-.09c.27-.12.08-.63.08-.63a5.93,5.93,0,0,0,1-.15c.39-.1-6-12.35-6-12.35s-.29-.78-.49-.78-6,12.37-6,12.37-.37.52-.11.52-.14.63.29.74.8.86.8.86l-2.59,6.7s-.49.7,0,.8a2.73,2.73,0,0,0,.93,0l-2.32,4.58s0,.41.32.41-2.61,6.11-2.61,6.11-.86,1,.09,1.21a1.73,1.73,0,0,0,1.6-.51s-.27,1,.7,1,2.28-1.4,2.28-1.31-1,1.72-.37,1.72,1.7-1.66,1.7-1.66-.49,1.27.07,1.27.84,0,.84,0v4h6.84v-4.15s0,.78.52.72.76-.87.76-.87-.23.78.3.93,1-1.38,1-1.38.39,1.6,1.17,1.6.45-1.48.45-1.48.62,1.71,1.28,1.59.29-1.4.29-1.4,1.11.9,1.41.9S218.06,173.59,218.06,173.59Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M387.27,183.9,385,178.84a2.78,2.78,0,0,0,.61-.09c.35-.08.8,0,.8-.33s-2.47-5.35-2.47-5.35a7.18,7.18,0,0,0,.76-.09c.2,0,.12-.4.12-.4s.43.54.65.42-.23-.69-.23-.69l-2.34-5.15a2.51,2.51,0,0,0,.79-.07c.22-.1.07-.52.07-.52a4.71,4.71,0,0,0,.79-.12c.32-.08-4.92-10.11-4.92-10.11s-.23-.64-.4-.64-4.93,10.13-4.93,10.13-.3.42-.08.42-.12.52.23.61.66.7.66.7L373,173.05s-.41.57,0,.66a2.19,2.19,0,0,0,.76,0l-1.91,3.75s0,.34.27.34-2.13,5-2.13,5-.71.81.06,1a1.42,1.42,0,0,0,1.32-.42s-.22.79.57.79,1.87-1.14,1.87-1.08-.85,1.42-.31,1.42,1.4-1.37,1.4-1.37-.4,1.05.05,1.05.69,0,.69,0v3.23h5.6V184s0,.64.42.59.63-.71.63-.71-.19.64.25.76.79-1.13.79-1.13.32,1.32,1,1.32.37-1.21.37-1.21.5,1.39,1,1.29.24-1.14.24-1.14.91.74,1.16.74S387.27,183.9,387.27,183.9Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M359.35,185,357.06,180a2.78,2.78,0,0,0,.61-.09c.35-.08.8,0,.8-.33S356,174.2,356,174.2a7.18,7.18,0,0,0,.76-.09c.2-.05.12-.4.12-.4s.43.54.65.42-.23-.69-.23-.69L355,168.29a2.42,2.42,0,0,0,.79-.06c.22-.11.07-.53.07-.53a5.47,5.47,0,0,0,.79-.11c.32-.09-4.92-10.12-4.92-10.12s-.23-.64-.4-.64S346.36,167,346.36,167s-.3.42-.08.42-.12.53.23.61.66.71.66.71l-2.12,5.48s-.41.57,0,.66a2.19,2.19,0,0,0,.76,0l-1.91,3.76s0,.33.27.33-2.13,5-2.13,5-.71.81.06,1a1.42,1.42,0,0,0,1.32-.42s-.22.79.57.79,1.87-1.14,1.87-1.07-.85,1.41-.31,1.41,1.4-1.36,1.4-1.36-.4,1,.05,1,.69,0,.69,0v3.23h5.6v-3.4s0,.64.42.59.63-.7.63-.7-.19.64.25.75.79-1.12.79-1.12.32,1.31,1,1.31.37-1.21.37-1.21.5,1.39,1,1.29.24-1.14.24-1.14.91.74,1.16.74S359.35,185,359.35,185Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M429.27,179.79l-4.73-10.47a6.1,6.1,0,0,0,1.25-.17c.73-.18,1.67-.07,1.67-.7s-5.12-11.06-5.12-11.06a14.71,14.71,0,0,0,1.57-.17c.42-.11.24-.84.24-.84s.91,1.11,1.36.87-.49-1.43-.49-1.43l-4.83-10.64a5,5,0,0,0,1.63-.14c.46-.21.14-1.08.14-1.08a11.44,11.44,0,0,0,1.64-.24c.66-.17-10.16-20.91-10.16-20.91s-.49-1.32-.84-1.32-10.19,20.94-10.19,20.94-.62.87-.17.87-.25,1.08.49,1.25,1.35,1.46,1.35,1.46l-4.38,11.35s-.84,1.18,0,1.35a4.33,4.33,0,0,0,1.56,0l-3.93,7.75s.07.7.56.7-4.42,10.33-4.42,10.33-1.46,1.67.14,2.05a2.92,2.92,0,0,0,2.71-.87s-.45,1.64,1.19,1.64,3.86-2.37,3.86-2.23-1.74,2.92-.63,2.92,2.89-2.81,2.89-2.81-.84,2.15.1,2.15,1.43,0,1.43,0V187h11.58v-7s0,1.32.87,1.22,1.29-1.46,1.29-1.46-.38,1.32.52,1.56,1.64-2.33,1.64-2.33.66,2.72,2,2.72.77-2.51.77-2.51,1,2.89,2.15,2.68.49-2.37.49-2.37,1.88,1.53,2.4,1.53S429.27,179.79,429.27,179.79Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M447.88,180.75l-2.8-6.19a3.62,3.62,0,0,0,.74-.1c.43-.1,1,0,1-.41s-3-6.54-3-6.54a8.14,8.14,0,0,0,.92-.1c.25-.06.15-.49.15-.49s.53.66.8.51-.29-.84-.29-.84l-2.86-6.29a3.11,3.11,0,0,0,1-.08c.27-.12.08-.64.08-.64a6.72,6.72,0,0,0,1-.14c.39-.1-6-12.35-6-12.35s-.29-.78-.5-.78-6,12.37-6,12.37-.37.51-.1.51-.14.64.29.74.8.86.8.86l-2.59,6.7s-.49.7,0,.81a2.67,2.67,0,0,0,.92,0L429,172.9s0,.41.33.41-2.61,6.1-2.61,6.1-.86,1,.08,1.22a1.76,1.76,0,0,0,1.61-.52s-.27,1,.69,1,2.29-1.4,2.29-1.32-1,1.73-.37,1.73,1.7-1.67,1.7-1.67-.49,1.28.06,1.28.85,0,.85,0V185h6.84v-4.15s0,.78.51.72.76-.86.76-.86-.22.78.31.92,1-1.37,1-1.37.39,1.6,1.17,1.6.45-1.48.45-1.48.62,1.71,1.27,1.58.29-1.4.29-1.4,1.11.91,1.42.91S447.88,180.75,447.88,180.75Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M60.81,174.51l-2.29-5.07a3,3,0,0,0,.6-.08c.36-.09.81,0,.81-.34s-2.47-5.35-2.47-5.35a6.71,6.71,0,0,0,.76-.08c.2-.05.11-.41.11-.41s.44.54.66.42-.24-.69-.24-.69l-2.33-5.15a2.42,2.42,0,0,0,.79-.06c.22-.1.06-.52.06-.52a6,6,0,0,0,.79-.12C58.38,157,53.15,147,53.15,147s-.23-.64-.4-.64-4.93,10.13-4.93,10.13-.3.42-.09.42-.11.52.24.6.66.71.66.71l-2.12,5.48s-.41.58,0,.66a2.29,2.29,0,0,0,.75,0l-1.9,3.75s0,.33.27.33-2.14,5-2.14,5-.7.81.07,1a1.4,1.4,0,0,0,1.31-.42s-.21.79.58.79,1.86-1.14,1.86-1.07-.84,1.41-.3,1.41,1.4-1.36,1.4-1.36-.41,1,.05,1,.69,0,.69,0V178h5.6v-3.39s0,.64.42.58.62-.7.62-.7-.18.64.26.76.79-1.13.79-1.13.32,1.31,1,1.31.37-1.21.37-1.21.5,1.4,1,1.29.23-1.14.23-1.14.91.74,1.17.74S60.81,174.51,60.81,174.51Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M37,175.82,33.91,169a4.06,4.06,0,0,0,.82-.11c.47-.12,1.08-.05,1.08-.46s-3.32-7.19-3.32-7.19.74-.05,1-.11.16-.55.16-.55.59.73.89.57-.32-.93-.32-.93l-3.15-6.92a3.53,3.53,0,0,0,1.07-.09c.29-.14.09-.7.09-.7a7.78,7.78,0,0,0,1.06-.16c.43-.12-6.6-13.6-6.6-13.6s-.32-.86-.55-.86-6.63,13.62-6.63,13.62-.4.57-.11.57-.16.7.32.81.88.95.88.95l-2.85,7.38s-.54.76,0,.88a3,3,0,0,0,1,0l-2.56,5.05s.05.45.36.45-2.87,6.72-2.87,6.72-1,1.08.09,1.33a1.91,1.91,0,0,0,1.76-.56s-.29,1.06.77,1.06,2.51-1.54,2.51-1.45-1.13,1.9-.4,1.9,1.88-1.83,1.88-1.83-.55,1.4.06,1.4.93,0,.93,0v4.34h7.53V176s0,.86.57.8.84-.95.84-.95-.25.85.34,1,1.06-1.51,1.06-1.51.43,1.76,1.29,1.76.5-1.63.5-1.63.68,1.88,1.4,1.75.32-1.54.32-1.54,1.22,1,1.56,1S37,175.82,37,175.82Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M49.39,174.51l-2.29-5.07a3.11,3.11,0,0,0,.61-.08c.35-.09.81,0,.81-.34S46,163.67,46,163.67a6.5,6.5,0,0,0,.76-.08c.2-.05.12-.41.12-.41s.43.54.65.42-.23-.69-.23-.69L45,157.76a2.42,2.42,0,0,0,.79-.06c.22-.1.07-.52.07-.52a6.21,6.21,0,0,0,.79-.12C47,157,41.74,147,41.74,147s-.24-.64-.41-.64-4.93,10.13-4.93,10.13-.3.42-.08.42-.12.52.23.6.66.71.66.71l-2.12,5.48s-.4.58,0,.66a2.36,2.36,0,0,0,.76,0L34,168.08s0,.33.26.33-2.13,5-2.13,5-.71.81.07,1a1.41,1.41,0,0,0,1.31-.42s-.22.79.57.79,1.87-1.14,1.87-1.07-.84,1.41-.31,1.41,1.4-1.36,1.4-1.36-.4,1,0,1,.69,0,.69,0V178h5.6v-3.39s0,.64.42.58.63-.7.63-.7-.19.64.25.76.79-1.13.79-1.13.32,1.31,1,1.31.37-1.21.37-1.21.5,1.4,1,1.29.24-1.14.24-1.14.91.74,1.16.74S49.39,174.51,49.39,174.51Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M18.49,178.07,16.2,173a3,3,0,0,0,.61-.08c.35-.09.81,0,.81-.34s-2.48-5.35-2.48-5.35a6.5,6.5,0,0,0,.76-.08c.2-.05.12-.41.12-.41s.44.54.66.42-.24-.69-.24-.69l-2.34-5.14a2.51,2.51,0,0,0,.79-.07c.22-.1.07-.52.07-.52a6.21,6.21,0,0,0,.79-.12c.32-.09-4.91-10.11-4.91-10.11s-.24-.64-.41-.64S5.5,160,5.5,160s-.3.42-.08.42-.12.52.24.6.65.71.65.71l-2.12,5.48s-.4.58,0,.66a2.34,2.34,0,0,0,.76,0l-1.9,3.75s0,.34.27.34-2.14,5-2.14,5-.71.81.07,1a1.43,1.43,0,0,0,1.31-.43s-.22.8.57.8S5,177.19,5,177.26s-.84,1.41-.3,1.41,1.39-1.36,1.39-1.36-.4,1,0,1h.69v3.23h5.61v-3.4s0,.64.42.59.62-.71.62-.71-.19.64.25.76.79-1.13.79-1.13.32,1.31,1,1.31.37-1.21.37-1.21.51,1.4,1,1.3.24-1.15.24-1.15.91.74,1.16.74S18.49,178.07,18.49,178.07Z" transform="translate(0 -104.68)"/><path class="cls-1" d="M0,200H500V172.38s-71,13.81-151.36,13.81S216.22,169,130.39,169,0,182.34,0,182.34Z" transform="translate(0 -104.68)"/></svg>';
		break;
		case 'city' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500.03 104.15" preserveAspectRatio="none"><rect class="cls-1" x="88.19" y="72.08" width="36.08" height="32.08"/><rect class="cls-1" x="90.3" y="64.08" width="33.96" height="40.08"/><rect class="cls-1" x="91.06" y="56.53" width="33.21" height="47.62"/><rect class="cls-1" x="124.26" y="82.34" width="38.34" height="21.81"/><rect class="cls-1" x="206.83" y="49.28" width="24.3" height="54.87"/><rect class="cls-1" x="237.62" y="44.91" width="11.77" height="59.25"/><rect class="cls-1" x="265.7" y="39.47" width="17.21" height="64.68"/><rect class="cls-1" x="278.53" y="62.87" width="8.3" height="41.28"/><rect class="cls-1" y="97.43" width="500.03" height="6.72"/><rect class="cls-1" x="163.83" y="71.21" width="28.3" height="26.23"/><rect class="cls-1" x="155.91" y="55.13" width="12.68" height="42.3"/><rect class="cls-1" x="156.64" y="49.81" width="11.15" height="8.72"/><rect class="cls-1" x="157.75" y="44.6" width="9.25" height="9.25"/><rect class="cls-1" x="159.53" y="41.04" width="3.51" height="4.19"/><rect class="cls-1" x="160.04" y="40.09" width="2.21" height="1.78"/><rect class="cls-1" x="171.6" y="67.45" width="3.57" height="5.15"/><rect class="cls-1" x="168.34" y="68.47" width="19.49" height="5.19"/><rect class="cls-1" x="178.08" y="65.94" width="2.76" height="3.21"/><rect class="cls-1" x="178.25" y="65.45" width="1.92" height="1.02"/><rect class="cls-1" x="142.75" y="76" width="13.15" height="10.04"/><rect class="cls-1" x="144.83" y="74.19" width="4.5" height="5.28"/><rect class="cls-1" x="72.81" y="87" width="17.15" height="12"/><rect class="cls-1" y="95.15" width="10.94" height="4.36"/><rect class="cls-1" y="69.68" width="2.06" height="28.36"/><rect class="cls-1" y="65.94" width="1.49" height="3.74"/><rect class="cls-1" x="191.11" y="82.34" width="18.06" height="17.45"/><rect class="cls-1" x="193.6" y="76" width="15.79" height="8.32"/><rect class="cls-1" x="194.91" y="72.23" width="13.42" height="5.77"/><rect class="cls-1" x="198.81" y="69.51" width="9.85" height="4.15"/><rect class="cls-1" x="199.49" y="66.47" width="8.21" height="3.56"/><rect class="cls-1" x="291.96" y="62.87" width="17.43" height="36.38"/><rect class="cls-1" x="306.91" y="73.13" width="21.06" height="28.3"/><rect class="cls-1" x="321.85" y="70.34" width="12.6" height="28.38"/><rect class="cls-1" x="322.91" y="66.47" width="11.55" height="17.85"/><rect class="cls-1" x="423.51" y="69.74" width="5.96" height="28.98"/><rect class="cls-1" x="429.92" y="69.74" width="11.17" height="29.51"/><rect class="cls-1" x="432.11" y="67.77" width="6.64" height="4.23"/><rect class="cls-1" x="464.04" y="32.53" width="18.42" height="65.28"/><rect class="cls-1" x="478.3" y="81.81" width="6.42" height="17.43"/><rect class="cls-1" x="480.42" y="67.77" width="3.62" height="15.7"/><rect class="cls-1" x="484.34" y="96.11" width="6.91" height="3.55"/><rect class="cls-1" x="486.08" y="95.36" width="1.09" height="1.43"/><rect class="cls-1" x="498.05" y="96.79" width="1.95" height="1.64"/><rect class="cls-1" x="499.38" y="95.8" width="0.62" height="0.91"/><rect class="cls-1" x="493.69" y="96.71" width="2.6" height="1.44"/><polyline class="cls-1" points="10.15 83.6 4.77 86.04 4.77 96.62 10.15 96.62 10.15 83.6"/><polyline class="cls-1" points="34.4 36.45 66.17 44.38 66.17 82.92 66.17 98.04 34.4 98.04 34.4 36.45"/><polygon class="cls-1" points="84.64 85.36 84.64 101.04 65.17 101.04 65.17 83.32 84.64 85.36"/><polygon class="cls-1" points="81.13 83.41 81.13 85.44 66.44 83.75 66.44 81.77 78.61 81.77 78.61 83.24 81.13 83.41"/><polygon class="cls-1" points="125.25 73.13 125.25 82.34 124.26 82.34 124.26 73 125.25 73.13"/><polygon class="cls-1" points="135.34 82.34 135.34 79.47 137.66 79.47 137.66 78.36 136.06 78.36 136.06 77.25 139.47 77.25 139.47 76.47 142.07 76.47 142.07 74.62 145 74.62 145 82.34 135.34 82.34"/><polygon class="cls-1" points="151.94 74.98 150.57 76 153.25 76 151.94 74.98"/><polygon class="cls-1" points="169.89 68.47 170.13 66.26 174.04 57 174.57 57.23 170.74 66.25 170.38 68.47 169.89 68.47"/><polygon class="cls-1" points="187.83 70.03 192.13 71.21 187.83 71.21 187.83 70.03"/><polygon class="cls-1" points="207.7 49.23 214.59 42.53 214.59 41.87 214.09 41.87 214.09 41.36 216.15 41.36 216.15 40.64 224.76 40.64 224.76 38.3 225.26 38.3 225.95 30.53 226.14 38.38 226.72 38.38 226.72 43.51 230.24 47.09 236.09 45.59 236.09 39.28 239.3 38.41 239.3 37.77 242.48 37.77 242.48 35.09 244.24 35.09 244.24 31.17 244.78 31.17 244.78 29.06 245.62 29.06 246.76 25.89 246.76 22.94 247.15 22.94 247.15 12.87 247.53 22.79 247.99 22.79 247.99 26.04 249.06 28.94 249.67 28.94 249.67 31.05 250.32 31.05 250.32 35.43 251.01 35.43 251.01 34.64 251.63 34.64 251.63 35.24 251.63 36.6 252.81 36.6 252.81 38.08 253.38 39.24 255.18 39.09 255.18 38.11 258.78 38.11 258.78 40.09 260.81 41.87 260.81 46 263.95 46.19 265.48 47.7 265.48 67.45 266.51 67.45 266.36 97.43 266.36 101.96 209.42 101.96 207.7 49.23"/><rect class="cls-1" x="10.15" y="36.45" width="24.6" height="67.7"/><rect class="cls-1" x="86.53" y="80.38" width="30.64" height="23.77"/><polyline class="cls-1" points="291.96 62.87 286.83 67.77 286.83 97.43 291.96 97.43 291.96 62.87"/><polyline class="cls-1" points="333.62 66.47 333.62 32.53 336.79 31.93 335.81 29.51 341.4 28.23 341.85 0 342.83 27.7 348.26 29.13 348.26 31.25 351.36 32.53 351.36 68.6 353.32 68.6 353.32 66.47 358.07 66.47 360.42 65.17 373.93 65.17 376.79 65.66 380.49 65.66 380.49 67.77 389.55 67.77 389.55 77.74 399.36 77.06 401.25 78.42 401.25 81.58 402 81.58 402 76.08 403.66 76.08 403.13 73.66 407.89 72.53 410.07 72.68 410.07 75.4 411.81 76 411.81 83.51 414.91 82.19 414.91 67.77 414.91 59.92 416.42 59.92 416.42 57.41 416.42 52.08 419.13 51.32 417.09 50.94 418.15 49.66 419.66 50.26 428.87 41.76 420.94 49.81 420.94 51.32 426.98 51.32 426.98 55.55 427.96 55.92 427.96 59.62 428.87 59.62 428.87 65.17 429.93 65.17 429.93 69.74 429.93 100.15 333.62 100.15 333.62 66.47"/><polyline class="cls-1" points="451.32 97.43 451.32 93.96 449.28 93.96 449.28 93.28 447.87 93.28 447.87 94.19 446.4 94.19 446.4 91.25 444.3 91.25 444.3 89.89 442.32 89.89 442.32 79.47 441.09 79.47 441.09 97.43 451.32 97.43"/></svg>';
		break;
		case 'fallleaves' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 138.97" preserveAspectRatio="none"><defs><style>.cls-2{opacity:0.5;}</style></defs><g id="Layer_3" data-name="Layer 3"><path class="cls-1" d="M0,158.87s61.62-36.53,139.21-36.53,116.22,40.45,219.17,40.45S500,150.42,500,150.42V200H0Z" transform="translate(0 -61.03)"/><path class="cls-2" d="M315.33,94.8c-.45,1-.76,1.73-1.13,2.45a17.55,17.55,0,0,0-1.74,9c.09,1.67,0,3.34,0,5,0,.44,0,.89-.07,1.34a6.35,6.35,0,0,1-.55,2.49,5.06,5.06,0,0,0-.38,1.41c-.38,2-.73,4-1.11,6a58.82,58.82,0,0,1-1.64,6.53,19.85,19.85,0,0,1-2.67,5.35,35.23,35.23,0,0,1-9.59,9.34,22.65,22.65,0,0,1-5.65,2.61,39,39,0,0,1-11.77,2,24.57,24.57,0,0,1-6.55-.78c-2.39-.62-2.13-.72-4.85.27a4.29,4.29,0,0,0-1.43.92l-4.27,4-.94.85-.88-.62,7.14-7.22c-.15-.3-.25-.56-.39-.79-2.11-3.58-2.15-3.82-2.83-8.12a13.2,13.2,0,0,1,0-3.66,14.89,14.89,0,0,0,.07-4.27,4.81,4.81,0,0,1,.16-2.06,54.1,54.1,0,0,1,2-6.18c.4-1,.73-2,1.08-3a7.34,7.34,0,0,1,1.12-2,40.11,40.11,0,0,1,8.22-8.34,23.52,23.52,0,0,1,6.49-3.87c1.23-.56,2.45-1.12,3.66-1.7a6.81,6.81,0,0,1,2.83-.72,6.24,6.24,0,0,0,1.2-.19c.52-.12,1-.25,1.54-.41a38.52,38.52,0,0,1,7.7-1.24c3.13-.28,6.24-.75,9.35-1.15a6.34,6.34,0,0,0,2.91-1.2c.73-.52,1.45-1.06,2.18-1.59Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M182.85,61c.59.91,1.05,1.58,1.46,2.27A17.32,17.32,0,0,0,191,69.63c1.45.83,2.81,1.8,4.21,2.72.38.24.74.51,1.1.78a6.21,6.21,0,0,1,1.8,1.81,5,5,0,0,0,1,1.07l4.46,4.19a57.81,57.81,0,0,1,4.62,4.9,19.74,19.74,0,0,1,3.07,5.12,35.41,35.41,0,0,1,2.7,13.12,23,23,0,0,1-.85,6.17,39.22,39.22,0,0,1-4.64,11,25.31,25.31,0,0,1-4.19,5.1c-1.81,1.67-1.76,1.4-2.39,4.23a4.06,4.06,0,0,0,0,1.7c.36,1.93.73,3.85,1.1,5.78.07.39.13.79.21,1.24l-1,.41c-.75-3.34-1.49-6.6-2.24-9.91-.33,0-.6-.09-.87-.1-4.15-.15-4.37-.25-8.37-2a13,13,0,0,1-3.07-2,14.87,14.87,0,0,0-3.55-2.37,4.76,4.76,0,0,1-1.65-1.24,56.57,56.57,0,0,1-4.15-5c-.61-.87-1.28-1.69-1.93-2.52a7.63,7.63,0,0,1-1.11-2,40.32,40.32,0,0,1-2.6-11.42,23.65,23.65,0,0,1,.25-7.55c.19-1.34.37-2.67.53-4a6.75,6.75,0,0,1,.93-2.76,7.4,7.4,0,0,0,.48-1.12c.18-.5.34-1,.49-1.51a37.56,37.56,0,0,1,3.11-7.16c1.44-2.79,2.72-5.66,4.06-8.49a6.39,6.39,0,0,0,.57-3.11c-.05-.89-.12-1.79-.17-2.68C182.87,61.78,182.87,61.55,182.85,61Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M278.54,120.77a2,2,0,0,0,1.18,1.46,1.22,1.22,0,0,0,1.16,0l1.06-.61,1.19-.74a2.3,2.3,0,0,1,.36.54c.12.34.18.71.29,1.13a3.75,3.75,0,0,0,.75,0,39.13,39.13,0,0,1,5.18-.6c.41,0,.81-.09,1.22-.12a4.48,4.48,0,0,1,1.27,0,2.76,2.76,0,0,1-.25.66,20.58,20.58,0,0,1-1.26,1.69A50.92,50.92,0,0,0,287,128.9c-.13.19-.24.38-.36.57a3.22,3.22,0,0,0-.56,2.54c-.29.2-.57.38-.84.58a8.64,8.64,0,0,0-.95.77,1.13,1.13,0,0,0-.2,1.68,11.19,11.19,0,0,0,.91,1.26c.19.26.42.5.66.78a8.84,8.84,0,0,1-1.41,1,8.25,8.25,0,0,0-2.37,2,2,2,0,0,1-.92.58,7.83,7.83,0,0,0-2.08,1.28,4.18,4.18,0,0,0-1,1.3,1.4,1.4,0,0,0,.12,1.58,7.78,7.78,0,0,0,1.26,1.24,14.67,14.67,0,0,0,3.2,1.77,2.43,2.43,0,0,1,1,.66c.32.4.68.78.58,1.35l1.46.75c-1.92.27-3.64.5-5.35.75-2.5.36-5,.74-7.48,1.11a1.91,1.91,0,0,0-.33.06c-.38.11-.57.43-.38.76.31.55.69,1.05,1,1.57.2.3.56.48.66.93-1.14-.19-2.23-.39-3.33-.55-.88-.13-1.76-.23-2.65-.32a5,5,0,0,0-.77,0,.85.85,0,0,0-.87.71c0,.18,0,.37-.08.65a3.22,3.22,0,0,1-.46-.35q-1.81-1.87-3.62-3.77A14,14,0,0,1,261,151c-1.65-2.15-3.31-4.29-4.91-6.47a2.31,2.31,0,0,0-1.65-1l-1.53-.23a2,2,0,0,0-.67.88q-4.09,6.94-8.18,13.91c-.56,1-1.12,1.92-1.72,2.85a1.9,1.9,0,0,0-.36,1.57,2.08,2.08,0,0,1,0,.56.89.89,0,0,1-.85.39c-.06-.05-.14-.09-.15-.15a6.55,6.55,0,0,1-.2-1c-.11-1.43-.09-1.42,1-2.4a4.56,4.56,0,0,0,.8-1.05q3.69-6.15,7.35-12.33l1.65-2.77c.12-.22.23-.45.37-.72-.3-.18-.56-.31-.79-.48a6.4,6.4,0,0,1-.93-.78,1.45,1.45,0,0,0-1.18-.52c-1.33.09-2.67.11-4,.3a15.6,15.6,0,0,0-4.35,1.31,5.19,5.19,0,0,1-2.81.47,10.72,10.72,0,0,0-2.54.2c-.33,0-.66.12-1,.19a3.43,3.43,0,0,1-2.88-.38.3.3,0,0,1,.24-.42c.9-.18,1.08-.8,1-1.58l0-.23a1.44,1.44,0,0,0-.87-.63,13.45,13.45,0,0,0-1.44-.57,1,1,0,0,1-.77-1.06c0-.34,0-.67,0-1-.23-.18-.45-.38-.7-.54-.46-.3-.92-.61-1.41-.88a37.53,37.53,0,0,1-6.18-4.52,1.89,1.89,0,0,1-.24-.33,7.93,7.93,0,0,1,1.23-.13c.36-.06.73-.08,1.1-.15a6.83,6.83,0,0,0,1.49-.4,15.42,15.42,0,0,1,2.72-1,14.79,14.79,0,0,0,3.75-1.66,4.73,4.73,0,0,0,.86-.69.78.78,0,0,0,.13-1,4.87,4.87,0,0,0-.64-.9,13.84,13.84,0,0,1-2.58-4.38,1.72,1.72,0,0,1-.07-.21c-.14-.49.06-.75.54-.65s.78.21,1.18.3a2.11,2.11,0,0,0,.66,0,.49.49,0,0,0,.42-.56,5.1,5.1,0,0,0-.39-.9c-.18-.36-.52-.64-.52-1s.5-.35.76-.46a1.1,1.1,0,0,0,.8-1.29,5.69,5.69,0,0,0-.27-1.08c-.08-.28-.22-.55-.32-.83-.19-.55-.17-1,.57-1.17a1.2,1.2,0,0,0,.31-.13.52.52,0,0,0,.27-.66,5.83,5.83,0,0,0-.23-.66,48.84,48.84,0,0,0,1-5.42c.3-1.57.62-3.13.94-4.69a1.92,1.92,0,0,1,.25-.44c.12.66.21,1.2.31,1.74,0,.22.11.43.17.65a2.33,2.33,0,0,0,2,1.93l.19.65a2.35,2.35,0,0,0,1.48,1.56,1.49,1.49,0,0,0,1.74-.32c.18-.18.33-.38.51-.58.39.23.42.64.52,1a2.29,2.29,0,0,0,.9,1.23c.48.34,1,.69,1.48,1s.64.27,1.14-.22c.07-.07.16-.13.27-.22,1,2.25,1.79,4.59,3.22,6.61a2.33,2.33,0,0,0,.43.38,1.43,1.43,0,0,0,1.15-1.22c.17-.83.28-1.68.42-2.52s.3-1.68.47-2.51a5.79,5.79,0,0,1,.3-.82c.13.34.19.56.29.75a.71.71,0,0,0,1.1.33,2.83,2.83,0,0,0,1.39-1.66c.22-.79.43-1.58.65-2.36.09-.36.2-.71.33-1.15a2.33,2.33,0,0,1,.48.32c.21.21.37.47.58.67a1,1,0,0,0,1.58,0,3.14,3.14,0,0,0,.87-1.28c.18-.44.37-.87.53-1.27.42-.14.62.15.87.28a1,1,0,0,0,1.39-.21,2.22,2.22,0,0,0,.28-.33,2.29,2.29,0,0,1,1.41-1.17c.25-.06.47-.36.63-.6.62-.92,1.2-1.87,1.84-2.78s1.18-1.52,1.78-2.27a3.59,3.59,0,0,1,.5-.42c.46,2.29.75,4.48,1.14,6.66s.7,4.38,1.21,6.48c.48.38.89-.19,1.34.08s.71-.44,1.2-.06c-.06.24-.1.53-.19.79-.2.56-.45,1.1-.64,1.66a4,4,0,0,0-.23,1c-.08.81.28,1.16,1.11,1.12.33,0,.65-.07.94-.1a.44.44,0,0,1,.12.63c-.24.5-.51,1-.76,1.49s-.41.87-.6,1.31a1.37,1.37,0,0,0,.4,1.7l.53.46c-.32.33-.62.6-.89.91-.75.87-1.52,1.73-2.22,2.64a3.91,3.91,0,0,0-.6,1.29.65.65,0,0,0,.72.86,2.45,2.45,0,0,0,.85-.19,10.29,10.29,0,0,0,1.78-.91c1.32-.9,2.59-1.86,3.88-2.79C277.66,121.38,278,121.13,278.54,120.77Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M388.25,137.37a1.24,1.24,0,0,0,1.06.43.75.75,0,0,0,.62-.35c.12-.22.25-.43.38-.64l.4-.75a1.34,1.34,0,0,1,.36.18,6.07,6.07,0,0,1,.49.51,2.11,2.11,0,0,0,.39-.23,23.39,23.39,0,0,1,2.57-1.87l.61-.43a2.88,2.88,0,0,1,.67-.39,1.91,1.91,0,0,1,.07.43c0,.42-.08.85-.16,1.27a29.51,29.51,0,0,0-.53,3.62l0,.41a2,2,0,0,0,.47,1.51c-.1.2-.19.38-.27.56a4.48,4.48,0,0,0-.27.69.69.69,0,0,0,.39,1,7.34,7.34,0,0,0,.86.39c.18.08.37.14.59.22a4.83,4.83,0,0,1-.46.94,5.11,5.11,0,0,0-.65,1.77,1.27,1.27,0,0,1-.32.59,4.8,4.8,0,0,0-.72,1.29,2.65,2.65,0,0,0-.15,1,.85.85,0,0,0,.54.8,4.56,4.56,0,0,0,1,.28,8.68,8.68,0,0,0,2.22,0,1.43,1.43,0,0,1,.74.05c.29.12.59.21.71.54l1,0-2.61,2-3.64,2.83a.93.93,0,0,0-.15.13.31.31,0,0,0,0,.52c.33.2.68.35,1,.52s.45.08.63.29c-.66.25-1.3.47-1.92.71s-1,.41-1.51.62a3.3,3.3,0,0,0-.41.23.51.51,0,0,0-.24.64,2.16,2.16,0,0,0,.15.36,1.61,1.61,0,0,1-.35,0c-1-.3-2-.6-3.05-.92a6.39,6.39,0,0,1-.83-.31c-1.52-.64-3-1.28-4.54-1.95a1.41,1.41,0,0,0-1.17,0l-.88.34a1.3,1.3,0,0,0-.09.67c-.05,3.27-.11,6.55-.16,9.82,0,.68,0,1.36-.06,2a1.14,1.14,0,0,0,.28.94,1.69,1.69,0,0,1,.17.3.55.55,0,0,1-.33.46c-.05,0-.11,0-.13,0a2.88,2.88,0,0,1-.39-.46c-.49-.72-.48-.72-.22-1.56a2.65,2.65,0,0,0,.11-.79c.08-2.92.14-5.83.21-8.74,0-.66,0-1.31,0-2,0-.15,0-.3,0-.49a3.45,3.45,0,0,1-.57,0,4.34,4.34,0,0,1-.72-.13.86.86,0,0,0-.78.08c-.68.44-1.38.86-2,1.35a9.54,9.54,0,0,0-1.91,2,3.17,3.17,0,0,1-1.35,1.09,6.78,6.78,0,0,0-1.29.87c-.16.12-.31.26-.46.39a2.07,2.07,0,0,1-1.64.66.18.18,0,0,1,0-.29c.42-.37.33-.75.06-1.14l-.08-.12a1,1,0,0,0-.65-.07c-.32,0-.63.07-.94.13a.59.59,0,0,1-.73-.33c-.08-.18-.19-.35-.3-.55l-.53-.08c-.34,0-.68,0-1,0a22.53,22.53,0,0,1-4.63-.55,1.21,1.21,0,0,1-.23-.1,3.85,3.85,0,0,1,.62-.43c.17-.15.36-.27.53-.42a3.45,3.45,0,0,0,.67-.65,9.79,9.79,0,0,1,1.16-1.33,9.14,9.14,0,0,0,1.49-2,2.78,2.78,0,0,0,.25-.62.46.46,0,0,0-.24-.58,2.63,2.63,0,0,0-.61-.29,8.31,8.31,0,0,1-2.67-1.55l-.11-.09c-.22-.22-.19-.41.09-.51l.72-.19a1.56,1.56,0,0,0,.37-.17.29.29,0,0,0,.05-.42,2.92,2.92,0,0,0-.48-.37c-.2-.13-.46-.18-.58-.39s.16-.33.26-.47a.66.66,0,0,0,0-.92,3.56,3.56,0,0,0-.46-.49c-.13-.13-.29-.23-.42-.35s-.39-.48-.05-.79a.48.48,0,0,0,.12-.16.31.31,0,0,0-.05-.43,3,3,0,0,0-.32-.28,29.12,29.12,0,0,0-1.09-3.18q-.46-1.38-.9-2.76a1,1,0,0,1,0-.31l.69.83.29.29a1.42,1.42,0,0,0,1.65.42l.29.29a1.47,1.47,0,0,0,1.25.38.91.91,0,0,0,.83-.69c0-.15.06-.31.09-.46.28,0,.42.21.57.36a1.44,1.44,0,0,0,.85.38c.36,0,.72.07,1.08.08s.41-.05.53-.46c0-.06.05-.12.08-.2a24.19,24.19,0,0,0,3.69,2.54,1.14,1.14,0,0,0,.34.07.88.88,0,0,0,.25-1c-.16-.49-.36-1-.53-1.46s-.35-1-.51-1.48a4.83,4.83,0,0,1-.09-.52,4.41,4.41,0,0,0,.38.31.44.44,0,0,0,.69-.15,1.74,1.74,0,0,0,.23-1.3c-.11-.48-.24-1-.36-1.44-.06-.22-.1-.44-.17-.72a1.62,1.62,0,0,1,.35,0c.18.05.34.14.51.18a.64.64,0,0,0,.85-.46,2,2,0,0,0,.07-.94c0-.28-.07-.57-.1-.83.18-.2.37-.11.54-.11a.61.61,0,0,0,.68-.53,1.09,1.09,0,0,0,.05-.26,1.41,1.41,0,0,1,.4-1,.83.83,0,0,0,.15-.51c.06-.67.07-1.35.14-2s.17-1.16.27-1.74a1.85,1.85,0,0,1,.13-.37c.94,1.07,1.75,2.15,2.61,3.18s1.68,2.12,2.58,3.08c.37.05.41-.37.73-.36s.25-.45.62-.39c0,.14.11.31.14.47.06.36.09.72.16,1.08a2.51,2.51,0,0,0,.16.58c.2.45.5.53.93.26l.47-.33c.21,0,.24.16.25.29,0,.34,0,.68.05,1s0,.58.07.87a.83.83,0,0,0,.72.79l.42.08c-.07.27-.15.51-.2.75-.14.69-.29,1.37-.39,2.06a2.34,2.34,0,0,0,.07.87.39.39,0,0,0,.64.24,1.72,1.72,0,0,0,.4-.36,6.8,6.8,0,0,0,.67-1c.43-.87.81-1.76,1.22-2.65Z" transform="translate(0 -61.03)"/><path class="cls-2" d="M335.77,113.84c.41.62.73,1.07,1,1.54a11.94,11.94,0,0,0,4.62,4.27c1,.55,1.95,1.21,2.91,1.82.26.16.51.35.76.53a4.24,4.24,0,0,1,1.25,1.21,3.4,3.4,0,0,0,.69.73l3.1,2.83a40.15,40.15,0,0,1,3.21,3.31,13.57,13.57,0,0,1,2.15,3.48,24.21,24.21,0,0,1,2,9,15.52,15.52,0,0,1-.52,4.23,26.89,26.89,0,0,1-3.07,7.58,16.83,16.83,0,0,1-2.82,3.53c-1.22,1.17-1.19,1-1.59,2.92a2.71,2.71,0,0,0,0,1.17c.27,1.31.54,2.63.8,3.94.06.27.11.54.16.85l-.68.29-1.63-6.76c-.22,0-.41-.06-.6-.06a10.85,10.85,0,0,1-5.74-1.29,8.86,8.86,0,0,1-2.13-1.33A10.37,10.37,0,0,0,337.2,156a3.35,3.35,0,0,1-1.15-.83,38.63,38.63,0,0,1-2.88-3.38c-.43-.59-.9-1.15-1.35-1.71a5.39,5.39,0,0,1-.78-1.38,27.64,27.64,0,0,1-1.89-7.8,16.1,16.1,0,0,1,.1-5.18c.11-.91.22-1.83.32-2.75a4.77,4.77,0,0,1,.61-1.9,4,4,0,0,0,.32-.77c.12-.34.22-.69.32-1a26,26,0,0,1,2.06-4.93c1-1.92,1.81-3.9,2.7-5.86a4.31,4.31,0,0,0,.36-2.13c-.05-.61-.1-1.22-.14-1.84C335.78,114.35,335.78,114.19,335.77,113.84Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M411.4,135.74c.07.37.12.64.16.92a6.07,6.07,0,0,0,1.28,2.91c.35.46.65,1,1,1.43l.24.4a2.12,2.12,0,0,1,.33.82,1.66,1.66,0,0,0,.17.47c.29.65.58,1.29.86,1.94a18.41,18.41,0,0,1,.82,2.18,6.71,6.71,0,0,1,.29,2,12.22,12.22,0,0,1-.9,4.55,7.87,7.87,0,0,1-1.1,1.85,13.53,13.53,0,0,1-3,2.89,8.64,8.64,0,0,1-2,1.06c-.79.29-.74.21-1.32,1a1.42,1.42,0,0,0-.23.54l-.42,2c0,.14-.07.27-.1.43h-.38l.62-3.46-.27-.15a5.46,5.46,0,0,1-2.4-1.75,5,5,0,0,1-.71-1,5.08,5.08,0,0,0-.82-1.23,1.74,1.74,0,0,1-.36-.62,19.57,19.57,0,0,1-.65-2.14c-.08-.36-.18-.71-.28-1.07a2.68,2.68,0,0,1-.07-.8,13.6,13.6,0,0,1,.7-4,8.09,8.09,0,0,1,1.09-2.37c.24-.4.48-.8.71-1.21a2.27,2.27,0,0,1,.66-.75,2.2,2.2,0,0,0,.31-.3l.36-.41a12.79,12.79,0,0,1,1.95-1.87c.83-.69,1.63-1.44,2.44-2.16a2.21,2.21,0,0,0,.59-.91c.11-.3.21-.59.31-.88Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M139.38,88.82a1.69,1.69,0,0,0,1.34.74,1,1,0,0,0,.88-.37c.21-.26.42-.52.61-.79s.43-.59.67-.93a2,2,0,0,1,.44.3c.2.23.36.48.57.77a3.15,3.15,0,0,0,.56-.24,33.21,33.21,0,0,1,3.74-2.07c.29-.14.58-.31.88-.47a3.85,3.85,0,0,1,1-.4,3.85,3.85,0,0,1,0,.58,15.72,15.72,0,0,1-.43,1.67,40.36,40.36,0,0,0-1.31,4.73c0,.17-.07.35-.09.53a2.65,2.65,0,0,0,.36,2.1c-.16.24-.31.46-.45.69a8.4,8.4,0,0,0-.48.88.94.94,0,0,0,.37,1.34,9.79,9.79,0,0,0,1.08.67c.23.13.47.25.74.38a7.49,7.49,0,0,1-.76,1.18,6.86,6.86,0,0,0-1.17,2.24,1.59,1.59,0,0,1-.52.73,6.38,6.38,0,0,0-1.17,1.61,3.29,3.29,0,0,0-.37,1.3,1.12,1.12,0,0,0,.58,1.15,6.43,6.43,0,0,0,1.33.55,11.89,11.89,0,0,0,3,.35,1.92,1.92,0,0,1,1,.19c.37.2.76.37.86.84l1.33.1-3.81,2.23-5.3,3.16a1.82,1.82,0,0,0-.23.15.42.42,0,0,0,0,.7c.4.31.84.58,1.27.86.24.16.57.18.79.49-.93.21-1.81.4-2.69.62-.7.17-1.4.38-2.1.58a3.32,3.32,0,0,0-.59.24.67.67,0,0,0-.43.8,4.6,4.6,0,0,0,.14.51,3.13,3.13,0,0,1-.46-.11l-3.91-1.73a10.33,10.33,0,0,1-1-.55c-1.91-1.12-3.83-2.21-5.72-3.37a1.86,1.86,0,0,0-1.55-.22l-1.23.3a1.63,1.63,0,0,0-.23.88l-1.86,13c-.13.9-.26,1.8-.42,2.69a1.57,1.57,0,0,0,.22,1.3,1.77,1.77,0,0,1,.18.42.73.73,0,0,1-.52.56c-.06,0-.14,0-.17-.07a6.07,6.07,0,0,1-.44-.68c-.53-1-.52-1,0-2.11a4.12,4.12,0,0,0,.29-1q.87-5.8,1.72-11.6c.13-.87.26-1.73.38-2.6,0-.21,0-.41.07-.66-.29,0-.53-.06-.75-.12a6.17,6.17,0,0,1-1-.3,1.18,1.18,0,0,0-1,0c-1,.48-2,.92-2.92,1.47a12.47,12.47,0,0,0-2.88,2.34,4.31,4.31,0,0,1-2,1.23,8.74,8.74,0,0,0-1.86.93c-.23.14-.45.3-.68.45a2.77,2.77,0,0,1-2.3.6.25.25,0,0,1,.06-.39c.62-.41.56-.93.27-1.5l-.09-.17a1.24,1.24,0,0,0-.86-.2c-.42,0-.84,0-1.26,0a.77.77,0,0,1-.91-.56c-.09-.26-.21-.5-.32-.78a6.06,6.06,0,0,0-.7-.19c-.44-.09-.89-.18-1.34-.23a31.05,31.05,0,0,1-6.08-1.5,3.17,3.17,0,0,1-.27-.17,5.12,5.12,0,0,1,.88-.48c.26-.16.54-.29.78-.46a5.5,5.5,0,0,0,1-.77,12.43,12.43,0,0,1,1.76-1.56,11.78,11.78,0,0,0,2.31-2.42,3.4,3.4,0,0,0,.44-.79.63.63,0,0,0-.22-.81,4,4,0,0,0-.76-.48,11.29,11.29,0,0,1-3.31-2.51l-.12-.14c-.25-.33-.18-.58.21-.66s.66-.08,1-.14a1.89,1.89,0,0,0,.51-.16.4.4,0,0,0,.14-.56,4.31,4.31,0,0,0-.57-.56c-.25-.21-.59-.32-.72-.61s.28-.42.44-.59a.9.9,0,0,0,.2-1.22,4.68,4.68,0,0,0-.53-.73c-.16-.19-.34-.35-.5-.53-.32-.36-.44-.71.06-1.06a.69.69,0,0,0,.19-.19.43.43,0,0,0,0-.58,4.88,4.88,0,0,0-.38-.43,40.19,40.19,0,0,0-.92-4.41c-.26-1.28-.5-2.56-.74-3.84a1.77,1.77,0,0,1,0-.41l.78,1.22c.1.15.22.29.33.43a1.89,1.89,0,0,0,2.13.84l.34.44a1.93,1.93,0,0,0,1.6.71,1.19,1.19,0,0,0,1.21-.78,5.89,5.89,0,0,0,.21-.59c.37,0,.52.35.7.57a1.91,1.91,0,0,0,1.06.65c.47.11.94.21,1.42.28s.56,0,.79-.52c0-.08.09-.15.14-.25a33.9,33.9,0,0,0,4.48,4,3,3,0,0,0,.45.15,1.2,1.2,0,0,0,.49-1.28c-.13-.68-.31-1.36-.46-2s-.3-1.36-.43-2a4.67,4.67,0,0,1,0-.71c.21.22.31.36.45.48a.59.59,0,0,0,.94-.09,2.31,2.31,0,0,0,.53-1.69c-.07-.67-.16-1.33-.24-2,0-.29-.07-.59-.11-1a3,3,0,0,1,.47.09c.22.1.42.24.64.33a.85.85,0,0,0,1.2-.48,2.6,2.6,0,0,0,.26-1.23c0-.39,0-.78,0-1.13.27-.24.51-.08.74-.06a.8.8,0,0,0,1-.58,2.24,2.24,0,0,0,.11-.34,1.91,1.91,0,0,1,.7-1.33,1.09,1.09,0,0,0,.29-.64c.19-.89.32-1.79.53-2.67s.41-1.52.64-2.27a3,3,0,0,1,.24-.47c1.06,1.58,2,3.15,2.93,4.67s1.89,3.1,2.93,4.52c.47.14.61-.42,1-.35s.4-.55.89-.41a5.92,5.92,0,0,1,.1.65c0,.48,0,1,0,1.45a3.7,3.7,0,0,0,.13.81c.19.63.57.79,1.19.5.24-.11.47-.26.68-.37.27.07.29.26.28.44,0,.45-.08.91-.11,1.36s0,.79,0,1.18A1.1,1.1,0,0,0,135,89.4l.54.18c-.14.35-.29.65-.39,1-.3.88-.61,1.77-.86,2.68a3.22,3.22,0,0,0-.06,1.16.53.53,0,0,0,.81.42,2,2,0,0,0,.6-.4,9.64,9.64,0,0,0,1.06-1.24c.71-1.09,1.37-2.21,2.06-3.31C138.91,89.55,139.1,89.25,139.38,88.82Z" transform="translate(0 -61.03)"/><path class="cls-2" d="M45.43,84.47a2.17,2.17,0,0,0,2-.3,1.32,1.32,0,0,0,.63-1.1c0-.44,0-.88,0-1.32s0-1,0-1.52a2.87,2.87,0,0,1,.7,0c.39.08.77.21,1.22.35a3.88,3.88,0,0,0,.4-.71,41.19,41.19,0,0,1,2.27-5.19c.2-.39.36-.81.55-1.21a5.44,5.44,0,0,1,.69-1.19,3.78,3.78,0,0,1,.48.59,21.47,21.47,0,0,1,.89,2.11,56.47,56.47,0,0,0,2.44,6c.1.22.22.43.33.65a3.51,3.51,0,0,0,2.08,1.91c0,.39,0,.75.08,1.1A9.41,9.41,0,0,0,60.38,86a1.24,1.24,0,0,0,1.46,1.12,15.67,15.67,0,0,0,1.68-.17c.35,0,.7-.12,1.09-.19a9.36,9.36,0,0,1,.16,1.86,9,9,0,0,0,.57,3.31,2.06,2.06,0,0,1,0,1.18,8.73,8.73,0,0,0,.06,2.65,4.44,4.44,0,0,0,.67,1.66,1.48,1.48,0,0,0,1.54.75,8.59,8.59,0,0,0,1.85-.5,15.29,15.29,0,0,0,3.41-2A2.69,2.69,0,0,1,74.08,95a1.8,1.8,0,0,1,1.58.19l1.5-1c-.8,2-1.52,3.68-2.22,5.43-1,2.53-2,5.07-3,7.61,0,.11-.09.23-.12.34-.1.42.09.77.51.78.68,0,1.36-.07,2-.12.38,0,.75-.27,1.23-.11-.81,1-1.59,1.88-2.34,2.82-.6.75-1.17,1.53-1.75,2.3A6.65,6.65,0,0,0,71,114a.9.9,0,0,0,.2,1.2,6.19,6.19,0,0,0,.56.42,3.26,3.26,0,0,1-.58.25c-1.84.45-3.68.9-5.52,1.33a13.75,13.75,0,0,1-1.54.26c-2.92.37-5.83.77-8.75,1.07a2.5,2.5,0,0,0-1.81,1l-1.06,1.31A2.21,2.21,0,0,0,53,122q4.29,7.63,8.57,15.27c.59,1.05,1.19,2.1,1.74,3.18a2.05,2.05,0,0,0,1.27,1.19,2.17,2.17,0,0,1,.53.3,1,1,0,0,1-.1,1c-.08,0-.17.09-.23.07a7.13,7.13,0,0,1-1-.36c-1.41-.67-1.39-.68-1.74-2.21a5.24,5.24,0,0,0-.54-1.32q-3.75-6.82-7.54-13.63c-.56-1-1.13-2-1.7-3.06-.13-.23-.29-.46-.47-.74-.33.18-.6.36-.88.48a8.11,8.11,0,0,1-1.25.45,1.54,1.54,0,0,0-1.12.82c-.65,1.29-1.36,2.56-1.9,3.9a16.77,16.77,0,0,0-1.15,4.79,5.72,5.72,0,0,1-1.1,2.9,11.34,11.34,0,0,0-1.2,2.48c-.14.33-.24.68-.36,1A3.74,3.74,0,0,1,40.88,141a.34.34,0,0,1-.26-.46c.32-.94-.16-1.44-.93-1.81l-.23-.1a1.63,1.63,0,0,0-1.07.48,16.29,16.29,0,0,0-1.32,1,1.05,1.05,0,0,1-1.42.14c-.3-.2-.62-.37-1-.57-.3.12-.61.22-.89.36-.54.27-1.08.53-1.6.84a40.61,40.61,0,0,1-7.62,3.32,1.86,1.86,0,0,1-.43.05,7.7,7.7,0,0,1,.54-1.22c.14-.38.33-.74.46-1.12a7.28,7.28,0,0,0,.44-1.61,16.92,16.92,0,0,1,.59-3.08,16,16,0,0,0,.5-4.42,5.35,5.35,0,0,0-.18-1.19.84.84,0,0,0-.89-.67,4.8,4.8,0,0,0-1.19.11,15.23,15.23,0,0,1-5.51,0l-.24-.05c-.54-.14-.67-.47-.31-.86s.63-.62.92-1a2.23,2.23,0,0,0,.41-.59.52.52,0,0,0-.29-.69,5.5,5.5,0,0,0-1.06-.14c-.44,0-.88.14-1.26-.07s0-.66,0-1a1.18,1.18,0,0,0-.77-1.45,6,6,0,0,0-1.16-.35c-.31-.07-.63-.09-1-.15-.62-.12-1-.39-.79-1.17a1.12,1.12,0,0,0,0-.36.55.55,0,0,0-.47-.61,6.9,6.9,0,0,0-.74-.15,52.94,52.94,0,0,0-4.53-3.91Q5.76,117,3.83,115.21c-.11-.09-.15-.25-.28-.47l1.8.66c.23.08.47.13.7.19A2.53,2.53,0,0,0,9,114.76l.71.18A2.59,2.59,0,0,0,12,114.4a1.61,1.61,0,0,0,.65-1.8c-.07-.27-.17-.53-.26-.79.43-.25.82,0,1.19,0a2.53,2.53,0,0,0,1.65-.16c.58-.27,1.17-.54,1.72-.86s.6-.45.42-1.19a3,3,0,0,1-.05-.37c2.66.26,5.28.83,8,.6a3.43,3.43,0,0,0,.59-.2,1.55,1.55,0,0,0-.52-1.74c-.69-.62-1.42-1.19-2.13-1.78s-1.41-1.2-2.1-1.81a8.75,8.75,0,0,1-.6-.73,7.08,7.08,0,0,0,.86.14.78.78,0,0,0,.92-.85,3.09,3.09,0,0,0-.81-2.21c-.61-.64-1.24-1.27-1.85-1.9-.28-.28-.55-.58-.9-.94a4.13,4.13,0,0,1,.56-.28c.31-.08.64-.08,1-.18a1.12,1.12,0,0,0,.88-1.46,3.62,3.62,0,0,0-.72-1.52l-.9-1.19c.09-.47.47-.49.73-.66a1.07,1.07,0,0,0,.57-1.41,2.51,2.51,0,0,0-.16-.46,2.49,2.49,0,0,1-.33-2,1.49,1.49,0,0,0-.21-.91c-.52-1.09-1.11-2.14-1.6-3.24-.43-.95-.79-1.94-1.16-2.92a3.52,3.52,0,0,1-.12-.69c2.4.82,4.61,1.75,6.86,2.57s4.49,1.74,6.74,2.41c.62-.24.31-.94.81-1.21s0-.91.6-1.16c.19.19.44.38.63.61.41.49.79,1,1.21,1.51a4.56,4.56,0,0,0,.78.74c.72.52,1.25.38,1.66-.43.17-.31.29-.65.42-.93a.48.48,0,0,1,.66.23c.33.5.64,1,1,1.52s.59.86.9,1.28a1.48,1.48,0,0,0,1.81.56l.72-.24c.13.48.23.91.37,1.32.4,1.18.79,2.37,1.26,3.52a4.12,4.12,0,0,0,.88,1.28.7.7,0,0,0,1.19-.21,2.46,2.46,0,0,0,.3-.9,12.09,12.09,0,0,0,.12-2.16c-.13-1.73-.33-3.45-.5-5.17C45.52,85.63,45.49,85.15,45.43,84.47Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M318.5,127.68c.08.5.15.87.19,1.24a8.13,8.13,0,0,0,1.64,4c.46.63.86,1.3,1.28,2,.11.18.22.36.32.54a2.78,2.78,0,0,1,.42,1.11,2.63,2.63,0,0,0,.22.65l1.11,2.63a28.22,28.22,0,0,1,1,3,9.2,9.2,0,0,1,.33,2.76,16.63,16.63,0,0,1-1.33,6.11,10.75,10.75,0,0,1-1.54,2.47,18.37,18.37,0,0,1-4.06,3.81,11.47,11.47,0,0,1-2.76,1.37c-1.08.38-1,.27-1.82,1.36a2.12,2.12,0,0,0-.32.72c-.21.89-.41,1.78-.62,2.67q-.08.27-.15.57H312l.92-4.65-.35-.21a7.32,7.32,0,0,1-3.19-2.44,5.8,5.8,0,0,1-.93-1.42,7.1,7.1,0,0,0-1.07-1.69,2.17,2.17,0,0,1-.47-.84,26.74,26.74,0,0,1-.82-2.91c-.09-.49-.22-1-.34-1.45a3.5,3.5,0,0,1-.09-1.07,18.82,18.82,0,0,1,1.06-5.36,11.15,11.15,0,0,1,1.54-3.18c.33-.53.67-1.07,1-1.61a3.25,3.25,0,0,1,.92-1,5,5,0,0,0,.42-.38c.17-.18.33-.37.49-.56a17.87,17.87,0,0,1,2.68-2.46c1.15-.91,2.24-1.89,3.35-2.85a3,3,0,0,0,.83-1.21c.15-.39.29-.79.44-1.18C318.36,128,318.41,127.9,318.5,127.68Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M452.44,119.09a1.66,1.66,0,0,0,1.51.29,1,1,0,0,0,.72-.63c.11-.31.23-.62.33-.94s.22-.69.35-1.09a2.83,2.83,0,0,1,.51.15c.26.15.49.34.78.55a3.67,3.67,0,0,0,.46-.4,30.71,30.71,0,0,1,2.9-3.13c.24-.23.45-.49.69-.72a3.74,3.74,0,0,1,.78-.68,2.07,2.07,0,0,1,.19.54,14.06,14.06,0,0,1,.12,1.72,40.1,40.1,0,0,0,.24,4.9c0,.18,0,.36.07.54a2.61,2.61,0,0,0,1,1.87c-.08.28-.16.54-.22.81a8.05,8.05,0,0,0-.18,1,.94.94,0,0,0,.77,1.16,10.46,10.46,0,0,0,1.23.29c.26.06.53.09.83.14a6.66,6.66,0,0,1-.36,1.35,7.09,7.09,0,0,0-.41,2.5,1.6,1.6,0,0,1-.26.85,6.4,6.4,0,0,0-.61,1.9,3.24,3.24,0,0,0,.06,1.35,1.14,1.14,0,0,0,.91.91,6.32,6.32,0,0,0,1.44.11,11.68,11.68,0,0,0,2.92-.61,2,2,0,0,1,1-.12c.42.08.84.12,1.08.53l1.3-.31-2.92,3.3c-1.36,1.55-2.7,3.11-4.05,4.66a1.92,1.92,0,0,0-.18.22c-.17.27-.12.57.17.67.48.18,1,.29,1.48.43.28.07.6,0,.9.22-.81.49-1.59.94-2.35,1.42s-1.22.8-1.82,1.21a3.72,3.72,0,0,0-.48.41.67.67,0,0,0-.16.9,3.59,3.59,0,0,0,.29.44,2.88,2.88,0,0,1-.47,0l-4.25-.43c-.39,0-.78-.11-1.17-.19-2.16-.46-4.33-.9-6.48-1.41a1.89,1.89,0,0,0-1.54.27l-1.07.67a1.65,1.65,0,0,0,0,.91l2.31,13c.16.89.32,1.79.45,2.69a1.51,1.51,0,0,0,.61,1.16,1.66,1.66,0,0,1,.3.34.74.74,0,0,1-.32.7c-.06,0-.14,0-.18,0a5.2,5.2,0,0,1-.63-.51c-.84-.83-.82-.83-.69-2a4,4,0,0,0-.06-1.08c-.65-3.85-1.32-7.7-2-11.55l-.45-2.6c0-.2-.09-.4-.15-.64a6.38,6.38,0,0,1-.75.12,5.47,5.47,0,0,1-1,0,1.19,1.19,0,0,0-1,.31c-.78.76-1.59,1.48-2.31,2.3a12.8,12.8,0,0,0-2,3.12,4.22,4.22,0,0,1-1.49,1.79,9,9,0,0,0-1.48,1.47c-.18.2-.34.42-.51.64a2.78,2.78,0,0,1-2,1.29.24.24,0,0,1-.07-.39c.46-.59.24-1.06-.22-1.51a1.79,1.79,0,0,0-.14-.13,1.19,1.19,0,0,0-.87.07c-.41.13-.81.25-1.2.41a.78.78,0,0,1-1-.25c-.17-.21-.35-.41-.55-.64-.24,0-.48,0-.72,0-.45.06-.9.11-1.35.21a31,31,0,0,1-6.24.47,2.82,2.82,0,0,1-.32-.07,5.56,5.56,0,0,1,.7-.74c.19-.23.41-.44.6-.68a5.17,5.17,0,0,0,.71-1,12.79,12.79,0,0,1,1.18-2,12.24,12.24,0,0,0,1.45-3,4.28,4.28,0,0,0,.17-.88.63.63,0,0,0-.46-.7A3.91,3.91,0,0,0,426,147a11.47,11.47,0,0,1-3.93-1.35l-.15-.1c-.35-.23-.36-.49,0-.68s.6-.29.89-.45a1.71,1.71,0,0,0,.44-.32.4.4,0,0,0,0-.57,4.36,4.36,0,0,0-.72-.35c-.3-.12-.66-.12-.87-.36s.12-.48.22-.69a.9.9,0,0,0-.19-1.23,4.36,4.36,0,0,0-.73-.52c-.2-.13-.43-.22-.64-.35-.41-.24-.64-.54-.27-1a.77.77,0,0,0,.12-.24.41.41,0,0,0-.18-.55,3.73,3.73,0,0,0-.49-.29,40.26,40.26,0,0,0-2.25-3.91c-.65-1.13-1.28-2.26-1.91-3.4a2.1,2.1,0,0,1-.08-.41l1.12.92c.14.11.3.2.45.31a1.91,1.91,0,0,0,2.28.12l.46.31a2,2,0,0,0,1.75.18,1.23,1.23,0,0,0,.91-1.12c0-.21,0-.42,0-.63.37-.07.59.17.83.32a1.9,1.9,0,0,0,1.22.29,14.16,14.16,0,0,0,1.44-.18c.49-.09.53-.17.58-.74,0-.09,0-.17.06-.28a33.45,33.45,0,0,0,5.5,2.4,2.56,2.56,0,0,0,.48,0,1.17,1.17,0,0,0,.06-1.37c-.34-.6-.72-1.19-1.07-1.79s-.71-1.2-1.05-1.81a6,6,0,0,1-.25-.66,6,6,0,0,0,.58.31.58.58,0,0,0,.86-.38,2.31,2.31,0,0,0,0-1.77c-.28-.6-.57-1.2-.85-1.81-.13-.27-.25-.54-.41-.89a1.74,1.74,0,0,1,.47,0c.24,0,.48.09.72.1a.84.84,0,0,0,1-.82,2.7,2.7,0,0,0-.14-1.26c-.12-.37-.24-.74-.34-1.07.18-.31.45-.23.68-.29a.79.79,0,0,0,.75-.86,1.45,1.45,0,0,0,0-.36,1.94,1.94,0,0,1,.26-1.48,1.14,1.14,0,0,0,.07-.7c-.1-.9-.25-1.8-.33-2.7s-.08-1.57-.11-2.36a4.06,4.06,0,0,1,.09-.52c1.5,1.17,2.85,2.38,4.24,3.52s2.77,2.35,4.2,3.38c.49,0,.45-.59.87-.65s.2-.66.72-.68a6.49,6.49,0,0,1,.29.59c.18.45.31.92.49,1.37a4.17,4.17,0,0,0,.37.73c.38.54.79.57,1.29.1.19-.18.37-.39.52-.56a.35.35,0,0,1,.41.33c.12.44.21.88.33,1.32s.21.76.32,1.14a1.11,1.11,0,0,0,1.15.84H449c0,.37-.06.7-.07,1,0,.94,0,1.88,0,2.81a3.17,3.17,0,0,0,.31,1.13.52.52,0,0,0,.9.15,2,2,0,0,0,.43-.57,8.57,8.57,0,0,0,.62-1.51c.34-1.25.62-2.53.93-3.79C452.22,119.94,452.31,119.59,452.44,119.09Z" transform="translate(0 -61.03)"/><path class="cls-1" d="M67.6,85.06c.35.55.62.94.86,1.35a10.35,10.35,0,0,0,4,3.77c.86.5,1.68,1.08,2.51,1.62l.65.47a3.76,3.76,0,0,1,1.07,1.07,3.25,3.25,0,0,0,.59.64c.88.84,1.78,1.66,2.66,2.5a36,36,0,0,1,2.75,2.91,11.72,11.72,0,0,1,1.83,3.06,20.92,20.92,0,0,1,1.6,7.81,13.42,13.42,0,0,1-.5,3.67,23.5,23.5,0,0,1-2.76,6.55,14.83,14.83,0,0,1-2.5,3c-1.07,1-1,.84-1.42,2.53a2.46,2.46,0,0,0,0,1l.66,3.44c0,.23.08.47.12.74l-.59.24-1.33-5.9-.52-.06a9.48,9.48,0,0,1-5-1.18,7.68,7.68,0,0,1-1.83-1.19,9.06,9.06,0,0,0-2.12-1.4,3,3,0,0,1-1-.74,35,35,0,0,1-2.47-3c-.36-.52-.76-1-1.15-1.51a4.43,4.43,0,0,1-.66-1.21,24,24,0,0,1-1.55-6.8,13.89,13.89,0,0,1,.15-4.5c.11-.79.22-1.59.32-2.38a4,4,0,0,1,.55-1.65,4.39,4.39,0,0,0,.29-.66c.1-.3.2-.6.28-.9A22.81,22.81,0,0,1,65,94.15c.86-1.66,1.62-3.36,2.42-5.05a3.81,3.81,0,0,0,.33-1.85c0-.53-.07-1.07-.1-1.6C67.6,85.51,67.61,85.37,67.6,85.06Z" transform="translate(0 -61.03)"/><path class="cls-2" d="M462.08,79.68c.62.89,1.11,1.53,1.54,2.21A17.61,17.61,0,0,0,470.53,88c1.48.76,2.88,1.68,4.32,2.54.38.23.75.49,1.12.74A6.33,6.33,0,0,1,477.84,93a5.34,5.34,0,0,0,1,1c1.53,1.34,3.09,2.66,4.63,4a57.66,57.66,0,0,1,4.8,4.71,20,20,0,0,1,3.27,5,35.51,35.51,0,0,1,3.2,13,22.71,22.71,0,0,1-.6,6.2A39.57,39.57,0,0,1,490,138.12a25.1,25.1,0,0,1-4,5.25c-1.74,1.75-1.7,1.47-2.22,4.32a4.23,4.23,0,0,0,.07,1.7c.44,1.91.89,3.82,1.32,5.73.09.39.17.79.27,1.23l-1,.45L481.8,147c-.33,0-.6-.06-.88-.06-4.15,0-4.37-.08-8.43-1.67a13,13,0,0,1-3.15-1.86,15.27,15.27,0,0,0-3.64-2.23A4.84,4.84,0,0,1,464,140a56.54,56.54,0,0,1-4.33-4.83c-.65-.84-1.35-1.64-2-2.44a7.86,7.86,0,0,1-1.18-2,40.4,40.4,0,0,1-3-11.31,23.38,23.38,0,0,1-.05-7.56c.13-1.34.26-2.68.38-4a6.82,6.82,0,0,1,.81-2.79,6.55,6.55,0,0,0,.44-1.14c.16-.5.3-1,.43-1.53a37.72,37.72,0,0,1,2.83-7.28c1.33-2.83,2.5-5.75,3.73-8.64a6.37,6.37,0,0,0,.44-3.12l-.27-2.68C462.13,80.43,462.12,80.19,462.08,79.68Z" transform="translate(0 -61.03)"/></g></svg>';
		break;
		case 'fire' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 144.36" preserveAspectRatio="none"><defs><style>.cls-2{opacity:0.5;}</style></defs><g id="Layer_3" data-name="Layer 3"><path class="cls-1" d="M497.51,73c-2-7.8-3.5-8.17-3.82-13.39-.27-4.54.66-7.94,0-8.11s-2,2.36-2.67,4.95c-1.12,4.09.27,5.33-.49,9.74-.35,2-1,5.32-3.65,7.7-1.81,1.61-5,3.18-6.09,2.19s0-3.53,3.57-14.52a14.24,14.24,0,0,0,.73-4.14,10.25,10.25,0,0,0-.24-2.92c-.53-2.11-1.63-2.7-2.51-4.22-1.1-1.88-.38-2.68-.65-9.16-.12-2.87-.41-6.08-.73-6.09s.05,2.5-1.3,5.36-2.84,2.78-3.25,4.86c-.45,2.33,1.28,3,1.06,5.93-.15,2-1.2,4.49-2.6,4.62s-3.17-2.24-3.24-4.38c-.05-1.43.68-1.73.65-3.16-.06-2.38-2.14-4.63-3-4.39s.65,6.58-1.13,7.39c-1.08.49-3.31-1.11-4.14-3.17-.94-2.34.38-4.2,1.22-7.54a26,26,0,0,0,.08-11c-.87-5.46-2.61-5.56-4.46-12.49-1.57-5.88-1.37-9.72-2-9.74s-1.71,3.94-1.71,8.12c0,8.79,4.59,11.1,3,16.06-1.28,4-4.6,3.62-6.66,9.17-.78,2.12-.87,3.76-1.05,7.06-.49,8.94,1.72,11.17-.16,14.68-1.56,2.91-5.26,5.46-8.6,4.71-4-.9-5.55-6-5.68-9.09-.11-2.55.71-5.48,1.62-5.52,1.53-.06,2.66,8.16,3.57,8,.58-.08.67-3.49.49-6.17-.28-4.17-1.05-4.08-3-12.17-.56-2.32-1-4.4-2.27-4.7s-2,1.07-3,.73-1.31-1.9-1.54-4.3c-.37-3.87-.64-6.59.24-10.88.82-4,2-6.28,1.38-6.65-.2-.12-.74-.14-2.92,2.11-4.22,4.36-7.73,8-7.54,12.58.12,3.12,1.86,3.92,1.38,7.46A15.59,15.59,0,0,1,424.93,43c-1.75,3.94-3.74,5.91-3.4,6.25.56.58,6-5.17,7.7-4.06,1.39.92-.3,6.06-1.37,8.68-2.67,6.52-6.79,10.26-5.6,11.85.45.6,1.14.18,1.86.89,1.64,1.6.61,6.18-1.94,9-.7.76-3.24,3.58-6.41,2.92a5.66,5.66,0,0,1-4.22-3.9c-.87-3.37,2.95-5.22,3.73-10.3.45-2.94-.38-5.24-1.3-7.79-2.22-6.15-5.47-6.89-9.73-14.44-1.77-3.13-4-7.93-3-8.68,1.25-.94,6.88,4.93,7.55,4.3.41-.39-1.89-2.44-3.08-5.84-1.91-5.46,1.45-7.52.08-13.23-1.15-4.77-3.83-4.74-4.71-9.73s1.13-8.8.73-8.93-3.11,4.39-3.89,10.39c-.84,6.42,1.39,7.71.81,13-.88,7.93-6.19,7.43-7.3,14.93-1.08,7.28,3.44,11.12.57,18.09-.3.72-1.51,3.64-2.93,3.57-1.69-.08-2.73-4.36-3.08-5.76-2-8.25.29-14.85-.32-15-.45-.12-2.57,3.14-2.6,7.3,0,4.43,2.34,6,1.62,9.9-.35,2-1.51,4.68-3,4.79-2.12.15-4.95-5.05-5.76-10.15-1.25-7.82,3-10.68,2-19.63-.5-4.69-2.19-8.78-2.92-8.68s.46,5.93-1.38,13.14c-2.24,8.76-6.29,8.37-7.3,14.77-1.41,8.9,5.88,12.9,3.32,20.77-1.31,4-4.76,7.67-6.81,7.14-2.47-.64-1.38-6.91-4-16.39-2.78-10.16-8.12-17.93-9.16-17.53s3.19,7.07,2.1,16.56c-.94,8.29-5,11.13-5.67,17.1-.05-.21-.1-.4-.15-.62-1.5-5.87-2.64-6.15-2.87-10.08-.21-3.42.49-6,0-6.11s-1.48,1.78-2,3.73c-.84,3.08.21,4-.37,7.33A9.42,9.42,0,0,1,338,78.36c-1.36,1.21-3.75,2.38-4.58,1.65s0-2.67,2.69-10.94a11.06,11.06,0,0,0,.55-3.12,8.12,8.12,0,0,0-.18-2.2c-.4-1.59-1.24-2-1.9-3.18-.82-1.42-.28-2-.49-6.9-.09-2.16-.3-4.58-.55-4.59s0,1.89-1,4-2.13,2.1-2.44,3.66c-.34,1.75,1,2.3.79,4.46-.11,1.5-.9,3.39-1.95,3.49s-2.39-1.69-2.45-3.3c0-1.08.52-1.3.49-2.39,0-1.79-1.61-3.48-2.26-3.3s.49,5-.85,5.57c-.82.37-2.5-.84-3.12-2.39-.71-1.76.28-3.17.92-5.68a19.73,19.73,0,0,0,.06-8.31c-.66-4.12-2-4.19-3.36-9.41-1.19-4.43-1-7.33-1.53-7.34s-1.29,3-1.28,6.11c0,6.63,3.45,8.37,2.26,12.1-1,3-3.46,2.73-5,6.91a16.28,16.28,0,0,0-.8,5.32c-.37,6.73,1.29,8.41-.12,11.06-1.17,2.19-4,4.11-6.48,3.54-3-.67-4.18-4.53-4.28-6.84-.08-1.93.54-4.13,1.23-4.16,1.15,0,2,6.14,2.68,6.05.44-.06.51-2.62.37-4.64-.21-3.15-.78-3.08-2.26-9.17-.42-1.75-.75-3.32-1.71-3.54s-1.5.8-2.26.55-1-1.43-1.16-3.24a24,24,0,0,1,.18-8.19c.62-3,1.51-4.73,1-5-.15-.09-.56-.11-2.2,1.59-3.18,3.28-5.82,6-5.68,9.47.09,2.35,1.4,3,1,5.62a11.43,11.43,0,0,1-1.1,3.36c-1.32,3-2.81,4.45-2.56,4.71.42.43,4.53-3.9,5.8-3.06,1,.69-.23,4.56-1,6.54-2,4.91-5.1,7.73-4.21,8.92.34.46.86.14,1.4.68,1.24,1.2.46,4.65-1.46,6.78-.52.58-2.44,2.7-4.83,2.2a4.28,4.28,0,0,1-3.18-2.93c-.65-2.55,2.22-3.94,2.81-7.77a11.16,11.16,0,0,0-1-5.86c-1.67-4.64-4.11-5.2-7.33-10.88-1.33-2.36-3-6-2.26-6.54.94-.71,5.18,3.72,5.68,3.24.31-.29-1.42-1.83-2.32-4.4-1.44-4.11,1.09-5.66.06-10-.86-3.6-2.88-3.57-3.54-7.34s.85-6.62.55-6.72-2.35,3.31-2.94,7.82c-.63,4.85,1.05,5.81.62,9.78-.66,6-4.67,5.6-5.5,11.25-.82,5.49,2.59,8.37.42,13.63-.22.54-1.13,2.74-2.2,2.68-1.27-.06-2.06-3.28-2.32-4.33-1.52-6.22.22-11.19-.24-11.31s-1.94,2.37-2,5.5c0,3.33,1.76,4.51,1.22,7.46-.27,1.47-1.14,3.52-2.26,3.6-1.6.12-3.72-3.8-4.34-7.64-.94-5.89,2.25-8,1.53-14.79-.38-3.53-1.65-6.61-2.2-6.54s.35,4.47-1,9.9c-1.69,6.6-4.73,6.3-5.5,11.13-1.06,6.7,4.44,9.71,2.51,15.64-1,3-3.59,5.78-5.14,5.38-1.85-.48-1-5.21-3-12.35-2.09-7.65-6.12-13.5-6.91-13.2s2.41,5.32,1.59,12.47a23.09,23.09,0,0,1-2.85,8.38,11.54,11.54,0,0,1-1.47-4c-.91-5.69,2.59-9.7,1.78-9.92s-5.38,4.41-7.72,10.5c-2.18,5.68-1.27,9.44-3.34,9.83-1.73.31-4.63-1.86-5.74-4.28-2.16-4.72,4-7.12,2.8-12.45-.86-3.84-4.26-3.6-6.15-8.85C211.92,53.52,213,50,212.31,50s-2,2.39-2.46,5.2c-.81,5.37,2.76,7.08,1.71,11.77-.69,3.06-3.06,6.17-4.85,6.08-1.25-.07-2.23-1.7-2.53-2.87-.6-2.35,1.39-3.28,1.37-5.93s-1.81-4.45-2.19-4.38,1.43,4-.27,9c-.29.84-1.17,3.4-2.6,3.45-1.19,0-2.2-1.71-2.45-2.14-2.43-4.18,1.38-6.48.47-10.85s-5.41-4.19-6.14-8.94c-.49-3.16,1.38-3.93.68-7.79-.66-3.59-2.91-6.3-3.28-6.22s1.35,2.36.62,5.35-3,3-4,5.84c-1.15,3.42,1.68,4.65.07,7.92-1,2-2.94,3.27-2.59,3.5.56.39,5.3-3.14,6.35-2.57.84.45-1,3.32-2.53,5.2-3.59,4.52-6.32,5-8.19,8.66-.78,1.52-1.48,2.9-1.1,4.67.66,3,3.87,4.15,3.14,6.17-.42,1.18-2,2.1-3.55,2.34a7.35,7.35,0,0,1-5.39-1.75c-2.15-1.7-3-4.44-1.64-5.4.61-.43,1.19-.18,1.57-.54,1-.95-2.47-3.19-4.71-7.1-.91-1.57-2.33-4.66-1.17-5.2,1.43-.67,6,2.78,6.49,2.43.28-.21-1.39-1.39-2.87-3.75a7.54,7.54,0,0,1-1.22-2.67c-.41-2.12,1-2.6,1.16-4.47.15-2.76-2.8-4.93-6.36-7.54-1.83-1.35-2.29-1.34-2.45-1.27-.53.23.47,1.6,1.16,4a13.7,13.7,0,0,1,.2,6.52c-.19,1.44-.49,2.38-1.3,2.58s-1.58-.6-2.52-.44-1.44,1.43-1.92,2.82c-1.64,4.85-2.29,4.79-2.52,7.29-.15,1.61-.08,3.65.41,3.7.76.07,1.71-4.85,3-4.81.76,0,1.46,1.77,1.37,3.3a5.88,5.88,0,0,1-4.78,5.45,8.24,8.24,0,0,1-7.24-2.82c-1.58-2.11.27-3.45-.14-8.8a9.7,9.7,0,0,0-.89-4.24c-1.73-3.32-4.53-3.1-5.6-5.49-1.33-3,2.53-4.36,2.53-9.63,0-2.51-.87-4.87-1.43-4.86s-.39,2.31-1.71,5.83c-1.56,4.16-3,4.22-3.76,7.49a11.23,11.23,0,0,0,.07,6.62c.71,2,1.82,3.11,1,4.52-.69,1.23-2.57,2.19-3.48,1.9-1.5-.49-.07-4.25-1-4.43-.72-.15-2.47,1.2-2.52,2.63,0,.86.58,1,.54,1.89a3,3,0,0,1-2.73,2.63c-1.18-.08-2.06-1.58-2.18-2.77-.19-1.73,1.26-2.16.88-3.55s-1.59-1.21-2.73-2.92-.85-3.21-1.09-3.21-.51,1.93-.62,3.65c-.23,3.88.38,4.36-.54,5.49-.74.91-1.68,1.27-2.12,2.53a4.5,4.5,0,0,0-.2,1.75,6.65,6.65,0,0,0,.61,2.48c3,6.59,3.83,8.18,3,8.71s-3.6-.35-5.13-1.32A6.82,6.82,0,0,1,115,76c-.64-2.64.53-3.38-.41-5.83-.6-1.55-1.76-3.06-2.25-3s.22,2.14,0,4.86c-.27,3.13-1.54,3.35-3.21,8-.26.71-.45,1.32-.6,1.86a59.76,59.76,0,0,0-1.17-6.22c-1.5-5.88-2.64-6.15-2.87-10.08-.21-3.43.49-6,0-6.11s-1.49,1.77-2,3.72c-.85,3.09.21,4-.37,7.34a9.39,9.39,0,0,1-2.75,5.8C98,77.59,95.56,78.77,94.74,78s0-2.66,2.69-10.94A11.35,11.35,0,0,0,98,64a8.12,8.12,0,0,0-.19-2.2c-.39-1.59-1.23-2-1.89-3.18-.82-1.42-.28-2-.49-6.91-.09-2.15-.3-4.58-.55-4.58s0,1.88-1,4-2.14,2.1-2.44,3.67c-.34,1.75,1,2.3.79,4.46-.11,1.5-.9,3.39-2,3.49S88,61.19,88,59.56c0-1.08.52-1.31.49-2.39,0-1.79-1.61-3.49-2.26-3.3s.48,5-.85,5.56c-.82.37-2.5-.83-3.12-2.38-.71-1.77.28-3.17.92-5.68a19.73,19.73,0,0,0,.06-8.31c-.66-4.12-2-4.19-3.36-9.42-1.19-4.42-1-7.32-1.53-7.33s-1.29,3-1.29,6.11c0,6.62,3.46,8.37,2.27,12.1-1,3-3.47,2.73-5,6.91a16.21,16.21,0,0,0-.79,5.31c-.37,6.74,1.29,8.42-.12,11.07-1.18,2.19-4,4.11-6.48,3.54-3-.68-4.18-4.53-4.28-6.84-.08-1.93.54-4.13,1.22-4.16,1.16,0,2,6.14,2.69,6.05.44-.06.51-2.63.37-4.64-.21-3.15-.79-3.08-2.26-9.17-.43-1.75-.76-3.32-1.71-3.55s-1.5.81-2.26.55-1-1.43-1.17-3.23a24.22,24.22,0,0,1,.19-8.19c.62-3,1.5-4.74,1-5-.15-.09-.56-.11-2.2,1.58-3.18,3.29-5.82,6-5.69,9.48.1,2.35,1.41,3,1,5.62a11.73,11.73,0,0,1-1.1,3.36c-1.32,3-2.82,4.45-2.56,4.71.42.43,4.53-3.9,5.8-3.06,1,.69-.23,4.56-1,6.54-2,4.91-5.11,7.73-4.21,8.92.34.46.86.14,1.4.67,1.23,1.21.46,4.66-1.47,6.79-.52.57-2.44,2.7-4.82,2.2A4.29,4.29,0,0,1,42.7,77c-.65-2.54,2.22-3.93,2.81-7.76a11.16,11.16,0,0,0-1-5.86c-1.67-4.64-4.12-5.2-7.33-10.88-1.33-2.36-3-6-2.26-6.54.94-.71,5.18,3.72,5.68,3.24.31-.3-1.42-1.84-2.32-4.4-1.44-4.11,1.09-5.66.06-10-.86-3.6-2.88-3.58-3.54-7.34s.85-6.63.55-6.72S33,24.09,32.41,28.6c-.63,4.84,1.05,5.81.61,9.78-.65,6-4.66,5.6-5.5,11.25-.81,5.48,2.6,8.37.43,13.62-.22.55-1.13,2.74-2.2,2.69-1.27-.06-2.06-3.28-2.32-4.34-1.52-6.21.22-11.18-.25-11.3s-1.93,2.36-1.95,5.5c0,3.33,1.76,4.51,1.22,7.45-.27,1.48-1.14,3.53-2.26,3.61-1.6.11-3.73-3.8-4.34-7.64-.94-5.89,2.25-8,1.53-14.79-.38-3.53-1.65-6.61-2.2-6.54s.35,4.47-1,9.9c-1.69,6.6-4.73,6.3-5.5,11.12-1.06,6.71,4.43,9.72,2.51,15.65-1,3-3.59,5.78-5.14,5.38-1.86-.48-1-5.21-3-12.35a42.36,42.36,0,0,0-3-7.85V91.19H500V84.53C498.63,81.19,499.14,79.44,497.51,73Z" transform="translate(0 53.17)"/></g><g class="cls-2"><path class="cls-1" d="M499,50.88a1.58,1.58,0,0,0,1,.58v-5.2C498.79,48.36,498.22,49.89,499,50.88Z" transform="translate(0 53.17)"/><path class="cls-1" d="M497.81,24.81c.24.25,1.07-.26,2.19-1.08V20.84C498.52,23.19,497.48,24.48,497.81,24.81Z" transform="translate(0 53.17)"/><path class="cls-1" d="M488.69,71.15A9,9,0,0,1,482,65c-1.38-5.34,4.67-8.26,5.91-16.3.71-4.66-.61-8.3-2.06-12.33-3.52-9.74-8.66-10.91-15.4-22.86-2.8-5-6.33-12.55-4.75-13.74,2-1.49,10.89,7.8,12,6.81.65-.62-3-3.87-4.88-9.25-3-8.64,2.3-11.9.13-20.94-1.82-7.55-6.06-7.5-7.45-15.4s1.78-13.93,1.15-14.13-4.92,6.94-6.16,16.44c-1.33,10.16,2.2,12.21,1.29,20.58-1.4,12.55-9.8,11.76-11.56,23.63-1.71,11.52,5.45,17.6.9,28.63-.47,1.14-2.39,5.77-4.63,5.65-2.68-.12-4.33-6.9-4.88-9.11-3.16-13.06.46-23.51-.51-23.75-.71-.19-4.06,5-4.11,11.56,0,7,3.7,9.5,2.56,15.67-.55,3.17-2.39,7.41-4.75,7.58-3.35.24-7.83-8-9.11-16.06-2-12.38,4.75-16.91,3.16-31.08-.79-7.42-3.46-13.89-4.62-13.73s.73,9.38-2.18,20.79c-3.55,13.87-10,13.25-11.56,23.38-2.23,14.09,9.31,20.42,5.26,32.88-2.08,6.33-7.54,12.14-10.78,11.3-3.91-1-2.19-10.94-6.33-25.94-4.4-16.09-12.86-28.38-14.5-27.75s5,11.19,3.32,26.21c-1.49,13.12-7.91,17.62-9,27.07-.08-.33-.16-.64-.24-1-2.37-9.3-4.18-9.74-4.54-16-.33-5.41.77-9.5,0-9.67s-2.35,2.82-3.17,5.9c-1.33,4.88.33,6.34-.58,11.61a14.89,14.89,0,0,1-4.36,9.19c-2.15,1.92-5.93,3.77-7.25,2.61s0-4.22,4.26-17.31a17.33,17.33,0,0,0,.87-4.94,12.7,12.7,0,0,0-.28-3.48c-.64-2.52-2-3.17-3-5-1.3-2.24-.44-3.16-.78-10.92-.14-3.42-.47-7.25-.87-7.26s0,3-1.58,6.33-3.37,3.32-3.86,5.79c-.54,2.77,1.58,3.64,1.25,7.06-.17,2.38-1.42,5.37-3.09,5.53s-3.78-2.68-3.87-5.23c0-1.71.82-2.06.77-3.78,0-2.83-2.55-5.51-3.58-5.22s.78,7.91-1.34,8.81c-1.3.59-4-1.33-4.94-3.78-1.12-2.79.44-5,1.46-9a31,31,0,0,0,.09-13.15c-1-6.53-3.16-6.64-5.32-14.9-1.88-7-1.58-11.6-2.42-11.62s-2,4.75-2,9.67c0,10.5,5.47,13.25,3.58,19.16-1.58,4.74-5.47,4.32-7.91,10.93a25.92,25.92,0,0,0-1.27,8.42c-.58,10.66,2,13.32-.19,17.51-1.85,3.47-6.33,6.51-10.25,5.6-4.75-1.06-6.62-7.17-6.78-10.82-.13-3.06.86-6.54,1.95-6.59,1.82,0,3.16,9.72,4.24,9.58.7-.1.81-4.15.59-7.35-.34-5-1.24-4.87-3.58-14.51-.67-2.77-1.19-5.26-2.71-5.6s-2.37,1.26-3.58.87-1.58-2.27-1.83-5.13a38.11,38.11,0,0,1,.28-13c1-4.75,2.39-7.49,1.59-7.92-.24-.14-.89-.17-3.49,2.52-5,5.19-9.21,9.49-9,15,.15,3.72,2.22,4.75,1.59,8.89A18.17,18.17,0,0,1,291.53,34c-2.08,4.75-4.44,7-4,7.46.67.68,7.17-6.18,9.18-4.85,1.59,1.09-.36,7.22-1.58,10.35-3.17,7.78-8.07,12.24-6.66,14.12.53.73,1.36.22,2.21,1.08,2,1.9.73,7.36-2.31,10.73-.82.92-3.86,4.27-7.64,3.48a6.77,6.77,0,0,1-5-4.63c-1-4,3.52-6.24,4.45-12.3a17.65,17.65,0,0,0-1.58-9.28c-2.65-7.34-6.51-8.23-11.6-17.22-2.11-3.74-4.75-9.5-3.58-10.35,1.49-1.13,8.2,5.89,9,5.13.49-.46-2.25-2.9-3.67-7-2.28-6.5,1.72-9,.09-15.83-1.36-5.69-4.56-5.65-5.6-11.61s1.34-10.48.87-10.64S260.29-12.12,259.36-5c-1,7.67,1.66,9.19,1,15.48-1,9.49-7.39,8.86-8.71,17.8-1.3,8.69,4.1,13.25.67,21.58-.35.85-1.79,4.34-3.49,4.24-2-.09-3.26-5.19-3.67-6.85-2.4-9.85.35-17.72-.38-17.91s-3.07,3.76-3.16,8.71c0,5.27,2.78,7.14,1.93,11.81-.43,2.33-1.81,5.57-3.58,5.7-2.53.19-5.89-6-6.87-12.1-1.49-9.32,3.56-12.66,2.42-23.41-.6-5.58-2.61-10.46-3.48-10.35s.55,7.08-1.58,15.67c-2.68,10.45-7.49,10-8.71,17.62-1.68,10.6,7,15.37,4,24.75-1.58,4.83-5.68,9.15-8.13,8.52-2.93-.76-1.58-8.25-4.75-19.55-3.31-12.11-9.69-21.37-10.94-20.89s3.82,8.42,2.52,19.74a36.74,36.74,0,0,1-4.51,13.26,18.38,18.38,0,0,1-2.33-6.41c-1.44-9,4.1-15.35,2.82-15.7s-8.52,7-12.22,16.62c-3.45,9-2,14.94-5.29,15.56-2.73.49-7.32-3-9.08-6.78-3.42-7.47,6.33-11.27,4.43-19.7-1.36-6.08-6.74-5.7-9.73-14-2.46-6.85-.68-12.36-1.84-12.47s-3.17,3.78-3.89,8.23c-1.29,8.5,4.36,11.2,2.7,18.63-1.09,4.84-4.84,9.76-7.67,9.62-2-.11-3.53-2.69-4-4.54-.95-3.72,2.2-5.19,2.17-9.39s-2.87-7-3.47-6.93,2.27,6.41-.42,14.24c-.46,1.33-1.86,5.39-4.12,5.46-1.88,0-3.48-2.7-3.88-3.38-3.84-6.62,2.19-10.26.75-17.18s-8.57-6.63-9.72-14.15c-.78-5,2.18-6.22,1.07-12.33-1-5.68-4.6-10-5.19-9.84s2.14,3.73,1,8.47-4.74,4.74-6.33,9.24c-1.82,5.41,2.66,7.36.11,12.54-1.58,3.16-4.65,5.17-4.1,5.54.89.61,8.39-5,10.06-4.07,1.32.71-1.59,5.25-4,8.23-5.68,7.15-10,7.91-13,13.71-1.24,2.4-2.35,4.59-1.74,7.39,1,4.75,6.12,6.57,5,9.76-.67,1.87-3.17,3.33-5.62,3.71a11.58,11.58,0,0,1-8.53-2.77c-3.41-2.69-4.75-7-2.6-8.55,1-.68,1.88-.28,2.48-.85,1.59-1.51-3.9-5-7.45-11.24-1.44-2.49-3.69-7.38-1.85-8.23,2.26-1.06,9.49,4.4,10.27,3.84.44-.33-2.2-2.2-4.54-5.93A11.7,11.7,0,0,1,98.18,41c-.65-3.35,1.66-4.11,1.83-7.07.24-4.37-4.43-7.81-10.06-11.94-2.9-2.14-3.63-2.12-3.88-2-.84.37.74,2.53,1.83,6.33a21.59,21.59,0,0,1,.32,10.32c-.3,2.28-.77,3.77-2.06,4.09s-2.5-1-4-.7-2.27,2.26-3,4.46c-2.6,7.68-3.63,7.59-4,11.54-.24,2.55-.13,5.78.65,5.86,1.2.11,2.7-7.68,4.74-7.61,1.21,0,2.31,2.8,2.17,5.22a9.32,9.32,0,0,1-7.56,8.63A13,13,0,0,1,63.69,63.6c-2.5-3.34.42-5.46-.22-13.93A15.38,15.38,0,0,0,62.06,43c-2.74-5.25-7.17-4.91-8.87-8.69-2.1-4.75,4-6.9,4-15.24,0-4-1.38-7.71-2.27-7.69s-.61,3.65-2.7,9.22c-2.47,6.59-4.75,6.68-5.95,11.86a17.67,17.67,0,0,0,.11,10.48c1.12,3.16,2.88,4.92,1.58,7.15-1.09,2-4.07,3.47-5.51,3-2.37-.78-.11-6.73-1.58-7-1.14-.24-3.91,1.9-4,4.16,0,1.36.92,1.58.85,3a4.75,4.75,0,0,1-4.32,4.17C31.56,57.24,30.16,54.86,30,53c-.3-2.74,2-3.42,1.4-5.62S28.85,45.45,27,42.74s-1.34-5.08-1.72-5.08-.81,3.05-1,5.78c-.37,6.14.6,6.9-.86,8.69-1.17,1.44-2.66,2-3.35,4a7,7,0,0,0-.32,2.77,10.34,10.34,0,0,0,1,3.93c4.74,10.43,6.06,12.94,4.74,13.78s-5.69-.55-8.11-2.09a10.76,10.76,0,0,1-4.86-7.31c-1-4.18.83-5.35-.65-9.23-1-2.45-2.79-4.84-3.56-4.75s.34,3.39,0,7.7c-.43,4.95-2.44,5.3-5.09,12.66-.41,1.12-.71,2.09-1,2.94A94.18,94.18,0,0,0,.45,66.69C.3,66.09.15,65.52,0,65v26.2H500V65.06a16.66,16.66,0,0,1-1.16,1.47C497.73,67.73,493.71,72.2,488.69,71.15Z" transform="translate(0 53.17)"/></g></svg>';
		break;
		case 'sphere' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 64" preserveAspectRatio="none"><rect class="cls-1" y="165" width="500" height="36" transform="translate(500 229) rotate(180)"/><circle class="cls-1" cx="249.5" cy="28.5" r="28.5"/></svg>';
		break;
		case 'music' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1019.61 199.55" preserveAspectRatio="none"><g id="Layer_1-2" data-name="Layer 1"><path class="cls-1" d="M1019.61,100.55v99H1.61v-61s82.09.89,186,12c117.81,12.59,222,30,371,30C758.86,180.55,1019.61,100.55,1019.61,100.55Z" transform="translate(0 0)"/><path class="cls-1" d="M977.91,66.58A1082.81,1082.81,0,0,1,800,129.05a1103.85,1103.85,0,0,1-186.87,31,1087.21,1087.21,0,0,1-189.06-1.43q-46.83-4.51-93.12-13.24c-31.91-6-63.29-14.21-94.79-22.08C173.41,107.66,106,93.15,41.79,108.39a205,205,0,0,0-23.28,7c-1.14.42,5.2,2.07,5.65,2.16,2.7.56,7.64,2.19,10.41,1.17,63.4-23.31,130.23-11,193.72,4.87,32.08,8,64.08,16.22,96.56,22.49q46.74,9,94.09,14.21A1119.76,1119.76,0,0,0,607,164.89a1115.65,1115.65,0,0,0,185.79-26.84,1085,1085,0,0,0,179.32-58.5q11-4.69,21.91-9.63c1.15-.52-5.18-2.07-5.64-2.16-2.49-.52-7.88-2.32-10.42-1.18Z" transform="translate(0 0)"/><path class="cls-1" d="M16.75,82.12c35.91-44.88,100-54,153.37-43,33.33,6.84,65.35,18.93,97.75,29.12a923.4,923.4,0,0,0,95.61,24.51,958.74,958.74,0,0,0,195.38,18.94A918.15,918.15,0,0,0,753.27,89.51C819.46,74.58,882.5,51.05,944.7,24.27q12-5.19,24-10.42c1.16-.5-5.18-2.07-5.64-2.16-2.53-.53-7.83-2.3-10.41-1.18-62.9,27.32-126,53.34-192.65,70.16A906.28,906.28,0,0,1,564.39,107.8c-65.4,1.9-131.13-3.1-195.31-15.92A871.81,871.81,0,0,1,272.75,66.7c-32.34-10.41-64.48-21.77-97.87-28.65-54-11-117.18-11.67-161.21,26.78A110.92,110.92,0,0,0,0,79.17c-.29.35,7.59,2.28,8.21,2.39C9.64,81.82,15.62,83.56,16.75,82.12Z" transform="translate(0 0)"/><path class="cls-1" d="M895.11.48a618.28,618.28,0,0,1-200.39,71c-1,.17,5.13,2,5.65,2.16,3.19.67,7.12,1.73,10.41,1.18A620,620,0,0,0,911.9,3.43c-.26.14-7.26-2.23-8.21-2.4-2.22-.39-6.42-1.75-8.54-.55Z" transform="translate(0 0)"/><path class="cls-1" d="M414.94,140.19c-18.51,9.08-18,25.6-14.65,30.15,3.8,5.16,15.47,11.44,37,2.55s17.57-22.64,12.38-28.47C443.43,137.36,429.11,133.23,414.94,140.19Z" transform="translate(0 0)"/><polyline class="cls-1" points="450.53 155.67 470.46 43.48 470.48 43.39 453.5 156.12"/><path class="cls-1" d="M469.11,52.28s51.56,14.62,36.55,36L502,92.77S538.31,73,471.08,42.62C469.82,42,469.11,52.28,469.11,52.28Z" transform="translate(0 0)"/><path class="cls-1" d="M842,124.84c-14.85,14.3-9.34,29.89-4.75,33.19,5.2,3.75,18.23,6.16,36.05-8.88s9.81-26.92,3.09-30.9C868.28,113.45,853.41,113.88,842,124.84Z" transform="translate(0 0)"/><polyline class="cls-1" points="880.96 130.69 865.8 19.06 865.66 17.68 883.92 130.21"/><path class="cls-1" d="M102.69,156.32c-19,7.87-19.61,24.4-16.55,29.15,3.46,5.39,14.71,12.4,36.79,4.91s19-21.47,14.18-27.62C131.31,155.32,117.3,150.28,102.69,156.32Z" transform="translate(0 0)"/><polyline class="cls-1" points="137.92 173.17 164.64 63.73 165.01 62.39 140.85 173.81"/><path class="cls-1" d="M918.84,53.55a936.61,936.61,0,0,1-169.11,58.29,956.9,956.9,0,0,1-177.09,25.48,929.8,929.8,0,0,1-178.88-8.2,863.78,863.78,0,0,1-86.57-17.07c-30.71-7.71-60.72-17.78-91.23-26.2C160.06,70.41,96,58.56,40.72,82.91A141,141,0,0,0,23.45,92c.16-.1,7.31,2.24,8.21,2.4,2.13.37,6.51,1.79,8.53.55C64.89,79.78,93.8,73.23,122.6,72.68c30.94-.58,60.9,6.47,90.46,15,29.88,8.6,59.45,18.13,89.66,25.56q44.11,10.86,89.1,17.62a983.1,983.1,0,0,0,177.55,10.72A968.33,968.33,0,0,0,745.24,120,939.16,939.16,0,0,0,914.82,65.86Q924.92,61.53,934.9,57c1.15-.53-5.18-2.07-5.65-2.17-2.48-.51-7.88-2.32-10.41-1.17Z" transform="translate(0 0)"/><path class="cls-1" d="M18.9,37.74C50.84,26.1,83.62,14,117.9,12.2s68.68,7.63,101.36,16.85q28.53,8,56.41,18.11a49.1,49.1,0,0,0,11.44,2.3c.82.08,6.27.37,3.22-.73a846.52,846.52,0,0,0-112.17-32c-19.06-4-38.43-7.35-57.93-8.06A207.36,207.36,0,0,0,64.8,14.54C43.67,19.54,23.22,27,2.8,34.4c-1.14.42,5.2,2.07,5.65,2.16,2.71.57,7.63,2.19,10.41,1.18Z" transform="translate(0 0)"/></g></svg>';
		break;
		case 'paint' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 500 78.26" preserveAspectRatio="none"><path class="cls-1" d="M0,181.36c35.21,0,8.49-59.62,32.49-59.62S34.91,174,54.08,174s2.41-44.68,22.79-44.68,1.29,63.8,23.63,64c16.67.15,5.8-58.86,26.33-58.86,23.25,0,.6,36.83,21.43,36.83s9.82-48.91,27.32-48.91-9.2,56.75,17.51,56.75-2.86-51.47,23.1-51.47.9,33.25,23.39,33.25c17.59,0,11.25-16.34,24.23-16.34,22.27,0-.07,45.43,23.62,45.43S283.84,130,309.8,130s1.95,49.66,22,49.66,4.92-41.21,22.62-41.21c22,0-1.28,48.76,21.85,48.76,23.8,0-.88-54.29,27.13-54.29,23.54,0,3.95,53.44,27.38,53.67,28,.29.77-58.35,27.64-58.35s7.66,62.66,29.64,62.66c11.19,0,11.91-14.11,11.91-14.11V200H0Z" transform="translate(0 -121.74)"/></svg>';
		break;
		case 'pyramid' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 500 71" preserveAspectRatio="none"><polygon class="cls-1" points="0 11.01 95.5 55.77 152.5 29.06 236 68.19 381.5 0 500 55.53 500 71 0 71 0 11.01"/></svg>';
		break;
		case 'snowflakes' :
			var svgpath = '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 500 133.46" preserveAspectRatio="none"><defs><style>.cls-2{opacity:0.5;}</style></defs><g id="Layer_3" data-name="Layer 3"><path class="cls-1" d="M0,158.87s61.62-36.53,139.21-36.53,116.22,40.45,219.17,40.45S500,150.42,500,150.42V200H0Z" transform="translate(0 -66.54)"/><path class="cls-1" d="M310.1,166.42c-.05-1.25-.11-2.5-.16-3.85,1.86-.23,3.65.11,5.54-.06a22.06,22.06,0,0,0-1.87-3.28c-.61-1-1.26-2.07-1.95-3.21l3.65-2.81c.24.37.46.67.64,1,1.33,2.36,2.67,4.7,3.94,7.09a1.39,1.39,0,0,0,1.57.89,17.16,17.16,0,0,0,3.27-.27L322.11,158l3.55-2.35c.24.32.46.58.64.86q1.6,2.53,3.2,5.08a1.22,1.22,0,0,0,1.09.74c3.41,0,6.83,0,10.24,0l.07-.26a3.57,3.57,0,0,0-.55-.41q-12-6.3-24.09-12.59a1.4,1.4,0,0,0-1.51,0c-2,1.13-4.07,2.21-6.11,3.3-.34.18-.69.34-1.12.56l-1.75-3.22,6-3.58c-1.05-.52-1.94-.88-2.75-1.38a2.89,2.89,0,0,0-3.27-.06,23.52,23.52,0,0,1-2.62,1.1L301.7,143l2.39-1.72-5-2.79c.78-1.27,1.54-2.49,2.35-3.79l5.78,2.45v-3.41l3.4-.2c.05.39.11.72.13,1,.08,1.45.17,2.9.2,4.36a1.22,1.22,0,0,0,.76,1.18c.81.39,1.57.85,2.57,1.4,0-1,0-1.85.05-2.68v-5.42l4.14.29c.09,1.36.19,2.68.27,4,.1,1.8.23,3.6.25,5.41a1.72,1.72,0,0,0,1.06,1.72c6.19,3.31,12.36,6.67,18.53,10l3.73,2a1.88,1.88,0,0,0,1,.25c-1.42-2.94-2.83-5.88-4.29-8.92h-9.59c-.08-1.43-.15-2.74-.23-4.17h6.24c-.73-1.29-1.32-2.43-2-3.49-.16-.24-.7-.29-1.06-.3-2.9-.09-5.81-.15-8.71-.22-.39,0-.77,0-1.31-.08v-3.75c3-.28,5.85-.08,8.94-.34-1-1.79-1.9-3.38-2.86-5.11l5-2.28,2.72,4.54c1.27-2.32,2.44-4.48,3.69-6.77L344,128c-2,3.48-3.87,6.85-5.78,10.25l2.39,3.38,2.93-5.18,3.53,1.65c-1.47,2.57-2.88,5-4.35,7.64l6.19,8.78a1.59,1.59,0,0,0,.25-1.28q-.09-9.76-.21-19.54c0-2.2-.06-4.4,0-6.6a1.36,1.36,0,0,0-.91-1.43c-2.18-1-4.32-2.05-6.48-3.08-.39-.18-.77-.38-1.25-.63.53-1.2,1-2.36,1.59-3.59l7.37,3.21c0-1.36.05-2.52,0-3.67,0-.26-.37-.56-.65-.72-1.63-.93-3.29-1.83-4.94-2.74-.34-.18-.67-.39-1.12-.65.57-1.15,1.13-2.25,1.76-3.52l5,2.86a32.6,32.6,0,0,0,.11-3.63c0-1.13,0-2.26,0-3.48h4.72v7.23l4.14-2.38c.51,1.15,1,2.2,1.47,3.32-1.57,1-3,1.88-4.52,2.72a1.78,1.78,0,0,0-1.12,1.94,21.06,21.06,0,0,1,0,2.41l7.43-2.69c.53,1.18,1,2.29,1.55,3.5-.31.17-.59.36-.89.5-2.42,1.12-4.84,2.25-7.27,3.35a1.26,1.26,0,0,0-.9,1.3q0,13.19-.14,26.38a.86.86,0,0,0,.27.62c1.94-2.77,3.87-5.55,5.86-8.4l-4.31-7.73,3.34-1.52c1.08,1.56,2.13,3.1,3.3,4.78l2.17-3.57c-1.87-3.19-3.74-6.36-5.66-9.62l4.41-2.36c1.18,2.55,2.33,5,3.58,7.73,1-1.67,1.69-3.27,2.62-4.91,1.74.72,3.39,1.56,5.15,2.39l-3.14,5.15,9,.32c.09,1.18.18,2.29.28,3.5l-11.63.51c-.48,1.05-1,2.1-1.53,3.31l5.89.55c.08,1.24,0,2.47-.05,3.79a10.45,10.45,0,0,1-1.07.07c-2.32,0-4.63,0-7-.15a1.65,1.65,0,0,0-1.76,1c-1.22,2.33-2.52,4.61-3.79,6.92-.16.29-.29.6-.54,1.14.52-.25.83-.37,1.12-.53,7.37-4.1,14.73-8.22,22.11-12.29a1.58,1.58,0,0,0,.91-1.58c0-2.55.15-5.1.24-7.65,0-.38.06-.76.1-1.14h4.47v6.86a5.56,5.56,0,0,0,2.53-.94c.17-.1.2-.56.21-.85,0-1.34,0-2.67,0-4v-1.22h4.63v3.1c1.9-.6,3.5-1.51,5.34-2.19l2.43,4.38-5.64,2.83,2.55,1.93c-.44.81-.87,1.59-1.36,2.46a15.27,15.27,0,0,1-2.21-1.18,3.3,3.3,0,0,0-4.18-.16,22,22,0,0,1-2.3,1.07l6.15,4.41c-.61.9-1.2,1.75-1.83,2.66l-2.13-1.15c-1.58-.87-3.18-1.71-4.73-2.63a1.65,1.65,0,0,0-1.84,0c-6.79,3.69-13.6,7.34-20.4,11a15.07,15.07,0,0,0-2.69,1.72c.33,0,.66.11,1,.12,2.51.09,5,.14,7.53.28a1.51,1.51,0,0,0,1.58-.9c.93-1.64,1.93-3.24,2.91-4.84l.67-1.06,4.06,2.17-2.84,4.6c1.44,0,2.68,0,3.92,0,.55,0,.68-.47.87-.84l3.65-7c.18-.34.38-.68.62-1.11l3.85,2.74c-1.08,2.09-2.14,4.12-3.28,6.31,1.65.28,3.17.07,4.76.27a16.5,16.5,0,0,1,0,3.65Z" transform="translate(0 -66.54)"/><path class="cls-1" d="M435.63,166.77c-.17-.85-.34-1.7-.53-2.62,1.26-.36,2.53-.32,3.81-.63a14.84,14.84,0,0,0-1.64-2.06c-.53-.66-1.08-1.29-1.68-2l2.21-2.32c.2.22.39.41.55.61,1.16,1.48,2.33,3,3.46,4.46a1,1,0,0,0,1.18.44,12.37,12.37,0,0,0,2.21-.53L443,159.71l2.19-2c.2.19.38.35.53.52.92,1,1.84,2.1,2.74,3.15a.83.83,0,0,0,.83.39l7-1.09,0-.19a2.82,2.82,0,0,0-.42-.22q-9-3-17.9-6.09a1,1,0,0,0-1,.18c-1.27,1-2.56,1.95-3.85,2.91l-.7.51-1.54-2,3.72-3.1a21.31,21.31,0,0,1-2-.65,2,2,0,0,0-2.26.31,17.67,17.67,0,0,1-1.68,1l-1.27-1.75,1.47-1.43-3.75-1.39,1.21-2.85,4.24,1.07-.36-2.34,2.31-.51c.07.27.15.49.2.72.21,1,.42,2,.6,3a.84.84,0,0,0,.65.73c.6.18,1.17.42,1.92.69-.1-.7-.17-1.28-.26-1.85s-.19-1.24-.28-1.86-.19-1.18-.29-1.86l2.88-.25c.2.93.41,1.82.6,2.72.27,1.23.54,2.46.75,3.69a1.21,1.21,0,0,0,.92,1.08c4.6,1.61,9.2,3.26,13.79,4.9l2.78,1a1.34,1.34,0,0,0,.72.07l-3.9-5.68-6.58,1-.61-2.85,4.29-.66c-.64-.81-1.16-1.53-1.76-2.19-.13-.14-.5-.12-.75-.09-2,.25-4,.52-6,.78l-.91.08L441,146l-.2-1.28c2-.5,4-.68,6.11-1.18-.88-1.12-1.67-2.12-2.51-3.21l3.18-2.1,2.36,2.84c.62-1.74,1.2-3.34,1.81-5.05l3.07.74c-1,2.6-1.92,5.12-2.88,7.66l2,2.07,1.47-3.87,2.6.75c-.74,1.93-1.44,3.78-2.18,5.72l5.19,5.37a1.06,1.06,0,0,0,0-.9c-.73-4.47-1.48-8.94-2.22-13.41-.25-1.51-.51-3-.73-4.53a1,1,0,0,0-.78-.89c-1.6-.45-3.18-.94-4.78-1.42l-.92-.3.71-2.64,5.4,1.42c-.14-.93-.23-1.73-.4-2.52,0-.17-.32-.34-.52-.42-1.22-.47-2.46-.91-3.69-1.36l-.84-.33c.27-.85.54-1.67.84-2.6l3.73,1.43a22.65,22.65,0,0,0-.31-2.51c-.11-.77-.24-1.55-.37-2.39l3.24-.5.77,5,2.59-2.07,1.37,2.12c-1,.82-1.88,1.61-2.82,2.35a1.23,1.23,0,0,0-.56,1.45c.13.49.17,1,.27,1.65l4.82-2.63,1.43,2.24c-.19.15-.36.3-.56.43-1.54,1-3.08,2.07-4.63,3.08a.86.86,0,0,0-.48,1c.91,6,1.8,12.09,2.71,18.14a.57.57,0,0,0,.25.4l3.13-6.4L464,142.47l2.13-1.4,2.77,2.93,1.12-2.68-4.91-6,2.77-2.09,3.29,4.93c.51-1.25.81-2.43,1.27-3.65,1.28.31,2.5.71,3.8,1.09l-1.61,3.87,6.21-.73.56,2.37-7.93,1.59c-.22.77-.45,1.55-.7,2.44l4.11-.25c.18.84.24,1.7.37,2.61-.27.06-.5.13-.73.16-1.6.22-3.19.46-4.79.64a1.14,1.14,0,0,0-1.11.86c-.59,1.73-1.24,3.44-1.87,5.16-.08.21-.13.44-.25.84.33-.23.53-.34.72-.49q6.93-5.4,13.88-10.8a1.1,1.1,0,0,0,.46-1.18c-.25-1.75-.45-3.52-.66-5.28,0-.26,0-.53-.05-.79l3.07-.48.73,4.71a3.66,3.66,0,0,0,1.64-.91c.11-.09.08-.41.06-.61-.14-.92-.29-1.83-.44-2.75l-.13-.84,3.18-.49.33,2.13c1.24-.62,2.25-1.41,3.44-2.08.69.9,1.39,1.79,2.14,2.76l-3.58,2.54,2,1.06-.67,1.84a10.56,10.56,0,0,1-1.65-.59,2.32,2.32,0,0,0-2.89.35,14.43,14.43,0,0,1-1.47,1l4.7,2.38-1,2-1.59-.56c-1.18-.43-2.37-.84-3.54-1.31a1.15,1.15,0,0,0-1.26.19q-6.41,4.89-12.85,9.74a11.21,11.21,0,0,0-1.66,1.46,5.46,5.46,0,0,0,.7,0c1.73-.2,3.47-.44,5.2-.61a1,1,0,0,0,1-.79c.47-1.22,1-2.42,1.49-3.63.1-.25.22-.5.35-.79l3,1-1.47,3.47,2.7-.42c.38-.06.41-.4.51-.67l1.76-5.19c.09-.26.19-.51.31-.83l2.94,1.47c-.53,1.55-1,3.06-1.58,4.69,1.15,0,2.18-.29,3.3-.33a12.23,12.23,0,0,1,.39,2.51Z" transform="translate(0 -66.54)"/><path class="cls-1" d="M178.84,129.7l.36-1.82c.9.1,1.7.46,2.61.59a10.47,10.47,0,0,0-.51-1.75c-.17-.56-.36-1.11-.56-1.72l2-.91c.07.2.14.36.19.54.36,1.25.73,2.51,1,3.77a.69.69,0,0,0,.64.6,8.24,8.24,0,0,0,1.56.23l-.78-2.13,1.93-.71c.07.18.15.33.2.48.31.92.63,1.83.93,2.75.08.22.16.4.43.46l4.81,1.15.06-.11a1.83,1.83,0,0,0-.21-.26l-9.9-8.61a.67.67,0,0,0-.71-.16c-1.08.3-2.16.57-3.24.86l-.59.13-.45-1.7,3.2-1c-.43-.36-.81-.63-1.13-1a1.4,1.4,0,0,0-1.53-.39,11.54,11.54,0,0,1-1.35.22l-.36-1.46,1.32-.53-2-1.88,1.53-1.51,2.44,1.8.38-1.6,1.62.28c0,.19,0,.36-.06.51q-.18,1-.39,2.07a.57.57,0,0,0,.22.64c.34.27.64.58,1.05,1,.12-.48.23-.87.32-1.26s.21-.84.31-1.27l.3-1.27,1.92.6c-.11.65-.22,1.28-.33,1.91-.15.86-.3,1.72-.49,2.56a.84.84,0,0,0,.31.93q3.8,3.38,7.57,6.79l1.52,1.36a.91.91,0,0,0,.45.23c-.33-1.54-.67-3.07-1-4.67l-4.5-1.07.36-2,2.93.7c-.2-.69-.35-1.29-.56-1.86,0-.13-.29-.22-.46-.26-1.35-.37-2.71-.72-4.07-1.08l-.6-.19.21-.89.21-.87c1.42.2,2.76.62,4.23.85-.26-1-.5-1.8-.76-2.72l2.59-.52c.26.81.5,1.58.77,2.44l2.5-2.76,1.77,1.28-3.86,4.17.74,1.85,2-2.1,1.47,1.17-2.9,3.1c.63,1.59,1.27,3.18,1.92,4.81a.77.77,0,0,0,.26-.57l2.1-9.2c.24-1,.46-2.07.72-3.1a.66.66,0,0,0-.27-.77c-.91-.71-1.8-1.45-2.69-2.17l-.52-.44,1.15-1.51,3.1,2.34c.15-.64.31-1.18.4-1.73,0-.12-.11-.31-.22-.41-.66-.62-1.34-1.23-2-1.84-.14-.12-.27-.26-.46-.43l1.22-1.45,2,1.89a16.64,16.64,0,0,0,.46-1.69c.13-.52.25-1.05.39-1.63l2.21.53-.81,3.4,2.21-.65.32,1.72c-.84.27-1.63.54-2.43.77-.43.12-.69.31-.74.78a11,11,0,0,1-.26,1.13l3.79-.42.33,1.81-.47.14-3.79.75a.62.62,0,0,0-.57.52c-1,4.12-2,8.24-3,12.36a.41.41,0,0,0,.06.32l3.69-3.28c-.38-1.35-.76-2.7-1.15-4.11l1.74-.34,1,2.61,1.42-1.43c-.52-1.71-1-3.41-1.58-5.15l2.34-.62c.26,1.33.52,2.62.81,4,.66-.66,1.16-1.34,1.78-2,.74.54,1.42,1.12,2.15,1.71l-2,2.06,4.18,1.16-.26,1.67-5.51-1.06-1.1,1.38,2.71.92c-.1.59-.29,1.16-.45,1.77-.19,0-.35,0-.51-.08-1.09-.28-2.17-.55-3.25-.85a.78.78,0,0,0-.94.26c-.83,1-1.7,1.88-2.55,2.82-.11.12-.2.25-.38.47l.58-.12,11.76-3.29a.75.75,0,0,0,.61-.63c.3-1.2.64-2.38,1-3.57.05-.18.11-.35.17-.53l2.1.51-.77,3.22a2.62,2.62,0,0,0,1.29-.16c.1,0,.16-.24.2-.38.15-.62.29-1.25.44-1.88,0-.18.09-.36.14-.57l2.17.52-.35,1.45c1-.07,1.82-.31,2.76-.42l.65,2.33-3,.69,1,1.19-.91,1a7.35,7.35,0,0,1-.91-.81,1.61,1.61,0,0,0-2-.54,9.39,9.39,0,0,1-1.2.24l2.4,2.77-1.16,1-.87-.78c-.65-.59-1.3-1.16-1.93-1.77a.81.81,0,0,0-.86-.21c-3.6,1-7.21,1.92-10.81,2.88a7.65,7.65,0,0,0-1.46.5,3.61,3.61,0,0,0,.46.17c1.17.33,2.34.63,3.5,1a.72.72,0,0,0,.84-.25c.62-.66,1.28-1.3,1.92-1.94.13-.14.27-.26.43-.42l1.66,1.47L211,135.4l1.84.44c.26.06.37-.14.5-.3.84-.95,1.67-1.91,2.5-2.87l.41-.45,1.51,1.72-2.25,2.6c.74.31,1.48.39,2.2.66a8,8,0,0,1-.4,1.71Z" transform="translate(0 -66.54)"/><path class="cls-1" d="M27.64,148.65l-1.05-2.86c1.35-.62,2.78-.8,4.16-1.38a16.55,16.55,0,0,0-2.2-2c-.71-.65-1.45-1.26-2.25-1.95l2.08-3c.26.22.5.39.72.59,1.57,1.46,3.15,2.9,4.68,4.39a1.11,1.11,0,0,0,1.4.3,13.25,13.25,0,0,0,2.39-1l-2.92-2.32,2.11-2.63c.26.19.49.33.69.5q1.83,1.51,3.64,3.05a1,1,0,0,0,1,.29c2.56-.84,5.14-1.65,7.71-2.48v-.21a3.2,3.2,0,0,0-.52-.18l-21.18-3.66a1.12,1.12,0,0,0-1.13.38c-1.25,1.34-2.54,2.65-3.81,4-.21.22-.43.42-.71.69l-2.09-2L24,133c-.92-.14-1.68-.19-2.4-.38a2.32,2.32,0,0,0-2.48.75,18.75,18.75,0,0,1-1.71,1.46l-1.73-1.74,1.39-1.87-4.45-.9c.28-1.14.56-2.24.85-3.41l4.95.45-.82-2.57,2.51-1c.13.28.26.51.35.76.41,1.07.83,2.14,1.2,3.23a.94.94,0,0,0,.86.7c.7.1,1.39.27,2.27.44-.23-.77-.41-1.4-.61-2s-.43-1.36-.65-2-.41-1.29-.66-2l3.2-.78c.39,1,.79,2,1.16,2.94.51,1.34,1,2.66,1.5,4a1.36,1.36,0,0,0,1.21,1c5.46,1,10.92,2,16.37,3.07l3.3.61a1.4,1.4,0,0,0,.82-.05L45,128l-7.23,2.31c-.4-1.06-.77-2-1.18-3.08l4.7-1.51c-.86-.8-1.58-1.51-2.36-2.14-.17-.14-.59,0-.86,0-2.21.63-4.41,1.29-6.62,1.94l-1,.25L30,124.36,29.58,123c2.16-.93,4.39-1.48,6.65-2.41-1.19-1.11-2.24-2.1-3.39-3.16l3.21-2.93,3.15,2.77c.39-2.06.75-4,1.14-6l3.58.29c-.64,3.1-1.25,6.1-1.88,9.12l2.62,2c.33-1.61.64-3.07,1-4.61l3.05.39c-.48,2.29-.94,4.5-1.43,6.81L54,130.32a1.24,1.24,0,0,0-.13-1Q51.47,122,49,114.63c-.55-1.65-1.11-3.3-1.63-5a1.08,1.08,0,0,0-1-.86c-1.87-.22-3.75-.49-5.62-.75l-1.09-.17c.11-1,.21-2,.33-3.09l6.32.63c-.32-1-.57-1.9-.9-2.75-.07-.19-.41-.34-.66-.39-1.45-.31-2.92-.58-4.38-.87l-1-.22c.16-1,.31-2,.48-3.07l4.45.94a27,27,0,0,0-.79-2.76c-.26-.85-.54-1.69-.84-2.62l3.55-1.14L48,98l2.54-2.79,1.91,2.14c-.95,1.1-1.82,2.15-2.75,3.14a1.41,1.41,0,0,0-.37,1.73,16.8,16.8,0,0,1,.59,1.81l4.95-3.82c.68.77,1.32,1.48,2,2.27-.19.2-.36.41-.55.59-1.55,1.43-3.1,2.86-4.66,4.27a1,1,0,0,0-.37,1.21q3.15,9.93,6.26,19.89a.69.69,0,0,0,.36.41c.79-2.56,1.57-5.12,2.38-7.75l-5.11-4.77,2.15-2,3.64,2.81.77-3.22-6.58-5.88,2.75-2.84,4.56,5c.36-1.5.48-2.87.79-4.33,1.48.12,2.93.35,4.46.56-.38,1.54-.73,3-1.13,4.63l6.85-1.92c.35.86.69,1.67,1,2.56l-8.63,3.19c-.11.91-.22,1.82-.35,2.86l4.57-1c.36.91.57,1.86.88,2.87-.3.11-.54.23-.8.31-1.75.53-3.5,1.08-5.26,1.56a1.31,1.31,0,0,0-1.1,1.17c-.35,2-.78,4.08-1.18,6.12-.05.26-.07.52-.13,1,.33-.31.54-.48.71-.67q6.84-7.3,13.69-14.6a1.23,1.23,0,0,0,.3-1.4c-.59-1.93-1.12-3.88-1.67-5.82-.08-.29-.13-.59-.2-.89l3.37-1.08,1.66,5.17A4.36,4.36,0,0,0,82,109.16c.1-.11,0-.47,0-.69-.32-1-.65-2-1-3-.1-.29-.19-.58-.3-.92l3.49-1.12.75,2.34c1.28-.92,2.27-2,3.49-3l2.89,2.72L87.72,109l2.39.84c-.14.72-.27,1.41-.43,2.18a11.09,11.09,0,0,1-2-.36,2.63,2.63,0,0,0-3.19.9,15.59,15.59,0,0,1-1.47,1.35l5.7,1.85c-.25.82-.48,1.6-.73,2.44l-1.89-.35c-1.4-.28-2.81-.52-4.2-.84a1.29,1.29,0,0,0-1.39.44c-4.22,4.41-8.47,8.81-12.7,13.21a11.37,11.37,0,0,0-1.61,1.94c.26-.05.52-.08.78-.15,1.91-.53,3.81-1.1,5.74-1.61a1.2,1.2,0,0,0,1-1.06c.3-1.45.68-2.9,1-4.34l.26-1,3.58.65c-.35,1.39-.68,2.73-1,4.16l3-.95c.41-.14.39-.52.45-.85q.54-3.06,1.06-6.14c0-.3.12-.6.2-1l3.56,1.14c-.31,1.83-.62,3.62-.94,5.55,1.3-.2,2.4-.72,3.65-.95a13.05,13.05,0,0,1,.88,2.74Z" transform="translate(0 -66.54)"/><g class="cls-2"><path class="cls-1" d="M84,91.93l-.76-.65c.44-.53.83-1,1.26-1.52a.66.66,0,0,0,.11-.81,19,19,0,0,0-1-2,4.74,4.74,0,0,0-.15.5c-.41,2.17-.81,4.34-1.24,6.5a.82.82,0,0,0,.34.94c.57.41,1.11.87,1.69,1.34l-.54,1L81.88,96a3.56,3.56,0,0,0-.33,1.35c0,.13.16.31.29.41.44.36.91.68,1.4,1l-.72.7-1.21-.78L81,99.84l-1.17-.22L80,98.49l-1.37.09-.14-.94,1.76-.3.29-1.52-2.33.27-.25-.91c.81-.26,1.56-.52,2.33-.75a.69.69,0,0,0,.55-.61c.39-2.35.8-4.7,1.21-7.06a2.2,2.2,0,0,0,0-.3,6.67,6.67,0,0,0-1,1c-.32.32-.64.66-1,1l.68,2.39-1,.26c-.1-.36-.17-.71-.29-1-.06-.14-.2-.33-.33-.36a.69.69,0,0,0-.45.21A.89.89,0,0,0,78.4,91c.33.8.59,1.64.92,2.54l-1.25.36-.72-2.13-1,1.07-1.16-.93,1.06-1.11c-.84-.32-1.69-.31-2.52-.59l.2-1.06a3.23,3.23,0,0,1,.44,0c.71.1,1.42.16,2.11.31A.94.94,0,0,0,77.54,89l.26-.35-1.72-.32.11-1a3,3,0,0,1,1.24.06c.5,0,1.06.26,1.48.1s.64-.69.94-1.06l.81-1c-.29,0-.44,0-.57.09-2.12.69-4.24,1.38-6.36,2a.77.77,0,0,0-.61.64c-.12.59-.3,1.16-.46,1.73-.06.22-.14.43-.23.68l-1.12-.28.37-2-.56.1a.67.67,0,0,0-.62.69,8.07,8.07,0,0,1-.19,1l-1.09-.15.07-1-1.67.41-.35-1.14,1.53-.67-.45-.72.54-.61c.63.42,1.21,1,2.13.53l-1.24-1.5.66-.56,1.93,1.51L80,83.85v-.17c-.84-.18-1.68-.38-2.53-.52-.14,0-.36.16-.49.3-.41.45-.81.93-1.24,1.43l-1-.9.91-1.09-1.29-.24L72.65,85l-1-1.06L73,82.4l-1.29-.24a6.62,6.62,0,0,1,.2-1.81l1.57.3-.74-2.06L73.9,78l.39,1.12c.1.28.19.57.28.85.33,1,.33,1,1.5,1l-.47-1.21,1.09-.47c.22.54.45,1,.62,1.54a.89.89,0,0,0,.82.68,23,23,0,0,0,2.41.31c-.1-.1-.2-.22-.31-.31C78.36,80,76.48,78.5,74.62,77a.89.89,0,0,0-.94-.15c-.62.22-1.26.39-1.93.6l-.33-1,1.76-.68a1.7,1.7,0,0,0-2.29-.6l-.25-.8.71-.43-.58-.5c-.19-.16-.38-.32-.62-.54l.82-.9,1.5,1,.23-.89.93.06-.16,1.07c-.1.79,0,.88.8,1.27l.41-2.17,1.13.33a18.72,18.72,0,0,1-.28,2,1.37,1.37,0,0,0,.61,1.57c1.61,1.25,3.17,2.56,4.76,3.85.17.14.35.26.52.38l.14-.08c-.22-.8-.43-1.61-.68-2.41,0-.12-.27-.22-.43-.26-.51-.12-1-.2-1.56-.3l-.7-.17.15-1.13,1.73.32c-.14-.41-.22-.69-.31-1s-.33-.29-.56-.34l-2.56-.48.21-1.09,2.48.34-.5-1.58L80.29,72l.56,1.38,1.4-1.64,1.07.67-.9,1.07-.71.84c-.64.76-.64.78,0,1.68l1.06-1.2.86.62L82,77.34l1.27,2.79c.09-.26.16-.38.19-.52.41-2.28.8-4.57,1.23-6.85a.85.85,0,0,0-.41-1c-.56-.35-1.07-.78-1.68-1.23l.62-.9,1.87,1.24.14-.46a.8.8,0,0,0-.34-1,14.85,14.85,0,0,1-1.21-1l.65-.88,1.23,1,.48-1.93,1.25.23-.38,2,1.3-.39.25,1a9.25,9.25,0,0,1-1.06.39A1,1,0,0,0,86.59,71a18.94,18.94,0,0,0,2.18-.22l.24,1-2.76.72-1.48,7.78a4,4,0,0,0,.41-.28c.43-.42.84-.86,1.29-1.25a.77.77,0,0,0,.26-1c-.24-.57-.4-1.17-.62-1.82l1-.25.7,1.5.81-.88-1.07-3,1.34-.41.6,2.34,1-1.22,1.28.91-1.12,1.3,2.47.57-.09,1-.56,0-2.11-.3c-.73-.1-.82,0-1.11.78l1.52.5-.25,1c-.7-.14-1.36-.23-2-.39a.83.83,0,0,0-1,.36c-.42.57-.89,1.1-1.44,1.77a4.4,4.4,0,0,0,.5-.09c2.18-.72,4.36-1.46,6.54-2.17a.74.74,0,0,0,.58-.66c.15-.73.35-1.46.54-2.23l1.22.23L95.1,78.4l.86-.15.32-1.68,1.22.24,0,.78c.51.08,1-.21,1.54-.21l.45,1.29-1.7.49.54.71-.43.56a1.93,1.93,0,0,1-.41-.26c-.6-.71-1.27-.53-2-.19l1.44,1.52-.63.65c-.56-.47-1.11-.9-1.65-1.36a.64.64,0,0,0-.68-.15l-6.83,2.17-.32.12a4.21,4.21,0,0,0,1.3.36,3.11,3.11,0,0,0,1.4.21c.4-.13.68-.64,1-1L91,82l1,.77-.92,1.06c.7.44,1.1.39,1.57-.2L94,81.86l.91,1L93.7,84.44l1.27.34-.29,1.53-1.32-.19.63,2-1.25.68c-.23-.77-.42-1.48-.63-2.18s0-.71-1-.84a2.42,2.42,0,0,0-.4,0c.08.23.14.42.21.61s.13.34.23.59l-1.22.54c-.23-.62-.45-1.17-.63-1.74a.71.71,0,0,0-.62-.54A15.6,15.6,0,0,0,86.48,85a3,3,0,0,0,.3.32c1.81,1.51,3.64,3,5.45,4.53a.73.73,0,0,0,.87.13c.57-.24,1.16-.43,1.79-.66l.47.81-1.82.84c.62,1,1.43.54,2.22.35l.39.8-1,.44,1.4,1.16-.81,1.08-1.42-.9-.23.73L93,94.38l.18-1.69-.74-.54-.39,2.06L90.88,94c.09-.65.13-1.31.27-1.95a1.15,1.15,0,0,0-.46-1.29C89.07,89.39,87.5,88,85.9,86.59a1.43,1.43,0,0,0-.61-.34l.83,2.54,2.5.61-.1,1.09-1.71-.19c.06.27.12.46.16.65a.62.62,0,0,0,.56.52c.63.11,1.26.25,1.89.39l.78.19L90,93.15l-2.43-.46.5,1.57-1.44.49L86,93.3l-1.48,1.79-1-.64,2.09-2.59-.49-1.19Z" transform="translate(0 -66.54)"/></g><g class="cls-2"><path class="cls-1" d="M180.52,103.53l-.5-.28c.19-.35.36-.68.55-1a.38.38,0,0,0,0-.47,7.54,7.54,0,0,0-.78-1,2.58,2.58,0,0,0,0,.29c0,1.26,0,2.53,0,3.79a.45.45,0,0,0,.29.49c.36.18.72.38,1.09.58l-.2.59-1.16-.46a2.18,2.18,0,0,0,0,.8c0,.07.12.16.21.2.28.15.58.29.9.44l-.33.47-.76-.31-.06.67H179l-.05-.65-.77.19-.17-.51,1-.36v-.89l-1.29.41-.23-.49c.42-.24.82-.46,1.23-.67a.38.38,0,0,0,.24-.4c0-1.37,0-2.74-.07-4.1a.68.68,0,0,0-.05-.17,4.25,4.25,0,0,0-.46.64c-.15.22-.29.44-.44.68l.63,1.28-.53.25c-.1-.19-.18-.38-.28-.56s-.15-.17-.22-.16a.36.36,0,0,0-.23.16.51.51,0,0,0,0,.62c.28.42.51.86.79,1.33l-.66.33-.63-1.12-.48.72-.75-.4.48-.74c-.51-.09-1,0-1.48-.06V103l.24,0c.41,0,.82-.06,1.22,0a.53.53,0,0,0,.58-.36,1.45,1.45,0,0,1,.11-.23h-1l0-.59a1.77,1.77,0,0,1,.71-.1,2.07,2.07,0,0,0,.84-.1c.2-.13.28-.46.41-.7s.21-.39.35-.66a3.07,3.07,0,0,0-.31.11l-3.36,1.84a.42.42,0,0,0-.28.42c0,.34,0,.68-.07,1,0,.13,0,.26-.06.41l-.66,0v-1.16l-.31.12a.37.37,0,0,0-.27.45,6,6,0,0,1,0,.6l-.63,0-.07-.56-.89.41-.32-.61.79-.54-.33-.36.23-.39c.41.16.8.43,1.26.07l-.86-.71.32-.39,1.24.64,4-2.13,0-.09c-.49,0-1,0-1.48,0-.08,0-.18.13-.24.22-.19.3-.36.61-.54.94l-.65-.41.4-.71h-.75l-.7,1.51-.67-.49.6-1h-.76a4,4,0,0,1-.08-1h.92l-.64-1.08.58-.47c.12.22.23.4.34.59s.16.3.25.45c.28.51.29.51.94.38l-.39-.63.56-.38c.18.28.37.53.51.8a.5.5,0,0,0,.54.29,11,11,0,0,0,1.39-.08l-.21-.14c-1.21-.63-2.43-1.26-3.63-1.9a.5.5,0,0,0-.55,0c-.32.18-.66.35-1,.54l-.28-.5.91-.57a1,1,0,0,0-1.35-.1l-.23-.42.36-.31-.38-.22-.41-.24.37-.6.94.38,0-.52.53-.07c0,.24,0,.43,0,.62,0,.46.07.5.58.63V93.51l.68.06a11.81,11.81,0,0,1,.06,1.18.76.76,0,0,0,.5.81c1.05.53,2.07,1.11,3.1,1.66l.33.16.07-.06c-.21-.43-.41-.86-.64-1.29,0-.06-.17-.09-.27-.09-.3,0-.6,0-.91,0l-.41,0,0-.65h1l-.28-.52c-.08-.14-.22-.13-.35-.13h-1.49V94L176,93.9l-.45-.83.79-.36.46.71.61-1.07.68.26-.4.7c-.1.18-.2.37-.31.55-.28.49-.27.5.18.94L178,94l.55.25-.7,1.26,1,1.44c0-.16,0-.24,0-.32,0-1.33,0-2.66,0-4a.49.49,0,0,0-.34-.54c-.35-.14-.69-.33-1.07-.51l.25-.58,1.18.5c0-.12,0-.19,0-.27a.46.46,0,0,0-.31-.56,7.74,7.74,0,0,1-.78-.43l.27-.56.81.44L179,89h.74v1.16l.69-.35.24.51a5.7,5.7,0,0,1-.55.33.56.56,0,0,0-.35.78c.42,0,.77-.29,1.2-.35l.25.54-1.48.7v4.54a1.83,1.83,0,0,0,.2-.21c.2-.28.38-.57.59-.84a.44.44,0,0,0,0-.6c-.19-.29-.35-.61-.54-1l.53-.25.55.77.36-.58-.92-1.58.7-.37.59,1.25.45-.79.81.37-.49.85L184,94l0,.54a2,2,0,0,1-.31,0c-.41,0-.82,0-1.23.06s-.46.07-.54.56l.91.11,0,.6c-.41,0-.79,0-1.16,0a.49.49,0,0,0-.53.31c-.17.36-.38.71-.62,1.15l.28-.1c1.15-.64,2.29-1.29,3.44-1.92a.43.43,0,0,0,.26-.43c0-.44,0-.87.06-1.32h.72v1.13l.47-.18v-1h.71l.06.44c.3,0,.52-.22.85-.28l.39.68-.9.46.37.34-.18.36a.89.89,0,0,1-.26-.11c-.41-.33-.77-.15-1.16.12l1,.7-.28.43c-.37-.2-.73-.39-1.07-.59a.38.38,0,0,0-.41,0c-1.2.66-2.4,1.3-3.61,1.95l-.17.1a2.8,2.8,0,0,0,.77.07c.28,0,.6.08.81,0s.32-.43.47-.66l.24-.37.64.33-.4.7c.44.17.66.09.86-.29s.37-.71.58-1.11l.62.44-.52,1,.75.06v.89l-.76,0,.56,1.06-.63.51-.58-1.16c-.21-.41-.11-.4-.66-.37l-.23,0c.07.13.13.23.19.32l.19.31-.63.44c-.19-.33-.37-.62-.54-.92a.39.39,0,0,0-.41-.23,7.76,7.76,0,0,0-1.26.08c.07,0,.13.11.2.15,1.19.65,2.38,1.3,3.56,2a.44.44,0,0,0,.5,0c.29-.2.61-.37.94-.57l.35.41-.94.66c.45.47.86.16,1.29,0l.3.4-.51.36.91.5-.34.7-.9-.36-.05.44h-.63l-.07-1-.48-.23V104h-.69a10.68,10.68,0,0,1,0-1.13.67.67,0,0,0-.4-.68c-1.05-.59-2.09-1.21-3.14-1.83a.81.81,0,0,0-.38-.12l.74,1.34,1.47.07.06.63-1,.08.16.35a.34.34,0,0,0,.37.22l1.11,0,.45,0v.64H182.6l.45.83-.76.43-.51-.75-.64,1.16-.62-.25.91-1.68-.41-.62Z" transform="translate(0 -66.54)"/></g><g class="cls-2"><path class="cls-1" d="M237.23,105.68l-.38-.76c.52-.27,1-.53,1.48-.77a.55.55,0,0,0,.35-.59,15.74,15.74,0,0,0-.11-1.91,4.19,4.19,0,0,0-.28.34c-1,1.55-2.06,3.11-3.1,4.65a.68.68,0,0,0-.05.84c.31.51.58,1,.88,1.6l-.73.56-1.06-1.51a2.92,2.92,0,0,0-.69,1c-.06.09,0,.29.08.41.23.42.49.83.75,1.28l-.79.31-.68-1-.62.76-.83-.55.46-.84-1.09-.38.21-.78,1.47.35.72-1.09-1.91-.55.11-.8c.72.06,1.39.11,2.06.19a.58.58,0,0,0,.63-.29c1.08-1.71,2.17-3.4,3.26-5.1a2.08,2.08,0,0,0,.08-.24,5.47,5.47,0,0,0-1.1.41l-1.1.47-.26,2.09-.86-.13c0-.32.1-.61.11-.91a.49.49,0,0,0-.13-.39.56.56,0,0,0-.42,0,.74.74,0,0,0-.51.75c0,.73-.07,1.47-.12,2.27l-1.09-.13.14-1.89-1.16.49-.6-1.1,1.19-.52c-.55-.52-1.22-.8-1.77-1.29l.51-.76c.1,0,.23.09.34.15.52.31,1,.59,1.54.93a.8.8,0,0,0,1,0l.31-.19-1.23-.82.42-.76a2.48,2.48,0,0,1,1,.46c.38.2.74.54,1.12.56s.72-.33,1.08-.52l1-.53a4,4,0,0,0-.48-.12l-5.62-.49a.65.65,0,0,0-.69.29c-.28.42-.61.81-.92,1.2-.12.15-.25.28-.4.45l-.78-.59.94-1.42-.47-.11a.56.56,0,0,0-.71.33,7,7,0,0,1-.48.74l-.79-.48.36-.74-1.42-.23.1-1,1.41,0-.11-.71.61-.29c.36.53.62,1.18,1.49,1.11l-.48-1.57.7-.23,1,1.81,6.67.67.05-.13c-.6-.41-1.18-.84-1.8-1.23-.1-.06-.33,0-.48.07-.47.22-.93.46-1.43.71l-.46-1,1.07-.55-.92-.61-2.1,1.27-.41-1.14,1.56-.77-.93-.61a5.25,5.25,0,0,1,.76-1.34l1.12.75.1-1.85,1.09-.1c0,.36,0,.68-.06,1l-.06.76c-.07.86-.07.87.84,1.23l0-1.09h1c0,.49,0,1,0,1.4a.74.74,0,0,0,.43.8,17.72,17.72,0,0,0,1.76,1,1.73,1.73,0,0,0-.14-.34c-1-1.77-1.95-3.53-2.9-5.31a.74.74,0,0,0-.68-.42c-.56,0-1.11-.11-1.7-.17l.06-.85,1.58,0c-.14-.9-.76-1.17-1.57-1.22l.06-.7.69-.1L233,87c-.1-.19-.19-.38-.31-.62l.94-.44.85,1.25.47-.62.7.35-.47.78c-.34.58-.33.67.2,1.25l1-1.55.78.62a16.93,16.93,0,0,1-.89,1.5,1.13,1.13,0,0,0,0,1.41c.84,1.5,1.63,3,2.44,4.56A4.62,4.62,0,0,0,239,96l.13,0c.09-.7.2-1.4.27-2.1,0-.11-.14-.26-.26-.34-.36-.27-.74-.5-1.1-.76-.16-.1-.31-.22-.5-.36l.49-.83,1.24.82.07-.85c0-.24-.15-.34-.31-.45l-1.84-1.22.52-.77,1.82,1.07.13-1.39,1.26.2,0,1.25,1.63-.81.61.86-1.05.54-.83.42c-.75.38-.75.4-.55,1.31l1.22-.58.47.76-1.89,1,.07,2.59a2.22,2.22,0,0,0,.32-.34c1.07-1.64,2.13-3.29,3.21-4.92a.73.73,0,0,0,0-.94c-.32-.46-.58-1-.9-1.51l.78-.5,1,1.58.26-.3a.68.68,0,0,0,.08-.94c-.23-.36-.39-.75-.61-1.17l.79-.47.63,1.19,1-1.34.9.59-.95,1.43,1.14.13-.12.82a7.24,7.24,0,0,1-.95,0,.83.83,0,0,0-1.06.68c.52.32,1.17.27,1.76.55l-.14.86-2.38-.35-3.71,5.57a1.68,1.68,0,0,0,.41-.09c.47-.18.93-.39,1.41-.54a.67.67,0,0,0,.54-.71c0-.51.07-1,.12-1.61L245,94l.05,1.39L246,95l.16-2.7,1.17.12-.3,2,1.2-.61.69,1.13-1.3.64,1.74,1.25-.39.71-.42-.21c-.51-.31-1-.63-1.54-.93s-.63-.29-1.12.24l1,.89-.53.7c-.5-.33-1-.62-1.42-1a.7.7,0,0,0-.89,0c-.52.3-1.06.56-1.7.9.22,0,.32.09.41.1l5.8.46a.64.64,0,0,0,.67-.32c.36-.52.75-1,1.15-1.56l.88.58-.92,1.38L251,99l.8-1.2.88.59-.29.6c.38.22.83.15,1.27.33l-.07,1.16-1.49-.17.19.72-.52.29a1.53,1.53,0,0,1-.23-.33c-.23-.75-.82-.83-1.52-.81l.62,1.65-.7.29c-.29-.54-.57-1.06-.84-1.59a.52.52,0,0,0-.48-.34l-6-.56h-.29a3.81,3.81,0,0,0,.9.71c.33.23.66.59,1,.62s.74-.28,1.11-.44l.59-.26.53.93-1.07.53c.4.57.73.66,1.29.36l1.63-.9.39,1.05-1.49.85.89.69-.73,1.09-1-.58-.17,1.75-1.19.12c.08-.67.16-1.29.23-1.9s.19-.57-.51-1a2.44,2.44,0,0,0-.31-.14c0,.21,0,.38,0,.55s0,.31,0,.53l-1.13,0c0-.57,0-1.07.08-1.57a.58.58,0,0,0-.31-.62,12.54,12.54,0,0,0-1.61-.93,3.42,3.42,0,0,0,.13.34l2.75,5.32a.62.62,0,0,0,.64.39c.52,0,1,0,1.61.08l.1.78-1.7,0c.18.94.93.89,1.61,1l0,.74-.92,0,.71,1.36-1,.58-.81-1.17-.43.49-.77-.51.7-1.25-.39-.67-1,1.48-.85-.56c.29-.48.53-1,.86-1.43a1,1,0,0,0,.06-1.16c-.81-1.59-1.57-3.2-2.35-4.8a1.32,1.32,0,0,0-.37-.47l-.19,2.25,1.74,1.29-.43.82-1.27-.71c0,.23-.06.4-.09.56a.52.52,0,0,0,.27.58c.45.3.9.62,1.34.93l.54.41-.52.78-1.74-1.16-.13,1.39-1.28-.09V107.4l-1.73.9-.55-.82,2.48-1.32v-1.09Z" transform="translate(0 -66.54)"/></g><g class="cls-2"><path class="cls-1" d="M340.79,126.09l-1.2-.69c.46-.84.86-1.64,1.32-2.41a.92.92,0,0,0-.05-1.13,22.28,22.28,0,0,0-1.91-2.52c0,.24-.06.48-.06.72,0,3.07,0,6.15,0,9.22a1.14,1.14,0,0,0,.71,1.2c.89.42,1.75.91,2.67,1.4l-.49,1.44-2.83-1.11a4.91,4.91,0,0,0-.1,1.93c0,.18.29.39.5.5.7.36,1.42.69,2.2,1.07l-.81,1.14-1.85-.75-.15,1.62h-1.66l-.12-1.58-1.85.47-.43-1.25,2.34-.87v-2.16l-3.13,1-.57-1.2c1-.56,2-1.11,3-1.63a.94.94,0,0,0,.6-1c-.07-3.33-.12-6.66-.18-10a2.91,2.91,0,0,0-.11-.4,9.21,9.21,0,0,0-1.13,1.57c-.36.52-.7,1.07-1.08,1.65l1.55,3.1-1.31.62c-.23-.47-.42-.93-.67-1.36a.82.82,0,0,0-.55-.41.84.84,0,0,0-.55.41,1.21,1.21,0,0,0,0,1.5c.66,1,1.24,2.09,1.92,3.23l-1.62.82-1.54-2.73-1.16,1.74-1.83-1,1.17-1.81c-1.23-.22-2.41,0-3.61-.15v-1.51a5,5,0,0,1,.6-.1c1-.06,2-.16,3-.13a1.31,1.31,0,0,0,1.4-.89c.06-.14.13-.27.26-.54H329l-.11-1.44a4.32,4.32,0,0,1,1.72-.24,5.19,5.19,0,0,0,2.05-.25c.49-.31.69-1.11,1-1.7s.5-1,.84-1.61a6.4,6.4,0,0,0-.76.27c-2.73,1.49-5.44,3-8.18,4.46a1.08,1.08,0,0,0-.67,1c0,.83-.11,1.66-.18,2.49,0,.31-.08.61-.13,1l-1.62-.09v-2.82l-.74.28a.92.92,0,0,0-.68,1.11,11.31,11.31,0,0,1,0,1.44l-1.53.08-.17-1.36-2.17,1-.78-1.48,1.93-1.31-.8-.87.57-1c1,.41,1.93,1.06,3.06.17l-2.1-1.73.77-.95,3,1.57,9.78-5.18-.05-.23c-1.19,0-2.39-.07-3.59,0-.2,0-.45.32-.59.54-.46.73-.87,1.48-1.33,2.28l-1.56-1,1-1.73h-1.83l-1.71,3.67-1.62-1.2,1.44-2.47h-1.83a8.53,8.53,0,0,1-.19-2.53h2.23l-1.55-2.63,1.4-1.14.82,1.43c.21.36.41.73.61,1.09.7,1.25.7,1.25,2.29.92l-.94-1.53,1.36-.92c.44.67.89,1.28,1.25,1.94a1.22,1.22,0,0,0,1.31.71,30.1,30.1,0,0,0,3.38-.19,4.11,4.11,0,0,0-.51-.34c-2.95-1.54-5.91-3.07-8.85-4.63a1.19,1.19,0,0,0-1.32,0c-.79.46-1.62.86-2.49,1.32l-.69-1.22,2.23-1.38c-1-1.11-2.13-.91-3.29-.23l-.55-1,.86-.77-.93-.54-1-.57.9-1.46,2.3.93.09-1.28,1.28-.15c0,.56,0,1,.07,1.5.06,1.11.15,1.21,1.41,1.53V101.7l1.64.14a28.17,28.17,0,0,1,.15,2.87,1.87,1.87,0,0,0,1.23,2c2.54,1.29,5,2.69,7.53,4,.26.15.54.27.81.4l.17-.15c-.51-1-1-2.11-1.55-3.13-.09-.16-.43-.23-.66-.24-.74,0-1.48,0-2.21,0-.32,0-.63,0-1,0l-.08-1.6h2.45c-.29-.53-.48-.89-.68-1.24s-.53-.33-.85-.33h-3.63v-1.53l3.48-.19-1.09-2,1.91-.88,1.13,1.74c.52-.9,1-1.72,1.49-2.61l1.64.63-1,1.7-.75,1.34c-.68,1.2-.68,1.23.44,2.3l1.14-1.92,1.34.62-1.71,3.07,2.47,3.49a5,5,0,0,0,.13-.76c0-3.23-.09-6.47-.09-9.7a1.2,1.2,0,0,0-.83-1.31c-.86-.34-1.67-.79-2.62-1.25l.62-1.4,2.87,1.22c0-.29.06-.48.08-.66a1.12,1.12,0,0,0-.75-1.36c-.64-.28-1.22-.67-1.9-1l.65-1.37,2,1.07c.05-1,.1-1.87.14-2.77h1.79V93.6l1.67-.87.59,1.25a12.26,12.26,0,0,1-1.34.81,1.39,1.39,0,0,0-.84,1.9c1,0,1.87-.7,2.93-.86l.6,1.32-3.6,1.7V109.9a5.16,5.16,0,0,0,.48-.5c.49-.68.92-1.39,1.44-2a1.08,1.08,0,0,0,.09-1.46c-.47-.72-.85-1.49-1.31-2.33l1.28-.6,1.34,1.88.88-1.41c-.73-1.26-1.46-2.52-2.25-3.86l1.73-.9,1.43,3L345,99.79l2,.92-1.19,2.07,3.53.13.12,1.33c-.29,0-.53.08-.77.09-1,0-2,.08-3,.14s-1.13.17-1.31,1.36l2.21.28c0,.52-.05,1-.08,1.45-1,0-1.92,0-2.83,0a1.15,1.15,0,0,0-1.27.76c-.43.88-.94,1.73-1.51,2.79a6.29,6.29,0,0,0,.66-.24c2.8-1.56,5.59-3.13,8.39-4.67a1.07,1.07,0,0,0,.63-1.06c0-1.05.1-2.1.15-3.2h1.74v2.75l1.14-.43v-2.37h1.73l.16,1.08c.72,0,1.27-.54,2.05-.69l1,1.65-2.2,1.12.92.83-.45.87a2.36,2.36,0,0,1-.62-.25c-1-.81-1.88-.38-2.83.28l2.36,1.71-.69,1c-.89-.49-1.76-.94-2.61-1.43a.89.89,0,0,0-1,0c-2.92,1.59-5.86,3.16-8.79,4.74l-.41.25a6.48,6.48,0,0,0,1.87.16,4.32,4.32,0,0,0,2-.09c.52-.28.77-1.05,1.13-1.61l.58-.9,1.57.8-1,1.7c1.06.42,1.6.24,2.09-.69s.91-1.75,1.42-2.71l1.5,1.06-1.26,2.55,1.84.13v2.17l-1.87.09,1.38,2.56-1.54,1.25c-.5-1-.95-1.91-1.42-2.82s-.25-1-1.61-.89c-.15,0-.3,0-.55.09l.45.78c.13.22.27.43.47.75l-1.52,1.06c-.48-.8-.93-1.5-1.32-2.22a1,1,0,0,0-1-.57,21.5,21.5,0,0,0-3.07.18,5.25,5.25,0,0,0,.49.37c2.89,1.6,5.78,3.18,8.65,4.79a1,1,0,0,0,1.23,0c.71-.48,1.47-.89,2.28-1.38l.86,1-2.29,1.61c1.11,1.14,2.1.38,3.14-.09l.74,1-1.26.86,2.22,1.23-.82,1.7-2.19-.88-.12,1.07h-1.53c-.06-.78-.12-1.53-.19-2.36l-1.15-.55v2.93h-1.68c-.05-.91-.17-1.83-.13-2.74a1.62,1.62,0,0,0-1-1.65c-2.57-1.44-5.09-3-7.64-4.45a1.93,1.93,0,0,0-.93-.3l1.8,3.26,3.58.18.14,1.52-2.39.19c.16.35.29.6.39.85a.85.85,0,0,0,.91.55c.89,0,1.79,0,2.69,0,.35,0,.69,0,1.11.06v1.56h-3.44l1.1,2-1.86,1-1.23-1.82-1.55,2.83-1.51-.63,2.2-4.08-1-1.51Z" transform="translate(0 -66.54)"/></g><g class="cls-2"><path class="cls-1" d="M470.82,110.72l-.85-.24c.16-.59.28-1.14.45-1.68a.58.58,0,0,0-.21-.69,13.93,13.93,0,0,0-1.55-1.26,3.5,3.5,0,0,0,.07.45c.46,1.89.94,3.78,1.39,5.68a.72.72,0,0,0,.62.63c.61.12,1.21.29,1.85.45l-.08,1-1.91-.25a3.15,3.15,0,0,0,.24,1.21c0,.11.24.19.38.23.49.12,1,.21,1.52.32l-.32.82-1.26-.17.16,1-1,.26-.31-1-1.07.57-.46-.71,1.31-.89-.33-1.33-1.77,1.09-.54-.65c.55-.51,1.07-1,1.6-1.46a.61.61,0,0,0,.22-.69c-.55-2-1.09-4.08-1.64-6.12a1.28,1.28,0,0,0-.12-.23,5.84,5.84,0,0,0-.46,1.13c-.14.38-.27.77-.41,1.19l1.42,1.67-.71.58a9.13,9.13,0,0,0-.62-.73.52.52,0,0,0-.4-.17.58.58,0,0,0-.28.33.79.79,0,0,0,.23.93c.56.52,1.08,1.09,1.67,1.7l-.87.75L465.39,113l-.45,1.25-1.28-.32.45-1.29c-.79.06-1.48.38-2.24.46l-.23-.93A2.3,2.3,0,0,1,462,112c.6-.19,1.2-.4,1.81-.54a.83.83,0,0,0,.73-.76c0-.09,0-.19.08-.37l-1.5.37-.29-.87a2.88,2.88,0,0,1,1-.41c.42-.15.94-.18,1.22-.46s.26-.79.37-1.2l.27-1.12a4.07,4.07,0,0,0-.43.28c-1.45,1.33-2.89,2.67-4.35,4a.69.69,0,0,0-.26.74c.12.51.19,1,.27,1.56,0,.2,0,.39.07.63l-1,.19-.43-1.74-.42.29a.58.58,0,0,0-.24.78,8.71,8.71,0,0,1,.23.89l-.94.28-.31-.81-1.18.94-.71-.79,1-1.1-.63-.41.21-.68c.66.1,1.35.36,1.91-.37l-1.56-.74.33-.7,2.11.5q2.61-2.34,5.23-4.67l-.07-.14c-.74.17-1.49.32-2.22.52-.12,0-.23.26-.28.42-.17.51-.31,1-.47,1.6l-1.11-.36.33-1.21-1.13.28-.49,2.52-1.17-.5.51-1.74-1.14.28a6,6,0,0,1-.5-1.53l1.38-.34-1.36-1.38.69-.91.73.75.54.58c.62.66.62.66,1.55.22l-.82-.8.7-.78c.37.35.74.66,1.06,1a.79.79,0,0,0,.92.24,19.24,19.24,0,0,0,2-.64c-.12,0-.24-.1-.37-.13-2.05-.5-4.1-1-6.14-1.5a.76.76,0,0,0-.81.23c-.42.4-.87.78-1.33,1.19L455,103l1.16-1.19a1.5,1.5,0,0,0-2.05.36l-.5-.54L454,101l-.65-.19-.7-.2.33-1,1.56.22-.14-.8.76-.29c.11.35.19.63.28.92.2.67.28.72,1.1.72l-.47-1.89,1-.16a17.23,17.23,0,0,1,.53,1.74,1.19,1.19,0,0,0,1.06,1c1.76.41,3.5.89,5.25,1.34a5,5,0,0,0,.56.11l.08-.11c-.47-.57-.94-1.14-1.43-1.69-.08-.09-.3-.08-.45,0l-1.36.33-.63.12-.29-1,1.5-.38-.6-.66c-.17-.18-.38-.12-.57-.07l-2.24.55-.23-.94,2.11-.65-1-1.08,1-.84,1,.91.52-1.84,1.11.14c-.12.43-.23.81-.33,1.19s-.18.63-.26.94c-.24.85-.23.86.62,1.35l.41-1.35.92.17-.59,2.15,2.06,1.78a3.77,3.77,0,0,0,0-.49c-.51-2-1-4-1.54-6a.75.75,0,0,0-.71-.68c-.58-.08-1.15-.23-1.8-.37l.17-1,1.95.31c0-.19,0-.31-.05-.42a.73.73,0,0,0-.67-.73c-.43-.07-.85-.22-1.33-.35l.19-.94,1.37.36-.33-1.73,1.1-.27.43,1.74.9-.79.55.68a7.7,7.7,0,0,1-.7.7.88.88,0,0,0-.23,1.3c.62-.18,1-.71,1.67-1l.57.71-1.95,1.6,1.68,6.8a3.48,3.48,0,0,0,.22-.38c.19-.49.35-1,.58-1.48a.69.69,0,0,0-.17-.91c-.4-.37-.75-.79-1.17-1.23l.7-.57,1.11,1,.33-1-2-2,.92-.81L469,95.25l.38-1.36,1.35.27-.42,1.45,2.2-.45.27.79a3.93,3.93,0,0,1-.46.18c-.6.18-1.21.35-1.81.54s-.66.27-.6,1l1.41-.17.17.9c-.61.16-1.17.32-1.75.43a.73.73,0,0,0-.66.65c-.13.62-.31,1.22-.51,2a2.72,2.72,0,0,0,.37-.25c1.49-1.38,3-2.78,4.46-4.15a.66.66,0,0,0,.22-.74c-.15-.65-.26-1.31-.39-2l1.07-.26.41,1.69.64-.44L475,93.86l1.07-.26.26.64c.44-.13.7-.53,1.16-.74l.84.87-1.19,1,.69.37-.13.6a1.78,1.78,0,0,1-.43-.06c-.74-.35-1.21,0-1.7.6l1.72.69-.27.75c-.62-.16-1.23-.31-1.82-.48a.56.56,0,0,0-.61.14l-4.68,4.26-.22.21a3.83,3.83,0,0,0,1.18-.19,2.77,2.77,0,0,0,1.2-.35c.27-.26.31-.77.45-1.17.07-.19.13-.38.22-.64l1.09.25-.35,1.2c.72.09,1-.1,1.18-.74s.3-1.22.46-1.89l1.09.43-.39,1.75,1.15-.19.33,1.33-1.13.34,1.24,1.37-.76,1-1.3-1.52c-.47-.53-.31-.55-1.13-.3l-.32.14.39.41.4.39-.77.89c-.42-.42-.8-.78-1.15-1.17a.62.62,0,0,0-.7-.2,13.27,13.27,0,0,0-1.86.58,2.28,2.28,0,0,0,.36.15l6.05,1.63a.65.65,0,0,0,.75-.21c.37-.4.77-.77,1.19-1.19l.68.48-1.16,1.34c.85.53,1.35-.09,1.92-.53l.6.49-.64.72,1.56.42-.25,1.17-1.48-.21.09.68-.95.24-.47-1.43-.8-.17.45,1.81-1,.26c-.17-.56-.38-1.1-.5-1.67a1,1,0,0,0-.85-.87c-1.8-.49-3.58-1-5.38-1.57a1.13,1.13,0,0,0-.62,0l1.61,1.74,2.23-.44.32.92-1.44.48.37.46a.53.53,0,0,0,.64.2c.55-.14,1.1-.26,1.66-.38l.7-.13.23,1L474,110l1,1.08-1,.93-1-.94-.52,2-1-.16.74-2.85-.84-.78Z" transform="translate(0 -66.54)"/></g></g></svg>';
		break;
		case 'butterfly' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 87" preserveAspectRatio="none"><defs><style>.cls-1{opacity:0.5;}</style></defs><g id="Layer_2" data-name="Layer 2"><polygon class="cls-1" points="500 69 500 0 250 31 0 0 0 69 500 69"/></g><g id="Layer_1" data-name="Layer 1"><polygon class="cls-2" points="500 69 500 87 0 87 0 69 250 31 500 69"/></g></svg>';
		break;
		case 'animated_waves' :
			var svgpath = '<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1417 794"><g transform="translate(708.5,397) scale(1,1) translate(-708.5,-397)"><linearGradient id="lg-0.47933337739525805" x1="0" x2="1" y1="0" y2="0"><stop stop-color="#ff00ff" offset="0"></stop><stop stop-color="#00ffff" offset="1"></stop></linearGradient><path d="" fill="url(#lg-0.47933337739525805)" opacity="0.4"><animate attributeName="d" dur="16.666666666666664s" repeatCount="indefinite" keyTimes="0;0.333;0.667;1" calcmod="spline" keySplines="0.2 0 0.2 1;0.2 0 0.2 1;0.2 0 0.2 1" begin="0s" values="M0 0L 0 324.5015185187671Q 177.125 298.8138829521863  354.25 260.63120664633277T 708.5 421.84239744185305T 1062.75 299.5855871657385T 1417 235.48542325129495L 1417 0 Z;M0 0L 0 556.0570965244332Q 177.125 579.7599181261096  354.25 548.8915090487861T 708.5 395.7607383039141T 1062.75 443.3170210284975T 1417 256.3449578716147L 1417 0 Z;M0 0L 0 334.3647287988679Q 177.125 481.3057865872413  354.25 454.2751592079807T 708.5 222.1385345469165T 1062.75 311.5931733565468T 1417 207.7608312901822L 1417 0 Z;M0 0L 0 324.5015185187671Q 177.125 298.8138829521863  354.25 260.63120664633277T 708.5 421.84239744185305T 1062.75 299.5855871657385T 1417 235.48542325129495L 1417 0 Z"></animate></path><path d="" fill="url(#lg-0.47933337739525805)" opacity="0.4"><animate attributeName="d" dur="16.666666666666664s" repeatCount="indefinite" keyTimes="0;0.333;0.667;1" calcmod="spline" keySplines="0.2 0 0.2 1;0.2 0 0.2 1;0.2 0 0.2 1" begin="-5.5555555555555545s" values="M0 0L 0 367.984770106225Q 177.125 324.01361362793216  354.25 306.28929020884766T 708.5 261.4361931670915T 1062.75 281.9991979465649T 1417 330.4049835349433L 1417 0 Z;M0 0L 0 509.4734329285319Q 177.125 540.4994363377859  354.25 517.4158015508332T 708.5 208.80779803904636T 1062.75 403.9369293490124T 1417 230.0060597212573L 1417 0 Z;M0 0L 0 457.76392017006003Q 177.125 542.0993611405761  354.25 524.1995210781041T 708.5 462.4877002854464T 1062.75 375.4312262098515T 1417 120.38246779772896L 1417 0 Z;M0 0L 0 367.984770106225Q 177.125 324.01361362793216  354.25 306.28929020884766T 708.5 261.4361931670915T 1062.75 281.9991979465649T 1417 330.4049835349433L 1417 0 Z"></animate></path><path d="" fill="url(#lg-0.47933337739525805)" opacity="0.4"><animate attributeName="d" dur="16.666666666666664s" repeatCount="indefinite" keyTimes="0;0.333;0.667;1" calcmod="spline" keySplines="0.2 0 0.2 1;0.2 0 0.2 1;0.2 0 0.2 1" begin="-11.111111111111109s" values="M0 0L 0 445.3038054314494Q 177.125 534.232193249191  354.25 485.43500150394334T 708.5 276.5172429814809T 1062.75 323.75793608780236T 1417 207.78966179439004L 1417 0 Z;M0 0L 0 604.6134986658767Q 177.125 588.8800511232508  354.25 558.8422971616096T 708.5 237.8922322513478T 1062.75 377.97839431525256T 1417 175.7858492654541L 1417 0 Z;M0 0L 0 617.8357128464033Q 177.125 457.79207391362837  354.25 431.84403152530945T 708.5 314.67826764223526T 1062.75 410.99068403607623T 1417 277.9132981120613L 1417 0 Z;M0 0L 0 445.3038054314494Q 177.125 534.232193249191  354.25 485.43500150394334T 708.5 276.5172429814809T 1062.75 323.75793608780236T 1417 207.78966179439004L 1417 0 Z"></animate></path></g></svg>';
		break;
		
		case '0' :
		default :
			if (prefix == 'divider') focus.find('.tck-divider1-container').remove();
			if (prefix == 'divider-2') focus.find('.tck-divider2-container').remove();
			return;
		break;
	}

	// remove all divider for B/C
	focus.find('.tck-divider-container:not(.tck-divider2-container):not(.tck-divider1-container)').remove();

	if (prefix == 'divider') {
		focus.find('.tck-divider1-container').remove();

		if (! focus.find('.tck-divider1-container').length) focus.prepend('<div class="tck-divider-container tck-divider1-container">' + svgpath + '</div>');

		var divider = focus.find('.tck-divider1-container');
	} else if (prefix == 'divider-2') {
		focus.find('.tck-divider2-container').remove();

		if ($ck('#divider-2shape').val()) {
			if (! focus.find('.tck-divider2-container').length) focus.prepend('<div class="tck-divider-container tck-divider2-container">' + svgpath + '</div>');
		} else {
			return;
		}
		var divider = focus.find('.tck-divider2-container');
	}

	// position
	var position = $ck('#' + prefix + 'position').val();
	if (position == 'top') {
		divider.removeClass('tck-divider-bottom').addClass('tck-divider-top');
	} else {
		divider.removeClass('tck-divider-top').addClass('tck-divider-bottom');
	}
	// placement
	if ($ck('#' + prefix + 'placement').val() == 'over') {
		divider.removeClass('tck-divider-under').addClass('tck-divider-over');
	} else {
		divider.removeClass('tck-divider-over').addClass('tck-divider-under');
	}

	// flip
	// if ($ck('#' + prefix + 'fliphorizontal').val() == '1') {
	if ($ck('[name="' + prefix + 'fliphorizontal"]:checked').val() == '1') {
		divider.addClass('ckflip-horizontal');
	} else {
		divider.removeClass('ckflip-horizontal');
	}

	// if ($ck('#' + prefix + 'flipvertical').val() == '1') {
	if ($ck('[name="' + prefix + 'flipvertical"]:checked').val() == '1') {
		divider.addClass('ckflip-vertical');
	} else {
		divider.removeClass('ckflip-vertical');
	}

//	divider.find('path, polygon, polyline, rect, circle').attr('fill', $ck('#' + prefix + 'color').val());
//	divider.css('background-color', $ck('#' + prefix + 'bgcolor').val());
	// fix for new version, remove old inline styles
	divider.find('path, polygon').attr('fill', '');
	divider.css('background-color', '');

	divider.find('svg').css('height', ckTestUnit($ck('#' + prefix + 'height').val()));
	divider.find('svg').css('width', ckTestUnit($ck('#' + prefix + 'width').val(), '%'));
	var widthVal = parseInt(ckTestUnit($ck('#' + prefix + 'width').val(), '%'));
	var offsetHRange = (widthVal - 100) / 2;
	var offsetVal = parseInt($ck('#' + prefix + 'offseth').val());
	divider.find('svg').css('margin-left', (offsetVal * offsetHRange / 100) + '%');
	if (position == 'top') {
		divider.css('margin-top', ckTestUnit($ck('#' + prefix + 'offsetv').val()));
	} else {
		divider.css('margin-bottom', ckTestUnit($ck('#' + prefix + 'offsetv').val()));
	}
		// divider.find('svg').css('width', ckTestUnit($ck('#' + prefix + 'width').val()));
		// divider.find('svg').css('max-width', ckTestUnit($ck('#' + prefix + 'width').val()));
}

function ckShowAddblockmanagerPanel() {
	ckCloseEdition();
	$ck('#tab_interface_addons .ckinterfacesliderparent').css('margin-left', '0');
	$ck('#tab_interface_addons').css('display', 'block').animate({'left': '0px', 'opacity': '1'}, 200);
	$ck('#ckaddblockmanager').css('display', 'block');
}

function ckCloseAddblockmanagerPanel() {
	$ck('#tab_interface_addons').animate(
		{'left': '150px', 'opacity': '0'}, 300,
		function() {
			$ck('#tab_interface_addons').css('display', 'none');
			}
		);
	if ($ck('#ckleftpanel').attr('data-reduced') == 'true') $ck('#ckleftpanel').addClass('reduced').removeAttr('data-reduced');
}



/*------------------------------
 *		Responsive styles
 -------------------------------*/

/* function used for the row and columns, show a small edition with margins, paddings */
function ckShowResponsiveCssEdition(blocid) {
	blocid = '#' + blocid;
	bloc = $ck(blocid);
	$ck('.editfocus').removeClass('editfocus');
	bloc.addClass('editfocus');
	var focus = $ck('.editfocus');
	$ck('#popup_editionck').empty().fadeIn().addClass('ckwait');
	var range = ckGetResponsiveRange();

	var ckprops = $ck('> .tab_blocstyles', focus);
	var fields = new Object();
	fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
	for (j=0;j<fieldslist.length;j++) {
		fieldname = fieldslist[j];
		fields[fieldname] = ckprops.attr(fieldname);

	}
	fields = JSON.stringify(fields);

	var myurl = PAGEBUILDERCK.URIPBCK + "&task=interface.load&layout=responsivecssedition&" + PAGEBUILDERCK.TOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			ckobjid: bloc.prop('id'),
			fields: fields,
			responsiverange: range
		}
	}).done(function(code) {
		$ck('#popup_editionck').append(code).removeClass('ckwait');
		$ck('#ckwaitoverlay').remove();
		ckFillEditionPopup(blocid, $ck('.workspaceck'), range);
		ckAddEventOnResponsiveFields($ck('#popup_editionck'), blocid);
		ckMakeTooltip($ck('#popup_editionck'));
	}).fail(function() {
		alert(Joomla.JText._('CK_FAILED', 'Failed'));
	});
}

function ckAddEventOnResponsiveFields(editionarea, blocid) {
	$ck('.inputbox:not(.colorPicker):not(.cknoupdate)', editionarea).change(function() {
		ckRenderResponsiveCss();
	});
	$ck('.colorPicker,.inputbox[type=radio]', editionarea).blur(function() {
		ckRenderResponsiveCss();
	});
}

function ckRenderResponsiveCss() {
	ckAddSpinnerIcon($ck('.headerckicon.cksave'));
	var editionarea = document.body;
	var focus = $ck('.editfocus');
	var blocid = focus.attr('id');
	var fieldslist = new Array();
	var fields = new Object();
	var rangeNumber = ckGetResponsiveRangeNumber();
	$ck('.inputbox', editionarea).each(function(i, el) {
		el = $ck(el);
		fields[el.attr('name')] = el.val();
		if (el.attr('type') == 'radio') {
			fields[el.attr('name')] = $ck('[name="' + el.attr('name') + '"]:checked').val();
			if (el.prop('checked')) {
				fields[el.attr('id')] = 'checked';
			} else {
				fields[el.attr('id')] = '';
			}
		}
	});

	$ck('> .ckprops.ckresponsiverange' + rangeNumber, focus).each(function(i, ckprops) {
		ckprops = $ck(ckprops);
		fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
		// fieldslist.each(function(fieldname) {
		// for (var fieldname of fieldslist) {
		for (j=0;j<fieldslist.length;j++) {
			fieldname = fieldslist[j];
			if (typeof(fields[fieldname]) == 'null') 
				fields[fieldname] = ckprops.attr(fieldname);
		// });
		}
	});
	fields = JSON.stringify(fields);
	var customstyles = new Object();
	$ck('.menustylescustom').each(function() {
		$this = $ck(this);
		customstyles[$this.attr('data-prefix')] = $this.attr('data-rule');
	});
	customstyles = JSON.stringify(customstyles);
	ckSaveResponsiveEdition(); // save fields before ajax to keep sequential/logical steps
	var myurl = PAGEBUILDERCK.URIPBCK + "&task=interface.load&layout=renderresponsivecss&" + PAGEBUILDERCK.TOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			objclass: focus.prop('class'),
			ckobjid: blocid,
			responsiverange: rangeNumber,
			customstyles: customstyles,
			fields: fields
		}
	}).done(function(code) {
		if (! $ck('> .ckstyleresponsive.ckresponsiverange' + rangeNumber, $ck('.workspaceck #' + blocid)).length) {
			$ck('.workspaceck #' + blocid).append('<div class="ckstyleresponsive ckresponsiverange' + rangeNumber + '"></div>')
		}
		$ck('> .ckstyleresponsive.ckresponsiverange' + rangeNumber, $ck('.workspaceck #' + blocid)).empty().append(code);
		ckOrderStylesResponsive(blocid);
		ckRemoveSpinnerIcon($ck('.headerckicon.cksave'));
		ckSaveAction();
	}).fail(function() {
		alert(Joomla.JText._('CK_FAILED', 'Failed'));
	});
}

function ckOrderStylesResponsive(blocid) {
	for (var i = 4; i > 0; i--) {
		$ck('.workspaceck #' + blocid).append($ck('.ckstyleresponsive.ckresponsiverange' + i, $ck('.workspaceck #' + blocid)));
	}
}

function ckSaveResponsiveEdition() {
	var focus = $ck('.editfocus');
	var rangeNumber = ckGetResponsiveRangeNumber();
	var editionarea = $ck('#popup_editionck');
	$ck('> .ckprops.ckresponsiverange' + rangeNumber, focus).remove();
	$ck('.ckproperty', editionarea).each(function(i, tab) {
		tab = $ck(tab);
		tabid = tab.attr('id');
		(! $ck('> .' + tabid + '_ckresponsiverange' + rangeNumber, focus).length) ? focus.prepend('<div class="' + tabid + '_ckresponsiverange' + rangeNumber + ' ckprops ckresponsive ckresponsive' + rangeNumber + '" />') : $ck('> .' + tabid + '_ckresponsiverange' + rangeNumber, focus).empty();
		focusprop = $ck('> .' + tabid + '_ckresponsiverange' + rangeNumber, focus);
		ckSavePopupfields(focusprop, tabid);
		fieldslist = ckGetPopupFieldslist(focus, tabid);
		focusprop.attr('fieldslist', fieldslist);
	});
}

function ckGetResponsiveRangeNumber() {
	var range = ckGetResponsiveRange();
	var rangeNumber = range.charAt(range.length-1);
	return rangeNumber;
}

function ckGetResponsiveRangeAttrib(responsiverange) {
	var responsiverangeattrib = responsiverange ? '-' +responsiverange : '';
	return responsiverangeattrib;
}

function ckGetResponsiveCssByResolution(rangeNumber) {
	var css = '';
	var i = 0;
	var selector = rangeNumber && rangeNumber !== '5' ? '.ckstyleresponsive.ckresponsiverange' + rangeNumber : '> .ckstyle';
	$ck('.ckbloc, .ckrowcontainer').each(function(j, bloc) {
		bloc = $ck(bloc);
		var blocid = bloc.attr('id') ? bloc.attr('id') : bloc.attr('data-id');
		if (bloc.attr('isdisabled') != 'true' && blocid) {
			var styleswrapper = ckGetStylesWrapperForBlock(blocid);
			if (styleswrapper.find(selector).length) {
//				styleswrapper.append('<div class="' + responsiveClass + '"></div>');
//				return styleswrapper.find(selector);
				var ckstyle = styleswrapper.find(selector + ' style').html();
				ckstyle = ckstyle.replace(/#/g, "|di|");
				css += ckstyle;
				i++;
			}
		}
	});

	return css;
}


function ckExportCustomStyle() {
//	if (!confirm(TCK.Text._('CK_CONFIRM_DELETE','Are you sure that you want to delete ?'))) return;
	var btn = $ck('#ckcustomstylesbuttons .ckfocus');
	var customstyleid = btn.attr('id');
	var styleswrapper = ckGetStylesWrapperForBlock(btn.attr('id'));
	var dataname = styleswrapper.attr('data-name');
	var datacssselector = styleswrapper.attr('data-cssselector');
	var re = new RegExp(customstyleid, 'g');
	var exportdata = styleswrapper[0].outerHTML.replace(re, '|ID|');

	// $ck('#ckstylescontainer .ckstylecontainer[data-id^="ckcustomstyle"]')
	// location.href works but need the PHP method
	//	location.href = 'http://joomla5dev/administrator/index.php?option=com_templateck&task=template.download';
	// js method works for html5 browsers
	ckDownload(customstyleid, exportdata);
}

function ckImportCustomStylesFields() {
	$ck('#ckimportcustomstyleform').show();
}

async function ckReadCustomStyleFile(event) {
	$ck('#ckimportcustomstyleform').show();
	const file = event.target.files.item(0)
	const text = await file.text();

	var blocid = ckCreateNewCustomStylesFields('', '', true);
//	var re = new RegExp('\|ID\|', '');
	var importdata = text.replace(/\|ID\|/g, blocid);
	var tempdata = $ck(importdata);
	var dataname = tempdata.attr('data-name') ? tempdata.attr('data-name') : '';
	var datacssselector = tempdata.attr('data-cssselector') ? tempdata.attr('data-cssselector') : '';
	var btn = $ck('#ckcustomstylesbuttons').find('#' + blocid + '.ckbutton');
	btn.text(dataname).attr('data-rule', '.' + datacssselector);
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);

	styleswrapper.html(tempdata.html());
	if (dataname) styleswrapper.attr('data-name', dataname);
	if (datacssselector) styleswrapper.attr('data-cssselector', datacssselector);
}

function ckDownload(filename, text) {
	var element = document.createElement('a');
	element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
	element.setAttribute('download', filename);

	element.style.display = 'none';
	document.body.appendChild(element);

	element.click();

	document.body.removeChild(element);
}

function ckShowVariations() {
	var target = $ck('.menuckpaneltarget[data-target="variations"]');

	// if content already loaded, exit
	if (target.attr('data-loaded') == '1') {
//		ckSwitchResponsive('5', true);
		return;
	}

	// get blocks
	blocs = ckGetBlocks();
	blocs = JSON.stringify(blocs);
	blocs = blocs.replace(/#/g, "|di|");
	bloc = $ck('#body');

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxvariations&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			blocs: blocs,
//			htmlcode_responsive: $ck('#htmlcode_responsive').val(),
//			templateid: TEMPLATEID
		}
	}).done(function(code) {
		target.find('> .inner').empty().append(code);
		ckFillEdition('body');
//		ckSwitchVariation('0', true);
		target.attr('data-loaded', '1');
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
		$ck('#ckwaitoverlay').remove();
	});
}
/*
function ckSwitchVariation(variation, force) {
//	var responsiverange = ckGetResponsiveRange();
	if (! force) force = false;
//	var resolution = parseFloat($ck('#ckresponsive' + responsiverange + 'value').val());
	var button = $ck('#ckvariation' + variation + 'button');

	// do nothing if click on the active button
	if (button.hasClass('active')) return;
	if (button.hasClass('active') && !force) {
		ckRemoveWorkspaceVariation();
	} else {
		$ck('#cktoolbarResponsive .ckbutton').removeClass('active').removeClass('ckbutton-warning');
		button.addClass('active').addClass('ckbutton-warning');
		ckSetWorkspaceVariation(variation);
	}

	$ck('.ckbloc, .ckrowcontainer', $ck('#body')).each(function(i, bloc) {
		ckAddEdition(bloc);
		$ck('> .editorck .isControlResponsive', $ck(bloc)).removeClass('active');
		var mobilevalue = $ck(bloc).attr('ckvariation' + variation) ? $ck(bloc).attr('ckvariation' + responsiverange) : 'mobile_default';
		$ck('> .editorck .isControlResponsive[data-mobile="' + mobilevalue + '"]', $ck(bloc)).addClass('active');
	});
}*/

function ckSwitchVariation(variation, force) {
//	var responsiverange = ckGetResponsiveRange();
	if (! force) force = false;
//	var resolution = parseFloat($ck('#ckresponsive' + responsiverange + 'value').val());
	var button = $ck('#ckvariation' + variation + 'button');

	// do nothing if click on the active button
	if (button.hasClass('active') && !force) {
		ckRemoveWorkspaceVariation();
//		button.removeClass('active').removeClass('ckbutton-warning');
//		$ck('.ckbloc, .ckrowcontainer', $ck('#body')).each(function(i, bloc) {
//			ckRemoveEdition(bloc);
//		});

		return;
	} else {
		$ck('#cktoolbarVariation .ckbutton').removeClass('active').removeClass('ckbutton-warning');
		button.addClass('active').addClass('ckbutton-warning');
		ckSetWorkspaceVariation(variation);
		ckAddVariationBanner(button);
		
		$ck('.ckbloc, .ckrowcontainer', $ck('#body')).each(function(i, bloc) {
			ckAddEdition(bloc);
			$ck('> .editorck .isControlResponsive', $ck(bloc)).removeClass('active');
			var mobilevalue = $ck(bloc).attr('ckvariation' + variation) ? $ck(bloc).attr('ckvariation' + variation) : 'mobile_default';
			$ck('> .editorck .isControlResponsive[data-mobile="' + mobilevalue + '"]', $ck(bloc)).addClass('active');
		});
	}

	
}

function ckSetWorkspaceVariation(range) {
	var workspace = $ck('#body');
	workspace.attr('ckvariationrange', range).addClass('ckvariationactive');
	$ck('#menuck').attr('ckvariationrange', range).addClass('ckvariationactive');
}

function ckRemoveWorkspaceVariation() {
	$ck('.menuckpaneltarget[data-target="variations"] .ckbutton').removeClass('active').removeClass('ckbutton-warning');
	var workspace = $ck('#body');
	workspace.attr('ckvariationrange', '').removeClass('ckvariationactive');
	$ck('#menuck').attr('ckvariationrange', '').removeClass('ckvariationactive');
	$ck('#ckvariation-banner').remove();
}

function ckGetVariationRangeNumber() {
	var range = ckGetVariationRange();
	var rangeNumber = range.charAt(range.length-1);
	return rangeNumber;
}

function ckGetVariationRange() {
	var range = $ck('#body').attr('ckvariationrange') ? $ck('#body').attr('ckvariationrange') : '0';
	return range;
}

function ckGetvariationCssByNumber(rangeNumber) {
	var css = '';
	var i = 0;
	var selector = rangeNumber && rangeNumber !== '5' ? '.ckstylevariation.ckvariationrange' + rangeNumber : '> .ckstyle';
	$ck('.ckbloc, .ckrowcontainer').each(function(j, bloc) {
		bloc = $ck(bloc);
		var blocid = bloc.attr('id') ? bloc.attr('id') : bloc.attr('data-id');
		if (bloc.attr('isdisabled') != 'true' && blocid) {
			var styleswrapper = ckGetStylesWrapperForBlock(blocid);
			if (styleswrapper.find(selector).length) {
//				styleswrapper.append('<div class="' + variationClass + '"></div>');
//				return styleswrapper.find(selector);
				var ckstyle = styleswrapper.find(selector + ' style').html();
				ckstyle = ckstyle.replace(/#/g, "|di|");
				css += ckstyle;
				i++;
			}
		}
	});
	['ckcustomlayoutblog', 'ckcustomlayoutarticle', 'ckcustomlayoutsearch'].forEach(function(blocid) {
		var styleswrapper = ckGetStylesWrapperForBlock(blocid);console.log(styleswrapper);
		if (styleswrapper.find(selector).length) {
//				styleswrapper.append('<div class="' + variationClass + '"></div>');
//				return styleswrapper.find(selector);
			var ckstyle = styleswrapper.find(selector + ' style').html();
			ckstyle = ckstyle.replace(/#/g, "|di|");
			css += ckstyle;
			i++;
		}
	});

	return css;
}

function ckAddVariationBanner(button) {
	var range = button.attr('data-range');
	var rangeText = button.text();
	$ck(document.body).append('<div id="ckvariation-banner"><div>' + rangeText + '</div><div class="ckvariation-banner-close" onclick="ckRemoveWorkspaceVariation()">×</div></div>');
}

function ckClearStylesFromPanel() {
	if (!confirm(TCK.Text._('CK_CONFIRM_CLEAR_STYLES','CK_CONFIRM_CLEAR_STYLES'))) return;
	$ck('#ckedition .ckinterfaceslider[data-id$="styles"] input').val('');
	ckRenderCss();
}